/*
    gnome_project.c
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <sys/wait.h>

#include <gnome.h>

#include "support.h"
#include "appwidzard.h"
#include "anjuta.h"
#include "preferences.h"
#include "launcher.h"
#include "messages.h"
#include "gnome_project.h"

static void new_prj_mesg_arrived (gchar * mesg);
static void new_prj_terminated (int status, time_t t);

void
create_new_project (AppWidzard * aw)
{
  int pid, status;
  gchar *cmd_str, *top_dir, *prj_file, *mesg;
  gchar *icon_file, *need_terminal, *use_header, *file_header;

  top_dir =
    g_strdup_printf ("%s/%s-%s", app->preferences->all_projects_dir,
		     aw->prj_name, aw->version);
  if (chdir (top_dir) == 0 && aw->type != blank)
  {
    anjuta_error (_
		  ("Error: The Project directory already exist.\nProject creation aborted."));
    return;
  }

  if (chdir (app->preferences->all_projects_dir) != 0)
    mkdir (app->preferences->all_projects_dir, 0755);
  mkdir (top_dir, 0755);
  chdir (top_dir);

  prj_file = g_strdup_printf ("%s/%s.prj", top_dir, aw->prj_name);
  if (file_is_regular (prj_file))
  {
    gchar *msg;
    GtkWidget *dlg;
    gint ret;
    
    msg = g_strdup_printf(_
		  ("The Project File \"%s\" already exist."
		  "\nThis will overwrite the file."
		  "\nDo you still want to continue?"), prj_file);
    dlg = gnome_question_dialog_modal (msg, NULL, NULL);
    g_free(msg);
    ret = gnome_dialog_run_and_close  (GNOME_DIALOG(dlg));
    if (ret != 0)
      return;
  }

  gtk_file_selection_set_filename (GTK_FILE_SELECTION
				   (app->project_dbase->fileselection_open),
				   prj_file);
  g_free (prj_file);

  messages_clear (app->messages, MESSAGE_BUILD);
  messages_append (app->messages,
		   _("Creating  project from templete ............. Done\n"),
		   MESSAGE_BUILD);
  messages_show (app->messages, MESSAGE_BUILD);

  switch (aw->language)
  {
  case c:
    if (aw->gettext_support == TRUE)
      switch (aw->type)
      {
      case blank:
	cmd_str = g_strdup_printf ("tar -xzf %s/bprj-c.tar.gz",
				   app->dirs->templetes);
	break;
      case console:
	cmd_str = g_strdup_printf ("tar -xzf %s/cprj-c-gt.tar.gz",
				   app->dirs->templetes);
	break;
      case gnome_blank:
	cmd_str = g_strdup_printf ("tar -xzf %s/gprj-blank-c-gt.tar.gz",
				   app->dirs->templetes);
	break;
      case gnome_full:
	cmd_str = g_strdup_printf ("tar -xzf %s/gprj-full-c-gt.tar.gz",
				   app->dirs->templetes);
	break;
      default:
	/* This should not reach */
	g_warning (_
		   ("Unrecognized case statement in create_new_project().\n"));
	g_free (top_dir);
	return;
      }
    else
      switch (aw->type)
      {
      case blank:
	cmd_str = g_strdup_printf ("tar -xzf %s/bprj-c.tar.gz",
				   app->dirs->templetes);
	break;
      case console:
	cmd_str = g_strdup_printf ("tar -xzf %s/cprj-c.tar.gz",
				   app->dirs->templetes);
	break;
      case gnome_blank:
	cmd_str = g_strdup_printf ("tar -xzf %s/gprj-blank-c.tar.gz",
				   app->dirs->templetes);
	break;
      case gnome_full:
	cmd_str = g_strdup_printf ("tar -xzf %s/gprj-full-c.tar.gz",
				   app->dirs->templetes);
	break;
      default:
	/* This should not reach */
	g_warning (_
		   ("Unrecognized case statement in create_new_project().\n"));
	g_free (top_dir);
	return;
      }
    break;
  case cpp:
    if (aw->gettext_support == TRUE)
      switch (aw->type)
      {
      case blank:
	cmd_str = g_strdup_printf ("tar -xzf %s/bprj-cpp.tar.gz",
				   app->dirs->templetes);
	break;
      case console:
	cmd_str = g_strdup_printf ("tar -xzf %s/cprj-cpp-gt.tar.gz",
				   app->dirs->templetes);
	break;
      case gnome_blank:
	cmd_str = g_strdup_printf ("tar -xzf %s/gprj-blank-cpp-gt.tar.gz",
				   app->dirs->templetes);
	break;
      case gnome_full:
	cmd_str = g_strdup_printf ("tar -xzf %s/gprj-full-cpp-gt.tar.gz",
				   app->dirs->templetes);
	break;
      default:
	/* This should not reach */
	g_warning (_
		   ("Unrecognized case statement in create_new_project function.\n"));
	g_free (top_dir);
	return;
      }
    else
      switch (aw->type)
      {
      case blank:
	cmd_str = g_strdup_printf ("tar -xzf %s/bprj-cpp.tar.gz",
				   app->dirs->templetes);
	break;
      case console:
	cmd_str = g_strdup_printf ("tar -xzf %s/cprj-cpp.tar.gz",
				   app->dirs->templetes);
	break;
      case gnome_blank:
	cmd_str = g_strdup_printf ("tar -xzf %s/gprj-blank-cpp.tar.gz",
				   app->dirs->templetes);
	break;
      case gnome_full:
	cmd_str = g_strdup_printf ("tar -xzf %s/gprj-full-cpp.tar.gz",
				   app->dirs->templetes);
	break;
      default:
	/* This should not reach */
	g_warning (_
		   ("Unrecognized case statement in create_new_project().\n"));
	g_free (top_dir);
	return;
      }
    break;
  default:
    /* This should not reach */
    g_warning (_("Unrecognized case statement in create_new_project().\n"));
    g_free (top_dir);
    return;
  }
  if ((pid = fork ()) == 0)
  {
    execlp (app->preferences->commands.shell,
	    app->preferences->commands.shell, "-c", cmd_str, NULL);
    g_error (_("Cannot execute command shell"));
  }
  waitpid (pid, &status, 0);

  if (WEXITSTATUS (status))
  {
    mesg =
      g_strdup_printf (_
		       ("Error: There was an error executing the command:\n"
			"   %s.\n"
			"It seems you do not have the required project templete ( *.tar.gz files).\n"
			"Make sure you have installed Anjuta properly."), cmd_str);
    anjuta_error (mesg);
    g_free (mesg);
    g_free (cmd_str);
    chdir ("..");
    cmd_str = g_strconcat ("rm -r -f ", top_dir, NULL);
    if ((pid = fork ()) == 0)
    {
      execlp (app->preferences->commands.shell,
	      app->preferences->commands.shell, "-c", cmd_str, NULL);
      g_error (_("Cannot execute command shell"));
    }
    anjuta_register_child_process (pid, NULL, NULL);
    g_free (top_dir);
    g_free (cmd_str);
    messages_append (app->messages,
		     _
		     ("\nERROR: Unable to Create the Project templete ... Aborted\n"),
		     MESSAGE_BUILD);
    return;
  }

  messages_append (app->messages,
		   _("Initializing the Project templete .............. Done\n"),
		   MESSAGE_BUILD);
  g_free (cmd_str);
  chdir (top_dir);

  if(aw->icon_file == NULL) icon_file = g_strdup(" ");
  else icon_file = g_strdup(extract_filename(aw->icon_file));
  if(aw->need_terminal == TRUE) need_terminal = g_strdup("true");
  else need_terminal = g_strdup("false");
  if(aw->use_header)
  {
    use_header = g_strdup("true");
    file_header = g_strconcat(app->dirs->data, "/header.c", NULL);
  }
  else
  {
    use_header = g_strdup("false");
    file_header = g_strdup(" ");
  }

  cmd_str =
    g_strdup_printf
    ("./project.init \"--project-name=%s\" \"--version=%s\" \"--author=%s\" "
     "\"--program-name=%s\" \"--srcdir=%s\" \"--pixdir=%s\" \"--docdir=%s\" "
     "\"--menu-entry=%s\" \"--menu-comment=%s\" \"--need-terminal=%s\" "
     "\"--icon-file=%s\" \"--app-group=%s\" \"--use-header=%s\" \"--file-header=%s\" ",
     aw->prj_name, aw->version, aw->author, aw->prog_name, aw->src_dir_name,
     aw->pix_dir_name, aw->doc_dir_name, aw->menu_entry, aw->menu_comment,
     need_terminal, icon_file, aw->app_group, use_header, file_header);

  g_free(icon_file);
  g_free(need_terminal);
  g_free(use_header);
  g_free(file_header);

  chdir (top_dir);
  if(file_is_executable("./project.init") == FALSE)
  {
    anjuta_error(_("Project templete does not have executable project.init script.\n"
                           "It seems you have tampered with the project templete."));
    g_free (cmd_str);
    g_free (top_dir);
    return;
  }

  if (launcher_execute (cmd_str,
			new_prj_mesg_arrived,
			new_prj_mesg_arrived, new_prj_terminated) == FALSE)
  {
    mesg =
      g_strdup_printf (
          _("Error: There was an error executing the command: "
          "%s\nMake sure you have installed Anjuta properly."),
		       cmd_str);
    anjuta_error (mesg);
    g_free (mesg);
    g_free (cmd_str);
    chdir ("..");
    cmd_str = g_strconcat ("rm -r -f ", top_dir, NULL);
    if ((pid = fork ()) == 0)
    {
      execlp (app->preferences->commands.shell,
	      app->preferences->commands.shell, "-c", cmd_str, NULL);
      g_error (_("Cannot execute command shell"));
    }
    if (pid > 0) anjuta_register_child_process (pid, NULL, NULL);
    g_free (top_dir);
    g_free (cmd_str);
    messages_append (app->messages,
		     _
		     ("\nERROR: Unable to Create the Project templete ... Aborted\n"),
		     MESSAGE_BUILD);
    anjuta_warning (_("Error: Cannot create project templete"));
    return;
  }
  g_free (cmd_str);
  g_free (top_dir);
}

static void
new_prj_mesg_arrived (gchar * mesg)
{
  messages_append (app->messages, mesg, MESSAGE_BUILD);
}

void
new_prj_terminated (int status, time_t t)
{
  gint pid;
  if (WEXITSTATUS (status))
  {
    messages_append (app->messages,
		     _
		     ("configuration completed...............Unsuccessful\n"),
		     MESSAGE_BUILD);
    anjuta_error (_
		  ("The Project was not successfully configured.\nI think you have to do it manually."));
  }
  else
  {
    messages_append (app->messages,
		     _("configuration completed...............Successful\n"
		       "Now Build the project to have a LOOK at it\n"),
		     MESSAGE_BUILD);
    anjuta_status (_("Project was successfully configured."));
  }
  project_dbase_load_project (app->project_dbase);
  gdk_beep ();
  if ((pid = fork ()) == 0)
  {
    execlp (app->preferences->commands.shell,
	    app->preferences->commands.shell,
	    "-c", "rm -f project.init", NULL);
    g_error (_("Cannot execute command shell"));
  }
  waitpid (pid, NULL, 0);
}
