/* 
    main_menubar_def.h
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _MAIN_MENUBAR_DEF_H_
#define _MAIN_MENUBAR_DEF_H_

#include <gnome.h>

static GnomeUIInfo recent_projects1_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("project1"),
    NULL,
    on_project1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo file1_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("_New"),
    N_("New Text File"),
    on_new_file1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
    GDK_N, GDK_MOD1_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Open ..."),
    N_("Open Text File"),
    on_open1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
    GDK_O, GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Save"),
    N_("Save Current File"),
    on_save1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
    GDK_S, GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Save _As ..."),
    N_("Save the current File to a different file"),
    on_save_as1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE_AS,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Save A_ll"),
    N_("Save all currently opened Files, execpt Newfiles"),
    on_save_all1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
    GDK_L, GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Close File"),
    N_("Close Current File"),
    on_close_file1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
    GDK_D, GDK_MOD1_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Reload File"),
    N_("Reload Current File"),
    on_reload_file1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REVERT,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("N_ew Project ..."),
    N_("Create a project using application widzard"),
    on_new_project1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Open P_roject ..."),
    N_("Open a Project"),
    on_open_project1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
    GDK_J, GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Sa_ve Project"),
    N_("Save the current Project"),
    on_save_project1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Close Pro_ject"),
    N_("Close the current Project"),
    on_close_project1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Rena_me ..."),
    N_("Rename the current file"),
    on_rename1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Page Set_up ..."),
    N_("Page setup for printing"),
    on_page_setup1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Print ..."),
    N_("Print the current File"),
    on_print1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PRINT,
    GDK_P, GDK_MOD1_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Recent _Files"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_SUBTREE, N_("Recent Projec_ts"),
    NULL,
    recent_projects1_menu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_EXIT_ITEM (on_exit1_activate, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo edit1_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("_Undo"),
    N_("Undo the last action"),
    on_undo1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_UNDO,
    GDK_Z, GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Redo"),
    N_("Redo the last udone action"),
    on_redo1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REDO,
    GDK_R, GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("C_ut"),
    N_("Cut the selected text from the editor to the clipboard"),
    on_cut1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CUT,
    GDK_X, GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Copy"),
    N_("Copy the selected text to the clipboard"),
    on_copy1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_COPY,
    GDK_C, GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Paste"),
    N_("Paste the content of clipboard at the current position"),
    on_paste1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PASTE,
    GDK_V, GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("C_lear"),
    N_("Delete the selected text from the editor"),
    on_clear1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_Delete, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Select All"),
    N_("Select all text in the editor"),
    on_select_all1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_A, GDK_MOD1_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Find ..."),
    N_("Search a string or regexp in the editor"),
    on_find1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SEARCH,
    GDK_F, GDK_MOD1_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Fin_d in files ..."),
    N_("Search a string in multiple files or directories"),
    on_find_in_files1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Find and Re_place ..."),
    N_("Search and replace a string or regexp with another string"),
    on_find_and_replace1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SRCHRPL,
    GDK_R, GDK_MOD1_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Goto Line no ..."),
    N_("Go to a perticular line no. in the editor"),
    on_goto_line_no1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_G, GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Edit Application _GUIs ..."),
    N_("Edit your application GUIs with glade GUI editor"),
    on_edit_app_gui1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_E, GDK_MOD1_MASK, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo toolbar1_submenu_uiinfo[] =
{
  {
    GNOME_APP_UI_TOGGLEITEM, N_("_Main Tolbar"),
    N_("Hide/Unhide main toolbar"),
    on_main_toolbar1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_TOGGLEITEM, N_("_Exended Toolbar"),
    N_("Hide/Unhide extended toolbar"),
    on_extended_toolbar1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_TOGGLEITEM, N_("_Browser Toolbar"),
    N_("Hide/Unhide browser toolbar"),
    on_browser_toolbar1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_TOGGLEITEM, N_("_Debug Toolbar"),
    N_("Hide/Unhide debug toolbar"),
    on_debug_toolbar1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo view1_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("_Messages"),
    N_("Show the message window"),
    on_messages1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ALIGN_LEFT,
    GDK_F1, GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Project _Listing"),
    N_("Show the project window"),
    on_project_listing1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ALIGN_LEFT,
    GDK_F2, GDK_CONTROL_MASK, NULL
  },
  {
   GNOME_APP_UI_ITEM, N_("B_ookmarks"),
    N_("Show the bookmark window"),
    on_bookmarks1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_F3, GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_SUBTREE, N_("_Toolbars"),
    NULL,
    toolbar1_submenu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, N_("_Toolbar"),
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Breakpoints"),
    N_("Show breakpoints editor window"),
    on_breakpoints1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_F4, GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Watch Window"),
    N_("Show expression watch window"),
    on_watch_window1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_F5, GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Registers"),
    N_("Show cpu registers and their contents"),
    on_registers1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_F6, GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Program _Stack"),
    N_("Show stack trace of the program"),
    on_program_stack1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_F7, GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Shared Libraries"),
    N_("Show shared libraries loaded by the program"),
    on_shared_lib1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_F8, GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Kernal Signals"),
    N_("Show the kernal signals editor window"),
    on_kernal_signals1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_F9, GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Dump Window"),
    N_("Show Memory dump window"),
    on_dump_window1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_F10, GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Console"),
    N_("Show the console where the program runs"),
    on_console1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_MIDI,
    GDK_F11, GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo project1_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("Add _Source file ..."),
    N_("Add a source file to the project"),
    on_prj_add_src1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Add _Pixmap file ..."),
    N_("Add a pixmap file to the project"),
    on_prj_add_pix1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Add _Document file ..."),
    N_("Add a document file to the project"),
    on_prj_add_doc1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Add _General file ..."),
    N_("Add a general file to the project"),
    on_prj_add_gen1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Add Di_rectory ..."),
    N_("Add a directory to the project"),
    on_prj_add_dir1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Remove from project"),
    N_("Remove the selected file from the project"),
    on_prj_remove1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, "READ_ME",
    N_("Open the readme file of the project"),
    on_prj_readme1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, "_TODO",
    N_("Open the todo file of the project"),
    on_prj_todo1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, "Change_Log",
    N_("Open the changelog file of the project"),
    on_prj_changelog1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, "_NEWS",
    N_("Open the news file of the project"),
    on_prj_news1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Project _Configuration ..."),
    N_("Edit the configuration of the project"),
    on_prj_config1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Project _Information"),
    N_("Detailed information about the project"),
    on_prj_info1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_OPEN,
    0, 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo format1_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("Syntax _Hilite"),
    N_("This will hilite the syntax of the source file"),
    on_syntax_hilite1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Auto _Format"),
    N_("This will autoformate source file"),
    on_indent1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ALIGN_LEFT,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Update tags image"),
    N_("This will update the tags image of the project/opened files"),
    on_update_tags1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_FONT,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Toggle _Line Wrap"),
    N_("Toggle line wrap of the editor"),
    on_line_wrap1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Toggle _Word Wrap"),
    N_("Toggle word wrap of the editor"),
    on_word_wrap1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Detach Current Document"),
    N_("Detach the current editor into a seperate window"),
    on_detach1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_END
};


static GnomeUIInfo build1_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("_Compile"),
    N_("Compile the current source file"),
    on_compile1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CONVERT,
    GDK_F9, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Build"),
    N_("Build the source directory of the project/current source file"),
    on_build_project1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXEC,
    GDK_F10, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Build _All"),
    N_("Build the whole project"),
    on_build_all_project1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_F11, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Install"),
    N_("Install the project in your computer"),
    on_install_project1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Build _Distribution"),
    N_("Build the distribution tarball of the project"),
    on_build_dist_project1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Con_figure ..."),
    N_("Configure the project"),
    on_configure_project1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Auto _genarate ..."),
    N_("Auto generate all the build files"),
    on_autogen_project1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Clea_n"),
    N_("Clean your source directory"),
    on_clean_project1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Clean A_ll"),
    N_("Clean the whole project directory"),
    on_clean_all_project1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Stop Build"),
    N_("Stop the current compile or build process"),
    on_stop_build_make1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_STOP,
    GDK_F12, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Execute"),
    N_("Execute the program"),
    on_go_execute1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_JUMP_TO,
    GDK_F3, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Set _Program params ..."),
    N_("Set the execution parameters of the program"),
    on_go_execute2_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_JUMP_TO,
    0, 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo bookmark1_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("_Toggle bookmark"),
    NULL,
    on_book_toggle1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Previous bookmark"),
    NULL,
    on_book_prev1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Next bookmark"),
    NULL,
    on_book_next1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Last bookmark"),
    NULL,
    on_book_next1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Clear all bookmarks"),
    NULL,
    on_book_clear1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_END
};

static GnomeUIInfo execution1_submenu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("Run/_Continue"),
    N_("Continue the execution of the program"),
    on_execution_continue1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXEC,
    GDK_F4, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Step _In"),
    N_("Single step into functions"),
    on_execution_step_in1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_F5, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Step O_ver"),
    N_("Single step over functions"),
    on_execution_step_over1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_F6, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Step _Out"),
    N_("Single step out of the functions"),
    on_execution_step_out1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_F7, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Run to cursor"),
    N_("Run to the cursor"),
    on_execution_run_to_cursor1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_F8, 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo breakpoints1_submenu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("Toggle breakpoint"),
    N_("Toggle breakpoint at the current location"),
    on_toggle_breakpoint1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Set Breakpoint ..."),
    N_("Set a breakpoint"),
    on_set_breakpoint1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_INDEX,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Breakpoints ..."),
    N_("Edit breakpoints"),
    on_show_breakpoints1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Disable all Breakpoints"),
    N_("This will deactivate all the breakpoints"),
    on_disable_all_breakpoints1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("C_lear all Breakpoints"),
    N_("This will delete all the breakpoints"),
    on_clear_breakpoints1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
    0, 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo info1_submenu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("Info _Target Files"),
    N_("The files which the debugger is active with"),
    on_info_targets_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Info _Program"),
    N_("Get the information about the execution status of the program"),
    on_info_program_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Info _Kernal User Struct"),
    N_("Get the contents of kernel 'struct user' for current child"),
    on_info_udot_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Info _Threads"),
    N_("Get the IDs of currently known threads"),
    on_info_threads_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Info _Global variables"),
    N_("All the global and static variables of the program"),
    on_info_variables_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Info _Local variables"),
    N_("All the local variables of the current frame"),
    on_info_locals_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Info _Current Frame"),
    N_("Show the information about the current frame of execution"),
    on_info_frame_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_BLUE,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Info Function _Arguments"),
    N_("Function arguments of the current frame"),
    on_info_args_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo debug1_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("_Start Debugger"),
    N_("Start the debugging session"),
    on_debugger_start_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXEC,
    GDK_F12, GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Load E_xecutable ..."),
    N_("Open the executable for debuging"),
    on_debugger_open_exec_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Load _Core file ..."),
    N_("Load a core file to disect"),
    on_debugger_load_core_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REVERT,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Attach to Process ..."),
    N_("Attach to an already running program"),
    on_debugger_attach_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ATTACH,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Restart Program"),
    N_("Stop and restart the program"),
    on_debugger_restart_prog_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REFRESH,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("S_top Program"),
    N_("Stop the debugging program"),
    on_debugger_stop_prog_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_STOP,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Detach Debugger"),
    N_("Detach the program if you have attached to it"),
    on_debugger_detach_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("I_nterrupt Program"),
    N_("Interrupt the program execution"),
    on_debugger_interrupt_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_F1, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Si_gnal to Process"),
    N_("Send a kernel signal to the debugging process"),
    on_debugger_signal_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_SUBTREE, N_("_Execution"),
    NULL,
    execution1_submenu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_SUBTREE, N_("_Breakpoints"),
    NULL,
    breakpoints1_submenu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_SUBTREE, N_("_Information"),
    NULL,
    info1_submenu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Ins_pect/Evaluate ..."),
    N_("Inspect or evaluate an expression or a variable"),
    on_debugger_inspect_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_OPEN,
    GDK_F2, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Add Expression in _Watch ..."),
    N_("Add expression or a variable in the watch"),
    on_debugger_inspect_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_F2, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("St_op Debugger"),
    N_("Say good bye to the debugger"),
    on_debugger_stop_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_STOP,
    0, 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo utilities1_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("Grep Utility"),
    NULL,
    on_grep_utility1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Compare two files"),
    NULL,
    on_compare_two_files1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Diff Utility"),
    NULL,
    on_diff_utility1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("File View (Char/Octal/Hex)"),
    NULL,
    on_file_view__char_octal_hex_1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Declarations"),
    NULL,
    on_c_beautifier1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("C Flow"),
    NULL,
    on_c_flow1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("C Cross-reference"),
    NULL,
    on_c_cross_reference1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("C Trace"),
    NULL,
    on_c_trace1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Backup Manager"),
    NULL,
    on_archive_maintenace1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo windows1_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("_Create New Window"),
    N_("Start another Anjuta application"),
    on_windows1_new_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
    0, 0, NULL
  },
/*
 Do not provide any gettext macro with "Cl_ose Current Window"
 given below. Otherwise, I won't be able to find it.
*/
  {
    GNOME_APP_UI_ITEM, "Cl_ose Current window",
    N_("Close current document window"),
    on_windows1_close_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
    0, 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo settings1_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("_Compiler and Linker Settings ..."),
    N_("Settings that are meant for compiler and linker"),
    on_set_compiler1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Source Paths ..."),
    N_("Specify the source paths for the Anjuta to search"),
    on_set_src_paths1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("_Preferences ..."),
    N_("Do your prefer coffee to tea? Check it out."),
    on_set_preferences1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Set _Default Preferences"),
    N_("But I prefer tea."),
    on_set_default_preferences1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP,
    0, 0, NULL
  },
  GNOMEUIINFO_END,
};

static GnomeUIInfo help1_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("Contents"),
    N_("This is your tutor"),
    on_contents1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_INDEX,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Index"),
    N_("Index of everything that you knew, but forgotten"),
    on_index1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_INDEX,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Browse Man Pages"),
    N_("The good old manual pages"),
    on_man_pages1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_RED,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Browse Info Pages"),
    N_("Info pages, where you cannot find what you are looking for"),
    on_info_pages1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_RED,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Search a topic"),
    N_("May I help you?"),
    on_search_a_topic1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SEARCH,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_ABOUT_ITEM (on_about1_activate, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo menubar1_uiinfo[] =
{
  GNOMEUIINFO_MENU_FILE_TREE (file1_menu_uiinfo),
  GNOMEUIINFO_MENU_EDIT_TREE (edit1_menu_uiinfo),
  GNOMEUIINFO_MENU_VIEW_TREE (view1_menu_uiinfo),
  {
    GNOME_APP_UI_SUBTREE, N_("_Project"),
    NULL,
    project1_menu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
   GNOME_APP_UI_SUBTREE, N_("For_mat"),
    NULL,
    format1_menu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_SUBTREE, N_("_Build"),
    NULL,
    build1_menu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_SUBTREE, N_("Bookmar_k"),
    NULL,
    bookmark1_menu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_SUBTREE, N_("_Debug"),
    NULL,
    debug1_menu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_SUBTREE, N_("_Utilities"),
    NULL,
    utilities1_menu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
/*
 Do not provide any gettext macro with "_Windows"
 given below. Otherwise, I won't be able to find it.
*/
  {
    GNOME_APP_UI_SUBTREE, "_Windows",
    NULL,
    windows1_menu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_SUBTREE, N_("_Settings"),
    NULL,
    settings1_menu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_MENU_HELP_TREE (help1_menu_uiinfo),
  GNOMEUIINFO_END
};

#endif
