/*
 * preferences.c
 * Copyright (C) 2000  Kh. Naba Kumar Singh
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>
#include "support.h"
#include "preferences.h"
#include "anjuta.h"
#include "commands.h"

extern gchar *format_style[];

static void on_preferences_set_default_yes_clicked (GtkButton * button,
						    gpointer user_data);

Preferences *
preferences_new ()
{
  Preferences *pr;
  pr = (Preferences *) malloc (sizeof (Preferences));
  if (pr)
    {
      GtkWidget *wid;
      GdkColormap *cmap;
      GList *list;
      int i;

      pr->commands.shell = g_strdup ("bash");
      pr->commands.build = g_strdup ("gmake");
      pr->commands.c_compiler = g_strdup ("gcc");
      pr->commands.cpp_compiler = g_strdup ("g++");
      pr->commands.pixmap_editor = g_strdup ("gimp");
      pr->commands.terminal = g_strdup ("gnome-terminal");
      pr->commands.browser = g_strdup ("gnome-help-browser");

      pr->auto_indent = TRUE;
      pr->auto_save = TRUE;
      pr->auto_save_timer = 10;
      pr->tab_size = 8;

      pr->plain_color.pixel = 0;
      pr->plain_color.red = 0;
      pr->plain_color.green = 0;
      pr->plain_color.blue = 0;

      pr->comment_color.pixel = 0;
      pr->comment_color.red = 65535;
      pr->comment_color.green = 0;
      pr->comment_color.blue = 0;

      pr->string_color.pixel = 0;
      pr->string_color.red = 65535;
      pr->string_color.green = 43908;
      pr->string_color.blue = 16383;

      pr->keywords_color.pixel = 0;
      pr->keywords_color.red = 0;
      pr->keywords_color.green = 0;
      pr->keywords_color.blue = 65535;

      wid = app->widgets.window;
      cmap = gtk_widget_get_colormap (wid);

      pr->back_color.pixel = 0;
      pr->back_color.red = 65535;
      pr->back_color.green = 65535;
      pr->back_color.blue = 65535;

      gdk_color_alloc (cmap, &(pr->plain_color));
      gdk_color_alloc (cmap, &(pr->comment_color));
      gdk_color_alloc (cmap, &(pr->string_color));
      gdk_color_alloc (cmap, &(pr->keywords_color));

      pr->auto_hilite = FALSE;
      pr->enable_hilite = TRUE;
      pr->lesser_hilite = FALSE;

      pr->font_name = NULL;
      pr->font = NULL;
      pr->pr_command = g_strdup ("lpr");

      pr->all_projects_dir = g_strconcat (getenv ("HOME"), "/Projects", NULL);
      pr->beep_on_build_complete = TRUE;
      pr->dialog_on_build_complete = FALSE;
      pr->check_dependencies = FALSE;
      pr->max_recent_prjs = 4;
      pr->max_recent_files = 12;
      pr->max_combo_histories = 8;
      pr->max_undo_histories = 100;
      pr->is_showing = FALSE;
      pr->win_pos_x = 100;
      pr->win_pos_y = 80;
      create_preferences_gui (pr);
      list = NULL;
      i = 0;
      while (shell_coms[i])
	{
	  list = g_list_append (list, shell_coms[i++]);
	}
      gtk_combo_set_popdown_strings (GTK_COMBO
				     (pr->widgets.commands.shell_combo),
				     list);
      g_list_free (list);
      list = NULL;
      i = 0;
      while (build_coms[i])
	{
	  list = g_list_append (list, build_coms[i++]);
	}
      gtk_combo_set_popdown_strings (GTK_COMBO
				     (pr->widgets.commands.build_combo),
				     list);
      g_list_free (list);
      list = NULL;
      i = 0;
      while (c_compiler_coms[i])
	{
	  list = g_list_append (list, c_compiler_coms[i++]);
	}
      gtk_combo_set_popdown_strings (GTK_COMBO
				     (pr->widgets.commands.c_compiler_combo),
				     list);
      g_list_free (list);
      list = NULL;
      i = 0;
      while (cpp_compiler_coms[i])
	{
	  list = g_list_append (list, cpp_compiler_coms[i++]);
	}
      gtk_combo_set_popdown_strings (GTK_COMBO
				     (pr->widgets.
				      commands.cpp_compiler_combo), list);
      g_list_free (list);
      list = NULL;
      i = 0;
      while (pixmap_editor_coms[i])
	{
	  list = g_list_append (list, pixmap_editor_coms[i++]);
	}
      gtk_combo_set_popdown_strings (GTK_COMBO
				     (pr->widgets.
				      commands.pixmap_editor_combo), list);
      g_list_free (list);
      list = NULL;
      i = 0;
      while (terminal_coms[i])
	{
	  list = g_list_append (list, terminal_coms[i++]);
	}
      gtk_combo_set_popdown_strings (GTK_COMBO
				     (pr->widgets.commands.terminal_combo),
				     list);
      g_list_free (list);
      list = NULL;
      i = 0;
      while (browser_coms[i])
	{
	  list = g_list_append (list, browser_coms[i++]);
	}
      gtk_combo_set_popdown_strings (GTK_COMBO
				     (pr->widgets.commands.browser_combo),
				     list);
      g_list_free (list);
      pr->format_disable = FALSE;
      pr->format_style = g_strdup ("Style of Kangleipak");
      pr->custom_style = g_strdup ("-i4 -bl -bls -bli0 -ss cbio0");

      pr->truncat_mesg = FALSE;
      pr->mesg_first = 50;
      pr->mesg_last = 30;
      pr->tag_pos = TAG_POS_TOP;
      pr->no_tag = FALSE;
      pr->tags_update = TRUE;
    }
  return pr;
}

void
preferences_destroy (Preferences * pr)
{
  gint i;
  if (pr)
    {
      if (pr->all_projects_dir)
	g_free (pr->all_projects_dir);
      if (pr->font_name)
	g_free (pr->font_name);
      if (pr->font)
	gdk_font_unref (pr->font);
      if (pr->pr_command)
	g_free (pr->pr_command);

      if (pr->commands.shell)
	g_free (pr->commands.shell);
      if (pr->commands.build)
	g_free (pr->commands.build);
      if (pr->commands.c_compiler)
	g_free (pr->commands.c_compiler);
      if (pr->commands.cpp_compiler)
	g_free (pr->commands.cpp_compiler);
      if (pr->commands.pixmap_editor)
	g_free (pr->commands.pixmap_editor);
      if (pr->commands.terminal)
	g_free (pr->commands.terminal);
      if (pr->commands.browser)
	g_free (pr->commands.browser);

      gtk_widget_unref (pr->widgets.window);
      gtk_widget_unref (pr->widgets.notebook);
      gtk_widget_unref (pr->widgets.prj_dir_entry);
      gtk_widget_unref (pr->widgets.recent_prj_spin);
      gtk_widget_unref (pr->widgets.recent_files_spin);
      gtk_widget_unref (pr->widgets.combo_history_spin);
      gtk_widget_unref (pr->widgets.beep_check);
      gtk_widget_unref (pr->widgets.dialog_check);
      gtk_widget_unref (pr->widgets.dependency_check);
      gtk_widget_unref (pr->widgets.auto_save_check);
      gtk_widget_unref (pr->widgets.auto_indent_check);
      gtk_widget_unref (pr->widgets.tab_size_spin);
      gtk_widget_unref (pr->widgets.timer_spin);
      gtk_widget_unref (pr->widgets.back_colorpicker);
      gtk_widget_unref (pr->widgets.plain_colorpicker);
      gtk_widget_unref (pr->widgets.comment_colorpicker);
      gtk_widget_unref (pr->widgets.string_colorpicker);
      gtk_widget_unref (pr->widgets.keywords_colorpicker);
      gtk_widget_unref (pr->widgets.enable_hilite_check);
      gtk_widget_unref (pr->widgets.auto_hilite_check);
      gtk_widget_unref (pr->widgets.lesser_hilite_check);
      gtk_widget_unref (pr->widgets.fontselector);
      gtk_widget_unref (pr->widgets.paperselector);
      gtk_widget_unref (pr->widgets.pr_command_combo);
      gtk_widget_unref (pr->widgets.pr_command_entry);
      gtk_widget_unref (pr->widgets.commands.shell_combo);
      gtk_widget_unref (pr->widgets.commands.build_combo);
      gtk_widget_unref (pr->widgets.commands.c_compiler_combo);
      gtk_widget_unref (pr->widgets.commands.cpp_compiler_combo);
      gtk_widget_unref (pr->widgets.commands.pixmap_editor_combo);
      gtk_widget_unref (pr->widgets.commands.terminal_combo);

      gtk_widget_unref (pr->widgets.format_style_combo);
      gtk_widget_unref (pr->widgets.custom_style_entry);
      gtk_widget_unref (pr->widgets.format_disable_check);
      gtk_widget_unref (pr->widgets.format_frame1);
      gtk_widget_unref (pr->widgets.format_frame2);

      gtk_widget_unref (pr->widgets.truncat_mesg_check);
      gtk_widget_unref (pr->widgets.mesg_first_spin);
      gtk_widget_unref (pr->widgets.mesg_last_spin);
      gtk_widget_unref (pr->widgets.tags_update_check);
      gtk_widget_unref (pr->widgets.no_tag_check);
      for (i = 0; i < 4; i++)
	gtk_widget_unref (pr->widgets.tag_pos_radio[i]);

      gtk_widget_destroy (pr->widgets.window);
      g_free (pr);
      pr = NULL;
    }
}

void
preferences_get (Preferences * pr)
{

  if (pr->all_projects_dir)
    gtk_entry_set_text (GTK_ENTRY (pr->widgets.prj_dir_entry),
			pr->all_projects_dir);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pr->widgets.beep_check),
				pr->beep_on_build_complete);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pr->widgets.dialog_check),
				pr->dialog_on_build_complete);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(pr->widgets.dependency_check),
				pr->check_dependencies);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (pr->widgets.recent_prj_spin),
			     pr->max_recent_prjs);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (pr->widgets.recent_files_spin),
			     pr->max_recent_files);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (pr->widgets.combo_history_spin),
			     pr->max_combo_histories);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(pr->widgets.auto_indent_check),
				pr->auto_indent);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(pr->widgets.auto_save_check), pr->auto_save);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(pr->widgets.enable_hilite_check),
				pr->enable_hilite);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(pr->widgets.auto_hilite_check),
				pr->auto_hilite);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(pr->widgets.lesser_hilite_check),
				pr->lesser_hilite);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (pr->widgets.timer_spin),
			     pr->auto_save_timer);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (pr->widgets.tab_size_spin),
			     pr->tab_size);

  if (pr->commands.shell)
    gtk_entry_set_text (GTK_ENTRY
			(GTK_COMBO (pr->widgets.commands.shell_combo)->entry),
			pr->commands.shell);

  if (pr->commands.build)
    gtk_entry_set_text (GTK_ENTRY
			(GTK_COMBO (pr->widgets.commands.build_combo)->entry),
			pr->commands.build);

  if (pr->commands.c_compiler)
    gtk_entry_set_text (GTK_ENTRY
			(GTK_COMBO
			 (pr->widgets.commands.c_compiler_combo)->entry),
			pr->commands.c_compiler);

  if (pr->commands.cpp_compiler)
    gtk_entry_set_text (GTK_ENTRY
			(GTK_COMBO
			 (pr->widgets.commands.cpp_compiler_combo)->entry),
			pr->commands.cpp_compiler);

  if (pr->commands.pixmap_editor)
    gtk_entry_set_text (GTK_ENTRY
			(GTK_COMBO
			 (pr->widgets.commands.pixmap_editor_combo)->entry),
			pr->commands.pixmap_editor);

  if (pr->commands.terminal)
    gtk_entry_set_text (GTK_ENTRY
			(GTK_COMBO
			 (pr->widgets.commands.terminal_combo)->entry),
			pr->commands.terminal);

  if (pr->commands.browser)
    gtk_entry_set_text (GTK_ENTRY
			(GTK_COMBO
			 (pr->widgets.commands.browser_combo)->entry),
			pr->commands.browser);

  if (pr->font_name)
    {
      gtk_font_selection_set_font_name (GTK_FONT_SELECTION
					(pr->widgets.fontselector),
					pr->font_name);
    }
  if (pr->pr_command)
    gtk_entry_set_text (GTK_ENTRY (pr->widgets.pr_command_entry),
			pr->pr_command);

  gnome_color_picker_set_i16 (GNOME_COLOR_PICKER
			      (pr->widgets.plain_colorpicker),
			      pr->plain_color.red, pr->plain_color.green,
			      pr->plain_color.blue, 0);

  gnome_color_picker_set_i16 (GNOME_COLOR_PICKER
			      (pr->widgets.comment_colorpicker),
			      pr->comment_color.red, pr->comment_color.green,
			      pr->comment_color.blue, 0);

  gnome_color_picker_set_i16 (GNOME_COLOR_PICKER
			      (pr->widgets.string_colorpicker),
			      pr->string_color.red, pr->string_color.green,
			      pr->string_color.blue, 0);

  gnome_color_picker_set_i16 (GNOME_COLOR_PICKER
			      (pr->widgets.keywords_colorpicker),
			      pr->keywords_color.red,
			      pr->keywords_color.green,
			      pr->keywords_color.blue, 0);

  gnome_color_picker_set_i16 (GNOME_COLOR_PICKER
			      (pr->widgets.back_colorpicker),
			      pr->back_color.red, pr->back_color.green,
			      pr->back_color.blue, 0);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(pr->widgets.format_disable_check), FALSE);
  if (pr->custom_style)
    gtk_entry_set_text (GTK_ENTRY (pr->widgets.custom_style_entry),
			pr->custom_style);

  if (pr->format_style)
    gtk_entry_set_text (GTK_ENTRY
			(GTK_COMBO (pr->widgets.format_style_combo)->entry),
			pr->format_style);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(pr->widgets.format_disable_check),
				pr->format_disable);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(pr->widgets.truncat_mesg_check), TRUE);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pr->widgets.no_tag_check),
				FALSE);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (pr->widgets.mesg_first_spin),
			     pr->mesg_first);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (pr->widgets.mesg_last_spin),
			     pr->mesg_last);
  switch (pr->tag_pos)
    {
    case TAG_POS_BOTTOM:
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (pr->widgets.tag_pos_radio[1]), TRUE);
      break;
    case TAG_POS_LEFT:
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (pr->widgets.tag_pos_radio[2]), TRUE);
      break;
    case TAG_POS_RIGHT:
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (pr->widgets.tag_pos_radio[3]), TRUE);
      break;
    case TAG_POS_TOP:
    default:
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (pr->widgets.tag_pos_radio[0]), TRUE);
    }
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(pr->widgets.truncat_mesg_check),
				pr->truncat_mesg);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pr->widgets.no_tag_check),
				pr->no_tag);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(pr->widgets.tags_update_check),
				pr->tags_update);

  preferences_show (pr);
}

void
preferences_show (Preferences * pr)
{
  if (!pr)
    return;

  if (pr->is_showing)
    {
      gdk_window_raise (pr->widgets.window->window);
      return;
    }
  gtk_widget_set_uposition (pr->widgets.window, pr->win_pos_x, pr->win_pos_y);
  gtk_widget_show (pr->widgets.window);
  pr->is_showing = TRUE;
}

void
preferences_set_defaults (Preferences * pr)
{
  messagebox2 (GNOME_MESSAGE_BOX_QUESTION,
	       _
	       ("Are you sure you want to reset the preferences to\ntheir default settings?"),
	       GNOME_STOCK_BUTTON_YES, GNOME_STOCK_BUTTON_NO,
	       GTK_SIGNAL_FUNC (on_preferences_set_default_yes_clicked), NULL,
	       pr);
}

void
preferences_hide (Preferences * pr)
{
  if (!pr)
    return;
  if (pr->is_showing == FALSE)
    return;
  gdk_window_get_root_origin (pr->widgets.window->window, &pr->win_pos_x,
			      &pr->win_pos_y);
  gtk_widget_hide (pr->widgets.window);
  pr->is_showing = FALSE;
}

gboolean
preferences_save_yourself (Preferences * pr)
{
  unsigned long temp1, temp2, temp3;
  FILE *stream;
  gchar *text;

  if (!pr)
    return FALSE;

  text = g_strconcat (app->dirs->settings, "/preferences.set", NULL);
  stream = fopen (text, "w");
  g_free (text);

  if (stream == NULL)
    return FALSE;
  fprintf (stream,
	   "# **************************************************************************\n");
  fprintf (stream,
	   _
	   ("# *********** DO NOT EDIT OR RENAME THIS FILE *****************\n"));
  fprintf (stream,
	   _
	   ("# ******************* Created by  Anjuta ********************************\n"));
  fprintf (stream,
	   _
	   ("# ****************** Anjuta Preferences *********************************\n"));
  fprintf (stream,
	   "# **************************************************************************\n\n");

  fprintf (stream, "Anjuta: %s\n", VERSION);

  /*
   * Page 0 
   */

  if (write_string (stream, "Project_Dir", pr->all_projects_dir) == FALSE)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", pr->beep_on_build_complete) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", pr->dialog_on_build_complete) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", pr->check_dependencies) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", pr->max_recent_prjs) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", pr->max_recent_files) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", pr->max_combo_histories) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", pr->auto_indent) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", pr->auto_save) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", pr->auto_save_timer) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", pr->enable_hilite) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", pr->auto_hilite) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", pr->lesser_hilite) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", pr->tab_size) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  /*
   * Page 1 
   */

  if (write_string (stream, "Command_Shell", pr->commands.shell) == FALSE)
    {
      fclose (stream);
      return FALSE;
    }
  if (write_string (stream, "Command_Build", pr->commands.build) == FALSE)
    {
      fclose (stream);
      return FALSE;
    }
  if (write_string (stream, "Command_C_Compiler", pr->commands.c_compiler) ==
      FALSE)
    {
      fclose (stream);
      return FALSE;
    }
  if (write_string (stream, "Command_Cpp_Compiler", pr->commands.cpp_compiler)
      == FALSE)
    {
      fclose (stream);
      return FALSE;
    }
  if (write_string
      (stream, "Command_Pixmap_Editor", pr->commands.pixmap_editor) == FALSE)
    {
      fclose (stream);
      return FALSE;
    }
  if (write_string (stream, "Command_Terminal", pr->commands.terminal) ==
      FALSE)
    {
      fclose (stream);
      return FALSE;
    }
  if (write_string (stream, "Command_Browser", pr->commands.browser) == FALSE)
    {
      fclose (stream);
      return FALSE;
    }

  /*
   * Page 2 
   */

  temp1 = (unsigned long) pr->plain_color.red;
  temp2 = (unsigned long) pr->plain_color.blue;
  temp3 = (unsigned long) pr->plain_color.green;
  if (fprintf (stream, "%lu %lu %lu\n", temp1, temp2, temp3) < 3)
    {
      fclose (stream);
      return FALSE;
    }

  temp1 = (unsigned long) pr->comment_color.red;
  temp2 = (unsigned long) pr->comment_color.blue;
  temp3 = (unsigned long) pr->comment_color.green;
  if (fprintf (stream, "%lu %lu %lu\n", temp1, temp2, temp3) < 3)
    {
      fclose (stream);
      return FALSE;
    }

  temp1 = (unsigned long) pr->string_color.red;
  temp2 = (unsigned long) pr->string_color.blue;
  temp3 = (unsigned long) pr->string_color.green;
  if (fprintf (stream, "%lu %lu %lu\n", temp1, temp2, temp3) < 3)
    {
      fclose (stream);
      return FALSE;
    }

  temp1 = (unsigned long) pr->keywords_color.red;
  temp2 = (unsigned long) pr->keywords_color.blue;
  temp3 = (unsigned long) pr->keywords_color.green;
  if (fprintf (stream, "%lu %lu %lu\n", temp1, temp2, temp3) < 3)
    {
      fclose (stream);
      return FALSE;
    }

  temp1 = (unsigned long) pr->back_color.red;
  temp2 = (unsigned long) pr->back_color.blue;
  temp3 = (unsigned long) pr->back_color.green;
  if (fprintf (stream, "%lu %lu %lu\n", temp1, temp2, temp3) < 3)
    {
      fclose (stream);
      return FALSE;
    }

  /*
   * Page 3 
   */
  if (pr->font_name)
    {
      if (fprintf (stream, "%d\n", 1) < 1)
	return FALSE;
      if (write_string (stream, "Font", pr->font_name) == FALSE)
	{
	  fclose (stream);
	  return FALSE;
	}
    }
  else
    {
      if (fprintf (stream, "%d\n", 0) < 1)
	{
	  fclose (stream);
	  return FALSE;
	}
    }

  /*
   * Page 4 
   */
  if (pr->pr_command)
    {
      if (fprintf (stream, "%d\n", 1) < 1)
	{
	  fclose (stream);
	  return FALSE;
	}
      if (write_string (stream, "Print_Command", pr->pr_command) == FALSE)
	{
	  fclose (stream);
	  return FALSE;
	}
    }
  else
    {
      if (fprintf (stream, "%d\n", 0) < 1)
	{
	  fclose (stream);
	  return FALSE;
	}
    }

  /*
   * Page 5 
   */

  if (fprintf (stream, "%d\n", pr->format_disable) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (write_string (stream, "Format_Style", pr->format_style) == FALSE)
    {
      fclose (stream);
      return FALSE;
    }
  if (pr->custom_style)
    {
      if (fprintf (stream, "%d\n", 1) < 1)
	{
	  fclose (stream);
	  return FALSE;
	}
      if (write_string (stream, "Custom_Style", pr->custom_style) == FALSE)
	{
	  fclose (stream);
	  return FALSE;
	}
    }
  else
    {
      if (fprintf (stream, "%d\n", 0) < 1)
	{
	  fclose (stream);
	  return FALSE;
	}
    }

  /*
   * Page 6 
   */
  if (fprintf (stream, "%d\n", (int) pr->truncat_mesg) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", pr->mesg_first) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", pr->mesg_last) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", (int) pr->tag_pos) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", (int) pr->no_tag) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", (int) pr->tags_update) < 1)
    {
      fclose (stream);
      return FALSE;
    }

  if (fprintf (stream, "%d\n", pr->win_pos_x) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fprintf (stream, "%d\n", pr->win_pos_y) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  return TRUE;
}

gboolean
preferences_load_yourself (Preferences * pr)
{
  gint dummy;
  unsigned long temp1, temp2, temp3;
  char *buff, buffer[256];
  FILE *stream;
  GdkFont *font;
  gint i;

  if (!pr)
    return FALSE;
  buff = g_strconcat (app->dirs->settings, "/preferences.set", NULL);
  stream = fopen (buff, "r");
  if (stream == NULL)
    return FALSE;
  i = 0;
  while (i < 6)
    {
      char ch;
      if ((ch = fgetc (stream)) == EOF)
	{
	  fclose (stream);
	  return FALSE;
	}
      if (ch == '\n')
	i++;
    }
  if (fscanf (stream, "Anjuta: %s\n", buffer) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (strcmp (buffer, VERSION) != 0)
    {
      fclose (stream);
      return FALSE;
    }

  /*
   * page 0 
   */

  if (read_string (stream, "Project_Dir", &buff) == FALSE)
    {
      fclose (stream);
      return FALSE;
    }
  if (pr->all_projects_dir)
    g_free (pr->all_projects_dir);
  pr->all_projects_dir = buff;
  if (fscanf (stream, "%d\n", &pr->beep_on_build_complete) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fscanf (stream, "%d\n", &pr->dialog_on_build_complete) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fscanf (stream, "%d\n", &pr->check_dependencies) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  pr->check_dependencies = FALSE;
  if (fscanf (stream, "%d\n", &pr->max_recent_prjs) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fscanf (stream, "%d\n", &pr->max_recent_files) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fscanf (stream, "%d\n", &pr->max_combo_histories) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fscanf (stream, "%d\n", &pr->auto_indent) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fscanf (stream, "%d\n", &pr->auto_save) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fscanf (stream, "%d\n", &pr->auto_save_timer) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fscanf (stream, "%d\n", &pr->enable_hilite) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  pr->enable_hilite = TRUE;
  if (fscanf (stream, "%d\n", &pr->auto_hilite) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fscanf (stream, "%d\n", &pr->lesser_hilite) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fscanf (stream, "%d\n", &pr->tab_size) < 1)
    {
      fclose (stream);
      return FALSE;
    }

  /*
   * Page 1 
   */

  if (read_string (stream, "Command_Shell", &buff) == FALSE)
    {
      fclose (stream);
      return FALSE;
    }
  if (pr->commands.shell)
    g_free (pr->commands.shell);
  pr->commands.shell = buff;

  if (read_string (stream, "Command_Build", &buff) == FALSE)
    {
      fclose (stream);
      return FALSE;
    }
  if (pr->commands.build)
    g_free (pr->commands.build);
  pr->commands.build = buff;

  if (read_string (stream, "Command_C_Compiler", &buff) == FALSE)
    {
      fclose (stream);
      return FALSE;
    }
  if (pr->commands.c_compiler)
    g_free (pr->commands.c_compiler);
  pr->commands.c_compiler = buff;

  if (read_string (stream, "Command_Cpp_Compiler", &buff) == FALSE)
    {
      fclose (stream);
      return FALSE;
    }
  if (pr->commands.cpp_compiler)
    g_free (pr->commands.cpp_compiler);
  pr->commands.cpp_compiler = buff;

  if (read_string (stream, "Command_Pixmap_Editor", &buff) == FALSE)
    {
      fclose (stream);
      return FALSE;
    }
  if (pr->commands.pixmap_editor)
    g_free (pr->commands.pixmap_editor);
  pr->commands.pixmap_editor = buff;

  if (read_string (stream, "Command_Terminal", &buff) == FALSE)
    {
      fclose (stream);
      return FALSE;
    }
  if (pr->commands.terminal)
    g_free (pr->commands.terminal);
  pr->commands.terminal = buff;

  if (read_string (stream, "Command_Browser", &buff) == FALSE)
    {
      fclose (stream);
      return FALSE;
    }
  if (pr->commands.browser)
    g_free (pr->commands.browser);
  pr->commands.browser = buff;

  /*
   * Page 2 
   */

  if (fscanf (stream, "%lu %lu %lu\n", &temp1, &temp2, &temp3) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  pr->plain_color.red = (guint16) temp1;
  pr->plain_color.blue = (guint16) temp2;
  pr->plain_color.green = (guint16) temp3;

  if (fscanf (stream, "%lu %lu %lu\n", &temp1, &temp2, &temp3) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  pr->comment_color.red = (guint16) temp1;
  pr->comment_color.blue = (guint16) temp2;
  pr->comment_color.green = (guint16) temp3;

  if (fscanf (stream, "%lu %lu %lu\n", &temp1, &temp2, &temp3) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  pr->string_color.red = (guint16) temp1;
  pr->string_color.blue = (guint16) temp2;
  pr->string_color.green = (guint16) temp3;

  if (fscanf (stream, "%lu %lu %lu\n", &temp1, &temp2, &temp3) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  pr->keywords_color.red = (guint16) temp1;
  pr->keywords_color.blue = (guint16) temp2;
  pr->keywords_color.green = (guint16) temp3;

  if (fscanf (stream, "%lu %lu %lu\n", &temp1, &temp2, &temp3) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  pr->back_color.red = (guint16) temp1;
  pr->back_color.blue = (guint16) temp2;
  pr->back_color.green = (guint16) temp3;

  /*
   * page 3 
   */

  if (fscanf (stream, "%d\n", &dummy) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (dummy)
    {
      if (read_string (stream, "Font", &buff) == FALSE)
	{
	  fclose (stream);
	  return FALSE;
	}

      font = gdk_font_load (buff);
      if (font)
	{
	  if (pr->font)
	    gdk_font_unref (pr->font);
	  pr->font = font;
	  if (pr->font_name)
	    g_free (pr->font_name);
	  pr->font_name = buff;
	  gtk_font_selection_set_font_name (GTK_FONT_SELECTION
					    (pr->widgets.fontselector),
					    pr->font_name);
	}
      else
	g_free (buff);
    }

  /*
   * page 4 
   */

  if (fscanf (stream, "%d\n", &dummy) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (dummy)
    {
      if (read_string (stream, "Print_Command", &buff) == FALSE)
	{
	  fclose (stream);
	  return FALSE;
	}
      if (pr->pr_command)
	g_free (pr->pr_command);
      pr->pr_command = g_strdup (buff);
      g_free (buff);
    }

  /*
   * Page 5 
   */

  if (fscanf (stream, "%d\n", &dummy) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  pr->format_disable = dummy;

  if (read_string (stream, "Format_Style", &buff) == FALSE)
    {
      fclose (stream);
      return FALSE;
    }
  if (pr->format_style)
    g_free (pr->format_style);
  pr->format_style = g_strdup (buff);
  g_free (buff);

  if (fscanf (stream, "%d\n", &dummy) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (dummy)
    {
      if (read_string (stream, "Custom_Style", &buff) == FALSE)
	{
	  fclose (stream);
	  return FALSE;
	}
      if (pr->custom_style)
	g_free (pr->custom_style);
      pr->custom_style = g_strdup (buff);
      g_free (buff);
    }

  /*
   * Page 6 
   */
  if (fscanf (stream, "%d\n", &pr->truncat_mesg) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fscanf (stream, "%d\n", &pr->mesg_first) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fscanf (stream, "%d\n", &pr->mesg_last) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fscanf (stream, "%d\n", &dummy) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  pr->tag_pos = (TagPos) dummy;
  if (fscanf (stream, "%d\n", &pr->no_tag) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fscanf (stream, "%d\n", &pr->tags_update) < 1)
    {
      fclose (stream);
      return FALSE;
    }

  if (fscanf (stream, "%d\n", &pr->win_pos_x) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  if (fscanf (stream, "%d\n", &pr->win_pos_y) < 1)
    {
      fclose (stream);
      return FALSE;
    }
  fclose (stream);
  anjuta_apply_preferences ();
  return TRUE;
}

void
on_preferences_set_default_yes_clicked (GtkButton * button,
					gpointer user_data)
{
  GtkWidget *wid;
  GdkColormap *cmap;

  Preferences *pr = (Preferences *) user_data;
  if (!pr)
    return;

  /*
   * Page 1 
   */

  pr->beep_on_build_complete = TRUE;
  pr->dialog_on_build_complete = FALSE;
  pr->check_dependencies = FALSE;
  pr->max_recent_prjs = 4;
  pr->max_recent_files = 12;
  pr->max_combo_histories = 8;
  pr->max_undo_histories = 10;
  pr->is_showing = FALSE;
  pr->win_pos_x = 100;
  pr->win_pos_y = 100;

  pr->auto_indent = TRUE;
  pr->auto_save = TRUE;
  pr->auto_save_timer = 10;
  pr->tab_size = 8;

  pr->auto_hilite = FALSE;
  pr->enable_hilite = TRUE;
  pr->lesser_hilite = FALSE;

  /*
   * page 2  
   */

  if (pr->commands.shell)
    g_free (pr->commands.shell);
  pr->commands.shell = g_strdup ("bash");

  if (pr->commands.build)
    g_free (pr->commands.build);
  pr->commands.build = g_strdup ("gmake");

  if (pr->commands.c_compiler)
    g_free (pr->commands.c_compiler);
  pr->commands.c_compiler = g_strdup ("gcc");

  if (pr->commands.cpp_compiler)
    g_free (pr->commands.cpp_compiler);
  pr->commands.cpp_compiler = g_strdup ("g++");

  if (pr->commands.pixmap_editor)
    g_free (pr->commands.pixmap_editor);
  pr->commands.pixmap_editor = g_strdup ("gimp");

  if (pr->commands.terminal)
    g_free (pr->commands.terminal);
  pr->commands.terminal = g_strdup ("gnome-terminal");

  if (pr->commands.browser)
    g_free (pr->commands.browser);
  pr->commands.browser = g_strdup ("gnome-help-browser");

  /*
   * page 3  
   */

  pr->plain_color.pixel = 0;
  pr->plain_color.red = 0;
  pr->plain_color.green = 0;
  pr->plain_color.blue = 0;

  pr->comment_color.pixel = 0;
  pr->comment_color.red = 65535;
  pr->comment_color.green = 0;
  pr->comment_color.blue = 0;

  pr->string_color.pixel = 0;
  pr->string_color.red = 65535;
  pr->string_color.green = 43908;
  pr->string_color.blue = 16383;

  pr->keywords_color.pixel = 0;
  pr->keywords_color.red = 0;
  pr->keywords_color.green = 0;
  pr->keywords_color.blue = 65535;

  wid = app->widgets.window;
  cmap = gtk_widget_get_colormap (wid);

  pr->back_color.pixel = 0;
  pr->back_color.red = 65535;
  pr->back_color.green = 65535;
  pr->back_color.blue = 65535;

  gdk_color_alloc (cmap, &(pr->plain_color));
  gdk_color_alloc (cmap, &(pr->comment_color));
  gdk_color_alloc (cmap, &(pr->string_color));
  gdk_color_alloc (cmap, &(pr->keywords_color));

  /*
   * page 3 
   */

  if (pr->font)
    gdk_font_unref (pr->font);
  pr->font = NULL;
  if (pr->font_name)
    g_free (pr->font_name);
  pr->font_name = NULL;
  gtk_font_selection_set_font_name (GTK_FONT_SELECTION
				    (pr->widgets.fontselector), "");
  anjuta_apply_preferences ();

  /*
   * page 4 
   */

  if (pr->pr_command)
    g_free (pr->pr_command);
  pr->pr_command = g_strdup ("lpr");

  /*
   * Page 5 
   */

  pr->format_disable = FALSE;
  if (pr->format_style)
    g_free (pr->format_style);
  pr->format_style = g_strdup ("Style of Kangleipak");
  if (pr->custom_style)
    g_free (pr->custom_style);
  pr->custom_style = g_strdup ("-i4 -bl -bls -bli0 -ss cbio0");

  /*
   * Page 6 
   */
  pr->truncat_mesg = FALSE;
  pr->mesg_first = 50;
  pr->mesg_last = 30;
  pr->tag_pos = TAG_POS_TOP;
  pr->no_tag = FALSE;
  pr->tags_update = TRUE;
}

gchar *
preferences_get_format_opts (Preferences * p)
{
  int i;
  for (i = 0;; i += 2)
    {
      if (format_style[i] == NULL)
	return NULL;
      if (strcmp (format_style[0], p->format_style) == 0)
	return p->custom_style;
      if (strcmp (format_style[i], p->format_style) == 0)
	return format_style[i + 1];
    }
  return NULL;
}
