/*
 * project_dbase_cbs.c
 * Copyright (C) 2000  Kh. Naba Kumar Singh
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>
#include "anjuta.h"
#include "project_dbase.h"
#include "project_dbase_cbs.h"
#include "utilities.h"
#include "messagebox.h"
#include "controls.h"
#include "support.h"

gint
on_project_dbase_win_delete_event (GtkWidget * w, GdkEvent * event,
				   gpointer data)
{
  ProjectDBase *p = data;
  project_dbase_hide (p);
  return TRUE;
}

void
on_project_dbase_remove_confirm_yes_clicked (GtkButton * button,
					     gpointer user_data)
{
  ProjectDBase *p;
  gchar *fn;
  GList *list;

  p = user_data;
  if( !p) return;
  if (p->cur_filename == NULL)
    return;

  list = p->src_files;
  while (list)
  {
    if (strcmp (p->cur_filename, (gchar *)list->data) == 0)
    {
      p->src_files =
	g_list_remove (p->src_files, list->data);
      project_dbase_update_tree (p);
      fn = anjuta_get_full_filename (p->cur_filename);
      tags_manager_remove (app->tags_manager, fn);
      g_free (fn);
      if (p->cur_filename)
      {
	g_free (p->cur_filename);
	p->cur_filename = NULL;
      }
      p->is_saved = FALSE;
      p->src_makefile_saved = FALSE;
      p->doc_makefile_saved = FALSE;
      project_dbase_save_project(p);
      return;
    }
    list = g_list_next(list);
  }

  list = p->doc_files;
  while (list)
  {
    if (strcmp (p->cur_filename, (gchar*)list->data) == 0)
    {
      p->doc_files =
	g_list_remove (p->doc_files, list->data);
      project_dbase_update_tree (p);
      if (p->cur_filename)
      {
	g_free (p->cur_filename);
	p->cur_filename = NULL;
      }
      p->is_saved = FALSE;
      p->doc_makefile_saved = FALSE;
      project_dbase_save_project(p);
      return;
    }
    list = g_list_next(list);
  }

  list = p->pix_files;
  while (list)
  {
    if (strcmp (p->cur_filename, (gchar*)list->data) == 0)
    {
      p->pix_files =
	g_list_remove (p->pix_files, list->data);
      project_dbase_update_tree (p);
      if (p->cur_filename)
      {
	g_free (p->cur_filename);
	p->cur_filename = NULL;
      }
      p->is_saved = FALSE;
      project_dbase_save_project(p);
      return;
    }
    list = g_list_next(list);
  }

  if (p->cur_filename)
  {
    g_free (p->cur_filename);
    p->cur_filename = NULL;
  }
}

void
on_project_dbase_clist_select_row (GtkCList * clist,
				   gint row,
				   gint column,
				   GdkEvent * event, gpointer user_data)
{
  GtkCTreeNode *node;
  ProjectDBase *p = user_data;

  if(!p) return;
  node = gtk_ctree_node_nth (GTK_CTREE (p->widgets.ctree), row);
  p->widgets.current_node = node;
  if (event == NULL) return;
  if (event->type != GDK_2BUTTON_PRESS) return;
  if (((GdkEventButton *) event)->button != 1) return;
  on_prj_view_src_activate (NULL, NULL);
}

void
on_open_prjfilesel_ok_clicked (GtkButton * button, gpointer user_data)
{
  ProjectDBase *p = app->project_dbase;
  if (p->project_is_open)
  {
    messagebox2 (GNOME_MESSAGE_BOX_WARNING,
		 _("There is already a project opened." \
		   "Do you want to close it first?"),
		 GNOME_STOCK_BUTTON_YES,
		 GNOME_STOCK_BUTTON_NO,
		 GTK_SIGNAL_FUNC (on_project_dbase_close_load_yes_clicked),
		 NULL, p);
    return;
  }
  gtk_widget_hide (p->fileselection_open);
  project_dbase_load_project (p);
}

void
on_open_prjfilesel_cancel_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_hide (app->project_dbase->fileselection_open);
}

void
on_add_prjfilesel_ok_clicked (GtkButton * button, gpointer user_data)
{
  gchar *filename, *dir, *comp_dir, *mesg;
  ProjectDBase *p = user_data;

  filename =
    gtk_file_selection_get_filename (GTK_FILE_SELECTION
				     (p->fileselection_add));
  if (file_is_regular(filename) == FALSE)
  {
      anjuta_error(_("This is not a regular file. I cannot add it to project."));
      return;
  }
  if (file_is_readable(filename) == FALSE)
  {
     anjuta_error (_("You have no read permission for this file"));
     return;
  }
  gtk_widget_hide (p->fileselection_add);
  dir = g_dirname (filename);
  switch (p->add_type)
  {
  case SOURCE:
    comp_dir = p->src_dir;
    mesg =
      g_strdup_printf (
        _("\"%s\"\ndoes not exist in the source directory.\nDo you want to IMPORT (ie copy) it?"),
		       filename);
    break;

  case DOCUMENT:
    comp_dir = p->doc_dir;
    mesg =
      g_strdup_printf (
         _("\"%s\"\ndoes not exist in the document directory.\nDo you want to IMPORT (ie copy) it?"),
		       filename);
    break;

  case PIXMAP:
    comp_dir = p->pix_dir;
    mesg =
      g_strdup_printf (_
		       ("\"%s\"\ndoes not exist in the pixmap directory.\nDo you want to IMPORT (ie. copy) it?"),
		       filename);
    break;

  case OTHER:
    comp_dir = p->top_proj_dir;
    g_free (dir);
    return;

  case DIRECTORY:
    comp_dir = p->top_proj_dir;
    g_free (dir);
    return;

  default:
    /*
     * This will not reach 
     */
    g_free (dir);
    return;
  }
  if (strcmp (dir, comp_dir) == 0)
    on_prj_import_confirm_yes (NULL, user_data);
  else
    messagebox2 (GNOME_MESSAGE_BOX_INFO, mesg,
		 GNOME_STOCK_BUTTON_YES,
		 GNOME_STOCK_BUTTON_NO,
		 on_prj_import_confirm_yes, NULL, user_data);
  g_free (dir);
  g_free (mesg);
}

void
on_prj_import_confirm_yes (GtkButton * button, gpointer user_data)
{
  gchar *filename, *dir, *comp_dir, *fn;
  GList **files, *list;
  ProjectDBase *p = user_data;

  gtk_widget_hide (p->fileselection_add);

  filename =
    gtk_file_selection_get_filename (GTK_FILE_SELECTION
				     (p->fileselection_add));
  dir = g_dirname (filename);
  switch (p->add_type)
  {
  case SOURCE:
    comp_dir = p->src_dir;
    files = &p->src_files;
    break;

  case DOCUMENT:
    comp_dir = p->doc_dir;
    files = &p->doc_files;
    break;

  case PIXMAP:
    comp_dir = p->pix_dir;
    files = &p->pix_files;
    break;

  case OTHER:
    comp_dir = p->top_proj_dir;
    g_free (dir);
    return;

  case DIRECTORY:
    comp_dir = p->top_proj_dir;
    g_free (dir);
    return;

  default:
    /*
     * This will not reach 
     */
    g_free (dir);
    return;
  }

  list = *files;
  while (list)
  {
    if (strcmp (extract_filename (filename), list->data) == 0)
    {
      /*
       * file has already been added. So skip with a message 
       */
      messagebox (GNOME_MESSAGE_BOX_INFO,
		  _("This file has already been added to the project."));
      g_free (dir);
      return;
    }
    list = g_list_next(list);
  }
  /*
   * File has not been added. So add it 
   */
  if (strcmp (dir, comp_dir) != 0)
  {
    /*
     * File does not exist in the corrospondig dir. So, import it. 
     */
    fn = g_strconcat (comp_dir, "/", extract_filename (filename), NULL);
    force_create_dir (comp_dir);
    if (!copy_file (filename, fn))
    {
      g_free (dir);
      g_free (fn);
      messagebox (GNOME_MESSAGE_BOX_INFO,
		  _("Error while copying the file inside the project."));
      return;
    }
    filename = fn;
  }
  else
    fn = g_strdup (filename);	/* Just to make the control flow easy */

  (*files) = g_list_insert_sorted ((*files),
				   g_strdup (extract_filename (filename)),
				   compare_string_func);
  p->is_saved = FALSE;
  if(p->add_type == SOURCE)
  {
    p->src_makefile_saved = FALSE;
    p->potfile_saved = FALSE;
  }
  else if (p->add_type == DOCUMENT)
  {
    p->doc_makefile_saved = FALSE;
  }
  project_dbase_update_tree (p);
  if (p->add_type == SOURCE && app->preferences->tags_update)
    tags_manager_update (app->tags_manager, filename);
  project_dbase_save_project (p);
  g_free (fn);
  g_free (dir);
  return;
}

void
on_add_prjfilesel_cancel_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_hide (app->project_dbase->fileselection_add);
}

void
on_project_dbase_close_load_yes_clicked (GtkButton * b, gpointer data)
{
  ProjectDBase *p = data;
  gtk_widget_hide (app->project_dbase->fileselection_open);
  project_dbase_close_project (p);
  project_dbase_load_project (p);
}

void
on_prj_add_src_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  ProjectDBase *p = app->project_dbase;
  p->add_type = SOURCE;
  gtk_window_set_title (GTK_WINDOW (p->fileselection_add),
			_("Select Source file to add"));
  gtk_widget_show (p->fileselection_add);
}


void
on_prj_add_doc_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  ProjectDBase *p = app->project_dbase;
  p->add_type = DOCUMENT;
  gtk_window_set_title (GTK_WINDOW (p->fileselection_add),
			_("Select Document file to add"));
  gtk_widget_show (p->fileselection_add);
}


void
on_prj_add_pix_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  ProjectDBase *p = app->project_dbase;
  p->add_type = PIXMAP;
  gtk_window_set_title (GTK_WINDOW (p->fileselection_add),
			_("Select Pixmap file to add"));
  gtk_widget_show (p->fileselection_add);
}


void
on_prj_add_other_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  ProjectDBase *p = app->project_dbase;
  p->add_type = OTHER;
  anjuta_not_implemented (__FILE__, __LINE__);
  return;
  gtk_window_set_title (GTK_WINDOW (p->fileselection_add),
			_("Select General file to add"));
  gtk_widget_show (p->fileselection_add);
}


void
on_prj_add_dir_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  ProjectDBase *p = app->project_dbase;
  anjuta_not_implemented (__FILE__, __LINE__);
  return;
  p->add_type = DIRECTORY;
  gtk_window_set_title (GTK_WINDOW (p->fileselection_add),
			_("Select Directory to add"));
  gtk_widget_show (p->fileselection_add);
}


void
on_prj_view_src_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gchar *filename, *full_filename;
  GdkPixmap *pixc, *pixo;
  GdkBitmap *maskc, *masko;
  gint8 space;
  gboolean is_leaf, expanded;

  ProjectDBase *p = app->project_dbase;
  gtk_ctree_get_node_info (GTK_CTREE (p->widgets.ctree),
			   p->widgets.current_node,
			   &filename, &space,
			   &pixc, &maskc, &pixo, &masko, &is_leaf, &expanded);
  if (is_leaf)
  {
    switch (get_file_ext_type (filename))
    {
    case FILE_EXT_TYPE_XPM:
    case FILE_EXT_TYPE_JPG:
    case FILE_EXT_TYPE_BMP:
    case FILE_EXT_TYPE_TIFF:
    case FILE_EXT_TYPE_GIF:
    case FILE_EXT_TYPE_PNG:
      full_filename = g_strconcat (p->pix_dir, "/", filename, NULL);
      anjuta_open_pixmap (full_filename);
      g_free (full_filename);
      break;
    default:
      anjuta_goto_file_line (filename, -1);
      break;
    }
  }
}


void
on_prj_remove_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gchar *filename;
  gchar *buff;
  GdkPixmap *pixc, *pixo;
  GdkBitmap *maskc, *masko;
  gint8 space;
  gboolean is_leaf, expanded;
  ProjectDBase *p = app->project_dbase;

  if (p->widgets.current_node == NULL)
    return;
  gtk_ctree_get_node_info (GTK_CTREE (p->widgets.ctree),
			   p->widgets.current_node,
			   &filename, &space,
			   &pixc, &maskc, &pixo, &masko, &is_leaf, &expanded);
  if (is_leaf == FALSE)
    return;
  if (p->cur_filename)
  {
    g_free (p->cur_filename);
    p->cur_filename = NULL;
  }
  p->cur_filename = g_strdup (filename);
  buff =
    g_strdup_printf (_
		     ("Are you sure you want to remove the item\n\"%s\" from the Project Data Base?"),
		     filename);
  messagebox2 (GNOME_MESSAGE_BOX_QUESTION, buff, GNOME_STOCK_BUTTON_YES,
	       GNOME_STOCK_BUTTON_NO,
	       on_project_dbase_remove_confirm_yes_clicked, NULL, p);
  g_free (buff);

}


void
on_prj_configure_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  anjuta_not_implemented (__FILE__, __LINE__);
}

void
on_prj_info_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  project_dbase_show_info (app->project_dbase);
}

void
on_prj_dock_undock_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  ProjectDBase *p = app->project_dbase;
  if (p->is_docked)
    project_dbase_undock (p);
  else
    project_dbase_dock (p);
}

void
on_prj_help_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}

gboolean
on_project_dbase_event (GtkWidget * widget,
			GdkEvent * event, gpointer user_data)
{
  GdkEventButton *bevent;
  ProjectDBase *pd = app->project_dbase;
  if (event->type != GDK_BUTTON_PRESS) return FALSE;
  if (((GdkEventButton *) event)->button != 3) return FALSE;
  bevent = (GdkEventButton *) event;
  bevent->button = 1;
  project_dbase_update_controls (pd);
  gtk_menu_popup (GTK_MENU (pd->widgets.menu), NULL,
    NULL, NULL, NULL, bevent->button, bevent->time);
  return TRUE;
}
