/*
    text_editor_gui.c
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>
#include "gtkaneditor.h"

#include "anjuta.h"
#include "text_editor_cbs.h"
#include "text_editor_gui.h"
#include "mainmenu_callbacks.h"
#include "pixmaps.h"
#include "support.h"

gint
on_text_editor_key_pressed(GtkWidget *widget, GdkEventKey *event, gpointer data);

void
create_text_editor_gui (TextEditor* te)
{
  GtkWidget *window1;
  GtkWidget *dock1;
  GtkWidget *dock_item1;
  GtkWidget *toolbar1;
  GtkWidget *tmp_toolbar_icon;
  GtkWidget *button1;
  GtkWidget *button2;
  GtkWidget *button3;
  GtkWidget *button5;
  GtkWidget *button6;
  GtkWidget *button7;
  GtkWidget *button8;
  GtkWidget *button9;
  GtkWidget *button10;
  GtkWidget *frame1;
  GtkWidget *hbox1;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *button11;
  GtkWidget *button12;
  GtkWidget *button14;
  GtkWidget *button13;
  GtkWidget *event_box1; 
  GtkWidget *scrolledwindow1;
  GtkWidget *editor1;

  window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize (window1, 200, 200);
  gtk_widget_set_uposition(window1, te->allocation.x, te->allocation.y);
  gtk_window_set_default_size(GTK_WINDOW(window1),
                    te->allocation.width, te->allocation.height);

  dock1 = gnome_dock_new ();
  gtk_widget_show (dock1);
  gtk_container_add (GTK_CONTAINER (window1), dock1);

  dock_item1 = gnome_dock_item_new("text_toolbar",
    GNOME_DOCK_ITEM_BEH_EXCLUSIVE | GNOME_DOCK_ITEM_BEH_NEVER_FLOATING);
  gtk_widget_show (dock_item1);
  gnome_dock_add_item(GNOME_DOCK(dock1), GNOME_DOCK_ITEM(dock_item1), GNOME_DOCK_TOP, 1, 1, 0, 0);
  gnome_dock_item_set_shadow_type(GNOME_DOCK_ITEM(dock_item1), GTK_SHADOW_OUT);
  gtk_container_set_border_width(GTK_CONTAINER(dock_item1), 2);

  toolbar1 = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (toolbar1);
  gtk_container_add (GTK_CONTAINER (dock_item1), toolbar1);
  gtk_toolbar_set_button_relief(GTK_TOOLBAR(toolbar1), GTK_RELIEF_NONE);
  gtk_toolbar_set_space_style(GTK_TOOLBAR(toolbar1), GTK_TOOLBAR_SPACE_LINE);

  tmp_toolbar_icon = create_pixmap (window1, ANJUTA_PIXMAP_NEW_FILE, FALSE);
  button1 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("New"),
                                _("New Text File"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button1);

  tmp_toolbar_icon = create_pixmap (window1, ANJUTA_PIXMAP_OPEN_FILE, FALSE);
  button2 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Open"),
                                _("Open Text File"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button2);

  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar1));

  tmp_toolbar_icon = create_pixmap (window1, ANJUTA_PIXMAP_SAVE_FILE, FALSE);
  button3 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Save"),
                                _("Save Current File"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button3);

  tmp_toolbar_icon = create_pixmap (window1, ANJUTA_PIXMAP_RELOAD_FILE, FALSE);
  button5 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Reload"),
                                _("Reload Current File"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button5);

  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar1));

  tmp_toolbar_icon = gnome_stock_pixmap_widget (window1, GNOME_STOCK_PIXMAP_CUT);
  button6 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Cut"),
                                _("Cut to clipboard"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button6);

  tmp_toolbar_icon = create_pixmap (window1, ANJUTA_PIXMAP_COPY, FALSE);
  button7 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Copy"),
                                _("Copy to clipboard"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button7);

  tmp_toolbar_icon = create_pixmap (window1, ANJUTA_PIXMAP_PASTE, FALSE);
  button8 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Paste"),
                                _("Paste from clipboard"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button8);

  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar1));

  tmp_toolbar_icon = create_pixmap (window1, ANJUTA_PIXMAP_SEARCH, FALSE);
  button9 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Find"),
                                _("Search the given string"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button9);

  tmp_toolbar_icon = create_pixmap (window1, ANJUTA_PIXMAP_FIND_REPLACE, FALSE);
  button10 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Replace"),
                                _("Search and replace the given string"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button10);

  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar1));

  frame1 = gtk_frame_new (NULL);
  gtk_widget_show (frame1);
  gtk_toolbar_append_widget (GTK_TOOLBAR (toolbar1), frame1, NULL, NULL);
  gtk_widget_set_usize (frame1, 117, -2);
  gtk_frame_set_shadow_type (GTK_FRAME (frame1), GTK_SHADOW_IN);
  gtk_container_set_border_width(GTK_CONTAINER(frame1), 2);
  gtk_widget_hide(frame1);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (frame1), hbox1);

  label1 = gtk_label_new (_("line: "));
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE, FALSE, 0);

  label2 = gtk_label_new (_("0"));
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (hbox1), label2, FALSE, FALSE, 0);

  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar1));

  tmp_toolbar_icon = create_pixmap (window1, ANJUTA_PIXMAP_COMPILE, FALSE);
  button11 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Compile"),
                                _("Compile the current file"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button11);

  tmp_toolbar_icon = create_pixmap (window1, ANJUTA_PIXMAP_BUILD, FALSE);
  button12 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Build"),
                                _("Build current File or Build the source directory of the Project"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button12);

  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar1));

  tmp_toolbar_icon = create_pixmap (window1, ANJUTA_PIXMAP_PRINT, FALSE);
  button14 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Print"),
                                _("Print the current File"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button14);

  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar1));

  tmp_toolbar_icon = create_pixmap (window1, ANJUTA_PIXMAP_DOCK, FALSE);
  button13 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Attach"),
                                _("Attach the editor window as paged editor"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button13);

  frame1 = gtk_frame_new(NULL);
  gtk_widget_show(frame1);
  gnome_dock_set_client_area  (GNOME_DOCK (dock1), frame1);
  gtk_frame_set_shadow_type (GTK_FRAME (frame1), GTK_SHADOW_OUT);

  event_box1 = gtk_event_box_new();
  gtk_widget_show (event_box1);
  gtk_container_add  (GTK_CONTAINER (frame1), event_box1);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_container_add(GTK_CONTAINER(event_box1), scrolledwindow1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
     GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  editor1= gtk_aneditor_new (NULL, NULL);
  gtk_widget_show (editor1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), editor1);
  GTK_ANEDITOR(editor1)->one_line_ind = FALSE;
  gtk_antext_set_editable(GTK_ANTEXT(editor1), TRUE);
  gtk_antext_set_line_wrap(GTK_ANTEXT(editor1), FALSE);
  gtk_antext_set_word_wrap(GTK_ANTEXT(editor1), FALSE);

  gtk_accel_group_attach(app->accel_group, GTK_OBJECT(window1));

  gtk_signal_connect (GTK_OBJECT (window1), "realize",
                      GTK_SIGNAL_FUNC (on_text_editor_window_realize),
                      te);
  gtk_signal_connect (GTK_OBJECT (window1), "size_allocate",
                      GTK_SIGNAL_FUNC (on_text_editor_window_size_allocate),
                      te);
  gtk_signal_connect (GTK_OBJECT (button1), "clicked",
                      GTK_SIGNAL_FUNC (on_new_file1_activate),
                      te);
  gtk_signal_connect (GTK_OBJECT (button2), "clicked",
                      GTK_SIGNAL_FUNC (on_open1_activate),
                      te);
  gtk_signal_connect (GTK_OBJECT (button3), "clicked",
                      GTK_SIGNAL_FUNC (on_save1_activate),
                      te);
  gtk_signal_connect (GTK_OBJECT (button5), "clicked",
                      GTK_SIGNAL_FUNC (on_reload_file1_activate),
                      te);
  gtk_signal_connect (GTK_OBJECT (button6), "clicked",
                      GTK_SIGNAL_FUNC (on_cut1_activate),
                      te);
  gtk_signal_connect (GTK_OBJECT (button7), "clicked",
                      GTK_SIGNAL_FUNC (on_copy1_activate),
                      te);
  gtk_signal_connect (GTK_OBJECT (button8), "clicked",
                      GTK_SIGNAL_FUNC (on_paste1_activate),
                      te);
  gtk_signal_connect (GTK_OBJECT (button9), "clicked",
                      GTK_SIGNAL_FUNC (on_find1_activate),
                      te);
  gtk_signal_connect (GTK_OBJECT (button10), "clicked",
                      GTK_SIGNAL_FUNC (on_find_and_replace1_activate),
                      te);
  gtk_signal_connect (GTK_OBJECT (button11), "clicked",
                      GTK_SIGNAL_FUNC (on_compile1_activate),
                      te);
  gtk_signal_connect (GTK_OBJECT (button12), "clicked",
                      GTK_SIGNAL_FUNC (on_build_project1_activate),
                      te);
  gtk_signal_connect (GTK_OBJECT (button14), "clicked",
                      GTK_SIGNAL_FUNC (on_print1_activate),
                      te);
  gtk_signal_connect (GTK_OBJECT (button13), "clicked",
                      GTK_SIGNAL_FUNC (on_text_editor_dock_activate),
                      te);
  gtk_signal_connect (GTK_OBJECT (scrolledwindow1), "realize",
                      GTK_SIGNAL_FUNC (on_text_editor_client_realize),
                      te);

/***************************************************************************/
   gtk_signal_connect (GTK_OBJECT (window1), "focus_in_event",
                      GTK_SIGNAL_FUNC (on_text_editor_window_focus_in_event),
                      te);
   gtk_signal_connect (GTK_OBJECT (editor1), "button_press_event",
                      GTK_SIGNAL_FUNC (on_text_editor_text_buttonpress_event),
                      te);
   gtk_signal_connect (GTK_OBJECT (editor1), "event",
                      GTK_SIGNAL_FUNC (on_text_editor_text_event),
                      te);
  gtk_signal_connect (GTK_OBJECT (window1), "delete_event",
                      GTK_SIGNAL_FUNC (on_text_editor_window_delete),
                      NULL);

   te->insert_signal_id = gtk_signal_connect (GTK_OBJECT (editor1), "insert_text",
                      GTK_SIGNAL_FUNC (on_text_editor_insert_text),
                      te);

   gtk_signal_connect_after (GTK_OBJECT (editor1), "insert_text",
			    GTK_SIGNAL_FUNC (on_text_editor_insert_text_after), te);

   te->delete_signal_id = gtk_signal_connect (GTK_OBJECT (editor1), "delete_text",
                      GTK_SIGNAL_FUNC (on_text_editor_delete_text),
                      te);
   gtk_signal_connect (GTK_OBJECT (editor1), "changed",
                      GTK_SIGNAL_FUNC (on_text_editor_text_changed),
                      te);

  te->widgets.window = window1;
  te->widgets.client_area = event_box1;
  te->widgets.client = scrolledwindow1;
  te->widgets.editor = editor1;
  te->widgets.line_label = label2;

  te->buttons.new = button1;
  te->buttons.open = button2;
  te->buttons.save = button3;
  te->buttons.reload = button5;
  te->buttons.cut = button6;
  te->buttons.copy = button7;
  te->buttons.paste = button8;
  te->buttons.find = button9;
  te->buttons.replace = button10;
  te->buttons.compile = button11;
  te->buttons.build = button12;
  te->buttons.print = button14;
  te->buttons.attach = button13;

  gtk_widget_ref(  te->buttons.new); 
  gtk_widget_ref(  te->buttons.new);
  gtk_widget_ref(  te->buttons.open);
  gtk_widget_ref(  te->buttons.save);
  gtk_widget_ref(  te->buttons.reload);
  gtk_widget_ref(  te->buttons.cut);
  gtk_widget_ref(  te->buttons.copy);
  gtk_widget_ref(  te->buttons.paste);
  gtk_widget_ref(  te->buttons.find);
  gtk_widget_ref(  te->buttons.replace);
  gtk_widget_ref(  te->buttons.compile);
  gtk_widget_ref(  te->buttons.build);
  gtk_widget_ref(  te->buttons.print);
  gtk_widget_ref(  te->buttons.attach);

  gtk_widget_ref(te->widgets.window);
  gtk_widget_ref(te->widgets.client_area);
  gtk_widget_ref(te->widgets.client);
  gtk_widget_ref(te->widgets.line_label);
  gtk_widget_ref(te->widgets.editor);
}

