/*
    anjuta_cbs.c
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>

#include <gnome.h>

#include "text_editor.h"
#include "anjuta.h"
#include "controls.h"
#include "fileselection.h"
#include "utilities.h"
#include "support.h"
#include "messagebox.h"
#include "launcher.h"
#include "debugger.h"

extern gboolean closing_state;

gint
on_anjuta_delete (GtkWidget * w, GdkEvent * event, gpointer data)
{
  TextEditor *te;
  GList *list;

  if (!app)
    return TRUE;
  anjuta_save_settings ();
  list = app->text_editor_list;
  while (list)
  {
    te = list->data;
    if (te->status == TEXT_EDITOR_NOT_SAVED)
    {
      messagebox2 (GNOME_MESSAGE_BOX_QUESTION,
		   _("Some files are not saved. Do you still want to exit?"),
		   GNOME_STOCK_BUTTON_YES,
		   GNOME_STOCK_BUTTON_NO,
		   GTK_SIGNAL_FUNC (on_anjuta_exit_yes_clicked), NULL, NULL);
      return TRUE;
    }
    list = g_list_next (list);
  }
  on_anjuta_exit_yes_clicked ( NULL, NULL);
  return TRUE;
}

void
on_anjuta_exit_yes_clicked (GtkButton * b, gpointer data)
{
  project_dbase_close_project(app->project_dbase);
  debugger_stop();
  anjuta_clean_exit ();
}

void
on_anjuta_destroy (GtkWidget * w, gpointer data)
{

}

void
on_anjuta_notebook_switch_page (GtkNotebook * notebook,
				GtkNotebookPage * page,
				gint page_num, gpointer user_data)
{
  anjuta_grab_text_focus (page_num);
}

void
on_open_filesel_ok_clicked (GtkButton * button, gpointer user_data)
{
  gchar *full_filename;
  full_filename =
    gtk_file_selection_get_filename (GTK_FILE_SELECTION (app->fileselection));
  if (strlen (extract_filename (full_filename)) == 0)
    return;
  if (file_is_regular(full_filename) == FALSE)
  {
      anjuta_error(_("This is not a regular file. I cannot open it."));
      return;
  }
  if (file_is_readable(full_filename) == FALSE)
  {
     anjuta_error (_("You have no read permission for this file"));
     return;
  }
  anjuta_goto_file_line (full_filename, -1);
  gtk_widget_hide (app->fileselection);
}

void
on_open_filesel_cancel_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_hide (app->fileselection);
}

void
on_save_as_filesel_ok_clicked (GtkButton * button, gpointer user_data)
{
  FILE *fp;
  gchar *filename, *buff;

  filename =
    gtk_file_selection_get_filename (GTK_FILE_SELECTION
				     (app->save_as_fileselection));
  if ((fp = fopen (filename, "r")) != NULL)
  {
    fclose (fp);
    buff =
      g_strdup_printf (_
		       ("The file \"%s\" already exist.\nDo you want to overwrite it?."),
		       filename);
    messagebox2 (GNOME_MESSAGE_BOX_QUESTION, buff, GNOME_STOCK_BUTTON_YES,
		 GNOME_STOCK_BUTTON_NO,
		 GTK_SIGNAL_FUNC (on_save_as_overwrite_yes_clicked), NULL,
		 user_data);
    g_free (buff);
  }
  else
    on_save_as_overwrite_yes_clicked (NULL, user_data);
}

void
on_save_as_overwrite_yes_clicked (GtkButton * button, gpointer user_data)
{
  TextEditor *te;
  gchar *full_filename;
  gint page_num;
  GtkWidget *child;

  full_filename =
    gtk_file_selection_get_filename (GTK_FILE_SELECTION
				     (app->save_as_fileselection));
  if (strlen (extract_filename (full_filename)) == 0)
    return;

  te = anjuta_get_current_text_editor ();
  if (!te)
    return;

  if (te->filename)
  {
    g_free (te->filename);
    te->filename = NULL;
  }
  if (te->full_filename)
  {
    if (app->project_dbase->project_is_open == FALSE)
      tags_manager_remove (app->tags_manager, te->full_filename);
    g_free (te->full_filename);
    te->full_filename = NULL;
  }
  te->full_filename = g_strdup (full_filename);
  te->filename = g_strdup (extract_filename (full_filename));
  text_editor_save_file (te);
  gtk_widget_hide (app->save_as_fileselection);
  if (closing_state)
  {
    anjuta_remove_current_text_editor ();
    closing_state = FALSE;
  }
  page_num =
    gtk_notebook_get_current_page (GTK_NOTEBOOK (app->widgets.notebook));
  child =
    gtk_notebook_get_nth_page (GTK_NOTEBOOK (app->widgets.notebook),
			       page_num);
  gtk_notebook_set_tab_label_text (GTK_NOTEBOOK (app->widgets.notebook),
				   child,
				   anjuta_get_notebook_text_editor
				   (page_num)->filename);
  anjuta_update_title ();
}

gboolean
on_anjuta_window_focus_in_event (GtkWidget * widget,
				 GdkEventFocus * event, gpointer user_data)
{
  gint page_num;

  if (g_list_length (GTK_NOTEBOOK (app->widgets.notebook)->children) > 0)
  {
    page_num =
      gtk_notebook_get_current_page (GTK_NOTEBOOK (app->widgets.notebook));
    if (page_num >= 0)
      app->current_text_editor = anjuta_get_notebook_text_editor (page_num);
  }
  else
    app->current_text_editor = NULL;
  main_toolbar_update ();
  extended_toolbar_update ();
  return FALSE;
}

void
on_save_as_filesel_cancel_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_hide (app->save_as_fileselection);
  closing_state = FALSE;
}

void
on_prj_list_undock_button_clicked (GtkButton * button, gpointer user_data)
{
  project_dbase_undock (app->project_dbase);
}


void
on_prj_list_hide_button_clicked (GtkButton * button, gpointer user_data)
{
  project_dbase_hide (app->project_dbase);
}


void
on_mesg_win_hide_button_clicked (GtkButton * button, gpointer user_data)
{
  messages_hide (app->messages);
}


void
on_mesg_win_undock_button_clicked (GtkButton * button, gpointer user_data)
{
  messages_undock (app->messages);
}

void
on_anjuta_progress_cancel (gpointer data)
{
  app->in_progress = FALSE;
  app->progress_cancel_cb (data);
  return;
}

gdouble on_anjuta_progress_cb (gpointer data)
{
  return (app->progress_value);
}
