/*
    appwidz_page2.c
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>

#include "support.h"
#include "appwidzard.h"

static gchar *app_group[] = 
{
  "Applications", "Games", "Graphics", "Internet", "Multimedia",
  "System", "Settings", "Utilities", "Development", "Networking",
  NULL
};

static void
on_c_lang_radiobutton_toggled (GtkToggleButton * togglebutton,
			       gpointer user_data)
{
  AppWidzard *aw = user_data;
  aw->language = c;
}


static void
on_cpp_lang_radiobutton_toggled (GtkToggleButton * togglebutton,
				 gpointer user_data)
{
  AppWidzard *aw = user_data;
  aw->language = cpp;
}

static void
on_gpl_checkbutton_toggled (GtkToggleButton * tb, gpointer user_data)
{
  AppWidzard *aw = user_data;
  aw->use_header = gtk_toggle_button_get_active (tb);
}

static void
on_menu_entry_changed              (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gchar *text;
  AppWidzard* aw = user_data;
  text = gtk_entry_get_text(GTK_ENTRY(editable));
  if(strlen(text) == 0)
  {
     if(aw->menu_entry) 
     {
        g_free(aw->menu_entry);
        aw->menu_entry = NULL;
        return;
      }
      return;
  }
  if(aw->menu_entry) g_free(aw->menu_entry);
  aw->menu_entry = g_strdup(text);
}

static void
on_app_group_entry_changed              (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gchar *text;
  AppWidzard* aw = user_data;
  text = gtk_entry_get_text(GTK_ENTRY(editable));
  if(aw->app_group) g_free(aw->app_group);
  aw->app_group = g_strdup(text);
}

static void
on_menu_entry_realize              (GtkWidget       *widget,
                                        gpointer         user_data)
{

}

static void
on_menu_comment_entry_changed              (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gchar *text;
  AppWidzard* aw = user_data;
  text = gtk_entry_get_text(GTK_ENTRY(editable));
  if(strlen(text) == 0)
  {
     if(aw->menu_comment) 
     {
        g_free(aw->menu_comment);
        aw->menu_comment = NULL;
        return;
      }
      return;
  }
  if(aw->menu_comment) g_free(aw->menu_comment);
  aw->menu_comment = g_strdup(text);
}

static void
on_menu_comment_entry_realize              (GtkWidget       *widget,
                                        gpointer         user_data)
{

}

static void
on_need_term_checkbutton_toggled (GtkToggleButton * tb, gpointer user_data)
{
  AppWidzard *aw = user_data;
  aw->need_terminal = gtk_toggle_button_get_active (tb);
}

static void
on_gettext_support_checkbutton_toggled (GtkToggleButton * togglebutton,
					gpointer user_data)
{
  AppWidzard *aw;
  aw = user_data;
  aw->gettext_support = gtk_toggle_button_get_active (togglebutton);
}


void
create_app_widzard_page3 (AppWidzard * aw)
{
  GtkWidget *window3;
  GtkWidget *frame;
  GtkWidget *vbox5;
  GtkWidget *hbox1;
  GtkWidget *vbox1;
  GtkWidget *vbox2;

  GtkWidget *frame4;
  GSList *hbox1_group = NULL;
  GtkWidget *c_lang_radiobutton;
  GtkWidget *cpp_lang_radiobutton;
  GtkWidget *gpl_checkbutton;
  GtkWidget *gettext_support_checkbutton;

  GtkWidget *frame1;
  GtkWidget *table1;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *label3;
  GtkWidget *entry1;
  GtkWidget *entry2;
  GtkWidget *combo1;
  GtkWidget *combo_entry1;
  GtkWidget *iconentry1;
  GtkWidget *checkbutton1;
  GtkWidget *druid_vbox3;
  GList *list;
  gint i;

  window3 = aw->widgets.window;

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  druid_vbox3 = GNOME_DRUID_PAGE_STANDARD (aw->widgets.page[3])->vbox;
  gtk_box_pack_start (GTK_BOX (druid_vbox3), frame, TRUE, TRUE, 0);

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox5);
  gtk_container_add (GTK_CONTAINER (frame), vbox5);

  frame4 = gtk_frame_new (NULL);
  gtk_widget_show (frame4);
  gtk_container_add (GTK_CONTAINER (vbox5), frame4);
  gtk_container_set_border_width (GTK_CONTAINER (frame4), 5);
  gtk_frame_set_shadow_type (GTK_FRAME (frame4), GTK_SHADOW_IN);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (frame4), vbox1);

  frame = gtk_frame_new (_(" Programming language "));
  gtk_widget_show (frame);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
  gtk_box_pack_start (GTK_BOX (vbox1), frame, TRUE, TRUE, 0);

  hbox1 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (frame), hbox1);

  c_lang_radiobutton = gtk_radio_button_new_with_label (hbox1_group, _("C"));
  hbox1_group =
    gtk_radio_button_group (GTK_RADIO_BUTTON (c_lang_radiobutton));
  gtk_widget_show (c_lang_radiobutton);
  gtk_box_pack_start (GTK_BOX (hbox1), c_lang_radiobutton, TRUE, TRUE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (c_lang_radiobutton), TRUE);


  cpp_lang_radiobutton =
    gtk_radio_button_new_with_label (hbox1_group, _("C++"));
  hbox1_group =
    gtk_radio_button_group (GTK_RADIO_BUTTON (cpp_lang_radiobutton));

/** No C++ Templetes **/
  gtk_widget_set_sensitive (cpp_lang_radiobutton, FALSE);
  gtk_widget_show (cpp_lang_radiobutton);
  gtk_box_pack_start (GTK_BOX (hbox1), cpp_lang_radiobutton, TRUE, TRUE, 0);

  frame = gtk_frame_new (_(" Project Options "));
  gtk_widget_show (frame);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
  gtk_box_pack_start (GTK_BOX (vbox1), frame, TRUE, TRUE, 0);

  vbox2 = gtk_vbox_new(FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);

  gpl_checkbutton =
    gtk_check_button_new_with_label (_("Include GNU Copyright statement in files heading"));
  gtk_widget_show (gpl_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox2), gpl_checkbutton, TRUE, TRUE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gpl_checkbutton), TRUE);

  gettext_support_checkbutton =
    gtk_check_button_new_with_label (_("Gettext Support Enable"));
  gtk_widget_show (gettext_support_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox2), gettext_support_checkbutton, TRUE, TRUE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				(gettext_support_checkbutton), TRUE);

  frame1 = gtk_frame_new (_(" Gnome Menu Entry"));
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox1), frame1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);

  table1 = gtk_table_new (3, 3, FALSE);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (frame1), table1);
  gtk_container_set_border_width (GTK_CONTAINER (table1), 5);

  label1 = gtk_label_new (_("Entry name:"));
  gtk_widget_show (label1);
  gtk_table_attach (GTK_TABLE (table1), label1, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label1), 5, 0);

  label2 = gtk_label_new (_("Comment:"));
  gtk_widget_show (label2);
  gtk_table_attach (GTK_TABLE (table1), label2, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label2), 5, 0);

  label3 = gtk_label_new (_("Group:"));
  gtk_widget_show (label3);
  gtk_table_attach (GTK_TABLE (table1), label3, 0, 1, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label3), 5, 0);

  entry1 = gtk_entry_new ();
  gtk_widget_show (entry1);
  gtk_table_attach (GTK_TABLE (table1), entry1, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  entry2 = gtk_entry_new ();
  gtk_widget_show (entry2);
  gtk_table_attach (GTK_TABLE (table1), entry2, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  combo1 = gtk_combo_new ();
  gtk_widget_show (combo1);
  gtk_table_attach (GTK_TABLE (table1), combo1, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  combo_entry1 = GTK_COMBO(combo1)->entry;
  gtk_entry_set_editable(GTK_ENTRY(combo_entry1), FALSE);

  list = NULL;
  i = 0;
  while (app_group[i])
    list = g_list_append (list, app_group[i++]);
  gtk_combo_set_popdown_strings (GTK_COMBO (combo1), list);
  g_list_free (list);

  iconentry1 = gnome_icon_entry_new (NULL, "Anjuta: Application Icon");
  gtk_widget_show (iconentry1);
  gtk_table_attach (GTK_TABLE (table1), iconentry1, 2, 3, 0, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  checkbutton1 = gtk_check_button_new_with_label (_("Needs terminal"));
  gtk_widget_show (checkbutton1);
  gtk_table_attach (GTK_TABLE (table1), checkbutton1, 2, 3, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width(GTK_CONTAINER(checkbutton1), 5);

  gtk_signal_connect (GTK_OBJECT (c_lang_radiobutton), "toggled",
		      GTK_SIGNAL_FUNC (on_c_lang_radiobutton_toggled), aw);
  gtk_signal_connect (GTK_OBJECT (cpp_lang_radiobutton), "toggled",
		      GTK_SIGNAL_FUNC (on_cpp_lang_radiobutton_toggled), aw);
  gtk_signal_connect (GTK_OBJECT (gpl_checkbutton), "toggled",
		      GTK_SIGNAL_FUNC (on_gpl_checkbutton_toggled), aw);
  gtk_signal_connect (GTK_OBJECT (gettext_support_checkbutton), "toggled",
		      GTK_SIGNAL_FUNC
		      (on_gettext_support_checkbutton_toggled), aw);

  gtk_signal_connect (GTK_OBJECT (entry1), "changed",
                      GTK_SIGNAL_FUNC (on_menu_entry_changed),
                      aw);
  gtk_signal_connect (GTK_OBJECT (entry1), "realize",
                      GTK_SIGNAL_FUNC (on_menu_entry_realize),
                      aw);
  gtk_signal_connect (GTK_OBJECT (entry2), "changed",
                      GTK_SIGNAL_FUNC (on_menu_comment_entry_changed),
                      aw);
  gtk_signal_connect (GTK_OBJECT (entry2), "realize",
                      GTK_SIGNAL_FUNC (on_menu_comment_entry_realize),
                      aw);
  gtk_signal_connect (GTK_OBJECT (combo_entry1), "changed",
                      GTK_SIGNAL_FUNC (on_app_group_entry_changed),
                      aw);
  gtk_signal_connect (GTK_OBJECT (checkbutton1), "toggled",
		      GTK_SIGNAL_FUNC(on_need_term_checkbutton_toggled), aw);

  aw->widgets.lang_c_radio  = c_lang_radiobutton;
  gtk_widget_ref(c_lang_radiobutton);
  aw->widgets.lang_cpp_radio  = cpp_lang_radiobutton;
  gtk_widget_ref(cpp_lang_radiobutton);
  aw->widgets.gettext_support_check  = gettext_support_checkbutton;
  gtk_widget_ref(gettext_support_checkbutton);
  aw->widgets.file_header_check  = gpl_checkbutton;
  gtk_widget_ref(gpl_checkbutton);
  aw->widgets.menu_entry_entry  = entry1;
  gtk_widget_ref(entry1);
  aw->widgets.menu_comment_entry  = entry2;
  gtk_widget_ref(entry2);
  aw->widgets.icon_entry  = iconentry1;
  gtk_widget_ref(iconentry1);
  aw->widgets.app_group_combo  = combo1;
  gtk_widget_ref(combo1);
  aw->widgets.app_group_entry  = combo_entry1;
  gtk_widget_ref(combo_entry1);

  aw->widgets.term_check  = checkbutton1;
  gtk_widget_ref(checkbutton1);
}
