/*
    appwidzard.c
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>

#include <gnome.h>

#include "anjuta.h"
#include "messagebox.h"
#include "support.h"
#include "appwidzard.h"


AppWidzard *
app_widzard_new (void)
{
  AppWidzard *aw = g_malloc (sizeof (AppWidzard));
  if (aw)
  {
    aw->prj_name = NULL;
    aw->prog_name = NULL;
    aw->author = g_strdup (getenv ("USER"));
    aw->version = g_strdup ("0.1");
    aw->src_dir_name = g_strdup ("src/");
    aw->pix_dir_name = g_strdup ("pixmaps/");
    aw->doc_dir_name = g_strdup ("doc/");
    aw->type = gnome_full;
    aw->language = c;
    aw->gettext_support = TRUE;
    aw->need_terminal = FALSE;
    aw->cur_page = 0;
    aw->menu_entry = NULL;
    aw->menu_comment = NULL;
    aw->icon_file = NULL;
    aw->app_group = g_strdup ("Applications");
    aw->use_header = TRUE;

    create_app_widzard_gui (aw);
    create_app_widzard_page1 (aw);
    create_app_widzard_page2 (aw);
    create_app_widzard_page3 (aw);
  }
  return aw;
}

void
app_widzard_proceed (void)
{
  AppWidzard *aw;

  if (anjuta_is_installed (app->preferences->commands.shell, TRUE) == FALSE)
    return;
  if (anjuta_is_installed ("tar", TRUE) == FALSE)
    return;
  if (anjuta_is_installed ("anjuta_prjconf", TRUE) == FALSE)
    return;

  aw = app_widzard_new ();
  if (GTK_IS_WIDGET (aw->widgets.window))
    gtk_widget_show (aw->widgets.window);
}

void
app_widzard_destroy (AppWidzard * aw)
{
  if (aw)
  {
    gtk_widget_unref (aw->widgets.window);
    gtk_widget_unref (aw->widgets.druid);
    gtk_widget_unref (aw->widgets.page[4]);
    gtk_widget_unref (aw->widgets.prj_name_entry);
    gtk_widget_unref (aw->widgets.author_entry);
    gtk_widget_unref (aw->widgets.version_entry);
    gtk_widget_unref (aw->widgets.prog_name_entry);
    gtk_widget_unref (aw->widgets.src_dir_entry);
    gtk_widget_unref (aw->widgets.doc_dir_entry);
    gtk_widget_unref (aw->widgets.pix_dir_entry);
    gtk_widget_unref (aw->widgets.lang_c_radio);
    gtk_widget_unref (aw->widgets.lang_cpp_radio);
    gtk_widget_unref (aw->widgets.gettext_support_check);
    gtk_widget_unref (aw->widgets.file_header_check);
    gtk_widget_unref (aw->widgets.menu_entry_entry);
    gtk_widget_unref (aw->widgets.menu_comment_entry);
    gtk_widget_unref (aw->widgets.icon_entry);
    gtk_widget_unref (aw->widgets.app_group_combo);
    gtk_widget_unref (aw->widgets.app_group_entry);

    gtk_widget_unref (aw->widgets.term_check);

    if (GTK_IS_WIDGET (aw->widgets.window))
      gtk_widget_destroy (aw->widgets.window);
    if (aw->prj_name)
      g_free (aw->prj_name);
    if (aw->prog_name)
      g_free (aw->prog_name);
    if (aw->author)
      g_free (aw->author);
    if (aw->version)
      g_free (aw->version);
    if (aw->src_dir_name)
      g_free (aw->src_dir_name);
    if (aw->pix_dir_name)
      g_free (aw->pix_dir_name);
    if (aw->doc_dir_name)
      g_free (aw->doc_dir_name);
    if (aw->menu_entry)
      g_free (aw->menu_entry);
    if (aw->menu_comment)
      g_free (aw->menu_comment);
    if (aw->icon_file)
      g_free (aw->icon_file);
    if (aw->app_group)
      g_free (aw->app_group);

    g_free (aw);
  }
}
