/*
    build_project.c
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <string.h>
#include <time.h>

#include <gnome.h>
#include "anjuta.h"
#include "build_file.h"
#include "launcher.h"
#include "build_project.h"

void
build_project()
{
  gchar* tmp;
  if(app->project_dbase->project_is_open)
  {
     if (anjuta_is_installed (app->preferences->commands.build, TRUE) == FALSE)
           return;

     chdir(app->project_dbase->src_dir);
     tmp = compiler_options_get_build_command(app->compiler_options);
     if(launcher_execute(tmp,
                                       build_mesg_arrived,
                                       build_mesg_arrived,
                                       build_terminated) == FALSE){g_free(tmp); return;}
     g_free(tmp);
     messages_clear(app->messages, MESSAGE_BUILD);
     messages_append(app->messages, _("Building source directory of the project: "), MESSAGE_BUILD);
     messages_append(app->messages, app->project_dbase->proj_name, MESSAGE_BUILD);
     messages_append(app->messages, " ...\n", MESSAGE_BUILD);
     messages_show(app->messages, MESSAGE_BUILD);
   }
   else
   {
        /* Single file build */
        build_file();
   }
}

void
build_all_project()
{
  gchar* tmp;
  if(app->project_dbase->project_is_open)
  {
     if (anjuta_is_installed (app->preferences->commands.build, TRUE) == FALSE)
           return;

     chdir(app->project_dbase->top_proj_dir);
     tmp = compiler_options_get_build_command(app->compiler_options);

     if(launcher_execute(tmp,
                                       build_mesg_arrived,
                                       build_mesg_arrived,
                                       build_all_terminated) == FALSE){g_free(tmp); return;}
     g_free(tmp);
     messages_clear(app->messages, MESSAGE_BUILD);
     messages_append(app->messages, _("Building the project from top: "), MESSAGE_BUILD);
     messages_append(app->messages, app->project_dbase->proj_name, MESSAGE_BUILD);
     messages_append(app->messages, " ...\n", MESSAGE_BUILD);
     messages_show(app->messages, MESSAGE_BUILD);
   }
}

void
build_dist_project()
{
  gchar* tmp, *cmd_str;
  if(app->project_dbase->project_is_open)
  {
     if (anjuta_is_installed (app->preferences->commands.build, TRUE) == FALSE)
           return;

     chdir(app->project_dbase->top_proj_dir);
     tmp = compiler_options_get_build_command(app->compiler_options);
     cmd_str = g_strconcat(tmp, " dist", NULL);
     g_free(tmp);
     if(launcher_execute(cmd_str,
                                       build_mesg_arrived,
                                       build_mesg_arrived,
                                       build_dist_terminated) == FALSE){g_free(cmd_str); return;}
     g_free(cmd_str);
     messages_clear(app->messages, MESSAGE_BUILD);
     messages_append(app->messages, _("Building the distribution package of the project: "), MESSAGE_BUILD);
     messages_append(app->messages, app->project_dbase->proj_name, MESSAGE_BUILD);
     messages_append(app->messages, " ...\n", MESSAGE_BUILD);

     messages_show(app->messages, MESSAGE_BUILD);
   }
}

void
build_install_project()
{
  gchar* tmp, *cmd_str;
  if(app->project_dbase->project_is_open)
  {
     if (anjuta_is_installed (app->preferences->commands.build, TRUE) == FALSE)
           return;

     chdir(app->project_dbase->top_proj_dir);
     tmp = compiler_options_get_build_command(app->compiler_options);
     cmd_str = g_strconcat(tmp, " install", NULL);
     g_free(tmp);
     if(launcher_execute(cmd_str,
                                       build_mesg_arrived,
                                       build_mesg_arrived,
                                       build_install_terminated) == FALSE){g_free(cmd_str); return;}
     g_free(cmd_str);
     messages_clear(app->messages, MESSAGE_BUILD);
     messages_append(app->messages, _("Installing the project: "), MESSAGE_BUILD);
     messages_append(app->messages, app->project_dbase->proj_name, MESSAGE_BUILD);
     messages_append(app->messages, " ...\n", MESSAGE_BUILD);

     messages_show(app->messages, MESSAGE_BUILD);
   }
}

void
build_autogen_project()
{
  if(app->project_dbase->project_is_open)
  {
     chdir(app->project_dbase->top_proj_dir);
     if(file_is_executable("./autogen.sh"))
     {
         if(launcher_execute("./autogen.sh",
                                       build_mesg_arrived,
                                       build_mesg_arrived,
                                       build_autogen_terminated) == FALSE) return;
     }
     else
     {
         if (anjuta_is_installed ("automake", TRUE) == FALSE)
           return;
         if (anjuta_is_installed ("autoconf", TRUE) == FALSE)
           return;

         if(launcher_execute("automake;autoconf;./configure",
                                       build_mesg_arrived,
                                       build_mesg_arrived,
                                       build_autogen_terminated) == FALSE) return;
     }

     messages_clear(app->messages, MESSAGE_BUILD);
     messages_append(app->messages, _("Autogenerating the project: "), MESSAGE_BUILD);
     messages_append(app->messages, app->project_dbase->proj_name, MESSAGE_BUILD);
     messages_append(app->messages, " ...\n", MESSAGE_BUILD);

     messages_show(app->messages, MESSAGE_BUILD);
   }
}

void
build_mesg_arrived(gchar *mesg)
{
   messages_append(app->messages, mesg, MESSAGE_BUILD);
}

void
build_terminated(int status, time_t time)
{
    gchar  *buff1;
    
    if(WEXITSTATUS(status))
    {
       messages_append(app->messages, _("Build completed...............Unsuccessful\n"), MESSAGE_BUILD);
       anjuta_warning(_("Build terminated with error(s)."));
    }
    else
    {
       messages_append(app->messages, _("Build completed...............Successful\n"), MESSAGE_BUILD);
       anjuta_status(_("Build completed ... successful."));
    }
    buff1 = g_strdup_printf(_("Total time taken: %d secs\n"), (gint)time);
    messages_append(app->messages, buff1, MESSAGE_BUILD);
    gdk_beep();
}

void
build_all_terminated(int status, time_t time)
{
    gchar  *buff1;
    
    if(WEXITSTATUS(status))
    {
       messages_append(app->messages, _("Build all completed...............Unsuccessful\n"), MESSAGE_BUILD);
       anjuta_warning(_("Build all completed...............Unsuccessful"));
    }
    else
    {
       messages_append(app->messages, _("Build all completed...............Successful\n"), MESSAGE_BUILD);
       anjuta_status(_("Build all completed ... successful"));
    }
    buff1 = g_strdup_printf(_("Total time taken: %d secs\n"), (gint)time);
    messages_append(app->messages, buff1, MESSAGE_BUILD);
    gdk_beep();
    g_free(buff1);
}

void
build_dist_terminated(int status, time_t time)
{
    gchar  *buff1;
    
    if(WEXITSTATUS(status))
    {
       messages_append(app->messages, _("Build-Distribution completed...............Unsuccessful\n"), MESSAGE_BUILD);
       anjuta_warning(_("Build-Distribution completed ... unsuccessful"));
    }
    else
    {
       messages_append(app->messages, _("Build-Distribution completed...............Successful\n"), MESSAGE_BUILD);
       messages_append(app->messages, _("You will find the source tarball in the top level directory of the project\n"), MESSAGE_BUILD);
       anjuta_status(_("Build-Distribution completed ... successful"));
    }
    buff1 = g_strdup_printf(_("Total time taken: %d secs\n"), (gint)time);
    messages_append(app->messages, buff1, MESSAGE_BUILD);
    gdk_beep();
    g_free(buff1);
}

void
build_install_terminated(int status, time_t time)
{
    gchar  *buff1;
    
    if(WEXITSTATUS(status))
    {
       messages_append(app->messages, _("Install completed...............Unsuccessful\n"), MESSAGE_BUILD);
       anjuta_warning(_("Install completed...............Unsuccessful"));
    }
    else
    {
       messages_append(app->messages, _("Install completed...............Successful\n"), MESSAGE_BUILD);
       anjuta_status(_("Install completed ... successful"));
    }
    buff1 = g_strdup_printf(_("Total time taken: %d secs\n"), (gint)time);
    messages_append(app->messages, buff1, MESSAGE_BUILD);
    gdk_beep();
    g_free(buff1);
}

void
build_autogen_terminated(int status, time_t time)
{
    gchar  *buff1;
    
    if(WEXITSTATUS(status))
    {
       messages_append(app->messages, _("Autogenaration completed...............Unsuccessful\n"), MESSAGE_BUILD);
       anjuta_warning(_("Autogenaration completed ... unsuccessful"));
    }
    else
    {
       messages_append(app->messages, _("Autogenaration completed...............Successful\nNow Configure the Project.\n"), MESSAGE_BUILD);
       anjuta_status(_("Autogenaration completed ... successful"));
    }
    buff1 = g_strdup_printf(_("Total time taken: %d secs\n"), (gint)time);
    messages_append(app->messages, buff1, MESSAGE_BUILD);
    gdk_beep();
    g_free(buff1);
}
