/*
    configurer.h
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _CONFIGURER_H_
#define _CONFIGURER_H_

typedef struct _Configurer Configurer;

struct _Configurer
{
  gchar    *args;
  GList     *args_history;
  gboolean    overwrite;
};  

GtkWidget*
create_configurer_dialog(Configurer*);

Configurer*
configurer_new(void);

void
configurer_show(Configurer*);

/* Configurer is auto hide */

void
configurer_destroy(Configurer*);

/* private */

void
on_configurer_ok_clicked                  (GtkButton       *button,
                                        gpointer         user_data);

void
on_configurer_combo_realize              (GtkWidget       *widget,
                                        gpointer         user_data);

void
on_configurer_entry_changed              (GtkEditable     *editable,
                                        gpointer         user_data);

void
on_configurer_checkbutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data);

void
on_configurer_checkbutton_realize        (GtkWidget       *widget,
                                        gpointer         user_data);

void
conf_mesg_arrived(gchar *mesg);

void
conf_terminated(int status, time_t time);


#endif
