 /*
  * mainmenu_callbacks.c
  * Copyright (C) 2000  Kh. Naba Kumar Singh
  * 
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 2 of the License, or
  * (at your option) any later version.
  * 
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  * 
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <sched.h>
#include <wait.h>

#include <gnome.h>
#include "anjuta.h"
#include "about.h"
#include "text_editor.h"
#include "messagebox.h"
#include "mainmenu_callbacks.h"
#include "build_project.h"
#include "clean_project.h"
#include "preferences.h"
#include "compile.h"
#include "launcher.h"
#include "appwidzard.h"
#include "project_dbase.h"
#include "debugger.h"
#include "breakpoints_cbs.h"
#include "goto_line.h"
#include "support.h"
#include "project_dbase_cbs.h"
#include "executer.h"
#include "gtkantext.h"
#include "controls.h"
#include "signals_cbs.h"

gboolean closing_state;		//Do not temper with this variable 

void
on_new_file1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  anjuta_append_text_editor (NULL);
}


void
on_open1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_widget_show (app->fileselection);
}


void
on_save1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  TextEditor *te;

  te = anjuta_get_current_text_editor ();
  if (te == NULL)
    return;
  if (te->full_filename == NULL)
  {
    gtk_widget_show (app->save_as_fileselection);
    return;
  }
  text_editor_save_file (te);
  if (closing_state)
  {
    anjuta_remove_current_text_editor ();
    closing_state = FALSE;
  }
}


void
on_save_as1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  if (anjuta_get_current_text_editor () == NULL)
    return;
  gtk_widget_show (app->save_as_fileselection);
}

void
on_save_all1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  TextEditor *te;
  int i;
  tags_manager_freeze (app->tags_manager);
  for (i = 0; i < g_list_length (app->text_editor_list); i++)
  {
    te = g_list_nth_data (app->text_editor_list, i);
    if (te->full_filename && te->status == TEXT_EDITOR_NOT_SAVED)
      text_editor_save_file (te);
  }
  tags_manager_thaw (app->tags_manager);
  anjuta_status (_("All files saved ..."));
}

void
on_close_file1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  TextEditor *te;
  gchar mesg[256];

  te = anjuta_get_current_text_editor ();
  if (te == NULL)
    return;
  if (te->status == TEXT_EDITOR_NOT_SAVED)
  {
    closing_state = TRUE;
    sprintf (mesg,
	     _
	     ("The file \"%s\" is not saved.\nDo you want to save it before closing?"),
	     te->filename);

    messagebox3 (GNOME_MESSAGE_BOX_QUESTION, mesg,
		 GNOME_STOCK_BUTTON_YES,
		 GNOME_STOCK_BUTTON_NO,
		 GNOME_STOCK_BUTTON_CANCEL,
		 on_save1_activate,
		 on_save_on_close_no_clicked,
		 on_save_on_close_cancel_clicked, NULL);
  }
  else
    anjuta_remove_current_text_editor ();
}


void
on_reload_file1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  TextEditor *te;
  gchar mesg[256];

  te = anjuta_get_current_text_editor ();
  if (te == NULL)
    return;

  sprintf (mesg,
	   _
	   ("Are you sure you want to reload %s.\nYou will lose any unsaved modification."),
	   te->filename);

  messagebox2 (GNOME_MESSAGE_BOX_QUESTION, mesg,
	       GNOME_STOCK_BUTTON_YES,
	       GNOME_STOCK_BUTTON_NO, on_reload_yes_clicked, NULL, te);
}

void
on_new_project1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  app_widzard_proceed ();
}

void
on_open_project1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  project_dbase_open_project (app->project_dbase);
}

void
on_save_project1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  project_dbase_save_project (app->project_dbase);
}


void
on_close_project1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  project_dbase_close_project (app->project_dbase);
}


void
on_rename1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  anjuta_not_implemented (__FILE__, __LINE__);
}


void
on_page_setup1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (app->preferences->widgets.notebook),
			 4);
  preferences_show (app->preferences);
}

static void
on_print_confirm_yes_clicked (GtkButton * b, gpointer data)
{
  gchar *cmd, *str;
  pid_t pid;
  int status;
  TextEditor *te;
  te = anjuta_get_current_text_editor ();

  if (!te)
    return;
  cmd = g_strdup (app->preferences->pr_command);
  if (!cmd)
    return;

  if ((pid = fork ()) == 0)
  {
    execlp (cmd, cmd, te->full_filename, NULL);
    g_error (_("Cannot execute Print command"));
  }
  waitpid (pid, &status, 0);
  if (WEXITSTATUS (status))
  {
    str =
      g_strconcat (_
		   ("There was an error while printing.\nPrint command given was: "),
		   cmd, " ", te->full_filename, NULL);
    messagebox (GNOME_MESSAGE_BOX_ERROR, str);
    g_free (str);
  }
  else
    messagebox (GNOME_MESSAGE_BOX_INFO,
		_("The file has been sent for printing."));
  g_free (cmd);
}

void
on_print1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  TextEditor *te;
  te = anjuta_get_current_text_editor ();

  if (!te)
    return;
  if (te->full_filename == NULL || te->status == TEXT_EDITOR_NOT_SAVED)
  {
    messagebox (GNOME_MESSAGE_BOX_INFO,
		_("You must save the file first and then print"));
    return;
  }
  messagebox2 (GNOME_MESSAGE_BOX_QUESTION,
	       _("Are you sure you want to print the current file?"),
	       GNOME_STOCK_BUTTON_YES, GNOME_STOCK_BUTTON_NO,
	       on_print_confirm_yes_clicked, NULL, NULL);
}


void
on_file2_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
on_project1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  anjuta_not_implemented (__FILE__, __LINE__);
}


void
on_exit1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  if (on_anjuta_delete (NULL, NULL, NULL) == FALSE)
    on_anjuta_destroy (NULL, NULL);
}


void
on_undo1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  TextEditor *te;
  te = anjuta_get_current_text_editor ();
  if (te == NULL)
    return;
  text_editor_undo (te);
}


void
on_redo1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  TextEditor *te;
  te = anjuta_get_current_text_editor ();
  if (te == NULL)
    return;
  text_editor_redo (te);
}


void
on_cut1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_editable_cut_clipboard (GTK_EDITABLE (anjuta_get_current_text ()));
}


void
on_copy1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_editable_copy_clipboard (GTK_EDITABLE (anjuta_get_current_text ()));
}


void
on_paste1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_editable_paste_clipboard (GTK_EDITABLE (anjuta_get_current_text ()));
}


void
on_clear1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_editable_delete_selection (GTK_EDITABLE (anjuta_get_current_text ()));
}

void
on_select_all1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkAnText *text;
  text = anjuta_get_current_text ();
  gtk_editable_select_region (GTK_EDITABLE (text), 0,
			      gtk_antext_get_length (text));
}

void
on_find1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  find_text_show (app->find_replace->find_text);
}


void
on_find_in_files1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  find_in_files_show (app->find_in_files);
}


void
on_find_and_replace1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  find_replace_show (app->find_replace);
}


void
on_goto_line_no1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *gt;
  gt = create_goto_line_dialog ();
  gtk_widget_show (gt);
}

void
on_edit_app_gui1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  summon_glade ();
}

/***********************************************************************/

void
on_messages1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  messages_show (app->messages, MESSAGE_TYPE_END);
}

void
on_project_listing1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  project_dbase_show (app->project_dbase);
}

void
on_bookmarks1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  anjuta_not_implemented (__FILE__, __LINE__);
}

void
on_breakpoints1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  breakpoints_dbase_show (debugger.breakpoints_dbase);
}

void
on_watch_window1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  expr_watch_show (debugger.watch);
}


void
on_registers1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  cpu_registers_show (debugger.cpu_registers);
}


void
on_program_stack1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  stack_trace_show (debugger.stack);
}

void
on_shared_lib1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  sharedlibs_show (debugger.sharedlibs);
}

void
on_kernal_signals1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  signals_show (debugger.signals);
}

void
on_dump_window1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  anjuta_not_implemented (__FILE__, __LINE__);
}


void
on_console1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  anjuta_not_implemented (__FILE__, __LINE__);
}

/************************************************************************/

void
on_main_toolbar1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gboolean state;
  GtkWidget *dock;

  state = GTK_CHECK_MENU_ITEM (menuitem)->active;
  dock = GNOME_APP (app->widgets.window)->dock;
  if (dock == NULL)
    return;
  if (GTK_IS_WIDGET (dock) == FALSE)
    return;

  app->widgets.toolbar.main_toolbar.is_showing = state;
  if (state)
    gtk_widget_show (GTK_WIDGET (gnome_dock_get_item_by_name
				 (GNOME_DOCK (dock), "toolbar1", NULL, NULL,
				  NULL, NULL)));
  else
    gtk_widget_hide (GTK_WIDGET
		     (gnome_dock_get_item_by_name
		      (GNOME_DOCK (dock), "toolbar1", NULL, NULL, NULL,
		       NULL)));
}

void
on_extended_toolbar1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gboolean state;
  GtkWidget *dock;

  state = GTK_CHECK_MENU_ITEM (menuitem)->active;
  dock = GNOME_APP (app->widgets.window)->dock;
  if (dock == NULL)
    return;
  if (GTK_IS_WIDGET (dock) == FALSE)
    return;

  app->widgets.toolbar.extended_toolbar.is_showing = state;
  if (state)
    gtk_widget_show (GTK_WIDGET (gnome_dock_get_item_by_name
				 (GNOME_DOCK (dock), "toolbar2", NULL, NULL,
				  NULL, NULL)));
  else
    gtk_widget_hide (GTK_WIDGET
		     (gnome_dock_get_item_by_name
		      (GNOME_DOCK (dock), "toolbar2", NULL, NULL, NULL,
		       NULL)));
}

void
on_browser_toolbar1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gboolean state;
  GtkWidget *dock;

  state = GTK_CHECK_MENU_ITEM (menuitem)->active;
  dock = GNOME_APP (app->widgets.window)->dock;
  if (dock == NULL)
    return;
  if (GTK_IS_WIDGET (dock) == FALSE)
    return;

  app->widgets.toolbar.browser_toolbar.is_showing = state;
  if (state)
    gtk_widget_show (GTK_WIDGET (gnome_dock_get_item_by_name
				 (GNOME_DOCK (dock), "toolbar3", NULL, NULL,
				  NULL, NULL)));
  else
    gtk_widget_hide (GTK_WIDGET
		     (gnome_dock_get_item_by_name
		      (GNOME_DOCK (dock), "toolbar3", NULL, NULL, NULL,
		       NULL)));
}

void
on_debug_toolbar1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gboolean state;
  GtkWidget *dock;

  state = GTK_CHECK_MENU_ITEM (menuitem)->active;
  dock = GNOME_APP (app->widgets.window)->dock;
  if (dock == NULL)
    return;
  if (GTK_IS_WIDGET (dock) == FALSE)
    return;

  app->widgets.toolbar.debug_toolbar.is_showing = state;
  if (state)
    gtk_widget_show (GTK_WIDGET (gnome_dock_get_item_by_name
				 (GNOME_DOCK (dock), "toolbar4", NULL, NULL,
				  NULL, NULL)));
  else
    gtk_widget_hide (GTK_WIDGET
		     (gnome_dock_get_item_by_name
		      (GNOME_DOCK (dock), "toolbar4", NULL, NULL, NULL,
		       NULL)));
}

/*************************************************************************/
void
on_prj_add_src1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  on_prj_add_src_activate (NULL, NULL);
}

void
on_prj_add_pix1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  on_prj_add_pix_activate (NULL, NULL);
}

void
on_prj_add_doc1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  on_prj_add_doc_activate (NULL, NULL);
}

void
on_prj_add_gen1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  on_prj_add_other_activate (NULL, NULL);
}

void
on_prj_add_dir1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  on_prj_add_dir_activate (NULL, NULL);
}

void
on_prj_remove1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  on_prj_remove_activate (NULL, NULL);
}

void
on_prj_readme1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gchar *filename;
  if (app->project_dbase->project_is_open == FALSE)
    return;
  filename = g_strconcat (app->project_dbase->top_proj_dir, "/README", NULL);
  anjuta_append_text_editor (filename);
  g_free (filename);
}

void
on_prj_todo1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gchar *filename;
  if (app->project_dbase->project_is_open == FALSE)
    return;
  filename = g_strconcat (app->project_dbase->top_proj_dir, "/TODO", NULL);
  anjuta_append_text_editor (filename);
  g_free (filename);
}

void
on_prj_changelog1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gchar *filename;
  if (app->project_dbase->project_is_open == FALSE)
    return;
  filename =
    g_strconcat (app->project_dbase->top_proj_dir, "/ChangeLog", NULL);
  anjuta_append_text_editor (filename);
  g_free (filename);
}

void
on_prj_news1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gchar *filename;
  if (app->project_dbase->project_is_open == FALSE)
    return;
  filename = g_strconcat (app->project_dbase->top_proj_dir, "/NEWS", NULL);
  anjuta_append_text_editor (filename);
  g_free (filename);
}

void
on_prj_config1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  on_prj_configure_activate (NULL, NULL);
}

void
on_prj_info1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  on_prj_info_activate (NULL, NULL);
}

/*************************************************************************/
void
on_syntax_hilite1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  TextEditor *te;
  te = anjuta_get_current_text_editor ();
  if (te == NULL)
    return;
  text_editor_hilite (te);
}


void
on_indent1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gchar *cmd, *file;
  GtkAnText *text;
  GtkAdjustment *adj;
  TextEditor *te;
  pid_t pid;
  int status;
  gfloat adj_value_save;
  FILE *fp;

  if (anjuta_is_installed (app->preferences->commands.shell, TRUE) == FALSE)
    return;
  if (anjuta_is_installed ("indent", TRUE) == FALSE)
    return;

  if (app->preferences->format_disable)
    return;
  text = anjuta_get_current_text ();
  if (text == NULL)
    return;
  if (GTK_IS_ANTEXT (text) == FALSE)
    return;
  te = anjuta_get_current_text_editor ();
  if (te == NULL)
    return;

  file = get_a_tmp_file ();
  fp = fopen (file, "w");
  if (fp)
  {
    gchar ch;
    guint nchars, i;

    anjuta_set_busy ();
    nchars = gtk_antext_get_length (GTK_ANTEXT (text));

    anjuta_status (_("Auto formating ..."));
    for (i = 0; i < nchars; i++)
    {
      ch = (GTK_ANTEXT_INDEX (GTK_ANTEXT (text), i));
      if (fwrite (&ch, 1, 1, fp) != 1)
      {
	fclose (fp);
	anjuta_warning (_("Error in in formating ..."));
	anjuta_set_active ();
	remove (file);
	g_free (file);
	return;
      }
    }
    fclose (fp);
  }
  else
  {
    anjuta_warning (_("Error in in formating ..."));
    anjuta_set_active ();
    g_free (file);
    return;
  }
  cmd = g_strconcat ("indent ",
		     preferences_get_format_opts (app->preferences),
		     " ", file, NULL);
  if ((pid = fork ()) == 0)
  {
    execlp (app->preferences->commands.shell,
	    app->preferences->commands.shell, "-c", cmd, NULL);
    g_error (_("Cannot execute command shell"));
  }
  g_free (cmd);
  waitpid (pid, &status, 0);
  fp = fopen (file, "r");
  if (fp)
  {
    gchar buffer[FILE_BUFFER_SIZE];
    gint nchars;
    gfloat size;
    gulong count;
    struct stat st;
    stat (file, &st);
    size = (float) st.st_size / FILE_BUFFER_SIZE;
    count = 0;
    gtk_antext_freeze (GTK_ANTEXT (text));
    adj = GTK_ANTEXT (text)->vadj;
    adj_value_save = adj->value;
    gtk_antext_set_point (GTK_ANTEXT (text), 0);
    gtk_antext_forward_delete (GTK_ANTEXT (text),
			       gtk_antext_get_length (GTK_ANTEXT (text)));
    gtk_antext_set_point (GTK_ANTEXT (text), 0);
    while (1)
    {
      nchars = fread (buffer, 1, FILE_BUFFER_SIZE, fp);
      gtk_antext_insert (GTK_ANTEXT (text),
			 te->style->font, NULL, NULL, buffer, nchars);
      count++;
      if (feof (fp))
	break;
    }
    fclose (fp);
    gtk_antext_thaw (GTK_ANTEXT (text));
    gtk_adjustment_set_value (adj, adj_value_save);
  }
  else
  {
    anjuta_warning (_("Error in in formating ..."));
    remove (file);
    g_free (file);
    gtk_antext_thaw (GTK_ANTEXT (text));
    return;
  }
  anjuta_set_active ();
  remove (file);
  g_free (file);
  anjuta_status (_("Auto formating completed"));
  te->status = TEXT_EDITOR_NOT_SAVED;
  main_toolbar_update ();
  update_main_menubar ();
}

void
on_update_tags1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  TextEditor *te;
  gint i;

  if (anjuta_is_installed("ctags", TRUE) == FALSE)
    return;

  tags_manager_freeze (app->tags_manager);
  tags_manager_clear (app->tags_manager);

  if (app->project_dbase->project_is_open)
  {
    if (!tags_manager_update_image (app->tags_manager,
				    app->project_dbase->src_files)) ;
  }
  else
  {
    for (i = 0; i < g_list_length (app->text_editor_list); i++)
    {
      te = g_list_nth_data (app->text_editor_list, i);
      if (te->full_filename)
	tags_manager_update (app->tags_manager, te->full_filename);
    }
  }
  tags_manager_thaw (app->tags_manager);
  anjuta_status (_("Tags image update successfully."));
}

void
on_line_wrap1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  TextEditor *te;
  te = anjuta_get_current_text_editor ();
  if (te == NULL)
    return;
  on_text_editor_menu_line_wrap_activate (NULL, NULL);
}

void
on_word_wrap1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  TextEditor *te;
  te = anjuta_get_current_text_editor ();
  if (te == NULL)
    return;
  on_text_editor_menu_word_wrap_activate (NULL, NULL);
}

void
on_detach1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gint page_num;
  GtkWidget *container;
  if (anjuta_get_current_text_editor () == NULL)
    return;
  page_num =
    gtk_notebook_get_current_page (GTK_NOTEBOOK (app->widgets.notebook));
  container =
    gtk_notebook_get_nth_page (GTK_NOTEBOOK (app->widgets.notebook),
			       page_num);
  text_editor_undock (anjuta_get_notebook_text_editor (page_num), container);
  gtk_notebook_remove_page (GTK_NOTEBOOK (app->widgets.notebook), page_num);
  on_anjuta_window_focus_in_event (NULL, NULL, NULL);
}

/*************************************************************************/
void
on_compile1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  compile_file ();
}


void
on_build_project1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  build_project ();
}

void
on_install_project1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  build_install_project ();
}

void
on_autogen_project1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  build_autogen_project ();
}

void
on_build_dist_project1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  build_dist_project ();
}

void
on_build_all_project1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  build_all_project ();
}

void
on_configure_project1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  configurer_show (app->configurer);
}

void
on_clean_project1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  clean_project ();
}

void
on_clean_all_project1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  clean_all_project ();
}

void
on_stop_build_make1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  launcher_reset ();
}

void
on_go_execute1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  executer_execute (app->executer);
}

void
on_go_execute2_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  executer_show (app->executer);
}

/*******************************************************************************/
void
on_book_toggle1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
}

void
on_book_prev1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
}

void
on_book_next1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
}

void
on_book_last1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
}

void
on_book_clear1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
}


/*******************************************************************************/
void
on_toggle_breakpoint1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  anjuta_not_implemented (__FILE__, __LINE__);
}

void
on_set_breakpoint1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  on_bk_add_breakpoint_clicked (NULL, debugger.breakpoints_dbase);
}

void
on_disable_all_breakpoints1_activate (GtkMenuItem * menuitem,
				      gpointer user_data)
{

}

void
on_show_breakpoints1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  breakpoints_dbase_show (debugger.breakpoints_dbase);
}

void
on_clear_breakpoints1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  on_bk_delete_all_clicked (NULL, debugger.breakpoints_dbase);
}

/*******************************************************************************/
void
on_execution_continue1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_run ();
}

void
on_execution_step_in1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_step_in ();
}

void
on_execution_step_out1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_step_out ();
}

void
on_execution_step_over1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_step_over ();
}

void
on_execution_run_to_cursor1_activate (GtkMenuItem * menuitem,
				      gpointer user_data)
{
  debugger_run_to_cursor ();
}

/*******************************************************************************/
void
on_info_targets_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_put_cmd_in_queqe ("set print pretty on", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("set verbos off", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("info target", DB_CMD_SE_MESG | DB_CMD_SE_DIALOG,
			     debugger_dialog_message, NULL);
  debugger_put_cmd_in_queqe ("set verbos on", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("set print pretty off", DB_CMD_NONE, NULL, NULL);
  debugger_execute_cmd_in_queqe ();
}

void
on_info_program_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_put_cmd_in_queqe ("set print pretty on", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("set verbos off", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("info program",
			     DB_CMD_SE_MESG | DB_CMD_SE_DIALOG,
			     debugger_dialog_message, NULL);
  debugger_put_cmd_in_queqe ("info program", DB_CMD_NONE,
			     on_debugger_update_prog_status, NULL);
  debugger_put_cmd_in_queqe ("set verbos on", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("set print pretty off", DB_CMD_NONE, NULL, NULL);
  debugger_execute_cmd_in_queqe ();
}

void
on_info_udot_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_put_cmd_in_queqe ("set print pretty on", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("set verbos off", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("info udot", DB_CMD_SE_MESG | DB_CMD_SE_DIALOG,
			     debugger_dialog_message, NULL);
  debugger_put_cmd_in_queqe ("set verbos on", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("set print pretty off", DB_CMD_NONE, NULL, NULL);
  debugger_execute_cmd_in_queqe ();
}

void
on_info_threads_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_put_cmd_in_queqe ("set print pretty on", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("set verbos off", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("info threads",
			     DB_CMD_SE_MESG | DB_CMD_SE_DIALOG,
			     debugger_dialog_message, NULL);
  debugger_put_cmd_in_queqe ("set verbos on", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("set print pretty off", DB_CMD_NONE, NULL, NULL);
  debugger_execute_cmd_in_queqe ();
}

void
on_info_variables_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_put_cmd_in_queqe ("set print pretty on", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("set verbos off", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("info variables",
			     DB_CMD_SE_MESG | DB_CMD_SE_DIALOG,
			     debugger_dialog_message, NULL);
  debugger_put_cmd_in_queqe ("set verbos on", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("set print pretty off", DB_CMD_NONE, NULL, NULL);
  debugger_execute_cmd_in_queqe ();
}

void
on_info_locals_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_put_cmd_in_queqe ("set print pretty on", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("set verbos off", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("set verbos off", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("info locals", DB_CMD_SE_MESG | DB_CMD_SE_DIALOG,
			     debugger_dialog_message, NULL);
  debugger_put_cmd_in_queqe ("set verbos on", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("set print pretty off", DB_CMD_NONE, NULL, NULL);
  debugger_execute_cmd_in_queqe ();
}

void
on_info_frame_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_put_cmd_in_queqe ("set print pretty on", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("set verbos off", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("info frame", DB_CMD_SE_MESG | DB_CMD_SE_DIALOG,
			     debugger_dialog_message, NULL);
  debugger_put_cmd_in_queqe ("set verbos on", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("set print pretty off", DB_CMD_NONE, NULL, NULL);
  debugger_execute_cmd_in_queqe ();
}

void
on_info_args_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_put_cmd_in_queqe ("set print pretty on", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("set verbos off", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("info args", DB_CMD_SE_MESG | DB_CMD_SE_DIALOG,
			     debugger_dialog_message, NULL);
  debugger_put_cmd_in_queqe ("set verbos on", DB_CMD_NONE, NULL, NULL);
  debugger_put_cmd_in_queqe ("set print pretty off", DB_CMD_NONE, NULL, NULL);
  debugger_execute_cmd_in_queqe ();
}


/********************************************************************************/

void
on_debugger_start_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gchar *prog, *temp;
  gint s_re, e_re;
  struct stat s_stat, e_stat;
  TextEditor *te;

  prog = NULL;
  if (app->project_dbase->project_is_open == TRUE)
  {
    prog = g_strdup_printf ("%s/%s", app->project_dbase->src_dir,
			    app->project_dbase->prog_name);
    debugger_start (prog);
    g_free (prog);
    return;
  }
  else
  {
    te = anjuta_get_current_text_editor ();
    if (te)
    {
      if (te->full_filename)
      {
	prog = g_strdup (te->full_filename);
	temp = get_file_extension (prog);
	if (temp)
	  *(--temp) = '\0';
	s_re = stat (te->full_filename, &s_stat);
	e_re = stat (prog, &e_stat);
      }
      if (te->full_filename == NULL
	  || (te->status == TEXT_EDITOR_NOT_SAVED)
	  || (e_re != 0) || (s_re != 0)
	  || (e_stat.st_mtime < s_stat.st_mtime))
      {
	anjuta_warning (_
			("WARNING: The Exec for this file is not up-to-date.\nBuild it first."));
	g_free (prog);
	return;
      }
    }
    else
      prog = NULL;
    debugger_start (prog);
    if (prog)
      g_free (prog);
    return;
  }
}

void
on_debugger_open_exec_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_open_exec_file ();
}

void
on_debugger_attach_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  if (debugger_is_active ())
    attach_process_show (debugger.attach_process);
  else
    anjuta_error (_("Debugger is not running. Start it first."));
}

void
on_debugger_load_core_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_load_core_file ();
}

void
on_debugger_restart_prog_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_restart_program ();
}

void
on_debugger_stop_prog_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_stop_program ();
}

void
on_debugger_detach_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_detach_process ();
}

void
on_debugger_stop_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  if (debugger.prog_is_running == TRUE)
  {
    if (debugger.prog_is_attached == TRUE)
    {
      messagebox2 (GNOME_MESSAGE_BOX_QUESTION,
		   _
		   ("Program is ATTACHED.\nDo you still want to stop Debugger?"),
		   GNOME_STOCK_BUTTON_YES, GNOME_STOCK_BUTTON_NO,
		   on_debugger_confirm_stop_yes_clicked, NULL, NULL);
    }
    else
    {
      messagebox2 (GNOME_MESSAGE_BOX_QUESTION,
		   _
		   ("Program is running.\nDo you still want to stop Debugger?"),
		   GNOME_STOCK_BUTTON_YES, GNOME_STOCK_BUTTON_NO,
		   on_debugger_confirm_stop_yes_clicked, NULL, NULL);
    }
  }
  else
    debugger_stop ();
}

void
on_debugger_confirm_stop_yes_clicked (GtkButton * button, gpointer data)
{
  debugger_stop ();
}

void
on_debugger_continue_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_run ();
}

void
on_debugger_step_in_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_step_in ();
}

void
on_debugger_step_out_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_step_out ();
}

void
on_debugger_step_over_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_step_over ();
}

void
on_debugger_run_to_cursor_activate (GtkMenuItem * menuitem,
				    gpointer user_data)
{
  debugger_run_to_cursor ();
}

void
on_debugger_interrupt_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  debugger_interrupt ();
}

void
on_debugger_signal_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  on_signals_send_activate (NULL, debugger.signals);
}

void
on_debugger_inspect_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *w = create_eval_dialog ();
  gtk_widget_show (w);
}

void
on_debugger_add_watch_activate (GtkMenuItem * menuitem, gpointer user_data)
{
}

void
on_debugger_custom_command_activate (GtkMenuItem * menuitem,
				     gpointer user_data)
{
  debugger_custom_command ();
}

/************************************************************************************************/

void
on_windows1_new_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  on_new_file1_activate (NULL, NULL);
}

void
on_windows1_close_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  on_close_file1_activate (NULL, NULL);
}

/************************************************************************************************/
void
on_set_compiler1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  compiler_options_get (app->compiler_options);
}

void
on_set_src_paths1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  src_paths_get (app->src_paths);
}

void
on_set_preferences1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  preferences_get (app->preferences);
}

void
on_set_default_preferences1_activate (GtkMenuItem * menuitem,
				      gpointer user_data)
{
  preferences_set_defaults (app->preferences);
}

/************************************************************************************************/
void
on_utilities1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
on_grep_utility1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
on_compare_two_files1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
on_diff_utility1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
  on_file_view__char_octal_hex_1_activate
  (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
on_c_beautifier1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
on_c_flow1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
on_c_cross_reference1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
on_c_trace1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}


void
on_archive_maintenace1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}

void
on_contents1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  pid_t pid;

  if (anjuta_is_installed ("gnome-help-browser", TRUE) == FALSE)
    return;

  if ((pid = fork ()) == 0)
  {
    execlp ("gnome-help-browser", "gnome-help-browser", "ghelp:anjuta");
    g_error (_("Cannot launch gnome-help-browser"));
  }
  if (pid > 0)
    anjuta_register_child_process (pid, NULL, NULL);
}


void
on_index1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  pid_t pid;
  if (anjuta_is_installed ("gnome-help-browser", TRUE) == FALSE)
    return;

  if ((pid = fork ()) == 0)
  {
    execlp ("gnome-help-browser", "gnome-help-browser", "ghelp:anjuta#index");
    g_error (_("Cannot launch gnome-help-browser"));
  }
  if (pid > 0)
    anjuta_register_child_process (pid, NULL, NULL);
}


void
on_man_pages1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  pid_t pid;

  if (anjuta_is_installed ("gnome-help-browser", TRUE) == FALSE)
    return;

  if ((pid = fork ()) == 0)
  {
    execlp ("gnome-help-browser", "gnome-help-browser", "toc:man");
    g_error (_("Cannot launch gnome-help-browser"));
  }
  if (pid > 0)
    anjuta_register_child_process (pid, NULL, NULL);
}

void
on_info_pages1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  pid_t pid;

  if (anjuta_is_installed ("gnome-help-browser", TRUE) == FALSE)
    return;

  if ((pid = fork ()) == 0)
  {
    execlp ("gnome-help-browser", "gnome-help-browser", "toc:info");
    g_error (_("Cannot launch gnome-help-browser"));
  }
  if (pid > 0)
    anjuta_register_child_process (pid, NULL, NULL);
}

void
on_search_a_topic1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  anjuta_not_implemented (__FILE__, __LINE__);
}

void
on_about1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_widget_show (create_about_gui ());
}

void
on_save_on_close_no_clicked (GtkButton * button, gpointer data)
{
  anjuta_remove_current_text_editor ();
  closing_state = FALSE;
}

void
on_save_on_close_cancel_clicked (GtkButton * button, gpointer data)
{
  closing_state = FALSE;
}

void
on_reload_yes_clicked (GtkButton * button, gpointer te_data)
{
  text_editor_load_file ((TextEditor *) te_data);
  anjuta_update_title ();
}
