/*
    preferences_gui.c
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>

#include "anjuta.h"
#include "messages.h"
#include "support.h"
#include "preferences.h"

gchar* format_style[] =
{
	"Custom style", " -i4 -bl -bls -bli0 -ss cbio0",
	"GNU coding style", " -gnu",
	"Kernighan & Ritchie style", " -kr",
	"Original Berkeyley style", " -org",
	"Style of Kangleipak", " -gnu -sc -bli0 -bl0 -cbi0 -ss",
	"Hello world style", "  -gnu -i0 -bli0 -cbi0 -cdb -sc -bl0 -ss",
	"Crazy boy style", " ",
	NULL, NULL
};

static void on_enable_hilite_check_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data);

static void on_preferences_ok_clicked           (GtkButton       *button,
                                        gpointer         user_data);

static void on_preferences_apply_clicked        (GtkButton       *button,
                                        gpointer         user_data);

static void on_preferences_cancel_clicked       (GtkButton       *button,
                                        gpointer         user_data);

static gboolean on_preferences_delete_event (GtkWidget      *w, GdkEvent *event,
                                        gpointer         user_data);

static void on_dir_create_cancel_clicked(GtkButton *button, gpointer data);

static void on_dir_create_yes_clicked(GtkButton *button, gpointer user_data);

static void
on_format_style_entry_changed          (GtkEditable     *editable,
                                        gpointer         user_data);
static void
on_format_style_check_clicked (GtkButton  *but,
                                        gpointer         user_data);

static void
on_trunc_mesg_check_clicked            (GtkButton       *button,
                                        gpointer         user_data);

static void
on_notebook_tag_none_clicked           (GtkButton       *button,
                                        gpointer         user_data);

static void
on_nootbook_tag_top_radio_clicked      (GtkButton       *button,
                                        gpointer         user_data);

static void
on_nootbook_tag_bottom_radio_clicked   (GtkButton       *button,
                                        gpointer         user_data);

static void
on_notebook_tag_left_radio_clicked     (GtkButton       *button,
                                        gpointer         user_data);

static void
on_notebook_tag_right_radio_clicked    (GtkButton       *button,
                                        gpointer         user_data);

static GtkWidget* create_preferences_page1 (Preferences *p);

static GtkWidget* create_preferences_page5 (Preferences *p);

static GtkWidget* create_preferences_page6 (Preferences *p);

void
create_preferences_gui (Preferences* pr)
{
  GtkWidget *dialog1;
  GtkWidget *dialog_vbox2;
  GtkWidget *dialog_action_area2;
  GtkWidget *window2;
  GtkWidget *notebook2;
  GtkWidget *page1;
  GtkWidget *page5;
  GtkWidget *page6;
  GtkWidget *vbox1;
  GtkWidget *frame1;
  GtkWidget *eventbox6;
  GtkWidget *entry3;
  GtkWidget *frame2;
  GtkWidget *table1;
  GtkWidget *label4;
  GtkWidget *eventbox3;
  GtkObject *spinbutton2_adj;
  GtkWidget *spinbutton2;
  GtkWidget *eventbox4;
  GtkObject *spinbutton3_adj;
  GtkWidget *spinbutton3;
  GtkWidget *eventbox5;
  GtkObject *spinbutton4_adj;
  GtkWidget *spinbutton4;
  GtkWidget *vseparator2;
  GtkWidget *vseparator1;
  GtkWidget *label5;
  GtkWidget *label6;
  GtkWidget *frame7;
  GtkWidget *vbox5;
  GtkWidget *hbox2;
  GtkWidget *checkbutton9;
  GtkWidget *eventbox7;
  GtkObject *spinbutton5_adj;
  GtkWidget *spinbutton5;
  GtkWidget *label9;
  GtkWidget *hbox21;
  GtkWidget *checkbutton8;
  GtkWidget *eventbox71;
  GtkObject *spinbutton51_adj;
  GtkWidget *spinbutton51;
  GtkWidget *label91;
  GtkWidget *label102;
  GtkWidget *label103;
  GtkWidget *frame4;
  GtkWidget *table2;
  GtkWidget *checkbutton1;
  GtkWidget *checkbutton2;
  GtkWidget *checkbutton7;
  GtkWidget *label1;
  GtkWidget *vbox6;
  GtkWidget *frame8;
  GtkWidget *table3;
  GtkWidget *label13;
  GtkWidget *label14;
  GtkWidget *label141;
  GtkWidget *label142;
  GtkWidget *label143;
  GtkWidget *colorpicker1;
  GtkWidget *colorpicker2;
  GtkWidget *colorpicker3;
  GtkWidget *colorpicker4;
  GtkWidget *colorpicker5;
  GtkWidget *frame91;
  GtkWidget *vbox71;
  GtkWidget *checkbutton100;
  GtkWidget *checkbutton101;
  GtkWidget *checkbutton102;
  GtkWidget *label11;
  GtkWidget *fontselection1;
  GtkWidget *label12;
  GtkWidget *vbox8;
  GtkWidget *frame10;
  GtkWidget *paperselector1;
  GtkWidget *frame11;
  GtkWidget *eventbox8;
  GtkWidget *combo1;
  GList *combo1_items = NULL;
  GtkWidget *combo_entry1;
  GtkWidget *label15;
  GtkWidget *label101;
  GtkWidget *preferences_ok;
  GtkWidget *preferences_apply;
  GtkWidget *preferences_cancel;

  dialog1 = gnome_dialog_new (_("Preferences"), NULL);
  gtk_window_set_policy (GTK_WINDOW (dialog1), FALSE, FALSE, FALSE);
  gnome_dialog_close_hides (GNOME_DIALOG (dialog1), TRUE);
  window2 = dialog1;
  
  pr->widgets.window = dialog1;

  dialog_vbox2 = GNOME_DIALOG (dialog1)->vbox;
  gtk_widget_show (dialog_vbox2);

  notebook2 = gtk_notebook_new ();
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), notebook2, FALSE, TRUE, 0);
  gtk_widget_show (notebook2);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (notebook2), vbox1);

  frame1 = gtk_frame_new (_(" All Projects Directory "));
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox1), frame1, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);

  eventbox6 = gtk_event_box_new ();
  gtk_widget_show (eventbox6);
  gtk_container_add (GTK_CONTAINER (frame1), eventbox6);
  gtk_container_set_border_width (GTK_CONTAINER (eventbox6), 5);

  entry3 = gtk_entry_new ();
  gtk_widget_show (entry3);
  gtk_container_add (GTK_CONTAINER (eventbox6), entry3);

  frame2 = gtk_frame_new (_(" History size "));
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (vbox1), frame2, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame2), 5);

  table1 = gtk_table_new (2, 5, FALSE);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (frame2), table1);

  label4 = gtk_label_new (_("Recent Projects:"));
  gtk_widget_show (label4);
  gtk_table_attach (GTK_TABLE (table1), label4, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label4), 5, 5);

  label5 = gtk_label_new (_("Recent Files:"));
  gtk_widget_show (label5);
  gtk_table_attach (GTK_TABLE (table1), label5, 2, 3, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 0);
  gtk_misc_set_padding (GTK_MISC (label5), 0, 6);

  label6 = gtk_label_new (_("Combo Popdown:"));
  gtk_widget_show (label6);
  gtk_table_attach (GTK_TABLE (table1), label6, 4, 5, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 0);
  gtk_misc_set_padding (GTK_MISC (label6), 0, 5);

  eventbox3 = gtk_event_box_new ();
  gtk_widget_show (eventbox3);
  gtk_table_attach (GTK_TABLE (table1), eventbox3, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (eventbox3), 5);

  spinbutton2_adj = gtk_adjustment_new (8, 0, 20, 1, 4, 4);
  spinbutton2 = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton2_adj), 1, 0);
  gtk_widget_show (spinbutton2);
  gtk_container_add (GTK_CONTAINER (eventbox3), spinbutton2);

  eventbox4 = gtk_event_box_new ();
  gtk_widget_show (eventbox4);
  gtk_table_attach (GTK_TABLE (table1), eventbox4, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (eventbox4), 5);

  spinbutton3_adj = gtk_adjustment_new (8, 0, 20, 1, 4, 4);
  spinbutton3 = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton3_adj), 1, 0);
  gtk_widget_show (spinbutton3);
  gtk_container_add (GTK_CONTAINER (eventbox4), spinbutton3);

  eventbox5 = gtk_event_box_new ();
  gtk_widget_show (eventbox5);
  gtk_table_attach (GTK_TABLE (table1), eventbox5, 4, 5, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (eventbox5), 5);

  spinbutton4_adj = gtk_adjustment_new (8, 0, 20, 1, 4, 4);
  spinbutton4 = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton4_adj), 1, 0);
  gtk_widget_show (spinbutton4);
  gtk_container_add (GTK_CONTAINER (eventbox5), spinbutton4);

  vseparator2 = gtk_vseparator_new ();
  gtk_widget_show (vseparator2);
  gtk_table_attach (GTK_TABLE (table1), vseparator2, 3, 4, 0, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  vseparator1 = gtk_vseparator_new ();
  gtk_widget_show (vseparator1);
  gtk_table_attach (GTK_TABLE (table1), vseparator1, 1, 2, 0, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  frame7 = gtk_frame_new (NULL);
  gtk_widget_show (frame7);
  gtk_box_pack_start (GTK_BOX (vbox1), frame7, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame7), 5);

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox5);
  gtk_container_add (GTK_CONTAINER (frame7), vbox5);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox5), hbox2, TRUE, TRUE, 0);

  checkbutton9 = gtk_check_button_new_with_label (_("Auto Save"));
  gtk_widget_show (checkbutton9);
  gtk_box_pack_start (GTK_BOX (hbox2), checkbutton9, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (checkbutton9), 5);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton9), TRUE);

  eventbox7 = gtk_event_box_new ();
  gtk_widget_show (eventbox7);
  gtk_box_pack_start (GTK_BOX (hbox2), eventbox7, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (eventbox7), 5);

  spinbutton5_adj = gtk_adjustment_new (10, 1, 100, 1, 5, 5);
  spinbutton5 = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton5_adj), 1, 0);
  gtk_widget_show (spinbutton5);
  gtk_container_add (GTK_CONTAINER (eventbox7), spinbutton5);

  label9 = gtk_label_new (_("Timer interval in minutes"));
  gtk_widget_show (label9);
  gtk_box_pack_start (GTK_BOX (hbox2), label9, FALSE, FALSE, 0);
  gtk_misc_set_padding (GTK_MISC (label9), 5, 0);

  hbox21 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox21);
  gtk_box_pack_start (GTK_BOX (vbox5), hbox21, TRUE, TRUE, 0);

  checkbutton8 = gtk_check_button_new_with_label (_("Auto Indent"));
  gtk_widget_show (checkbutton8);
  gtk_box_pack_start (GTK_BOX (hbox21), checkbutton8, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (checkbutton8), 5);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton8), TRUE);

  eventbox71 = gtk_event_box_new ();
  gtk_widget_show (eventbox71);
  gtk_box_pack_start (GTK_BOX (hbox21), eventbox71, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (eventbox71), 5);

  spinbutton51_adj = gtk_adjustment_new (8, 1, 30, 1, 5, 5);
  spinbutton51 = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton51_adj), 1, 0);
  gtk_widget_show (spinbutton51);
  gtk_container_add (GTK_CONTAINER (eventbox71), spinbutton51);

  label91 = gtk_label_new (_("Tab Size"));
  gtk_widget_show (label91);
  gtk_box_pack_start (GTK_BOX (hbox21), label91, FALSE, FALSE, 0);
  gtk_misc_set_padding (GTK_MISC (label91), 5, 0);

  frame4 = gtk_frame_new (_(" Job Options "));
  gtk_widget_show (frame4);
  gtk_box_pack_start (GTK_BOX (vbox1), frame4, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame4), 5);

  table2 = gtk_table_new (2, 2, TRUE);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (frame4), table2);

  checkbutton1 = gtk_check_button_new_with_label (_("Beep on job complete"));
  gtk_widget_show (checkbutton1);
  gtk_table_attach (GTK_TABLE (table2), checkbutton1, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (checkbutton1), 5);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton1), TRUE);

  checkbutton2 = gtk_check_button_new_with_label (_("Dialog on job complete"));
  gtk_widget_show (checkbutton2);
  gtk_table_attach (GTK_TABLE (table2), checkbutton2, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (checkbutton2), 5);

  checkbutton7 = gtk_check_button_new_with_label (_("Check for job dependencies"));
/*  gtk_widget_show (checkbutton7); */
  gtk_table_attach (GTK_TABLE (table2), checkbutton7, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (checkbutton7), 5);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton7), TRUE);

  label1 = gtk_label_new (_("General"));
  gtk_widget_show (label1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 0), label1);

  page1 = create_preferences_page1(pr);
  gtk_container_add (GTK_CONTAINER (notebook2), page1);

  label101 = gtk_label_new (_("Commands"));
  gtk_widget_show (label101);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 1), label101);


  vbox6 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox6);
  gtk_container_add (GTK_CONTAINER (notebook2), vbox6);

  frame8 = gtk_frame_new (_(" Colors "));
  gtk_widget_show (frame8);
  gtk_box_pack_start (GTK_BOX (vbox6), frame8, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame8), 5);

  table3 = gtk_table_new (5, 2, TRUE);
  gtk_widget_show (table3);
  gtk_container_add (GTK_CONTAINER (frame8), table3);

  label13 = gtk_label_new (_("Plain text color:"));
  gtk_widget_show (label13);
  gtk_table_attach (GTK_TABLE (table3), label13, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label13), 5, 0);

  label14 = gtk_label_new (_("Comment  text color:"));
  gtk_widget_show (label14);
  gtk_table_attach (GTK_TABLE (table3), label14, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label14), 5, 0);

  label141 = gtk_label_new (_("String text color:"));
  gtk_widget_show (label141);
  gtk_table_attach (GTK_TABLE (table3), label141, 0, 1, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label141), 5, 0);

  label142 = gtk_label_new (_("Keywords text color:"));
  gtk_widget_show (label142);
  gtk_table_attach (GTK_TABLE (table3), label142, 0, 1, 3, 4,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label142), 5, 0);

  label143 = gtk_label_new (_("Background color:"));
  gtk_table_attach (GTK_TABLE (table3), label143, 0, 1, 4, 5,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label143), 5, 0);

  colorpicker1 = gnome_color_picker_new ();
  gtk_widget_show (colorpicker1);
  gtk_table_attach (GTK_TABLE (table3), colorpicker1, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (colorpicker1), 5);

  colorpicker2 = gnome_color_picker_new ();
  gtk_widget_show (colorpicker2);
  gtk_table_attach (GTK_TABLE (table3), colorpicker2, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (colorpicker2), 5);

  colorpicker3 = gnome_color_picker_new ();
  gtk_widget_show (colorpicker3);
  gtk_table_attach (GTK_TABLE (table3), colorpicker3, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (colorpicker3), 5);

  colorpicker4 = gnome_color_picker_new ();
  gtk_widget_show (colorpicker4);
  gtk_table_attach (GTK_TABLE (table3), colorpicker4, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (colorpicker4), 5);

  colorpicker5 = gnome_color_picker_new ();
  gtk_table_attach (GTK_TABLE (table3), colorpicker5, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (colorpicker5), 5);

  frame91 = gtk_frame_new (_(" Syntax Hilight "));
  gtk_widget_show (frame91);
  gtk_box_pack_start (GTK_BOX (vbox6), frame91, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame91), 5);

  vbox71 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox71);
  gtk_container_add (GTK_CONTAINER (frame91), vbox71);

  checkbutton100 = gtk_check_button_new_with_label (_("Enable Syntax Hilighting"));

/*  gtk_widget_show (checkbutton100);*/

  gtk_box_pack_start (GTK_BOX (vbox71), checkbutton100, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (checkbutton100), 5);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton100), TRUE);

  checkbutton101 = gtk_check_button_new_with_label (_("Enable Automatic Syntax Hilight"));
  gtk_widget_show (checkbutton101);
  gtk_box_pack_start (GTK_BOX (vbox71), checkbutton101, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (checkbutton101), 5);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton101), TRUE);

  checkbutton102 = gtk_check_button_new_with_label (_("Hilight with lesser keywords (Faster). "));
  gtk_widget_show (checkbutton102);
  gtk_box_pack_start (GTK_BOX (vbox71), checkbutton102, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (checkbutton102), 5);

  label11 = gtk_label_new (_("Colors"));
  gtk_widget_show (label11);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 2), label11);

  fontselection1 = gtk_font_selection_new ();
  gtk_widget_show (fontselection1);
  gtk_container_add (GTK_CONTAINER (notebook2), fontselection1);

  label12 = gtk_label_new (_("Text Font"));
  gtk_widget_show (label12);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 3), label12);

  vbox8 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox8);
  gtk_container_add (GTK_CONTAINER (notebook2), vbox8);

  frame10 = gtk_frame_new (_(" Paper Size "));
  gtk_widget_show (frame10);
  gtk_box_pack_start (GTK_BOX (vbox8), frame10, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame10), 5);

  paperselector1 = gnome_paper_selector_new ();
  gtk_widget_show (paperselector1);
  gtk_container_add (GTK_CONTAINER (frame10), paperselector1);
  gtk_container_set_border_width (GTK_CONTAINER (paperselector1), 5);

  frame11 = gtk_frame_new (_(" Print Command "));
  gtk_widget_show (frame11);
  gtk_box_pack_start (GTK_BOX (vbox8), frame11, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame11), 5);

  eventbox8 = gtk_event_box_new ();
  gtk_widget_show (eventbox8);
  gtk_container_add (GTK_CONTAINER (frame11), eventbox8);
  gtk_container_set_border_width (GTK_CONTAINER (eventbox8), 5);

  combo1 = gtk_combo_new ();
  gtk_widget_show (combo1);
  gtk_container_add (GTK_CONTAINER (eventbox8), combo1);
  combo1_items = g_list_append (combo1_items, "lpr");
  gtk_combo_set_popdown_strings (GTK_COMBO (combo1), combo1_items);
  g_list_free (combo1_items);

  combo_entry1 = GTK_COMBO (combo1)->entry;
  gtk_widget_show (combo_entry1);
  gtk_entry_set_text (GTK_ENTRY (combo_entry1), "lpr");

  label15 = gtk_label_new (_("Print Setup"));
  gtk_widget_show (label15);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2),
	gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 4), label15);

  page5 = create_preferences_page5(pr);
  gtk_container_add (GTK_CONTAINER (notebook2), page5);

  label102 = gtk_label_new (_("Auto Format"));
  gtk_widget_show (label102);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2),
	gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 5), label102);

  page6 = create_preferences_page6(pr);
  gtk_container_add (GTK_CONTAINER (notebook2), page6);

  label103 = gtk_label_new (_("misc"));
  gtk_widget_show (label103);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2),
	gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 6), label103);

  dialog_action_area2 = GNOME_DIALOG (dialog1)->action_area;
  gtk_widget_show (dialog_action_area2);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area2), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area2), 8);

  gnome_dialog_append_button (GNOME_DIALOG (dialog1), GNOME_STOCK_BUTTON_OK);
  preferences_ok = g_list_last (GNOME_DIALOG (dialog1)->buttons)->data;
  gtk_widget_show (preferences_ok);
  GTK_WIDGET_SET_FLAGS (preferences_ok, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (dialog1), GNOME_STOCK_BUTTON_APPLY);
  preferences_apply = g_list_last (GNOME_DIALOG (dialog1)->buttons)->data;
  gtk_widget_show (preferences_apply);
  GTK_WIDGET_SET_FLAGS (preferences_apply, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (dialog1), GNOME_STOCK_BUTTON_CANCEL);
  preferences_cancel = g_list_last (GNOME_DIALOG (dialog1)->buttons)->data;
  gtk_widget_show (preferences_cancel);
  GTK_WIDGET_SET_FLAGS (preferences_cancel, GTK_CAN_DEFAULT);

  gtk_accel_group_attach( app->accel_group, GTK_OBJECT(dialog1));

  gtk_signal_connect (GTK_OBJECT (dialog1), "delete_event",
                      GTK_SIGNAL_FUNC (on_preferences_delete_event),
                      pr);
  gtk_signal_connect (GTK_OBJECT (preferences_ok), "clicked",
                      GTK_SIGNAL_FUNC (on_preferences_ok_clicked),
                      pr);
  gtk_signal_connect (GTK_OBJECT (preferences_apply), "clicked",
                      GTK_SIGNAL_FUNC (on_preferences_apply_clicked),
                      pr);
  gtk_signal_connect (GTK_OBJECT (preferences_cancel), "clicked",
                      GTK_SIGNAL_FUNC (on_preferences_cancel_clicked),
                      pr);
  gtk_signal_connect (GTK_OBJECT (checkbutton100), "toggled",
                      GTK_SIGNAL_FUNC (on_enable_hilite_check_toggled),
                      pr);

  pr->widgets.prj_dir_entry = entry3;
  pr->widgets.recent_prj_spin = spinbutton2;
  pr->widgets.recent_files_spin = spinbutton3;
  pr->widgets.combo_history_spin = spinbutton4;
  pr->widgets.beep_check = checkbutton1;
  pr->widgets.dialog_check = checkbutton2;
  pr->widgets.dependency_check = checkbutton7;
  pr->widgets.auto_save_check = checkbutton9;
  pr->widgets.auto_indent_check = checkbutton8;
  pr->widgets.tab_size_spin = spinbutton51;
  pr->widgets.timer_spin = spinbutton5;
  pr->widgets.plain_colorpicker = colorpicker1;
  pr->widgets.comment_colorpicker = colorpicker2;
  pr->widgets.string_colorpicker = colorpicker3;
  pr->widgets.keywords_colorpicker = colorpicker4;
  pr->widgets.back_colorpicker = colorpicker5;
  pr->widgets.enable_hilite_check = checkbutton100;
  pr->widgets.auto_hilite_check = checkbutton101;
  pr->widgets.lesser_hilite_check = checkbutton102;
  pr->widgets.fontselector = fontselection1;
  pr->widgets.paperselector = paperselector1;
  pr->widgets.pr_command_combo = combo1;
  pr->widgets.pr_command_entry = combo_entry1;
  pr->widgets.notebook = notebook2;
  pr->widgets.window = dialog1;
  
  gtk_widget_ref(pr->widgets.window);
  gtk_widget_ref(pr->widgets.notebook);
  gtk_widget_ref(pr->widgets.prj_dir_entry);
  gtk_widget_ref(pr->widgets.recent_prj_spin);
  gtk_widget_ref(pr->widgets.recent_files_spin);
  gtk_widget_ref(pr->widgets.combo_history_spin);
  gtk_widget_ref(pr->widgets.beep_check);
  gtk_widget_ref(pr->widgets.dialog_check);
  gtk_widget_ref(pr->widgets.dependency_check);
  gtk_widget_ref(pr->widgets.auto_save_check);
  gtk_widget_ref(pr->widgets.auto_indent_check);
  gtk_widget_ref(pr->widgets.tab_size_spin);
  gtk_widget_ref(pr->widgets.timer_spin);
  gtk_widget_ref(pr->widgets.plain_colorpicker);
  gtk_widget_ref(pr->widgets.comment_colorpicker);
  gtk_widget_ref(pr->widgets.string_colorpicker);
  gtk_widget_ref(pr->widgets.keywords_colorpicker);
  gtk_widget_ref(pr->widgets.back_colorpicker);
  gtk_widget_ref(pr->widgets.enable_hilite_check);
  gtk_widget_ref(pr->widgets.auto_hilite_check);
  gtk_widget_ref(pr->widgets.lesser_hilite_check);
  gtk_widget_ref(pr->widgets.fontselector);
  gtk_widget_ref(pr->widgets.paperselector);
  gtk_widget_ref(pr->widgets.pr_command_combo);
  gtk_widget_ref(pr->widgets.pr_command_entry); 
}

static GtkWidget *
create_preferences_page1(Preferences *p)
{
  GtkWidget *window1;
  GtkWidget *frame1;
  GtkWidget *table1;
  GtkWidget *combo1;
  GtkWidget *combo_entry1;
  GtkWidget *combo2;
  GtkWidget *combo_entry2;
  GtkWidget *combo3;
  GtkWidget *combo_entry3;
  GtkWidget *combo4;
  GtkWidget *combo_entry4;
  GtkWidget *combo5;
  GtkWidget *combo_entry5;
  GtkWidget *combo6;
  GtkWidget *combo_entry6;
  GtkWidget *combo7;
  GtkWidget *combo_entry7;
  GtkWidget *label6;
  GtkWidget *label5;
  GtkWidget *label4;
  GtkWidget *label3;
  GtkWidget *label2;
  GtkWidget *label1;

  window1 = p->widgets.window;

  frame1 = gtk_frame_new (NULL);
  gtk_widget_show (frame1);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);

  table1 = gtk_table_new (7, 2, FALSE);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (frame1), table1);

  combo1 = gtk_combo_new ();
  gtk_widget_show (combo1);
  gtk_table_attach (GTK_TABLE (table1), combo1, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (combo1), 5);

  combo_entry1 = GTK_COMBO (combo1)->entry;
  gtk_widget_show (combo_entry1);
  gtk_entry_set_editable(GTK_ENTRY(combo_entry1), FALSE);


  combo2 = gtk_combo_new ();
  gtk_widget_show (combo2);
  gtk_table_attach (GTK_TABLE (table1), combo2, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (combo2), 5);

  combo_entry2 = GTK_COMBO (combo2)->entry;
  gtk_widget_show (combo_entry2);
  gtk_entry_set_editable(GTK_ENTRY(combo_entry2), FALSE);


  combo3 = gtk_combo_new ();
  gtk_widget_show (combo3);
  gtk_table_attach (GTK_TABLE (table1), combo3, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (combo3), 5);

  combo_entry3 = GTK_COMBO (combo3)->entry;
  gtk_widget_show (combo_entry3);
  gtk_entry_set_editable(GTK_ENTRY(combo_entry3), FALSE);


  combo4 = gtk_combo_new ();
  gtk_widget_show (combo4);
  gtk_table_attach (GTK_TABLE (table1), combo4, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (combo4), 5);

  combo_entry4 = GTK_COMBO (combo4)->entry;
  gtk_widget_show (combo_entry4);
  gtk_entry_set_editable(GTK_ENTRY(combo_entry4), FALSE);


  combo5 = gtk_combo_new ();
  gtk_widget_show (combo5);
  gtk_table_attach (GTK_TABLE (table1), combo5, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (combo5), 5);

  combo_entry5 = GTK_COMBO (combo5)->entry;
  gtk_widget_show (combo_entry5);
  gtk_entry_set_editable(GTK_ENTRY(combo_entry5), FALSE);


  combo6 = gtk_combo_new ();
  gtk_widget_show (combo6);
  gtk_table_attach (GTK_TABLE (table1), combo6, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (combo6), 5);

  combo_entry6 = GTK_COMBO (combo6)->entry;
  gtk_widget_show (combo_entry6);
  gtk_entry_set_editable(GTK_ENTRY(combo_entry6), FALSE);


  combo7 = gtk_combo_new ();
  gtk_widget_show (combo7);
  gtk_table_attach (GTK_TABLE (table1), combo7, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (combo7), 5);

  combo_entry7 = GTK_COMBO (combo7)->entry;
  gtk_widget_show (combo_entry7);
  gtk_entry_set_editable(GTK_ENTRY(combo_entry7), FALSE);

  label1 = gtk_label_new (_("Html Browser:"));
/*  gtk_widget_show (label1); */
  gtk_table_attach (GTK_TABLE (table1), label1, 0, 1, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label1), 6, 0);

  label6 = gtk_label_new (_("Terminal:"));
/*  gtk_widget_show (label6); */
  gtk_table_attach (GTK_TABLE (table1), label6, 0, 1, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label6), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label6), 6, 0);

  label5 = gtk_label_new (_("Pixmap editor:"));
  gtk_widget_show (label5);
  gtk_table_attach (GTK_TABLE (table1), label5, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label5), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label5), 6, 0);

  label4 = gtk_label_new (_("C++ compiler/linker"));
  gtk_widget_show (label4);
  gtk_table_attach (GTK_TABLE (table1), label4, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label4), 5, 0);

  label3 = gtk_label_new (_("C compiler/linker"));
  gtk_widget_show (label3);
  gtk_table_attach (GTK_TABLE (table1), label3, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label3), 6, 0);

  label2 = gtk_label_new (_("Build command:"));
  gtk_widget_show (label2);
  gtk_table_attach (GTK_TABLE (table1), label2, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label2), 6, 0);

  label1 = gtk_label_new (_("Command shell:"));
/*  gtk_widget_show (label1); */
  gtk_table_attach (GTK_TABLE (table1), label1, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label1), 6, 0);

  p->widgets.commands.shell_combo = combo1;
  p->widgets.commands.build_combo = combo2;
  p->widgets.commands.c_compiler_combo = combo3;
  p->widgets.commands.cpp_compiler_combo = combo4;
  p->widgets.commands.pixmap_editor_combo = combo5;
  p->widgets.commands.terminal_combo = combo6;
  p->widgets.commands.browser_combo = combo7;

 gtk_widget_hide(combo1);
 gtk_widget_hide(combo6);
 gtk_widget_hide(combo7);

  gtk_widget_ref(p->widgets.commands.shell_combo);
  gtk_widget_ref(p->widgets.commands.build_combo);
  gtk_widget_ref(p->widgets.commands.c_compiler_combo);
  gtk_widget_ref(p->widgets.commands.cpp_compiler_combo);
  gtk_widget_ref(p->widgets.commands.pixmap_editor_combo);
  gtk_widget_ref(p->widgets.commands.terminal_combo);
  gtk_widget_ref(p->widgets.commands.browser_combo);

  return frame1;
}

static GtkWidget*
create_preferences_page5 (Preferences *p)
{
  GtkWidget *window1;
  GtkWidget *checkbutton1;
  GtkWidget *frame1;
  GtkWidget *vbox1;
  GtkWidget *frame2;
  GtkWidget *combo1;
  GtkWidget *combo_entry1;
  GtkWidget *frame3;
  GtkWidget *vbox2;
  GtkWidget *label1;
  GtkWidget *entry1;
  gint i;
  GList *s_list = NULL;

  window1 = p->widgets.window;

  frame1 = gtk_frame_new (NULL);
  gtk_widget_show (frame1);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (frame1), vbox1);
  gtk_container_set_border_width (GTK_CONTAINER (vbox1), 5);

  checkbutton1 = gtk_check_button_new_with_label (_("Disable Auto format"));
  gtk_widget_show (checkbutton1);
  gtk_box_pack_start (GTK_BOX (vbox1), checkbutton1, FALSE, FALSE, 5);

  frame2 = gtk_frame_new (_(" Format Style "));
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (vbox1), frame2, FALSE, FALSE, 5);

  combo1 = gtk_combo_new ();
  gtk_widget_show (combo1);
  gtk_container_add (GTK_CONTAINER (frame2), combo1);
  gtk_container_set_border_width (GTK_CONTAINER (combo1), 5);

  for(i=0;;i+=2)
  {
	if(format_style[i]==NULL) break;
  	s_list = g_list_append(s_list, format_style[i]);
  }
  gtk_combo_set_popdown_strings(GTK_COMBO(combo1), s_list);

  combo_entry1 = GTK_COMBO (combo1)->entry;
  gtk_widget_show (combo_entry1);
  gtk_entry_set_editable(GTK_ENTRY(combo_entry1), FALSE);
  gtk_entry_set_text(GTK_ENTRY(combo_entry1), format_style[8]);

  frame3 = gtk_frame_new (_(" Custom Style "));
  gtk_widget_show (frame3);
  gtk_box_pack_start (GTK_BOX (vbox1), frame3, FALSE, FALSE, 0);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (frame3), vbox2);
  gtk_container_set_border_width (GTK_CONTAINER (vbox2), 5);

  label1 = gtk_label_new (
	_("Enter the command line arguments for the 'indent' program."
	"\nRead the info page for the 'indent' for more details."));
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox2), label1, FALSE, FALSE, 5);
  gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);

  entry1 = gtk_entry_new ();
  gtk_widget_show (entry1);
  gtk_box_pack_start (GTK_BOX (vbox2), entry1, FALSE, FALSE, 5);

  gtk_signal_connect (GTK_OBJECT (combo_entry1), "changed",
                      GTK_SIGNAL_FUNC (on_format_style_entry_changed),
                      p);
  gtk_signal_connect (GTK_OBJECT (checkbutton1), "clicked",
                      GTK_SIGNAL_FUNC (on_format_style_check_clicked),
                      p);

  gtk_widget_ref(checkbutton1);
  p->widgets.format_disable_check = checkbutton1;
  gtk_widget_ref(combo1);
  p->widgets.format_style_combo = combo1;
  gtk_widget_ref(entry1);
  p->widgets.custom_style_entry = entry1;
  gtk_widget_ref(frame2);
  p->widgets.format_frame1 = frame2;
  gtk_widget_ref(frame3);
  p->widgets.format_frame2 = frame3;

  return frame1;
}

static GtkWidget*
create_preferences_page6 (Preferences *p)
{
  GtkWidget *window1;
  GtkWidget *frame1;
  GtkWidget *vbox1;
  GtkWidget *frame2;
  GtkWidget *table1;
  GtkWidget *checkbutton1;
  GtkObject *spinbutton1_adj;
  GtkWidget *spinbutton1;
  GtkObject *spinbutton2_adj;
  GtkWidget *spinbutton2;
  GtkWidget *label4;
  GtkWidget *label3;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *frame3;
  GtkWidget *table2;
  GtkWidget *checkbutton6;
  GtkWidget *hseparator1;
  GSList *table2_group = NULL;
  GtkWidget *radiobutton1;
  GtkWidget *radiobutton2;
  GtkWidget *radiobutton3;
  GtkWidget *radiobutton4;
  GtkWidget *frame4;
  GtkWidget *checkbutton7;
  gint i;

  window1 = p->widgets.window;

  frame1 = gtk_frame_new (NULL);
  gtk_widget_show (frame1);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (frame1), vbox1);

  frame2 = gtk_frame_new (_(" Messages"));
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (vbox1), frame2, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame2), 5);

  table1 = gtk_table_new (3, 3, FALSE);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (frame2), table1);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 5);

  checkbutton1 = gtk_check_button_new_with_label (_("Truncate long messages"));
  gtk_widget_show (checkbutton1);
  gtk_table_attach (GTK_TABLE (table1), checkbutton1, 0, 3, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (checkbutton1), 5);

  spinbutton1_adj = gtk_adjustment_new (15, 0, 100, 1, 10, 10);
  spinbutton1 = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton1_adj), 1, 0);
  gtk_widget_show (spinbutton1);
  gtk_table_attach (GTK_TABLE (table1), spinbutton1, 1, 2, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (spinbutton1, 60, -2);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinbutton1), TRUE);

  spinbutton2_adj = gtk_adjustment_new (15, 0, 100, 1, 10, 10);
  spinbutton2 = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton2_adj), 1, 0);
  gtk_widget_show (spinbutton2);
  gtk_table_attach (GTK_TABLE (table1), spinbutton2, 1, 2, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (spinbutton2, 60, -2);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinbutton2), TRUE);

  label4 = gtk_label_new (_("characters"));
  gtk_widget_show (label4);
  gtk_table_attach (GTK_TABLE (table1), label4, 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label3 = gtk_label_new (_("characters"));
  gtk_widget_show (label3);
  gtk_table_attach (GTK_TABLE (table1), label3, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label1 = gtk_label_new (_("Show first"));
  gtk_widget_show (label1);
  gtk_table_attach (GTK_TABLE (table1), label1, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 0);
  gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_RIGHT);

  label2 = gtk_label_new (_("Show last"));
  gtk_widget_show (label2);
  gtk_table_attach (GTK_TABLE (table1), label2, 0, 1, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 0);

  frame3 = gtk_frame_new (_(" Notebook tags position "));
  gtk_widget_show (frame3);
  gtk_box_pack_start (GTK_BOX (vbox1), frame3, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame3), 5);

  table2 = gtk_table_new (4, 2, FALSE);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (frame3), table2);

  checkbutton6 = gtk_check_button_new_with_label (_("Do not show notebook title tags"));
  gtk_widget_show (checkbutton6);
  gtk_table_attach (GTK_TABLE (table2), checkbutton6, 0, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (checkbutton6), 5);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_show (hseparator1);
  gtk_table_attach (GTK_TABLE (table2), hseparator1, 0, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  radiobutton1 = gtk_radio_button_new_with_label (table2_group, _("Top"));
  table2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton1));
  gtk_widget_show (radiobutton1);
  gtk_table_attach (GTK_TABLE (table2), radiobutton1, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  radiobutton2 = gtk_radio_button_new_with_label (table2_group, _("Bottom"));
  table2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton2));
  gtk_widget_show (radiobutton2);
  gtk_table_attach (GTK_TABLE (table2), radiobutton2, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  radiobutton3 = gtk_radio_button_new_with_label (table2_group, _("Left"));
  table2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton3));
  gtk_widget_show (radiobutton3);
  gtk_table_attach (GTK_TABLE (table2), radiobutton3, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  radiobutton4 = gtk_radio_button_new_with_label (table2_group, _("Right"));
  table2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton4));
  gtk_widget_show (radiobutton4);
  gtk_table_attach (GTK_TABLE (table2), radiobutton4, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  frame4 = gtk_frame_new (_(" Tags Browser "));
  gtk_widget_show (frame4);
  gtk_box_pack_start (GTK_BOX (vbox1), frame4, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame4), 5);

  checkbutton7 = gtk_check_button_new_with_label (_("Update tags image automatically"));
  gtk_widget_show (checkbutton7);
  gtk_container_add (GTK_CONTAINER (frame4), checkbutton7);
  gtk_container_set_border_width (GTK_CONTAINER (checkbutton7), 5);

  gtk_signal_connect (GTK_OBJECT (checkbutton1), "clicked",
                      GTK_SIGNAL_FUNC (on_trunc_mesg_check_clicked),
                      p);
  gtk_signal_connect (GTK_OBJECT (checkbutton6), "clicked",
                      GTK_SIGNAL_FUNC (on_notebook_tag_none_clicked),
                      p);
  gtk_signal_connect (GTK_OBJECT (radiobutton1), "clicked",
                      GTK_SIGNAL_FUNC (on_nootbook_tag_top_radio_clicked),
                      p);
  gtk_signal_connect (GTK_OBJECT (radiobutton2), "clicked",
                      GTK_SIGNAL_FUNC (on_nootbook_tag_bottom_radio_clicked),
                      p);
  gtk_signal_connect (GTK_OBJECT (radiobutton3), "clicked",
                      GTK_SIGNAL_FUNC (on_notebook_tag_left_radio_clicked),
                      p);
  gtk_signal_connect (GTK_OBJECT (radiobutton4), "clicked",
                      GTK_SIGNAL_FUNC (on_notebook_tag_right_radio_clicked),
                      p);

  gtk_widget_ref(checkbutton1);
  p->widgets.truncat_mesg_check = checkbutton1;
  gtk_widget_ref(spinbutton1);
  p->widgets.mesg_first_spin = spinbutton1;
  gtk_widget_ref(spinbutton2);
  p->widgets.mesg_last_spin = spinbutton2;

  p->widgets.tag_pos_radio[0] = radiobutton1;
  p->widgets.tag_pos_radio[1] = radiobutton2;
  p->widgets.tag_pos_radio[2] = radiobutton3;
  p->widgets.tag_pos_radio[3] = radiobutton4;
  for( i=0; i<4; i++) gtk_widget_ref(p->widgets.tag_pos_radio[i]);

  gtk_widget_ref(checkbutton6);
  p->widgets.no_tag_check = checkbutton6;
  gtk_widget_ref(checkbutton7);
  p->widgets.tags_update_check = checkbutton7;

  return frame1;
}

void
on_enable_hilite_check_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
   Preferences *pr = user_data;
   gtk_widget_set_sensitive(pr->widgets.auto_hilite_check,
               gtk_toggle_button_get_active(togglebutton));
   gtk_widget_set_sensitive(pr->widgets.lesser_hilite_check,
               gtk_toggle_button_get_active(togglebutton));
}

void
on_preferences_ok_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  Preferences *pr =(Preferences*)user_data;
  if(pr)
  {
    on_preferences_apply_clicked(NULL, user_data);
    preferences_hide(pr);
  }
}

gboolean
on_preferences_delete_event (GtkWidget      *w, GdkEvent *event,
                                        gpointer         user_data)
{
  Preferences *pr =(Preferences*)user_data;
  if(pr)
  {
    preferences_hide(pr);
  }
  return TRUE;
}

void
on_preferences_apply_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
  gushort    attrb;
  gchar* dir;
  gchar *font_name;
  GdkFont* font;
  Preferences *pr =(Preferences*)user_data;

  if(pr)
  {

/* Page 1 */
    pr->beep_on_build_complete = 
        gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pr->widgets.beep_check));
    pr->dialog_on_build_complete = 
        gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pr->widgets.dialog_check));
    pr->check_dependencies = 
        gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pr->widgets.dependency_check));
    pr->max_recent_prjs = 
        gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pr->widgets.recent_prj_spin));
    pr->max_recent_files =
        gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pr->widgets.recent_files_spin));
    pr->max_combo_histories =
        gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pr->widgets.combo_history_spin));
    pr->auto_indent = 
        gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pr->widgets.auto_indent_check));
    pr->auto_save = 
        gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pr->widgets.auto_save_check));
    pr->enable_hilite = 
        gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pr->widgets.enable_hilite_check));
    pr->auto_hilite = 
        gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pr->widgets.auto_hilite_check));
    pr->lesser_hilite = 
        gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pr->widgets.lesser_hilite_check));
    pr->tab_size =
        gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pr->widgets.tab_size_spin));
    pr->auto_save_timer =
        gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pr->widgets.timer_spin));

/* page 2  */
    if(pr->commands.shell) g_free(pr->commands.shell);
    pr->commands.shell = g_strdup(gtk_entry_get_text(GTK_ENTRY(
		GTK_COMBO(pr->widgets.commands.shell_combo)->entry)));

    if(pr->commands.build) g_free(pr->commands.build);
    pr->commands.build = g_strdup(gtk_entry_get_text(GTK_ENTRY(
		GTK_COMBO(pr->widgets.commands.build_combo)->entry)));

    if(pr->commands.c_compiler) g_free(pr->commands.c_compiler);
    pr->commands.c_compiler = g_strdup(gtk_entry_get_text(GTK_ENTRY(
		GTK_COMBO(pr->widgets.commands.c_compiler_combo)->entry)));

    if(pr->commands.cpp_compiler) g_free(pr->commands.cpp_compiler);
    pr->commands.cpp_compiler = g_strdup(gtk_entry_get_text(GTK_ENTRY(
		GTK_COMBO(pr->widgets.commands.cpp_compiler_combo)->entry)));

    if(pr->commands.pixmap_editor) g_free(pr->commands.pixmap_editor);
    pr->commands.pixmap_editor = g_strdup(gtk_entry_get_text(GTK_ENTRY(
		GTK_COMBO(pr->widgets.commands.pixmap_editor_combo)->entry)));

    if(pr->commands.terminal) g_free(pr->commands.terminal);
    pr->commands.terminal = g_strdup(gtk_entry_get_text(GTK_ENTRY(
		GTK_COMBO(pr->widgets.commands.terminal_combo)->entry)));

    if(pr->commands.browser) g_free(pr->commands.browser);
    pr->commands.browser = g_strdup(gtk_entry_get_text(GTK_ENTRY(
		GTK_COMBO(pr->widgets.commands.browser_combo)->entry)));

/* page 3  */

    gnome_color_picker_get_i16(GNOME_COLOR_PICKER(pr->widgets.plain_colorpicker),
                   &pr->plain_color.red, &pr->plain_color.green, &pr->plain_color.blue, &attrb);
    gnome_color_picker_get_i16(GNOME_COLOR_PICKER(pr->widgets.comment_colorpicker),
                   &pr->comment_color.red, &pr->comment_color.green, &pr->comment_color.blue, &attrb);
    gnome_color_picker_get_i16(GNOME_COLOR_PICKER(pr->widgets.string_colorpicker),
                   &pr->string_color.red, &pr->string_color.green, &pr->string_color.blue, &attrb);
    gnome_color_picker_get_i16(GNOME_COLOR_PICKER(pr->widgets.keywords_colorpicker),
                   &pr->keywords_color.red, &pr->keywords_color.green, &pr->keywords_color.blue, &attrb);
    gnome_color_picker_get_i16(GNOME_COLOR_PICKER(pr->widgets.back_colorpicker),
                   &pr->back_color.red, &pr->back_color.green, &pr->back_color.blue, &attrb);

/* page 3 */

    font_name = gtk_font_selection_get_font_name(GTK_FONT_SELECTION(pr->widgets.fontselector));
    if(font_name)
    {
       font = gdk_font_load(font_name);
       if(font)
       {
          if(pr->font) gdk_font_unref(pr->font);
          pr->font = font;
          if(pr->font_name) g_free(pr->font_name);
          pr->font_name = font_name;
          gtk_font_selection_set_font_name(GTK_FONT_SELECTION(pr->widgets.fontselector), pr->font_name);
        }
        else g_free(font_name);
      }

/* page 4 */
    if(pr->pr_command) g_free(pr->pr_command);
    pr->pr_command = g_strdup( gtk_entry_get_text(GTK_ENTRY(pr->widgets.pr_command_entry)));

/* Page 5 */
    if(pr->format_style) g_free(pr->format_style);
    pr->format_style = g_strdup( gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(pr->widgets.format_style_combo)->entry)));
    if(pr->custom_style) g_free(pr->custom_style);
    pr->custom_style = g_strdup( gtk_entry_get_text(GTK_ENTRY(pr->widgets.custom_style_entry)));
    pr->format_disable = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pr->widgets.format_disable_check));

/* Page 6 */
   pr->mesg_first = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pr->widgets.mesg_first_spin));
   pr->mesg_last = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pr->widgets.mesg_last_spin));

   if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pr->widgets.tag_pos_radio[0])) == TRUE)
   {
	pr->tag_pos = TAG_POS_TOP;
   }
   else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pr->widgets.tag_pos_radio[1])) == TRUE)
   {
	pr->tag_pos = TAG_POS_BOTTOM;
   }
   else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pr->widgets.tag_pos_radio[2])) == TRUE)
   {
	pr->tag_pos = TAG_POS_LEFT;
   }
   else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pr->widgets.tag_pos_radio[3])) == TRUE)
   {
	pr->tag_pos = TAG_POS_RIGHT;
   }
   else
   {
	pr->tag_pos = TAG_POS_TOP;
   }

   pr->truncat_mesg = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pr->widgets.truncat_mesg_check));
   pr->no_tag = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pr->widgets.no_tag_check));
   pr->tags_update = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pr->widgets.tags_update_check));

/**********/
    dir = gtk_entry_get_text(GTK_ENTRY(pr->widgets.prj_dir_entry));
    if(pr->all_projects_dir) g_free(pr->all_projects_dir);
    pr->all_projects_dir = g_strdup(dir);

    anjuta_apply_preferences();
    preferences_save_yourself(pr);
    if(chdir(dir))
    {
       messagebox2(GNOME_MESSAGE_BOX_QUESTION, 
                               _("The Project Directory you specified does not exist. \nDo you want to create it?"),
                               GNOME_STOCK_BUTTON_YES,
                               GNOME_STOCK_BUTTON_CANCEL,
                               on_dir_create_yes_clicked,
                               on_dir_create_cancel_clicked,
                               pr);
       return;
    }
  }
}

void
on_preferences_cancel_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
  Preferences *pr =(Preferences*)user_data;
  if(pr) preferences_hide(pr);
}

void
on_dir_create_yes_clicked(GtkButton *button, gpointer user_data)
{
   Preferences *pr = user_data;
   gchar *dir;
   dir = gtk_entry_get_text(GTK_ENTRY(pr->widgets.prj_dir_entry));
   if(mkdir(dir, 0755))
   {
       anjuta_error(_("Cannot create the directory. \nMake sure it is a valid directory name."));
       return;
   }
   if(pr->all_projects_dir) g_free(pr->all_projects_dir);
   pr->all_projects_dir = g_strdup(dir);
}

void
on_dir_create_cancel_clicked(GtkButton *button, gpointer data)
{
  /* No need to do anything here */
}

static void
on_format_style_entry_changed          (GtkEditable     *editable,
                                        gpointer         user_data)
{
  Preferences* pr = user_data;
  if( strcmp (gtk_entry_get_text(GTK_ENTRY(editable)), format_style[0])==0)
	gtk_widget_set_sensitive(pr->widgets.format_frame2, TRUE);
  else
	gtk_widget_set_sensitive(pr->widgets.format_frame2, FALSE);
}

static void
on_format_style_check_clicked (GtkButton  *but,
                                        gpointer         user_data)
{
	Preferences* pr = user_data;
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(but)) == TRUE)
	{
		gtk_widget_set_sensitive(pr->widgets.format_frame1, FALSE);
		gtk_widget_set_sensitive(pr->widgets.format_frame2, FALSE);
	}
	else
	{
		if( strcmp (gtk_entry_get_text(
				GTK_ENTRY(GTK_COMBO(pr->widgets.format_style_combo)->entry)),
					format_style[0])==0)
			gtk_widget_set_sensitive(pr->widgets.format_frame2, TRUE);
	  	else
			gtk_widget_set_sensitive(pr->widgets.format_frame2, FALSE);
		gtk_widget_set_sensitive(pr->widgets.format_frame1, TRUE);
	}
}

static void
on_trunc_mesg_check_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	Preferences* pr = user_data;

	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
	{
			gtk_widget_set_sensitive(pr->widgets.mesg_first_spin, TRUE);
			gtk_widget_set_sensitive(pr->widgets.mesg_last_spin, TRUE);
	}
	else
	{
			gtk_widget_set_sensitive(pr->widgets.mesg_first_spin, FALSE);
			gtk_widget_set_sensitive(pr->widgets.mesg_last_spin, FALSE);
	}
}


static void
on_notebook_tag_none_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	Preferences* pr = user_data;
	gint i;

	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
	{
		for(i=0; i<4; i++)
			gtk_widget_set_sensitive(pr->widgets.tag_pos_radio[i], FALSE);
	}
	else
	{
		for(i=0; i<4; i++)
			gtk_widget_set_sensitive(pr->widgets.tag_pos_radio[i], TRUE);
	}
}


static void
on_nootbook_tag_top_radio_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{

}


static void
on_nootbook_tag_bottom_radio_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{

}


static void
on_notebook_tag_left_radio_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{

}


static void
on_notebook_tag_right_radio_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{

}

