/*
    toolbar_callbacks.c
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>
#include "gtkaneditor.h"

#include "anjuta.h"
#include "text_editor.h"
#include "mainmenu_callbacks.h"
#include "toolbar_callbacks.h"
#include "project_dbase_cbs.h"
#include "messagebox.h"
#include "debugger.h"


static gint on_member_combo_entry_sel_idle(gpointer data);

void
on_toolbar_new_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  on_new_file1_activate                  (NULL, NULL);
}


void
on_toolbar_open_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  on_open1_activate                      (NULL, NULL);
}


void
on_toolbar_save_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  on_save1_activate                      (NULL, NULL);
}

void
on_toolbar_save_all_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  on_save_all1_activate                      (NULL, NULL);
}

void
on_toolbar_close_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  on_close_file1_activate                      (NULL, NULL);
}


void
on_toolbar_reload_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  on_reload_file1_activate                      (NULL, NULL);
}


void
on_toolbar_undo_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  on_undo1_activate                      (NULL, NULL);
}


void
on_toolbar_redo_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  on_redo1_activate                      (NULL, NULL);
}

void
on_toolbar_print_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	on_print1_activate(NULL, NULL);
}

void
on_toolbar_detach_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
on_detach1_activate (NULL, NULL);
}

void
on_toolbar_find_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  TextEditor     *te;
  gchar           *string, *string1;
  gchar buff[512];
  gint ret;

  te = anjuta_get_current_text_editor();
  if(!te) return;
  string1 = gtk_entry_get_text(GTK_ENTRY(app->widgets.toolbar.main_toolbar.find_entry));
  if(!string1 || strlen(string1)==0) return;
  string = g_strdup(string1);
  app->find_replace->find_text->find_history =
             update_string_list(app->find_replace->find_text->find_history, 
                                           string, COMBO_LIST_LENGTH);
  gtk_combo_set_popdown_strings(GTK_COMBO(app->widgets.toolbar.main_toolbar.find_combo),
                                          app->find_replace->find_text->find_history);

  ret = text_editor_find(te, string, app->find_replace->find_text->forward,
                   app->find_replace->find_text->regexp, app->find_replace->find_text->ignore_case);
  sprintf(buff,
  _("The match \"%s\" was not found from the current location"),string);
  if(ret < 0)
        anjuta_error(_("A serious error occured while searching.:-("));
  else if(ret == 0)
        anjuta_error(buff);
  g_free(string);
}

void
on_toolbar_goto_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  TextEditor*    te;
  guint line;
  gchar buff[256];
  gchar *line_ascii;

  te  = anjuta_get_current_text_editor();
  if(te)
  {
    line_ascii = gtk_entry_get_text(GTK_ENTRY(app->widgets.toolbar.main_toolbar.line_entry));
    if(strlen(line_ascii) == 0) return;
    line = atoi(line_ascii);
    if(text_editor_goto_line(te,line)==FALSE)
    {
      sprintf(buff,_("There is line no. %d in \"%s\"."),line, te->filename);
      anjuta_error(buff);
    }
  }
}

void
on_toolbar_project_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  project_dbase_show(app->project_dbase);
}

void
on_toolbar_messages_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  messages_show(app->messages, MESSAGE_TYPE_END);
}


void
on_toolbar_help_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  on_contents1_activate(NULL, NULL);
}

void
on_toolbar_open_project_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  on_open_project1_activate(NULL, NULL);
}
void
on_toolbar_save_project_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  on_save_project1_activate(NULL, NULL);
}
void
on_toolbar_close_project_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  on_close_project1_activate(NULL, NULL);
}

void
on_toolbar_hilite_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  on_syntax_hilite1_activate(NULL, NULL);
}

void
on_toolbar_indent_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  on_indent1_activate(NULL, NULL);
}

void
on_toolbar_compile_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  on_compile1_activate(NULL, NULL);
}

void
on_toolbar_configure_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  on_configure_project1_activate(NULL, NULL);
}

void
on_toolbar_build_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  on_build_project1_activate(NULL, NULL);  
}

void
on_toolbar_build_all_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  on_build_all_project1_activate(NULL, NULL);
}

void
on_toolbar_exec_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  on_go_execute1_activate(NULL, NULL);
}

void
on_toolbar_debug_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  on_debugger_start_activate(NULL,NULL);
}

void
on_toolbar_stop_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  on_stop_build_make1_activate(NULL, NULL);
}

void
on_toolbar_go_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  on_debugger_continue_activate(NULL,NULL);
}

   
void
on_toolbar_step_in_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  on_debugger_step_in_activate(NULL,NULL);
}


void
on_toolbar_step_out_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
  on_debugger_step_out_activate(NULL,NULL);
}

void
on_toolbar_step_over_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
  on_debugger_step_over_activate(NULL,NULL);
}

void
on_toolbar_toggle_bp_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
   on_set_breakpoint1_activate(NULL, NULL);
 /* on_toggle_breakpoint1_activate(NULL,NULL); */
}

void
on_toolbar_watch_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
 on_watch_window1_activate(NULL,NULL);
}
void
on_toolbar_stack_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
 on_program_stack1_activate(NULL,NULL);
}

void
on_toolbar_registers_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
 on_registers1_activate(NULL,NULL);

}

void
on_toolbar_frame_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
 on_info_frame_activate(NULL,NULL);
}

void
on_toolbar_inspect_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
 on_debugger_inspect_activate(NULL,NULL);
}

void
on_toolbar_interrupt_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
 on_debugger_interrupt_activate(NULL,NULL);
}

void
on_toolbar_debug_stop_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
 on_debugger_stop_activate(NULL,NULL);
}

/*******************************************************************************/

void
on_tag_combo_entry_changed             (GtkEditable     *editable,
                                        gpointer         user_data)
{
    gchar* label;

    /* Dynamic allocation is necessary, because text in the editable is going to
     * change very soon
     */
    label = g_strdup(gtk_entry_get_text(GTK_ENTRY(editable)));
    if(label == NULL) return;
    switch(app->tags_manager->menu_type)
    {
        case function_t:
             if(app->tags_manager->cur_file)
                     if(strcmp(app->tags_manager->cur_file, label)==0) break;
             gtk_signal_disconnect_by_func (GTK_OBJECT (app->widgets.toolbar.browser_toolbar.member_entry),
                      GTK_SIGNAL_FUNC (on_member_combo_entry_changed),
                      NULL);
             gtk_combo_set_popdown_strings(GTK_COMBO(app->widgets.toolbar.browser_toolbar.member_combo),
                        tags_manager_get_function_list(app->tags_manager, label));
             if(app->tags_manager->cur_file) g_free(app->tags_manager->cur_file);
             app->tags_manager->cur_file = g_strdup(label);
             gtk_signal_connect (GTK_OBJECT (app->widgets.toolbar.browser_toolbar.member_entry), "changed",
                      GTK_SIGNAL_FUNC (on_member_combo_entry_changed),
                      NULL);
             g_free(label);
             break;
        case class_t:
             gtk_signal_disconnect_by_func (GTK_OBJECT (app->widgets.toolbar.browser_toolbar.member_entry),
                      GTK_SIGNAL_FUNC (on_member_combo_entry_changed),
                      NULL);
             gtk_combo_set_popdown_strings(GTK_COMBO(app->widgets.toolbar.browser_toolbar.member_combo),
                        tags_manager_get_mem_func_list(app->tags_manager, label));
             g_free(label);
             gtk_signal_connect (GTK_OBJECT (app->widgets.toolbar.browser_toolbar.member_entry), "changed",
                      GTK_SIGNAL_FUNC (on_member_combo_entry_changed),
                      NULL);
             break;
        default:
             gtk_timeout_add(10, on_member_combo_entry_sel_idle, label);
/*             on_member_combo_entry_sel_idle(label); */
    }
}

void
on_tag_combo_list_select_child                  (GtkList         *list,
                                        GtkWidget       *widget,
                                        gpointer         user_data)
{
}

void
on_member_combo_entry_changed             (GtkEditable     *editable,
                                        gpointer         user_data)
{
    gchar* label;

    switch(app->tags_manager->menu_type)
    {
        case function_t:
             label = g_strdup(gtk_entry_get_text(GTK_ENTRY(editable)));
             break;
        case class_t:
             label = g_strconcat(
                 gtk_entry_get_text(GTK_ENTRY(app->widgets.toolbar.browser_toolbar.tag_entry)),
                 "::",
                 gtk_entry_get_text(GTK_ENTRY(editable)), NULL);
             break;
        default:
		label = NULL;
		break;
    }
    if(label)
    {
	gtk_timeout_add(10, on_member_combo_entry_sel_idle, label);
/*        on_member_combo_entry_sel_idle(label); */
    }
}

static gint
on_member_combo_entry_sel_idle(gpointer data)
{
    gchar *file;
    guint   line;
    gchar  *label = data;

    anjuta_set_busy();

    /* Do not update gtk when launcher is busy */
    /* This will freeze the application till the launcher is done */
    update_gtk();
    tags_manager_block_draw(app->tags_manager);
    tags_manager_get_tag_info(app->tags_manager, label,
	&file, &line);
    if(file)
    {
       anjuta_goto_file_line(file, line);
       anjuta_grab_text_focus(-1);
       g_free(file);
    }
    g_free(label);
    anjuta_set_active();
    tags_manager_unblock_draw(app->tags_manager);
    return FALSE;
}

void
on_member_combo_list_select_child                  (GtkList         *list,
                                        GtkWidget       *widget,
                                        gpointer         user_data)
{
}

void
on_browser_widzard_clicked   (GtkButton       *button,
                  gpointer         user_data)
{

}

void
on_tag_functions_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    if(app->tags_manager->menu_type == function_t) return;
    app->tags_manager->menu_type = function_t;
    app->tags_manager->update_required_tags = TRUE;
    app->tags_manager->update_required_mems = TRUE;
    tags_manager_update_menu(app->tags_manager);
}


void
on_tag_classes_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    if(app->tags_manager->menu_type == class_t) return;
    app->tags_manager->menu_type = class_t;
    app->tags_manager->update_required_tags = TRUE;
    app->tags_manager->update_required_mems = TRUE;
    tags_manager_update_menu(app->tags_manager);
}


void
on_tag_structs_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    if(app->tags_manager->menu_type == struct_t) return;
    app->tags_manager->menu_type = struct_t;
    app->tags_manager->update_required_tags = TRUE;
    tags_manager_update_menu(app->tags_manager);
}


void
on_tag_unions_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    if(app->tags_manager->menu_type == union_t) return;
    app->tags_manager->menu_type = union_t;
    app->tags_manager->update_required_tags = TRUE;
    tags_manager_update_menu(app->tags_manager);
}


void
on_tag_enums_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    if(app->tags_manager->menu_type == enum_t) return;
    app->tags_manager->menu_type = enum_t;
    app->tags_manager->update_required_tags = TRUE;
    tags_manager_update_menu(app->tags_manager);
}


void
on_tag_variables_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    if(app->tags_manager->menu_type == variable_t) return;
    app->tags_manager->menu_type = variable_t;
    app->tags_manager->update_required_tags = TRUE;
    tags_manager_update_menu(app->tags_manager);
}


void
on_tag_macros_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    if(app->tags_manager->menu_type == macro_t) return;
    app->tags_manager->menu_type = macro_t;
    app->tags_manager->update_required_tags = TRUE;
    tags_manager_update_menu(app->tags_manager);
}


