/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-message-view.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * SECTION:ianjuta-message-view
 * @title: IAnjutaMessageView
 * @short_description: A view where messages of different kind can be shown
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-message-view.h
 * 
 */

#include "ianjuta-message-view.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_message_view_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-message-view-quark");
	}
	
	return quark;
}

/**
* ianjuta_message_view_append:
* @obj: Self
* @type: fixme
* @summary: fixme
* @details: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_message_view_append (IAnjutaMessageView *obj, IAnjutaMessageViewType type,   const gchar *summary,   const gchar *details, GError **err)
{
	g_return_if_fail (IANJUTA_IS_MESSAGE_VIEW(obj));
	g_return_if_fail (summary != NULL);
	g_return_if_fail (details != NULL);
	IANJUTA_MESSAGE_VIEW_GET_IFACE (obj)->append (obj, type, summary, details, err);
}

/**
* ianjuta_message_view_buffer_append:
* @obj: Self
* @text: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_message_view_buffer_append (IAnjutaMessageView *obj, const gchar *text, GError **err)
{
	g_return_if_fail (IANJUTA_IS_MESSAGE_VIEW(obj));
	g_return_if_fail (text != NULL);
	IANJUTA_MESSAGE_VIEW_GET_IFACE (obj)->buffer_append (obj, text, err);
}

/**
* ianjuta_message_view_clear:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_message_view_clear (IAnjutaMessageView *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_MESSAGE_VIEW(obj));
	IANJUTA_MESSAGE_VIEW_GET_IFACE (obj)->clear (obj, err);
}

/**
* ianjuta_message_view_get_all_messages:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*/
GList*
ianjuta_message_view_get_all_messages (IAnjutaMessageView *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_MESSAGE_VIEW(obj), 0);
	return IANJUTA_MESSAGE_VIEW_GET_IFACE (obj)->get_all_messages (obj, err);
}

/**
* ianjuta_message_view_get_current_message:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*/
const gchar*
ianjuta_message_view_get_current_message (IAnjutaMessageView *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_MESSAGE_VIEW(obj), NULL);
	return IANJUTA_MESSAGE_VIEW_GET_IFACE (obj)->get_current_message (obj, err);
}

/**
* ianjuta_message_view_select_next:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_message_view_select_next (IAnjutaMessageView *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_MESSAGE_VIEW(obj));
	IANJUTA_MESSAGE_VIEW_GET_IFACE (obj)->select_next (obj, err);
}

/**
* ianjuta_message_view_select_previous:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_message_view_select_previous (IAnjutaMessageView *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_MESSAGE_VIEW(obj));
	IANJUTA_MESSAGE_VIEW_GET_IFACE (obj)->select_previous (obj, err);
}

static void
ianjuta_message_view_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {
		/* Signal */
		g_signal_new ("buffer-flushed",
			IANJUTA_TYPE_MESSAGE_VIEW,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaMessageViewIface, buffer_flushed),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			1,
			G_TYPE_STRING);

		/* Signal */
		g_signal_new ("message-clicked",
			IANJUTA_TYPE_MESSAGE_VIEW,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaMessageViewIface, message_clicked),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			1,
			G_TYPE_STRING);


		initialized = TRUE;
	}
}

GType
ianjuta_message_view_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaMessageViewIface),
			ianjuta_message_view_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaMessageView", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_message_view_type_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_MESSAGE_VIEW_TYPE_NORMAL, "IANJUTA_MESSAGE_VIEW_TYPE_NORMAL", "type-normal" }, 
		{ IANJUTA_MESSAGE_VIEW_TYPE_INFO, "IANJUTA_MESSAGE_VIEW_TYPE_INFO", "type-info" }, 
		{ IANJUTA_MESSAGE_VIEW_TYPE_WARNING, "IANJUTA_MESSAGE_VIEW_TYPE_WARNING", "type-warning" }, 
		{ IANJUTA_MESSAGE_VIEW_TYPE_ERROR, "IANJUTA_MESSAGE_VIEW_TYPE_ERROR", "type-error" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaMessageViewType", values);
	}

	return type;
}
