/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-hover.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * SECTION:ianjuta-editor-hover
 * @title: IAnjutaEditorHover
 * @short_description: Text editor hover interface
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-editor-hover
 * 
 */

#include "ianjuta-editor-hover.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_editor_hover_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-editor-hover-quark");
	}
	
	return quark;
}

void
ianjuta_editor_hover_display (IAnjutaEditorHover *obj, const gchar *info, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_HOVER(obj));
	g_return_if_fail (info != NULL);
	IANJUTA_EDITOR_HOVER_GET_IFACE (obj)->display (obj, info, err);
}

/* Default implementation */
static void
ianjuta_editor_hover_display_default (IAnjutaEditorHover *obj, const gchar *info, GError **err)
{
	g_return_if_reached ();
}

void
ianjuta_editor_hover_set_timeout (IAnjutaEditorHover *obj, gint timeout, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_HOVER(obj));
	IANJUTA_EDITOR_HOVER_GET_IFACE (obj)->set_timeout (obj, timeout, err);
}

/* Default implementation */
static void
ianjuta_editor_hover_set_timeout_default (IAnjutaEditorHover *obj, gint timeout, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_editor_hover_base_init (IAnjutaEditorHoverIface* klass)
{
	static gboolean initialized = FALSE;

	klass->display = ianjuta_editor_hover_display_default;
	klass->set_timeout = ianjuta_editor_hover_set_timeout_default;
	
	if (!initialized) {
		/* Signal */
		g_signal_new ("hover-leave",
			IANJUTA_TYPE_EDITOR_HOVER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaEditorHoverIface, hover_leave),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);

		/* Signal */
		g_signal_new ("hover-over",
			IANJUTA_TYPE_EDITOR_HOVER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaEditorHoverIface, hover_over),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);


		initialized = TRUE;
	}
}

GType
ianjuta_editor_hover_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEditorHoverIface),
			(GBaseInitFunc) ianjuta_editor_hover_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEditorHover", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_EDITOR);
	}
	return type;			
}
