/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-macro.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * SECTION:ianjuta-macro
 * @title: IAnjutaMacro
 * @short_description: Macro processor interface
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-macro.h
 * 
 */

#include "ianjuta-macro.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_macro_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-macro-quark");
	}
	
	return quark;
}

/**
 * ianjuta_macro_insert:
 * @key: Key of the macro
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Insert Macro to editor
 */
void
ianjuta_macro_insert (IAnjutaMacro *obj, const gchar* key, GError **err)
{
	g_return_if_fail (IANJUTA_IS_MACRO(obj));
	g_return_if_fail (key != NULL);
	IANJUTA_MACRO_GET_IFACE (obj)->insert (obj, key, err);
}

/* Default implementation */
static void
ianjuta_macro_insert_default (IAnjutaMacro *obj, const gchar* key, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_macro_base_init (IAnjutaMacroIface* klass)
{
	static gboolean initialized = FALSE;

	klass->insert = ianjuta_macro_insert_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_macro_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaMacroIface),
			(GBaseInitFunc) ianjuta_macro_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaMacro", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
