/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-debug-manager.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * SECTION:ianjuta-debug-manager
 * @title: IAnjutaDebugManager
 * @short_description: Interface for plugin that manages debuggers
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-debug-manager.h
 * 
 */

#include "ianjuta-debug-manager.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_debug_manager_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-debug-manager-quark");
	}
	
	return quark;
}

static void
ianjuta_debug_manager_base_init (IAnjutaDebugManagerIface* klass)
{
	static gboolean initialized = FALSE;

	
	if (!initialized) {
		/* Signal */
		g_signal_new ("breakpoint-changed",
			IANJUTA_TYPE_DEBUG_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaDebugManagerIface, breakpoint_changed),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__POINTER,
			G_TYPE_NONE,
			1,
			G_TYPE_POINTER);


		initialized = TRUE;
	}
}

GType
ianjuta_debug_manager_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaDebugManagerIface),
			(GBaseInitFunc) ianjuta_debug_manager_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaDebugManager", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
