/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-cpu-debugger.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_CPU_DEBUGGER_H_
#define _IANJUTA_CPU_DEBUGGER_H_

#include <glib-object.h>
#include <libanjuta/interfaces/ianjuta-debug-manager.h>
#include <libanjuta/interfaces/ianjuta-debugger.h>
#include <libanjuta/interfaces/ianjuta-message-view.h>
#include <sys/types.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_CPU_DEBUGGER (ianjuta_cpu_debugger_get_type ())
#define IANJUTA_CPU_DEBUGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_CPU_DEBUGGER, IAnjutaCpuDebugger))
#define IANJUTA_IS_CPU_DEBUGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_CPU_DEBUGGER))
#define IANJUTA_CPU_DEBUGGER_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_CPU_DEBUGGER, IAnjutaCpuDebuggerIface))

#define IANJUTA_CPU_DEBUGGER_ERROR ianjuta_cpu_debugger_error_quark()

typedef struct _IAnjutaCpuDebugger IAnjutaCpuDebugger;
typedef struct _IAnjutaCpuDebuggerIface IAnjutaCpuDebuggerIface;

struct _IAnjutaCpuDebuggerIface {
	GTypeInterface g_iface;
	

	gboolean (*disassemble) (IAnjutaCpuDebugger *obj, guint address,  guint length,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*inspect_memory) (IAnjutaCpuDebugger *obj, guint address,  guint length,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*list_register) (IAnjutaCpuDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*update_register) (IAnjutaCpuDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*write_register) (IAnjutaCpuDebugger *obj, IAnjutaDebuggerRegister *value, GError **err);

};

GQuark ianjuta_cpu_debugger_error_quark     (void);
GType  ianjuta_cpu_debugger_get_type        (void);

gboolean ianjuta_cpu_debugger_disassemble (IAnjutaCpuDebugger *obj, guint address,  guint length,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_cpu_debugger_inspect_memory (IAnjutaCpuDebugger *obj, guint address,  guint length,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_cpu_debugger_list_register (IAnjutaCpuDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_cpu_debugger_update_register (IAnjutaCpuDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_cpu_debugger_write_register (IAnjutaCpuDebugger *obj, IAnjutaDebuggerRegister *value, GError **err);


G_END_DECLS

#endif
