/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-document-manager.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-document-manager
 * @title: IAnjutaDocumentManager
 * @short_description: Interface for plugin that manages all the editors
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-document-manager.h
 * 
 */

#include "ianjuta-document-manager.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_document_manager_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-document-manager-quark");
	}
	
	return quark;
}

/**
* ianjuta_document_manager_add_buffer:
* @obj: Self
* @name: Name of the editor buffer.
* @content: Initial content of the buffer.
* @err: Error propagation and reporting.
* 
* Creates a new editor buffer of the given name and sets the given
* content as its initial content.
* 
* Return value: the IAnjutaEditor instance that has been added.
*/
IAnjutaEditor*
ianjuta_document_manager_add_buffer (IAnjutaDocumentManager *obj, const gchar *name,   const gchar* content, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj), NULL);
	return IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->add_buffer (obj, name, content, err);
}

/* Default implementation */
static IAnjutaEditor*
ianjuta_document_manager_add_buffer_default (IAnjutaDocumentManager *obj, const gchar *name,   const gchar* content, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_document_manager_add_document:
* @obj: Self
* @document: the document to add
* @err: Error propagation and reporting.
*
* Adds a document to the document manager. This will open a new
* Notebook tab and show the document there
*
*/
void
ianjuta_document_manager_add_document (IAnjutaDocumentManager *obj, IAnjutaDocument* document, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj));
	g_return_if_fail (IANJUTA_IS_DOCUMENT(document));
	IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->add_document (obj, document, err);
}

/* Default implementation */
static void
ianjuta_document_manager_add_document_default (IAnjutaDocumentManager *obj, IAnjutaDocument* document, GError **err)
{
	g_return_if_reached ();
}

/**
* ianjuta_document_manager_find_document_with_path:
* @obj: Self
* @file_path: the file path.
* @err: Error propagation and reporting.
* 
* Finds the document that has the file with path @file_path loaded. Only
* the editor that matches the file path will be searched.
* 
* Return value: the document that corresponds to given file path. NULL if
* there is no editor loaded with this file path.
*/
IAnjutaDocument*
ianjuta_document_manager_find_document_with_path (IAnjutaDocumentManager *obj, const gchar *file_path, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj), NULL);
	return IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->find_document_with_path (obj, file_path, err);
}

/* Default implementation */
static IAnjutaDocument*
ianjuta_document_manager_find_document_with_path_default (IAnjutaDocumentManager *obj, const gchar *file_path, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_document_manager_get_current_document:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Gets the current document.
* 
* Return value: the currently active editor. NULL if none is there.
*/
IAnjutaDocument*
ianjuta_document_manager_get_current_document (IAnjutaDocumentManager *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj), NULL);
	return IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->get_current_document (obj, err);
}

/* Default implementation */
static IAnjutaDocument*
ianjuta_document_manager_get_current_document_default (IAnjutaDocumentManager *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_document_manager_get_documents:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Gets the current list of documents.
*
* Return value: the list of current available documents. The returned
* list must be freed after use (not the editor objects in the list).
*/
GList*
ianjuta_document_manager_get_documents (IAnjutaDocumentManager *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj), 0);
	return IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->get_documents (obj, err);
}

/* Default implementation */
static GList*
ianjuta_document_manager_get_documents_default (IAnjutaDocumentManager *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_document_manager_get_full_filename:
* @obj: Self
* @file: short filename
* @err: Error propagation and reporting.
* 
* Given the short filename, finds the full path of the file, if the
* editor that has it loaded is found. If there is no editor that has
* this file opened, returns NULL.
* 
* Return value: the full path of the file, if an editor is found for it.
*/
const gchar*
ianjuta_document_manager_get_full_filename (IAnjutaDocumentManager *obj, const gchar *file, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj), NULL);
	return IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->get_full_filename (obj, file, err);
}

/* Default implementation */
static const gchar*
ianjuta_document_manager_get_full_filename_default (IAnjutaDocumentManager *obj, const gchar *file, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_document_manager_goto_file_line:
* @obj: Self
* @file: the file to go to.
* @lineno: the line number in the file to go to.
* @err: Error propagation and reporting.
* 
* Loads the given file if not loaded yet, set its editor as current editor
* and moves cursor to the given line in the editor.
* 
* Return value: the editor where the mark has been put. NULL if none.
*/
IAnjutaEditor*
ianjuta_document_manager_goto_file_line (IAnjutaDocumentManager *obj, const gchar *file,   gint lineno, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj), NULL);
	return IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->goto_file_line (obj, file, lineno, err);
}

/* Default implementation */
static IAnjutaEditor*
ianjuta_document_manager_goto_file_line_default (IAnjutaDocumentManager *obj, const gchar *file,   gint lineno, GError **err)
{
	g_return_val_if_reached (NULL);
}

/** 
* ianjuta_document_manager_goto_file_line_mark:
* @obj: Self
* @file: the file to go to.
* @lineno: the line number in the file to go to.
* @mark: TRUE if the line should be marked with a marker.
* @err: Error propagation and reporting
* 
* Loads the given file if not loaded yet, set its editor as current editor
* and moves cursor to the given line in the editor. Optionally also marks
* the line with line marker if @mark is given TRUE.
* 
* Return value: the editor where the mark has been put. NULL if none.
*/
IAnjutaEditor*
ianjuta_document_manager_goto_file_line_mark (IAnjutaDocumentManager *obj, const gchar *file,   gint lineno,   gboolean mark, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj), NULL);
	return IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->goto_file_line_mark (obj, file, lineno, mark, err);
}

/* Default implementation */
static IAnjutaEditor*
ianjuta_document_manager_goto_file_line_mark_default (IAnjutaDocumentManager *obj, const gchar *file,   gint lineno,   gboolean mark, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_document_manager_remove_buffer:
* @obj: Self
* @editor: Editor buffer to close.
* @save_before: If true, saves the editor before closing.
* @err: Error propagation and reporting.
*
* Closes and removes the given editor buffer. If @save_before is TRUE, also
* saves the editor before closing.
*
* Return value: TRUE if the editor was removed, else FALSE.
*/
gboolean
ianjuta_document_manager_remove_document (IAnjutaDocumentManager *obj, IAnjutaDocument *editor,   gboolean save_before, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj), FALSE);
	g_return_val_if_fail (IANJUTA_IS_DOCUMENT(editor), FALSE);
	return IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->remove_document (obj, editor, save_before, err);
}

/* Default implementation */
static gboolean
ianjuta_document_manager_remove_document_default (IAnjutaDocumentManager *obj, IAnjutaDocument *editor,   gboolean save_before, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/** 
* ianjuta_document_manager_set_current_editor:
* @obj: Self
* @editor: the editor to set as current.
* @err: Error propagation and reporting.
* 
* Sets the given editor as current editor.
*/
void
ianjuta_document_manager_set_current_document (IAnjutaDocumentManager *obj, IAnjutaDocument *document, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj));
	g_return_if_fail (IANJUTA_IS_DOCUMENT(document));
	IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->set_current_document (obj, document, err);
}

/* Default implementation */
static void
ianjuta_document_manager_set_current_document_default (IAnjutaDocumentManager *obj, IAnjutaDocument *document, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_document_manager_base_init (IAnjutaDocumentManagerIface* klass)
{
	static gboolean initialized = FALSE;

	klass->add_buffer = ianjuta_document_manager_add_buffer_default;
	klass->add_document = ianjuta_document_manager_add_document_default;
	klass->find_document_with_path = ianjuta_document_manager_find_document_with_path_default;
	klass->get_current_document = ianjuta_document_manager_get_current_document_default;
	klass->get_documents = ianjuta_document_manager_get_documents_default;
	klass->get_full_filename = ianjuta_document_manager_get_full_filename_default;
	klass->goto_file_line = ianjuta_document_manager_goto_file_line_default;
	klass->goto_file_line_mark = ianjuta_document_manager_goto_file_line_mark_default;
	klass->remove_document = ianjuta_document_manager_remove_document_default;
	klass->set_current_document = ianjuta_document_manager_set_current_document_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_document_manager_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaDocumentManagerIface),
			(GBaseInitFunc) ianjuta_document_manager_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaDocumentManager", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_document_manager_error_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_DOCUMENT_MANAGER_DOESNT_EXIST, "IANJUTA_DOCUMENT_MANAGER_DOESNT_EXIST", "doesnt-exist" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaDocumentManagerError", values);
	}

	return type;
}
