/* ctags-visitor.c generated by valac 0.11.2, the Vala compiler
 * generated from ctags-visitor.vala, do not modify */

/*
 * ctags-visitor.vala
 *
 * Copyright 2008, 2010 Abderrahim Kitouni <a.kitouni@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala.h>
#include <valagee.h>


#define TYPE_CTAGS_ENTRY (ctags_entry_get_type ())
typedef struct _CTagsEntry CTagsEntry;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DUMMY_REPORT (dummy_report_get_type ())
#define DUMMY_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DUMMY_REPORT, DummyReport))
#define DUMMY_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DUMMY_REPORT, DummyReportClass))
#define IS_DUMMY_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DUMMY_REPORT))
#define IS_DUMMY_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DUMMY_REPORT))
#define DUMMY_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DUMMY_REPORT, DummyReportClass))

typedef struct _DummyReport DummyReport;
typedef struct _DummyReportClass DummyReportClass;
typedef struct _DummyReportPrivate DummyReportPrivate;

#define TYPE_CTAGS_VISITOR (ctags_visitor_get_type ())
#define CTAGS_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CTAGS_VISITOR, CTagsVisitor))
#define CTAGS_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CTAGS_VISITOR, CTagsVisitorClass))
#define IS_CTAGS_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CTAGS_VISITOR))
#define IS_CTAGS_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CTAGS_VISITOR))
#define CTAGS_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CTAGS_VISITOR, CTagsVisitorClass))

typedef struct _CTagsVisitor CTagsVisitor;
typedef struct _CTagsVisitorClass CTagsVisitorClass;
typedef struct _CTagsVisitorPrivate CTagsVisitorPrivate;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define __g_list_free__ctags_entry_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__ctags_entry_free0_ (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _ctags_entry_free0(var) ((var == NULL) ? NULL : (var = (ctags_entry_free (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

struct _CTagsEntry {
	gint line_number;
	gchar* name;
	gchar* kind_name;
	gchar kind;
	gchar* access;
	gchar* implementation;
	gchar* inheritance;
	gchar* scope[2];
	gchar* signature;
	gchar* typeref;
	gchar* returntype;
};

struct _DummyReport {
	ValaReport parent_instance;
	DummyReportPrivate * priv;
};

struct _DummyReportClass {
	ValaReportClass parent_class;
};

typedef void (*CTagsEntryMaker) (CTagsEntry* entry);
struct _CTagsVisitor {
	ValaCodeVisitor parent_instance;
	CTagsVisitorPrivate * priv;
};

struct _CTagsVisitorClass {
	ValaCodeVisitorClass parent_class;
};

struct _CTagsVisitorPrivate {
	ValaParser* vala_parser;
	ValaGenieParser* genie_parser;
	GList* taglist;
};


static gpointer dummy_report_parent_class = NULL;
static gpointer ctags_visitor_parent_class = NULL;

GType ctags_entry_get_type (void) G_GNUC_CONST;
CTagsEntry* ctags_entry_dup (const CTagsEntry* self);
void ctags_entry_free (CTagsEntry* self);
void ctags_entry_copy (const CTagsEntry* self, CTagsEntry* dest);
void ctags_entry_destroy (CTagsEntry* self);
static void _vala_array_copy1 (gchar** self, gchar** dest);
GType dummy_report_get_type (void) G_GNUC_CONST;
enum  {
	DUMMY_REPORT_DUMMY_PROPERTY
};
static void dummy_report_real_warn (ValaReport* base, ValaSourceReference* source, const gchar* message);
static void dummy_report_real_err (ValaReport* base, ValaSourceReference* source, const gchar* message);
DummyReport* dummy_report_new (void);
DummyReport* dummy_report_construct (GType object_type);
GType ctags_visitor_get_type (void) G_GNUC_CONST;
#define CTAGS_VISITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CTAGS_VISITOR, CTagsVisitorPrivate))
enum  {
	CTAGS_VISITOR_DUMMY_PROPERTY
};
static void _ctags_entry_free0_ (gpointer var);
static void _g_list_free__ctags_entry_free0_ (GList* self);
CTagsVisitor* ctags_visitor_new (void);
CTagsVisitor* ctags_visitor_construct (GType object_type);
static gchar* ctags_visitor_get_access (ValaSymbol* sym);
static gchar* ctags_visitor_to_string (ValaIterable* seq, const gchar* sep);
static gchar* ctags_visitor_implementation (ValaSymbol* sym);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static gchar* ctags_visitor_signature (ValaList* parameter);
static void ctags_visitor_scope (ValaSymbol* s, gchar** scope, int scope_length1);
static void ctags_visitor_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static void ctags_visitor_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void ctags_visitor_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void ctags_visitor_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void ctags_visitor_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void ctags_visitor_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain);
static void ctags_visitor_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static void ctags_visitor_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode);
static void ctags_visitor_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d);
static void ctags_visitor_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static void ctags_visitor_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void ctags_visitor_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void ctags_visitor_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void ctags_visitor_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void ctags_visitor_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local);
void ctags_visitor_parse_vala (CTagsVisitor* self, const gchar* filename, CTagsEntryMaker maker);
void ctags_visitor_parse_genie (CTagsVisitor* self, const gchar* filename, CTagsEntryMaker maker);
static void ctags_visitor_finalize (ValaCodeVisitor* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _vala_array_copy1 (gchar** self, gchar** dest) {
	int i;
	for (i = 0; i < 2; i++) {
		dest[i] = g_strdup (self[i]);
	}
}


void ctags_entry_copy (const CTagsEntry* self, CTagsEntry* dest) {
	gchar* _tmp0_[2] = {0};
	dest->line_number = self->line_number;
	dest->name = g_strdup (self->name);
	dest->kind_name = g_strdup (self->kind_name);
	dest->kind = self->kind;
	dest->access = g_strdup (self->access);
	dest->implementation = g_strdup (self->implementation);
	dest->inheritance = g_strdup (self->inheritance);
	memcpy (dest->scope, (_vala_array_copy1 (self->scope, _tmp0_), _tmp0_), 2 * sizeof (gchar*));
	dest->signature = g_strdup (self->signature);
	dest->typeref = g_strdup (self->typeref);
	dest->returntype = g_strdup (self->returntype);
}


void ctags_entry_destroy (CTagsEntry* self) {
	_g_free0 (self->name);
	_g_free0 (self->kind_name);
	_g_free0 (self->access);
	_g_free0 (self->implementation);
	_g_free0 (self->inheritance);
	_vala_array_destroy (self->scope, 2, (GDestroyNotify) g_free);
	_g_free0 (self->signature);
	_g_free0 (self->typeref);
	_g_free0 (self->returntype);
}


CTagsEntry* ctags_entry_dup (const CTagsEntry* self) {
	CTagsEntry* dup;
	dup = g_new0 (CTagsEntry, 1);
	ctags_entry_copy (self, dup);
	return dup;
}


void ctags_entry_free (CTagsEntry* self) {
	ctags_entry_destroy (self);
	g_free (self);
}


GType ctags_entry_get_type (void) {
	static volatile gsize ctags_entry_type_id__volatile = 0;
	if (g_once_init_enter (&ctags_entry_type_id__volatile)) {
		GType ctags_entry_type_id;
		ctags_entry_type_id = g_boxed_type_register_static ("CTagsEntry", (GBoxedCopyFunc) ctags_entry_dup, (GBoxedFreeFunc) ctags_entry_free);
		g_once_init_leave (&ctags_entry_type_id__volatile, ctags_entry_type_id);
	}
	return ctags_entry_type_id__volatile;
}


static void dummy_report_real_warn (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	DummyReport * self;
	self = (DummyReport*) base;
	g_return_if_fail (message != NULL);
}


static void dummy_report_real_err (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	DummyReport * self;
	self = (DummyReport*) base;
	g_return_if_fail (message != NULL);
}


DummyReport* dummy_report_construct (GType object_type) {
	DummyReport * self = NULL;
	self = (DummyReport*) vala_report_construct (object_type);
	return self;
}


DummyReport* dummy_report_new (void) {
	return dummy_report_construct (TYPE_DUMMY_REPORT);
}


static void dummy_report_class_init (DummyReportClass * klass) {
	dummy_report_parent_class = g_type_class_peek_parent (klass);
	VALA_REPORT_CLASS (klass)->warn = dummy_report_real_warn;
	VALA_REPORT_CLASS (klass)->err = dummy_report_real_err;
}


static void dummy_report_instance_init (DummyReport * self) {
}


GType dummy_report_get_type (void) {
	static volatile gsize dummy_report_type_id__volatile = 0;
	if (g_once_init_enter (&dummy_report_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DummyReportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dummy_report_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DummyReport), 0, (GInstanceInitFunc) dummy_report_instance_init, NULL };
		GType dummy_report_type_id;
		dummy_report_type_id = g_type_register_static (VALA_TYPE_REPORT, "DummyReport", &g_define_type_info, 0);
		g_once_init_leave (&dummy_report_type_id__volatile, dummy_report_type_id);
	}
	return dummy_report_type_id__volatile;
}


static void _ctags_entry_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (ctags_entry_free (var), NULL));
}


static void _g_list_free__ctags_entry_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _ctags_entry_free0_, NULL);
	g_list_free (self);
}


CTagsVisitor* ctags_visitor_construct (GType object_type) {
	CTagsVisitor* self = NULL;
	ValaParser* _tmp0_ = NULL;
	ValaParser* _tmp1_;
	ValaGenieParser* _tmp2_ = NULL;
	ValaGenieParser* _tmp3_;
	self = (CTagsVisitor*) vala_code_visitor_construct (object_type);
	_tmp0_ = vala_parser_new ();
	_tmp1_ = _tmp0_;
	_vala_code_visitor_unref0 (self->priv->vala_parser);
	self->priv->vala_parser = _tmp1_;
	_tmp2_ = vala_genie_parser_new ();
	_tmp3_ = _tmp2_;
	_vala_code_visitor_unref0 (self->priv->genie_parser);
	self->priv->genie_parser = _tmp3_;
	return self;
}


CTagsVisitor* ctags_visitor_new (void) {
	return ctags_visitor_construct (TYPE_CTAGS_VISITOR);
}


static gchar* ctags_visitor_get_access (ValaSymbol* sym) {
	gchar* result = NULL;
	ValaSymbolAccessibility _tmp0_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_symbol_get_access (sym);
	switch (_tmp0_) {
		case VALA_SYMBOL_ACCESSIBILITY_PRIVATE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("private");
			result = _tmp1_;
			return result;
		}
		case VALA_SYMBOL_ACCESSIBILITY_INTERNAL:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("internal");
			result = _tmp2_;
			return result;
		}
		case VALA_SYMBOL_ACCESSIBILITY_PROTECTED:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("protected");
			result = _tmp3_;
			return result;
		}
		case VALA_SYMBOL_ACCESSIBILITY_PUBLIC:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("public");
			result = _tmp4_;
			return result;
		}
	}
	g_assert_not_reached ();
}


static gchar* ctags_visitor_to_string (ValaIterable* seq, const gchar* sep) {
	gchar* result = NULL;
	GString* _tmp0_ = NULL;
	GString* str;
	gboolean first;
	gchar* _tmp6_;
	g_return_val_if_fail (seq != NULL, NULL);
	g_return_val_if_fail (sep != NULL, NULL);
	_tmp0_ = g_string_new ("");
	str = _tmp0_;
	first = TRUE;
	{
		ValaIterator* _tmp1_ = NULL;
		ValaIterator* _type_it;
		_tmp1_ = vala_iterable_iterator (seq);
		_type_it = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			gpointer _tmp3_ = NULL;
			ValaDataType* type;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			_tmp2_ = vala_iterator_next (_type_it);
			if (!_tmp2_) {
				break;
			}
			_tmp3_ = vala_iterator_get (_type_it);
			type = (ValaDataType*) _tmp3_;
			if (first) {
				first = FALSE;
			} else {
				g_string_append (str, sep);
			}
			_tmp4_ = vala_data_type_to_qualified_string (type, NULL);
			_tmp5_ = _tmp4_;
			g_string_append (str, _tmp5_);
			_g_free0 (_tmp5_);
			_vala_code_node_unref0 (type);
		}
		_vala_iterator_unref0 (_type_it);
	}
	_tmp6_ = g_strdup (str->str);
	result = _tmp6_;
	_g_string_free0 (str);
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static gchar* ctags_visitor_implementation (ValaSymbol* sym) {
	gchar* result = NULL;
	GList* list;
	GString* _tmp16_ = NULL;
	GString* ret;
	gboolean first;
	gchar* _tmp18_;
	g_return_val_if_fail (sym != NULL, NULL);
	list = NULL;
	if (VALA_IS_SIGNAL (sym)) {
		ValaSignal* _tmp0_;
		ValaSignal* sig;
		gboolean _tmp1_;
		_tmp0_ = _vala_code_node_ref0 (VALA_SIGNAL (sym));
		sig = _tmp0_;
		_tmp1_ = vala_signal_get_is_virtual (sig);
		if (_tmp1_) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("virtual");
			list = g_list_append (list, _tmp2_);
		}
		_vala_code_node_unref0 (sig);
	} else {
		if (VALA_IS_CLASS (sym)) {
			ValaClass* _tmp3_;
			ValaClass* cls;
			gboolean _tmp4_;
			_tmp3_ = _vala_code_node_ref0 (VALA_CLASS (sym));
			cls = _tmp3_;
			_tmp4_ = vala_class_get_is_abstract (cls);
			if (_tmp4_) {
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("abstract");
				list = g_list_append (list, _tmp5_);
			}
			_vala_code_node_unref0 (cls);
		} else {
			if (VALA_IS_METHOD (sym)) {
				ValaMethod* _tmp6_;
				ValaMethod* meth;
				gboolean _tmp7_;
				_tmp6_ = _vala_code_node_ref0 (VALA_METHOD (sym));
				meth = _tmp6_;
				_tmp7_ = vala_method_get_is_abstract (meth);
				if (_tmp7_) {
					gchar* _tmp8_;
					_tmp8_ = g_strdup ("abstract");
					list = g_list_append (list, _tmp8_);
				} else {
					gboolean _tmp9_;
					_tmp9_ = vala_method_get_is_virtual (meth);
					if (_tmp9_) {
						gchar* _tmp10_;
						_tmp10_ = g_strdup ("virtual");
						list = g_list_append (list, _tmp10_);
					}
				}
				_vala_code_node_unref0 (meth);
			} else {
				if (VALA_IS_PROPERTY (sym)) {
					ValaProperty* _tmp11_;
					ValaProperty* prop;
					gboolean _tmp12_;
					_tmp11_ = _vala_code_node_ref0 (VALA_PROPERTY (sym));
					prop = _tmp11_;
					_tmp12_ = vala_property_get_is_abstract (prop);
					if (_tmp12_) {
						gchar* _tmp13_;
						_tmp13_ = g_strdup ("abstract");
						list = g_list_append (list, _tmp13_);
					} else {
						gboolean _tmp14_;
						_tmp14_ = vala_property_get_is_virtual (prop);
						if (_tmp14_) {
							gchar* _tmp15_;
							_tmp15_ = g_strdup ("virtual");
							list = g_list_append (list, _tmp15_);
						}
					}
					_vala_code_node_unref0 (prop);
				} else {
					g_return_val_if_reached (NULL);
				}
			}
		}
	}
	_tmp16_ = g_string_new ("");
	ret = _tmp16_;
	first = TRUE;
	{
		GList* str_collection;
		GList* str_it;
		str_collection = list;
		for (str_it = str_collection; str_it != NULL; str_it = str_it->next) {
			gchar* _tmp17_;
			gchar* str;
			_tmp17_ = g_strdup ((const gchar*) str_it->data);
			str = _tmp17_;
			{
				if (first) {
					first = FALSE;
				} else {
					g_string_append (ret, ",");
				}
				g_string_append (ret, str);
				_g_free0 (str);
			}
		}
	}
	_tmp18_ = g_strdup (ret->str);
	result = _tmp18_;
	_g_string_free0 (ret);
	__g_list_free__g_free0_0 (list);
	return result;
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static gchar* ctags_visitor_signature (ValaList* parameter) {
	gchar* result = NULL;
	GString* _tmp0_ = NULL;
	GString* ret;
	gboolean first;
	gchar* _tmp9_;
	g_return_val_if_fail (parameter != NULL, NULL);
	_tmp0_ = g_string_new ("(");
	ret = _tmp0_;
	first = TRUE;
	{
		ValaList* _tmp1_;
		ValaList* _p_list;
		gint _tmp2_;
		gint _p_size;
		gint _p_index;
		_tmp1_ = _vala_iterable_ref0 (parameter);
		_p_list = _tmp1_;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _p_list);
		_p_size = _tmp2_;
		_p_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			ValaParameter* p;
			gboolean _tmp4_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp3_ = vala_list_get (_p_list, _p_index);
			p = (ValaParameter*) _tmp3_;
			if (first) {
				first = FALSE;
			} else {
				g_string_append (ret, ",");
			}
			_tmp4_ = vala_parameter_get_ellipsis (p);
			if (_tmp4_) {
				g_string_append (ret, "...");
			} else {
				ValaDataType* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				const gchar* _tmp8_ = NULL;
				_tmp5_ = vala_variable_get_variable_type ((ValaVariable*) p);
				_tmp6_ = vala_data_type_to_qualified_string (_tmp5_, NULL);
				_tmp7_ = _tmp6_;
				g_string_append (ret, _tmp7_);
				_g_free0 (_tmp7_);
				g_string_append (ret, " ");
				_tmp8_ = vala_symbol_get_name ((ValaSymbol*) p);
				g_string_append (ret, _tmp8_);
			}
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	g_string_append (ret, ")");
	_tmp9_ = g_strdup (ret->str);
	result = _tmp9_;
	_g_string_free0 (ret);
	return result;
}


static void ctags_visitor_scope (ValaSymbol* s, gchar** scope, int scope_length1) {
	ValaSymbol* _tmp0_ = NULL;
	ValaSymbol* _tmp1_;
	ValaSymbol* par;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (s != NULL);
	_tmp0_ = vala_symbol_get_parent_symbol (s);
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	par = _tmp1_;
	if (par != NULL) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = vala_symbol_get_name (par);
		_tmp2_ = _tmp3_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		if (VALA_IS_CLASS (par)) {
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = g_strdup ("class");
			_tmp5_ = _tmp4_;
			_g_free0 (scope[0]);
			scope[0] = _tmp5_;
		} else {
			if (VALA_IS_STRUCT (par)) {
				gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp6_ = g_strdup ("struct");
				_tmp7_ = _tmp6_;
				_g_free0 (scope[0]);
				scope[0] = _tmp7_;
			} else {
				if (VALA_IS_INTERFACE (par)) {
					gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = g_strdup ("interface");
					_tmp9_ = _tmp8_;
					_g_free0 (scope[0]);
					scope[0] = _tmp9_;
				} else {
					_vala_code_node_unref0 (par);
					return;
				}
			}
		}
		_tmp10_ = vala_symbol_get_name (par);
		_tmp11_ = g_strdup (_tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (scope[1]);
		scope[1] = _tmp12_;
	}
	_vala_code_node_unref0 (par);
}


static void ctags_visitor_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	CTagsVisitor * self;
	self = (CTagsVisitor*) base;
	g_return_if_fail (source_file != NULL);
	vala_source_file_accept_children (source_file, (ValaCodeVisitor*) self);
}


static gpointer _ctags_entry_dup0 (gpointer self) {
	return self ? ctags_entry_dup (self) : NULL;
}


static void ctags_visitor_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	CTagsVisitor * self;
	CTagsEntry entry = {0};
	ValaSourceReference* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	ValaList* _tmp11_ = NULL;
	ValaList* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	CTagsEntry* _tmp15_;
	self = (CTagsVisitor*) base;
	g_return_if_fail (cl != NULL);
	memset (&entry, 0, sizeof (CTagsEntry));
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) cl);
	_tmp1_ = vala_source_reference_get_first_line (_tmp0_);
	entry.line_number = _tmp1_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) cl);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (entry.name);
	entry.name = _tmp4_;
	_tmp5_ = g_strdup ("class");
	_tmp6_ = _tmp5_;
	_g_free0 (entry.kind_name);
	entry.kind_name = _tmp6_;
	entry.kind = 'c';
	_tmp7_ = ctags_visitor_get_access ((ValaSymbol*) cl);
	_tmp8_ = _tmp7_;
	_g_free0 (entry.access);
	entry.access = _tmp8_;
	_tmp9_ = ctags_visitor_implementation ((ValaSymbol*) cl);
	_tmp10_ = _tmp9_;
	_g_free0 (entry.implementation);
	entry.implementation = _tmp10_;
	_tmp11_ = vala_class_get_base_types (cl);
	_tmp12_ = _tmp11_;
	_tmp13_ = ctags_visitor_to_string ((ValaIterable*) _tmp12_, ",");
	_tmp14_ = _tmp13_;
	_g_free0 (entry.inheritance);
	entry.inheritance = _tmp14_;
	_vala_iterable_unref0 (_tmp12_);
	ctags_visitor_scope ((ValaSymbol*) cl, entry.scope, 2);
	_tmp15_ = _ctags_entry_dup0 (&entry);
	self->priv->taglist = g_list_append (self->priv->taglist, _tmp15_);
	vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) self);
	ctags_entry_destroy (&entry);
}


static void ctags_visitor_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	CTagsVisitor * self;
	CTagsEntry entry = {0};
	ValaSourceReference* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	CTagsEntry* _tmp9_;
	self = (CTagsVisitor*) base;
	g_return_if_fail (st != NULL);
	memset (&entry, 0, sizeof (CTagsEntry));
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) st);
	_tmp1_ = vala_source_reference_get_first_line (_tmp0_);
	entry.line_number = _tmp1_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) st);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (entry.name);
	entry.name = _tmp4_;
	_tmp5_ = g_strdup ("struct");
	_tmp6_ = _tmp5_;
	_g_free0 (entry.kind_name);
	entry.kind_name = _tmp6_;
	entry.kind = 's';
	_tmp7_ = ctags_visitor_get_access ((ValaSymbol*) st);
	_tmp8_ = _tmp7_;
	_g_free0 (entry.access);
	entry.access = _tmp8_;
	ctags_visitor_scope ((ValaSymbol*) st, entry.scope, 2);
	_tmp9_ = _ctags_entry_dup0 (&entry);
	self->priv->taglist = g_list_append (self->priv->taglist, _tmp9_);
	vala_code_node_accept_children ((ValaCodeNode*) st, (ValaCodeVisitor*) self);
	ctags_entry_destroy (&entry);
}


static void ctags_visitor_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	CTagsVisitor * self;
	CTagsEntry entry = {0};
	ValaSourceReference* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	ValaList* _tmp9_ = NULL;
	ValaList* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	CTagsEntry* _tmp13_;
	self = (CTagsVisitor*) base;
	g_return_if_fail (iface != NULL);
	memset (&entry, 0, sizeof (CTagsEntry));
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) iface);
	_tmp1_ = vala_source_reference_get_first_line (_tmp0_);
	entry.line_number = _tmp1_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) iface);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (entry.name);
	entry.name = _tmp4_;
	_tmp5_ = g_strdup ("interface");
	_tmp6_ = _tmp5_;
	_g_free0 (entry.kind_name);
	entry.kind_name = _tmp6_;
	entry.kind = 'i';
	_tmp7_ = ctags_visitor_get_access ((ValaSymbol*) iface);
	_tmp8_ = _tmp7_;
	_g_free0 (entry.access);
	entry.access = _tmp8_;
	_tmp9_ = vala_interface_get_prerequisites (iface);
	_tmp10_ = _tmp9_;
	_tmp11_ = ctags_visitor_to_string ((ValaIterable*) _tmp10_, ",");
	_tmp12_ = _tmp11_;
	_g_free0 (entry.inheritance);
	entry.inheritance = _tmp12_;
	_vala_iterable_unref0 (_tmp10_);
	ctags_visitor_scope ((ValaSymbol*) iface, entry.scope, 2);
	_tmp13_ = _ctags_entry_dup0 (&entry);
	self->priv->taglist = g_list_append (self->priv->taglist, _tmp13_);
	vala_code_node_accept_children ((ValaCodeNode*) iface, (ValaCodeVisitor*) self);
	ctags_entry_destroy (&entry);
}


static void ctags_visitor_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	CTagsVisitor * self;
	CTagsEntry entry = {0};
	ValaSourceReference* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	CTagsEntry* _tmp9_;
	self = (CTagsVisitor*) base;
	g_return_if_fail (en != NULL);
	memset (&entry, 0, sizeof (CTagsEntry));
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) en);
	_tmp1_ = vala_source_reference_get_first_line (_tmp0_);
	entry.line_number = _tmp1_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) en);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (entry.name);
	entry.name = _tmp4_;
	_tmp5_ = g_strdup ("enum");
	_tmp6_ = _tmp5_;
	_g_free0 (entry.kind_name);
	entry.kind_name = _tmp6_;
	entry.kind = 'e';
	_tmp7_ = ctags_visitor_get_access ((ValaSymbol*) en);
	_tmp8_ = _tmp7_;
	_g_free0 (entry.access);
	entry.access = _tmp8_;
	ctags_visitor_scope ((ValaSymbol*) en, entry.scope, 2);
	_tmp9_ = _ctags_entry_dup0 (&entry);
	self->priv->taglist = g_list_append (self->priv->taglist, _tmp9_);
	vala_code_node_accept_children ((ValaCodeNode*) en, (ValaCodeVisitor*) self);
	ctags_entry_destroy (&entry);
}


static void ctags_visitor_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain) {
	CTagsVisitor * self;
	CTagsEntry entry = {0};
	ValaSourceReference* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	CTagsEntry* _tmp9_;
	self = (CTagsVisitor*) base;
	g_return_if_fail (edomain != NULL);
	memset (&entry, 0, sizeof (CTagsEntry));
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) edomain);
	_tmp1_ = vala_source_reference_get_first_line (_tmp0_);
	entry.line_number = _tmp1_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) edomain);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (entry.name);
	entry.name = _tmp4_;
	_tmp5_ = g_strdup ("errordomain");
	_tmp6_ = _tmp5_;
	_g_free0 (entry.kind_name);
	entry.kind_name = _tmp6_;
	entry.kind = 'E';
	_tmp7_ = ctags_visitor_get_access ((ValaSymbol*) edomain);
	_tmp8_ = _tmp7_;
	_g_free0 (entry.access);
	entry.access = _tmp8_;
	ctags_visitor_scope ((ValaSymbol*) edomain, entry.scope, 2);
	_tmp9_ = _ctags_entry_dup0 (&entry);
	self->priv->taglist = g_list_append (self->priv->taglist, _tmp9_);
	vala_code_node_accept_children ((ValaCodeNode*) edomain, (ValaCodeVisitor*) self);
	ctags_entry_destroy (&entry);
}


static void ctags_visitor_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev) {
	CTagsVisitor * self;
	CTagsEntry entry = {0};
	ValaSourceReference* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	CTagsEntry* _tmp9_;
	self = (CTagsVisitor*) base;
	g_return_if_fail (ev != NULL);
	memset (&entry, 0, sizeof (CTagsEntry));
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) ev);
	_tmp1_ = vala_source_reference_get_first_line (_tmp0_);
	entry.line_number = _tmp1_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) ev);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (entry.name);
	entry.name = _tmp4_;
	_tmp5_ = g_strdup ("enumvalue");
	_tmp6_ = _tmp5_;
	_g_free0 (entry.kind_name);
	entry.kind_name = _tmp6_;
	entry.kind = 'v';
	_tmp7_ = ctags_visitor_get_access ((ValaSymbol*) ev);
	_tmp8_ = _tmp7_;
	_g_free0 (entry.access);
	entry.access = _tmp8_;
	ctags_visitor_scope ((ValaSymbol*) ev, entry.scope, 2);
	_tmp9_ = _ctags_entry_dup0 (&entry);
	self->priv->taglist = g_list_append (self->priv->taglist, _tmp9_);
	ctags_entry_destroy (&entry);
}


static void ctags_visitor_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode) {
	CTagsVisitor * self;
	CTagsEntry entry = {0};
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	CTagsEntry* _tmp7_;
	self = (CTagsVisitor*) base;
	g_return_if_fail (ecode != NULL);
	memset (&entry, 0, sizeof (CTagsEntry));
	_tmp0_ = vala_symbol_get_name ((ValaSymbol*) ecode);
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = _tmp1_;
	_g_free0 (entry.name);
	entry.name = _tmp2_;
	_tmp3_ = g_strdup ("errorcode");
	_tmp4_ = _tmp3_;
	_g_free0 (entry.kind_name);
	entry.kind_name = _tmp4_;
	entry.kind = 'r';
	_tmp5_ = ctags_visitor_get_access ((ValaSymbol*) ecode);
	_tmp6_ = _tmp5_;
	_g_free0 (entry.access);
	entry.access = _tmp6_;
	ctags_visitor_scope ((ValaSymbol*) ecode, entry.scope, 2);
	_tmp7_ = _ctags_entry_dup0 (&entry);
	self->priv->taglist = g_list_append (self->priv->taglist, _tmp7_);
	ctags_entry_destroy (&entry);
}


static void ctags_visitor_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d) {
	CTagsVisitor * self;
	CTagsEntry entry = {0};
	ValaSourceReference* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	ValaDataType* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	ValaList* _tmp12_ = NULL;
	ValaList* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	CTagsEntry* _tmp16_;
	self = (CTagsVisitor*) base;
	g_return_if_fail (d != NULL);
	memset (&entry, 0, sizeof (CTagsEntry));
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
	_tmp1_ = vala_source_reference_get_first_line (_tmp0_);
	entry.line_number = _tmp1_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) d);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (entry.name);
	entry.name = _tmp4_;
	_tmp5_ = g_strdup ("delegate");
	_tmp6_ = _tmp5_;
	_g_free0 (entry.kind_name);
	entry.kind_name = _tmp6_;
	entry.kind = 'd';
	_tmp7_ = ctags_visitor_get_access ((ValaSymbol*) d);
	_tmp8_ = _tmp7_;
	_g_free0 (entry.access);
	entry.access = _tmp8_;
	ctags_visitor_scope ((ValaSymbol*) d, entry.scope, 2);
	_tmp9_ = vala_delegate_get_return_type (d);
	_tmp10_ = vala_data_type_to_qualified_string (_tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (entry.returntype);
	entry.returntype = _tmp11_;
	_tmp12_ = vala_delegate_get_parameters (d);
	_tmp13_ = _tmp12_;
	_tmp14_ = ctags_visitor_signature (_tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (entry.signature);
	entry.signature = _tmp15_;
	_vala_iterable_unref0 (_tmp13_);
	_tmp16_ = _ctags_entry_dup0 (&entry);
	self->priv->taglist = g_list_append (self->priv->taglist, _tmp16_);
	ctags_entry_destroy (&entry);
}


static void ctags_visitor_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	CTagsVisitor * self;
	CTagsEntry entry = {0};
	ValaSourceReference* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	ValaDataType* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	ValaList* _tmp14_ = NULL;
	ValaList* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	CTagsEntry* _tmp18_;
	self = (CTagsVisitor*) base;
	g_return_if_fail (sig != NULL);
	memset (&entry, 0, sizeof (CTagsEntry));
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) sig);
	_tmp1_ = vala_source_reference_get_first_line (_tmp0_);
	entry.line_number = _tmp1_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) sig);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (entry.name);
	entry.name = _tmp4_;
	_tmp5_ = g_strdup ("signal");
	_tmp6_ = _tmp5_;
	_g_free0 (entry.kind_name);
	entry.kind_name = _tmp6_;
	entry.kind = 'S';
	_tmp7_ = ctags_visitor_get_access ((ValaSymbol*) sig);
	_tmp8_ = _tmp7_;
	_g_free0 (entry.access);
	entry.access = _tmp8_;
	_tmp9_ = ctags_visitor_implementation ((ValaSymbol*) sig);
	_tmp10_ = _tmp9_;
	_g_free0 (entry.implementation);
	entry.implementation = _tmp10_;
	ctags_visitor_scope ((ValaSymbol*) sig, entry.scope, 2);
	_tmp11_ = vala_signal_get_return_type (sig);
	_tmp12_ = vala_data_type_to_qualified_string (_tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_g_free0 (entry.returntype);
	entry.returntype = _tmp13_;
	_tmp14_ = vala_signal_get_parameters (sig);
	_tmp15_ = _tmp14_;
	_tmp16_ = ctags_visitor_signature (_tmp15_);
	_tmp17_ = _tmp16_;
	_g_free0 (entry.signature);
	entry.signature = _tmp17_;
	_vala_iterable_unref0 (_tmp15_);
	_tmp18_ = _ctags_entry_dup0 (&entry);
	self->priv->taglist = g_list_append (self->priv->taglist, _tmp18_);
	ctags_entry_destroy (&entry);
}


static void ctags_visitor_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	CTagsVisitor * self;
	CTagsEntry entry = {0};
	ValaSourceReference* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	ValaDataType* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	CTagsEntry* _tmp12_;
	self = (CTagsVisitor*) base;
	g_return_if_fail (f != NULL);
	memset (&entry, 0, sizeof (CTagsEntry));
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
	_tmp1_ = vala_source_reference_get_first_line (_tmp0_);
	entry.line_number = _tmp1_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) f);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (entry.name);
	entry.name = _tmp4_;
	_tmp5_ = g_strdup ("field");
	_tmp6_ = _tmp5_;
	_g_free0 (entry.kind_name);
	entry.kind_name = _tmp6_;
	entry.kind = 'f';
	_tmp7_ = ctags_visitor_get_access ((ValaSymbol*) f);
	_tmp8_ = _tmp7_;
	_g_free0 (entry.access);
	entry.access = _tmp8_;
	ctags_visitor_scope ((ValaSymbol*) f, entry.scope, 2);
	_tmp9_ = vala_variable_get_variable_type ((ValaVariable*) f);
	_tmp10_ = vala_data_type_to_qualified_string (_tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (entry.typeref);
	entry.typeref = _tmp11_;
	_tmp12_ = _ctags_entry_dup0 (&entry);
	self->priv->taglist = g_list_append (self->priv->taglist, _tmp12_);
	ctags_entry_destroy (&entry);
}


static void ctags_visitor_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	CTagsVisitor * self;
	CTagsEntry entry = {0};
	ValaSourceReference* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	ValaDataType* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	CTagsEntry* _tmp12_;
	self = (CTagsVisitor*) base;
	g_return_if_fail (c != NULL);
	memset (&entry, 0, sizeof (CTagsEntry));
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
	_tmp1_ = vala_source_reference_get_first_line (_tmp0_);
	entry.line_number = _tmp1_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) c);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (entry.name);
	entry.name = _tmp4_;
	_tmp5_ = g_strdup ("field");
	_tmp6_ = _tmp5_;
	_g_free0 (entry.kind_name);
	entry.kind_name = _tmp6_;
	entry.kind = 'f';
	_tmp7_ = ctags_visitor_get_access ((ValaSymbol*) c);
	_tmp8_ = _tmp7_;
	_g_free0 (entry.access);
	entry.access = _tmp8_;
	ctags_visitor_scope ((ValaSymbol*) c, entry.scope, 2);
	_tmp9_ = vala_constant_get_type_reference (c);
	_tmp10_ = vala_data_type_to_qualified_string (_tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (entry.typeref);
	entry.typeref = _tmp11_;
	_tmp12_ = _ctags_entry_dup0 (&entry);
	self->priv->taglist = g_list_append (self->priv->taglist, _tmp12_);
	ctags_entry_destroy (&entry);
}


static void ctags_visitor_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	CTagsVisitor * self;
	CTagsEntry entry = {0};
	ValaSourceReference* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	ValaDataType* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	CTagsEntry* _tmp14_;
	self = (CTagsVisitor*) base;
	g_return_if_fail (prop != NULL);
	memset (&entry, 0, sizeof (CTagsEntry));
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
	_tmp1_ = vala_source_reference_get_first_line (_tmp0_);
	entry.line_number = _tmp1_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (entry.name);
	entry.name = _tmp4_;
	_tmp5_ = g_strdup ("property");
	_tmp6_ = _tmp5_;
	_g_free0 (entry.kind_name);
	entry.kind_name = _tmp6_;
	entry.kind = 'p';
	_tmp7_ = ctags_visitor_get_access ((ValaSymbol*) prop);
	_tmp8_ = _tmp7_;
	_g_free0 (entry.access);
	entry.access = _tmp8_;
	_tmp9_ = ctags_visitor_implementation ((ValaSymbol*) prop);
	_tmp10_ = _tmp9_;
	_g_free0 (entry.implementation);
	entry.implementation = _tmp10_;
	ctags_visitor_scope ((ValaSymbol*) prop, entry.scope, 2);
	_tmp11_ = vala_property_get_property_type (prop);
	_tmp12_ = vala_data_type_to_qualified_string (_tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_g_free0 (entry.typeref);
	entry.typeref = _tmp13_;
	_tmp14_ = _ctags_entry_dup0 (&entry);
	self->priv->taglist = g_list_append (self->priv->taglist, _tmp14_);
	ctags_entry_destroy (&entry);
}


static void ctags_visitor_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	CTagsVisitor * self;
	CTagsEntry entry = {0};
	ValaSourceReference* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	ValaDataType* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	ValaList* _tmp14_ = NULL;
	ValaList* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	CTagsEntry* _tmp18_;
	self = (CTagsVisitor*) base;
	g_return_if_fail (m != NULL);
	memset (&entry, 0, sizeof (CTagsEntry));
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
	_tmp1_ = vala_source_reference_get_first_line (_tmp0_);
	entry.line_number = _tmp1_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) m);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (entry.name);
	entry.name = _tmp4_;
	_tmp5_ = g_strdup ("method");
	_tmp6_ = _tmp5_;
	_g_free0 (entry.kind_name);
	entry.kind_name = _tmp6_;
	entry.kind = 'm';
	_tmp7_ = ctags_visitor_get_access ((ValaSymbol*) m);
	_tmp8_ = _tmp7_;
	_g_free0 (entry.access);
	entry.access = _tmp8_;
	_tmp9_ = ctags_visitor_implementation ((ValaSymbol*) m);
	_tmp10_ = _tmp9_;
	_g_free0 (entry.implementation);
	entry.implementation = _tmp10_;
	ctags_visitor_scope ((ValaSymbol*) m, entry.scope, 2);
	_tmp11_ = vala_method_get_return_type (m);
	_tmp12_ = vala_data_type_to_qualified_string (_tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_g_free0 (entry.returntype);
	entry.returntype = _tmp13_;
	_tmp14_ = vala_method_get_parameters (m);
	_tmp15_ = _tmp14_;
	_tmp16_ = ctags_visitor_signature (_tmp15_);
	_tmp17_ = _tmp16_;
	_g_free0 (entry.signature);
	entry.signature = _tmp17_;
	_vala_iterable_unref0 (_tmp15_);
	_tmp18_ = _ctags_entry_dup0 (&entry);
	self->priv->taglist = g_list_append (self->priv->taglist, _tmp18_);
	ctags_entry_destroy (&entry);
}


static void ctags_visitor_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local) {
	CTagsVisitor * self;
	CTagsEntry entry = {0};
	ValaSourceReference* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	CTagsEntry* _tmp9_;
	self = (CTagsVisitor*) base;
	g_return_if_fail (local != NULL);
	memset (&entry, 0, sizeof (CTagsEntry));
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) local);
	_tmp1_ = vala_source_reference_get_first_line (_tmp0_);
	entry.line_number = _tmp1_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) local);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (entry.name);
	entry.name = _tmp4_;
	_tmp5_ = g_strdup ("local");
	_tmp6_ = _tmp5_;
	_g_free0 (entry.kind_name);
	entry.kind_name = _tmp6_;
	entry.kind = 'l';
	_tmp7_ = ctags_visitor_get_access ((ValaSymbol*) local);
	_tmp8_ = _tmp7_;
	_g_free0 (entry.access);
	entry.access = _tmp8_;
	_tmp9_ = _ctags_entry_dup0 (&entry);
	self->priv->taglist = g_list_append (self->priv->taglist, _tmp9_);
	ctags_entry_destroy (&entry);
}


void ctags_visitor_parse_vala (CTagsVisitor* self, const gchar* filename, CTagsEntryMaker maker) {
	GList* _tmp0_;
	ValaCodeContext* _tmp1_ = NULL;
	ValaCodeContext* context;
	DummyReport* _tmp2_ = NULL;
	DummyReport* _tmp3_;
	ValaSourceFileType _tmp4_ = 0;
	gboolean _tmp5_;
	ValaSourceFile* _tmp6_ = NULL;
	ValaSourceFile* source_file;
	GList* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = NULL;
	__g_list_free__ctags_entry_free0_0 (self->priv->taglist);
	self->priv->taglist = _tmp0_;
	_tmp1_ = vala_code_context_new ();
	context = _tmp1_;
	_tmp2_ = dummy_report_new ();
	_tmp3_ = _tmp2_;
	vala_code_context_set_report (context, (ValaReport*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp5_ = g_str_has_suffix (filename, "vapi");
	if (_tmp5_) {
		_tmp4_ = VALA_SOURCE_FILE_TYPE_PACKAGE;
	} else {
		_tmp4_ = VALA_SOURCE_FILE_TYPE_SOURCE;
	}
	_tmp6_ = vala_source_file_new (context, _tmp4_, filename, NULL);
	source_file = _tmp6_;
	vala_code_context_push (context);
	vala_code_context_add_source_file (context, source_file);
	vala_parser_parse (self->priv->vala_parser, context);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	{
		GList* tagentry_collection;
		GList* tagentry_it;
		tagentry_collection = self->priv->taglist;
		for (tagentry_it = tagentry_collection; tagentry_it != NULL; tagentry_it = tagentry_it->next) {
			CTagsEntry* _tmp7_;
			CTagsEntry* tagentry;
			_tmp7_ = _ctags_entry_dup0 ((CTagsEntry*) tagentry_it->data);
			tagentry = _tmp7_;
			{
				maker (tagentry);
				_ctags_entry_free0 (tagentry);
			}
		}
	}
	_tmp8_ = NULL;
	__g_list_free__ctags_entry_free0_0 (self->priv->taglist);
	self->priv->taglist = _tmp8_;
	vala_code_context_pop ();
	_vala_source_file_unref0 (source_file);
	_vala_code_context_unref0 (context);
}


void ctags_visitor_parse_genie (CTagsVisitor* self, const gchar* filename, CTagsEntryMaker maker) {
	GList* _tmp0_;
	ValaCodeContext* _tmp1_ = NULL;
	ValaCodeContext* context;
	DummyReport* _tmp2_ = NULL;
	DummyReport* _tmp3_;
	ValaSourceFile* _tmp4_ = NULL;
	ValaSourceFile* source_file;
	GList* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = NULL;
	__g_list_free__ctags_entry_free0_0 (self->priv->taglist);
	self->priv->taglist = _tmp0_;
	_tmp1_ = vala_code_context_new ();
	context = _tmp1_;
	_tmp2_ = dummy_report_new ();
	_tmp3_ = _tmp2_;
	vala_code_context_set_report (context, (ValaReport*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = vala_source_file_new (context, VALA_SOURCE_FILE_TYPE_SOURCE, filename, NULL);
	source_file = _tmp4_;
	vala_code_context_add_source_file (context, source_file);
	vala_code_context_push (context);
	vala_genie_parser_parse (self->priv->genie_parser, context);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	{
		GList* tagentry_collection;
		GList* tagentry_it;
		tagentry_collection = self->priv->taglist;
		for (tagentry_it = tagentry_collection; tagentry_it != NULL; tagentry_it = tagentry_it->next) {
			CTagsEntry* _tmp5_;
			CTagsEntry* tagentry;
			_tmp5_ = _ctags_entry_dup0 ((CTagsEntry*) tagentry_it->data);
			tagentry = _tmp5_;
			{
				maker (tagentry);
				_ctags_entry_free0 (tagentry);
			}
		}
	}
	_tmp6_ = NULL;
	__g_list_free__ctags_entry_free0_0 (self->priv->taglist);
	self->priv->taglist = _tmp6_;
	vala_code_context_pop ();
	_vala_source_file_unref0 (source_file);
	_vala_code_context_unref0 (context);
}


static void ctags_visitor_class_init (CTagsVisitorClass * klass) {
	ctags_visitor_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = ctags_visitor_finalize;
	g_type_class_add_private (klass, sizeof (CTagsVisitorPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = ctags_visitor_real_visit_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = ctags_visitor_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = ctags_visitor_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = ctags_visitor_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = ctags_visitor_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = ctags_visitor_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum_value = ctags_visitor_real_visit_enum_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_code = ctags_visitor_real_visit_error_code;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = ctags_visitor_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = ctags_visitor_real_visit_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = ctags_visitor_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = ctags_visitor_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = ctags_visitor_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = ctags_visitor_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_local_variable = ctags_visitor_real_visit_local_variable;
}


static void ctags_visitor_instance_init (CTagsVisitor * self) {
	self->priv = CTAGS_VISITOR_GET_PRIVATE (self);
}


static void ctags_visitor_finalize (ValaCodeVisitor* obj) {
	CTagsVisitor * self;
	self = CTAGS_VISITOR (obj);
	_vala_code_visitor_unref0 (self->priv->vala_parser);
	_vala_code_visitor_unref0 (self->priv->genie_parser);
	__g_list_free__ctags_entry_free0_0 (self->priv->taglist);
	VALA_CODE_VISITOR_CLASS (ctags_visitor_parent_class)->finalize (obj);
}


GType ctags_visitor_get_type (void) {
	static volatile gsize ctags_visitor_type_id__volatile = 0;
	if (g_once_init_enter (&ctags_visitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CTagsVisitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ctags_visitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CTagsVisitor), 0, (GInstanceInitFunc) ctags_visitor_instance_init, NULL };
		GType ctags_visitor_type_id;
		ctags_visitor_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "CTagsVisitor", &g_define_type_info, 0);
		g_once_init_leave (&ctags_visitor_type_id__volatile, ctags_visitor_type_id);
	}
	return ctags_visitor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



