// -*- c++ -*-
// Generated by gmmproc 2.45.31 -- DO NOT MODIFY!
#ifndef _ATKMM_TABLE_H
#define _ATKMM_TABLE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* $Id: table.hg,v 1.4 2006/04/12 11:11:24 murrayc Exp $ */

/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/interface.h>
#include <glibmm/arrayhandle.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C"
{
  typedef struct _AtkTableIface AtkTableIface;
  typedef struct _AtkTable      AtkTable;
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _AtkTable AtkTable;
typedef struct _AtkTableClass AtkTableClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Atk
{ class Table_Class; } // namespace Atk
#endif // DOXYGEN_SHOULD_SKIP_THIS

namespace Atk
{

class Object;

/** The ATK interface implemented for UI components which contain tabular or row/column information.
 * This should be implemented by components which present elements ordered via rows and columns. It may also be used to
 * present tree-structured information if the nodes of the trees can be said to contain multiple "columns". Individual
 * elements of an Atk::Table are typically referred to as "cells", and these cells are exposed by Atk::Table as child
 * Atk::Objects of the Atk::Table. Both row/column and child-index-based access to these children is provided.
 *
 * Children of Atk::Table are frequently "lightweight" objects, that is, they may not have backing widgets in the host UI
 * toolkit. They are therefore often transient.
 *
 * Since tables are often very complex, Atk::Table includes provision for offering simplified summary information, as
 * well as row and column headers and captions. Headers and captions are AtkObjects which may implement other interfaces
 * (Atk::Text, Atk::Image, etc.) as appropriate. Atk::Table summaries may themselves be (simplified) Atk::Tables, etc. 
 */

class Table : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Table CppObjectType;
  typedef Table_Class CppClassType;
  typedef AtkTable BaseObjectType;
  typedef AtkTableIface BaseClassType;

private:
  friend class Table_Class;
  static CppClassType table_class_;

  // noncopyable
  Table(const Table&);
  Table& operator=(const Table&);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  Table();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit Table(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit Table(AtkTable* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Table();

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  AtkTable*       gobj()       { return reinterpret_cast<AtkTable*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const AtkTable* gobj() const { return reinterpret_cast<AtkTable*>(gobject_); }

private:


public:
  
  /** Get a reference to the table cell at @a row, @a column. This cell
   * should implement the interface Atk::TableCell
   * 
   * @param row A <tt>int</tt> representing a row in @a table.
   * @param column A <tt>int</tt> representing a column in @a table.
   * @return An Atk::Object representing the referred
   * to accessible.
   */
  Glib::RefPtr<Atk::Object> get_at(int row, int column);
  
  /** Get a reference to the table cell at @a row, @a column. This cell
   * should implement the interface Atk::TableCell
   * 
   * @param row A <tt>int</tt> representing a row in @a table.
   * @param column A <tt>int</tt> representing a column in @a table.
   * @return An Atk::Object representing the referred
   * to accessible.
   */
  Glib::RefPtr<const Atk::Object> get_at(int row, int column) const;

  
#ifndef ATKMM_DISABLE_DEPRECATED

  /** Gets a <tt>int</tt> representing the index at the specified @a row and
   *  @a column.
   * 
   * Deprecated: Since 2.12. Use ref_at() in order to get the
   * accessible that represents the cell at ( @a row, @a column)
   * 
   * @deprecated Use get_at() instead.
   * 
   * @param row A <tt>int</tt> representing a row in @a table.
   * @param column A <tt>int</tt> representing a column in @a table.
   * @return A <tt>int</tt> representing the index at specified position.
   * The value -1 is returned if the object at row,column is not a child
   * of table or table does not implement this interface.
   */
  int get_index_at(int row, int column) const;
#endif // ATKMM_DISABLE_DEPRECATED


#ifndef ATKMM_DISABLE_DEPRECATED

  /** Gets a <tt>int</tt> representing the column at the specified @a index.
   * 
   * Deprecated: @newin{2,12}
   * 
   * @deprecated This should not be used in newly-written code.
   * 
   * @param index A <tt>int</tt> representing an index in @a table.
   * @return A <tt>int</tt> representing the column at the specified index,
   * or -1 if the table does not implement this method.
   */
  int get_column_at_index(int index) const;
#endif // ATKMM_DISABLE_DEPRECATED


#ifndef ATKMM_DISABLE_DEPRECATED

  /** Gets a <tt>int</tt> representing the row at the specified @a index.
   * 
   * Deprecated: since 2.12.
   * 
   * @deprecated This should not be used in newly-written code.
   * 
   * @param index A <tt>int</tt> representing an index in @a table.
   * @return A <tt>int</tt> representing the row at the specified index,
   * or -1 if the table does not implement this method.
   */
  int get_row_at_index(int index) const;
#endif // ATKMM_DISABLE_DEPRECATED


  /** Gets the number of columns in the table.
   * 
   * @return A <tt>int</tt> representing the number of columns, or 0
   * if value does not implement this interface.
   */
  int get_n_columns() const;
  
  /** Gets the number of rows in the table.
   * 
   * @return A <tt>int</tt> representing the number of rows, or 0
   * if value does not implement this interface.
   */
  int get_n_rows() const;
  
  /** Gets the number of columns occupied by the accessible object
   * at the specified @a row and @a column in the @a table.
   * 
   * @param row A <tt>int</tt> representing a row in @a table.
   * @param column A <tt>int</tt> representing a column in @a table.
   * @return A <tt>int</tt> representing the column extent at specified position, or 0
   * if value does not implement this interface.
   */
  int get_column_extent_at(int row, int column) const;
  
  /** Gets the number of rows occupied by the accessible object
   * at a specified @a row and @a column in the @a table.
   * 
   * @param row A <tt>int</tt> representing a row in @a table.
   * @param column A <tt>int</tt> representing a column in @a table.
   * @return A <tt>int</tt> representing the row extent at specified position, or 0
   * if value does not implement this interface.
   */
  int get_row_extent_at(int row, int column) const;
  
  
  /** Gets the caption for the @a table.
   * 
   * @return A AtkObject* representing the
   * table caption, or <tt>0</tt> if value does not implement this interface.
   */
  Glib::RefPtr<Atk::Object> get_caption();
  
  /** Gets the caption for the @a table.
   * 
   * @return A AtkObject* representing the
   * table caption, or <tt>0</tt> if value does not implement this interface.
   */
  Glib::RefPtr<const Atk::Object> get_caption() const;
  
  
  /** Gets the description text of the specified @a column in the table
   * 
   * @param column A <tt>int</tt> representing a column in @a table.
   * @return A gchar* representing the column description, or <tt>0</tt>
   * if value does not implement this interface.
   */
  Glib::ustring get_column_description(int column) const;
  
  
  /** Gets the column header of a specified column in an accessible table.
   * 
   * @param column A <tt>int</tt> representing a column in the table.
   * @return A AtkObject* representing the
   * specified column header, or <tt>0</tt> if value does not implement this
   * interface.
   */
  Glib::RefPtr<Atk::Object> get_column_header(int column);
  
  /** Gets the column header of a specified column in an accessible table.
   * 
   * @param column A <tt>int</tt> representing a column in the table.
   * @return A AtkObject* representing the
   * specified column header, or <tt>0</tt> if value does not implement this
   * interface.
   */
  Glib::RefPtr<const Atk::Object> get_column_header(int column) const;

  
  /** Gets the description text of the specified row in the table
   * 
   * @param row A <tt>int</tt> representing a row in @a table.
   * @return A gchar* representing the row description, or
   * <tt>0</tt> if value does not implement this interface.
   */
  Glib::ustring get_row_description(int row) const;

  
  /** Gets the row header of a specified row in an accessible table.
   * 
   * @param row A <tt>int</tt> representing a row in the table.
   * @return A AtkObject* representing the
   * specified row header, or <tt>0</tt> if value does not implement this
   * interface.
   */
  Glib::RefPtr<Atk::Object> get_row_header(int row);
  
  /** Gets the row header of a specified row in an accessible table.
   * 
   * @param row A <tt>int</tt> representing a row in the table.
   * @return A AtkObject* representing the
   * specified row header, or <tt>0</tt> if value does not implement this
   * interface.
   */
  Glib::RefPtr<const Atk::Object> get_row_header(int row) const;
  
  
  /** Gets the summary description of the table.
   * 
   * @return A AtkObject* representing a summary description
   * of the table, or zero if value does not implement this interface.
   */
  Glib::RefPtr<Atk::Object> get_summary();
  
  /** Gets the summary description of the table.
   * 
   * @return A AtkObject* representing a summary description
   * of the table, or zero if value does not implement this interface.
   */
  Glib::RefPtr<const Atk::Object> get_summary() const;
  
  
  /** Sets the caption for the table.
   * 
   * @param caption A Atk::Object representing the caption to set for @a table.
   */
  void set_caption(const Glib::RefPtr<Atk::Object>& caption);
  
  /** Sets the description text for the specified @a column of the @a table.
   * 
   * @param column A <tt>int</tt> representing a column in @a table.
   * @param description A #gchar representing the description text
   * to set for the specified @a column of the @a table.
   */
  void set_column_description(int column, const Glib::ustring& description);
  
  /** Sets the specified column header to @a header.
   * 
   * @param column A <tt>int</tt> representing a column in @a table.
   * @param header An Atk::Table.
   */
  void set_column_header(int column, const Glib::RefPtr<Atk::Object>& header);
  
  /** Sets the description text for the specified @a row of @a table.
   * 
   * @param row A <tt>int</tt> representing a row in @a table.
   * @param description A #gchar representing the description text
   * to set for the specified @a row of @a table.
   */
  void set_row_description(int row, const Glib::ustring& description);
  
  /** Sets the specified row header to @a header.
   * 
   * @param row A <tt>int</tt> representing a row in @a table.
   * @param header An Atk::Table.
   */
  void set_row_header(int row, const Glib::RefPtr<Atk::Object>& header);
  
  /** Sets the summary description of the table.
   * 
   * @param accessible An Atk::Object representing the summary description
   * to set for @a table.
   */
  void set_summary(const Glib::RefPtr<Atk::Object>& accessible);

  
  Glib::ArrayHandle<int> get_selected_columns() const;
  Glib::ArrayHandle<int> get_selected_rows() const;

  
  /** Gets a boolean value indicating whether the specified @a column
   * is selected
   * 
   * @param column A <tt>int</tt> representing a column in @a table.
   * @return A <tt>bool</tt> representing if the column is selected, or 0
   * if value does not implement this interface.
   */
  bool is_column_selected(int column) const;
  
  /** Gets a boolean value indicating whether the specified @a row
   * is selected
   * 
   * @param row A <tt>int</tt> representing a row in @a table.
   * @return A <tt>bool</tt> representing if the row is selected, or 0
   * if value does not implement this interface.
   */
  bool is_row_selected(int row) const;
  
  /** Gets a boolean value indicating whether the accessible object
   * at the specified @a row and @a column is selected
   * 
   * @param row A <tt>int</tt> representing a row in @a table.
   * @param column A <tt>int</tt> representing a column in @a table.
   * @return A <tt>bool</tt> representing if the cell is selected, or 0
   * if value does not implement this interface.
   */
  bool is_selected(int row, int column) const;
  
  /** Adds the specified @a row to the selection.
   * 
   * @param row A <tt>int</tt> representing a row in @a table.
   * @return A <tt>bool</tt> representing if row was successfully added to selection,
   * or 0 if value does not implement this interface.
   */
  bool add_row_selection(int row);
  
  /** Removes the specified @a row from the selection.
   * 
   * @param row A <tt>int</tt> representing a row in @a table.
   * @return A <tt>bool</tt> representing if the row was successfully removed from
   * the selection, or 0 if value does not implement this interface.
   */
  bool remove_row_selection(int row);
  
  /** Adds the specified @a column to the selection.
   * 
   * @param column A <tt>int</tt> representing a column in @a table.
   * @return A <tt>bool</tt> representing if the column was successfully added to 
   * the selection, or 0 if value does not implement this interface.
   */
  bool add_column_selection(int column);
  
  /** Adds the specified @a column to the selection.
   * 
   * @param column A <tt>int</tt> representing a column in @a table.
   * @return A <tt>bool</tt> representing if the column was successfully removed from
   * the selection, or 0 if value does not implement this interface.
   */
  bool remove_column_selection(int column);

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%row_inserted(int row, int num_inserted)</tt>
   *
   * The "row-inserted" signal is emitted by an object which
   * implements the AtkTable interface when a row is inserted.
   * 
   * @param arg1 The index of the first row inserted.
   * @param arg2 The number of rows inserted.
   */

  Glib::SignalProxy2< void,int,int > signal_row_inserted();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%column_inserted(int column, int num_inserted)</tt>
   *
   * The "column-inserted" signal is emitted by an object which
   * implements the AtkTable interface when a column is inserted.
   * 
   * @param arg1 The index of the column inserted.
   * @param arg2 The number of colums inserted.
   */

  Glib::SignalProxy2< void,int,int > signal_column_inserted();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%row_deleted(int row, int num_deleted)</tt>
   *
   * The "row-deleted" signal is emitted by an object which
   * implements the AtkTable interface when a row is deleted.
   * 
   * @param arg1 The index of the first row deleted.
   * @param arg2 The number of rows deleted.
   */

  Glib::SignalProxy2< void,int,int > signal_row_deleted();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%column_deleted(int column, int num_deleted)</tt>
   *
   * The "column-deleted" signal is emitted by an object which
   * implements the AtkTable interface when a column is deleted.
   * 
   * @param arg1 The index of the first column deleted.
   * @param arg2 The number of columns deleted.
   */

  Glib::SignalProxy2< void,int,int > signal_column_deleted();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%row_reordered()</tt>
   *
   * The "row-reordered" signal is emitted by an object which
   * implements the AtkTable interface when the rows are
   * reordered.
   */

  Glib::SignalProxy0< void > signal_row_reordered();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%column_reordered()</tt>
   *
   * The "column-reordered" signal is emitted by an object which
   * implements the AtkTable interface when the columns are
   * reordered.
   */

  Glib::SignalProxy0< void > signal_column_reordered();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%model_changed()</tt>
   *
   * The "model-changed" signal is emitted by an object which
   * implements the AtkTable interface when the model displayed by
   * the table changes.
   */

  Glib::SignalProxy0< void > signal_model_changed();


protected:
 

    virtual Glib::RefPtr<Atk::Object> get_at_vfunc(int row, int column);

    virtual int get_index_at_vfunc(int row, int column) const;

    virtual int get_column_at_index_vfunc(int index) const;

    virtual int get_row_at_index_vfunc(int index) const;

    virtual int get_n_columns_vfunc() const;

    virtual int get_n_rows_vfunc() const;

    virtual int get_column_extent_at_vfunc(int row, int column) const;

    virtual int get_row_extent_at_vfunc(int row, int column) const;

    virtual Glib::RefPtr<Atk::Object> get_caption_vfunc();

    virtual const char* get_column_description_vfunc(int column) const;

    virtual Glib::RefPtr<Atk::Object> get_column_header_vfunc(int column);

    virtual const char* get_row_description_vfunc(int row) const;

    virtual Glib::RefPtr<Atk::Object> get_row_header_vfunc(int row);

    virtual Glib::RefPtr<Atk::Object> get_summary_vfunc();

    virtual void set_caption_vfunc(const Glib::RefPtr<Atk::Object>& caption);

    virtual void set_column_description_vfunc(int column, const char* description);

    virtual void set_column_header_vfunc(int column, const Glib::RefPtr<Atk::Object>& header);

    virtual void set_row_description_vfunc(int row, const char* description);

    virtual void set_row_header_vfunc(int row, const Glib::RefPtr<Atk::Object>& header);

    virtual void set_summary_vfunc(const Glib::RefPtr<Atk::Object>& accessible);

    virtual bool is_column_selected_vfunc(int column) const;

    virtual bool is_row_selected_vfunc(int row) const;

    virtual bool is_selected_vfunc(int row, int column) const;

    virtual bool add_row_selection_vfunc(int row);

    virtual bool remove_row_selection_vfunc(int row);

    virtual bool add_column_selection_vfunc(int column);

    virtual bool remove_column_selection_vfunc(int column);

    virtual int get_selected_columns_vfunc(int** selected) const;

    virtual int get_selected_rows_vfunc(int** selected) const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_row_inserted().
  virtual void on_row_inserted(int row, int num_inserted);
  /// This is a default handler for the signal signal_column_inserted().
  virtual void on_column_inserted(int column, int num_inserted);
  /// This is a default handler for the signal signal_row_deleted().
  virtual void on_row_deleted(int row, int num_deleted);
  /// This is a default handler for the signal signal_column_deleted().
  virtual void on_column_deleted(int column, int num_deleted);
  /// This is a default handler for the signal signal_row_reordered().
  virtual void on_row_reordered();
  /// This is a default handler for the signal signal_column_reordered().
  virtual void on_column_reordered();
  /// This is a default handler for the signal signal_model_changed().
  virtual void on_model_changed();


};

} // namespace Atk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Atk::Table
   */
  Glib::RefPtr<Atk::Table> wrap(AtkTable* object, bool take_copy = false);

} // namespace Glib


#endif /* _ATKMM_TABLE_H */

