//***********************************************************************
// *  $RCSfile$ - Person.cs
// *
// *  Copyright (C) 2007 Novell, Inc.
// *
// *  This program is free software; you can redistribute it and/or
// *  modify it under the terms of the GNU General Public
// *  License as published by the Free Software Foundation; either
// *  version 2 of the License, or (at your option) any later version.
// *
// *  This program is distributed in the hope that it will be useful,
// *  but WITHOUT ANY WARRANTY; without even the implied warranty of
// *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// *  General Public License for more details.
// *
// *  You should have received a copy of the GNU General Public
// *  License along with this program; if not, write to the Free
// *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
// *
// **********************************************************************

using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Text;

namespace Banter
{
	///<summary>
	///	Person Class
	/// In memory representation of a person including data from online services
	/// EDS, and anything else that is needed to make this person functional
	///</summary>
	public class Person
	{
		#region Private Types
		//private Member member;
		private Tapioca.Contact contact;
		private bool isSelf;
		private string photoFile = String.Empty;
		#endregion

		#region Properties

		/*
		/// <summary>
		/// Current Presence Status
		/// </summary>
		public MemberPresence Presence
		{
			get
			{
				return member.Presence;
			}
			set
			{
				if (this.isSelf == false)
					throw new ApplicationException ("Invalid to set presence on friends");
			}
		}
		*/

		/// <summary>
		/// Current Presence Status
		/// </summary>
		public Tapioca.ContactPresence TapiocaPresence
		{
			get
			{
				return Tapioca.ContactPresence.Available;
			}
			set
			{
				if (this.isSelf == false)
					throw new ApplicationException ("Invalid to set presence on friends");
			}
		}

		/// <summary>
		/// Online status message
		/// </summary>
		public string TapiocaPresenceMessage
		{
			get {return contact.PresenceMessage;}
		}


		/*		
		/// <summary>
		/// Online capabilities
		/// </summary>
		public MemberCapabilities Capabilities
		{
			get
			{
				return member.Capabilities;
			}
		}
		*/
		
		/// <summary>
		/// Online capabilities
		/// </summary>
		public Tapioca.ContactCapabilities TapiocaCapabilities
		{
			get
			{
				return contact.Capabilities; 
			}
		}
		
		/// <summary>
		/// Online status message
		/// </summary>
		public string PresenceMessage
		{
			get
			{
				string message = String.Empty;
			
				/*
				if (member != null)
					message = member.PresenceMessage;
				else if (contact != null)
					message = contact.PresenceMessage;
				*/
				if (contact != null)
					message = contact.PresenceMessage;
				
				return message;
			}
		}
		
		/// <summary>
		/// Person's name to be displayed
		/// </summary>
		public string DisplayName
		{
			get
			{
				string displayName = String.Empty;
				
				/*
				if (member != null)
				{
					// Fix this later to pull the name from the EDS
					if ((member.Alias != null) &&
						(member.Alias.Length > 0) )
						displayName = member.Alias;
					else
						displayName = member.ScreenName;
				} 
				else*/
				if (contact != null)
				{
					if ((contact.Alias != null) && 
						(contact.Alias.Length > 0))
						displayName = contact.Alias;
					else
						displayName = contact.Uri;
				}
				
				return displayName;
			}
		}
		
		/// <summary>
		/// Path to person's photo
		/// </summary>
		public string PhotoFile
		{
			get {return photoFile;}
		}
		
		/// <summary>
		/// Indicates self awareness
		/// </summary>
		public bool IsSelf
		{
			get{ return isSelf;}
			set
			{
				isSelf = value;
			}
		}

		/*
		/// <summary>
		/// The internal Member class
		/// </summary>
		public Member Member
		{
			get{ return member;}
		}
		*/
		
		/// <summary>
		/// The internal Member class
		/// </summary>
		public Tapioca.Contact Contact
		{
			get{ return contact;}
		}
		
		
		#endregion
		
		#region Constructors
		/*
		/// <summary>
		/// Constructs a person from a member object
		/// </summary>
		public Person(Member member)
		{
			this.isSelf = false;
			this.member = member;
		}
		*/
		
		/// <summary>
		/// Constructs a person from a tapioca contact
		/// </summary>
		public Person(Tapioca.Contact contact)
		{
			this.isSelf = false;
			this.contact = contact;
		}
		
		/// <summary>
		/// Constructs a ME person from a tapioca contact
		/// </summary>
		public Person(Tapioca.Contact contact, bool self)
		{
			this.isSelf = false;
			this.contact = contact;
			this.isSelf = self;
		}
		#endregion
	}	
}