/* baobab-scanner.c generated by valac 0.38.0.11-8bd7f, the Vala compiler
 * generated from baobab-scanner.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Ryan Lortie <desrt@desrt.ca>
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2012  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gunixmounts.h>


#define BAOBAB_TYPE_SCAN_FLAGS (baobab_scan_flags_get_type ())

#define BAOBAB_TYPE_SCANNER (baobab_scanner_get_type ())
#define BAOBAB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_SCANNER, BaobabScanner))
#define BAOBAB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_SCANNER, BaobabScannerClass))
#define BAOBAB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_SCANNER))
#define BAOBAB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_SCANNER))
#define BAOBAB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_SCANNER, BaobabScannerClass))

typedef struct _BaobabScanner BaobabScanner;
typedef struct _BaobabScannerClass BaobabScannerClass;
typedef struct _BaobabScannerPrivate BaobabScannerPrivate;

#define BAOBAB_SCANNER_TYPE_HARD_LINK (baobab_scanner_hard_link_get_type ())
typedef struct _BaobabScannerHardLink BaobabScannerHardLink;
typedef struct _BaobabScannerResultsArray BaobabScannerResultsArray;
enum  {
	BAOBAB_SCANNER_DUMMY_PROPERTY,
	BAOBAB_SCANNER_DIRECTORY_PROPERTY,
	BAOBAB_SCANNER_SCAN_FLAGS_PROPERTY,
	BAOBAB_SCANNER_MAX_DEPTH_PROPERTY,
	BAOBAB_SCANNER_LAST_PROPERTY
};
static GParamSpec* baobab_scanner_properties[BAOBAB_SCANNER_LAST_PROPERTY];

#define BAOBAB_SCANNER_TYPE_COLUMNS (baobab_scanner_columns_get_type ())

#define BAOBAB_SCANNER_TYPE_STATE (baobab_scanner_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BaobabScannerResults BaobabScannerResults;
#define _baobab_scanner_results_array_free0(var) ((var == NULL) ? NULL : (var = (baobab_scanner_results_array_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _baobab_scanner_results_free0(var) ((var == NULL) ? NULL : (var = (baobab_scanner_results_free (var), NULL)))

#define BAOBAB_TYPE_APPLICATION (baobab_application_get_type ())
#define BAOBAB_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_APPLICATION, BaobabApplication))
#define BAOBAB_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_APPLICATION, BaobabApplicationClass))
#define BAOBAB_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_APPLICATION))
#define BAOBAB_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_APPLICATION))
#define BAOBAB_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_APPLICATION, BaobabApplicationClass))

typedef struct _BaobabApplication BaobabApplication;
typedef struct _BaobabApplicationClass BaobabApplicationClass;
#define __g_list_free__g_unix_mount_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_unix_mount_free0_ (var), NULL)))
enum  {
	BAOBAB_SCANNER_COMPLETED_SIGNAL,
	BAOBAB_SCANNER_LAST_SIGNAL
};
static guint baobab_scanner_signals[BAOBAB_SCANNER_LAST_SIGNAL] = {0};

typedef enum  {
	BAOBAB_SCAN_FLAGS_NONE = 1 << 0,
	BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS = 1 << 1
} BaobabScanFlags;

struct _BaobabScanner {
	GtkTreeStore parent_instance;
	BaobabScannerPrivate * priv;
};

struct _BaobabScannerClass {
	GtkTreeStoreClass parent_class;
};

struct _BaobabScannerHardLink {
	guint64 inode;
	guint32 device;
};

struct _BaobabScannerPrivate {
	GFile* _directory;
	BaobabScanFlags _scan_flags;
	gint _max_depth;
	GThread* thread;
	guint process_result_idle;
	BaobabScannerHardLink* hardlinks;
	gint hardlinks_length1;
	gint _hardlinks_size_;
	GHashTable* excluded_locations;
	gboolean successful;
	GAsyncQueue* results_queue;
	BaobabScanner* self;
	GCancellable* cancellable;
	GError* scan_error;
};

typedef enum  {
	BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME,
	BAOBAB_SCANNER_COLUMNS_PARSE_NAME,
	BAOBAB_SCANNER_COLUMNS_PERCENT,
	BAOBAB_SCANNER_COLUMNS_SIZE,
	BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE,
	BAOBAB_SCANNER_COLUMNS_TIME_MODIFIED,
	BAOBAB_SCANNER_COLUMNS_ELEMENTS,
	BAOBAB_SCANNER_COLUMNS_STATE,
	BAOBAB_SCANNER_COLUMNS_ERROR,
	BAOBAB_SCANNER_COLUMNS_COLUMNS
} BaobabScannerColumns;

typedef enum  {
	BAOBAB_SCANNER_STATE_SCANNING,
	BAOBAB_SCANNER_STATE_CANCELLED,
	BAOBAB_SCANNER_STATE_NEED_PERCENT,
	BAOBAB_SCANNER_STATE_ERROR,
	BAOBAB_SCANNER_STATE_CHILD_ERROR,
	BAOBAB_SCANNER_STATE_DONE
} BaobabScannerState;

struct _BaobabScannerResults {
	BaobabScannerResults* parent;
	gchar* display_name;
	gchar* parse_name;
	guint64 size;
	guint64 alloc_size;
	guint64 time_modified;
	gint elements;
	gdouble percent;
	gint max_depth;
	GError* error;
	gboolean child_error;
	GtkTreeIter iter;
	gboolean iter_is_set;
};

struct _BaobabScannerResultsArray {
	BaobabScannerResults** results;
	gint results_length1;
	gint _results_size_;
};


static gpointer baobab_scanner_parent_class = NULL;

GType baobab_scan_flags_get_type (void) G_GNUC_CONST;
GType baobab_scanner_get_type (void) G_GNUC_CONST;
static GType baobab_scanner_hard_link_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static BaobabScannerHardLink* baobab_scanner_hard_link_dup (const BaobabScannerHardLink* self);
static void baobab_scanner_hard_link_free (BaobabScannerHardLink* self);
static void baobab_scanner_results_array_free (BaobabScannerResultsArray * self);
#define BAOBAB_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_SCANNER, BaobabScannerPrivate))
GType baobab_scanner_columns_get_type (void) G_GNUC_CONST;
GType baobab_scanner_state_get_type (void) G_GNUC_CONST;
#define BAOBAB_SCANNER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_UNIX_NLINK "," G_FILE_ATTRIBUTE_UNIX_INODE "," G_FILE_ATTRIBUTE_UNIX_DEVICE "," G_FILE_ATTRIBUTE_ACCESS_CAN_READ
static void baobab_scanner_results_free (BaobabScannerResults * self);
static BaobabScannerResults* baobab_scanner_add_directory (BaobabScanner* self, GFile* directory, GFileInfo* info, BaobabScannerResults* parent);
static BaobabScannerResultsArray* baobab_scanner_results_array_new (void);
static BaobabScannerResults* baobab_scanner_results_new (void);
static void _vala_array_add1 (BaobabScannerResults** * array, int* length, int* size, BaobabScannerResults* value);
static void baobab_scanner_hard_link_init (BaobabScannerHardLink *self, GFileInfo* info);
static gboolean _baobab_scanner_hard_link_equal (const BaobabScannerHardLink * s1, const BaobabScannerHardLink * s2);
static gboolean _vala_baobab_scanner_hard_link_array_contains (BaobabScannerHardLink * stack, int stack_length, BaobabScannerHardLink * needle);
static void _vala_array_add2 (BaobabScannerHardLink* * array, int* length, int* size, const BaobabScannerHardLink* value);
static void* baobab_scanner_scan_in_thread (BaobabScanner* self);
GFile* baobab_scanner_get_directory (BaobabScanner* self);
static void _vala_array_add3 (BaobabScannerResults** * array, int* length, int* size, BaobabScannerResults* value);
static void baobab_scanner_ensure_iter_exists (BaobabScanner* self, BaobabScannerResults* results);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
static gboolean baobab_scanner_process_results (BaobabScanner* self);
gint baobab_scanner_get_max_depth (BaobabScanner* self);
void baobab_scanner_set_max_depth (BaobabScanner* self, gint value);
static void baobab_scanner_cancel_and_reset (BaobabScanner* self);
void baobab_scanner_scan (BaobabScanner* self, gboolean force);
static gpointer _baobab_scanner_scan_in_thread_gthread_func (gpointer self);
static gboolean ___lambda4_ (BaobabScanner* self);
static gboolean ____lambda4__gsource_func (gpointer self);
void baobab_scanner_cancel (BaobabScanner* self);
void baobab_scanner_finish (BaobabScanner* self, GError** error);
BaobabScanner* baobab_scanner_new (GFile* directory, BaobabScanFlags flags);
BaobabScanner* baobab_scanner_construct (GType object_type, GFile* directory, BaobabScanFlags flags);
static void baobab_scanner_set_directory (BaobabScanner* self, GFile* value);
static void baobab_scanner_set_scan_flags (BaobabScanner* self, BaobabScanFlags value);
GType baobab_application_get_type (void) G_GNUC_CONST;
BaobabApplication* baobab_application_get_default (void);
GHashTable* baobab_application_get_excluded_locations (BaobabApplication* self);
static void _g_unix_mount_free0_ (gpointer var);
static inline void _g_list_free__g_unix_mount_free0_ (GList* self);
static void _baobab_scanner_results_array_free0_ (gpointer var);
BaobabScanFlags baobab_scanner_get_scan_flags (BaobabScanner* self);
static void baobab_scanner_results_array_instance_init (BaobabScannerResultsArray * self);
static void baobab_scanner_results_instance_init (BaobabScannerResults * self);
static void baobab_scanner_finalize (GObject * obj);
static void _vala_baobab_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_baobab_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType baobab_scan_flags_get_type (void) {
	static volatile gsize baobab_scan_flags_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_scan_flags_type_id__volatile)) {
		static const GFlagsValue values[] = {{BAOBAB_SCAN_FLAGS_NONE, "BAOBAB_SCAN_FLAGS_NONE", "none"}, {BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS, "BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS", "exclude-mounts"}, {0, NULL, NULL}};
		GType baobab_scan_flags_type_id;
		baobab_scan_flags_type_id = g_flags_register_static ("BaobabScanFlags", values);
		g_once_init_leave (&baobab_scan_flags_type_id__volatile, baobab_scan_flags_type_id);
	}
	return baobab_scan_flags_type_id__volatile;
}


GType baobab_scanner_columns_get_type (void) {
	static volatile gsize baobab_scanner_columns_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_scanner_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME, "BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME", "display-name"}, {BAOBAB_SCANNER_COLUMNS_PARSE_NAME, "BAOBAB_SCANNER_COLUMNS_PARSE_NAME", "parse-name"}, {BAOBAB_SCANNER_COLUMNS_PERCENT, "BAOBAB_SCANNER_COLUMNS_PERCENT", "percent"}, {BAOBAB_SCANNER_COLUMNS_SIZE, "BAOBAB_SCANNER_COLUMNS_SIZE", "size"}, {BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE, "BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE", "alloc-size"}, {BAOBAB_SCANNER_COLUMNS_TIME_MODIFIED, "BAOBAB_SCANNER_COLUMNS_TIME_MODIFIED", "time-modified"}, {BAOBAB_SCANNER_COLUMNS_ELEMENTS, "BAOBAB_SCANNER_COLUMNS_ELEMENTS", "elements"}, {BAOBAB_SCANNER_COLUMNS_STATE, "BAOBAB_SCANNER_COLUMNS_STATE", "state"}, {BAOBAB_SCANNER_COLUMNS_ERROR, "BAOBAB_SCANNER_COLUMNS_ERROR", "error"}, {BAOBAB_SCANNER_COLUMNS_COLUMNS, "BAOBAB_SCANNER_COLUMNS_COLUMNS", "columns"}, {0, NULL, NULL}};
		GType baobab_scanner_columns_type_id;
		baobab_scanner_columns_type_id = g_enum_register_static ("BaobabScannerColumns", values);
		g_once_init_leave (&baobab_scanner_columns_type_id__volatile, baobab_scanner_columns_type_id);
	}
	return baobab_scanner_columns_type_id__volatile;
}


GType baobab_scanner_state_get_type (void) {
	static volatile gsize baobab_scanner_state_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_scanner_state_type_id__volatile)) {
		static const GEnumValue values[] = {{BAOBAB_SCANNER_STATE_SCANNING, "BAOBAB_SCANNER_STATE_SCANNING", "scanning"}, {BAOBAB_SCANNER_STATE_CANCELLED, "BAOBAB_SCANNER_STATE_CANCELLED", "cancelled"}, {BAOBAB_SCANNER_STATE_NEED_PERCENT, "BAOBAB_SCANNER_STATE_NEED_PERCENT", "need-percent"}, {BAOBAB_SCANNER_STATE_ERROR, "BAOBAB_SCANNER_STATE_ERROR", "error"}, {BAOBAB_SCANNER_STATE_CHILD_ERROR, "BAOBAB_SCANNER_STATE_CHILD_ERROR", "child-error"}, {BAOBAB_SCANNER_STATE_DONE, "BAOBAB_SCANNER_STATE_DONE", "done"}, {0, NULL, NULL}};
		GType baobab_scanner_state_type_id;
		baobab_scanner_state_type_id = g_enum_register_static ("BaobabScannerState", values);
		g_once_init_leave (&baobab_scanner_state_type_id__volatile, baobab_scanner_state_type_id);
	}
	return baobab_scanner_state_type_id__volatile;
}


static void _vala_array_add1 (BaobabScannerResults** * array, int* length, int* size, BaobabScannerResults* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BaobabScannerResults*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean _baobab_scanner_hard_link_equal (const BaobabScannerHardLink * s1, const BaobabScannerHardLink * s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->inode != s2->inode) {
		return FALSE;
	}
	if (s1->device != s2->device) {
		return FALSE;
	}
	return TRUE;
}


static gboolean _vala_baobab_scanner_hard_link_array_contains (BaobabScannerHardLink * stack, int stack_length, BaobabScannerHardLink * needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (_baobab_scanner_hard_link_equal (&stack[i], needle) == TRUE) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add2 (BaobabScannerHardLink* * array, int* length, int* size, const BaobabScannerHardLink* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BaobabScannerHardLink, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static BaobabScannerResults* baobab_scanner_add_directory (BaobabScanner* self, GFile* directory, GFileInfo* info, BaobabScannerResults* parent) {
	BaobabScannerResults* result = NULL;
	BaobabScannerResultsArray* results_array = NULL;
	BaobabScannerResultsArray* _tmp0_;
	GHashTable* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_;
	BaobabScannerResults* results = NULL;
	BaobabScannerResults* _tmp4_;
	BaobabScannerResults* _tmp5_;
	GFileInfo* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	BaobabScannerResults* _tmp9_;
	GFile* _tmp10_;
	gchar* _tmp11_;
	BaobabScannerResults* _tmp12_;
	BaobabScannerResults* _tmp13_;
	BaobabScannerResults* _tmp14_;
	GFileInfo* _tmp15_;
	guint64 _tmp16_;
	BaobabScannerResults* _tmp17_;
	GFileInfo* _tmp18_;
	gint64 _tmp19_;
	GFileInfo* _tmp20_;
	gboolean _tmp21_;
	BaobabScannerResults* _tmp25_;
	BaobabScannerResults* _tmp26_;
	BaobabScannerResults* _tmp27_;
	BaobabScannerResultsArray* _tmp119_;
	BaobabScannerResults** _tmp120_;
	gint _tmp120__length1;
	GAsyncQueue* _tmp129_;
	BaobabScannerResultsArray* _tmp130_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (directory != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = baobab_scanner_results_array_new ();
	results_array = _tmp0_;
	_tmp1_ = self->priv->excluded_locations;
	_tmp2_ = directory;
	_tmp3_ = g_hash_table_contains (_tmp1_, _tmp2_);
	if (_tmp3_) {
		result = NULL;
		_baobab_scanner_results_array_free0 (results_array);
		return result;
	}
	_tmp4_ = baobab_scanner_results_new ();
	results = _tmp4_;
	_tmp5_ = results;
	_tmp6_ = info;
	_tmp7_ = g_file_info_get_display_name (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (_tmp5_->display_name);
	_tmp5_->display_name = _tmp8_;
	_tmp9_ = results;
	_tmp10_ = directory;
	_tmp11_ = g_file_get_parse_name (_tmp10_);
	_g_free0 (_tmp9_->parse_name);
	_tmp9_->parse_name = _tmp11_;
	_tmp12_ = results;
	_tmp13_ = parent;
	_tmp12_->parent = _tmp13_;
	_tmp14_ = results;
	_tmp15_ = info;
	_tmp16_ = g_file_info_get_attribute_uint64 (_tmp15_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	_tmp14_->time_modified = _tmp16_;
	_tmp17_ = results;
	_tmp18_ = info;
	_tmp19_ = g_file_info_get_size (_tmp18_);
	_tmp17_->size = (guint64) _tmp19_;
	_tmp20_ = info;
	_tmp21_ = g_file_info_has_attribute (_tmp20_, G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE);
	if (_tmp21_) {
		BaobabScannerResults* _tmp22_;
		GFileInfo* _tmp23_;
		guint64 _tmp24_;
		_tmp22_ = results;
		_tmp23_ = info;
		_tmp24_ = g_file_info_get_attribute_uint64 (_tmp23_, G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE);
		_tmp22_->alloc_size = _tmp24_;
	}
	_tmp25_ = results;
	_tmp25_->elements = 1;
	_tmp26_ = results;
	_g_error_free0 (_tmp26_->error);
	_tmp26_->error = NULL;
	_tmp27_ = results;
	_tmp27_->child_error = FALSE;
	{
		GFileEnumerator* children = NULL;
		GFile* _tmp28_;
		GCancellable* _tmp29_;
		GFileEnumerator* _tmp30_;
		GFileInfo* child_info = NULL;
		_tmp28_ = directory;
		_tmp29_ = self->priv->cancellable;
		_tmp30_ = g_file_enumerate_children (_tmp28_, BAOBAB_SCANNER_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, _tmp29_, &_inner_error_);
		children = _tmp30_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp31_ = NULL;
			GFileEnumerator* _tmp32_;
			GCancellable* _tmp33_;
			GFileInfo* _tmp34_;
			GFileInfo* _tmp35_;
			GFileInfo* _tmp36_;
			GFileInfo* _tmp37_;
			GFileType _tmp38_;
			_tmp32_ = children;
			_tmp33_ = self->priv->cancellable;
			_tmp34_ = g_file_enumerator_next_file (_tmp32_, _tmp33_, &_inner_error_);
			_tmp31_ = _tmp34_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (child_info);
				_g_object_unref0 (children);
				goto __catch4_g_error;
			}
			_tmp35_ = _tmp31_;
			_tmp31_ = NULL;
			_g_object_unref0 (child_info);
			child_info = _tmp35_;
			_tmp36_ = child_info;
			if (!(_tmp36_ != NULL)) {
				_g_object_unref0 (_tmp31_);
				break;
			}
			_tmp37_ = child_info;
			_tmp38_ = g_file_info_get_file_type (_tmp37_);
			switch (_tmp38_) {
				case G_FILE_TYPE_DIRECTORY:
				{
					GFile* child = NULL;
					GFile* _tmp39_;
					GFileInfo* _tmp40_;
					const gchar* _tmp41_;
					GFile* _tmp42_;
					BaobabScannerResults* child_results = NULL;
					GFile* _tmp43_;
					GFileInfo* _tmp44_;
					BaobabScannerResults* _tmp45_;
					BaobabScannerResults* _tmp46_;
					BaobabScannerResults* _tmp47_;
					_tmp39_ = directory;
					_tmp40_ = child_info;
					_tmp41_ = g_file_info_get_name (_tmp40_);
					_tmp42_ = g_file_get_child (_tmp39_, _tmp41_);
					child = _tmp42_;
					_tmp43_ = child;
					_tmp44_ = child_info;
					_tmp45_ = results;
					_tmp46_ = baobab_scanner_add_directory (self, _tmp43_, _tmp44_, _tmp45_);
					child_results = _tmp46_;
					_tmp47_ = child_results;
					if (_tmp47_ != NULL) {
						BaobabScannerResults* _tmp48_;
						BaobabScannerResults* _tmp49_;
						guint64 _tmp50_;
						BaobabScannerResults* _tmp51_;
						guint64 _tmp52_;
						BaobabScannerResults* _tmp53_;
						BaobabScannerResults* _tmp54_;
						guint64 _tmp55_;
						BaobabScannerResults* _tmp56_;
						guint64 _tmp57_;
						BaobabScannerResults* _tmp58_;
						BaobabScannerResults* _tmp59_;
						gint _tmp60_;
						BaobabScannerResults* _tmp61_;
						gint _tmp62_;
						BaobabScannerResults* _tmp63_;
						BaobabScannerResults* _tmp64_;
						gint _tmp65_;
						BaobabScannerResults* _tmp66_;
						gint _tmp67_;
						gint _tmp68_;
						gboolean _tmp69_ = FALSE;
						BaobabScannerResults* _tmp70_;
						GError* _tmp71_;
						BaobabScannerResults* _tmp75_;
						guint64 _tmp76_;
						BaobabScannerResults* _tmp77_;
						guint64 _tmp78_;
						BaobabScannerResultsArray* _tmp82_;
						BaobabScannerResultsArray* _tmp83_;
						BaobabScannerResults** _tmp84_;
						gint _tmp84__length1;
						BaobabScannerResults* _tmp85_;
						_tmp48_ = results;
						_tmp49_ = results;
						_tmp50_ = _tmp49_->size;
						_tmp51_ = child_results;
						_tmp52_ = _tmp51_->size;
						_tmp49_->size = _tmp50_ + _tmp52_;
						_tmp53_ = results;
						_tmp54_ = results;
						_tmp55_ = _tmp54_->alloc_size;
						_tmp56_ = child_results;
						_tmp57_ = _tmp56_->alloc_size;
						_tmp54_->alloc_size = _tmp55_ + _tmp57_;
						_tmp58_ = results;
						_tmp59_ = results;
						_tmp60_ = _tmp59_->elements;
						_tmp61_ = child_results;
						_tmp62_ = _tmp61_->elements;
						_tmp59_->elements = _tmp60_ + _tmp62_;
						_tmp63_ = results;
						_tmp64_ = results;
						_tmp65_ = _tmp64_->max_depth;
						_tmp66_ = child_results;
						_tmp67_ = _tmp66_->max_depth;
						_tmp68_ = MAX (_tmp65_, _tmp67_ + 1);
						_tmp63_->max_depth = _tmp68_;
						_tmp70_ = child_results;
						_tmp71_ = _tmp70_->error;
						if (_tmp71_ != NULL) {
							_tmp69_ = TRUE;
						} else {
							BaobabScannerResults* _tmp72_;
							gboolean _tmp73_;
							_tmp72_ = child_results;
							_tmp73_ = _tmp72_->child_error;
							_tmp69_ = _tmp73_;
						}
						if (_tmp69_) {
							BaobabScannerResults* _tmp74_;
							_tmp74_ = results;
							_tmp74_->child_error = TRUE;
						}
						_tmp75_ = results;
						_tmp76_ = _tmp75_->time_modified;
						_tmp77_ = child_results;
						_tmp78_ = _tmp77_->time_modified;
						if (_tmp76_ < _tmp78_) {
							BaobabScannerResults* _tmp79_;
							BaobabScannerResults* _tmp80_;
							guint64 _tmp81_;
							_tmp79_ = results;
							_tmp80_ = child_results;
							_tmp81_ = _tmp80_->time_modified;
							_tmp79_->time_modified = _tmp81_;
						}
						_tmp82_ = results_array;
						_tmp83_ = results_array;
						_tmp84_ = _tmp83_->results;
						_tmp84__length1 = _tmp83_->results_length1;
						_tmp85_ = child_results;
						child_results = NULL;
						_vala_array_add1 (&_tmp82_->results, &_tmp82_->results_length1, &_tmp82_->_results_size_, _tmp85_);
					}
					_baobab_scanner_results_free0 (child_results);
					_g_object_unref0 (child);
					break;
				}
				case G_FILE_TYPE_REGULAR:
				{
					GFileInfo* _tmp86_;
					gboolean _tmp87_;
					BaobabScannerResults* _tmp95_;
					BaobabScannerResults* _tmp96_;
					guint64 _tmp97_;
					GFileInfo* _tmp98_;
					gint64 _tmp99_;
					GFileInfo* _tmp100_;
					gboolean _tmp101_;
					BaobabScannerResults* _tmp107_;
					gint _tmp108_;
					guint64 child_time = 0ULL;
					GFileInfo* _tmp109_;
					guint64 _tmp110_;
					BaobabScannerResults* _tmp111_;
					guint64 _tmp112_;
					guint64 _tmp113_;
					_tmp86_ = child_info;
					_tmp87_ = g_file_info_has_attribute (_tmp86_, G_FILE_ATTRIBUTE_UNIX_NLINK);
					if (_tmp87_) {
						GFileInfo* _tmp88_;
						guint32 _tmp89_;
						_tmp88_ = child_info;
						_tmp89_ = g_file_info_get_attribute_uint32 (_tmp88_, G_FILE_ATTRIBUTE_UNIX_NLINK);
						if (_tmp89_ > ((guint32) 1)) {
							BaobabScannerHardLink hl = {0};
							GFileInfo* _tmp90_;
							BaobabScannerHardLink _tmp91_;
							BaobabScannerHardLink* _tmp92_;
							gint _tmp92__length1;
							BaobabScannerHardLink* _tmp93_;
							gint _tmp93__length1;
							BaobabScannerHardLink _tmp94_;
							_tmp90_ = child_info;
							baobab_scanner_hard_link_init (&hl, _tmp90_);
							_tmp91_ = hl;
							_tmp92_ = self->priv->hardlinks;
							_tmp92__length1 = self->priv->hardlinks_length1;
							if (_vala_baobab_scanner_hard_link_array_contains (_tmp92_, _tmp92__length1, &_tmp91_)) {
								continue;
							}
							_tmp93_ = self->priv->hardlinks;
							_tmp93__length1 = self->priv->hardlinks_length1;
							_tmp94_ = hl;
							_vala_array_add2 (&self->priv->hardlinks, &self->priv->hardlinks_length1, &self->priv->_hardlinks_size_, &_tmp94_);
						}
					}
					_tmp95_ = results;
					_tmp96_ = results;
					_tmp97_ = _tmp96_->size;
					_tmp98_ = child_info;
					_tmp99_ = g_file_info_get_size (_tmp98_);
					_tmp96_->size = _tmp97_ + _tmp99_;
					_tmp100_ = child_info;
					_tmp101_ = g_file_info_has_attribute (_tmp100_, G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE);
					if (_tmp101_) {
						BaobabScannerResults* _tmp102_;
						BaobabScannerResults* _tmp103_;
						guint64 _tmp104_;
						GFileInfo* _tmp105_;
						guint64 _tmp106_;
						_tmp102_ = results;
						_tmp103_ = results;
						_tmp104_ = _tmp103_->alloc_size;
						_tmp105_ = child_info;
						_tmp106_ = g_file_info_get_attribute_uint64 (_tmp105_, G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE);
						_tmp103_->alloc_size = _tmp104_ + _tmp106_;
					}
					_tmp107_ = results;
					_tmp108_ = _tmp107_->elements;
					_tmp107_->elements = _tmp108_ + 1;
					_tmp109_ = child_info;
					_tmp110_ = g_file_info_get_attribute_uint64 (_tmp109_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
					child_time = _tmp110_;
					_tmp111_ = results;
					_tmp112_ = _tmp111_->time_modified;
					_tmp113_ = child_time;
					if (_tmp112_ < _tmp113_) {
						BaobabScannerResults* _tmp114_;
						guint64 _tmp115_;
						_tmp114_ = results;
						_tmp115_ = child_time;
						_tmp114_->time_modified = _tmp115_;
					}
					break;
				}
				default:
				{
					break;
				}
			}
			_g_object_unref0 (_tmp31_);
		}
		_g_object_unref0 (child_info);
		_g_object_unref0 (children);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		BaobabScannerResults* _tmp116_;
		GError* _tmp117_;
		GError* _tmp118_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp116_ = results;
		_tmp117_ = e;
		_tmp118_ = _g_error_copy0 (_tmp117_);
		_g_error_free0 (_tmp116_->error);
		_tmp116_->error = _tmp118_;
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_baobab_scanner_results_free0 (results);
		_baobab_scanner_results_array_free0 (results_array);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp119_ = results_array;
	_tmp120_ = _tmp119_->results;
	_tmp120__length1 = _tmp119_->results_length1;
	{
		BaobabScannerResults** child_results_collection = NULL;
		gint child_results_collection_length1 = 0;
		gint _child_results_collection_size_ = 0;
		gint child_results_it = 0;
		child_results_collection = _tmp120_;
		child_results_collection_length1 = _tmp120__length1;
		for (child_results_it = 0; child_results_it < _tmp120__length1; child_results_it = child_results_it + 1) {
			BaobabScannerResults* child_results = NULL;
			child_results = child_results_collection[child_results_it];
			{
				BaobabScannerResults* _tmp121_;
				guint64 _tmp122_;
				_tmp121_ = results;
				_tmp122_ = _tmp121_->size;
				if (_tmp122_ > ((guint64) 0)) {
					BaobabScannerResults* _tmp123_;
					BaobabScannerResults* _tmp124_;
					guint64 _tmp125_;
					BaobabScannerResults* _tmp126_;
					guint64 _tmp127_;
					_tmp123_ = child_results;
					_tmp124_ = child_results;
					_tmp125_ = _tmp124_->size;
					_tmp126_ = results;
					_tmp127_ = _tmp126_->size;
					_tmp123_->percent = (100 * ((gdouble) _tmp125_)) / ((gdouble) _tmp127_);
				} else {
					BaobabScannerResults* _tmp128_;
					_tmp128_ = child_results;
					_tmp128_->percent = (gdouble) 0;
				}
			}
		}
	}
	_tmp129_ = self->priv->results_queue;
	_tmp130_ = results_array;
	results_array = NULL;
	g_async_queue_push (_tmp129_, _tmp130_);
	result = results;
	_baobab_scanner_results_array_free0 (results_array);
	return result;
}


static void _vala_array_add3 (BaobabScannerResults** * array, int* length, int* size, BaobabScannerResults* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BaobabScannerResults*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void* baobab_scanner_scan_in_thread (BaobabScanner* self) {
	void* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		BaobabScannerResultsArray* array = NULL;
		BaobabScannerResultsArray* _tmp0_;
		GFileInfo* info = NULL;
		GFile* _tmp1_;
		GCancellable* _tmp2_;
		GFileInfo* _tmp3_;
		BaobabScannerResults* results = NULL;
		GFile* _tmp4_;
		BaobabScannerResults* _tmp5_;
		BaobabScannerResults* _tmp6_;
		BaobabScannerResultsArray* _tmp7_;
		BaobabScannerResultsArray* _tmp8_;
		BaobabScannerResults** _tmp9_;
		gint _tmp9__length1;
		BaobabScannerResults* _tmp10_;
		GAsyncQueue* _tmp11_;
		BaobabScannerResultsArray* _tmp12_;
		_tmp0_ = baobab_scanner_results_array_new ();
		array = _tmp0_;
		_tmp1_ = self->priv->_directory;
		_tmp2_ = self->priv->cancellable;
		_tmp3_ = g_file_query_info (_tmp1_, BAOBAB_SCANNER_ATTRIBUTES, 0, _tmp2_, &_inner_error_);
		info = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_baobab_scanner_results_array_free0 (array);
			goto __catch5_g_error;
		}
		_tmp4_ = self->priv->_directory;
		_tmp5_ = baobab_scanner_add_directory (self, _tmp4_, info, NULL);
		results = _tmp5_;
		_tmp6_ = results;
		_tmp6_->percent = 100.0;
		_tmp7_ = array;
		_tmp8_ = array;
		_tmp9_ = _tmp8_->results;
		_tmp9__length1 = _tmp8_->results_length1;
		_tmp10_ = results;
		results = NULL;
		_vala_array_add3 (&_tmp7_->results, &_tmp7_->results_length1, &_tmp7_->_results_size_, _tmp10_);
		_tmp11_ = self->priv->results_queue;
		_tmp12_ = array;
		array = NULL;
		g_async_queue_push (_tmp11_, _tmp12_);
		_baobab_scanner_results_free0 (results);
		_g_object_unref0 (info);
		_baobab_scanner_results_array_free0 (array);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (self->priv->self);
	self->priv->self = NULL;
	result = NULL;
	return result;
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
	dup = g_new0 (GtkTreeIter, 1);
	memcpy (dup, self, sizeof (GtkTreeIter));
	return dup;
}


static gpointer __gtk_tree_iter_dup0 (gpointer self) {
	return self ? _gtk_tree_iter_dup (self) : NULL;
}


static void baobab_scanner_ensure_iter_exists (BaobabScanner* self, BaobabScannerResults* results) {
	GtkTreeIter* parent_iter = NULL;
	BaobabScannerResults* _tmp0_;
	gboolean _tmp1_;
	BaobabScannerResults* _tmp2_;
	BaobabScannerResults* _tmp3_;
	BaobabScannerResults* _tmp10_;
	GtkTreeIter* _tmp11_;
	GtkTreeIter _tmp12_ = {0};
	BaobabScannerResults* _tmp13_;
	GtkTreeIter _tmp14_;
	BaobabScannerResults* _tmp15_;
	const gchar* _tmp16_;
	BaobabScannerResults* _tmp17_;
	const gchar* _tmp18_;
	BaobabScannerResults* _tmp19_;
	guint64 _tmp20_;
	BaobabScannerResults* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results != NULL);
	_tmp0_ = results;
	_tmp1_ = _tmp0_->iter_is_set;
	if (_tmp1_) {
		_g_free0 (parent_iter);
		return;
	}
	_tmp2_ = results;
	_tmp3_ = _tmp2_->parent;
	if (_tmp3_ != NULL) {
		BaobabScannerResults* _tmp4_;
		BaobabScannerResults* _tmp5_;
		BaobabScannerResults* _tmp6_;
		BaobabScannerResults* _tmp7_;
		GtkTreeIter _tmp8_;
		GtkTreeIter* _tmp9_;
		_tmp4_ = results;
		_tmp5_ = _tmp4_->parent;
		baobab_scanner_ensure_iter_exists (self, _tmp5_);
		_tmp6_ = results;
		_tmp7_ = _tmp6_->parent;
		_tmp8_ = _tmp7_->iter;
		_tmp9_ = __gtk_tree_iter_dup0 (&_tmp8_);
		_g_free0 (parent_iter);
		parent_iter = _tmp9_;
	} else {
		_g_free0 (parent_iter);
		parent_iter = NULL;
	}
	_tmp10_ = results;
	_tmp11_ = parent_iter;
	gtk_tree_store_append ((GtkTreeStore*) self, &_tmp12_, _tmp11_);
	_tmp10_->iter = _tmp12_;
	_tmp13_ = results;
	_tmp14_ = _tmp13_->iter;
	_tmp15_ = results;
	_tmp16_ = _tmp15_->display_name;
	_tmp17_ = results;
	_tmp18_ = _tmp17_->parse_name;
	_tmp19_ = results;
	_tmp20_ = _tmp19_->time_modified;
	gtk_tree_store_set ((GtkTreeStore*) self, &_tmp14_, BAOBAB_SCANNER_COLUMNS_STATE, BAOBAB_SCANNER_STATE_SCANNING, BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME, _tmp16_, BAOBAB_SCANNER_COLUMNS_PARSE_NAME, _tmp18_, BAOBAB_SCANNER_COLUMNS_TIME_MODIFIED, _tmp20_, -1);
	_tmp21_ = results;
	_tmp21_->iter_is_set = TRUE;
	_g_free0 (parent_iter);
}


static gboolean baobab_scanner_process_results (BaobabScanner* self) {
	gboolean result = FALSE;
	BaobabScanner* _tmp41_;
	g_return_val_if_fail (self != NULL, FALSE);
	while (TRUE) {
		BaobabScannerResultsArray* results_array = NULL;
		GAsyncQueue* _tmp0_;
		gpointer _tmp1_;
		BaobabScannerResultsArray* _tmp2_;
		BaobabScannerResultsArray* _tmp3_;
		BaobabScannerResults** _tmp4_;
		gint _tmp4__length1;
		_tmp0_ = self->priv->results_queue;
		_tmp1_ = g_async_queue_try_pop (_tmp0_);
		results_array = (BaobabScannerResultsArray*) _tmp1_;
		_tmp2_ = results_array;
		if (_tmp2_ == NULL) {
			_baobab_scanner_results_array_free0 (results_array);
			break;
		}
		_tmp3_ = results_array;
		_tmp4_ = _tmp3_->results;
		_tmp4__length1 = _tmp3_->results_length1;
		{
			BaobabScannerResults** results_collection = NULL;
			gint results_collection_length1 = 0;
			gint _results_collection_size_ = 0;
			gint results_it = 0;
			results_collection = _tmp4_;
			results_collection_length1 = _tmp4__length1;
			for (results_it = 0; results_it < _tmp4__length1; results_it = results_it + 1) {
				BaobabScannerResults* results = NULL;
				results = results_collection[results_it];
				{
					BaobabScannerResults* _tmp5_;
					BaobabScannerState state = 0;
					BaobabScannerResults* _tmp6_;
					gboolean _tmp7_;
					BaobabScannerResults* _tmp10_;
					GtkTreeIter _tmp11_;
					BaobabScannerResults* _tmp12_;
					guint64 _tmp13_;
					BaobabScannerResults* _tmp14_;
					guint64 _tmp15_;
					BaobabScannerResults* _tmp16_;
					gdouble _tmp17_;
					BaobabScannerResults* _tmp18_;
					gint _tmp19_;
					BaobabScannerState _tmp20_;
					BaobabScannerResults* _tmp21_;
					GError* _tmp22_;
					BaobabScannerResults* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					BaobabScannerResults* _tmp28_;
					GError* _tmp29_;
					BaobabScannerResults* _tmp39_;
					BaobabScannerResults* _tmp40_;
					_tmp5_ = results;
					baobab_scanner_ensure_iter_exists (self, _tmp5_);
					_tmp6_ = results;
					_tmp7_ = _tmp6_->child_error;
					if (_tmp7_) {
						state = BAOBAB_SCANNER_STATE_CHILD_ERROR;
					} else {
						BaobabScannerResults* _tmp8_;
						GError* _tmp9_;
						_tmp8_ = results;
						_tmp9_ = _tmp8_->error;
						if (_tmp9_ != NULL) {
							state = BAOBAB_SCANNER_STATE_ERROR;
						} else {
							state = BAOBAB_SCANNER_STATE_DONE;
						}
					}
					_tmp10_ = results;
					_tmp11_ = _tmp10_->iter;
					_tmp12_ = results;
					_tmp13_ = _tmp12_->size;
					_tmp14_ = results;
					_tmp15_ = _tmp14_->alloc_size;
					_tmp16_ = results;
					_tmp17_ = _tmp16_->percent;
					_tmp18_ = results;
					_tmp19_ = _tmp18_->elements;
					_tmp20_ = state;
					_tmp21_ = results;
					_tmp22_ = _tmp21_->error;
					gtk_tree_store_set ((GtkTreeStore*) self, &_tmp11_, BAOBAB_SCANNER_COLUMNS_SIZE, _tmp13_, BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE, _tmp15_, BAOBAB_SCANNER_COLUMNS_PERCENT, _tmp17_, BAOBAB_SCANNER_COLUMNS_ELEMENTS, _tmp19_, BAOBAB_SCANNER_COLUMNS_STATE, _tmp20_, BAOBAB_SCANNER_COLUMNS_ERROR, _tmp22_, -1);
					_tmp23_ = results;
					_tmp24_ = _tmp23_->max_depth;
					_tmp25_ = self->priv->_max_depth;
					if (_tmp24_ > _tmp25_) {
						BaobabScannerResults* _tmp26_;
						gint _tmp27_;
						_tmp26_ = results;
						_tmp27_ = _tmp26_->max_depth;
						baobab_scanner_set_max_depth (self, _tmp27_);
					}
					_tmp28_ = results;
					_tmp29_ = _tmp28_->error;
					if (_tmp29_ != NULL) {
						BaobabScannerResults* _tmp30_;
						GError* _tmp31_;
						_tmp30_ = results;
						_tmp31_ = _tmp30_->error;
						if (g_error_matches (_tmp31_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
							BaobabScannerResults* _tmp32_;
							GError* _tmp33_;
							GError* _tmp34_;
							_tmp32_ = results;
							_tmp33_ = _tmp32_->error;
							_tmp34_ = _g_error_copy0 (_tmp33_);
							_g_error_free0 (self->priv->scan_error);
							self->priv->scan_error = _tmp34_;
							g_signal_emit (self, baobab_scanner_signals[BAOBAB_SCANNER_COMPLETED_SIGNAL], 0);
							result = FALSE;
							_baobab_scanner_results_array_free0 (results_array);
							return result;
						} else {
							GError* _tmp35_;
							_tmp35_ = self->priv->scan_error;
							if (_tmp35_ == NULL) {
								BaobabScannerResults* _tmp36_;
								GError* _tmp37_;
								GError* _tmp38_;
								_tmp36_ = results;
								_tmp37_ = _tmp36_->error;
								_tmp38_ = _g_error_copy0 (_tmp37_);
								_g_error_free0 (self->priv->scan_error);
								self->priv->scan_error = _tmp38_;
							}
						}
					}
					_tmp39_ = results;
					_tmp40_ = _tmp39_->parent;
					if (_tmp40_ == NULL) {
						self->priv->successful = TRUE;
						g_signal_emit (self, baobab_scanner_signals[BAOBAB_SCANNER_COMPLETED_SIGNAL], 0);
						result = FALSE;
						_baobab_scanner_results_array_free0 (results_array);
						return result;
					}
				}
			}
		}
		_baobab_scanner_results_array_free0 (results_array);
	}
	_tmp41_ = self->priv->self;
	result = _tmp41_ != NULL;
	return result;
}


static gpointer _g_thread_ref0 (gpointer self) {
	return self ? g_thread_ref (self) : NULL;
}


static void baobab_scanner_cancel_and_reset (BaobabScanner* self) {
	GCancellable* _tmp0_;
	GThread* _tmp1_;
	guint _tmp4_;
	BaobabScannerResultsArray* tmp = NULL;
	GAsyncQueue* _tmp6_;
	gpointer _tmp7_;
	GCancellable* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
	_tmp1_ = self->priv->thread;
	if (_tmp1_ != NULL) {
		GThread* _tmp2_;
		GThread* _tmp3_;
		_tmp2_ = self->priv->thread;
		_tmp3_ = _g_thread_ref0 (_tmp2_);
		g_thread_join (_tmp3_);
		_g_thread_unref0 (self->priv->thread);
		self->priv->thread = NULL;
	}
	_tmp4_ = self->priv->process_result_idle;
	if (_tmp4_ != ((guint) 0)) {
		guint _tmp5_;
		_tmp5_ = self->priv->process_result_idle;
		g_source_remove (_tmp5_);
		self->priv->process_result_idle = (guint) 0;
	}
	_tmp6_ = self->priv->results_queue;
	_tmp7_ = g_async_queue_try_pop (_tmp6_);
	tmp = (BaobabScannerResultsArray*) _tmp7_;
	while (TRUE) {
		BaobabScannerResultsArray* _tmp8_;
		GAsyncQueue* _tmp9_;
		gpointer _tmp10_;
		_tmp8_ = tmp;
		if (!(_tmp8_ != NULL)) {
			break;
		}
		_tmp9_ = self->priv->results_queue;
		_tmp10_ = g_async_queue_try_pop (_tmp9_);
		_baobab_scanner_results_array_free0 (tmp);
		tmp = (BaobabScannerResultsArray*) _tmp10_;
	}
	self->priv->hardlinks = (g_free (self->priv->hardlinks), NULL);
	self->priv->hardlinks = NULL;
	self->priv->hardlinks_length1 = 0;
	self->priv->_hardlinks_size_ = self->priv->hardlinks_length1;
	gtk_tree_store_clear (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_store_get_type (), GtkTreeStore));
	_tmp11_ = self->priv->cancellable;
	g_cancellable_reset (_tmp11_);
	_g_error_free0 (self->priv->scan_error);
	self->priv->scan_error = NULL;
	_baobab_scanner_results_array_free0 (tmp);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _baobab_scanner_scan_in_thread_gthread_func (gpointer self) {
	gpointer result;
	result = baobab_scanner_scan_in_thread ((BaobabScanner*) self);
	g_object_unref (self);
	return result;
}


static gboolean ___lambda4_ (BaobabScanner* self) {
	gboolean result = FALSE;
	gboolean res = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	_tmp0_ = baobab_scanner_process_results (self);
	res = _tmp0_;
	_tmp1_ = res;
	if (!_tmp1_) {
		self->priv->process_result_idle = (guint) 0;
	}
	result = res;
	return result;
}


static gboolean ____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda4_ ((BaobabScanner*) self);
	return result;
}


void baobab_scanner_scan (BaobabScanner* self, gboolean force) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = force;
	if (_tmp0_) {
		self->priv->successful = FALSE;
	}
	_tmp1_ = self->priv->successful;
	if (!_tmp1_) {
		BaobabScanner* _tmp2_;
		GThread* _tmp3_;
		guint _tmp4_;
		baobab_scanner_cancel_and_reset (self);
		_tmp2_ = _g_object_ref0 (self);
		_g_object_unref0 (self->priv->self);
		self->priv->self = _tmp2_;
		_tmp3_ = g_thread_new ("scanner", _baobab_scanner_scan_in_thread_gthread_func, g_object_ref (self));
		_g_thread_unref0 (self->priv->thread);
		self->priv->thread = _tmp3_;
		_tmp4_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda4__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->process_result_idle = _tmp4_;
	} else {
		g_signal_emit (self, baobab_scanner_signals[BAOBAB_SCANNER_COMPLETED_SIGNAL], 0);
	}
}


void baobab_scanner_cancel (BaobabScanner* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->successful;
	if (!_tmp0_) {
		baobab_scanner_cancel_and_reset (self);
	}
}


void baobab_scanner_finish (BaobabScanner* self, GError** error) {
	GError* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scan_error;
	if (_tmp0_ != NULL) {
		GError* _tmp1_;
		GError* _tmp2_;
		_tmp1_ = self->priv->scan_error;
		_tmp2_ = _g_error_copy0 (_tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void _g_unix_mount_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_unix_mount_free (var), NULL));
}


static inline void _g_list_free__g_unix_mount_free0_ (GList* self) {
	g_list_free_full (self, (GDestroyNotify) _g_unix_mount_free0_);
}


static void _baobab_scanner_results_array_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (baobab_scanner_results_array_free (var), NULL));
}


BaobabScanner* baobab_scanner_construct (GType object_type, GFile* directory, BaobabScanFlags flags) {
	BaobabScanner * self = NULL;
	GFile* _tmp0_;
	BaobabScanFlags _tmp1_;
	GCancellable* _tmp2_;
	GType* _tmp3_;
	GType* _tmp4_;
	gint _tmp4__length1;
	BaobabApplication* _tmp5_;
	BaobabApplication* _tmp6_;
	GHashTable* _tmp7_;
	BaobabScanFlags _tmp8_;
	GHashTable* _tmp14_;
	GFile* _tmp15_;
	GAsyncQueue* _tmp16_;
	g_return_val_if_fail (directory != NULL, NULL);
	self = (BaobabScanner*) g_object_new (object_type, NULL);
	_tmp0_ = directory;
	baobab_scanner_set_directory (self, _tmp0_);
	_tmp1_ = flags;
	baobab_scanner_set_scan_flags (self, _tmp1_);
	_tmp2_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp2_;
	_g_error_free0 (self->priv->scan_error);
	self->priv->scan_error = NULL;
	_tmp3_ = g_new0 (GType, 9);
	_tmp3_[0] = G_TYPE_STRING;
	_tmp3_[1] = G_TYPE_STRING;
	_tmp3_[2] = G_TYPE_DOUBLE;
	_tmp3_[3] = G_TYPE_UINT64;
	_tmp3_[4] = G_TYPE_UINT64;
	_tmp3_[5] = G_TYPE_UINT64;
	_tmp3_[6] = G_TYPE_INT;
	_tmp3_[7] = BAOBAB_SCANNER_TYPE_STATE;
	_tmp3_[8] = G_TYPE_ERROR;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 9;
	gtk_tree_store_set_column_types ((GtkTreeStore*) self, 9, _tmp4_);
	_tmp4_ = (g_free (_tmp4_), NULL);
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self, (gint) BAOBAB_SCANNER_COLUMNS_SIZE, GTK_SORT_DESCENDING);
	_tmp5_ = baobab_application_get_default ();
	_tmp6_ = _tmp5_;
	_tmp7_ = baobab_application_get_excluded_locations (_tmp6_);
	_g_hash_table_unref0 (self->priv->excluded_locations);
	self->priv->excluded_locations = _tmp7_;
	_g_object_unref0 (_tmp6_);
	_tmp8_ = flags;
	if ((_tmp8_ & BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS) == BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS) {
		GList* _tmp9_;
		_tmp9_ = g_unix_mounts_get (NULL);
		{
			GList* mount_collection = NULL;
			GList* mount_it = NULL;
			mount_collection = _tmp9_;
			for (mount_it = mount_collection; mount_it != NULL; mount_it = mount_it->next) {
				GUnixMountEntry* mount = NULL;
				mount = (GUnixMountEntry*) mount_it->data;
				{
					GHashTable* _tmp10_;
					GUnixMountEntry* _tmp11_;
					const gchar* _tmp12_;
					GFile* _tmp13_;
					_tmp10_ = self->priv->excluded_locations;
					_tmp11_ = mount;
					_tmp12_ = g_unix_mount_get_mount_path (_tmp11_);
					_tmp13_ = g_file_new_for_path (_tmp12_);
					g_hash_table_add (_tmp10_, _tmp13_);
				}
			}
			__g_list_free__g_unix_mount_free0_0 (mount_collection);
		}
	}
	_tmp14_ = self->priv->excluded_locations;
	_tmp15_ = directory;
	g_hash_table_remove (_tmp14_, _tmp15_);
	_tmp16_ = g_async_queue_new_full (_baobab_scanner_results_array_free0_);
	_g_async_queue_unref0 (self->priv->results_queue);
	self->priv->results_queue = _tmp16_;
	return self;
}


BaobabScanner* baobab_scanner_new (GFile* directory, BaobabScanFlags flags) {
	return baobab_scanner_construct (BAOBAB_TYPE_SCANNER, directory, flags);
}


GFile* baobab_scanner_get_directory (BaobabScanner* self) {
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_directory;
	result = _tmp0_;
	return result;
}


static void baobab_scanner_set_directory (BaobabScanner* self, GFile* value) {
	g_return_if_fail (self != NULL);
	if (baobab_scanner_get_directory (self) != value) {
		GFile* _tmp0_;
		GFile* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_directory);
		self->priv->_directory = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_properties[BAOBAB_SCANNER_DIRECTORY_PROPERTY]);
	}
}


BaobabScanFlags baobab_scanner_get_scan_flags (BaobabScanner* self) {
	BaobabScanFlags result;
	BaobabScanFlags _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_scan_flags;
	result = _tmp0_;
	return result;
}


static void baobab_scanner_set_scan_flags (BaobabScanner* self, BaobabScanFlags value) {
	g_return_if_fail (self != NULL);
	if (baobab_scanner_get_scan_flags (self) != value) {
		BaobabScanFlags _tmp0_;
		_tmp0_ = value;
		self->priv->_scan_flags = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_properties[BAOBAB_SCANNER_SCAN_FLAGS_PROPERTY]);
	}
}


gint baobab_scanner_get_max_depth (BaobabScanner* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_max_depth;
	result = _tmp0_;
	return result;
}


void baobab_scanner_set_max_depth (BaobabScanner* self, gint value) {
	g_return_if_fail (self != NULL);
	if (baobab_scanner_get_max_depth (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_max_depth = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, baobab_scanner_properties[BAOBAB_SCANNER_MAX_DEPTH_PROPERTY]);
	}
}


static BaobabScannerResultsArray* baobab_scanner_results_array_new (void) {
	BaobabScannerResultsArray* self;
	self = g_slice_new0 (BaobabScannerResultsArray);
	baobab_scanner_results_array_instance_init (self);
	return self;
}


static void baobab_scanner_results_array_instance_init (BaobabScannerResultsArray * self) {
}


static void baobab_scanner_results_array_free (BaobabScannerResultsArray * self) {
	self->results = (_vala_array_free (self->results, self->results_length1, (GDestroyNotify) baobab_scanner_results_free), NULL);
	g_slice_free (BaobabScannerResultsArray, self);
}


static BaobabScannerResults* baobab_scanner_results_new (void) {
	BaobabScannerResults* self;
	self = g_slice_new0 (BaobabScannerResults);
	baobab_scanner_results_instance_init (self);
	return self;
}


static void baobab_scanner_results_instance_init (BaobabScannerResults * self) {
}


static void baobab_scanner_results_free (BaobabScannerResults * self) {
	_g_free0 (self->display_name);
	_g_free0 (self->parse_name);
	_g_error_free0 (self->error);
	g_slice_free (BaobabScannerResults, self);
}


static void baobab_scanner_hard_link_init (BaobabScannerHardLink *self, GFileInfo* info) {
	GFileInfo* _tmp0_;
	guint64 _tmp1_;
	GFileInfo* _tmp2_;
	guint32 _tmp3_;
	g_return_if_fail (info != NULL);
	memset (self, 0, sizeof (BaobabScannerHardLink));
	_tmp0_ = info;
	_tmp1_ = g_file_info_get_attribute_uint64 (_tmp0_, G_FILE_ATTRIBUTE_UNIX_INODE);
	(*self).inode = _tmp1_;
	_tmp2_ = info;
	_tmp3_ = g_file_info_get_attribute_uint32 (_tmp2_, G_FILE_ATTRIBUTE_UNIX_DEVICE);
	(*self).device = _tmp3_;
}


static BaobabScannerHardLink* baobab_scanner_hard_link_dup (const BaobabScannerHardLink* self) {
	BaobabScannerHardLink* dup;
	dup = g_new0 (BaobabScannerHardLink, 1);
	memcpy (dup, self, sizeof (BaobabScannerHardLink));
	return dup;
}


static void baobab_scanner_hard_link_free (BaobabScannerHardLink* self) {
	g_free (self);
}


static GType baobab_scanner_hard_link_get_type (void) {
	static volatile gsize baobab_scanner_hard_link_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_scanner_hard_link_type_id__volatile)) {
		GType baobab_scanner_hard_link_type_id;
		baobab_scanner_hard_link_type_id = g_boxed_type_register_static ("BaobabScannerHardLink", (GBoxedCopyFunc) baobab_scanner_hard_link_dup, (GBoxedFreeFunc) baobab_scanner_hard_link_free);
		g_once_init_leave (&baobab_scanner_hard_link_type_id__volatile, baobab_scanner_hard_link_type_id);
	}
	return baobab_scanner_hard_link_type_id__volatile;
}


static void baobab_scanner_class_init (BaobabScannerClass * klass) {
	baobab_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabScannerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_scanner_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_scanner_set_property;
	G_OBJECT_CLASS (klass)->finalize = baobab_scanner_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_DIRECTORY_PROPERTY, baobab_scanner_properties[BAOBAB_SCANNER_DIRECTORY_PROPERTY] = g_param_spec_object ("directory", "directory", "directory", g_file_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_SCAN_FLAGS_PROPERTY, baobab_scanner_properties[BAOBAB_SCANNER_SCAN_FLAGS_PROPERTY] = g_param_spec_flags ("scan-flags", "scan-flags", "scan-flags", BAOBAB_TYPE_SCAN_FLAGS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_MAX_DEPTH_PROPERTY, baobab_scanner_properties[BAOBAB_SCANNER_MAX_DEPTH_PROPERTY] = g_param_spec_int ("max-depth", "max-depth", "max-depth", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	baobab_scanner_signals[BAOBAB_SCANNER_COMPLETED_SIGNAL] = g_signal_new ("completed", BAOBAB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void baobab_scanner_instance_init (BaobabScanner * self) {
	self->priv = BAOBAB_SCANNER_GET_PRIVATE (self);
	self->priv->thread = NULL;
	self->priv->process_result_idle = (guint) 0;
	self->priv->successful = FALSE;
}


static void baobab_scanner_finalize (GObject * obj) {
	BaobabScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_SCANNER, BaobabScanner);
	_g_object_unref0 (self->priv->_directory);
	_g_thread_unref0 (self->priv->thread);
	self->priv->hardlinks = (g_free (self->priv->hardlinks), NULL);
	_g_hash_table_unref0 (self->priv->excluded_locations);
	_g_async_queue_unref0 (self->priv->results_queue);
	_g_object_unref0 (self->priv->self);
	_g_object_unref0 (self->priv->cancellable);
	_g_error_free0 (self->priv->scan_error);
	G_OBJECT_CLASS (baobab_scanner_parent_class)->finalize (obj);
}


GType baobab_scanner_get_type (void) {
	static volatile gsize baobab_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabScanner), 0, (GInstanceInitFunc) baobab_scanner_instance_init, NULL };
		GType baobab_scanner_type_id;
		baobab_scanner_type_id = g_type_register_static (gtk_tree_store_get_type (), "BaobabScanner", &g_define_type_info, 0);
		g_once_init_leave (&baobab_scanner_type_id__volatile, baobab_scanner_type_id);
	}
	return baobab_scanner_type_id__volatile;
}


static void _vala_baobab_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BaobabScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_SCANNER, BaobabScanner);
	switch (property_id) {
		case BAOBAB_SCANNER_DIRECTORY_PROPERTY:
		g_value_set_object (value, baobab_scanner_get_directory (self));
		break;
		case BAOBAB_SCANNER_SCAN_FLAGS_PROPERTY:
		g_value_set_flags (value, baobab_scanner_get_scan_flags (self));
		break;
		case BAOBAB_SCANNER_MAX_DEPTH_PROPERTY:
		g_value_set_int (value, baobab_scanner_get_max_depth (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_baobab_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BaobabScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_SCANNER, BaobabScanner);
	switch (property_id) {
		case BAOBAB_SCANNER_DIRECTORY_PROPERTY:
		baobab_scanner_set_directory (self, g_value_get_object (value));
		break;
		case BAOBAB_SCANNER_SCAN_FLAGS_PROPERTY:
		baobab_scanner_set_scan_flags (self, g_value_get_flags (value));
		break;
		case BAOBAB_SCANNER_MAX_DEPTH_PROPERTY:
		baobab_scanner_set_max_depth (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



