/* baobab-scanner.c generated by valac 0.20.1.51-7ff1, the Vala compiler
 * generated from baobab-scanner.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Ryan Lortie <desrt@desrt.ca>
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2012  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gunixmounts.h>


#define BAOBAB_TYPE_SCAN_FLAGS (baobab_scan_flags_get_type ())

#define BAOBAB_TYPE_SCANNER (baobab_scanner_get_type ())
#define BAOBAB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_SCANNER, BaobabScanner))
#define BAOBAB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_SCANNER, BaobabScannerClass))
#define BAOBAB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_SCANNER))
#define BAOBAB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_SCANNER))
#define BAOBAB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_SCANNER, BaobabScannerClass))

typedef struct _BaobabScanner BaobabScanner;
typedef struct _BaobabScannerClass BaobabScannerClass;
typedef struct _BaobabScannerPrivate BaobabScannerPrivate;

#define BAOBAB_SCANNER_TYPE_HARD_LINK (baobab_scanner_hard_link_get_type ())
typedef struct _BaobabScannerHardLink BaobabScannerHardLink;
typedef struct _BaobabScannerResultsArray BaobabScannerResultsArray;

#define BAOBAB_SCANNER_TYPE_COLUMNS (baobab_scanner_columns_get_type ())

#define BAOBAB_SCANNER_TYPE_STATE (baobab_scanner_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BaobabScannerResults BaobabScannerResults;
#define _baobab_scanner_results_array_free0(var) ((var == NULL) ? NULL : (var = (baobab_scanner_results_array_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _baobab_scanner_results_free0(var) ((var == NULL) ? NULL : (var = (baobab_scanner_results_free (var), NULL)))
#define __g_list_free__g_unix_mount_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_unix_mount_free0_ (var), NULL)))

typedef enum  {
	BAOBAB_SCAN_FLAGS_NONE = 1 << 0,
	BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS = 1 << 1
} BaobabScanFlags;

struct _BaobabScanner {
	GtkTreeStore parent_instance;
	BaobabScannerPrivate * priv;
};

struct _BaobabScannerClass {
	GtkTreeStoreClass parent_class;
};

struct _BaobabScannerHardLink {
	guint64 inode;
	guint32 device;
};

struct _BaobabScannerPrivate {
	GFile* _directory;
	BaobabScanFlags _scan_flags;
	gint _max_depth;
	GThread* thread;
	guint process_result_idle;
	BaobabScannerHardLink* hardlinks;
	gint hardlinks_length1;
	gint _hardlinks_size_;
	GHashTable* excluded_locations;
	gboolean successful;
	GAsyncQueue* results_queue;
	BaobabScanner* self;
	GCancellable* cancellable;
	GError* scan_error;
};

typedef enum  {
	BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME,
	BAOBAB_SCANNER_COLUMNS_PARSE_NAME,
	BAOBAB_SCANNER_COLUMNS_PERCENT,
	BAOBAB_SCANNER_COLUMNS_SIZE,
	BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE,
	BAOBAB_SCANNER_COLUMNS_ELEMENTS,
	BAOBAB_SCANNER_COLUMNS_STATE,
	BAOBAB_SCANNER_COLUMNS_ERROR,
	BAOBAB_SCANNER_COLUMNS_COLUMNS
} BaobabScannerColumns;

typedef enum  {
	BAOBAB_SCANNER_STATE_SCANNING,
	BAOBAB_SCANNER_STATE_CANCELLED,
	BAOBAB_SCANNER_STATE_NEED_PERCENT,
	BAOBAB_SCANNER_STATE_ERROR,
	BAOBAB_SCANNER_STATE_CHILD_ERROR,
	BAOBAB_SCANNER_STATE_DONE
} BaobabScannerState;

struct _BaobabScannerResults {
	BaobabScannerResults* parent;
	gchar* display_name;
	gchar* parse_name;
	guint64 size;
	guint64 alloc_size;
	gint elements;
	gdouble percent;
	gint max_depth;
	GError* error;
	gboolean child_error;
	GtkTreeIter iter;
	gboolean iter_is_set;
};

struct _BaobabScannerResultsArray {
	BaobabScannerResults** results;
	gint results_length1;
	gint _results_size_;
};


static gpointer baobab_scanner_parent_class = NULL;

GType baobab_scan_flags_get_type (void) G_GNUC_CONST;
GType baobab_scanner_get_type (void) G_GNUC_CONST;
static GType baobab_scanner_hard_link_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static BaobabScannerHardLink* baobab_scanner_hard_link_dup (const BaobabScannerHardLink* self);
static void baobab_scanner_hard_link_free (BaobabScannerHardLink* self);
static void baobab_scanner_results_array_free (BaobabScannerResultsArray* self);
#define BAOBAB_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_SCANNER, BaobabScannerPrivate))
enum  {
	BAOBAB_SCANNER_DUMMY_PROPERTY,
	BAOBAB_SCANNER_DIRECTORY,
	BAOBAB_SCANNER_SCAN_FLAGS,
	BAOBAB_SCANNER_MAX_DEPTH
};
GType baobab_scanner_columns_get_type (void) G_GNUC_CONST;
GType baobab_scanner_state_get_type (void) G_GNUC_CONST;
#define BAOBAB_SCANNER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE "," G_FILE_ATTRIBUTE_UNIX_NLINK "," G_FILE_ATTRIBUTE_UNIX_INODE "," G_FILE_ATTRIBUTE_UNIX_DEVICE "," G_FILE_ATTRIBUTE_ACCESS_CAN_READ
static void baobab_scanner_results_free (BaobabScannerResults* self);
static BaobabScannerResults* baobab_scanner_add_directory (BaobabScanner* self, GFile* directory, GFileInfo* info, BaobabScannerResults* parent);
static BaobabScannerResultsArray* baobab_scanner_results_array_new (void);
static BaobabScannerResultsArray* baobab_scanner_results_array_new (void);
static BaobabScannerResults* baobab_scanner_results_new (void);
static BaobabScannerResults* baobab_scanner_results_new (void);
static void _vala_array_add1 (BaobabScannerResults*** array, int* length, int* size, BaobabScannerResults* value);
static void baobab_scanner_hard_link_init (BaobabScannerHardLink *self, GFileInfo* info);
static gboolean _baobab_scanner_hard_link_equal (const BaobabScannerHardLink* s1, const BaobabScannerHardLink* s2);
static gboolean _vala_baobab_scanner_hard_link_array_contains (BaobabScannerHardLink* stack, int stack_length, BaobabScannerHardLink* needle);
static void _vala_array_add2 (BaobabScannerHardLink** array, int* length, int* size, const BaobabScannerHardLink* value);
static void* baobab_scanner_scan_in_thread (BaobabScanner* self);
GFile* baobab_scanner_get_directory (BaobabScanner* self);
static void _vala_array_add3 (BaobabScannerResults*** array, int* length, int* size, BaobabScannerResults* value);
static void baobab_scanner_ensure_iter_exists (BaobabScanner* self, BaobabScannerResults* results);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
static gboolean baobab_scanner_process_results (BaobabScanner* self);
gint baobab_scanner_get_max_depth (BaobabScanner* self);
void baobab_scanner_set_max_depth (BaobabScanner* self, gint value);
static void baobab_scanner_cancel_and_reset (BaobabScanner* self);
void baobab_scanner_scan (BaobabScanner* self, gboolean force);
static gpointer _baobab_scanner_scan_in_thread_gthread_func (gpointer self);
static gboolean _baobab_scanner_process_results_gsource_func (gpointer self);
void baobab_scanner_cancel (BaobabScanner* self);
void baobab_scanner_finish (BaobabScanner* self, GError** error);
BaobabScanner* baobab_scanner_new (GFile* directory, BaobabScanFlags flags);
BaobabScanner* baobab_scanner_construct (GType object_type, GFile* directory, BaobabScanFlags flags);
static void baobab_scanner_set_directory (BaobabScanner* self, GFile* value);
static void baobab_scanner_set_scan_flags (BaobabScanner* self, BaobabScanFlags value);
GHashTable* baobab_application_get_excluded_locations (void);
static void _g_unix_mount_free0_ (gpointer var);
static void _g_list_free__g_unix_mount_free0_ (GList* self);
static void _baobab_scanner_results_array_free0_ (gpointer var);
BaobabScanFlags baobab_scanner_get_scan_flags (BaobabScanner* self);
static void baobab_scanner_results_array_instance_init (BaobabScannerResultsArray * self);
static void baobab_scanner_results_instance_init (BaobabScannerResults * self);
static void baobab_scanner_finalize (GObject* obj);
static void _vala_baobab_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_baobab_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType baobab_scan_flags_get_type (void) {
	static volatile gsize baobab_scan_flags_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_scan_flags_type_id__volatile)) {
		static const GFlagsValue values[] = {{BAOBAB_SCAN_FLAGS_NONE, "BAOBAB_SCAN_FLAGS_NONE", "none"}, {BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS, "BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS", "exclude-mounts"}, {0, NULL, NULL}};
		GType baobab_scan_flags_type_id;
		baobab_scan_flags_type_id = g_flags_register_static ("BaobabScanFlags", values);
		g_once_init_leave (&baobab_scan_flags_type_id__volatile, baobab_scan_flags_type_id);
	}
	return baobab_scan_flags_type_id__volatile;
}


GType baobab_scanner_columns_get_type (void) {
	static volatile gsize baobab_scanner_columns_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_scanner_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME, "BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME", "display-name"}, {BAOBAB_SCANNER_COLUMNS_PARSE_NAME, "BAOBAB_SCANNER_COLUMNS_PARSE_NAME", "parse-name"}, {BAOBAB_SCANNER_COLUMNS_PERCENT, "BAOBAB_SCANNER_COLUMNS_PERCENT", "percent"}, {BAOBAB_SCANNER_COLUMNS_SIZE, "BAOBAB_SCANNER_COLUMNS_SIZE", "size"}, {BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE, "BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE", "alloc-size"}, {BAOBAB_SCANNER_COLUMNS_ELEMENTS, "BAOBAB_SCANNER_COLUMNS_ELEMENTS", "elements"}, {BAOBAB_SCANNER_COLUMNS_STATE, "BAOBAB_SCANNER_COLUMNS_STATE", "state"}, {BAOBAB_SCANNER_COLUMNS_ERROR, "BAOBAB_SCANNER_COLUMNS_ERROR", "error"}, {BAOBAB_SCANNER_COLUMNS_COLUMNS, "BAOBAB_SCANNER_COLUMNS_COLUMNS", "columns"}, {0, NULL, NULL}};
		GType baobab_scanner_columns_type_id;
		baobab_scanner_columns_type_id = g_enum_register_static ("BaobabScannerColumns", values);
		g_once_init_leave (&baobab_scanner_columns_type_id__volatile, baobab_scanner_columns_type_id);
	}
	return baobab_scanner_columns_type_id__volatile;
}


GType baobab_scanner_state_get_type (void) {
	static volatile gsize baobab_scanner_state_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_scanner_state_type_id__volatile)) {
		static const GEnumValue values[] = {{BAOBAB_SCANNER_STATE_SCANNING, "BAOBAB_SCANNER_STATE_SCANNING", "scanning"}, {BAOBAB_SCANNER_STATE_CANCELLED, "BAOBAB_SCANNER_STATE_CANCELLED", "cancelled"}, {BAOBAB_SCANNER_STATE_NEED_PERCENT, "BAOBAB_SCANNER_STATE_NEED_PERCENT", "need-percent"}, {BAOBAB_SCANNER_STATE_ERROR, "BAOBAB_SCANNER_STATE_ERROR", "error"}, {BAOBAB_SCANNER_STATE_CHILD_ERROR, "BAOBAB_SCANNER_STATE_CHILD_ERROR", "child-error"}, {BAOBAB_SCANNER_STATE_DONE, "BAOBAB_SCANNER_STATE_DONE", "done"}, {0, NULL, NULL}};
		GType baobab_scanner_state_type_id;
		baobab_scanner_state_type_id = g_enum_register_static ("BaobabScannerState", values);
		g_once_init_leave (&baobab_scanner_state_type_id__volatile, baobab_scanner_state_type_id);
	}
	return baobab_scanner_state_type_id__volatile;
}


static void _vala_array_add1 (BaobabScannerResults*** array, int* length, int* size, BaobabScannerResults* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BaobabScannerResults*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean _baobab_scanner_hard_link_equal (const BaobabScannerHardLink* s1, const BaobabScannerHardLink* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->inode != s2->inode) {
		return FALSE;
	}
	if (s1->device != s2->device) {
		return FALSE;
	}
	return TRUE;
}


static gboolean _vala_baobab_scanner_hard_link_array_contains (BaobabScannerHardLink* stack, int stack_length, BaobabScannerHardLink* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (_baobab_scanner_hard_link_equal (&stack[i], needle) == TRUE) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add2 (BaobabScannerHardLink** array, int* length, int* size, const BaobabScannerHardLink* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BaobabScannerHardLink, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static BaobabScannerResults* baobab_scanner_add_directory (BaobabScanner* self, GFile* directory, GFileInfo* info, BaobabScannerResults* parent) {
	BaobabScannerResults* result = NULL;
	BaobabScannerResultsArray* results_array = NULL;
	BaobabScannerResultsArray* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	BaobabScannerResults* results = NULL;
	BaobabScannerResults* _tmp4_ = NULL;
	BaobabScannerResults* _tmp5_ = NULL;
	GFileInfo* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	BaobabScannerResults* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	BaobabScannerResults* _tmp12_ = NULL;
	BaobabScannerResults* _tmp13_ = NULL;
	BaobabScannerResults* _tmp14_ = NULL;
	GFileInfo* _tmp15_ = NULL;
	gint64 _tmp16_ = 0LL;
	GFileInfo* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	BaobabScannerResults* _tmp22_ = NULL;
	BaobabScannerResults* _tmp23_ = NULL;
	BaobabScannerResults* _tmp24_ = NULL;
	BaobabScannerResultsArray* _tmp102_ = NULL;
	BaobabScannerResults** _tmp103_ = NULL;
	gint _tmp103__length1 = 0;
	GAsyncQueue* _tmp109_ = NULL;
	BaobabScannerResultsArray* _tmp110_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (directory != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = baobab_scanner_results_array_new ();
	results_array = _tmp0_;
	_tmp1_ = self->priv->excluded_locations;
	_tmp2_ = directory;
	_tmp3_ = g_hash_table_contains (_tmp1_, _tmp2_);
	if (_tmp3_) {
		result = NULL;
		_baobab_scanner_results_array_free0 (results_array);
		return result;
	}
	_tmp4_ = baobab_scanner_results_new ();
	results = _tmp4_;
	_tmp5_ = results;
	_tmp6_ = info;
	_tmp7_ = g_file_info_get_display_name (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (_tmp5_->display_name);
	_tmp5_->display_name = _tmp8_;
	_tmp9_ = results;
	_tmp10_ = directory;
	_tmp11_ = g_file_get_parse_name (_tmp10_);
	_g_free0 (_tmp9_->parse_name);
	_tmp9_->parse_name = _tmp11_;
	_tmp12_ = results;
	_tmp13_ = parent;
	_tmp12_->parent = _tmp13_;
	_tmp14_ = results;
	_tmp15_ = info;
	_tmp16_ = g_file_info_get_size (_tmp15_);
	_tmp14_->size = (guint64) _tmp16_;
	_tmp17_ = info;
	_tmp18_ = g_file_info_has_attribute (_tmp17_, G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE);
	if (_tmp18_) {
		BaobabScannerResults* _tmp19_ = NULL;
		GFileInfo* _tmp20_ = NULL;
		guint64 _tmp21_ = 0ULL;
		_tmp19_ = results;
		_tmp20_ = info;
		_tmp21_ = g_file_info_get_attribute_uint64 (_tmp20_, G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE);
		_tmp19_->alloc_size = _tmp21_;
	}
	_tmp22_ = results;
	_tmp22_->elements = 1;
	_tmp23_ = results;
	_g_error_free0 (_tmp23_->error);
	_tmp23_->error = NULL;
	_tmp24_ = results;
	_tmp24_->child_error = FALSE;
	{
		GFileEnumerator* children = NULL;
		GFile* _tmp25_ = NULL;
		GCancellable* _tmp26_ = NULL;
		GFileEnumerator* _tmp27_ = NULL;
		GFileInfo* child_info = NULL;
		_tmp25_ = directory;
		_tmp26_ = self->priv->cancellable;
		_tmp27_ = g_file_enumerate_children (_tmp25_, BAOBAB_SCANNER_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, _tmp26_, &_inner_error_);
		children = _tmp27_;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp28_ = NULL;
			GFileEnumerator* _tmp29_ = NULL;
			GCancellable* _tmp30_ = NULL;
			GFileInfo* _tmp31_ = NULL;
			GFileInfo* _tmp32_ = NULL;
			GFileInfo* _tmp33_ = NULL;
			GFileType _tmp34_ = 0;
			_tmp29_ = children;
			_tmp30_ = self->priv->cancellable;
			_tmp31_ = g_file_enumerator_next_file (_tmp29_, _tmp30_, &_inner_error_);
			_tmp28_ = _tmp31_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (child_info);
				_g_object_unref0 (children);
				goto __catch8_g_error;
			}
			_g_object_unref0 (child_info);
			child_info = _tmp28_;
			_tmp32_ = child_info;
			if (!(_tmp32_ != NULL)) {
				break;
			}
			_tmp33_ = child_info;
			_tmp34_ = g_file_info_get_file_type (_tmp33_);
			switch (_tmp34_) {
				case G_FILE_TYPE_DIRECTORY:
				{
					GFile* child = NULL;
					GFile* _tmp35_ = NULL;
					GFileInfo* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					GFile* _tmp38_ = NULL;
					BaobabScannerResults* child_results = NULL;
					GFile* _tmp39_ = NULL;
					GFileInfo* _tmp40_ = NULL;
					BaobabScannerResults* _tmp41_ = NULL;
					BaobabScannerResults* _tmp42_ = NULL;
					BaobabScannerResults* _tmp43_ = NULL;
					_tmp35_ = directory;
					_tmp36_ = child_info;
					_tmp37_ = g_file_info_get_name (_tmp36_);
					_tmp38_ = g_file_get_child (_tmp35_, _tmp37_);
					child = _tmp38_;
					_tmp39_ = child;
					_tmp40_ = child_info;
					_tmp41_ = results;
					_tmp42_ = baobab_scanner_add_directory (self, _tmp39_, _tmp40_, _tmp41_);
					child_results = _tmp42_;
					_tmp43_ = child_results;
					if (_tmp43_ != NULL) {
						BaobabScannerResults* _tmp44_ = NULL;
						BaobabScannerResults* _tmp45_ = NULL;
						guint64 _tmp46_ = 0ULL;
						BaobabScannerResults* _tmp47_ = NULL;
						guint64 _tmp48_ = 0ULL;
						BaobabScannerResults* _tmp49_ = NULL;
						BaobabScannerResults* _tmp50_ = NULL;
						guint64 _tmp51_ = 0ULL;
						BaobabScannerResults* _tmp52_ = NULL;
						guint64 _tmp53_ = 0ULL;
						BaobabScannerResults* _tmp54_ = NULL;
						BaobabScannerResults* _tmp55_ = NULL;
						gint _tmp56_ = 0;
						BaobabScannerResults* _tmp57_ = NULL;
						gint _tmp58_ = 0;
						BaobabScannerResults* _tmp59_ = NULL;
						BaobabScannerResults* _tmp60_ = NULL;
						gint _tmp61_ = 0;
						BaobabScannerResults* _tmp62_ = NULL;
						gint _tmp63_ = 0;
						gint _tmp64_ = 0;
						gboolean _tmp65_ = FALSE;
						BaobabScannerResults* _tmp66_ = NULL;
						GError* _tmp67_ = NULL;
						gboolean _tmp70_ = FALSE;
						BaobabScannerResultsArray* _tmp72_ = NULL;
						BaobabScannerResultsArray* _tmp73_ = NULL;
						BaobabScannerResults** _tmp74_ = NULL;
						gint _tmp74__length1 = 0;
						BaobabScannerResults* _tmp75_ = NULL;
						_tmp44_ = results;
						_tmp45_ = results;
						_tmp46_ = _tmp45_->size;
						_tmp47_ = child_results;
						_tmp48_ = _tmp47_->size;
						_tmp45_->size = _tmp46_ + _tmp48_;
						_tmp49_ = results;
						_tmp50_ = results;
						_tmp51_ = _tmp50_->alloc_size;
						_tmp52_ = child_results;
						_tmp53_ = _tmp52_->alloc_size;
						_tmp50_->alloc_size = _tmp51_ + _tmp53_;
						_tmp54_ = results;
						_tmp55_ = results;
						_tmp56_ = _tmp55_->elements;
						_tmp57_ = child_results;
						_tmp58_ = _tmp57_->elements;
						_tmp55_->elements = _tmp56_ + _tmp58_;
						_tmp59_ = results;
						_tmp60_ = results;
						_tmp61_ = _tmp60_->max_depth;
						_tmp62_ = child_results;
						_tmp63_ = _tmp62_->max_depth;
						_tmp64_ = MAX (_tmp61_, _tmp63_ + 1);
						_tmp59_->max_depth = _tmp64_;
						_tmp66_ = child_results;
						_tmp67_ = _tmp66_->error;
						if (_tmp67_ != NULL) {
							_tmp65_ = TRUE;
						} else {
							BaobabScannerResults* _tmp68_ = NULL;
							gboolean _tmp69_ = FALSE;
							_tmp68_ = child_results;
							_tmp69_ = _tmp68_->child_error;
							_tmp65_ = _tmp69_;
						}
						_tmp70_ = _tmp65_;
						if (_tmp70_) {
							BaobabScannerResults* _tmp71_ = NULL;
							_tmp71_ = results;
							_tmp71_->child_error = TRUE;
						}
						_tmp72_ = results_array;
						_tmp73_ = results_array;
						_tmp74_ = _tmp73_->results;
						_tmp74__length1 = _tmp73_->results_length1;
						_tmp75_ = child_results;
						child_results = NULL;
						_vala_array_add1 (&_tmp72_->results, &_tmp72_->results_length1, &_tmp72_->_results_size_, _tmp75_);
					}
					_baobab_scanner_results_free0 (child_results);
					_g_object_unref0 (child);
					break;
				}
				case G_FILE_TYPE_REGULAR:
				{
					GFileInfo* _tmp76_ = NULL;
					gboolean _tmp77_ = FALSE;
					BaobabScannerResults* _tmp85_ = NULL;
					BaobabScannerResults* _tmp86_ = NULL;
					guint64 _tmp87_ = 0ULL;
					GFileInfo* _tmp88_ = NULL;
					gint64 _tmp89_ = 0LL;
					GFileInfo* _tmp90_ = NULL;
					gboolean _tmp91_ = FALSE;
					BaobabScannerResults* _tmp97_ = NULL;
					gint _tmp98_ = 0;
					_tmp76_ = child_info;
					_tmp77_ = g_file_info_has_attribute (_tmp76_, G_FILE_ATTRIBUTE_UNIX_NLINK);
					if (_tmp77_) {
						GFileInfo* _tmp78_ = NULL;
						guint32 _tmp79_ = 0U;
						_tmp78_ = child_info;
						_tmp79_ = g_file_info_get_attribute_uint32 (_tmp78_, G_FILE_ATTRIBUTE_UNIX_NLINK);
						if (_tmp79_ > ((guint32) 1)) {
							BaobabScannerHardLink hl = {0};
							GFileInfo* _tmp80_ = NULL;
							BaobabScannerHardLink _tmp81_ = {0};
							BaobabScannerHardLink* _tmp82_ = NULL;
							gint _tmp82__length1 = 0;
							BaobabScannerHardLink* _tmp83_ = NULL;
							gint _tmp83__length1 = 0;
							BaobabScannerHardLink _tmp84_ = {0};
							_tmp80_ = child_info;
							baobab_scanner_hard_link_init (&hl, _tmp80_);
							_tmp81_ = hl;
							_tmp82_ = self->priv->hardlinks;
							_tmp82__length1 = self->priv->hardlinks_length1;
							if (_vala_baobab_scanner_hard_link_array_contains (_tmp82_, _tmp82__length1, &_tmp81_)) {
								continue;
							}
							_tmp83_ = self->priv->hardlinks;
							_tmp83__length1 = self->priv->hardlinks_length1;
							_tmp84_ = hl;
							_vala_array_add2 (&self->priv->hardlinks, &self->priv->hardlinks_length1, &self->priv->_hardlinks_size_, &_tmp84_);
						}
					}
					_tmp85_ = results;
					_tmp86_ = results;
					_tmp87_ = _tmp86_->size;
					_tmp88_ = child_info;
					_tmp89_ = g_file_info_get_size (_tmp88_);
					_tmp86_->size = _tmp87_ + _tmp89_;
					_tmp90_ = child_info;
					_tmp91_ = g_file_info_has_attribute (_tmp90_, G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE);
					if (_tmp91_) {
						BaobabScannerResults* _tmp92_ = NULL;
						BaobabScannerResults* _tmp93_ = NULL;
						guint64 _tmp94_ = 0ULL;
						GFileInfo* _tmp95_ = NULL;
						guint64 _tmp96_ = 0ULL;
						_tmp92_ = results;
						_tmp93_ = results;
						_tmp94_ = _tmp93_->alloc_size;
						_tmp95_ = child_info;
						_tmp96_ = g_file_info_get_attribute_uint64 (_tmp95_, G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE);
						_tmp93_->alloc_size = _tmp94_ + _tmp96_;
					}
					_tmp97_ = results;
					_tmp98_ = _tmp97_->elements;
					_tmp97_->elements = _tmp98_ + 1;
					break;
				}
				default:
				{
					break;
				}
			}
		}
		_g_object_unref0 (child_info);
		_g_object_unref0 (children);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		BaobabScannerResults* _tmp99_ = NULL;
		GError* _tmp100_ = NULL;
		GError* _tmp101_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp99_ = results;
		_tmp100_ = e;
		_tmp101_ = _g_error_copy0 (_tmp100_);
		_g_error_free0 (_tmp99_->error);
		_tmp99_->error = _tmp101_;
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_baobab_scanner_results_free0 (results);
		_baobab_scanner_results_array_free0 (results_array);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp102_ = results_array;
	_tmp103_ = _tmp102_->results;
	_tmp103__length1 = _tmp102_->results_length1;
	{
		BaobabScannerResults** child_results_collection = NULL;
		gint child_results_collection_length1 = 0;
		gint _child_results_collection_size_ = 0;
		gint child_results_it = 0;
		child_results_collection = _tmp103_;
		child_results_collection_length1 = _tmp103__length1;
		for (child_results_it = 0; child_results_it < _tmp103__length1; child_results_it = child_results_it + 1) {
			BaobabScannerResults* child_results = NULL;
			child_results = child_results_collection[child_results_it];
			{
				BaobabScannerResults* _tmp104_ = NULL;
				BaobabScannerResults* _tmp105_ = NULL;
				guint64 _tmp106_ = 0ULL;
				BaobabScannerResults* _tmp107_ = NULL;
				guint64 _tmp108_ = 0ULL;
				_tmp104_ = child_results;
				_tmp105_ = child_results;
				_tmp106_ = _tmp105_->size;
				_tmp107_ = results;
				_tmp108_ = _tmp107_->size;
				_tmp104_->percent = (100 * ((gdouble) _tmp106_)) / ((gdouble) _tmp108_);
			}
		}
	}
	_tmp109_ = self->priv->results_queue;
	_tmp110_ = results_array;
	results_array = NULL;
	g_async_queue_push (_tmp109_, _tmp110_);
	result = results;
	_baobab_scanner_results_array_free0 (results_array);
	return result;
}


static void _vala_array_add3 (BaobabScannerResults*** array, int* length, int* size, BaobabScannerResults* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BaobabScannerResults*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void* baobab_scanner_scan_in_thread (BaobabScanner* self) {
	void* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		BaobabScannerResultsArray* array = NULL;
		BaobabScannerResultsArray* _tmp0_ = NULL;
		GFileInfo* info = NULL;
		GFile* _tmp1_ = NULL;
		GCancellable* _tmp2_ = NULL;
		GFileInfo* _tmp3_ = NULL;
		BaobabScannerResults* results = NULL;
		GFile* _tmp4_ = NULL;
		BaobabScannerResults* _tmp5_ = NULL;
		BaobabScannerResults* _tmp6_ = NULL;
		BaobabScannerResultsArray* _tmp7_ = NULL;
		BaobabScannerResultsArray* _tmp8_ = NULL;
		BaobabScannerResults** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		BaobabScannerResults* _tmp10_ = NULL;
		GAsyncQueue* _tmp11_ = NULL;
		BaobabScannerResultsArray* _tmp12_ = NULL;
		_tmp0_ = baobab_scanner_results_array_new ();
		array = _tmp0_;
		_tmp1_ = self->priv->_directory;
		_tmp2_ = self->priv->cancellable;
		_tmp3_ = g_file_query_info (_tmp1_, BAOBAB_SCANNER_ATTRIBUTES, 0, _tmp2_, &_inner_error_);
		info = _tmp3_;
		if (_inner_error_ != NULL) {
			_baobab_scanner_results_array_free0 (array);
			goto __catch9_g_error;
		}
		_tmp4_ = self->priv->_directory;
		_tmp5_ = baobab_scanner_add_directory (self, _tmp4_, info, NULL);
		results = _tmp5_;
		_tmp6_ = results;
		_tmp6_->percent = 100.0;
		_tmp7_ = array;
		_tmp8_ = array;
		_tmp9_ = _tmp8_->results;
		_tmp9__length1 = _tmp8_->results_length1;
		_tmp10_ = results;
		results = NULL;
		_vala_array_add3 (&_tmp7_->results, &_tmp7_->results_length1, &_tmp7_->_results_size_, _tmp10_);
		_tmp11_ = self->priv->results_queue;
		_tmp12_ = array;
		array = NULL;
		g_async_queue_push (_tmp11_, _tmp12_);
		_baobab_scanner_results_free0 (results);
		_g_object_unref0 (info);
		_baobab_scanner_results_array_free0 (array);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (self->priv->self);
	self->priv->self = NULL;
	result = NULL;
	return result;
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
	dup = g_new0 (GtkTreeIter, 1);
	memcpy (dup, self, sizeof (GtkTreeIter));
	return dup;
}


static gpointer __gtk_tree_iter_dup0 (gpointer self) {
	return self ? _gtk_tree_iter_dup (self) : NULL;
}


static void baobab_scanner_ensure_iter_exists (BaobabScanner* self, BaobabScannerResults* results) {
	GtkTreeIter* parent_iter = NULL;
	BaobabScannerResults* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	BaobabScannerResults* _tmp2_ = NULL;
	BaobabScannerResults* _tmp3_ = NULL;
	BaobabScannerResults* _tmp10_ = NULL;
	GtkTreeIter* _tmp11_ = NULL;
	GtkTreeIter _tmp12_ = {0};
	BaobabScannerResults* _tmp13_ = NULL;
	GtkTreeIter _tmp14_ = {0};
	BaobabScannerResults* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	BaobabScannerResults* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	BaobabScannerResults* _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results != NULL);
	_tmp0_ = results;
	_tmp1_ = _tmp0_->iter_is_set;
	if (_tmp1_) {
		_g_free0 (parent_iter);
		return;
	}
	_tmp2_ = results;
	_tmp3_ = _tmp2_->parent;
	if (_tmp3_ != NULL) {
		BaobabScannerResults* _tmp4_ = NULL;
		BaobabScannerResults* _tmp5_ = NULL;
		BaobabScannerResults* _tmp6_ = NULL;
		BaobabScannerResults* _tmp7_ = NULL;
		GtkTreeIter _tmp8_ = {0};
		GtkTreeIter* _tmp9_ = NULL;
		_tmp4_ = results;
		_tmp5_ = _tmp4_->parent;
		baobab_scanner_ensure_iter_exists (self, _tmp5_);
		_tmp6_ = results;
		_tmp7_ = _tmp6_->parent;
		_tmp8_ = _tmp7_->iter;
		_tmp9_ = __gtk_tree_iter_dup0 (&_tmp8_);
		_g_free0 (parent_iter);
		parent_iter = _tmp9_;
	} else {
		_g_free0 (parent_iter);
		parent_iter = NULL;
	}
	_tmp10_ = results;
	_tmp11_ = parent_iter;
	gtk_tree_store_append ((GtkTreeStore*) self, &_tmp12_, _tmp11_);
	_tmp10_->iter = _tmp12_;
	_tmp13_ = results;
	_tmp14_ = _tmp13_->iter;
	_tmp15_ = results;
	_tmp16_ = _tmp15_->display_name;
	_tmp17_ = results;
	_tmp18_ = _tmp17_->parse_name;
	gtk_tree_store_set ((GtkTreeStore*) self, &_tmp14_, BAOBAB_SCANNER_COLUMNS_STATE, BAOBAB_SCANNER_STATE_SCANNING, BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME, _tmp16_, BAOBAB_SCANNER_COLUMNS_PARSE_NAME, _tmp18_, -1);
	_tmp19_ = results;
	_tmp19_->iter_is_set = TRUE;
	_g_free0 (parent_iter);
}


static gboolean baobab_scanner_process_results (BaobabScanner* self) {
	gboolean result = FALSE;
	BaobabScanner* _tmp41_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	while (TRUE) {
		BaobabScannerResultsArray* results_array = NULL;
		GAsyncQueue* _tmp0_ = NULL;
		gpointer _tmp1_ = NULL;
		BaobabScannerResultsArray* _tmp2_ = NULL;
		BaobabScannerResultsArray* _tmp3_ = NULL;
		BaobabScannerResults** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp0_ = self->priv->results_queue;
		_tmp1_ = g_async_queue_try_pop (_tmp0_);
		results_array = (BaobabScannerResultsArray*) _tmp1_;
		_tmp2_ = results_array;
		if (_tmp2_ == NULL) {
			_baobab_scanner_results_array_free0 (results_array);
			break;
		}
		_tmp3_ = results_array;
		_tmp4_ = _tmp3_->results;
		_tmp4__length1 = _tmp3_->results_length1;
		{
			BaobabScannerResults** results_collection = NULL;
			gint results_collection_length1 = 0;
			gint _results_collection_size_ = 0;
			gint results_it = 0;
			results_collection = _tmp4_;
			results_collection_length1 = _tmp4__length1;
			for (results_it = 0; results_it < _tmp4__length1; results_it = results_it + 1) {
				BaobabScannerResults* results = NULL;
				results = results_collection[results_it];
				{
					BaobabScannerResults* _tmp5_ = NULL;
					BaobabScannerState state = 0;
					BaobabScannerResults* _tmp6_ = NULL;
					gboolean _tmp7_ = FALSE;
					BaobabScannerResults* _tmp10_ = NULL;
					GtkTreeIter _tmp11_ = {0};
					BaobabScannerResults* _tmp12_ = NULL;
					guint64 _tmp13_ = 0ULL;
					BaobabScannerResults* _tmp14_ = NULL;
					guint64 _tmp15_ = 0ULL;
					BaobabScannerResults* _tmp16_ = NULL;
					gdouble _tmp17_ = 0.0;
					BaobabScannerResults* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					BaobabScannerState _tmp20_ = 0;
					BaobabScannerResults* _tmp21_ = NULL;
					GError* _tmp22_ = NULL;
					BaobabScannerResults* _tmp23_ = NULL;
					gint _tmp24_ = 0;
					gint _tmp25_ = 0;
					BaobabScannerResults* _tmp28_ = NULL;
					GError* _tmp29_ = NULL;
					BaobabScannerResults* _tmp39_ = NULL;
					BaobabScannerResults* _tmp40_ = NULL;
					_tmp5_ = results;
					baobab_scanner_ensure_iter_exists (self, _tmp5_);
					_tmp6_ = results;
					_tmp7_ = _tmp6_->child_error;
					if (_tmp7_) {
						state = BAOBAB_SCANNER_STATE_CHILD_ERROR;
					} else {
						BaobabScannerResults* _tmp8_ = NULL;
						GError* _tmp9_ = NULL;
						_tmp8_ = results;
						_tmp9_ = _tmp8_->error;
						if (_tmp9_ != NULL) {
							state = BAOBAB_SCANNER_STATE_ERROR;
						} else {
							state = BAOBAB_SCANNER_STATE_DONE;
						}
					}
					_tmp10_ = results;
					_tmp11_ = _tmp10_->iter;
					_tmp12_ = results;
					_tmp13_ = _tmp12_->size;
					_tmp14_ = results;
					_tmp15_ = _tmp14_->alloc_size;
					_tmp16_ = results;
					_tmp17_ = _tmp16_->percent;
					_tmp18_ = results;
					_tmp19_ = _tmp18_->elements;
					_tmp20_ = state;
					_tmp21_ = results;
					_tmp22_ = _tmp21_->error;
					gtk_tree_store_set ((GtkTreeStore*) self, &_tmp11_, BAOBAB_SCANNER_COLUMNS_SIZE, _tmp13_, BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE, _tmp15_, BAOBAB_SCANNER_COLUMNS_PERCENT, _tmp17_, BAOBAB_SCANNER_COLUMNS_ELEMENTS, _tmp19_, BAOBAB_SCANNER_COLUMNS_STATE, _tmp20_, BAOBAB_SCANNER_COLUMNS_ERROR, _tmp22_, -1);
					_tmp23_ = results;
					_tmp24_ = _tmp23_->max_depth;
					_tmp25_ = self->priv->_max_depth;
					if (_tmp24_ > _tmp25_) {
						BaobabScannerResults* _tmp26_ = NULL;
						gint _tmp27_ = 0;
						_tmp26_ = results;
						_tmp27_ = _tmp26_->max_depth;
						baobab_scanner_set_max_depth (self, _tmp27_);
					}
					_tmp28_ = results;
					_tmp29_ = _tmp28_->error;
					if (_tmp29_ != NULL) {
						BaobabScannerResults* _tmp30_ = NULL;
						GError* _tmp31_ = NULL;
						_tmp30_ = results;
						_tmp31_ = _tmp30_->error;
						if (g_error_matches (_tmp31_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
							BaobabScannerResults* _tmp32_ = NULL;
							GError* _tmp33_ = NULL;
							GError* _tmp34_ = NULL;
							_tmp32_ = results;
							_tmp33_ = _tmp32_->error;
							_tmp34_ = _g_error_copy0 (_tmp33_);
							_g_error_free0 (self->priv->scan_error);
							self->priv->scan_error = _tmp34_;
							g_signal_emit_by_name (self, "completed");
							result = FALSE;
							_baobab_scanner_results_array_free0 (results_array);
							return result;
						} else {
							GError* _tmp35_ = NULL;
							_tmp35_ = self->priv->scan_error;
							if (_tmp35_ == NULL) {
								BaobabScannerResults* _tmp36_ = NULL;
								GError* _tmp37_ = NULL;
								GError* _tmp38_ = NULL;
								_tmp36_ = results;
								_tmp37_ = _tmp36_->error;
								_tmp38_ = _g_error_copy0 (_tmp37_);
								_g_error_free0 (self->priv->scan_error);
								self->priv->scan_error = _tmp38_;
							}
						}
					}
					_tmp39_ = results;
					_tmp40_ = _tmp39_->parent;
					if (_tmp40_ == NULL) {
						self->priv->successful = TRUE;
						g_signal_emit_by_name (self, "completed");
						result = FALSE;
						_baobab_scanner_results_array_free0 (results_array);
						return result;
					}
				}
			}
		}
		_baobab_scanner_results_array_free0 (results_array);
	}
	_tmp41_ = self->priv->self;
	result = _tmp41_ != NULL;
	return result;
}


static void baobab_scanner_cancel_and_reset (BaobabScanner* self) {
	GCancellable* _tmp0_ = NULL;
	GThread* _tmp1_ = NULL;
	guint _tmp3_ = 0U;
	BaobabScannerResultsArray* tmp = NULL;
	GAsyncQueue* _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
	GCancellable* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
	_tmp1_ = self->priv->thread;
	if (_tmp1_ != NULL) {
		GThread* _tmp2_ = NULL;
		_tmp2_ = self->priv->thread;
		g_thread_join (_tmp2_);
		_g_thread_unref0 (self->priv->thread);
		self->priv->thread = NULL;
	}
	_tmp3_ = self->priv->process_result_idle;
	if (_tmp3_ != ((guint) 0)) {
		guint _tmp4_ = 0U;
		_tmp4_ = self->priv->process_result_idle;
		g_source_remove (_tmp4_);
		self->priv->process_result_idle = (guint) 0;
	}
	_tmp5_ = self->priv->results_queue;
	_tmp6_ = g_async_queue_try_pop (_tmp5_);
	tmp = (BaobabScannerResultsArray*) _tmp6_;
	while (TRUE) {
		BaobabScannerResultsArray* _tmp7_ = NULL;
		GAsyncQueue* _tmp8_ = NULL;
		gpointer _tmp9_ = NULL;
		_tmp7_ = tmp;
		if (!(_tmp7_ != NULL)) {
			break;
		}
		_tmp8_ = self->priv->results_queue;
		_tmp9_ = g_async_queue_try_pop (_tmp8_);
		_baobab_scanner_results_array_free0 (tmp);
		tmp = (BaobabScannerResultsArray*) _tmp9_;
	}
	gtk_tree_store_clear (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_TREE_STORE, GtkTreeStore));
	_tmp10_ = self->priv->cancellable;
	g_cancellable_reset (_tmp10_);
	_g_error_free0 (self->priv->scan_error);
	self->priv->scan_error = NULL;
	_baobab_scanner_results_array_free0 (tmp);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _baobab_scanner_scan_in_thread_gthread_func (gpointer self) {
	gpointer result;
	result = baobab_scanner_scan_in_thread (self);
	g_object_unref (self);
	return result;
}


static gboolean _baobab_scanner_process_results_gsource_func (gpointer self) {
	gboolean result;
	result = baobab_scanner_process_results (self);
	return result;
}


void baobab_scanner_scan (BaobabScanner* self, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = force;
	if (_tmp0_) {
		self->priv->successful = FALSE;
	}
	_tmp1_ = self->priv->successful;
	if (!_tmp1_) {
		BaobabScanner* _tmp2_ = NULL;
		GThread* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		baobab_scanner_cancel_and_reset (self);
		_tmp2_ = _g_object_ref0 (self);
		_g_object_unref0 (self->priv->self);
		self->priv->self = _tmp2_;
		_tmp3_ = g_thread_new ("scanner", _baobab_scanner_scan_in_thread_gthread_func, g_object_ref (self));
		_g_thread_unref0 (self->priv->thread);
		self->priv->thread = _tmp3_;
		_tmp4_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _baobab_scanner_process_results_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->process_result_idle = _tmp4_;
	} else {
		g_signal_emit_by_name (self, "completed");
	}
}


void baobab_scanner_cancel (BaobabScanner* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->successful;
	if (!_tmp0_) {
		baobab_scanner_cancel_and_reset (self);
	}
}


void baobab_scanner_finish (BaobabScanner* self, GError** error) {
	GError* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scan_error;
	if (_tmp0_ != NULL) {
		GError* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = self->priv->scan_error;
		_tmp2_ = _g_error_copy0 (_tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void _g_unix_mount_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_unix_mount_free (var), NULL));
}


static void _g_list_free__g_unix_mount_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_unix_mount_free0_, NULL);
	g_list_free (self);
}


static void _baobab_scanner_results_array_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (baobab_scanner_results_array_free (var), NULL));
}


BaobabScanner* baobab_scanner_construct (GType object_type, GFile* directory, BaobabScanFlags flags) {
	BaobabScanner * self = NULL;
	GFile* _tmp0_ = NULL;
	BaobabScanFlags _tmp1_ = 0;
	GCancellable* _tmp2_ = NULL;
	GType* _tmp3_ = NULL;
	GType* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GHashTable* _tmp5_ = NULL;
	BaobabScanFlags _tmp6_ = 0;
	GHashTable* _tmp12_ = NULL;
	GFile* _tmp13_ = NULL;
	GAsyncQueue* _tmp14_ = NULL;
	g_return_val_if_fail (directory != NULL, NULL);
	self = (BaobabScanner*) g_object_new (object_type, NULL);
	_tmp0_ = directory;
	baobab_scanner_set_directory (self, _tmp0_);
	_tmp1_ = flags;
	baobab_scanner_set_scan_flags (self, _tmp1_);
	_tmp2_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp2_;
	_g_error_free0 (self->priv->scan_error);
	self->priv->scan_error = NULL;
	_tmp3_ = g_new0 (GType, 8);
	_tmp3_[0] = G_TYPE_STRING;
	_tmp3_[1] = G_TYPE_STRING;
	_tmp3_[2] = G_TYPE_DOUBLE;
	_tmp3_[3] = G_TYPE_UINT64;
	_tmp3_[4] = G_TYPE_UINT64;
	_tmp3_[5] = G_TYPE_INT;
	_tmp3_[6] = BAOBAB_SCANNER_TYPE_STATE;
	_tmp3_[7] = G_TYPE_ERROR;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 8;
	gtk_tree_store_set_column_types ((GtkTreeStore*) self, 8, _tmp4_);
	_tmp4_ = (g_free (_tmp4_), NULL);
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self, (gint) BAOBAB_SCANNER_COLUMNS_SIZE, GTK_SORT_DESCENDING);
	_tmp5_ = baobab_application_get_excluded_locations ();
	_g_hash_table_unref0 (self->priv->excluded_locations);
	self->priv->excluded_locations = _tmp5_;
	_tmp6_ = flags;
	if ((_tmp6_ & BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS) == BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS) {
		GList* _tmp7_ = NULL;
		_tmp7_ = g_unix_mounts_get (NULL);
		{
			GList* mount_collection = NULL;
			GList* mount_it = NULL;
			mount_collection = _tmp7_;
			for (mount_it = mount_collection; mount_it != NULL; mount_it = mount_it->next) {
				GUnixMountEntry* mount = NULL;
				mount = (GUnixMountEntry*) mount_it->data;
				{
					GHashTable* _tmp8_ = NULL;
					GUnixMountEntry* _tmp9_ = NULL;
					const gchar* _tmp10_ = NULL;
					GFile* _tmp11_ = NULL;
					_tmp8_ = self->priv->excluded_locations;
					_tmp9_ = mount;
					_tmp10_ = g_unix_mount_get_mount_path (_tmp9_);
					_tmp11_ = g_file_new_for_path (_tmp10_);
					g_hash_table_add (_tmp8_, _tmp11_);
				}
			}
			__g_list_free__g_unix_mount_free0_0 (mount_collection);
		}
	}
	_tmp12_ = self->priv->excluded_locations;
	_tmp13_ = directory;
	g_hash_table_remove (_tmp12_, _tmp13_);
	_tmp14_ = g_async_queue_new_full (_baobab_scanner_results_array_free0_);
	_g_async_queue_unref0 (self->priv->results_queue);
	self->priv->results_queue = _tmp14_;
	return self;
}


BaobabScanner* baobab_scanner_new (GFile* directory, BaobabScanFlags flags) {
	return baobab_scanner_construct (BAOBAB_TYPE_SCANNER, directory, flags);
}


GFile* baobab_scanner_get_directory (BaobabScanner* self) {
	GFile* result;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_directory;
	result = _tmp0_;
	return result;
}


static void baobab_scanner_set_directory (BaobabScanner* self, GFile* value) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_directory);
	self->priv->_directory = _tmp1_;
	g_object_notify ((GObject *) self, "directory");
}


BaobabScanFlags baobab_scanner_get_scan_flags (BaobabScanner* self) {
	BaobabScanFlags result;
	BaobabScanFlags _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_scan_flags;
	result = _tmp0_;
	return result;
}


static void baobab_scanner_set_scan_flags (BaobabScanner* self, BaobabScanFlags value) {
	BaobabScanFlags _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_scan_flags = _tmp0_;
	g_object_notify ((GObject *) self, "scan-flags");
}


gint baobab_scanner_get_max_depth (BaobabScanner* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_max_depth;
	result = _tmp0_;
	return result;
}


void baobab_scanner_set_max_depth (BaobabScanner* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_max_depth = _tmp0_;
	g_object_notify ((GObject *) self, "max-depth");
}


static BaobabScannerResultsArray* baobab_scanner_results_array_new (void) {
	BaobabScannerResultsArray* self;
	self = g_slice_new0 (BaobabScannerResultsArray);
	baobab_scanner_results_array_instance_init (self);
	return self;
}


static void baobab_scanner_results_array_instance_init (BaobabScannerResultsArray * self) {
}


static void baobab_scanner_results_array_free (BaobabScannerResultsArray* self) {
	self->results = (_vala_array_free (self->results, self->results_length1, (GDestroyNotify) baobab_scanner_results_free), NULL);
	g_slice_free (BaobabScannerResultsArray, self);
}


static BaobabScannerResults* baobab_scanner_results_new (void) {
	BaobabScannerResults* self;
	self = g_slice_new0 (BaobabScannerResults);
	baobab_scanner_results_instance_init (self);
	return self;
}


static void baobab_scanner_results_instance_init (BaobabScannerResults * self) {
}


static void baobab_scanner_results_free (BaobabScannerResults* self) {
	_g_free0 (self->display_name);
	_g_free0 (self->parse_name);
	_g_error_free0 (self->error);
	g_slice_free (BaobabScannerResults, self);
}


static void baobab_scanner_hard_link_init (BaobabScannerHardLink *self, GFileInfo* info) {
	GFileInfo* _tmp0_ = NULL;
	guint64 _tmp1_ = 0ULL;
	GFileInfo* _tmp2_ = NULL;
	guint32 _tmp3_ = 0U;
	g_return_if_fail (info != NULL);
	memset (self, 0, sizeof (BaobabScannerHardLink));
	_tmp0_ = info;
	_tmp1_ = g_file_info_get_attribute_uint64 (_tmp0_, G_FILE_ATTRIBUTE_UNIX_INODE);
	(*self).inode = _tmp1_;
	_tmp2_ = info;
	_tmp3_ = g_file_info_get_attribute_uint32 (_tmp2_, G_FILE_ATTRIBUTE_UNIX_DEVICE);
	(*self).device = _tmp3_;
}


static BaobabScannerHardLink* baobab_scanner_hard_link_dup (const BaobabScannerHardLink* self) {
	BaobabScannerHardLink* dup;
	dup = g_new0 (BaobabScannerHardLink, 1);
	memcpy (dup, self, sizeof (BaobabScannerHardLink));
	return dup;
}


static void baobab_scanner_hard_link_free (BaobabScannerHardLink* self) {
	g_free (self);
}


static GType baobab_scanner_hard_link_get_type (void) {
	static volatile gsize baobab_scanner_hard_link_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_scanner_hard_link_type_id__volatile)) {
		GType baobab_scanner_hard_link_type_id;
		baobab_scanner_hard_link_type_id = g_boxed_type_register_static ("BaobabScannerHardLink", (GBoxedCopyFunc) baobab_scanner_hard_link_dup, (GBoxedFreeFunc) baobab_scanner_hard_link_free);
		g_once_init_leave (&baobab_scanner_hard_link_type_id__volatile, baobab_scanner_hard_link_type_id);
	}
	return baobab_scanner_hard_link_type_id__volatile;
}


static void baobab_scanner_class_init (BaobabScannerClass * klass) {
	baobab_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabScannerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_scanner_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_scanner_set_property;
	G_OBJECT_CLASS (klass)->finalize = baobab_scanner_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_DIRECTORY, g_param_spec_object ("directory", "directory", "directory", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_SCAN_FLAGS, g_param_spec_flags ("scan-flags", "scan-flags", "scan-flags", BAOBAB_TYPE_SCAN_FLAGS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_MAX_DEPTH, g_param_spec_int ("max-depth", "max-depth", "max-depth", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("completed", BAOBAB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void baobab_scanner_instance_init (BaobabScanner * self) {
	self->priv = BAOBAB_SCANNER_GET_PRIVATE (self);
	self->priv->thread = NULL;
	self->priv->process_result_idle = (guint) 0;
	self->priv->successful = FALSE;
}


static void baobab_scanner_finalize (GObject* obj) {
	BaobabScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_SCANNER, BaobabScanner);
	_g_object_unref0 (self->priv->_directory);
	_g_thread_unref0 (self->priv->thread);
	self->priv->hardlinks = (g_free (self->priv->hardlinks), NULL);
	_g_hash_table_unref0 (self->priv->excluded_locations);
	_g_async_queue_unref0 (self->priv->results_queue);
	_g_object_unref0 (self->priv->self);
	_g_object_unref0 (self->priv->cancellable);
	_g_error_free0 (self->priv->scan_error);
	G_OBJECT_CLASS (baobab_scanner_parent_class)->finalize (obj);
}


GType baobab_scanner_get_type (void) {
	static volatile gsize baobab_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabScanner), 0, (GInstanceInitFunc) baobab_scanner_instance_init, NULL };
		GType baobab_scanner_type_id;
		baobab_scanner_type_id = g_type_register_static (GTK_TYPE_TREE_STORE, "BaobabScanner", &g_define_type_info, 0);
		g_once_init_leave (&baobab_scanner_type_id__volatile, baobab_scanner_type_id);
	}
	return baobab_scanner_type_id__volatile;
}


static void _vala_baobab_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BaobabScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_SCANNER, BaobabScanner);
	switch (property_id) {
		case BAOBAB_SCANNER_DIRECTORY:
		g_value_set_object (value, baobab_scanner_get_directory (self));
		break;
		case BAOBAB_SCANNER_SCAN_FLAGS:
		g_value_set_flags (value, baobab_scanner_get_scan_flags (self));
		break;
		case BAOBAB_SCANNER_MAX_DEPTH:
		g_value_set_int (value, baobab_scanner_get_max_depth (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_baobab_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BaobabScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_SCANNER, BaobabScanner);
	switch (property_id) {
		case BAOBAB_SCANNER_DIRECTORY:
		baobab_scanner_set_directory (self, g_value_get_object (value));
		break;
		case BAOBAB_SCANNER_SCAN_FLAGS:
		baobab_scanner_set_scan_flags (self, g_value_get_flags (value));
		break;
		case BAOBAB_SCANNER_MAX_DEPTH:
		baobab_scanner_set_max_depth (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



