/* bug-buddy bug submitting program
 *
 * Copyright (C) 1999 - 2001 Jacob Berkman
 * Copyright 2000 Ximian, Inc.
 *
 * Author:  jacob berkman  <jacob@bug-buddy.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __BUG_BUDDY_H__
#define __BUG_BUDDY_H__

#include "bugzilla.h"

#include <glade/glade.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <sys/types.h>


typedef struct {
	/* contact page */
	gchar *name;
	gchar *email;
	
	/* package page */
	gchar *package;
	gchar *package_ver;
	
	/* dialog page */
	gchar *app_file;
	int pid;
	
	/* core page */
	gchar *core_file;

	/* file to include */
	gchar *include_file;

	/* pid to kill after the bug report */
	int kill;
} GOptionData;

enum {
	LOADING_INFO,
	DEBUGGING,
	SENDING,
	DONE
};


void buddy_error (GtkWidget *parent, const char *msg, ...);
void gdb_finished (gpointer data);


#endif /* __bug_buddy_h__ */
