/* json-deserializer.c generated by valac 0.12.0, the Vala compiler
 * generated from json-deserializer.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>
#include <stdio.h>
#include <float.h>
#include <math.h>


#define CARIBOU_TYPE_JSON_DESERIALIZER (caribou_json_deserializer_get_type ())
#define CARIBOU_JSON_DESERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CARIBOU_TYPE_JSON_DESERIALIZER, CaribouJsonDeserializer))
#define CARIBOU_JSON_DESERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CARIBOU_TYPE_JSON_DESERIALIZER, CaribouJsonDeserializerClass))
#define CARIBOU_IS_JSON_DESERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CARIBOU_TYPE_JSON_DESERIALIZER))
#define CARIBOU_IS_JSON_DESERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CARIBOU_TYPE_JSON_DESERIALIZER))
#define CARIBOU_JSON_DESERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CARIBOU_TYPE_JSON_DESERIALIZER, CaribouJsonDeserializerClass))

typedef struct _CaribouJsonDeserializer CaribouJsonDeserializer;
typedef struct _CaribouJsonDeserializerClass CaribouJsonDeserializerClass;
typedef struct _CaribouJsonDeserializerPrivate CaribouJsonDeserializerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define CARIBOU_TYPE_GROUP_MODEL (caribou_group_model_get_type ())
#define CARIBOU_GROUP_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CARIBOU_TYPE_GROUP_MODEL, CaribouGroupModel))
#define CARIBOU_GROUP_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CARIBOU_TYPE_GROUP_MODEL, CaribouGroupModelClass))
#define CARIBOU_IS_GROUP_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CARIBOU_TYPE_GROUP_MODEL))
#define CARIBOU_IS_GROUP_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CARIBOU_TYPE_GROUP_MODEL))
#define CARIBOU_GROUP_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CARIBOU_TYPE_GROUP_MODEL, CaribouGroupModelClass))

typedef struct _CaribouGroupModel CaribouGroupModel;
typedef struct _CaribouGroupModelClass CaribouGroupModelClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define CARIBOU_TYPE_SCANNABLE_GROUP (caribou_scannable_group_get_type ())
#define CARIBOU_SCANNABLE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CARIBOU_TYPE_SCANNABLE_GROUP, CaribouScannableGroup))
#define CARIBOU_SCANNABLE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CARIBOU_TYPE_SCANNABLE_GROUP, CaribouScannableGroupClass))
#define CARIBOU_IS_SCANNABLE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CARIBOU_TYPE_SCANNABLE_GROUP))
#define CARIBOU_IS_SCANNABLE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CARIBOU_TYPE_SCANNABLE_GROUP))
#define CARIBOU_SCANNABLE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CARIBOU_TYPE_SCANNABLE_GROUP, CaribouScannableGroupClass))

typedef struct _CaribouScannableGroup CaribouScannableGroup;
typedef struct _CaribouScannableGroupClass CaribouScannableGroupClass;

#define CARIBOU_TYPE_LEVEL_MODEL (caribou_level_model_get_type ())
#define CARIBOU_LEVEL_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CARIBOU_TYPE_LEVEL_MODEL, CaribouLevelModel))
#define CARIBOU_LEVEL_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CARIBOU_TYPE_LEVEL_MODEL, CaribouLevelModelClass))
#define CARIBOU_IS_LEVEL_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CARIBOU_TYPE_LEVEL_MODEL))
#define CARIBOU_IS_LEVEL_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CARIBOU_TYPE_LEVEL_MODEL))
#define CARIBOU_LEVEL_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CARIBOU_TYPE_LEVEL_MODEL, CaribouLevelModelClass))

typedef struct _CaribouLevelModel CaribouLevelModel;
typedef struct _CaribouLevelModelClass CaribouLevelModelClass;
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define CARIBOU_TYPE_KEY_MODEL (caribou_key_model_get_type ())
#define CARIBOU_KEY_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CARIBOU_TYPE_KEY_MODEL, CaribouKeyModel))
#define CARIBOU_KEY_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CARIBOU_TYPE_KEY_MODEL, CaribouKeyModelClass))
#define CARIBOU_IS_KEY_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CARIBOU_TYPE_KEY_MODEL))
#define CARIBOU_IS_KEY_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CARIBOU_TYPE_KEY_MODEL))
#define CARIBOU_KEY_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CARIBOU_TYPE_KEY_MODEL, CaribouKeyModelClass))

typedef struct _CaribouKeyModel CaribouKeyModel;
typedef struct _CaribouKeyModelClass CaribouKeyModelClass;

struct _CaribouJsonDeserializer {
	GObject parent_instance;
	CaribouJsonDeserializerPrivate * priv;
};

struct _CaribouJsonDeserializerClass {
	GObjectClass parent_class;
};


static gpointer caribou_json_deserializer_parent_class = NULL;

GType caribou_json_deserializer_get_type (void) G_GNUC_CONST;
enum  {
	CARIBOU_JSON_DESERIALIZER_DUMMY_PROPERTY
};
gboolean caribou_json_deserializer_get_layout_file_inner (const gchar* data_dir, const gchar* group, const gchar* variant, GFile** fp);
GFile* caribou_json_deserializer_get_layout_file (const gchar* keyboard_type, const gchar* group, const gchar* variant, GError** error);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
GType caribou_group_model_get_type (void) G_GNUC_CONST;
CaribouGroupModel* caribou_json_deserializer_load_group (const gchar* keyboard_type, const gchar* group, const gchar* variant);
CaribouGroupModel* caribou_group_model_new (const gchar* group, const gchar* variant);
CaribouGroupModel* caribou_group_model_construct (GType object_type, const gchar* group, const gchar* variant);
void caribou_json_deserializer_create_levels_from_json (CaribouGroupModel* group, JsonNode* root);
CaribouLevelModel* caribou_level_model_new (const gchar* mode);
CaribouLevelModel* caribou_level_model_construct (GType object_type, const gchar* mode);
GType caribou_scannable_group_get_type (void) G_GNUC_CONST;
GType caribou_level_model_get_type (void) G_GNUC_CONST;
void caribou_json_deserializer_load_rows (CaribouLevelModel* level, JsonArray* json_rows);
void caribou_group_model_add_level (CaribouGroupModel* self, const gchar* lname, CaribouLevelModel* level);
GType caribou_key_model_get_type (void) G_GNUC_CONST;
void caribou_level_model_add_key (CaribouLevelModel* self, gint rownum, gint colnum, CaribouKeyModel* key);
CaribouKeyModel* caribou_json_deserializer_load_key (JsonObject* json_key);
CaribouKeyModel* caribou_key_model_new (const gchar* name);
CaribouKeyModel* caribou_key_model_construct (GType object_type, const gchar* name);
void caribou_key_model_set_toggle (CaribouKeyModel* self, const gchar* value);
void caribou_key_model_set_margin_left (CaribouKeyModel* self, gdouble value);
void caribou_key_model_set_width (CaribouKeyModel* self, gdouble value);
void caribou_key_model_add_subkey (CaribouKeyModel* self, const gchar* name);
const gchar* caribou_key_model_get_name (CaribouKeyModel* self);
CaribouJsonDeserializer* caribou_json_deserializer_new (void);
CaribouJsonDeserializer* caribou_json_deserializer_construct (GType object_type);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gboolean caribou_json_deserializer_get_layout_file_inner (const gchar* data_dir, const gchar* group, const gchar* variant, GFile** fp) {
	GFile* _fp = NULL;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gchar** files;
	gint files_length1;
	gint _files_size_;
	g_return_val_if_fail (data_dir != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = string_to_string (group);
	_tmp1_ = string_to_string (variant);
	_tmp2_ = g_strconcat (_tmp0_, "_", _tmp1_, ".json", NULL);
	_tmp3_ = string_to_string (group);
	_tmp4_ = g_strconcat (_tmp3_, ".json", NULL);
	_tmp5_ = g_new0 (gchar*, 2 + 1);
	_tmp5_[0] = _tmp2_;
	_tmp5_[1] = _tmp4_;
	files = _tmp5_;
	files_length1 = 2;
	_files_size_ = 2;
	{
		gchar** fn_collection;
		int fn_collection_length1;
		int fn_it;
		fn_collection = files;
		fn_collection_length1 = files_length1;
		for (fn_it = 0; fn_it < files_length1; fn_it = fn_it + 1) {
			gchar* _tmp6_;
			gchar* fn;
			_tmp6_ = g_strdup (fn_collection[fn_it]);
			fn = _tmp6_;
			{
				gchar* _tmp7_ = NULL;
				gchar* layout_fn;
				GFile* _tmp8_ = NULL;
				gboolean _tmp9_;
				_tmp7_ = g_build_filename (data_dir, fn, NULL);
				layout_fn = _tmp7_;
				_tmp8_ = g_file_new_for_path (layout_fn);
				_g_object_unref0 (_fp);
				_fp = _tmp8_;
				_tmp9_ = g_file_query_exists (_fp, NULL);
				if (_tmp9_) {
					result = TRUE;
					_g_free0 (layout_fn);
					_g_free0 (fn);
					files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
					if (fp) {
						*fp = _fp;
					} else {
						_g_object_unref0 (_fp);
					}
					return result;
				}
				_g_free0 (layout_fn);
				_g_free0 (fn);
			}
		}
	}
	result = FALSE;
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
	if (fp) {
		*fp = _fp;
	} else {
		_g_object_unref0 (_fp);
	}
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


GFile* caribou_json_deserializer_get_layout_file (const gchar* keyboard_type, const gchar* group, const gchar* variant, GError** error) {
	GFile* result = NULL;
	GList* dirs;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* custom_dir;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_;
	gchar** _tmp6_ = NULL;
	GError* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (keyboard_type != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (variant != NULL, NULL);
	dirs = NULL;
	_tmp0_ = g_getenv ("CARIBOU_LAYOUTS_DIR");
	_tmp1_ = g_strdup (_tmp0_);
	custom_dir = _tmp1_;
	if (custom_dir != NULL) {
		gchar* _tmp2_ = NULL;
		_tmp2_ = g_build_filename (custom_dir, "layouts", keyboard_type, NULL);
		dirs = g_list_append (dirs, _tmp2_);
	}
	_tmp3_ = g_get_user_data_dir ();
	_tmp4_ = g_build_filename (_tmp3_, "caribou", "layouts", keyboard_type, NULL);
	dirs = g_list_append (dirs, _tmp4_);
	_tmp6_ = _tmp5_ = g_get_system_data_dirs ();
	{
		gchar** data_dir_collection;
		int data_dir_collection_length1;
		int data_dir_it;
		data_dir_collection = _tmp6_;
		data_dir_collection_length1 = _vala_array_length (_tmp5_);
		for (data_dir_it = 0; data_dir_it < _vala_array_length (_tmp5_); data_dir_it = data_dir_it + 1) {
			gchar* _tmp7_;
			gchar* data_dir;
			_tmp7_ = g_strdup (data_dir_collection[data_dir_it]);
			data_dir = _tmp7_;
			{
				gchar* _tmp8_ = NULL;
				_tmp8_ = g_build_filename (data_dir, "caribou", "layouts", keyboard_type, NULL);
				dirs = g_list_append (dirs, _tmp8_);
				_g_free0 (data_dir);
			}
		}
	}
	{
		GList* data_dir_collection;
		GList* data_dir_it;
		data_dir_collection = dirs;
		for (data_dir_it = data_dir_collection; data_dir_it != NULL; data_dir_it = data_dir_it->next) {
			gchar* _tmp9_;
			gchar* data_dir;
			_tmp9_ = g_strdup ((const gchar*) data_dir_it->data);
			data_dir = _tmp9_;
			{
				GFile* fp = NULL;
				GFile* _tmp10_ = NULL;
				gboolean _tmp11_;
				_tmp11_ = caribou_json_deserializer_get_layout_file_inner (data_dir, group, variant, &_tmp10_);
				_g_object_unref0 (fp);
				fp = _tmp10_;
				if (_tmp11_) {
					result = fp;
					_g_free0 (data_dir);
					_g_free0 (custom_dir);
					__g_list_free__g_free0_0 (dirs);
					return result;
				}
				_g_object_unref0 (fp);
				_g_free0 (data_dir);
			}
		}
	}
	_tmp12_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "Could not find layout file for %s %s", group, variant);
	_inner_error_ = _tmp12_;
	if (_inner_error_->domain == G_IO_ERROR) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (custom_dir);
		__g_list_free__g_free0_0 (dirs);
		return NULL;
	} else {
		_g_free0 (custom_dir);
		__g_list_free__g_free0_0 (dirs);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (custom_dir);
	__g_list_free__g_free0_0 (dirs);
}


CaribouGroupModel* caribou_json_deserializer_load_group (const gchar* keyboard_type, const gchar* group, const gchar* variant) {
	CaribouGroupModel* result = NULL;
	JsonParser* _tmp0_ = NULL;
	JsonParser* parser;
	GFile* _tmp1_ = NULL;
	GFile* f;
	GFileInputStream* _tmp2_ = NULL;
	GFileInputStream* _tmp3_;
	GFileInputStream* _tmp4_;
	CaribouGroupModel* _tmp5_ = NULL;
	CaribouGroupModel* grp;
	JsonNode* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (keyboard_type != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (variant != NULL, NULL);
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	_tmp1_ = caribou_json_deserializer_get_layout_file (keyboard_type, group, variant, &_inner_error_);
	f = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	_tmp2_ = g_file_read (f, NULL, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (f);
		goto __catch1_g_error;
	}
	_tmp4_ = _tmp3_;
	json_parser_load_from_stream (parser, (GInputStream*) _tmp4_, G_CANCELLABLE (NULL), &_inner_error_);
	_g_object_unref0 (_tmp4_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (f);
		goto __catch1_g_error;
	}
	_g_object_unref0 (f);
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stdout, "Failed to load JSON: %s\n", e->message);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp5_ = caribou_group_model_new (group, variant);
	grp = _tmp5_;
	_tmp6_ = json_parser_get_root (parser);
	caribou_json_deserializer_create_levels_from_json (grp, _tmp6_);
	result = grp;
	_g_object_unref0 (parser);
	return result;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


void caribou_json_deserializer_create_levels_from_json (CaribouGroupModel* group, JsonNode* root) {
	JsonObject* _tmp0_ = NULL;
	JsonObject* _tmp1_;
	JsonObject* obj;
	JsonNodeType _tmp2_;
	GList* _tmp3_ = NULL;
	g_return_if_fail (group != NULL);
	g_return_if_fail (root != NULL);
	_tmp0_ = json_node_get_object (root);
	_tmp1_ = _json_object_ref0 (_tmp0_);
	obj = _tmp1_;
	_tmp2_ = json_node_get_node_type (root);
	if (_tmp2_ != JSON_NODE_OBJECT) {
		_json_object_unref0 (obj);
		return;
	}
	_tmp3_ = json_object_get_members (obj);
	{
		GList* levelname_collection;
		GList* levelname_it;
		levelname_collection = _tmp3_;
		for (levelname_it = levelname_collection; levelname_it != NULL; levelname_it = levelname_it->next) {
			gchar* _tmp4_;
			gchar* levelname;
			_tmp4_ = g_strdup ((const gchar*) levelname_it->data);
			levelname = _tmp4_;
			{
				JsonObject* _tmp5_ = NULL;
				JsonObject* json_level;
				gchar* _tmp6_;
				gchar* mode;
				gboolean _tmp7_;
				JsonArray* _tmp10_ = NULL;
				JsonArray* _tmp11_;
				JsonArray* json_rows;
				CaribouLevelModel* _tmp12_ = NULL;
				CaribouLevelModel* level;
				_tmp5_ = json_object_get_object_member (obj, levelname);
				json_level = _tmp5_;
				_tmp6_ = g_strdup ("");
				mode = _tmp6_;
				_tmp7_ = json_object_has_member (json_level, "mode");
				if (_tmp7_) {
					const gchar* _tmp8_ = NULL;
					gchar* _tmp9_;
					_tmp8_ = json_object_get_string_member (json_level, "mode");
					_tmp9_ = g_strdup (_tmp8_);
					_g_free0 (mode);
					mode = _tmp9_;
				}
				_tmp10_ = json_object_get_array_member (json_level, "rows");
				_tmp11_ = _json_array_ref0 (_tmp10_);
				json_rows = _tmp11_;
				_tmp12_ = caribou_level_model_new (mode);
				level = _tmp12_;
				caribou_json_deserializer_load_rows (level, json_rows);
				caribou_group_model_add_level (group, levelname, level);
				_g_object_unref0 (level);
				_json_array_unref0 (json_rows);
				_g_free0 (mode);
				_g_free0 (levelname);
			}
		}
		_g_list_free0 (levelname_collection);
	}
	_json_object_unref0 (obj);
}


void caribou_json_deserializer_load_rows (CaribouLevelModel* level, JsonArray* json_rows) {
	g_return_if_fail (level != NULL);
	g_return_if_fail (json_rows != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp1_;
				JsonArray* _tmp2_ = NULL;
				JsonArray* _tmp3_;
				JsonArray* json_children;
				JsonNode* _tmp4_ = NULL;
				JsonNode* child;
				JsonNodeType _tmp5_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				_tmp1_ = json_array_get_length (json_rows);
				if (!(i < _tmp1_)) {
					break;
				}
				_tmp2_ = json_array_get_array_element (json_rows, (guint) i);
				_tmp3_ = _json_array_ref0 (_tmp2_);
				json_children = _tmp3_;
				_tmp4_ = json_array_get_element (json_children, (guint) 0);
				child = _tmp4_;
				_tmp5_ = json_node_get_node_type (child);
				if (_tmp5_ == JSON_NODE_OBJECT) {
					{
						gint j;
						j = 0;
						{
							gboolean _tmp6_;
							_tmp6_ = TRUE;
							while (TRUE) {
								guint _tmp7_;
								JsonObject* _tmp8_ = NULL;
								JsonObject* _tmp9_;
								JsonObject* json_key;
								CaribouKeyModel* _tmp10_ = NULL;
								CaribouKeyModel* _tmp11_;
								if (!_tmp6_) {
									j++;
								}
								_tmp6_ = FALSE;
								_tmp7_ = json_array_get_length (json_children);
								if (!(j < _tmp7_)) {
									break;
								}
								_tmp8_ = json_array_get_object_element (json_children, (guint) j);
								_tmp9_ = _json_object_ref0 (_tmp8_);
								json_key = _tmp9_;
								_tmp10_ = caribou_json_deserializer_load_key (json_key);
								_tmp11_ = _tmp10_;
								caribou_level_model_add_key (level, i, 0, _tmp11_);
								_g_object_unref0 (_tmp11_);
								_json_object_unref0 (json_key);
							}
						}
					}
				} else {
					JsonNodeType _tmp12_;
					_tmp12_ = json_node_get_node_type (child);
					if (_tmp12_ == JSON_NODE_ARRAY) {
						{
							gint k;
							k = 0;
							{
								gboolean _tmp13_;
								_tmp13_ = TRUE;
								while (TRUE) {
									guint _tmp14_;
									JsonArray* _tmp15_ = NULL;
									JsonArray* _tmp16_;
									JsonArray* json_keys;
									if (!_tmp13_) {
										k++;
									}
									_tmp13_ = FALSE;
									_tmp14_ = json_array_get_length (json_children);
									if (!(k < _tmp14_)) {
										break;
									}
									_tmp15_ = json_array_get_array_element (json_children, (guint) k);
									_tmp16_ = _json_array_ref0 (_tmp15_);
									json_keys = _tmp16_;
									{
										gint j;
										j = 0;
										{
											gboolean _tmp17_;
											_tmp17_ = TRUE;
											while (TRUE) {
												guint _tmp18_;
												JsonObject* _tmp19_ = NULL;
												JsonObject* _tmp20_;
												JsonObject* json_key;
												CaribouKeyModel* _tmp21_ = NULL;
												CaribouKeyModel* _tmp22_;
												if (!_tmp17_) {
													j++;
												}
												_tmp17_ = FALSE;
												_tmp18_ = json_array_get_length (json_keys);
												if (!(j < _tmp18_)) {
													break;
												}
												_tmp19_ = json_array_get_object_element (json_keys, (guint) j);
												_tmp20_ = _json_object_ref0 (_tmp19_);
												json_key = _tmp20_;
												_tmp21_ = caribou_json_deserializer_load_key (json_key);
												_tmp22_ = _tmp21_;
												caribou_level_model_add_key (level, i, k, _tmp22_);
												_g_object_unref0 (_tmp22_);
												_json_object_unref0 (json_key);
											}
										}
									}
									_json_array_unref0 (json_keys);
								}
							}
						}
					}
				}
				_json_array_unref0 (json_children);
			}
		}
	}
}


CaribouKeyModel* caribou_json_deserializer_load_key (JsonObject* json_key) {
	CaribouKeyModel* result = NULL;
	const gchar* _tmp0_ = NULL;
	CaribouKeyModel* _tmp1_ = NULL;
	CaribouKeyModel* key;
	gboolean _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp6_;
	gboolean _tmp8_;
	g_return_val_if_fail (json_key != NULL, NULL);
	_tmp0_ = json_object_get_string_member (json_key, "name");
	_tmp1_ = caribou_key_model_new (_tmp0_);
	key = _tmp1_;
	_tmp2_ = json_object_has_member (json_key, "toggle");
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = json_object_get_string_member (json_key, "toggle");
		caribou_key_model_set_toggle (key, _tmp3_);
	}
	_tmp4_ = json_object_has_member (json_key, "margin_left");
	if (_tmp4_) {
		gdouble _tmp5_;
		_tmp5_ = json_object_get_double_member (json_key, "margin_left");
		caribou_key_model_set_margin_left (key, _tmp5_);
	}
	_tmp6_ = json_object_has_member (json_key, "width");
	if (_tmp6_) {
		gdouble _tmp7_;
		_tmp7_ = json_object_get_double_member (json_key, "width");
		caribou_key_model_set_width (key, _tmp7_);
	}
	_tmp8_ = json_object_has_member (json_key, "extended_names");
	if (_tmp8_) {
		JsonArray* _tmp9_ = NULL;
		JsonArray* _tmp10_;
		JsonArray* json_keys;
		guint _tmp11_;
		guint nkeys;
		guint i = 0U;
		const gchar* _tmp12_ = NULL;
		_tmp9_ = json_object_get_array_member (json_key, "extended_names");
		_tmp10_ = _json_array_ref0 (_tmp9_);
		json_keys = _tmp10_;
		_tmp11_ = json_array_get_length (json_keys);
		nkeys = _tmp11_;
		_tmp12_ = caribou_key_model_get_name (key);
		caribou_key_model_add_subkey (key, _tmp12_);
		{
			gboolean _tmp13_;
			i = (guint) 0;
			_tmp13_ = TRUE;
			while (TRUE) {
				const gchar* _tmp14_ = NULL;
				if (!_tmp13_) {
					i++;
				}
				_tmp13_ = FALSE;
				if (!(i < nkeys)) {
					break;
				}
				_tmp14_ = json_array_get_string_element (json_keys, i);
				caribou_key_model_add_subkey (key, _tmp14_);
			}
		}
		_json_array_unref0 (json_keys);
	}
	result = key;
	return result;
}


CaribouJsonDeserializer* caribou_json_deserializer_construct (GType object_type) {
	CaribouJsonDeserializer * self = NULL;
	self = (CaribouJsonDeserializer*) g_object_new (object_type, NULL);
	return self;
}


CaribouJsonDeserializer* caribou_json_deserializer_new (void) {
	return caribou_json_deserializer_construct (CARIBOU_TYPE_JSON_DESERIALIZER);
}


static void caribou_json_deserializer_class_init (CaribouJsonDeserializerClass * klass) {
	caribou_json_deserializer_parent_class = g_type_class_peek_parent (klass);
}


static void caribou_json_deserializer_instance_init (CaribouJsonDeserializer * self) {
}


GType caribou_json_deserializer_get_type (void) {
	static volatile gsize caribou_json_deserializer_type_id__volatile = 0;
	if (g_once_init_enter (&caribou_json_deserializer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaribouJsonDeserializerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) caribou_json_deserializer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaribouJsonDeserializer), 0, (GInstanceInitFunc) caribou_json_deserializer_instance_init, NULL };
		GType caribou_json_deserializer_type_id;
		caribou_json_deserializer_type_id = g_type_register_static (G_TYPE_OBJECT, "CaribouJsonDeserializer", &g_define_type_info, 0);
		g_once_init_leave (&caribou_json_deserializer_type_id__volatile, caribou_json_deserializer_type_id);
	}
	return caribou_json_deserializer_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



