// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_MEDIA_H
#define _CLUTTERMM_MEDIA_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/interface.h>
#include <glibmm/ustring.h>
#include <clutter/clutter-media.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterMedia ClutterMedia;
typedef struct _ClutterMediaClass ClutterMediaClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Media_Class; } // namespace Clutter
namespace Clutter
{


class Media : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Media CppObjectType;
  typedef Media_Class CppClassType;
  typedef ClutterMedia BaseObjectType;
  typedef ClutterMediaInterface BaseClassType;

private:
  friend class Media_Class;
  static CppClassType media_class_;

  // noncopyable
  Media(const Media&);
  Media& operator=(const Media&);

protected:
  Media(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit Media(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit Media(ClutterMedia* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Media();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterMedia*       gobj()       { return reinterpret_cast<ClutterMedia*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const ClutterMedia* gobj() const { return reinterpret_cast<ClutterMedia*>(gobject_); }

private:


public:

  
  /** Sets the uri of @a media to @a uri.
   * @param uri Uri.
   */
  void set_uri(const Glib::ustring& uri);
  
  /** Retrieves the URI from @a media.
   * @return The URI as a string.
   */
  Glib::ustring get_uri() const;
  
  /** Starts or stops @a media playing.
   * @param playing <tt>true</tt> to start playing, <tt>false</tt> to stop.
   */
  void set_playing(bool playing=true);
  
  /** Retrieves the state of @a media.
   * @return <tt>true</tt> if playing, <tt>false</tt> if stopped.
   */
  bool get_playing() const;
  
  /** Sets the playback position of @a media to @a position.
   * @param position The desired position.
   */
  void set_position(int position);
  
  /** Retrieves the position of @a media.
   * @return The playback position.
   */
  int get_position() const;
  
  /** Sets the playback volume of @a media to @a volume.
   * @param volume The volume as a double between 0.0 and 1.0.
   */
  void set_volume(double volume);
  
  /** Retrieves the playback volume of @a media.
   * @return The playback volume between 0.0 and 1.0.
   */
  double get_volume() const;
  
  /** Retrieves the amount of the stream that is buffered.
   * @return Percentage value.
   */
  int get_buffer_percent() const;
  
  /** Sets the filename of the media source.
   * @param filename A filename to media file.
   */
  void set_filename(const Glib::ustring& filename);
  
  /** Retrieves whether @a media is seekable or not.
   * @return <tt>true</tt> if @a media can seek, <tt>false</tt> otherwise.
   */
  bool get_can_seek() const;
  
  /** Retrieves the duration of the media stream that @a media represents.
   * @return The length of the media stream.
   */
  int get_duration() const;


  // TODO: these aren't in the signals.defs file yet
  //_WRAP_SIGNAL(void eos(), "eos")
  // TODO: figure out what to do with this GError parameter
  //_WRAP_SIGNAL(void error(GError* error), "error")

protected:

 
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_uri_vfunc(const Glib::ustring& uri);
#endif //GLIBMM_VFUNCS_ENABLED


  // TODO: error "No conversion from Glib::ustring to const char* defined", even
  // though it works above in get_uri
  //_WRAP_VFUNC(Glib::ustring get_uri() const, get_uri)
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_playing_vfunc(bool playing);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool get_playing_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_position_vfunc(int position);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual int get_position_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_volume_vfunc(double volume);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual double get_volume_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool can_seek_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual int get_buffer_percent_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual int get_duration_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter
//vim: ts=2,sw=2


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Media
   */
  Glib::RefPtr<Clutter::Media> wrap(ClutterMedia* object, bool take_copy = false);

} // namespace Glib


#endif /* _CLUTTERMM_MEDIA_H */

