// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_SCORE_H
#define _CLUTTERMM_SCORE_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/timeline.h>
#include <clutter/clutter.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterScore ClutterScore;
typedef struct _ClutterScoreClass ClutterScoreClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Score_Class; } // namespace Clutter
namespace Clutter
{


class Score : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Score CppObjectType;
  typedef Score_Class CppClassType;
  typedef ClutterScore BaseObjectType;
  typedef ClutterScoreClass BaseClassType;

private:  friend class Score_Class;
  static CppClassType score_class_;

private:
  // noncopyable
  Score(const Score&);
  Score& operator=(const Score&);

protected:
  explicit Score(const Glib::ConstructParams& construct_params);
  explicit Score(ClutterScore* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Score();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterScore*       gobj()       { return reinterpret_cast<ClutterScore*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterScore* gobj() const { return reinterpret_cast<ClutterScore*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterScore* gobj_copy();

private:


protected:
  Score();

public:
  
  static Glib::RefPtr<Score> create();


  void set_loop(bool loop = true);
  
  bool get_loop() const;

  
  gulong append(const Glib::RefPtr<Timeline>& parent, const Glib::RefPtr<Timeline>& timeline);

  /** Appends a timeline to another one existing in the score. The new timeline
   * will be started when start() is called.
   *
   * @param timeline the Timeline to append
   * @return the id of the newly added timeline, to be used with get_timeline() and remove().
   */
  gulong append(const Glib::RefPtr<Timeline>& timeline);

  
  void append_at_marker(const Glib::RefPtr<Timeline>& parent, const Glib::ustring& marker_name, const Glib::RefPtr<Timeline>& timeline);

  
  void remove(gulong id);
  
  void remove_all();

  
  Glib::RefPtr<Timeline> get_timeline(gulong id);
  
  Glib::RefPtr<const Timeline> get_timeline(gulong id) const;

 
  Glib::SListHandle<Glib::RefPtr<Timeline> > list_timelines();
  
  Glib::SListHandle<Glib::RefPtr<const Timeline> > list_timelines() const;

  
  void start();
  
  void pause();
  
  void stop();
  
  void rewind();
  
  bool is_playing() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the score should restart once finished.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_loop() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the score should restart once finished.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_loop() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /**
   * @par Prototype:
   * <tt>void on_my_%completed()</tt>
   */

  Glib::SignalProxy0< void > signal_completed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%paused()</tt>
   */

  Glib::SignalProxy0< void > signal_paused();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%started()</tt>
   */

  Glib::SignalProxy0< void > signal_started();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%timeline_completed(const Glib::RefPtr<Timeline>& timeline)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Timeline>& > signal_timeline_completed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%timeline_started(const Glib::RefPtr<Timeline>& timeline)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Timeline>& > signal_timeline_started();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_completed();
  virtual void on_paused();
  virtual void on_started();
  virtual void on_timeline_completed(const Glib::RefPtr<Timeline>& timeline);
  virtual void on_timeline_started(const Glib::RefPtr<Timeline>& timeline);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Score
   */
  Glib::RefPtr<Clutter::Score> wrap(ClutterScore* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_SCORE_H */

