// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_TIMELINE_H
#define _CLUTTERMM_TIMELINE_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/types.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterTimeline ClutterTimeline;
typedef struct _ClutterTimelineClass ClutterTimelineClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Timeline_Class; } // namespace Clutter
namespace Clutter
{

/** @addtogroup cluttermmEnums Enums and Flags */

/**
 * @ingroup cluttermmEnums
 */
enum TimelineDirection
{
  TIMELINE_FORWARD,
  TIMELINE_BACKWARD
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::TimelineDirection> : public Glib::Value_Enum<Clutter::TimelineDirection>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class Timeline : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Timeline CppObjectType;
  typedef Timeline_Class CppClassType;
  typedef ClutterTimeline BaseObjectType;
  typedef ClutterTimelineClass BaseClassType;

private:  friend class Timeline_Class;
  static CppClassType timeline_class_;

private:
  // noncopyable
  Timeline(const Timeline&);
  Timeline& operator=(const Timeline&);

protected:
  explicit Timeline(const Glib::ConstructParams& construct_params);
  explicit Timeline(ClutterTimeline* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Timeline();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterTimeline*       gobj()       { return reinterpret_cast<ClutterTimeline*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterTimeline* gobj() const { return reinterpret_cast<ClutterTimeline*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterTimeline* gobj_copy();

private:


protected:
  explicit Timeline(guint num_frames, guint fps);
  explicit Timeline(guint duration);
public:
  
  static Glib::RefPtr<Timeline> create(guint n_frames, guint fps);

  
  static Glib::RefPtr<Timeline> create(guint msecs);

  
  //We don't wrap this as a copy constructor because there is 
  //no way to use copy constructors with RefPtr:
  
  Glib::RefPtr<Timeline> clone() const;

  
  void set_duration(guint msecs);
  
  /** Retrieves the duration of a Clutter::Timeline in milliseconds.
   * See set_duration().
   * @return The duration of the timeline, in milliseconds.
   * 
   * Since: 0.6.
   */
  guint get_duration() const;
  
  void set_speed(guint fps);
  
  guint get_speed() const;
  
  void start();
  
  void pause();
  
  void stop();
  
  void rewind();
  
  void set_loop(bool loop = true);
  
  bool get_loop() const;
  
  void skip(guint n_frames);
  
  void advance(guint frame_num);
  
  int get_current_frame() const;
  
  guint get_delta(guint& msecs) const;
  guint get_delta() const;
  
  void set_n_frames(guint n_frames);
  
  guint get_n_frames() const;
  
  bool is_playing() const;
  
  void set_delay(guint msecs);
  
  guint get_delay() const;
  
  double get_progress() const;
  
  Cogl::Fixed get_progressx() const;
  
  void set_direction(TimelineDirection direction);
  
  TimelineDirection get_direction() const;

  
  Glib::StringArrayHandle list_markers(gint frame_num) const;
  
  void add_marker_at_time(const Glib::ustring& marker_name, guint msecs);
  
  void add_marker_at_frame(const Glib::ustring& marker_name, guint frame_num);
  
  bool has_marker(const Glib::ustring& marker_name);
  
  void remove_marker(const Glib::ustring& marker_name);
  
  void advance_to_marker(const Glib::ustring& marker_name);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Delay before start.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_delay() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Delay before start.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_delay() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Direction of the timeline.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<TimelineDirection> property_direction() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Direction of the timeline.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<TimelineDirection> property_direction() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Duration of the timeline in milliseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_duration() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Duration of the timeline in milliseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_duration() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Frames per second.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_fps() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Frames per second.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_fps() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Should the timeline automatically restart.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_loop() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Should the timeline automatically restart.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_loop() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Total number of frames.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_num_frames() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Total number of frames.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_num_frames() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /**
   * @par Prototype:
   * <tt>void on_my_%completed()</tt>
   */

  Glib::SignalProxy0< void > signal_completed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%new_frame(gint fram_num)</tt>
   */

  Glib::SignalProxy1< void,gint > signal_new_frame();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%paused()</tt>
   */

  Glib::SignalProxy0< void > signal_paused();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%started()</tt>
   */

  Glib::SignalProxy0< void > signal_started();


  // TODO: This signal is detailed, though I don't think we can wrap the
  // detail in Glibmm yet. armin.
 

  /**
   * @par Prototype:
   * <tt>void on_my_%marker_reached(const Glib::ustring& marker_name, int frame_num)</tt>
   */

  Glib::SignalProxy2< void,const Glib::ustring&,int > signal_marker_reached();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_completed();
  virtual void on_new_frame(gint fram_num);
  virtual void on_paused();
  virtual void on_started();
  virtual void on_marker_reached(const Glib::ustring& marker_name, int frame_num);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Timeline
   */
  Glib::RefPtr<Clutter::Timeline> wrap(ClutterTimeline* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_TIMELINE_H */

