// Generated by gtkmmproc -- DO NOT MODIFY!


#include <cluttermm/actor.h>
#include <cluttermm/private/actor_p.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <clutter/clutter.h>
#include <iterator>

namespace Clutter
{

ActorBox::ActorBox(float x1, float y1, float x2, float y2)
{
  gobject_.x1 = x1;
  gobject_.y1 = y1;
  gobject_.x2 = x2;
  gobject_.y2 = y2;
}

bool Actor::is_mapped() const
{
  return (CLUTTER_ACTOR_IS_MAPPED(gobj()) != 0);
}

bool Actor::is_realized() const
{
  return (CLUTTER_ACTOR_IS_REALIZED(gobj()) != 0);
}

bool Actor::is_visible() const
{
  return CLUTTER_ACTOR_IS_VISIBLE(gobj());
}

bool Actor::is_reactive() const
{
  return (CLUTTER_ACTOR_IS_REACTIVE(gobj()) != 0);
}

Geometry Actor::get_geometry() const
{
  Geometry geom;
  clutter_actor_get_geometry(const_cast<ClutterActor*>(gobj()), geom.gobj());
  return geom;
}

#if 0
ActorBox Actor::get_paint_area() const
{
  ActorBox box;
  clutter_actor_get_paint_area(const_cast<ClutterActor*>(gobj()), box.gobj());
  return box;
}
#endif

void Actor::get_abs_allocation_vertices(Vertex vertices[4]) const
{
  clutter_actor_get_abs_allocation_vertices(const_cast<ClutterActor*>(gobj()), reinterpret_cast<ClutterVertex*>(vertices));
}

void Actor::get_allocation_vertices(Vertex vertices[4]) const
{
  clutter_actor_get_allocation_vertices(const_cast<ClutterActor*>(gobj()), NULL, reinterpret_cast<ClutterVertex*>(vertices));
}

void Actor::get_allocation_vertices(const Glib::RefPtr<Actor>& ancestor, Vertex vertices[4]) const
{
  clutter_actor_get_allocation_vertices(const_cast<ClutterActor*>(gobj()), Glib::unwrap(ancestor), reinterpret_cast<ClutterVertex*>(vertices));
}

ActorBox Actor::get_allocation_box() const
{
  ActorBox box;
  clutter_actor_get_allocation_box(const_cast<ClutterActor*>(gobj()), box.gobj());
  return box;
}

void Actor::apply_relative_transform_to_point(const Vertex& point, Vertex& vertex) const
{
  clutter_actor_apply_relative_transform_to_point(const_cast<ClutterActor*>(gobj()), NULL, const_cast<ClutterVertex*>(point.gobj()), vertex.gobj());
}

Geometry Actor::get_allocation_geometry() const
{
  Geometry geom;
  clutter_actor_get_allocation_geometry(const_cast<ClutterActor*>(gobj()), geom.gobj());
  return geom;
}

Glib::RefPtr<Animation>
Actor::animate(gulong mode, guint duration, const std::map<std::string, Glib::ValueBase>& properties)
{
  gchar* c_properties[properties.size()];
  GValue values[properties.size()];

  for(std::map<std::string, Glib::ValueBase>::const_iterator iter = properties.begin(); iter != properties.end(); ++iter)
  {
    c_properties[std::distance(properties.begin(), iter)] = g_strdup(iter->first.c_str());
    g_value_copy(iter->second.gobj(), &values[std::distance(properties.begin(), iter)]);
  }

  return Glib::wrap(clutter_actor_animatev(gobj(), mode, duration, properties.size(), c_properties, values));
}

Glib::RefPtr<Animation>
Actor::animate(gulong mode, const Glib::RefPtr<Timeline>& timeline, const std::map<std::string, Glib::ValueBase>& properties)
{
  gchar* c_properties[properties.size()];
  GValue values[properties.size()];

  for(std::map<std::string, Glib::ValueBase>::const_iterator iter = properties.begin(); iter != properties.end(); ++iter)
  {
    c_properties[std::distance(properties.begin(), iter)] = g_strdup(iter->first.c_str());
    g_value_copy(iter->second.gobj(), &values[std::distance(properties.begin(), iter)]);
  }

  return Glib::wrap(clutter_actor_animate_with_timelinev(gobj(), mode, timeline->gobj(), properties.size(), c_properties, values));
}

Glib::RefPtr<Animation>
Actor::animate(const Glib::RefPtr<Alpha>& alpha, const std::map<std::string, Glib::ValueBase>& properties)
{
  gchar* c_properties[properties.size()];
  GValue values[properties.size()];

  for(std::map<std::string, Glib::ValueBase>::const_iterator iter = properties.begin(); iter != properties.end(); ++iter)
  {
    c_properties[std::distance(properties.begin(), iter)] = g_strdup(iter->first.c_str());
    g_value_copy(iter->second.gobj(), &values[std::distance(properties.begin(), iter)]);
  }

  return Glib::wrap(clutter_actor_animate_with_alphav(gobj(), alpha->gobj(), properties.size(), c_properties, values));
}

#if 0
// We need to hand-code this vfunc to write the result back into the
// box variable. The C++ wrapper cannot ref the existing variable, but only
// make a copy.
void Actor_Class::get_paint_area_vfunc_callback(ClutterActor* self, ClutterActorBox* box)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      // Call the virtual member method, which derived classes might override.
      ActorBox cpp_box;
      obj->get_paint_area_vfunc(cpp_box);
      *box = *cpp_box.gobj();
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

    // Call the original underlying C function:
    if(base && base->get_paint_area)
      (*base->get_paint_area)(self, box);
  }
}

void Actor::get_paint_area_vfunc(ActorBox& box) const
{
  //Call the default C implementation:

  BaseClassType *const base = static_cast<BaseClassType*>(
    g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
      g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
    )
  );

  if(base && base->get_paint_area)
    (*base->get_paint_area)(const_cast<ClutterActor*>(gobj()), box.gobj());
}
#endif

} //namespace Clutter


namespace
{


static gboolean Actor_signal_button_press_event_callback(ClutterActor* self, ClutterButtonEvent* p0,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< bool,ButtonEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0
));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Actor_signal_button_press_event_notify_callback(ClutterActor* self, ClutterButtonEvent* p0, void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,ButtonEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Actor_signal_button_press_event_info =
{
  "button_press_event",
  (GCallback) &Actor_signal_button_press_event_callback,
  (GCallback) &Actor_signal_button_press_event_notify_callback
};


static gboolean Actor_signal_button_release_event_callback(ClutterActor* self, ClutterButtonEvent* p0,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< bool,ButtonEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0
));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Actor_signal_button_release_event_notify_callback(ClutterActor* self, ClutterButtonEvent* p0, void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,ButtonEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Actor_signal_button_release_event_info =
{
  "button_release_event",
  (GCallback) &Actor_signal_button_release_event_callback,
  (GCallback) &Actor_signal_button_release_event_notify_callback
};


static gboolean Actor_signal_motion_event_callback(ClutterActor* self, ClutterMotionEvent* p0,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< bool,MotionEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0
));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Actor_signal_motion_event_notify_callback(ClutterActor* self, ClutterMotionEvent* p0, void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,MotionEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Actor_signal_motion_event_info =
{
  "motion_event",
  (GCallback) &Actor_signal_motion_event_callback,
  (GCallback) &Actor_signal_motion_event_notify_callback
};


static gboolean Actor_signal_leave_event_callback(ClutterActor* self, ClutterCrossingEvent* p0,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< bool,CrossingEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0
));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Actor_signal_leave_event_notify_callback(ClutterActor* self, ClutterCrossingEvent* p0, void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,CrossingEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Actor_signal_leave_event_info =
{
  "leave_event",
  (GCallback) &Actor_signal_leave_event_callback,
  (GCallback) &Actor_signal_leave_event_notify_callback
};


static const Glib::SignalProxyInfo Actor_signal_show_info =
{
  "show",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Actor_signal_hide_info =
{
  "hide",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Actor_signal_destroy_info =
{
  "destroy",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static gboolean Actor_signal_key_release_event_callback(ClutterActor* self, ClutterKeyEvent* p0,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< bool,KeyEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0
));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Actor_signal_key_release_event_notify_callback(ClutterActor* self, ClutterKeyEvent* p0, void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,KeyEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Actor_signal_key_release_event_info =
{
  "key_release_event",
  (GCallback) &Actor_signal_key_release_event_callback,
  (GCallback) &Actor_signal_key_release_event_notify_callback
};


static gboolean Actor_signal_enter_event_callback(ClutterActor* self, ClutterCrossingEvent* p0,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< bool,CrossingEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0
));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Actor_signal_enter_event_notify_callback(ClutterActor* self, ClutterCrossingEvent* p0, void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,CrossingEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Actor_signal_enter_event_info =
{
  "enter_event",
  (GCallback) &Actor_signal_enter_event_callback,
  (GCallback) &Actor_signal_enter_event_notify_callback
};


static gboolean Actor_signal_event_callback(ClutterActor* self, ClutterEvent* p0,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< bool,Event* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0
));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Actor_signal_event_notify_callback(ClutterActor* self, ClutterEvent* p0, void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,Event* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Actor_signal_event_info =
{
  "event",
  (GCallback) &Actor_signal_event_callback,
  (GCallback) &Actor_signal_event_notify_callback
};


static const Glib::SignalProxyInfo Actor_signal_key_focus_out_info =
{
  "key-focus_out",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Actor_signal_key_focus_in_info =
{
  "key-focus_in",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Actor_signal_parent_set_callback(ClutterActor* self, ClutterActor* p0,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,const Glib::RefPtr<Actor>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap((p0),true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Actor_signal_parent_set_info =
{
  "parent_set",
  (GCallback) &Actor_signal_parent_set_callback,
  (GCallback) &Actor_signal_parent_set_callback
};


static gboolean Actor_signal_scroll_event_callback(ClutterActor* self, ClutterScrollEvent* p0,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< bool,ScrollEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0
));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Actor_signal_scroll_event_notify_callback(ClutterActor* self, ClutterScrollEvent* p0, void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,ScrollEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Actor_signal_scroll_event_info =
{
  "scroll_event",
  (GCallback) &Actor_signal_scroll_event_callback,
  (GCallback) &Actor_signal_scroll_event_notify_callback
};


static gboolean Actor_signal_key_press_event_callback(ClutterActor* self, ClutterKeyEvent* p0,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< bool,KeyEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0
));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Actor_signal_key_press_event_notify_callback(ClutterActor* self, ClutterKeyEvent* p0, void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,KeyEvent* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Actor_signal_key_press_event_info =
{
  "key_press_event",
  (GCallback) &Actor_signal_key_press_event_callback,
  (GCallback) &Actor_signal_key_press_event_notify_callback
};


static gboolean Actor_signal_captured_event_callback(ClutterActor* self, ClutterEvent* p0,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< bool,Event* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0
));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static gboolean Actor_signal_captured_event_notify_callback(ClutterActor* self, ClutterEvent* p0, void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,Event* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo Actor_signal_captured_event_info =
{
  "captured_event",
  (GCallback) &Actor_signal_captured_event_callback,
  (GCallback) &Actor_signal_captured_event_notify_callback
};


static const Glib::SignalProxyInfo Actor_signal_paint_info =
{
  "paint",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Actor_signal_queue_redaw_callback(ClutterActor* self, ClutterActor* p0,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,const Glib::RefPtr<Actor>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap((p0),true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Actor_signal_queue_redaw_info =
{
  "queue_redraw",
  (GCallback) &Actor_signal_queue_redaw_callback,
  (GCallback) &Actor_signal_queue_redaw_callback
};


static const Glib::SignalProxyInfo Actor_signal_queue_relayout_info =
{
  "queue_relayout",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Actor_signal_realize_info =
{
  "realize",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Actor_signal_unrealize_info =
{
  "unrealize",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Actor_signal_pick_callback(ClutterActor* self, const ClutterColor* color,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,const Color& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Color(const_cast<ClutterColor*>(color), true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Actor_signal_pick_info =
{
  "pick",
  (GCallback) &Actor_signal_pick_callback,
  (GCallback) &Actor_signal_pick_callback
};


static void Actor_signal_allocation_changed_callback(ClutterActor* self, ClutterActorBox* p0,ClutterAllocationFlags p1,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,const ActorBox&,AllocationFlags > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(ActorBox(const_cast<ClutterActorBox*>(p0))
, ((AllocationFlags)(p1))
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Actor_signal_allocation_changed_info =
{
  "allocation-changed",
  (GCallback) &Actor_signal_allocation_changed_callback,
  (GCallback) &Actor_signal_allocation_changed_callback
};


} // anonymous namespace


namespace Glib
{

Clutter::ActorBox& wrap(ClutterActorBox* object)
{
  return *reinterpret_cast<Clutter::ActorBox*>(object);
}

const Clutter::ActorBox& wrap(const ClutterActorBox* object)
{
  return *reinterpret_cast<const Clutter::ActorBox*>(object);
}

} // namespace Glib


namespace Clutter
{


// static
GType ActorBox::get_type()
{
  return clutter_actor_box_get_type();
}

ActorBox::ActorBox()
{
  GLIBMM_INITIALIZE_STRUCT(gobject_, ClutterActorBox);
}

ActorBox::ActorBox(const ClutterActorBox* gobject)
{
  if(gobject)
    gobject_ = *gobject;
  else
    GLIBMM_INITIALIZE_STRUCT(gobject_, ClutterActorBox);
}


void ActorBox::get_origin(float& x, float& y) const
{
clutter_actor_box_get_origin(const_cast<ClutterActorBox*>(gobj()), &(x), &(y)); 
}

void ActorBox::get_size(float& width, float& height) const
{
clutter_actor_box_get_size(const_cast<ClutterActorBox*>(gobj()), &(width), &(height)); 
}

float ActorBox::get_area() const
{
  return clutter_actor_box_get_area(const_cast<ClutterActorBox*>(gobj()));
}

bool ActorBox::contains(float x, float y) const
{
  return clutter_actor_box_contains(const_cast<ClutterActorBox*>(gobj()), x, y);
}

void ActorBox::clamp_to_pixel()
{
clutter_actor_box_clamp_to_pixel(gobj()); 
}

 float ActorBox::get_x1() const
{
  return gobj()->x1;
}
 
 void ActorBox::set_x1(const float& value)
{
  gobj()->x1 = value;
}
 
 float ActorBox::get_y1() const
{
  return gobj()->y1;
}
 
 void ActorBox::set_y1(const float& value)
{
  gobj()->y1 = value;
}
 
 float ActorBox::get_x2() const
{
  return gobj()->x2;
}
 
 void ActorBox::set_x2(const float& value)
{
  gobj()->x2 = value;
}
 
 float ActorBox::get_y2() const
{
  return gobj()->y2;
}
 
 void ActorBox::set_y2(const float& value)
{
  gobj()->y2 = value;
}
 

} // namespace Clutter

// static
GType Glib::Value<Clutter::ActorFlags>::value_type()
{
  return clutter_actor_flags_get_type();
}

// static
GType Glib::Value<Clutter::AllocationFlags>::value_type()
{
  return clutter_allocation_flags_get_type();
}


namespace Glib
{

Glib::RefPtr<Clutter::Actor> wrap(ClutterActor* object, bool take_copy)
{
  return Glib::RefPtr<Clutter::Actor>( dynamic_cast<Clutter::Actor*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Clutter
{


/* The *_Class implementation: */

const Glib::Class& Actor_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Actor_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(clutter_actor_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Scriptable::add_interface(get_type());

  }

  return *this;
}


void Actor_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  klass->show_all = &show_all_vfunc_callback;
  klass->hide_all = &hide_all_vfunc_callback;
  klass->pick = &pick_vfunc_callback;
  klass->get_preferred_width = &get_preferred_width_vfunc_callback;
  klass->get_preferred_height = &get_preferred_height_vfunc_callback;
  klass->allocate = &allocate_vfunc_callback;

  klass->button_press_event = &button_press_event_callback;
  klass->button_release_event = &button_release_event_callback;
  klass->motion_event = &motion_event_callback;
  klass->leave_event = &leave_event_callback;
  klass->show = &show_callback;
  klass->hide = &hide_callback;
  klass->destroy = &destroy_callback;
  klass->key_release_event = &key_release_event_callback;
  klass->enter_event = &enter_event_callback;
  klass->event = &event_callback;
  klass->key_focus_out = &key_focus_out_callback;
  klass->key_focus_in = &key_focus_in_callback;
  klass->parent_set = &parent_set_callback;
  klass->scroll_event = &scroll_event_callback;
  klass->key_press_event = &key_press_event_callback;
  klass->captured_event = &captured_event_callback;
  klass->paint = &paint_callback;
  klass->queue_redraw = &queue_redraw_callback;
  klass->queue_relayout = &queue_relayout_callback;
  klass->realize = &realize_callback;
  klass->unrealize = &unrealize_callback;
  klass->pick = &pick_callback;
}

void Actor_Class::show_all_vfunc_callback(ClutterActor* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->show_all_vfunc();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->show_all)
    (*base->show_all)(self);

}
void Actor_Class::hide_all_vfunc_callback(ClutterActor* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->hide_all_vfunc();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->hide_all)
    (*base->hide_all)(self);

}
void Actor_Class::pick_vfunc_callback(ClutterActor* self, const ClutterColor* color)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->pick_vfunc(Color(const_cast<ClutterColor*>(color), true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->pick)
    (*base->pick)(self, color);

}
void Actor_Class::get_preferred_width_vfunc_callback(ClutterActor* self, float for_height, float* min_width_p, float* natural_width_p)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->get_preferred_width_vfunc(for_height, *(min_width_p)
, *(natural_width_p)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_preferred_width)
    (*base->get_preferred_width)(self, for_height, min_width_p, natural_width_p);

}
void Actor_Class::get_preferred_height_vfunc_callback(ClutterActor* self, float for_width, float* min_height_p, float* natural_height_p)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->get_preferred_height_vfunc(for_width, *(min_height_p)
, *(natural_height_p)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_preferred_height)
    (*base->get_preferred_height)(self, for_width, min_height_p, natural_height_p);

}
void Actor_Class::allocate_vfunc_callback(ClutterActor* self, const ClutterActorBox* box, ClutterAllocationFlags absolute_origin_changed)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->allocate_vfunc(Glib::wrap(box)
, ((AllocationFlags)(absolute_origin_changed))
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->allocate)
    (*base->allocate)(self, box, absolute_origin_changed);

}

gboolean Actor_Class::button_press_event_callback(ClutterActor* self, ClutterButtonEvent* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_button_press_event(p0
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->button_press_event)
    return (*base->button_press_event)(self, p0);

  typedef gboolean RType;
  return RType();
}
gboolean Actor_Class::button_release_event_callback(ClutterActor* self, ClutterButtonEvent* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_button_release_event(p0
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->button_release_event)
    return (*base->button_release_event)(self, p0);

  typedef gboolean RType;
  return RType();
}
gboolean Actor_Class::motion_event_callback(ClutterActor* self, ClutterMotionEvent* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_motion_event(p0
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->motion_event)
    return (*base->motion_event)(self, p0);

  typedef gboolean RType;
  return RType();
}
gboolean Actor_Class::leave_event_callback(ClutterActor* self, ClutterCrossingEvent* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_leave_event(p0
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->leave_event)
    return (*base->leave_event)(self, p0);

  typedef gboolean RType;
  return RType();
}
void Actor_Class::show_callback(ClutterActor* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_show();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->show)
    (*base->show)(self);
}
void Actor_Class::hide_callback(ClutterActor* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_hide();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->hide)
    (*base->hide)(self);
}
void Actor_Class::destroy_callback(ClutterActor* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_destroy();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->destroy)
    (*base->destroy)(self);
}
gboolean Actor_Class::key_release_event_callback(ClutterActor* self, ClutterKeyEvent* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_key_release_event(p0
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->key_release_event)
    return (*base->key_release_event)(self, p0);

  typedef gboolean RType;
  return RType();
}
gboolean Actor_Class::enter_event_callback(ClutterActor* self, ClutterCrossingEvent* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_enter_event(p0
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->enter_event)
    return (*base->enter_event)(self, p0);

  typedef gboolean RType;
  return RType();
}
gboolean Actor_Class::event_callback(ClutterActor* self, ClutterEvent* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_event(p0
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->event)
    return (*base->event)(self, p0);

  typedef gboolean RType;
  return RType();
}
void Actor_Class::key_focus_out_callback(ClutterActor* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_key_focus_out();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->key_focus_out)
    (*base->key_focus_out)(self);
}
void Actor_Class::key_focus_in_callback(ClutterActor* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_key_focus_in();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->key_focus_in)
    (*base->key_focus_in)(self);
}
void Actor_Class::parent_set_callback(ClutterActor* self, ClutterActor* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_parent_set(Glib::wrap((p0),true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->parent_set)
    (*base->parent_set)(self, p0);
}
gboolean Actor_Class::scroll_event_callback(ClutterActor* self, ClutterScrollEvent* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_scroll_event(p0
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->scroll_event)
    return (*base->scroll_event)(self, p0);

  typedef gboolean RType;
  return RType();
}
gboolean Actor_Class::key_press_event_callback(ClutterActor* self, ClutterKeyEvent* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_key_press_event(p0
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->key_press_event)
    return (*base->key_press_event)(self, p0);

  typedef gboolean RType;
  return RType();
}
gboolean Actor_Class::captured_event_callback(ClutterActor* self, ClutterEvent* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_captured_event(p0
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->captured_event)
    return (*base->captured_event)(self, p0);

  typedef gboolean RType;
  return RType();
}
void Actor_Class::paint_callback(ClutterActor* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_paint();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->paint)
    (*base->paint)(self);
}
void Actor_Class::queue_redraw_callback(ClutterActor* self, ClutterActor* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_queue_redaw(Glib::wrap((p0),true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->queue_redraw)
    (*base->queue_redraw)(self, p0);
}
void Actor_Class::queue_relayout_callback(ClutterActor* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_queue_relayout();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->queue_relayout)
    (*base->queue_relayout)(self);
}
void Actor_Class::realize_callback(ClutterActor* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_realize();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->realize)
    (*base->realize)(self);
}
void Actor_Class::unrealize_callback(ClutterActor* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_unrealize();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->unrealize)
    (*base->unrealize)(self);
}
void Actor_Class::pick_callback(ClutterActor* self, const ClutterColor* color)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_pick(Color(const_cast<ClutterColor*>(color), true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->pick)
    (*base->pick)(self, color);
}


Glib::ObjectBase* Actor_Class::wrap_new(GObject* object)
{
  return new Actor((ClutterActor*)object);
}


/* The implementation: */

ClutterActor* Actor::gobj_copy()
{
  reference();
  return gobj();
}

Actor::Actor(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{
   if(gobject_ && g_object_is_floating (gobject_))
     g_object_ref_sink(gobject_); //Stops it from being floating.

}

Actor::Actor(ClutterActor* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Actor::~Actor()
{}


Actor::CppClassType Actor::actor_class_; // initialize static member

GType Actor::get_type()
{
  return actor_class_.init().get_type();
}


GType Actor::get_base_type()
{
  return clutter_actor_get_type();
}

Actor::Actor()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(actor_class_.init()))
{
  
   if(gobject_ && g_object_is_floating (gobject_))
     g_object_ref_sink(gobject_); //Stops it from being floating.

}

void Actor::set_flags(ActorFlags flags)
{
clutter_actor_set_flags(gobj(), ((ClutterActorFlags)(flags))); 
}

void Actor::unset_flags(ActorFlags flags)
{
clutter_actor_unset_flags(gobj(), ((ClutterActorFlags)(flags))); 
}

ActorFlags Actor::get_flags() const
{
  return ((ActorFlags)(clutter_actor_get_flags(const_cast<ClutterActor*>(gobj()))));
}

void Actor::show()
{
clutter_actor_show(gobj()); 
}

void Actor::show_all()
{
clutter_actor_show_all(gobj()); 
}

void Actor::hide()
{
clutter_actor_hide(gobj()); 
}

void Actor::hide_all()
{
clutter_actor_hide_all(gobj()); 
}

void Actor::realize()
{
clutter_actor_realize(gobj()); 
}

void Actor::unrealize()
{
clutter_actor_unrealize(gobj()); 
}

void Actor::map()
{
clutter_actor_map(gobj()); 
}

void Actor::unmap()
{
clutter_actor_unmap(gobj()); 
}

void Actor::paint()
{
clutter_actor_paint(gobj()); 
}

void Actor::queue_redraw()
{
clutter_actor_queue_redraw(gobj()); 
}

void Actor::queue_relayout()
{
clutter_actor_queue_relayout(gobj()); 
}

Glib::RefPtr<Pango::Context> Actor::get_pango_context()
{

  Glib::RefPtr<Pango::Context> retvalue = Glib::wrap(clutter_actor_get_pango_context(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Pango::Context> Actor::get_pango_context() const
{
  return const_cast<Actor*>(this)->get_pango_context();
}

Glib::RefPtr<Pango::Context> Actor::create_pango_context()
{
  return Glib::wrap(clutter_actor_create_pango_context(gobj()));
}

Glib::RefPtr<Pango::Layout> Actor::create_pango_layout(const Glib::ustring& text)
{
  return Glib::wrap(clutter_actor_create_pango_layout(gobj(), text.c_str()));
}

void Actor::get_transformation_matrix(CoglMatrix* matrix)
{
clutter_actor_get_transformation_matrix(gobj(), matrix); 
}

bool Actor::is_in_clone_paint() const
{
  return clutter_actor_is_in_clone_paint(const_cast<ClutterActor*>(gobj()));
}

bool Actor::has_pointer() const
{
  return clutter_actor_has_pointer(const_cast<ClutterActor*>(gobj()));
}

void Actor::set_text_direction(TextDirection text_dir)
{
clutter_actor_set_text_direction(gobj(), ((ClutterTextDirection)(text_dir))); 
}

TextDirection Actor::get_text_direction() const
{
  return ((TextDirection)(clutter_actor_get_text_direction(const_cast<ClutterActor*>(gobj()))));
}

Glib::RefPtr<Actor> Actor::get_stage()
{

  Glib::RefPtr<Actor> retvalue = Glib::wrap(clutter_actor_get_stage(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Actor> Actor::get_stage() const
{
  return const_cast<Actor*>(this)->get_stage();
}

void Actor::set_geometry(const Geometry& geometry)
{
clutter_actor_set_geometry(gobj(), (geometry).gobj()); 
}

void Actor::set_size(float width, float height)
{
clutter_actor_set_size(gobj(), width, height); 
}

void Actor::get_position(float& x, float& y)
{
clutter_actor_get_position(gobj(), &(x), &(y)); 
}

void Actor::set_position(float x, float y)
{
clutter_actor_set_position(gobj(), x, y); 
}

float Actor::get_width() const
{
  return clutter_actor_get_width(const_cast<ClutterActor*>(gobj()));
}

float Actor::get_height() const
{
  return clutter_actor_get_height(const_cast<ClutterActor*>(gobj()));
}

void Actor::set_width(float width)
{
clutter_actor_set_width(gobj(), width); 
}

void Actor::set_height(float height)
{
clutter_actor_set_height(gobj(), height); 
}

void Actor::set_x(float x)
{
clutter_actor_set_x(gobj(), x); 
}

float Actor::get_x() const
{
  return clutter_actor_get_x(const_cast<ClutterActor*>(gobj()));
}

void Actor::set_y(float y)
{
clutter_actor_set_y(gobj(), y); 
}

float Actor::get_y() const
{
  return clutter_actor_get_y(const_cast<ClutterActor*>(gobj()));
}

void Actor::set_reactive(bool reactive)
{
clutter_actor_set_reactive(gobj(), static_cast<int>(reactive)); 
}

bool Actor::get_reactive() const
{
  return clutter_actor_get_reactive(const_cast<ClutterActor*>(gobj()));
}

void Actor::set_rotation(RotateAxis axis, double angle, float x, float y, float z)
{
clutter_actor_set_rotation(gobj(), ((ClutterRotateAxis)(axis)), angle, x, y, z); 
}

void Actor::set_z_rotation_from_gravity(double angle, Gravity gravity)
{
clutter_actor_set_z_rotation_from_gravity(gobj(), angle, ((ClutterGravity)(gravity))); 
}

double Actor::get_rotation(RotateAxis axis, float& x, float& y, float& z) const
{
  return clutter_actor_get_rotation(const_cast<ClutterActor*>(gobj()), ((ClutterRotateAxis)(axis)), &(x), &(y), &(z));
}

Gravity Actor::get_z_rotation_gravity() const
{
  return ((Gravity)(clutter_actor_get_z_rotation_gravity(const_cast<ClutterActor*>(gobj()))));
}

void Actor::set_opacity(guint8 opacity)
{
clutter_actor_set_opacity(gobj(), opacity); 
}

guint8 Actor::get_opacity() const
{
  return clutter_actor_get_opacity(const_cast<ClutterActor*>(gobj()));
}

void Actor::set_name(const gchar * name)
{
clutter_actor_set_name(gobj(), name); 
}

Glib::ustring Actor::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(clutter_actor_get_name(const_cast<ClutterActor*>(gobj())));
}

guint32 Actor::get_gid() const
{
  return clutter_actor_get_gid(const_cast<ClutterActor*>(gobj()));
}

void Actor::set_clip(float xoff, float yoff, float width, float height)
{
clutter_actor_set_clip(gobj(), xoff, yoff, width, height); 
}

void Actor::get_clip(float& xoff, float& yoff, float& width, float& height)
{
clutter_actor_get_clip(gobj(), &(xoff), &(yoff), &(width), &(height)); 
}

void Actor::remove_clip()
{
clutter_actor_remove_clip(gobj()); 
}

bool Actor::has_clip() const
{
  return clutter_actor_has_clip(const_cast<ClutterActor*>(gobj()));
}

void Actor::set_parent(const Glib::RefPtr<Actor>& parent)
{
clutter_actor_set_parent(gobj(), Glib::unwrap(parent)); 
}

Glib::RefPtr<Actor> Actor::get_parent()
{

  Glib::RefPtr<Actor> retvalue = Glib::wrap(clutter_actor_get_parent(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Actor> Actor::get_parent() const
{
  return const_cast<Actor*>(this)->get_parent();
}

void Actor::reparent(const Glib::RefPtr<Actor>& new_parent)
{
clutter_actor_reparent(gobj(), Glib::unwrap(new_parent)); 
}

void Actor::unparent()
{
clutter_actor_unparent(gobj()); 
}

void Actor::raise(const Glib::RefPtr<Actor>& below)
{
clutter_actor_raise(gobj(), Glib::unwrap(below)); 
}

void Actor::lower(const Glib::RefPtr<Actor>& above)
{
clutter_actor_lower(gobj(), Glib::unwrap(above)); 
}

void Actor::raise_top()
{
clutter_actor_raise_top(gobj()); 
}

void Actor::lower_bottom()
{
clutter_actor_lower_bottom(gobj()); 
}

Glib::RefPtr<Shader> Actor::get_shader()
{

  Glib::RefPtr<Shader> retvalue = Glib::wrap(clutter_actor_get_shader(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Shader> Actor::get_shader() const
{
  return const_cast<Actor*>(this)->get_shader();
}

void Actor::set_shader(const Glib::RefPtr<Shader>& shader)
{
clutter_actor_set_shader(gobj(), Glib::unwrap(shader)); 
}

bool Actor::is_rotated() const
{
  return clutter_actor_is_rotated(const_cast<ClutterActor*>(gobj()));
}

bool Actor::is_scaled() const
{
  return clutter_actor_is_scaled(const_cast<ClutterActor*>(gobj()));
}

bool Actor::should_pick_paint() const
{
  return clutter_actor_should_pick_paint(const_cast<ClutterActor*>(gobj()));
}

void Actor::allocate(const ActorBox& box, AllocationFlags absolute_origin_changed)
{
clutter_actor_allocate(gobj(), (box).gobj(), ((ClutterAllocationFlags)(absolute_origin_changed))); 
}

void Actor::allocate_preferred_size(AllocationFlags absolute_origin_changed)
{
clutter_actor_allocate_preferred_size(gobj(), ((ClutterAllocationFlags)(absolute_origin_changed))); 
}

void Actor::allocate_available_size(float x, float y, float available_width, float available_height, AllocationFlags flags)
{
clutter_actor_allocate_available_size(gobj(), x, y, available_width, available_height, ((ClutterAllocationFlags)(flags))); 
}

void Actor::apply_relative_transform_to_point(const Glib::RefPtr<Actor>& ancestor, const Vertex& point, Vertex& vertex) const
{
clutter_actor_apply_relative_transform_to_point(const_cast<ClutterActor*>(gobj()), Glib::unwrap(ancestor), (point).gobj(), (vertex).gobj()); 
}

void Actor::set_request_mode(RequestMode mode)
{
clutter_actor_set_request_mode(gobj(), ((ClutterRequestMode)(mode))); 
}

RequestMode Actor::get_request_mode() const
{
  return ((RequestMode)(clutter_actor_get_request_mode(const_cast<ClutterActor*>(gobj()))));
}

void Actor::get_preferred_size(float& min_width_p, float& min_height_p, float& natural_width_p, float& natural_height_p) const
{
clutter_actor_get_preferred_size(const_cast<ClutterActor*>(gobj()), &(min_width_p), &(min_height_p), &(natural_width_p), &(natural_height_p)); 
}

void Actor::get_preferred_width(float for_height, float& min_width_p, float& natural_width_p) const
{
clutter_actor_get_preferred_width(const_cast<ClutterActor*>(gobj()), for_height, &(min_width_p), &(natural_width_p)); 
}

void Actor::get_preferred_height(float for_width, float& min_height_p, float& natural_height_p) const
{
clutter_actor_get_preferred_height(const_cast<ClutterActor*>(gobj()), for_width, &(min_height_p), &(natural_height_p)); 
}

guint8 Actor::get_paint_opacity() const
{
  return clutter_actor_get_paint_opacity(const_cast<ClutterActor*>(gobj()));
}

bool Actor::get_paint_visibility() const
{
  return clutter_actor_get_paint_visibility(const_cast<ClutterActor*>(gobj()));
}

void Actor::move_anchor_point_from_gravity(Gravity gravity)
{
clutter_actor_move_anchor_point_from_gravity(gobj(), ((ClutterGravity)(gravity))); 
}

void Actor::move_anchor_point(float anchor_x, float anchor_y)
{
clutter_actor_move_anchor_point(gobj(), anchor_x, anchor_y); 
}

bool Actor::get_fixed_position_set() const
{
  return clutter_actor_get_fixed_position_set(const_cast<ClutterActor*>(gobj()));
}

void Actor::set_fixed_position_set(bool is_set)
{
clutter_actor_set_fixed_position_set(gobj(), static_cast<int>(is_set)); 
}

void Actor::get_transformed_position(float& x, float& y) const
{
clutter_actor_get_transformed_position(const_cast<ClutterActor*>(gobj()), &(x), &(y)); 
}

void Actor::get_transformed_size(float& width, float& height) const
{
clutter_actor_get_transformed_size(const_cast<ClutterActor*>(gobj()), &(width), &(height)); 
}

void Actor::set_depth(float depth)
{
clutter_actor_set_depth(gobj(), depth); 
}

float Actor::get_depth() const
{
  return clutter_actor_get_depth(const_cast<ClutterActor*>(gobj()));
}

void Actor::set_scale(double scale_x, double scale_y)
{
clutter_actor_set_scale(gobj(), scale_x, scale_y); 
}

void Actor::set_scale_full(double scale_x, double scale_y, float center_x, float center_y)
{
clutter_actor_set_scale_full(gobj(), scale_x, scale_y, center_x, center_y); 
}

void Actor::set_scale_with_gravity(double scale_x, double scale_y, Gravity gravity)
{
clutter_actor_set_scale_with_gravity(gobj(), scale_x, scale_y, ((ClutterGravity)(gravity))); 
}

void Actor::get_scale(double& scale_x, double& scale_y) const
{
clutter_actor_get_scale(const_cast<ClutterActor*>(gobj()), &(scale_x), &(scale_y)); 
}

void Actor::get_scale_center(float& center_x, float& center_y) const
{
clutter_actor_get_scale_center(const_cast<ClutterActor*>(gobj()), &(center_x), &(center_y)); 
}

Gravity Actor::get_scale_gravity() const
{
  return ((Gravity)(clutter_actor_get_scale_gravity(const_cast<ClutterActor*>(gobj()))));
}

void Actor::get_size(float& width, float& height) const
{
clutter_actor_get_size(const_cast<ClutterActor*>(gobj()), &(width), &(height)); 
}

void Actor::move_by(float dx, float dy)
{
clutter_actor_move_by(gobj(), dx, dy); 
}

void Actor::apply_transform_to_point(const Vertex& point, Vertex& vertex) const
{
clutter_actor_apply_transform_to_point(const_cast<ClutterActor*>(gobj()), (point).gobj(), (vertex).gobj()); 
}

void Actor::transform_stage_point(float x, float y, float& x_out, float& y_out) const
{
clutter_actor_transform_stage_point(const_cast<ClutterActor*>(gobj()), x, y, &(x_out), &(y_out)); 
}

bool Actor::event(ClutterEvent* event, bool capture)
{
  return clutter_actor_event(gobj(), event, static_cast<int>(capture));
}

Glib::RefPtr<Actor> Actor::get_actor_by_gid(guint32 id)
{

  Glib::RefPtr<Actor> retvalue = Glib::wrap(clutter_get_actor_by_gid(id));

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}


void Actor::set_anchor_point(float anchor_x, float anchor_y)
{
clutter_actor_set_anchor_point(gobj(), anchor_x, anchor_y); 
}

void Actor::get_anchor_point(float& anchor_x, float& anchor_y) const
{
clutter_actor_get_anchor_point(const_cast<ClutterActor*>(gobj()), &(anchor_x), &(anchor_y)); 
}

void Actor::set_anchor_point_from_gravity(ClutterGravity gravity)
{
clutter_actor_set_anchor_point_from_gravity(gobj(), gravity); 
}

Gravity Actor::get_anchor_point_gravity()
{
  return ((Gravity)(clutter_actor_get_anchor_point_gravity(gobj())));
}

void Actor::grab_key_focus()
{
clutter_actor_grab_key_focus(gobj()); 
}

Glib::RefPtr<Animation> Actor::get_animation()
{

  Glib::RefPtr<Animation> retvalue = Glib::wrap(clutter_actor_get_animation(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Animation> Actor::get_animation() const
{
  return const_cast<Actor*>(this)->get_animation();
}

void Actor::push_internal()
{
clutter_actor_push_internal(gobj()); 
}

void Actor::pop_internal()
{
clutter_actor_pop_internal(gobj()); 
}

void Actor::set_shader_param_value(const Glib::ustring& param, const Glib::ValueBase& value)
{
clutter_actor_set_shader_param(gobj(), param.c_str(), (value).gobj()); 
}


Glib::SignalProxy1< bool,ButtonEvent* > Actor::signal_button_press_event()
{
  return Glib::SignalProxy1< bool,ButtonEvent* >(this, &Actor_signal_button_press_event_info);
}


Glib::SignalProxy1< bool,ButtonEvent* > Actor::signal_button_release_event()
{
  return Glib::SignalProxy1< bool,ButtonEvent* >(this, &Actor_signal_button_release_event_info);
}


Glib::SignalProxy1< bool,MotionEvent* > Actor::signal_motion_event()
{
  return Glib::SignalProxy1< bool,MotionEvent* >(this, &Actor_signal_motion_event_info);
}


Glib::SignalProxy1< bool,CrossingEvent* > Actor::signal_leave_event()
{
  return Glib::SignalProxy1< bool,CrossingEvent* >(this, &Actor_signal_leave_event_info);
}


Glib::SignalProxy0< void > Actor::signal_show()
{
  return Glib::SignalProxy0< void >(this, &Actor_signal_show_info);
}


Glib::SignalProxy0< void > Actor::signal_hide()
{
  return Glib::SignalProxy0< void >(this, &Actor_signal_hide_info);
}


Glib::SignalProxy0< void > Actor::signal_destroy()
{
  return Glib::SignalProxy0< void >(this, &Actor_signal_destroy_info);
}


Glib::SignalProxy1< bool,KeyEvent* > Actor::signal_key_release_event()
{
  return Glib::SignalProxy1< bool,KeyEvent* >(this, &Actor_signal_key_release_event_info);
}


Glib::SignalProxy1< bool,CrossingEvent* > Actor::signal_enter_event()
{
  return Glib::SignalProxy1< bool,CrossingEvent* >(this, &Actor_signal_enter_event_info);
}


Glib::SignalProxy1< bool,Event* > Actor::signal_event()
{
  return Glib::SignalProxy1< bool,Event* >(this, &Actor_signal_event_info);
}


Glib::SignalProxy0< void > Actor::signal_key_focus_out()
{
  return Glib::SignalProxy0< void >(this, &Actor_signal_key_focus_out_info);
}


Glib::SignalProxy0< void > Actor::signal_key_focus_in()
{
  return Glib::SignalProxy0< void >(this, &Actor_signal_key_focus_in_info);
}


Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& > Actor::signal_parent_set()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& >(this, &Actor_signal_parent_set_info);
}


Glib::SignalProxy1< bool,ScrollEvent* > Actor::signal_scroll_event()
{
  return Glib::SignalProxy1< bool,ScrollEvent* >(this, &Actor_signal_scroll_event_info);
}


Glib::SignalProxy1< bool,KeyEvent* > Actor::signal_key_press_event()
{
  return Glib::SignalProxy1< bool,KeyEvent* >(this, &Actor_signal_key_press_event_info);
}


Glib::SignalProxy1< bool,Event* > Actor::signal_captured_event()
{
  return Glib::SignalProxy1< bool,Event* >(this, &Actor_signal_captured_event_info);
}


Glib::SignalProxy0< void > Actor::signal_paint()
{
  return Glib::SignalProxy0< void >(this, &Actor_signal_paint_info);
}


Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& > Actor::signal_queue_redaw()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& >(this, &Actor_signal_queue_redaw_info);
}


Glib::SignalProxy0< void > Actor::signal_queue_relayout()
{
  return Glib::SignalProxy0< void >(this, &Actor_signal_queue_relayout_info);
}


Glib::SignalProxy0< void > Actor::signal_realize()
{
  return Glib::SignalProxy0< void >(this, &Actor_signal_realize_info);
}


Glib::SignalProxy0< void > Actor::signal_unrealize()
{
  return Glib::SignalProxy0< void >(this, &Actor_signal_unrealize_info);
}


Glib::SignalProxy1< void,const Color& > Actor::signal_pick()
{
  return Glib::SignalProxy1< void,const Color& >(this, &Actor_signal_pick_info);
}


Glib::SignalProxy2< void,const ActorBox&,AllocationFlags > Actor::signal_allocation_changed()
{
  return Glib::SignalProxy2< void,const ActorBox&,AllocationFlags >(this, &Actor_signal_allocation_changed_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<ActorBox> Actor::property_allocation() const
{
  return Glib::PropertyProxy_ReadOnly<ActorBox>(this, "allocation");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<float> Actor::property_anchor_x() 
{
  return Glib::PropertyProxy<float>(this, "anchor-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<float> Actor::property_anchor_x() const
{
  return Glib::PropertyProxy_ReadOnly<float>(this, "anchor-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<float> Actor::property_anchor_y() 
{
  return Glib::PropertyProxy<float>(this, "anchor-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<float> Actor::property_anchor_y() const
{
  return Glib::PropertyProxy_ReadOnly<float>(this, "anchor-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Gravity> Actor::property_anchor_gravity() 
{
  return Glib::PropertyProxy<Gravity>(this, "anchor-gravity");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Gravity> Actor::property_anchor_gravity() const
{
  return Glib::PropertyProxy_ReadOnly<Gravity>(this, "anchor-gravity");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Geometry> Actor::property_clip() 
{
  return Glib::PropertyProxy<Geometry>(this, "clip");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Geometry> Actor::property_clip() const
{
  return Glib::PropertyProxy_ReadOnly<Geometry>(this, "clip");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Actor::property_clip_to_allocation() 
{
  return Glib::PropertyProxy<bool>(this, "clip-to-allocation");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Actor::property_clip_to_allocation() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "clip-to-allocation");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<float> Actor::property_depth() 
{
  return Glib::PropertyProxy<float>(this, "depth");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<float> Actor::property_depth() const
{
  return Glib::PropertyProxy_ReadOnly<float>(this, "depth");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Actor::property_fixed_position_set() 
{
  return Glib::PropertyProxy<bool>(this, "fixed-position-set");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Actor::property_fixed_position_set() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "fixed-position-set");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<float> Actor::property_fixed_x() 
{
  return Glib::PropertyProxy<float>(this, "fixed-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<float> Actor::property_fixed_x() const
{
  return Glib::PropertyProxy_ReadOnly<float>(this, "fixed-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<float> Actor::property_fixed_y() 
{
  return Glib::PropertyProxy<float>(this, "fixed-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<float> Actor::property_fixed_y() const
{
  return Glib::PropertyProxy_ReadOnly<float>(this, "fixed-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Actor::property_has_clip() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "has-clip");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Actor::property_has_pointer() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "has-pointer");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<float> Actor::property_height() 
{
  return Glib::PropertyProxy<float>(this, "height");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<float> Actor::property_height() const
{
  return Glib::PropertyProxy_ReadOnly<float>(this, "height");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<float> Actor::property_min_height() 
{
  return Glib::PropertyProxy<float>(this, "min-height");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<float> Actor::property_min_height() const
{
  return Glib::PropertyProxy_ReadOnly<float>(this, "min-height");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Actor::property_min_height_set() 
{
  return Glib::PropertyProxy<bool>(this, "min-height-set");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Actor::property_min_height_set() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "min-height-set");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<float> Actor::property_min_width() 
{
  return Glib::PropertyProxy<float>(this, "min-width");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<float> Actor::property_min_width() const
{
  return Glib::PropertyProxy_ReadOnly<float>(this, "min-width");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Actor::property_min_width_set() 
{
  return Glib::PropertyProxy<bool>(this, "min-width-set");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Actor::property_min_width_set() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "min-width-set");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Actor::property_name() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "name");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Actor::property_name() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "name");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<guint8> Actor::property_opacity() 
{
  return Glib::PropertyProxy<guint8>(this, "opacity");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<guint8> Actor::property_opacity() const
{
  return Glib::PropertyProxy_ReadOnly<guint8>(this, "opacity");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Actor::property_reactive() 
{
  return Glib::PropertyProxy<bool>(this, "reactive");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Actor::property_reactive() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "reactive");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<RequestMode> Actor::property_request_mode() 
{
  return Glib::PropertyProxy<RequestMode>(this, "request-mode");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<RequestMode> Actor::property_request_mode() const
{
  return Glib::PropertyProxy_ReadOnly<RequestMode>(this, "request-mode");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<double> Actor::property_rotation_angle_x() 
{
  return Glib::PropertyProxy<double>(this, "rotation-angle-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> Actor::property_rotation_angle_x() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "rotation-angle-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<double> Actor::property_rotation_angle_y() 
{
  return Glib::PropertyProxy<double>(this, "rotation-angle-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> Actor::property_rotation_angle_y() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "rotation-angle-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<double> Actor::property_rotation_angle_z() 
{
  return Glib::PropertyProxy<double>(this, "rotation-angle-z");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> Actor::property_rotation_angle_z() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "rotation-angle-z");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Vertex> Actor::property_rotation_center_x() 
{
  return Glib::PropertyProxy<Vertex>(this, "rotation-center-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Vertex> Actor::property_rotation_center_x() const
{
  return Glib::PropertyProxy_ReadOnly<Vertex>(this, "rotation-center-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Vertex> Actor::property_rotation_center_y() 
{
  return Glib::PropertyProxy<Vertex>(this, "rotation-center-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Vertex> Actor::property_rotation_center_y() const
{
  return Glib::PropertyProxy_ReadOnly<Vertex>(this, "rotation-center-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Vertex> Actor::property_rotation_center_z() 
{
  return Glib::PropertyProxy<Vertex>(this, "rotation-center-z");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Vertex> Actor::property_rotation_center_z() const
{
  return Glib::PropertyProxy_ReadOnly<Vertex>(this, "rotation-center-z");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Gravity> Actor::property_rotation_center_z_gravity() 
{
  return Glib::PropertyProxy<Gravity>(this, "rotation-center-z-gravity");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Gravity> Actor::property_rotation_center_z_gravity() const
{
  return Glib::PropertyProxy_ReadOnly<Gravity>(this, "rotation-center-z-gravity");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<double> Actor::property_scale_x() 
{
  return Glib::PropertyProxy<double>(this, "scale-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> Actor::property_scale_x() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "scale-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<double> Actor::property_scale_y() 
{
  return Glib::PropertyProxy<double>(this, "scale-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> Actor::property_scale_y() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "scale-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<double> Actor::property_scale_center_x() 
{
  return Glib::PropertyProxy<double>(this, "scale-center-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> Actor::property_scale_center_x() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "scale-center-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<double> Actor::property_scale_center_y() 
{
  return Glib::PropertyProxy<double>(this, "scale-center-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> Actor::property_scale_center_y() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "scale-center-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Gravity> Actor::property_scale_gravity() 
{
  return Glib::PropertyProxy<Gravity>(this, "scale-gravity");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Gravity> Actor::property_scale_gravity() const
{
  return Glib::PropertyProxy_ReadOnly<Gravity>(this, "scale-gravity");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Actor::property_show_on_set_parent() 
{
  return Glib::PropertyProxy<bool>(this, "show-on-set-parent");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Actor::property_show_on_set_parent() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "show-on-set-parent");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<TextDirection> Actor::property_text_direction() 
{
  return Glib::PropertyProxy<TextDirection>(this, "text-direction");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<TextDirection> Actor::property_text_direction() const
{
  return Glib::PropertyProxy_ReadOnly<TextDirection>(this, "text-direction");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Actor::property_visible() 
{
  return Glib::PropertyProxy<bool>(this, "visible");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Actor::property_visible() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "visible");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<float> Actor::property_width() 
{
  return Glib::PropertyProxy<float>(this, "width");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<float> Actor::property_width() const
{
  return Glib::PropertyProxy_ReadOnly<float>(this, "width");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<float> Actor::property_x() 
{
  return Glib::PropertyProxy<float>(this, "x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<float> Actor::property_x() const
{
  return Glib::PropertyProxy_ReadOnly<float>(this, "x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<float> Actor::property_y() 
{
  return Glib::PropertyProxy<float>(this, "y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<float> Actor::property_y() const
{
  return Glib::PropertyProxy_ReadOnly<float>(this, "y");
}
#endif //GLIBMM_PROPERTIES_ENABLED


bool Clutter::Actor::on_button_press_event(ButtonEvent* event)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->button_press_event)
    return (*base->button_press_event)(gobj(),event);

  typedef bool RType;
  return RType();
}
bool Clutter::Actor::on_button_release_event(ButtonEvent* event)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->button_release_event)
    return (*base->button_release_event)(gobj(),event);

  typedef bool RType;
  return RType();
}
bool Clutter::Actor::on_motion_event(MotionEvent* event)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->motion_event)
    return (*base->motion_event)(gobj(),event);

  typedef bool RType;
  return RType();
}
bool Clutter::Actor::on_leave_event(CrossingEvent* event)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->leave_event)
    return (*base->leave_event)(gobj(),event);

  typedef bool RType;
  return RType();
}
void Clutter::Actor::on_show()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->show)
    (*base->show)(gobj());
}
void Clutter::Actor::on_hide()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->hide)
    (*base->hide)(gobj());
}
void Clutter::Actor::on_destroy()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->destroy)
    (*base->destroy)(gobj());
}
bool Clutter::Actor::on_key_release_event(KeyEvent* event)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->key_release_event)
    return (*base->key_release_event)(gobj(),event);

  typedef bool RType;
  return RType();
}
bool Clutter::Actor::on_enter_event(CrossingEvent* event)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->enter_event)
    return (*base->enter_event)(gobj(),event);

  typedef bool RType;
  return RType();
}
bool Clutter::Actor::on_event(Event* event)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->event)
    return (*base->event)(gobj(),event);

  typedef bool RType;
  return RType();
}
void Clutter::Actor::on_key_focus_out()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->key_focus_out)
    (*base->key_focus_out)(gobj());
}
void Clutter::Actor::on_key_focus_in()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->key_focus_in)
    (*base->key_focus_in)(gobj());
}
void Clutter::Actor::on_parent_set(const Glib::RefPtr<Actor>& old_parent)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->parent_set)
    (*base->parent_set)(gobj(),Glib::unwrap(old_parent));
}
bool Clutter::Actor::on_scroll_event(ScrollEvent* event)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->scroll_event)
    return (*base->scroll_event)(gobj(),event);

  typedef bool RType;
  return RType();
}
bool Clutter::Actor::on_key_press_event(KeyEvent* event)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->key_press_event)
    return (*base->key_press_event)(gobj(),event);

  typedef bool RType;
  return RType();
}
bool Clutter::Actor::on_captured_event(Event* event)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->captured_event)
    return (*base->captured_event)(gobj(),event);

  typedef bool RType;
  return RType();
}
void Clutter::Actor::on_paint()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->paint)
    (*base->paint)(gobj());
}
void Clutter::Actor::on_queue_redaw(const Glib::RefPtr<Actor>& origin)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->queue_redraw)
    (*base->queue_redraw)(gobj(),Glib::unwrap(origin));
}
void Clutter::Actor::on_queue_relayout()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->queue_relayout)
    (*base->queue_relayout)(gobj());
}
void Clutter::Actor::on_realize()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->realize)
    (*base->realize)(gobj());
}
void Clutter::Actor::on_unrealize()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->unrealize)
    (*base->unrealize)(gobj());
}
void Clutter::Actor::on_pick(const Color& color)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->pick)
    (*base->pick)(gobj(),(color).gobj());
}

void Clutter::Actor::show_all_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->show_all)
    (*base->show_all)(gobj());
}
void Clutter::Actor::hide_all_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->hide_all)
    (*base->hide_all)(gobj());
}
void Clutter::Actor::pick_vfunc(const Color& color) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->pick)
    (*base->pick)(gobj(),(color).gobj());
}
void Clutter::Actor::get_preferred_width_vfunc(float for_height, float& min_width_p, float& natural_width_p) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_preferred_width)
    (*base->get_preferred_width)(const_cast<ClutterActor*>(gobj()),for_height,&(min_width_p),&(natural_width_p));
}
void Clutter::Actor::get_preferred_height_vfunc(float for_width, float& min_height_p, float& natural_height_p) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_preferred_height)
    (*base->get_preferred_height)(const_cast<ClutterActor*>(gobj()),for_width,&(min_height_p),&(natural_height_p));
}
void Clutter::Actor::allocate_vfunc(const ActorBox& box, AllocationFlags absolute_origin_changed) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->allocate)
    (*base->allocate)(gobj(),(box).gobj(),((ClutterAllocationFlags)(absolute_origin_changed)));
}


} // namespace Clutter


