/* modifications-revealer.c generated by valac 0.36.6.6-c7bee, the Vala compiler
 * generated from modifications-revealer.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <dconf.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <glib/gi18n-lib.h>


#define TYPE_MODIFICATIONS_REVEALER (modifications_revealer_get_type ())
#define MODIFICATIONS_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFICATIONS_REVEALER, ModificationsRevealer))
#define MODIFICATIONS_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFICATIONS_REVEALER, ModificationsRevealerClass))
#define IS_MODIFICATIONS_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFICATIONS_REVEALER))
#define IS_MODIFICATIONS_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFICATIONS_REVEALER))
#define MODIFICATIONS_REVEALER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFICATIONS_REVEALER, ModificationsRevealerClass))

typedef struct _ModificationsRevealer ModificationsRevealer;
typedef struct _ModificationsRevealerClass ModificationsRevealerClass;
typedef struct _ModificationsRevealerPrivate ModificationsRevealerPrivate;

#define MODIFICATIONS_REVEALER_TYPE_MODE (modifications_revealer_mode_get_type ())

#define TYPE_SETTING_OBJECT (setting_object_get_type ())
#define SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTING_OBJECT, SettingObject))
#define SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTING_OBJECT, SettingObjectClass))
#define IS_SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTING_OBJECT))
#define IS_SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTING_OBJECT))
#define SETTING_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTING_OBJECT, SettingObjectClass))

typedef struct _SettingObject SettingObject;
typedef struct _SettingObjectClass SettingObjectClass;

#define TYPE_KEY (key_get_type ())
#define KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY, Key))
#define KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY, KeyClass))
#define IS_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY))
#define IS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY))
#define KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY, KeyClass))

typedef struct _Key Key;
typedef struct _KeyClass KeyClass;

#define TYPE_DCONF_KEY (dconf_key_get_type ())
#define DCONF_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DCONF_KEY, DConfKey))
#define DCONF_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DCONF_KEY, DConfKeyClass))
#define IS_DCONF_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DCONF_KEY))
#define IS_DCONF_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DCONF_KEY))
#define DCONF_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DCONF_KEY, DConfKeyClass))

typedef struct _DConfKey DConfKey;
typedef struct _DConfKeyClass DConfKeyClass;

#define TYPE_GSETTINGS_KEY (gsettings_key_get_type ())
#define GSETTINGS_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GSETTINGS_KEY, GSettingsKey))
#define GSETTINGS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GSETTINGS_KEY, GSettingsKeyClass))
#define IS_GSETTINGS_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GSETTINGS_KEY))
#define IS_GSETTINGS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GSETTINGS_KEY))
#define GSETTINGS_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GSETTINGS_KEY, GSettingsKeyClass))

typedef struct _GSettingsKey GSettingsKey;
typedef struct _GSettingsKeyClass GSettingsKeyClass;

#define TYPE_BEHAVIOUR (behaviour_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block17Data Block17Data;
#define _dconf_changeset_unref0(var) ((var == NULL) ? NULL : (var = (dconf_changeset_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	MODIFICATIONS_REVEALER_RELOAD_SIGNAL,
	MODIFICATIONS_REVEALER_NUM_SIGNALS
};
static guint modifications_revealer_signals[MODIFICATIONS_REVEALER_NUM_SIGNALS] = {0};

struct _ModificationsRevealer {
	GtkRevealer parent_instance;
	ModificationsRevealerPrivate * priv;
};

struct _ModificationsRevealerClass {
	GtkRevealerClass parent_class;
};

typedef enum  {
	MODIFICATIONS_REVEALER_MODE_NONE,
	MODIFICATIONS_REVEALER_MODE_TEMPORARY,
	MODIFICATIONS_REVEALER_MODE_DELAYED
} ModificationsRevealerMode;

typedef enum  {
	BEHAVIOUR_UNSAFE,
	BEHAVIOUR_SAFE,
	BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT,
	BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT,
	BEHAVIOUR_ALWAYS_DELAY
} Behaviour;

struct _ModificationsRevealerPrivate {
	ModificationsRevealerMode mode;
	GtkLabel* label;
	GtkModelButton* apply_button;
	GThemedIcon* apply_button_icon;
	DConfClient* dconf_client;
	GHashTable* dconf_keys_awaiting_hashtable;
	GHashTable* gsettings_keys_awaiting_hashtable;
	Behaviour _behaviour;
};

struct _Block17Data {
	int _ref_count_;
	ModificationsRevealer* self;
	GHashTable* delayed_settings_hashtable;
	DConfChangeset* dconf_changeset;
};


static gpointer modifications_revealer_parent_class = NULL;

GType modifications_revealer_get_type (void) G_GNUC_CONST;
static GType modifications_revealer_mode_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType setting_object_get_type (void) G_GNUC_CONST;
GType key_get_type (void) G_GNUC_CONST;
GType dconf_key_get_type (void) G_GNUC_CONST;
GType gsettings_key_get_type (void) G_GNUC_CONST;
GType behaviour_get_type (void) G_GNUC_CONST;
#define MODIFICATIONS_REVEALER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MODIFICATIONS_REVEALER, ModificationsRevealerPrivate))
enum  {
	MODIFICATIONS_REVEALER_0_PROPERTY,
	MODIFICATIONS_REVEALER_BEHAVIOUR_PROPERTY
};
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void modifications_revealer_on_size_allocate (ModificationsRevealer* self, GtkAllocation* allocation);
static void _modifications_revealer_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
gboolean modifications_revealer_get_current_delay_mode (ModificationsRevealer* self);
Behaviour modifications_revealer_get_behaviour (ModificationsRevealer* self);
gboolean modifications_revealer_should_delay_apply (ModificationsRevealer* self, const gchar* type_string);
void modifications_revealer_enter_delay_mode (ModificationsRevealer* self);
static void modifications_revealer_update (ModificationsRevealer* self);
void modifications_revealer_add_delayed_setting (ModificationsRevealer* self, Key* key, GVariant* new_value);
void key_set_planned_change (Key* self, gboolean value);
void key_set_planned_value (Key* self, GVariant* value);
gchar* key_get_descriptor (Key* self);
void modifications_revealer_dismiss_change (ModificationsRevealer* self, Key* key);
void modifications_revealer_path_changed (ModificationsRevealer* self);
void modifications_revealer_apply_delayed_settings (ModificationsRevealer* self);
static void modifications_revealer_dismiss_delayed_settings (ModificationsRevealer* self);
void modifications_revealer_warn_if_no_planned_changes (ModificationsRevealer* self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static gboolean __lambda18_ (Block17Data* _data17_, const gchar* descriptor, GSettingsKey* key);
const gchar* gsettings_key_get_schema_id (GSettingsKey* self);
GVariant* key_get_planned_value (Key* self);
const gchar* setting_object_get_name (SettingObject* self);
static gboolean ___lambda18__ghr_func (gconstpointer key, gconstpointer value, gpointer self);
static gboolean __lambda19_ (ModificationsRevealer* self, const gchar* schema_id, GSettings* schema_settings);
static gboolean ___lambda19__ghr_func (gconstpointer key, gconstpointer value, gpointer self);
static gboolean __lambda20_ (Block17Data* _data17_, const gchar* descriptor, DConfKey* key);
const gchar* setting_object_get_full_name (SettingObject* self);
void dconf_key_set_is_ghost (DConfKey* self, gboolean value);
static gboolean ___lambda20__ghr_func (gconstpointer key, gconstpointer value, gpointer self);
static void _modifications_revealer_apply_delayed_settings_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean __lambda21_ (ModificationsRevealer* self, const gchar* descriptor, GSettingsKey* key);
static gboolean ___lambda21__ghr_func (gconstpointer key, gconstpointer value, gpointer self);
static gboolean __lambda22_ (ModificationsRevealer* self, const gchar* descriptor, DConfKey* key);
static gboolean ___lambda22__ghr_func (gconstpointer key, gconstpointer value, gpointer self);
static void _modifications_revealer_dismiss_delayed_settings_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gchar* modifications_revealer_get_text (guint dconf, guint gsettings);
ModificationsRevealer* modifications_revealer_new (void);
ModificationsRevealer* modifications_revealer_construct (GType object_type);
void modifications_revealer_set_behaviour (ModificationsRevealer* self, Behaviour value);
static void modifications_revealer_finalize (GObject * obj);
static void _vala_modifications_revealer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_modifications_revealer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GType modifications_revealer_mode_get_type (void) {
	static volatile gsize modifications_revealer_mode_type_id__volatile = 0;
	if (g_once_init_enter (&modifications_revealer_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{MODIFICATIONS_REVEALER_MODE_NONE, "MODIFICATIONS_REVEALER_MODE_NONE", "none"}, {MODIFICATIONS_REVEALER_MODE_TEMPORARY, "MODIFICATIONS_REVEALER_MODE_TEMPORARY", "temporary"}, {MODIFICATIONS_REVEALER_MODE_DELAYED, "MODIFICATIONS_REVEALER_MODE_DELAYED", "delayed"}, {0, NULL, NULL}};
		GType modifications_revealer_mode_type_id;
		modifications_revealer_mode_type_id = g_enum_register_static ("ModificationsRevealerMode", values);
		g_once_init_leave (&modifications_revealer_mode_type_id__volatile, modifications_revealer_mode_type_id);
	}
	return modifications_revealer_mode_type_id__volatile;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void modifications_revealer_on_size_allocate (ModificationsRevealer* self, GtkAllocation* allocation) {
	GtkStyleContext* context = NULL;
	GtkModelButton* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkAllocation _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = self->priv->apply_button;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	context = _tmp2_;
	_tmp3_ = *allocation;
	_tmp4_ = _tmp3_.width;
	if (_tmp4_ < 900) {
		GtkStyleContext* _tmp5_;
		GtkModelButton* _tmp6_;
		GThemedIcon* _tmp7_;
		GtkStyleContext* _tmp8_;
		_tmp5_ = context;
		gtk_style_context_remove_class (_tmp5_, "text-button");
		_tmp6_ = self->priv->apply_button;
		_tmp7_ = self->priv->apply_button_icon;
		g_object_set (_tmp6_, "icon", (GIcon*) _tmp7_, NULL);
		_tmp8_ = context;
		gtk_style_context_add_class (_tmp8_, "image-button");
	} else {
		GtkStyleContext* _tmp9_;
		GtkModelButton* _tmp10_;
		GtkStyleContext* _tmp11_;
		_tmp9_ = context;
		gtk_style_context_remove_class (_tmp9_, "image-button");
		_tmp10_ = self->priv->apply_button;
		g_object_set (_tmp10_, "icon", NULL, NULL);
		_tmp11_ = context;
		gtk_style_context_add_class (_tmp11_, "text-button");
	}
	_g_object_unref0 (context);
}


static void _modifications_revealer_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	modifications_revealer_on_size_allocate ((ModificationsRevealer*) self, allocation);
}


gboolean modifications_revealer_get_current_delay_mode (ModificationsRevealer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ModificationsRevealerMode _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->mode;
	if (_tmp1_ == MODIFICATIONS_REVEALER_MODE_DELAYED) {
		_tmp0_ = TRUE;
	} else {
		Behaviour _tmp2_;
		_tmp2_ = self->priv->_behaviour;
		_tmp0_ = _tmp2_ == BEHAVIOUR_ALWAYS_DELAY;
	}
	result = _tmp0_;
	return result;
}


gboolean modifications_revealer_should_delay_apply (ModificationsRevealer* self, const gchar* type_string) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	Behaviour _tmp5_;
	Behaviour _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_string != NULL, FALSE);
	_tmp2_ = modifications_revealer_get_current_delay_mode (self);
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		Behaviour _tmp3_;
		_tmp3_ = self->priv->_behaviour;
		_tmp1_ = _tmp3_ == BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Behaviour _tmp4_;
		_tmp4_ = self->priv->_behaviour;
		_tmp0_ = _tmp4_ == BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->priv->_behaviour;
	if (_tmp5_ == BEHAVIOUR_UNSAFE) {
		result = FALSE;
		return result;
	}
	_tmp6_ = self->priv->_behaviour;
	if (_tmp6_ == BEHAVIOUR_SAFE) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		_tmp10_ = type_string;
		if (g_strcmp0 (_tmp10_, "b") != 0) {
			const gchar* _tmp11_;
			_tmp11_ = type_string;
			_tmp9_ = g_strcmp0 (_tmp11_, "mb") != 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			const gchar* _tmp12_;
			_tmp12_ = type_string;
			_tmp8_ = g_strcmp0 (_tmp12_, "<enum>") != 0;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp13_;
			_tmp13_ = type_string;
			_tmp7_ = g_strcmp0 (_tmp13_, "<flags>") != 0;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		return result;
	}
	g_assert_not_reached ();
}


void modifications_revealer_enter_delay_mode (ModificationsRevealer* self) {
	GtkModelButton* _tmp0_;
	GHashTable* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	GHashTable* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	g_return_if_fail (self != NULL);
	self->priv->mode = MODIFICATIONS_REVEALER_MODE_DELAYED;
	_tmp0_ = self->priv->apply_button;
	_tmp1_ = self->priv->dconf_keys_awaiting_hashtable;
	_tmp2_ = g_hash_table_size (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->gsettings_keys_awaiting_hashtable;
	_tmp5_ = g_hash_table_size (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, (_tmp3_ + _tmp6_) != ((guint) 0));
	modifications_revealer_update (self);
}


void modifications_revealer_add_delayed_setting (ModificationsRevealer* self, Key* key, GVariant* new_value) {
	Key* _tmp0_;
	Key* _tmp1_;
	GVariant* _tmp2_;
	Key* _tmp3_;
	ModificationsRevealerMode _tmp16_ = 0;
	gboolean _tmp17_;
	GtkModelButton* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	key_set_planned_change (_tmp0_, TRUE);
	_tmp1_ = key;
	_tmp2_ = new_value;
	key_set_planned_value (_tmp1_, _tmp2_);
	_tmp3_ = key;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_GSETTINGS_KEY)) {
		GHashTable* _tmp4_;
		Key* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		Key* _tmp8_;
		GSettingsKey* _tmp9_;
		_tmp4_ = self->priv->gsettings_keys_awaiting_hashtable;
		_tmp5_ = key;
		_tmp6_ = key_get_descriptor (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = key;
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_GSETTINGS_KEY, GSettingsKey));
		g_hash_table_insert (_tmp4_, _tmp7_, _tmp9_);
	} else {
		GHashTable* _tmp10_;
		Key* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		Key* _tmp14_;
		DConfKey* _tmp15_;
		_tmp10_ = self->priv->dconf_keys_awaiting_hashtable;
		_tmp11_ = key;
		_tmp12_ = key_get_descriptor (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = key;
		_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_DCONF_KEY, DConfKey));
		g_hash_table_insert (_tmp10_, _tmp13_, _tmp15_);
	}
	_tmp17_ = modifications_revealer_get_current_delay_mode (self);
	if (_tmp17_) {
		_tmp16_ = MODIFICATIONS_REVEALER_MODE_DELAYED;
	} else {
		_tmp16_ = MODIFICATIONS_REVEALER_MODE_TEMPORARY;
	}
	self->priv->mode = _tmp16_;
	_tmp18_ = self->priv->apply_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp18_, TRUE);
	modifications_revealer_update (self);
}


void modifications_revealer_dismiss_change (ModificationsRevealer* self, Key* key) {
	ModificationsRevealerMode _tmp0_;
	Key* _tmp3_;
	Key* _tmp4_;
	Key* _tmp5_;
	gboolean _tmp16_ = FALSE;
	ModificationsRevealerMode _tmp17_;
	GtkModelButton* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->mode;
	if (_tmp0_ == MODIFICATIONS_REVEALER_MODE_NONE) {
		ModificationsRevealerMode _tmp1_ = 0;
		Behaviour _tmp2_;
		_tmp2_ = self->priv->_behaviour;
		if (_tmp2_ == BEHAVIOUR_ALWAYS_DELAY) {
			_tmp1_ = MODIFICATIONS_REVEALER_MODE_DELAYED;
		} else {
			_tmp1_ = MODIFICATIONS_REVEALER_MODE_TEMPORARY;
		}
		self->priv->mode = _tmp1_;
	}
	_tmp3_ = key;
	key_set_planned_change (_tmp3_, FALSE);
	_tmp4_ = key;
	key_set_planned_value (_tmp4_, NULL);
	_tmp5_ = key;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_GSETTINGS_KEY)) {
		GHashTable* _tmp6_;
		Key* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = self->priv->gsettings_keys_awaiting_hashtable;
		_tmp7_ = key;
		_tmp8_ = key_get_descriptor (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		g_hash_table_remove (_tmp6_, _tmp10_);
		_g_free0 (_tmp10_);
	} else {
		GHashTable* _tmp11_;
		Key* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp11_ = self->priv->dconf_keys_awaiting_hashtable;
		_tmp12_ = key;
		_tmp13_ = key_get_descriptor (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		g_hash_table_remove (_tmp11_, _tmp15_);
		_g_free0 (_tmp15_);
	}
	_tmp17_ = self->priv->mode;
	if (_tmp17_ != MODIFICATIONS_REVEALER_MODE_TEMPORARY) {
		GHashTable* _tmp18_;
		guint _tmp19_;
		guint _tmp20_;
		GHashTable* _tmp21_;
		guint _tmp22_;
		guint _tmp23_;
		_tmp18_ = self->priv->dconf_keys_awaiting_hashtable;
		_tmp19_ = g_hash_table_size (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->gsettings_keys_awaiting_hashtable;
		_tmp22_ = g_hash_table_size (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp16_ = (_tmp20_ + _tmp23_) != ((guint) 0);
	} else {
		_tmp16_ = FALSE;
	}
	_tmp24_ = self->priv->apply_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp24_, _tmp16_);
	modifications_revealer_update (self);
}


void modifications_revealer_path_changed (ModificationsRevealer* self) {
	ModificationsRevealerMode _tmp0_;
	gboolean _tmp1_ = FALSE;
	Behaviour _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mode;
	if (_tmp0_ != MODIFICATIONS_REVEALER_MODE_TEMPORARY) {
		return;
	}
	_tmp2_ = self->priv->_behaviour;
	if (_tmp2_ == BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT) {
		_tmp1_ = TRUE;
	} else {
		Behaviour _tmp3_;
		_tmp3_ = self->priv->_behaviour;
		_tmp1_ = _tmp3_ == BEHAVIOUR_SAFE;
	}
	if (_tmp1_) {
		modifications_revealer_apply_delayed_settings (self);
	} else {
		Behaviour _tmp4_;
		_tmp4_ = self->priv->_behaviour;
		if (_tmp4_ == BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT) {
			modifications_revealer_dismiss_delayed_settings (self);
		} else {
			g_assert_not_reached ();
		}
	}
}


void modifications_revealer_warn_if_no_planned_changes (ModificationsRevealer* self) {
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->dconf_keys_awaiting_hashtable;
	_tmp2_ = g_hash_table_size (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == ((guint) 0)) {
		GHashTable* _tmp4_;
		guint _tmp5_;
		guint _tmp6_;
		_tmp4_ = self->priv->gsettings_keys_awaiting_hashtable;
		_tmp5_ = g_hash_table_size (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkLabel* _tmp7_;
		_tmp7_ = self->priv->label;
		gtk_label_set_text (_tmp7_, _ ("Nothing to reset."));
	}
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}


static void block17_data_unref (void * _userdata_) {
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		ModificationsRevealer* self;
		self = _data17_->self;
		_dconf_changeset_unref0 (_data17_->dconf_changeset);
		_g_hash_table_unref0 (_data17_->delayed_settings_hashtable);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}


static gboolean __lambda18_ (Block17Data* _data17_, const gchar* descriptor, GSettingsKey* key) {
	ModificationsRevealer* self;
	gboolean result = FALSE;
	GSettings* settings = NULL;
	GSettingsKey* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettingsKey* _tmp17_;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	GSettingsKey* _tmp31_;
	self = _data17_->self;
	g_return_val_if_fail (descriptor != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = key;
	_tmp1_ = gsettings_key_get_schema_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_hash_table_lookup (_data17_->delayed_settings_hashtable, _tmp2_);
	_tmp4_ = _g_object_ref0 ((GSettings*) _tmp3_);
	settings = _tmp4_;
	_tmp5_ = settings;
	if (_tmp5_ == NULL) {
		GSettingsKey* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GSettings* _tmp9_;
		GSettings* _tmp10_;
		GSettingsKey* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		GSettings* _tmp15_;
		GSettings* _tmp16_;
		_tmp6_ = key;
		_tmp7_ = gsettings_key_get_schema_id (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_settings_new (_tmp8_);
		_g_object_unref0 (settings);
		settings = _tmp9_;
		_tmp10_ = settings;
		g_settings_delay (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_settings_get_type (), GSettings));
		_tmp11_ = key;
		_tmp12_ = gsettings_key_get_schema_id (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup (_tmp13_);
		_tmp15_ = settings;
		_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_settings_get_type (), GSettings));
		g_hash_table_insert (_data17_->delayed_settings_hashtable, _tmp14_, _tmp16_);
	}
	_tmp17_ = key;
	_tmp18_ = key_get_planned_value ((Key*) _tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ == NULL) {
		GSettings* _tmp20_;
		GSettingsKey* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp20_ = settings;
		_tmp21_ = key;
		_tmp22_ = setting_object_get_name ((SettingObject*) _tmp21_);
		_tmp23_ = _tmp22_;
		g_settings_reset (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, g_settings_get_type (), GSettings), _tmp23_);
	} else {
		GSettings* _tmp24_;
		GSettingsKey* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		GSettingsKey* _tmp28_;
		GVariant* _tmp29_;
		GVariant* _tmp30_;
		_tmp24_ = settings;
		_tmp25_ = key;
		_tmp26_ = setting_object_get_name ((SettingObject*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = key;
		_tmp29_ = key_get_planned_value ((Key*) _tmp28_);
		_tmp30_ = _tmp29_;
		g_settings_set_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, g_settings_get_type (), GSettings), _tmp27_, (GVariant*) _tmp30_);
	}
	_tmp31_ = key;
	key_set_planned_change ((Key*) _tmp31_, FALSE);
	result = TRUE;
	_g_object_unref0 (settings);
	return result;
}


static gboolean ___lambda18__ghr_func (gconstpointer key, gconstpointer value, gpointer self) {
	gboolean result;
	result = __lambda18_ (self, (const gchar*) key, (GSettingsKey*) value);
	return result;
}


static gboolean __lambda19_ (ModificationsRevealer* self, const gchar* schema_id, GSettings* schema_settings) {
	gboolean result = FALSE;
	GSettings* _tmp0_;
	g_return_val_if_fail (schema_id != NULL, FALSE);
	g_return_val_if_fail (schema_settings != NULL, FALSE);
	_tmp0_ = schema_settings;
	g_settings_apply (_tmp0_);
	result = TRUE;
	return result;
}


static gboolean ___lambda19__ghr_func (gconstpointer key, gconstpointer value, gpointer self) {
	gboolean result;
	result = __lambda19_ ((ModificationsRevealer*) self, (const gchar*) key, (GSettings*) value);
	return result;
}


static gboolean __lambda20_ (Block17Data* _data17_, const gchar* descriptor, DConfKey* key) {
	ModificationsRevealer* self;
	gboolean result = FALSE;
	DConfKey* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	DConfKey* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	DConfKey* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	DConfKey* _tmp10_;
	self = _data17_->self;
	g_return_val_if_fail (descriptor != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = key;
	_tmp1_ = setting_object_get_full_name ((SettingObject*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = key;
	_tmp4_ = key_get_planned_value ((Key*) _tmp3_);
	_tmp5_ = _tmp4_;
	dconf_changeset_set (_data17_->dconf_changeset, _tmp2_, _tmp5_);
	_tmp6_ = key;
	_tmp7_ = key_get_planned_value ((Key*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == NULL) {
		DConfKey* _tmp9_;
		_tmp9_ = key;
		dconf_key_set_is_ghost (_tmp9_, TRUE);
	}
	_tmp10_ = key;
	key_set_planned_change ((Key*) _tmp10_, FALSE);
	result = TRUE;
	return result;
}


static gboolean ___lambda20__ghr_func (gconstpointer key, gconstpointer value, gpointer self) {
	gboolean result;
	result = __lambda20_ (self, (const gchar*) key, (DConfKey*) value);
	return result;
}


void modifications_revealer_apply_delayed_settings (ModificationsRevealer* self) {
	Block17Data* _data17_;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	DConfChangeset* _tmp4_;
	GHashTable* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	self->priv->mode = MODIFICATIONS_REVEALER_MODE_NONE;
	modifications_revealer_update (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_data17_->delayed_settings_hashtable = _tmp2_;
	_tmp3_ = self->priv->gsettings_keys_awaiting_hashtable;
	g_hash_table_foreach_remove (_tmp3_, ___lambda18__ghr_func, _data17_);
	g_hash_table_foreach_remove (_data17_->delayed_settings_hashtable, ___lambda19__ghr_func, self);
	_tmp4_ = dconf_changeset_new ();
	_data17_->dconf_changeset = _tmp4_;
	_tmp5_ = self->priv->dconf_keys_awaiting_hashtable;
	g_hash_table_foreach_remove (_tmp5_, ___lambda20__ghr_func, _data17_);
	{
		DConfClient* _tmp6_;
		_tmp6_ = self->priv->dconf_client;
		dconf_client_change_sync (_tmp6_, _data17_->dconf_changeset, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_warning ("modifications-revealer.vala:193: %s", _tmp8_);
		_g_error_free0 (_error_);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		block17_data_unref (_data17_);
		_data17_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_signal_emit (self, modifications_revealer_signals[MODIFICATIONS_REVEALER_RELOAD_SIGNAL], 0);
	block17_data_unref (_data17_);
	_data17_ = NULL;
}


static void _modifications_revealer_apply_delayed_settings_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	modifications_revealer_apply_delayed_settings ((ModificationsRevealer*) self);
}


static gboolean __lambda21_ (ModificationsRevealer* self, const gchar* descriptor, GSettingsKey* key) {
	gboolean result = FALSE;
	GSettingsKey* _tmp0_;
	g_return_val_if_fail (descriptor != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = key;
	key_set_planned_change ((Key*) _tmp0_, FALSE);
	result = TRUE;
	return result;
}


static gboolean ___lambda21__ghr_func (gconstpointer key, gconstpointer value, gpointer self) {
	gboolean result;
	result = __lambda21_ ((ModificationsRevealer*) self, (const gchar*) key, (GSettingsKey*) value);
	return result;
}


static gboolean __lambda22_ (ModificationsRevealer* self, const gchar* descriptor, DConfKey* key) {
	gboolean result = FALSE;
	DConfKey* _tmp0_;
	g_return_val_if_fail (descriptor != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = key;
	key_set_planned_change ((Key*) _tmp0_, FALSE);
	result = TRUE;
	return result;
}


static gboolean ___lambda22__ghr_func (gconstpointer key, gconstpointer value, gpointer self) {
	gboolean result;
	result = __lambda22_ ((ModificationsRevealer*) self, (const gchar*) key, (DConfKey*) value);
	return result;
}


static void modifications_revealer_dismiss_delayed_settings (ModificationsRevealer* self) {
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->mode = MODIFICATIONS_REVEALER_MODE_NONE;
	modifications_revealer_update (self);
	_tmp0_ = self->priv->gsettings_keys_awaiting_hashtable;
	g_hash_table_foreach_remove (_tmp0_, ___lambda21__ghr_func, self);
	_tmp1_ = self->priv->dconf_keys_awaiting_hashtable;
	g_hash_table_foreach_remove (_tmp1_, ___lambda22__ghr_func, self);
	g_signal_emit (self, modifications_revealer_signals[MODIFICATIONS_REVEALER_RELOAD_SIGNAL], 0);
}


static void _modifications_revealer_dismiss_delayed_settings_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	modifications_revealer_dismiss_delayed_settings ((ModificationsRevealer*) self);
}


static void modifications_revealer_update (ModificationsRevealer* self) {
	ModificationsRevealerMode _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mode;
	if (_tmp0_ == MODIFICATIONS_REVEALER_MODE_NONE) {
		GtkLabel* _tmp1_;
		gtk_revealer_set_reveal_child ((GtkRevealer*) self, FALSE);
		_tmp1_ = self->priv->label;
		gtk_label_set_text (_tmp1_, "");
	} else {
		ModificationsRevealerMode _tmp2_;
		_tmp2_ = self->priv->mode;
		if (_tmp2_ == MODIFICATIONS_REVEALER_MODE_TEMPORARY) {
			guint length = 0U;
			GHashTable* _tmp3_;
			guint _tmp4_;
			guint _tmp5_;
			GHashTable* _tmp6_;
			guint _tmp7_;
			guint _tmp8_;
			guint _tmp9_;
			_tmp3_ = self->priv->dconf_keys_awaiting_hashtable;
			_tmp4_ = g_hash_table_size (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = self->priv->gsettings_keys_awaiting_hashtable;
			_tmp7_ = g_hash_table_size (_tmp6_);
			_tmp8_ = _tmp7_;
			length = _tmp5_ + _tmp8_;
			_tmp9_ = length;
			if (_tmp9_ == ((guint) 0)) {
				GtkLabel* _tmp10_;
				_tmp10_ = self->priv->label;
				gtk_label_set_text (_tmp10_, _ ("The value is invalid."));
			} else {
				guint _tmp11_;
				_tmp11_ = length;
				if (_tmp11_ != ((guint) 1)) {
					g_assert_not_reached ();
				} else {
					Behaviour _tmp12_;
					_tmp12_ = self->priv->_behaviour;
					if (_tmp12_ == BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT) {
						GtkLabel* _tmp13_;
						_tmp13_ = self->priv->label;
						gtk_label_set_text (_tmp13_, _ ("The change will be dismissed if you quit this view without applying."));
					} else {
						gboolean _tmp14_ = FALSE;
						Behaviour _tmp15_;
						_tmp15_ = self->priv->_behaviour;
						if (_tmp15_ == BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT) {
							_tmp14_ = TRUE;
						} else {
							Behaviour _tmp16_;
							_tmp16_ = self->priv->_behaviour;
							_tmp14_ = _tmp16_ == BEHAVIOUR_SAFE;
						}
						if (_tmp14_) {
							GtkLabel* _tmp17_;
							_tmp17_ = self->priv->label;
							gtk_label_set_text (_tmp17_, _ ("The change will be applied on such request or if you quit this view."));
						} else {
							g_assert_not_reached ();
						}
					}
				}
			}
			gtk_revealer_set_reveal_child ((GtkRevealer*) self, TRUE);
		} else {
			GtkLabel* _tmp18_;
			GHashTable* _tmp19_;
			guint _tmp20_;
			guint _tmp21_;
			GHashTable* _tmp22_;
			guint _tmp23_;
			guint _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp18_ = self->priv->label;
			_tmp19_ = self->priv->dconf_keys_awaiting_hashtable;
			_tmp20_ = g_hash_table_size (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = self->priv->gsettings_keys_awaiting_hashtable;
			_tmp23_ = g_hash_table_size (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = modifications_revealer_get_text (_tmp21_, _tmp24_);
			_tmp26_ = _tmp25_;
			gtk_label_set_text (_tmp18_, _tmp26_);
			_g_free0 (_tmp26_);
			gtk_revealer_set_reveal_child ((GtkRevealer*) self, TRUE);
		}
	}
}


static gchar* modifications_revealer_get_text (guint dconf, guint gsettings) {
	gchar* result = NULL;
	guint _tmp0_;
	guint _tmp6_;
	guint _tmp10_;
	guint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	guint _tmp14_;
	guint _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	_tmp0_ = dconf;
	if (_tmp0_ == ((guint) 0)) {
		guint _tmp1_;
		guint _tmp3_;
		guint _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = gsettings;
		if (_tmp1_ == ((guint) 0)) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Changes will be delayed until you request it."));
			result = _tmp2_;
			return result;
		}
		_tmp3_ = gsettings;
		_tmp4_ = gsettings;
		_tmp5_ = g_strdup_printf (ngettext ("One gsettings operation delayed.", "%u gsettings operations delayed.", (gulong) _tmp3_), _tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = gsettings;
	if (_tmp6_ == ((guint) 0)) {
		guint _tmp7_;
		guint _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = dconf;
		_tmp8_ = dconf;
		_tmp9_ = g_strdup_printf (ngettext ("One dconf operation delayed.", "%u dconf operations delayed.", (gulong) _tmp7_), _tmp8_);
		result = _tmp9_;
		return result;
	}
	_tmp10_ = gsettings;
	_tmp11_ = gsettings;
	_tmp12_ = g_strdup_printf (ngettext ("One gsettings operation", "%u gsettings operations", (gulong) _tmp10_), _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = dconf;
	_tmp15_ = dconf;
	_tmp16_ = g_strdup_printf (ngettext (" and one dconf operation delayed.", " and %u dconf operations delayed.", (gulong) _tmp14_), _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strdup_printf (_ ("%s%s"), _tmp13_, _tmp17_);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_);
	_g_free0 (_tmp13_);
	result = _tmp19_;
	return result;
}


ModificationsRevealer* modifications_revealer_construct (GType object_type) {
	ModificationsRevealer * self = NULL;
	self = (ModificationsRevealer*) g_object_new (object_type, NULL);
	return self;
}


ModificationsRevealer* modifications_revealer_new (void) {
	return modifications_revealer_construct (TYPE_MODIFICATIONS_REVEALER);
}


Behaviour modifications_revealer_get_behaviour (ModificationsRevealer* self) {
	Behaviour result;
	Behaviour _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_behaviour;
	result = _tmp0_;
	return result;
}


void modifications_revealer_set_behaviour (ModificationsRevealer* self, Behaviour value) {
	g_return_if_fail (self != NULL);
	if (modifications_revealer_get_behaviour (self) != value) {
		Behaviour _tmp0_;
		_tmp0_ = value;
		self->priv->_behaviour = _tmp0_;
		g_object_notify ((GObject *) self, "behaviour");
	}
}


static void modifications_revealer_class_init (ModificationsRevealerClass * klass) {
	gint ModificationsRevealer_private_offset;
	modifications_revealer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ModificationsRevealerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_modifications_revealer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_modifications_revealer_set_property;
	G_OBJECT_CLASS (klass)->finalize = modifications_revealer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MODIFICATIONS_REVEALER_BEHAVIOUR_PROPERTY, g_param_spec_enum ("behaviour", "behaviour", "behaviour", TYPE_BEHAVIOUR, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	ModificationsRevealer_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/modifications-revealer.ui");
	modifications_revealer_signals[MODIFICATIONS_REVEALER_RELOAD_SIGNAL] = g_signal_new ("reload", TYPE_MODIFICATIONS_REVEALER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label", FALSE, ModificationsRevealer_private_offset + G_STRUCT_OFFSET (ModificationsRevealerPrivate, label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "apply_button", FALSE, ModificationsRevealer_private_offset + G_STRUCT_OFFSET (ModificationsRevealerPrivate, apply_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_size_allocate", G_CALLBACK(_modifications_revealer_on_size_allocate_gtk_widget_size_allocate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "apply_delayed_settings", G_CALLBACK(_modifications_revealer_apply_delayed_settings_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "dismiss_delayed_settings", G_CALLBACK(_modifications_revealer_dismiss_delayed_settings_gtk_button_clicked));
}


static void modifications_revealer_instance_init (ModificationsRevealer * self) {
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GThemedIcon* _tmp3_;
	DConfClient* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	GHashFunc _tmp8_;
	GEqualFunc _tmp9_;
	GHashTable* _tmp10_;
	self->priv = MODIFICATIONS_REVEALER_GET_PRIVATE (self);
	self->priv->mode = MODIFICATIONS_REVEALER_MODE_NONE;
	_tmp0_ = g_strdup ("object-select-symbolic");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	_tmp3_ = (GThemedIcon*) g_themed_icon_new_from_names (_tmp2_, 1);
	self->priv->apply_button_icon = _tmp3_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_tmp4_ = dconf_client_new ();
	self->priv->dconf_client = _tmp4_;
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_object_unref0_);
	self->priv->dconf_keys_awaiting_hashtable = _tmp7_;
	_tmp8_ = g_str_hash;
	_tmp9_ = g_str_equal;
	_tmp10_ = g_hash_table_new_full (_tmp8_, _tmp9_, _g_free0_, _g_object_unref0_);
	self->priv->gsettings_keys_awaiting_hashtable = _tmp10_;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void modifications_revealer_finalize (GObject * obj) {
	ModificationsRevealer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MODIFICATIONS_REVEALER, ModificationsRevealer);
	_g_object_unref0 (self->priv->label);
	_g_object_unref0 (self->priv->apply_button);
	_g_object_unref0 (self->priv->apply_button_icon);
	_g_object_unref0 (self->priv->dconf_client);
	_g_hash_table_unref0 (self->priv->dconf_keys_awaiting_hashtable);
	_g_hash_table_unref0 (self->priv->gsettings_keys_awaiting_hashtable);
	G_OBJECT_CLASS (modifications_revealer_parent_class)->finalize (obj);
}


GType modifications_revealer_get_type (void) {
	static volatile gsize modifications_revealer_type_id__volatile = 0;
	if (g_once_init_enter (&modifications_revealer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ModificationsRevealerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) modifications_revealer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ModificationsRevealer), 0, (GInstanceInitFunc) modifications_revealer_instance_init, NULL };
		GType modifications_revealer_type_id;
		modifications_revealer_type_id = g_type_register_static (gtk_revealer_get_type (), "ModificationsRevealer", &g_define_type_info, 0);
		g_once_init_leave (&modifications_revealer_type_id__volatile, modifications_revealer_type_id);
	}
	return modifications_revealer_type_id__volatile;
}


static void _vala_modifications_revealer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ModificationsRevealer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MODIFICATIONS_REVEALER, ModificationsRevealer);
	switch (property_id) {
		case MODIFICATIONS_REVEALER_BEHAVIOUR_PROPERTY:
		g_value_set_enum (value, modifications_revealer_get_behaviour (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_modifications_revealer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ModificationsRevealer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MODIFICATIONS_REVEALER, ModificationsRevealer);
	switch (property_id) {
		case MODIFICATIONS_REVEALER_BEHAVIOUR_PROPERTY:
		modifications_revealer_set_behaviour (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



