/* source-expandable-group.c generated by valac 0.10.0, the Vala compiler
 * generated from source-expandable-group.vala, do not modify */

/*
 * Copyright (c) 2010, Nate Stedman <natesm@gmail.com>
 * 
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define SOURCE_TYPE_BASE_GROUP (source_base_group_get_type ())
#define SOURCE_BASE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOURCE_TYPE_BASE_GROUP, SourceBaseGroup))
#define SOURCE_BASE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOURCE_TYPE_BASE_GROUP, SourceBaseGroupClass))
#define SOURCE_IS_BASE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOURCE_TYPE_BASE_GROUP))
#define SOURCE_IS_BASE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOURCE_TYPE_BASE_GROUP))
#define SOURCE_BASE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOURCE_TYPE_BASE_GROUP, SourceBaseGroupClass))

typedef struct _SourceBaseGroup SourceBaseGroup;
typedef struct _SourceBaseGroupClass SourceBaseGroupClass;
typedef struct _SourceBaseGroupPrivate SourceBaseGroupPrivate;

#define SOURCE_TYPE_EXPANDABLE_GROUP (source_expandable_group_get_type ())
#define SOURCE_EXPANDABLE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOURCE_TYPE_EXPANDABLE_GROUP, SourceExpandableGroup))
#define SOURCE_EXPANDABLE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOURCE_TYPE_EXPANDABLE_GROUP, SourceExpandableGroupClass))
#define SOURCE_IS_EXPANDABLE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOURCE_TYPE_EXPANDABLE_GROUP))
#define SOURCE_IS_EXPANDABLE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOURCE_TYPE_EXPANDABLE_GROUP))
#define SOURCE_EXPANDABLE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOURCE_TYPE_EXPANDABLE_GROUP, SourceExpandableGroupClass))

typedef struct _SourceExpandableGroup SourceExpandableGroup;
typedef struct _SourceExpandableGroupClass SourceExpandableGroupClass;
typedef struct _SourceExpandableGroupPrivate SourceExpandableGroupPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _SourceBaseGroup {
	GtkAlignment parent_instance;
	SourceBaseGroupPrivate * priv;
	GtkAlignment* header_align;
	GtkAlignment* items_align;
};

struct _SourceBaseGroupClass {
	GtkAlignmentClass parent_class;
};

struct _SourceExpandableGroup {
	SourceBaseGroup parent_instance;
	SourceExpandableGroupPrivate * priv;
};

struct _SourceExpandableGroupClass {
	SourceBaseGroupClass parent_class;
};

struct _SourceExpandableGroupPrivate {
	GtkExpander* expander;
};


static gpointer source_expandable_group_parent_class = NULL;

GType source_base_group_get_type (void) G_GNUC_CONST;
GType source_expandable_group_get_type (void) G_GNUC_CONST;
#define SOURCE_EXPANDABLE_GROUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SOURCE_TYPE_EXPANDABLE_GROUP, SourceExpandableGroupPrivate))
enum  {
	SOURCE_EXPANDABLE_GROUP_DUMMY_PROPERTY,
	SOURCE_EXPANDABLE_GROUP_EXPANDED
};
SourceExpandableGroup* source_expandable_group_new (const char* title, gboolean expanded);
SourceExpandableGroup* source_expandable_group_construct (GType object_type, const char* title, gboolean expanded);
SourceBaseGroup* source_base_group_construct (GType object_type, const char* title);
gboolean source_expandable_group_get_expanded (SourceExpandableGroup* self);
void source_expandable_group_set_expanded (SourceExpandableGroup* self, gboolean value);
static void source_expandable_group_finalize (GObject* obj);
static void source_expandable_group_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void source_expandable_group_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



/**
 * Create a new, empty, Source.ExpandableGroup.
 *
 * @param title The header of the Source.Group.
 * @param expanded If the group should be expanded by default.
 */
#line 47 "source-expandable-group.vala"
SourceExpandableGroup* source_expandable_group_construct (GType object_type, const char* title, gboolean expanded) {
#line 104 "source-expandable-group.c"
	SourceExpandableGroup * self;
#line 47 "source-expandable-group.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 49 "source-expandable-group.vala"
	self = (SourceExpandableGroup*) source_base_group_construct (object_type, title);
#line 51 "source-expandable-group.vala"
	gtk_expander_set_label_widget (self->priv->expander, (GtkWidget*) ((SourceBaseGroup*) self)->header_align);
#line 52 "source-expandable-group.vala"
	g_object_set ((GtkWidget*) self->priv->expander, "can-focus", FALSE, NULL);
#line 53 "source-expandable-group.vala"
	gtk_expander_set_expanded (self->priv->expander, expanded);
#line 54 "source-expandable-group.vala"
	gtk_container_add ((GtkContainer*) self->priv->expander, (GtkWidget*) ((SourceBaseGroup*) self)->items_align);
#line 55 "source-expandable-group.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->expander);
#line 120 "source-expandable-group.c"
	return self;
}


#line 47 "source-expandable-group.vala"
SourceExpandableGroup* source_expandable_group_new (const char* title, gboolean expanded) {
#line 47 "source-expandable-group.vala"
	return source_expandable_group_construct (SOURCE_TYPE_EXPANDABLE_GROUP, title, expanded);
#line 129 "source-expandable-group.c"
}


gboolean source_expandable_group_get_expanded (SourceExpandableGroup* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = gtk_expander_get_expanded (self->priv->expander);
#line 37 "source-expandable-group.vala"
	return result;
#line 139 "source-expandable-group.c"
}


void source_expandable_group_set_expanded (SourceExpandableGroup* self, gboolean value) {
	g_return_if_fail (self != NULL);
#line 38 "source-expandable-group.vala"
	gtk_expander_set_expanded (self->priv->expander, value);
#line 147 "source-expandable-group.c"
	g_object_notify ((GObject *) self, "expanded");
}


static void source_expandable_group_class_init (SourceExpandableGroupClass * klass) {
	source_expandable_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SourceExpandableGroupPrivate));
	G_OBJECT_CLASS (klass)->get_property = source_expandable_group_get_property;
	G_OBJECT_CLASS (klass)->set_property = source_expandable_group_set_property;
	G_OBJECT_CLASS (klass)->finalize = source_expandable_group_finalize;
	/**
	 * If the ExpandableGroup's expander is expanded.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOURCE_EXPANDABLE_GROUP_EXPANDED, g_param_spec_boolean ("expanded", "expanded", "expanded", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void source_expandable_group_instance_init (SourceExpandableGroup * self) {
	self->priv = SOURCE_EXPANDABLE_GROUP_GET_PRIVATE (self);
	self->priv->expander = g_object_ref_sink ((GtkExpander*) gtk_expander_new (""));
}


static void source_expandable_group_finalize (GObject* obj) {
	SourceExpandableGroup * self;
	self = SOURCE_EXPANDABLE_GROUP (obj);
	_g_object_unref0 (self->priv->expander);
	G_OBJECT_CLASS (source_expandable_group_parent_class)->finalize (obj);
}


/**
 * An expandable group in a {@link Source.List}.
 *
 * Source.ExpandableGroup can contain any amount of {@link Source.Item}s.
 * Above these items, a header is shown in order to categorize a
 * {@link Source.List}. Unlike {@link Source.Group}, which is VBox based,
 * ExpandableGroup can be expanded and contracted.
 */
GType source_expandable_group_get_type (void) {
	static volatile gsize source_expandable_group_type_id__volatile = 0;
	if (g_once_init_enter (&source_expandable_group_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SourceExpandableGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_expandable_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceExpandableGroup), 0, (GInstanceInitFunc) source_expandable_group_instance_init, NULL };
		GType source_expandable_group_type_id;
		source_expandable_group_type_id = g_type_register_static (SOURCE_TYPE_BASE_GROUP, "SourceExpandableGroup", &g_define_type_info, 0);
		g_once_init_leave (&source_expandable_group_type_id__volatile, source_expandable_group_type_id);
	}
	return source_expandable_group_type_id__volatile;
}


static void source_expandable_group_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SourceExpandableGroup * self;
	self = SOURCE_EXPANDABLE_GROUP (object);
	switch (property_id) {
		case SOURCE_EXPANDABLE_GROUP_EXPANDED:
		g_value_set_boolean (value, source_expandable_group_get_expanded (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void source_expandable_group_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SourceExpandableGroup * self;
	self = SOURCE_EXPANDABLE_GROUP (object);
	switch (property_id) {
		case SOURCE_EXPANDABLE_GROUP_EXPANDED:
		source_expandable_group_set_expanded (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




