/* source-item.c generated by valac 0.10.0, the Vala compiler
 * generated from source-item.vala, do not modify */

/*
 * Copyright (c) 2010, Nate Stedman <natesm@gmail.com>
 * 
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define SOURCE_TYPE_ITEM (source_item_get_type ())
#define SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOURCE_TYPE_ITEM, SourceItem))
#define SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOURCE_TYPE_ITEM, SourceItemClass))
#define SOURCE_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOURCE_TYPE_ITEM))
#define SOURCE_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOURCE_TYPE_ITEM))
#define SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOURCE_TYPE_ITEM, SourceItemClass))

typedef struct _SourceItem SourceItem;
typedef struct _SourceItemClass SourceItemClass;
typedef struct _SourceItemPrivate SourceItemPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SourceItem {
	GtkHBox parent_instance;
	SourceItemPrivate * priv;
	GtkAlignment* right_align;
	GtkWidget* widget;
};

struct _SourceItemClass {
	GtkHBoxClass parent_class;
};

struct _SourceItemPrivate {
	GtkImage* image;
	GtkLabel* label;
	GtkButton* button;
	char* label_text;
};


static gpointer source_item_parent_class = NULL;

GType source_item_get_type (void) G_GNUC_CONST;
#define SOURCE_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SOURCE_TYPE_ITEM, SourceItemPrivate))
enum  {
	SOURCE_ITEM_DUMMY_PROPERTY,
	SOURCE_ITEM_SELECTED
};
#define SOURCE_ITEM_ICON_SIZE GTK_ICON_SIZE_MENU
#define SOURCE_ITEM_HBOX_PADDING 2
#define SOURCE_ITEM_FORMAT_SELECTED "<b>%s</b>"
#define SOURCE_ITEM_FORMAT_DESELECTED "%s"
#define SOURCE_ITEM_FORMAT_RIGHT_NEW "<small><b>%i</b></small>"
#define SOURCE_ITEM_FORMAT_RIGHT_OLD "<small><b>%i</b></small>"
#define SOURCE_ITEM_ITEM_PADDING 5
#define SOURCE_ITEM_LABEL_VERT_ALIGN 0.6f
#define SOURCE_ITEM_RELIEF_SELECTED GTK_RELIEF_NORMAL
#define SOURCE_ITEM_RELIEF_DESELECTED GTK_RELIEF_NONE
SourceItem* source_item_new (const char* text, GtkImage* img, GtkWidget* widg);
SourceItem* source_item_construct (GType object_type, const char* text, GtkImage* img, GtkWidget* widg);
void source_item_set_selected (SourceItem* self, gboolean value);
static void _lambda77_ (SourceItem* self);
gboolean source_item_get_selected (SourceItem* self);
static void __lambda77__gtk_button_clicked (GtkButton* _sender, gpointer self);
SourceItem* source_item_new_from_stock_icon (const char* text, const char* item, GtkWidget* widg);
SourceItem* source_item_construct_from_stock_icon (GType object_type, const char* text, const char* item, GtkWidget* widg);
SourceItem* source_item_new_from_stock_text (const char* item, GtkImage* img, GtkWidget* widg);
SourceItem* source_item_construct_from_stock_text (GType object_type, const char* item, GtkImage* img, GtkWidget* widg);
SourceItem* source_item_new_from_stock (const char* item, GtkWidget* widg);
SourceItem* source_item_construct_from_stock (GType object_type, const char* item, GtkWidget* widg);
void source_item_select (SourceItem* self);
static void source_item_finalize (GObject* obj);
static void source_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void source_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



/**
 * Creates a Source.Item with a customizable icon and text.
 *
 * @param text The text to display in the source item.
 * @param img The image widget to use (note that this icon should use
 * the Gtk.IconSize constant ICON_SIZE to fit in with other items).
 * @param widg The widget that this Source.Item should be linked with.
 * If null, this Source.Item will only emit the clicked signal when 
 * clicked, without any automatic UI changes.
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 183 "source-item.vala"
static void _lambda77_ (SourceItem* self) {
#line 184 "source-item.vala"
	if (!source_item_get_selected (self)) {
#line 186 "source-item.vala"
		g_signal_emit_by_name (self, "clicked", self);
#line 122 "source-item.c"
	}
}


#line 183 "source-item.vala"
static void __lambda77__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 129 "source-item.c"
	_lambda77_ (self);
}


#line 150 "source-item.vala"
SourceItem* source_item_construct (GType object_type, const char* text, GtkImage* img, GtkWidget* widg) {
#line 136 "source-item.c"
	SourceItem * self;
	char* _tmp0_;
	GtkWidget* _tmp1_;
	GtkImage* _tmp2_;
	char* _tmp3_;
	GtkLabel* _tmp4_;
	GtkButton* _tmp5_;
	GtkAlignment* label_align;
	GtkAlignment* _tmp6_;
	GtkAlignment* image_align;
	GtkHBox* hbox;
	GtkAlignment* _tmp7_;
#line 150 "source-item.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 150 "source-item.vala"
	g_return_val_if_fail (img != NULL, NULL);
#line 153 "source-item.c"
	self = g_object_newv (object_type, 0, NULL);
#line 153 "source-item.vala"
	gtk_box_set_homogeneous ((GtkBox*) self, FALSE);
#line 154 "source-item.vala"
	self->priv->label_text = (_tmp0_ = g_strdup (text), _g_free0 (self->priv->label_text), _tmp0_);
#line 155 "source-item.vala"
	self->widget = (_tmp1_ = _g_object_ref0 (widg), _g_object_unref0 (self->widget), _tmp1_);
#line 158 "source-item.vala"
	self->priv->image = (_tmp2_ = _g_object_ref0 (img), _g_object_unref0 (self->priv->image), _tmp2_);
#line 159 "source-item.vala"
	self->priv->label = (_tmp4_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp3_ = g_strdup_printf (SOURCE_ITEM_FORMAT_DESELECTED, text))), _g_object_unref0 (self->priv->label), _tmp4_);
#line 165 "source-item.c"
	_g_free0 (_tmp3_);
#line 160 "source-item.vala"
	gtk_label_set_use_markup (self->priv->label, TRUE);
#line 161 "source-item.vala"
	self->priv->button = (_tmp5_ = g_object_ref_sink ((GtkButton*) gtk_button_new ()), _g_object_unref0 (self->priv->button), _tmp5_);
#line 162 "source-item.vala"
	g_object_set ((GtkWidget*) self->priv->button, "can-focus", FALSE, NULL);
#line 163 "source-item.vala"
	source_item_set_selected (self, FALSE);
#line 164 "source-item.vala"
	label_align = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, SOURCE_ITEM_LABEL_VERT_ALIGN, (float) 0, (float) 0));
#line 165 "source-item.vala"
	gtk_alignment_set_padding (label_align, (guint) 0, (guint) 0, (guint) SOURCE_ITEM_ITEM_PADDING, (guint) SOURCE_ITEM_ITEM_PADDING);
#line 166 "source-item.vala"
	self->right_align = (_tmp6_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 1, SOURCE_ITEM_LABEL_VERT_ALIGN, (float) 1, (float) 1)), _g_object_unref0 (self->right_align), _tmp6_);
#line 167 "source-item.vala"
	image_align = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, (float) 0, (float) 1));
#line 168 "source-item.vala"
	gtk_alignment_set_padding (image_align, (guint) 0, (guint) 0, (guint) SOURCE_ITEM_ITEM_PADDING, (guint) 0);
#line 171 "source-item.vala"
	gtk_container_add ((GtkContainer*) label_align, (GtkWidget*) self->priv->label);
#line 172 "source-item.vala"
	gtk_container_add ((GtkContainer*) image_align, (GtkWidget*) self->priv->image);
#line 173 "source-item.vala"
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, SOURCE_ITEM_HBOX_PADDING));
#line 174 "source-item.vala"
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) image_align, FALSE, FALSE, (guint) 0);
#line 175 "source-item.vala"
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label_align, TRUE, TRUE, (guint) 0);
#line 176 "source-item.vala"
	gtk_container_add ((GtkContainer*) self->priv->button, (GtkWidget*) hbox);
#line 178 "source-item.vala"
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->button, FALSE, FALSE, (guint) 0);
#line 179 "source-item.vala"
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) (_tmp7_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 1, (float) 1, (float) 0, (float) 0))), TRUE, TRUE, (guint) 0);
#line 201 "source-item.c"
	_g_object_unref0 (_tmp7_);
#line 180 "source-item.vala"
	gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) self->right_align, FALSE, FALSE, (guint) 0);
#line 183 "source-item.vala"
	g_signal_connect_object (self->priv->button, "clicked", (GCallback) __lambda77__gtk_button_clicked, self, 0);
#line 207 "source-item.c"
	_g_object_unref0 (hbox);
	_g_object_unref0 (image_align);
	_g_object_unref0 (label_align);
	return self;
}


#line 150 "source-item.vala"
SourceItem* source_item_new (const char* text, GtkImage* img, GtkWidget* widg) {
#line 150 "source-item.vala"
	return source_item_construct (SOURCE_TYPE_ITEM, text, img, widg);
#line 219 "source-item.c"
}


/**
 * Creates a Source.Item with a stock icon and customizable text.
 *
 * @param text The text to display in the source item.
 * @param item The stock item to take the icon from.
 * @param widg The widget that this Source.Item should be linked with.
 * If null, this Source.Item will only emit the clicked signal when 
 * clicked, without any automatic UI changes.
 */
#line 200 "source-item.vala"
SourceItem* source_item_construct_from_stock_icon (GType object_type, const char* text, const char* item, GtkWidget* widg) {
#line 234 "source-item.c"
	SourceItem * self;
	GtkImage* _tmp0_;
#line 200 "source-item.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 200 "source-item.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 202 "source-item.vala"
	self = (SourceItem*) source_item_construct (object_type, text, _tmp0_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (item, SOURCE_ITEM_ICON_SIZE)), widg);
#line 243 "source-item.c"
	_g_object_unref0 (_tmp0_);
	return self;
}


#line 200 "source-item.vala"
SourceItem* source_item_new_from_stock_icon (const char* text, const char* item, GtkWidget* widg) {
#line 200 "source-item.vala"
	return source_item_construct_from_stock_icon (SOURCE_TYPE_ITEM, text, item, widg);
#line 253 "source-item.c"
}


/**
 * Creates a Source.Item with a stock icon and customizable text.
 *
 * @param text The text to display in the source item.
 * @param item The stock item to take the label from.
 * @param img The image widget to use (note that this icon should use
 * the Gtk.IconSize constant ICON_SIZE to fit in with other items).
 * @param widg The widget that this Source.Item should be linked with.
 * If null, this Source.Item will only emit the clicked signal when 
 * clicked, without any automatic UI changes.
 */
#line 1157 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 270 "source-item.c"
	char* result = NULL;
	GError * _inner_error_ = NULL;
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 279 "source-item.c"
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1159 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 287 "source-item.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch39_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1160 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 298 "source-item.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch39_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1160 "glib-2.0.vapi"
		return result;
#line 313 "source-item.c"
	}
	goto __finally39;
	__catch39_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1162 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 324 "source-item.c"
			_g_error_free0 (e);
		}
	}
	__finally39:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 216 "source-item.vala"
SourceItem* source_item_construct_from_stock_text (GType object_type, const char* item, GtkImage* img, GtkWidget* widg) {
#line 339 "source-item.c"
	SourceItem * self;
	GtkStockItem stock = {0};
#line 216 "source-item.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 216 "source-item.vala"
	g_return_val_if_fail (img != NULL, NULL);
#line 346 "source-item.c"
	memset (&stock, 0, sizeof (GtkStockItem));
#line 219 "source-item.vala"
	if (gtk_stock_lookup (item, &stock)) {
#line 350 "source-item.c"
		char* _tmp0_;
#line 221 "source-item.vala"
		self = (SourceItem*) source_item_construct (object_type, _tmp0_ = string_replace (stock.label, "_", ""), img, widg);
#line 354 "source-item.c"
		_g_free0 (_tmp0_);
	}
	return self;
}


#line 216 "source-item.vala"
SourceItem* source_item_new_from_stock_text (const char* item, GtkImage* img, GtkWidget* widg) {
#line 216 "source-item.vala"
	return source_item_construct_from_stock_text (SOURCE_TYPE_ITEM, item, img, widg);
#line 365 "source-item.c"
}


/**
 * Creates a Source.Item with a stock icon and text.
 *
 * @param item The stock item to take the icon and text from.
 * @param widg The widget that this Source.Item should be linked with.
 * If null, this Source.Item will only emit the clicked signal when 
 * clicked, without any automatic UI changes.
 */
#line 233 "source-item.vala"
SourceItem* source_item_construct_from_stock (GType object_type, const char* item, GtkWidget* widg) {
#line 379 "source-item.c"
	SourceItem * self;
	GtkStockItem stock = {0};
#line 233 "source-item.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 384 "source-item.c"
	memset (&stock, 0, sizeof (GtkStockItem));
#line 236 "source-item.vala"
	if (gtk_stock_lookup (item, &stock)) {
#line 388 "source-item.c"
		char* _tmp0_;
		GtkImage* _tmp1_;
#line 238 "source-item.vala"
		self = (SourceItem*) source_item_construct (object_type, _tmp0_ = string_replace (stock.label, "_", ""), _tmp1_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (item, SOURCE_ITEM_ICON_SIZE)), widg);
#line 393 "source-item.c"
		_g_object_unref0 (_tmp1_);
		_g_free0 (_tmp0_);
	}
	return self;
}


#line 233 "source-item.vala"
SourceItem* source_item_new_from_stock (const char* item, GtkWidget* widg) {
#line 233 "source-item.vala"
	return source_item_construct_from_stock (SOURCE_TYPE_ITEM, item, widg);
#line 405 "source-item.c"
}


/**
 * Selects this Source.Item, emitting a "clicked" signal.
 */
#line 247 "source-item.vala"
void source_item_select (SourceItem* self) {
#line 247 "source-item.vala"
	g_return_if_fail (self != NULL);
#line 249 "source-item.vala"
	source_item_set_selected (self, TRUE);
#line 418 "source-item.c"
}


gboolean source_item_get_selected (SourceItem* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = gtk_button_get_relief (self->priv->button) == SOURCE_ITEM_RELIEF_SELECTED;
#line 112 "source-item.vala"
	return result;
#line 428 "source-item.c"
}


void source_item_set_selected (SourceItem* self, gboolean value) {
	GtkReliefStyle _tmp0_ = 0;
	const char* _tmp1_;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
#line 116 "source-item.vala"
	if (source_item_get_selected (self) == value) {
#line 116 "source-item.vala"
		return;
#line 441 "source-item.c"
	}
#line 119 "source-item.vala"
	if (value) {
#line 119 "source-item.vala"
		_tmp0_ = SOURCE_ITEM_RELIEF_SELECTED;
#line 447 "source-item.c"
	} else {
#line 119 "source-item.vala"
		_tmp0_ = SOURCE_ITEM_RELIEF_DESELECTED;
#line 451 "source-item.c"
	}
#line 119 "source-item.vala"
	gtk_button_set_relief (self->priv->button, _tmp0_);
#line 455 "source-item.c"
	_tmp1_ = NULL;
#line 120 "source-item.vala"
	if (value) {
#line 121 "source-item.vala"
		_tmp1_ = SOURCE_ITEM_FORMAT_SELECTED;
#line 461 "source-item.c"
	} else {
#line 122 "source-item.vala"
		_tmp1_ = SOURCE_ITEM_FORMAT_DESELECTED;
#line 465 "source-item.c"
	}
#line 120 "source-item.vala"
	gtk_label_set_label (self->priv->label, _tmp2_ = g_strdup_printf (_tmp1_, self->priv->label_text));
#line 469 "source-item.c"
	_g_free0 (_tmp2_);
#line 125 "source-item.vala"
	if (value) {
#line 127 "source-item.vala"
		g_signal_emit_by_name (self, "clicked", self);
#line 475 "source-item.c"
	}
	g_object_notify ((GObject *) self, "selected");
}


static void source_item_class_init (SourceItemClass * klass) {
	source_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SourceItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = source_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = source_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = source_item_finalize;
	/**
	 * If this Source.Item is the selected item in its {@link Source.List}.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOURCE_ITEM_SELECTED, g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Emitted when the Source.Item's Gtk.Button is clicked. Generally used
	 * internally to change {@link Source.List} selection.
	 *
	 * @param sender The Source.Item that emitted the signal (generally, "this").
	 */
	g_signal_new ("clicked", SOURCE_TYPE_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SOURCE_TYPE_ITEM);
}


static void source_item_instance_init (SourceItem * self) {
	self->priv = SOURCE_ITEM_GET_PRIVATE (self);
}


static void source_item_finalize (GObject* obj) {
	SourceItem * self;
	self = SOURCE_ITEM (obj);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->label);
	_g_object_unref0 (self->right_align);
	_g_object_unref0 (self->priv->button);
	_g_object_unref0 (self->widget);
	_g_free0 (self->priv->label_text);
	G_OBJECT_CLASS (source_item_parent_class)->finalize (obj);
}


/**
 * An individual item in a {@link Source.Group}.
 *
 * Source.Item contains a Gtk.Button, which in turn contains an image and a
 * label. When added to a {@link Source.Group}, signals are automatically set
 * up to manage the {@link Source.View} this item is a part of.
 */
GType source_item_get_type (void) {
	static volatile gsize source_item_type_id__volatile = 0;
	if (g_once_init_enter (&source_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SourceItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceItem), 0, (GInstanceInitFunc) source_item_instance_init, NULL };
		GType source_item_type_id;
		source_item_type_id = g_type_register_static (GTK_TYPE_HBOX, "SourceItem", &g_define_type_info, 0);
		g_once_init_leave (&source_item_type_id__volatile, source_item_type_id);
	}
	return source_item_type_id__volatile;
}


static void source_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SourceItem * self;
	self = SOURCE_ITEM (object);
	switch (property_id) {
		case SOURCE_ITEM_SELECTED:
		g_value_set_boolean (value, source_item_get_selected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void source_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SourceItem * self;
	self = SOURCE_ITEM (object);
	switch (property_id) {
		case SOURCE_ITEM_SELECTED:
		source_item_set_selected (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




