/* ease-image.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-image.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>


#define EASE_TYPE_IMAGE (ease_image_get_type ())
#define EASE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE, EaseImage))
#define EASE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE, EaseImageClass))
#define EASE_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE))
#define EASE_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE))
#define EASE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE, EaseImageClass))

typedef struct _EaseImage EaseImage;
typedef struct _EaseImageClass EaseImageClass;
typedef struct _EaseImagePrivate EaseImagePrivate;

#define EASE_TYPE_IMAGE_FILL_TYPE (ease_image_fill_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _EaseImage {
	GObject parent_instance;
	EaseImagePrivate * priv;
};

struct _EaseImageClass {
	GObjectClass parent_class;
};

typedef enum  {
	EASE_IMAGE_FILL_TYPE_STRETCH,
	EASE_IMAGE_FILL_TYPE_ASPECT,
	EASE_IMAGE_FILL_TYPE_ORIGINAL
} EaseImageFillType;

struct _EaseImagePrivate {
	char* _filename;
	char* _source;
	EaseImageFillType _fill;
};


static gpointer ease_image_parent_class = NULL;

GType ease_image_get_type (void) G_GNUC_CONST;
GType ease_image_fill_type_get_type (void) G_GNUC_CONST;
#define EASE_IMAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_IMAGE, EaseImagePrivate))
enum  {
	EASE_IMAGE_DUMMY_PROPERTY,
	EASE_IMAGE_FILENAME,
	EASE_IMAGE_SOURCE,
	EASE_IMAGE_FILL
};
void ease_image_set_cairo (EaseImage* self, cairo_t* cr, gint width, gint height, const char* path);
const char* ease_image_get_filename (EaseImage* self);
EaseImageFillType ease_image_get_fill (EaseImage* self);
EaseImage* ease_image_new (void);
EaseImage* ease_image_construct (GType object_type);
void ease_image_set_filename (EaseImage* self, const char* value);
const char* ease_image_get_source (EaseImage* self);
void ease_image_set_source (EaseImage* self, const char* value);
void ease_image_set_fill (EaseImage* self, EaseImageFillType value);
static void ease_image_finalize (GObject* obj);
static void ease_image_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_image_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
char* ease_image_fill_type_to_string (EaseImageFillType self);
#define EASE_THEME_IMAGE_STRETCH "image-fill-stretch"
#define EASE_THEME_IMAGE_ASPECT "image-fill-aspect"
#define EASE_THEME_IMAGE_ORIGINAL "image-fill-original"
EaseImageFillType ease_image_fill_type_from_string (const char* str);
char* ease_image_fill_type_description (EaseImageFillType self);
GtkListStore* ease_image_fill_type_list_store (void);



/**
 * Sets up a CairoContext to render this image.
 *
 * @param cr The context to set up.
 * @param width The width of the rendering.
 * @param height The height of the rendering.
 * @param path The base path to any possible media files.
 */
#line 43 "ease-image.vala"
void ease_image_set_cairo (EaseImage* self, cairo_t* cr, gint width, gint height, const char* path) {
#line 116 "ease-image.c"
	GError * _inner_error_ = NULL;
#line 43 "ease-image.vala"
	g_return_if_fail (self != NULL);
#line 43 "ease-image.vala"
	g_return_if_fail (cr != NULL);
#line 43 "ease-image.vala"
	g_return_if_fail (path != NULL);
#line 124 "ease-image.c"
	{
		char* full;
		GdkPixbuf* pixbuf;
#line 47 "ease-image.vala"
		full = g_build_filename (path, self->priv->_filename, NULL);
#line 130 "ease-image.c"
		pixbuf = NULL;
#line 49 "ease-image.vala"
		switch (self->priv->_fill) {
#line 134 "ease-image.c"
			case EASE_IMAGE_FILL_TYPE_STRETCH:
			{
				GdkPixbuf* _tmp0_;
				GdkPixbuf* _tmp1_;
#line 52 "ease-image.vala"
				_tmp0_ = gdk_pixbuf_new_from_file_at_scale (full, width, height, FALSE, &_inner_error_);
#line 141 "ease-image.c"
				if (_inner_error_ != NULL) {
					_g_object_unref0 (pixbuf);
					_g_free0 (full);
					goto __catch19_g_error;
				}
#line 52 "ease-image.vala"
				pixbuf = (_tmp1_ = _tmp0_, _g_object_unref0 (pixbuf), _tmp1_);
#line 56 "ease-image.vala"
				gdk_cairo_set_source_pixbuf (cr, pixbuf, (double) 0, (double) 0);
#line 57 "ease-image.vala"
				break;
#line 153 "ease-image.c"
			}
			case EASE_IMAGE_FILL_TYPE_ASPECT:
			{
				GdkPixbuf* _tmp2_;
				GdkPixbuf* _tmp3_;
				float this_aspect;
				GdkPixbuf* out_pixbuf;
#line 59 "ease-image.vala"
				_tmp2_ = gdk_pixbuf_new_from_file (full, &_inner_error_);
#line 163 "ease-image.c"
				if (_inner_error_ != NULL) {
					_g_object_unref0 (pixbuf);
					_g_free0 (full);
					goto __catch19_g_error;
				}
#line 59 "ease-image.vala"
				pixbuf = (_tmp3_ = _tmp2_, _g_object_unref0 (pixbuf), _tmp3_);
#line 62 "ease-image.vala"
				this_aspect = ((float) width) / height;
#line 173 "ease-image.c"
				out_pixbuf = NULL;
#line 66 "ease-image.vala"
				if (this_aspect > 1) {
#line 177 "ease-image.c"
					GdkPixbuf* _tmp4_;
#line 68 "ease-image.vala"
					out_pixbuf = (_tmp4_ = gdk_pixbuf_scale_simple (pixbuf, width, (gint) (height * this_aspect), GDK_INTERP_BILINEAR), _g_object_unref0 (out_pixbuf), _tmp4_);
#line 71 "ease-image.vala"
					gdk_cairo_set_source_pixbuf (cr, out_pixbuf, (double) 0, (double) ((height - gdk_pixbuf_get_height (out_pixbuf)) / 2));
#line 183 "ease-image.c"
				} else {
					GdkPixbuf* _tmp5_;
#line 78 "ease-image.vala"
					out_pixbuf = (_tmp5_ = gdk_pixbuf_scale_simple (pixbuf, (gint) (width / this_aspect), height, GDK_INTERP_BILINEAR), _g_object_unref0 (out_pixbuf), _tmp5_);
#line 81 "ease-image.vala"
					gdk_cairo_set_source_pixbuf (cr, out_pixbuf, (double) ((width - gdk_pixbuf_get_width (out_pixbuf)) / 2), (double) 0);
#line 190 "ease-image.c"
				}
				_g_object_unref0 (out_pixbuf);
#line 86 "ease-image.vala"
				break;
#line 195 "ease-image.c"
			}
			case EASE_IMAGE_FILL_TYPE_ORIGINAL:
			{
				GdkPixbuf* _tmp6_;
				GdkPixbuf* _tmp7_;
#line 88 "ease-image.vala"
				_tmp6_ = gdk_pixbuf_new_from_file (full, &_inner_error_);
#line 203 "ease-image.c"
				if (_inner_error_ != NULL) {
					_g_object_unref0 (pixbuf);
					_g_free0 (full);
					goto __catch19_g_error;
				}
#line 88 "ease-image.vala"
				pixbuf = (_tmp7_ = _tmp6_, _g_object_unref0 (pixbuf), _tmp7_);
#line 89 "ease-image.vala"
				gdk_cairo_set_source_pixbuf (cr, pixbuf, (double) ((width - gdk_pixbuf_get_width (pixbuf)) / 2), (double) ((height - gdk_pixbuf_get_height (pixbuf)) / 2));
#line 92 "ease-image.vala"
				break;
#line 215 "ease-image.c"
			}
		}
		_g_object_unref0 (pixbuf);
		_g_free0 (full);
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 98 "ease-image.vala"
			g_critical ("ease-image.vala:98: Error rendering image background: %s", e->message);
#line 230 "ease-image.c"
			_g_error_free0 (e);
		}
	}
	__finally19:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 18 "ease-image.vala"
EaseImage* ease_image_construct (GType object_type) {
#line 245 "ease-image.c"
	EaseImage * self;
#line 18 "ease-image.vala"
	self = (EaseImage*) g_object_new (object_type, NULL);
#line 249 "ease-image.c"
	return self;
}


#line 18 "ease-image.vala"
EaseImage* ease_image_new (void) {
#line 18 "ease-image.vala"
	return ease_image_construct (EASE_TYPE_IMAGE);
#line 258 "ease-image.c"
}


const char* ease_image_get_filename (EaseImage* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_filename;
#line 23 "ease-image.vala"
	return result;
#line 268 "ease-image.c"
}


void ease_image_set_filename (EaseImage* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_filename = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_filename), _tmp0_);
	g_object_notify ((GObject *) self, "filename");
}


const char* ease_image_get_source (EaseImage* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_source;
#line 28 "ease-image.vala"
	return result;
#line 286 "ease-image.c"
}


void ease_image_set_source (EaseImage* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_source = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_source), _tmp0_);
	g_object_notify ((GObject *) self, "source");
}


EaseImageFillType ease_image_get_fill (EaseImage* self) {
	EaseImageFillType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_fill;
#line 33 "ease-image.vala"
	return result;
#line 304 "ease-image.c"
}


void ease_image_set_fill (EaseImage* self, EaseImageFillType value) {
	g_return_if_fail (self != NULL);
	self->priv->_fill = value;
	g_object_notify ((GObject *) self, "fill");
}


static void ease_image_class_init (EaseImageClass * klass) {
	ease_image_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseImagePrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_image_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_image_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_image_finalize;
	/**
	 * The image's filename, relative to the {@link Document}'s path.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_IMAGE_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The original path to the background image. This path is used in the UI.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_IMAGE_SOURCE, g_param_spec_string ("source", "source", "source", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The fill mode of this image.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_IMAGE_FILL, g_param_spec_enum ("fill", "fill", "fill", EASE_TYPE_IMAGE_FILL_TYPE, EASE_IMAGE_FILL_TYPE_STRETCH, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void ease_image_instance_init (EaseImage * self) {
	self->priv = EASE_IMAGE_GET_PRIVATE (self);
	self->priv->_fill = EASE_IMAGE_FILL_TYPE_STRETCH;
}


static void ease_image_finalize (GObject* obj) {
	EaseImage * self;
	self = EASE_IMAGE (obj);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_source);
	G_OBJECT_CLASS (ease_image_parent_class)->finalize (obj);
}


GType ease_image_get_type (void) {
	static volatile gsize ease_image_type_id__volatile = 0;
	if (g_once_init_enter (&ease_image_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseImage), 0, (GInstanceInitFunc) ease_image_instance_init, NULL };
		GType ease_image_type_id;
		ease_image_type_id = g_type_register_static (G_TYPE_OBJECT, "EaseImage", &g_define_type_info, 0);
		g_once_init_leave (&ease_image_type_id__volatile, ease_image_type_id);
	}
	return ease_image_type_id__volatile;
}


static void ease_image_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseImage * self;
	self = EASE_IMAGE (object);
	switch (property_id) {
		case EASE_IMAGE_FILENAME:
		g_value_set_string (value, ease_image_get_filename (self));
		break;
		case EASE_IMAGE_SOURCE:
		g_value_set_string (value, ease_image_get_source (self));
		break;
		case EASE_IMAGE_FILL:
		g_value_set_enum (value, ease_image_get_fill (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_image_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseImage * self;
	self = EASE_IMAGE (object);
	switch (property_id) {
		case EASE_IMAGE_FILENAME:
		ease_image_set_filename (self, g_value_get_string (value));
		break;
		case EASE_IMAGE_SOURCE:
		ease_image_set_source (self, g_value_get_string (value));
		break;
		case EASE_IMAGE_FILL:
		ease_image_set_fill (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


/**
 * Returns a string representation of this ImageFillType.
 */
#line 112 "ease-image.vala"
char* ease_image_fill_type_to_string (EaseImageFillType self) {
#line 408 "ease-image.c"
	char* result = NULL;
#line 114 "ease-image.vala"
	switch (self) {
#line 412 "ease-image.c"
		case EASE_IMAGE_FILL_TYPE_STRETCH:
		{
			result = g_strdup (EASE_THEME_IMAGE_STRETCH);
#line 116 "ease-image.vala"
			return result;
#line 418 "ease-image.c"
		}
		case EASE_IMAGE_FILL_TYPE_ASPECT:
		{
			result = g_strdup (EASE_THEME_IMAGE_ASPECT);
#line 117 "ease-image.vala"
			return result;
#line 425 "ease-image.c"
		}
		case EASE_IMAGE_FILL_TYPE_ORIGINAL:
		{
			result = g_strdup (EASE_THEME_IMAGE_ORIGINAL);
#line 118 "ease-image.vala"
			return result;
#line 432 "ease-image.c"
		}
	}
	result = g_strdup ("undefined");
#line 120 "ease-image.vala"
	return result;
#line 438 "ease-image.c"
}


/**
 * Creates a ImageFillType from a string representation.
 */
#line 126 "ease-image.vala"
EaseImageFillType ease_image_fill_type_from_string (const char* str) {
#line 447 "ease-image.c"
	EaseImageFillType result = 0;
	const char* _tmp0_;
	GQuark _tmp1_;
#line 126 "ease-image.vala"
	g_return_val_if_fail (str != NULL, 0);
#line 453 "ease-image.c"
	_tmp0_ = str;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == g_quark_from_string (EASE_THEME_IMAGE_STRETCH))
	switch (0) {
		default:
		{
			result = EASE_IMAGE_FILL_TYPE_STRETCH;
#line 130 "ease-image.vala"
			return result;
#line 463 "ease-image.c"
		}
	} else if (_tmp1_ == g_quark_from_string (EASE_THEME_IMAGE_ASPECT))
	switch (0) {
		default:
		{
			result = EASE_IMAGE_FILL_TYPE_ASPECT;
#line 131 "ease-image.vala"
			return result;
#line 472 "ease-image.c"
		}
	} else if (_tmp1_ == g_quark_from_string (EASE_THEME_IMAGE_ORIGINAL))
	switch (0) {
		default:
		{
			result = EASE_IMAGE_FILL_TYPE_ORIGINAL;
#line 132 "ease-image.vala"
			return result;
#line 481 "ease-image.c"
		}
	}
#line 135 "ease-image.vala"
	g_warning ("ease-image.vala:135: %s is not an image fill type", str);
#line 486 "ease-image.c"
	result = EASE_IMAGE_FILL_TYPE_STRETCH;
#line 136 "ease-image.vala"
	return result;
#line 490 "ease-image.c"
}


/**
 * Returns a string description of the ImageFillType
 */
#line 142 "ease-image.vala"
char* ease_image_fill_type_description (EaseImageFillType self) {
#line 499 "ease-image.c"
	char* result = NULL;
#line 144 "ease-image.vala"
	switch (self) {
#line 503 "ease-image.c"
		case EASE_IMAGE_FILL_TYPE_STRETCH:
		{
			result = g_strdup (_ ("Stretch"));
#line 146 "ease-image.vala"
			return result;
#line 509 "ease-image.c"
		}
		case EASE_IMAGE_FILL_TYPE_ASPECT:
		{
			result = g_strdup (_ ("Maintain Aspect Ratio"));
#line 147 "ease-image.vala"
			return result;
#line 516 "ease-image.c"
		}
		case EASE_IMAGE_FILL_TYPE_ORIGINAL:
		{
			result = g_strdup (_ ("Do not Scale"));
#line 148 "ease-image.vala"
			return result;
#line 523 "ease-image.c"
		}
	}
	result = g_strdup ("undefined");
#line 150 "ease-image.vala"
	return result;
#line 529 "ease-image.c"
}


/**
 * Creates a ListStore with the first column set as the description
 * and the second column set as the ImageFillType.
 */
#line 157 "ease-image.vala"
GtkListStore* ease_image_fill_type_list_store (void) {
#line 539 "ease-image.c"
	GtkListStore* result = NULL;
	GtkListStore* store;
	GtkTreeIter itr = {0};
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
#line 159 "ease-image.vala"
	store = gtk_list_store_new (2, G_TYPE_STRING, EASE_TYPE_IMAGE_FILL_TYPE);
#line 162 "ease-image.vala"
	gtk_list_store_append (store, &itr);
#line 163 "ease-image.vala"
	gtk_list_store_set (store, &itr, 0, _tmp0_ = ease_image_fill_type_description (EASE_IMAGE_FILL_TYPE_STRETCH), 1, EASE_IMAGE_FILL_TYPE_STRETCH, -1);
#line 552 "ease-image.c"
	_g_free0 (_tmp0_);
#line 164 "ease-image.vala"
	gtk_list_store_append (store, &itr);
#line 165 "ease-image.vala"
	gtk_list_store_set (store, &itr, 0, _tmp1_ = ease_image_fill_type_description (EASE_IMAGE_FILL_TYPE_ASPECT), 1, EASE_IMAGE_FILL_TYPE_ASPECT, -1);
#line 558 "ease-image.c"
	_g_free0 (_tmp1_);
#line 166 "ease-image.vala"
	gtk_list_store_append (store, &itr);
#line 167 "ease-image.vala"
	gtk_list_store_set (store, &itr, 0, _tmp2_ = ease_image_fill_type_description (EASE_IMAGE_FILL_TYPE_ORIGINAL), 1, EASE_IMAGE_FILL_TYPE_ORIGINAL, -1);
#line 564 "ease-image.c"
	_g_free0 (_tmp2_);
	result = store;
#line 169 "ease-image.vala"
	return result;
#line 569 "ease-image.c"
}


GType ease_image_fill_type_get_type (void) {
	static volatile gsize ease_image_fill_type_type_id__volatile = 0;
	if (g_once_init_enter (&ease_image_fill_type_type_id__volatile)) {
		static const GEnumValue values[] = {{EASE_IMAGE_FILL_TYPE_STRETCH, "EASE_IMAGE_FILL_TYPE_STRETCH", "stretch"}, {EASE_IMAGE_FILL_TYPE_ASPECT, "EASE_IMAGE_FILL_TYPE_ASPECT", "aspect"}, {EASE_IMAGE_FILL_TYPE_ORIGINAL, "EASE_IMAGE_FILL_TYPE_ORIGINAL", "original"}, {0, NULL, NULL}};
		GType ease_image_fill_type_type_id;
		ease_image_fill_type_type_id = g_enum_register_static ("EaseImageFillType", values);
		g_once_init_leave (&ease_image_fill_type_type_id__volatile, ease_image_fill_type_type_id);
	}
	return ease_image_fill_type_type_id__volatile;
}




