/* Eye of Gnome image viewer - image canvas item
 *
 * Copyright (C) 1999 The Free Software Foundation
 *
 * Author: Federico Mena-Quintero <federico@gimp.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef IMAGE_ITEM_H
#define IMAGE_ITEM_H

#include <libgnome/gnome-defs.h>
#include <libgnomeui/gnome-canvas.h>

BEGIN_GNOME_DECLS



#define TYPE_IMAGE_ITEM            (image_item_get_type ())
#define IMAGE_ITEM(obj)            (GTK_CHECK_CAST ((obj), TYPE_IMAGE_ITEM, ImageItem))
#define IMAGE_ITEM_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_IMAGE_ITEM, ImageItemClass))
#define IS_IMAGE_ITEM(obj)         (GTK_CHECK_TYPE ((obj), TYPE_IMAGE_ITEM))
#define IS_IMAGE_ITEM_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_IMAGE_ITEM))


typedef struct _ImageItem ImageItem;
typedef struct _ImageItemClass ImageItemClass;


struct _ImageItem {
	GnomeCanvasItem item;

	/* Private data */
	gpointer priv;
};

struct _ImageItemClass {
	GnomeCanvasItemClass parent_class;
};


GtkType image_item_get_type (void);



END_GNOME_DECLS

#endif
