/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* e-book-backend-couchdb.c - CouchDB contact backend
 *
 * Copyright (C) 2009 Canonical, Ltd. (www.canonical.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 3 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include <e-util/e-config.h>
#include <e-util/e-plugin.h>
#include <addressbook/gui/widgets/eab-config.h>
#include <libedataserver/e-source.h>
#include <libedataserver/e-source-list.h>
#include <libedataserver/e-url.h>
#include <libedataserver/e-account-list.h>

#define COUCHDB_BASE_URI "couchdb://"

static void
ensure_couchdb_contacts_source_group (void)
{
	ESourceList *source_list;

	source_list = e_source_list_new_for_gconf_default("/apps/evolution/addressbook/sources");
	if (source_list) {
		e_source_list_ensure_group (source_list, _("CouchDB"), COUCHDB_BASE_URI, FALSE);

		g_object_unref (G_OBJECT (source_list));
	}
}

static void
remove_couchdb_contacts_source_group (void)
{
	ESourceList *source_list;

	source_list = e_source_list_new_for_gconf_default("/apps/evolution/addressbook/sources");
	if (source_list) {
		ESourceGroup *group;

		group = e_source_list_peek_group_by_base_uri (source_list, COUCHDB_BASE_URI);
		if (group) {
			GSList *sources;

			sources = e_source_group_peek_sources (group);
			if (sources == NULL) {
				e_source_list_remove_group (source_list, group);
				e_source_list_sync (source_list, NULL);
			}
		}

		g_object_unref (G_OBJECT (source_list));
	}
}

GtkWidget *
plugin_couchdb_contacts (EPlugin *epl, EConfigHookItemFactoryData *data)
{
	ESource *source;
        ESourceGroup *group;
	const gchar *base_uri;
	EABConfigTargetSource *t = (EABConfigTargetSource *) data->target;

	source = t->source;
        group  = e_source_peek_group (source);

        base_uri = e_source_group_peek_base_uri (group);

        g_object_set_data (G_OBJECT (epl), "wwidget", NULL);

	if (strcmp(base_uri, COUCHDB_BASE_URI) != 0)
                return NULL;

	return NULL;
}

gint
e_plugin_lib_enable (EPluginLib *ep, gint enable)
{
	if (enable)
		ensure_couchdb_contacts_source_group ();
	else
		remove_couchdb_contacts_source_group ();

	return 0;
}
