


#include <camel.h>
#include "camel-enumtypes.h"

/* enumerations from "camel-enums.h" */
GType
camel_authentication_result_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "CAMEL_AUTHENTICATION_ERROR", "error" },
      { 1, "CAMEL_AUTHENTICATION_ACCEPTED", "accepted" },
      { 2, "CAMEL_AUTHENTICATION_REJECTED", "rejected" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("CamelAuthenticationResult", values);
  }
  return etype;
}
GType
camel_folder_flags_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { 1, "CAMEL_FOLDER_HAS_SUMMARY_CAPABILITY", "has-summary-capability" },
      { 2, "CAMEL_FOLDER_HAS_SEARCH_CAPABILITY", "has-search-capability" },
      { 4, "CAMEL_FOLDER_FILTER_RECENT", "filter-recent" },
      { 8, "CAMEL_FOLDER_HAS_BEEN_DELETED", "has-been-deleted" },
      { 16, "CAMEL_FOLDER_IS_TRASH", "is-trash" },
      { 32, "CAMEL_FOLDER_IS_JUNK", "is-junk" },
      { 64, "CAMEL_FOLDER_FILTER_JUNK", "filter-junk" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("CamelFolderFlags", values);
  }
  return etype;
}
GType
camel_folder_info_flags_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { 1, "CAMEL_FOLDER_NOSELECT", "noselect" },
      { 2, "CAMEL_FOLDER_NOINFERIORS", "noinferiors" },
      { 4, "CAMEL_FOLDER_CHILDREN", "children" },
      { 8, "CAMEL_FOLDER_NOCHILDREN", "nochildren" },
      { 16, "CAMEL_FOLDER_SUBSCRIBED", "subscribed" },
      { 32, "CAMEL_FOLDER_VIRTUAL", "virtual" },
      { 64, "CAMEL_FOLDER_SYSTEM", "system" },
      { 128, "CAMEL_FOLDER_VTRASH", "vtrash" },
      { 256, "CAMEL_FOLDER_SHARED_TO_ME", "shared-to-me" },
      { 512, "CAMEL_FOLDER_SHARED_BY_ME", "shared-by-me" },
      { 0, "CAMEL_FOLDER_TYPE_NORMAL", "type-normal" },
      { 1, "CAMEL_FOLDER_TYPE_INBOX", "type-inbox" },
      { 2, "CAMEL_FOLDER_TYPE_OUTBOX", "type-outbox" },
      { 3, "CAMEL_FOLDER_TYPE_TRASH", "type-trash" },
      { 4, "CAMEL_FOLDER_TYPE_JUNK", "type-junk" },
      { 5, "CAMEL_FOLDER_TYPE_SENT", "type-sent" },
      { 6, "CAMEL_FOLDER_TYPE_CONTACTS", "type-contacts" },
      { 7, "CAMEL_FOLDER_TYPE_EVENTS", "type-events" },
      { 8, "CAMEL_FOLDER_TYPE_MEMOS", "type-memos" },
      { 9, "CAMEL_FOLDER_TYPE_TASKS", "type-tasks" },
      { 65536, "CAMEL_FOLDER_READONLY", "readonly" },
      { 131072, "CAMEL_FOLDER_CHECK_FOR_NEW", "check-for-new" },
      { 262144, "CAMEL_FOLDER_FLAGGED", "flagged" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("CamelFolderInfoFlags", values);
  }
  return etype;
}
GType
camel_store_info_flags_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { 1, "CAMEL_STORE_INFO_FOLDER_NOSELECT", "noselect" },
      { 2, "CAMEL_STORE_INFO_FOLDER_NOINFERIORS", "noinferiors" },
      { 4, "CAMEL_STORE_INFO_FOLDER_CHILDREN", "children" },
      { 8, "CAMEL_STORE_INFO_FOLDER_NOCHILDREN", "nochildren" },
      { 16, "CAMEL_STORE_INFO_FOLDER_SUBSCRIBED", "subscribed" },
      { 32, "CAMEL_STORE_INFO_FOLDER_VIRTUAL", "virtual" },
      { 64, "CAMEL_STORE_INFO_FOLDER_SYSTEM", "system" },
      { 128, "CAMEL_STORE_INFO_FOLDER_VTRASH", "vtrash" },
      { 256, "CAMEL_STORE_INFO_FOLDER_SHARED_TO_ME", "shared-to-me" },
      { 512, "CAMEL_STORE_INFO_FOLDER_SHARED_BY_ME", "shared-by-me" },
      { 65536, "CAMEL_STORE_INFO_FOLDER_READONLY", "readonly" },
      { 131072, "CAMEL_STORE_INFO_FOLDER_CHECK_FOR_NEW", "check-for-new" },
      { 262144, "CAMEL_STORE_INFO_FOLDER_FLAGGED", "flagged" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("CamelStoreInfoFlags", values);
  }
  return etype;
}
GType
camel_fetch_headers_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "CAMEL_FETCH_HEADERS_BASIC", "basic" },
      { 1, "CAMEL_FETCH_HEADERS_BASIC_AND_MAILING_LIST", "basic-and-mailing-list" },
      { 2, "CAMEL_FETCH_HEADERS_ALL", "all" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("CamelFetchHeadersType", values);
  }
  return etype;
}
GType
camel_junk_status_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "CAMEL_JUNK_STATUS_INCONCLUSIVE", "inconclusive" },
      { 1, "CAMEL_JUNK_STATUS_MESSAGE_IS_JUNK", "message-is-junk" },
      { 2, "CAMEL_JUNK_STATUS_MESSAGE_IS_NOT_JUNK", "message-is-not-junk" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("CamelJunkStatus", values);
  }
  return etype;
}
GType
camel_mime_filter_basic_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "CAMEL_MIME_FILTER_BASIC_INVALID", "invalid" },
      { 1, "CAMEL_MIME_FILTER_BASIC_BASE64_ENC", "base64-enc" },
      { 2, "CAMEL_MIME_FILTER_BASIC_BASE64_DEC", "base64-dec" },
      { 3, "CAMEL_MIME_FILTER_BASIC_QP_ENC", "qp-enc" },
      { 4, "CAMEL_MIME_FILTER_BASIC_QP_DEC", "qp-dec" },
      { 5, "CAMEL_MIME_FILTER_BASIC_UU_ENC", "uu-enc" },
      { 6, "CAMEL_MIME_FILTER_BASIC_UU_DEC", "uu-dec" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("CamelMimeFilterBasicType", values);
  }
  return etype;
}
GType
camel_mime_filter_crlf_direction_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "CAMEL_MIME_FILTER_CRLF_ENCODE", "encode" },
      { 1, "CAMEL_MIME_FILTER_CRLF_DECODE", "decode" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("CamelMimeFilterCRLFDirection", values);
  }
  return etype;
}
GType
camel_mime_filter_crlf_mode_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "CAMEL_MIME_FILTER_CRLF_MODE_CRLF_DOTS", "dots" },
      { 1, "CAMEL_MIME_FILTER_CRLF_MODE_CRLF_ONLY", "only" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("CamelMimeFilterCRLFMode", values);
  }
  return etype;
}
GType
camel_mime_filter_gzip_mode_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "CAMEL_MIME_FILTER_GZIP_MODE_ZIP", "zip" },
      { 1, "CAMEL_MIME_FILTER_GZIP_MODE_UNZIP", "unzip" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("CamelMimeFilterGZipMode", values);
  }
  return etype;
}
GType
camel_mime_filter_yenc_direction_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "CAMEL_MIME_FILTER_YENC_DIRECTION_ENCODE", "encode" },
      { 1, "CAMEL_MIME_FILTER_YENC_DIRECTION_DECODE", "decode" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("CamelMimeFilterYencDirection", values);
  }
  return etype;
}
GType
camel_network_security_method_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "CAMEL_NETWORK_SECURITY_METHOD_NONE", "none" },
      { 1, "CAMEL_NETWORK_SECURITY_METHOD_SSL_ON_ALTERNATE_PORT", "ssl-on-alternate-port" },
      { 2, "CAMEL_NETWORK_SECURITY_METHOD_STARTTLS_ON_STANDARD_PORT", "starttls-on-standard-port" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("CamelNetworkSecurityMethod", values);
  }
  return etype;
}
GType
camel_provider_conf_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "CAMEL_PROVIDER_CONF_END", "end" },
      { 1, "CAMEL_PROVIDER_CONF_SECTION_START", "section-start" },
      { 2, "CAMEL_PROVIDER_CONF_SECTION_END", "section-end" },
      { 3, "CAMEL_PROVIDER_CONF_CHECKBOX", "checkbox" },
      { 4, "CAMEL_PROVIDER_CONF_CHECKSPIN", "checkspin" },
      { 5, "CAMEL_PROVIDER_CONF_ENTRY", "entry" },
      { 6, "CAMEL_PROVIDER_CONF_LABEL", "label" },
      { 7, "CAMEL_PROVIDER_CONF_HIDDEN", "hidden" },
      { 8, "CAMEL_PROVIDER_CONF_OPTIONS", "options" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("CamelProviderConfType", values);
  }
  return etype;
}
GType
camel_provider_flags_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { 1, "CAMEL_PROVIDER_IS_REMOTE", "is-remote" },
      { 2, "CAMEL_PROVIDER_IS_LOCAL", "is-local" },
      { 4, "CAMEL_PROVIDER_IS_EXTERNAL", "is-external" },
      { 8, "CAMEL_PROVIDER_IS_SOURCE", "is-source" },
      { 16, "CAMEL_PROVIDER_IS_STORAGE", "is-storage" },
      { 32, "CAMEL_PROVIDER_SUPPORTS_SSL", "supports-ssl" },
      { 64, "CAMEL_PROVIDER_HAS_LICENSE", "has-license" },
      { 128, "CAMEL_PROVIDER_DISABLE_SENT_FOLDER", "disable-sent-folder" },
      { 256, "CAMEL_PROVIDER_ALLOW_REAL_TRASH_FOLDER", "allow-real-trash-folder" },
      { 512, "CAMEL_PROVIDER_ALLOW_REAL_JUNK_FOLDER", "allow-real-junk-folder" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("CamelProviderFlags", values);
  }
  return etype;
}
GType
camel_provider_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "CAMEL_PROVIDER_STORE", "store" },
      { 1, "CAMEL_PROVIDER_TRANSPORT", "transport" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("CamelProviderType", values);
  }
  return etype;
}
GType
camel_sasl_anon_trace_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "CAMEL_SASL_ANON_TRACE_EMAIL", "email" },
      { 1, "CAMEL_SASL_ANON_TRACE_OPAQUE", "opaque" },
      { 2, "CAMEL_SASL_ANON_TRACE_EMPTY", "empty" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("CamelSaslAnonTraceType", values);
  }
  return etype;
}
GType
camel_service_connection_status_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "CAMEL_SERVICE_DISCONNECTED", "disconnected" },
      { 1, "CAMEL_SERVICE_CONNECTING", "connecting" },
      { 2, "CAMEL_SERVICE_CONNECTED", "connected" },
      { 3, "CAMEL_SERVICE_DISCONNECTING", "disconnecting" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("CamelServiceConnectionStatus", values);
  }
  return etype;
}
GType
camel_session_alert_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "CAMEL_SESSION_ALERT_INFO", "info" },
      { 1, "CAMEL_SESSION_ALERT_WARNING", "warning" },
      { 2, "CAMEL_SESSION_ALERT_ERROR", "error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("CamelSessionAlertType", values);
  }
  return etype;
}
GType
camel_sort_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "CAMEL_SORT_ASCENDING", "ascending" },
      { 1, "CAMEL_SORT_DESCENDING", "descending" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("CamelSortType", values);
  }
  return etype;
}
GType
camel_store_flags_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { 1, "CAMEL_STORE_VTRASH", "vtrash" },
      { 2, "CAMEL_STORE_VJUNK", "vjunk" },
      { 4, "CAMEL_STORE_PROXY", "proxy" },
      { 8, "CAMEL_STORE_IS_MIGRATING", "is-migrating" },
      { 16, "CAMEL_STORE_REAL_JUNK_FOLDER", "real-junk-folder" },
      { 32, "CAMEL_STORE_CAN_EDIT_FOLDERS", "can-edit-folders" },
      { 64, "CAMEL_STORE_USE_CACHE_DIR", "use-cache-dir" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("CamelStoreFlags", values);
  }
  return etype;
}
GType
camel_store_get_folder_info_flags_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { 1, "CAMEL_STORE_FOLDER_INFO_FAST", "fast" },
      { 2, "CAMEL_STORE_FOLDER_INFO_RECURSIVE", "recursive" },
      { 4, "CAMEL_STORE_FOLDER_INFO_SUBSCRIBED", "subscribed" },
      { 8, "CAMEL_STORE_FOLDER_INFO_NO_VIRTUAL", "no-virtual" },
      { 16, "CAMEL_STORE_FOLDER_INFO_SUBSCRIPTION_LIST", "subscription-list" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("CamelStoreGetFolderInfoFlags", values);
  }
  return etype;
}
GType
camel_store_permission_flags_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { 1, "CAMEL_STORE_READ", "read" },
      { 2, "CAMEL_STORE_WRITE", "write" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("CamelStorePermissionFlags", values);
  }
  return etype;
}
GType
camel_tcp_stream_ssl_flags_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { 1, "CAMEL_TCP_STREAM_SSL_ENABLE_SSL2", "ssl2" },
      { 2, "CAMEL_TCP_STREAM_SSL_ENABLE_SSL3", "ssl3" },
      { 4, "CAMEL_TCP_STREAM_SSL_ENABLE_TLS", "tls" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("CamelTcpStreamSSLFlags", values);
  }
  return etype;
}
GType
camel_transfer_encoding_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "CAMEL_TRANSFER_ENCODING_DEFAULT", "encoding-default" },
      { 1, "CAMEL_TRANSFER_ENCODING_7BIT", "encoding-7bit" },
      { 2, "CAMEL_TRANSFER_ENCODING_8BIT", "encoding-8bit" },
      { 3, "CAMEL_TRANSFER_ENCODING_BASE64", "encoding-base64" },
      { 4, "CAMEL_TRANSFER_ENCODING_QUOTEDPRINTABLE", "encoding-quotedprintable" },
      { 5, "CAMEL_TRANSFER_ENCODING_BINARY", "encoding-binary" },
      { 6, "CAMEL_TRANSFER_ENCODING_UUENCODE", "encoding-uuencode" },
      { 7, "CAMEL_TRANSFER_NUM_ENCODINGS", "num-encodings" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("CamelTransferEncoding", values);
  }
  return etype;
}
GType
camel_stream_vfs_open_method_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "CAMEL_STREAM_VFS_CREATE", "create" },
      { 1, "CAMEL_STREAM_VFS_APPEND", "append" },
      { 2, "CAMEL_STREAM_VFS_READ", "read" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("CamelStreamVFSOpenMethod", values);
  }
  return etype;
}



