/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            kolab-http-job.h
 *
 *  Tue Mar  1 14:05:54 2011
 *  Copyright  2011  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#ifndef _KOLAB_HTTP_JOB_H_
#define _KOLAB_HTTP_JOB_H_

/*----------------------------------------------------------------------------*/

#include <glib.h>
#include "camel-system-headers.h"

/*----------------------------------------------------------------------------*/

/**
 * KolabHttpJob:
 * @url: the CamelURL containing all server information
 *          (needs to be maintained manually)
 * @buffer: the byte buffer to hold the HTTP server response
 *          (needs to be maintained manually)
 * @nbytes: can be used to store a bytes count (aside from the buffer length)
 * @pkcs11pin: the pin needed to access client cert on pkcs #11 tokens
 *
 * This structure holds all information needed by the kolab_util_http_get()
 * function to send a query to a webserver.
 */
typedef struct _KolabHttpJob {
	CamelURL *url;
	GByteArray *buffer;
	gssize nbytes;
	gchar *pkcs11pin;
} KolabHttpJob;

/*----------------------------------------------------------------------------*/

KolabHttpJob* kolab_http_job_new (void);
void kolab_http_job_free (KolabHttpJob *job);

/*----------------------------------------------------------------------------*/

#endif /* _KOLAB_HTTP_JOB_H_ */

/*----------------------------------------------------------------------------*/
