/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            camel-imapx-extd-conn-manager.h
 *
 *  2011-12-20, 15:59:18
 *  Copyright 2011, Christian Hilberg
 *  <hilberg@unix-ag.org>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#ifndef _CAMEL_IMAPX_EXTD_CONN_MANAGER_H_
#define _CAMEL_IMAPX_EXTD_CONN_MANAGER_H_

/*----------------------------------------------------------------------------*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>

#include "camel-imapx-conn-manager.h"
#include "camel-imapx-extd-server.h"
#include "camel-imapx-extd-store.h"

/*----------------------------------------------------------------------------*/
/* Standard GObject macros */

#define CAMEL_TYPE_IMAPX_EXTD_CONN_MANAGER	  \
	(camel_imapx_extd_conn_manager_get_type ())
#define CAMEL_IMAPX_EXTD_CONN_MANAGER(obj)	  \
	(G_TYPE_CHECK_INSTANCE_CAST \
	 ((obj), CAMEL_TYPE_IMAPX_EXTD_CONN_MANAGER, CamelIMAPXExtdConnManager))
#define CAMEL_IMAPX_EXTD_CONN_MANAGER_CLASS(klass)	  \
	(G_TYPE_CHECK_CLASS_CAST \
	 ((klass), CAMEL_TYPE_IMAPX_EXTD_CONN_MANAGER, CamelIMAPXExtdConnManagerClass))
#define CAMEL_IS_IMAPX_EXTD_CONN_MANAGER(obj)	  \
	(G_TYPE_CHECK_INSTANCE_TYPE \
	 ((obj), CAMEL_TYPE_IMAPX_EXTD_CONN_MANAGER))
#define CAMEL_IS_IMAPX_EXTD_CONN_MANAGER_CLASS(klass)	  \
	(G_TYPE_CHECK_CLASS_TYPE \
	 ((klass), CAMEL_TYPE_IMAPX_EXTD_CONN_MANAGER))
#define CAMEL_IMAPX_EXTD_CONN_MANAGER_GET_CLASS(obj)	  \
	(G_TYPE_INSTANCE_GET_CLASS \
	 ((obj), CAMEL_TYPE_IMAPX_EXTD_CONN_MANAGER, CamelIMAPXExtdConnManagerClass))

G_BEGIN_DECLS

typedef struct _CamelIMAPXExtdConnManager CamelIMAPXExtdConnManager;
typedef struct _CamelIMAPXExtdConnManagerClass CamelIMAPXExtdConnManagerClass;

struct _CamelIMAPXExtdConnManager {
	CamelIMAPXConnManager parent;
};

struct _CamelIMAPXExtdConnManagerClass {
	CamelIMAPXConnManagerClass parent_class;

	/* public virtual functions */

	CamelStore* (*get_store) (CamelIMAPXConnManager *self);

	CamelIMAPXServer* (*get_connection) (CamelIMAPXConnManager *self,
	                                     const gchar *foldername,
	                                     GCancellable *cancellable,
	                                     GError **err);

	void (*close_connections) (CamelIMAPXConnManager *self);

	GList* (*get_connections) (CamelIMAPXConnManager *self);

	void (*update_con_info) (CamelIMAPXConnManager *self,
	                         CamelIMAPXServer *server,
	                         const gchar *foldername);
};

GType
camel_imapx_extd_conn_manager_get_type (void);

CamelIMAPXExtdConnManager*
camel_imapx_extd_conn_manager_new (CamelIMAPXExtdStore *store);

CamelStore*
camel_imapx_extd_conn_manager_get_store (CamelIMAPXConnManager *self);

CamelIMAPXServer*
camel_imapx_extd_conn_manager_get_connection (CamelIMAPXConnManager *self,
                                              const gchar *foldername,
                                              GCancellable *cancellable,
                                              GError **err);

void
camel_imapx_extd_conn_manager_close_connections (CamelIMAPXConnManager *self);

GList*
camel_imapx_extd_conn_manager_get_connections (CamelIMAPXConnManager *self);

void
camel_imapx_extd_conn_manager_update_con_info (CamelIMAPXConnManager *self,
                                               CamelIMAPXServer *server,
                                               const gchar *foldername);

G_END_DECLS

/*----------------------------------------------------------------------------*/

#endif /* _CAMEL_IMAPX_EXTD_CONN_MANAGER_H_ */

/*----------------------------------------------------------------------------*/
