/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            camel-imapx-conn-manager-defs.h
 *
 *  2012-01-20, 14:53:18
 *  Copyright 2012, Christian Hilberg
 *  <hilberg@unix-ag.org>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/* This file holds definitions needed by CamelIMAPXExtdConnManager,
 * but not exported by its parent class. In order not to mess with
 * upstream code, we (temporarily) dupe the symbols here.
 * Once the *Extd* classes get merged into their upstream counterparts,
 * these dupes can be removed
 */

/*----------------------------------------------------------------------------*/

#ifndef _CAMEL_IMAPX_CONN_MANAGER_DEFS_H_
#define _CAMEL_IMAPX_CONN_MANAGER_DEFS_H_

/*----------------------------------------------------------------------------*/

#define c(...) camel_imapx_debug(conman, __VA_ARGS__)

#define CON_READ_LOCK(x)	  \
	(g_static_rw_lock_reader_lock (&(x)->priv->rw_lock))
#define CON_READ_UNLOCK(x)	  \
	(g_static_rw_lock_reader_unlock (&(x)->priv->rw_lock))
#define CON_WRITE_LOCK(x)	  \
	(g_static_rw_lock_writer_lock (&(x)->priv->rw_lock))
#define CON_WRITE_UNLOCK(x)	  \
	(g_static_rw_lock_writer_unlock (&(x)->priv->rw_lock))

/* typedef of CamelIMAPXConnManagerPrivate done in camel-imapx-conn-manager.h */

struct _CamelIMAPXConnManagerPrivate {
	/* XXX Might be easier for this to be a hash table,
	 *     with CamelIMAPXServer pointers as the keys. */
	GList *connections;
	gpointer store;  /* weak pointer */
	GStaticRWLock rw_lock;
};

struct _ConnectionInfo {
	GMutex *lock;
	CamelIMAPXServer *is;
	GHashTable *folder_names;
	gchar *selected_folder;
	volatile gint ref_count;
};

enum {
	PROP_0,
	PROP_STORE
};

/*----------------------------------------------------------------------------*/

#endif /* _CAMEL_IMAPX_CONN_MANAGER_DEFS_H_ */

/*----------------------------------------------------------------------------*/
