/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            camel-imapx-server-friend.h
 *
 *  2012-01-20, 18:57:18
 *  Copyright 2012, Christian Hilberg
 *  <hilberg@unix-ag.org>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/* This file holds function prototypes needed by CamelIMAPXExtdServer,
 * but not exported by its parent class. In order not to mess with
 * upstream code, we (temporarily) declare the symbols here.
 * Once the *Extd* classes get merged into their upstream counterparts,
 * these can be removed
 */

/*----------------------------------------------------------------------------*/

#ifndef _CAMEL_IMAPX_SERVER_FRIEND_H_
#define _CAMEL_IMAPX_SERVER_FRIEND_H_

/*----------------------------------------------------------------------------*/

CamelIMAPXJob*
camel_imapx_server_match_active_job (CamelIMAPXServer *self,
                                     guint32 type,
                                     const gchar *uid);

gchar*
camel_imapx_server_get_uid_from_index (CamelIMAPXServer *self,
                                       CamelFolderSummary *summary,
                                       guint id);

void
camel_imapx_server_expunge_uid_from_summary (CamelIMAPXServer *self,
                                             gchar *uid,
                                             gboolean unsolicited);

gboolean
camel_imapx_server_idle_supported (CamelIMAPXServer *self);

void
camel_imapx_server_init_idle (CamelIMAPXServer *self);

gboolean
camel_imapx_server_in_idle (CamelIMAPXServer *self);

gboolean
camel_imapx_server_stop_idle (CamelIMAPXServer *self,
                              GError **err);

gint
camel_imapx_server_refresh_info_uid_cmp (CamelIMAPXServer *self,
                                         gconstpointer ap,
                                         gconstpointer bp,
                                         gboolean ascending);

void
camel_imapx_server_invalidate_local_cache (CamelIMAPXServer *self,
                                           CamelIMAPXFolder *ifolder,
                                           guint64 new_uidvalidity);

gboolean
camel_imapx_server_completion (CamelIMAPXServer *self,
                               guchar *token,
                               gint len,
                               GCancellable *cancellable,
                               GError **err);

gboolean
camel_imapx_server_continuation (CamelIMAPXServer *self,
                                 gboolean litplus,
                                 GCancellable *cancellable,
                                 GError **err);

gboolean
camel_imapx_server_command_start (CamelIMAPXServer *self,
                                  CamelIMAPXCommand *ic,
                                  GCancellable *cancellable,
                                  GError **err);

gboolean
camel_imapx_server_command_run_sync (CamelIMAPXServer *self,
                                     CamelIMAPXCommand *ic,
                                     GCancellable *cancellable,
                                     GError **err);

gboolean
camel_imapx_server_connect_to_server_process (CamelIMAPXServer *self,
                                              const gchar *cmd,
                                              GError **err);

gboolean
camel_imapx_server_disconnect (CamelIMAPXServer *self);

void
camel_imapx_server_cancel_all_jobs (CamelIMAPXServer *self,
                                    GError *err_to_copy);

/*----------------------------------------------------------------------------*/

#endif /* _CAMEL_IMAPX_SERVER_FRIEND_H_ */

/*----------------------------------------------------------------------------*/
