/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            camel-imapx-acl.c
 *
 *  2012-07-30, 19:09:28
 *  Copyright 2012, Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/
/* ACL (RFC 4314) */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <glib/gi18n-lib.h>

#include "camel-imapx-acl.h"

/*----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------*/

CamelImapxAcl*
camel_imapx_acl_new (gboolean locked)
{
	CamelImapxAcl *acl = g_new0 (CamelImapxAcl, 1);
	g_mutex_init (&(acl->acl_lock));

	if (locked)
		g_mutex_lock (&(acl->acl_lock));

	acl->myrights = g_hash_table_new_full (g_str_hash,
	                                       g_str_equal,
	                                       g_free,
	                                       g_free);
	acl->mboxes = g_hash_table_new_full (g_str_hash,
	                                     g_str_equal,
	                                     g_free,
	                                     g_free);
	return acl;
}

void
camel_imapx_acl_free (CamelImapxAcl *acl)
{
	if (acl == NULL)
		return;

	if (acl->myrights)
		g_hash_table_destroy (acl->myrights);
	if (acl->mboxes)
		g_hash_table_destroy (acl->mboxes);

	while (! g_mutex_trylock (&(acl->acl_lock)));
	g_mutex_unlock (&(acl->acl_lock));
	g_mutex_clear (&(acl->acl_lock));

	g_free (acl);
}

CamelImapxAcl*
camel_imapx_acl_resect (CamelImapxAcl *acl)
{
	CamelImapxAcl *tmp_acl = NULL;
	GHashTable *myrights = NULL;
	GHashTable *mboxes = NULL;

	if (acl == NULL)
		return NULL;

	/* (acquire acl lock) */
	g_mutex_lock (&(acl->acl_lock));

	tmp_acl = camel_imapx_acl_new (FALSE);

	myrights = acl->myrights;
	mboxes = acl->mboxes;

	acl->myrights = tmp_acl->myrights;
	acl->mboxes = tmp_acl->mboxes;

	tmp_acl->myrights = myrights;
	tmp_acl->mboxes = mboxes;

	/* (release acl lock) */
	g_mutex_unlock (&(acl->acl_lock));

	return tmp_acl;
}

/*----------------------------------------------------------------------------*/
