#include <stdio.h>
#include <string.h>

#include <libbonobo.h>

#include "Evolution-DataServer-Mail.h"
#include "e-mail-remote-glue-storechange.h"
#include "e-mail-remote-glue-folderinfo.h"

static void e_mail_remote_glue_storechange_class_init (EMailRemoteGlueStoreChangeClass *klass);
static void e_mail_remote_glue_storechange_init (EMailRemoteGlueStoreChange *comp, EMailRemoteGlueStoreChangeClass *klass);
static void e_mail_remote_glue_storechange_finalize (GObject *object);

/*static guint e_mail_remote_signals[LAST_SIGNAL] = { 0 };*/

static GObjectClass *parent_class;

/**
 * e_mail_remote_glue_storechange_get_type:
 *
 * Registers the #EMailRemoteGlueStoreChange class if necessary, and returns the type ID
 * associated to it.
 *
 * Return value: The type ID of the #EMailRemoteGlueStoreChange class.
 **/
GType
e_mail_remote_glue_storechange_get_type (void)
{
  static GType e_mail_remote_glue_storechange_type = 0;

  if (!e_mail_remote_glue_storechange_type) {
    static GTypeInfo info = {
      sizeof (EMailRemoteGlueStoreChangeClass),
      (GBaseInitFunc) NULL,
      (GBaseFinalizeFunc) NULL,
      (GClassInitFunc) e_mail_remote_glue_storechange_class_init,
      NULL, NULL,
      sizeof (EMailRemoteGlueStoreChange),
      0,
      (GInstanceInitFunc) e_mail_remote_glue_storechange_init
    };
    e_mail_remote_glue_storechange_type = g_type_register_static (G_TYPE_OBJECT, "EMailRemoteGlueStoreChange", &info, 0);
  }

  return e_mail_remote_glue_storechange_type;
}

/* Class initialization function for the calendar-glue object */
static void
e_mail_remote_glue_storechange_class_init (EMailRemoteGlueStoreChangeClass *klass)
{
  GObjectClass *object_class;

  object_class = (GObjectClass *) klass;

  parent_class = g_type_class_peek_parent (klass);

  object_class->finalize = e_mail_remote_glue_storechange_finalize;
}

/* Object initialization function for the calendar-glue object */
static void
e_mail_remote_glue_storechange_init (EMailRemoteGlueStoreChange *emrg_schange, EMailRemoteGlueStoreChangeClass *klass)
{  
  emrg_schange->folder_infos = NULL;
}

/**
 * e_mail_remote_glue_storechange_new:
 *
 * Creates a new empty calendar-glue component object.  
 *
 * Return value: A newly-created calendar-glue component object.
 **/
EMailRemoteGlueStoreChange *
e_mail_remote_glue_storechange_new (void)
{
  return E_MAIL_REMOTE_GLUE_STORECHANGE (g_object_new (E_TYPE_MAIL_REMOTE_GLUE_STORECHANGE, NULL));
}

/* Finalize handler for the calendar-glue component object */
static void
e_mail_remote_glue_storechange_finalize (GObject *object)
{
  EMailRemoteGlueStoreChange *schange;

  g_return_if_fail (object != NULL);
  g_return_if_fail (E_IS_MAIL_REMOTE_GLUE_STORECHANGE (object));

  schange = E_MAIL_REMOTE_GLUE_STORECHANGE (object);

  if (schange->folder_infos) {
    g_slist_foreach (schange->folder_infos, (GFunc)g_object_unref, NULL);
    g_slist_free (schange->folder_infos);
  }
  
  if (G_OBJECT_CLASS (parent_class)->finalize)
    (* G_OBJECT_CLASS (parent_class)->finalize) (object);
}

EMailRemoteGlueStoreChange*
e_mail_remote_glue_storechange_new_clone (EMailRemoteGlueStoreChange* schange)
{
  EMailRemoteGlueStoreChange* emrg_schange = NULL;
  EMailRemoteGlueFolderInfo* finfo = NULL;
  GSList* l;

  emrg_schange = e_mail_remote_glue_storechange_new ();
  for (l = schange->folder_infos; l; l = l->next) {
    finfo = e_mail_remote_glue_folderinfo_new_clone (l->data);
    emrg_schange->folder_infos = g_slist_append (emrg_schange->folder_infos, finfo);
  }
  return emrg_schange;
}


EMailRemoteGlueStoreChange*
e_mail_remote_glue_storechange_new_from_EMStoreChange (Evolution_Mail_StoreChange schange)
{
  EMailRemoteGlueStoreChange* emrg_schange = NULL;
  EMailRemoteGlueFolderInfo* finfo = NULL;
  int i = 0;

  emrg_schange = e_mail_remote_glue_storechange_new ();
  for (i = 0; i < schange.folders._length; i++) {
    finfo = e_mail_remote_glue_folderinfo_new_from_EMFolderInfo (schange.folders._buffer[i]);
    emrg_schange->folder_infos = g_slist_append (emrg_schange->folder_infos, finfo);
  }
  return emrg_schange;
}

GSList*
e_mail_remote_glue_storechange_get_folder_info_list (EMailRemoteGlueStoreChange* schange)
{
  g_return_val_if_fail (schange != NULL, NULL);
  return schange->folder_infos;
}
