%define name	firestarter
%define version 0.8.3
%define release 1

Summary: A firewall tool for the GNOME Desktop Environment
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: Applications/Internet
URL: http://firestarter.sourceforge.net

Source0: http://download.sourceforge.com/firestarter/firestarter-%{version}.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

BuildRequires: glib-devel, gtk+-devel >= 1.2.7
BuildRequires: gnome-libs-devel >= 1.2.3, gnome-core-devel
BuildRequires: docbook-utils, sgml-tools, openjade
BuildRequires: sh-utils, textutils, fileutils, binutils, grep, make, gcc

Requires: gtk+ >= 1.2.7, gnome-libs >= 1.2.3, gnome-core, initscripts

%description
Firestarter is an easy-to-use, yet powerful, Linux firewall tool for GNOME.
Use it to quickly set up a secure environment using the firewall creation
wizard, or use it's monitoring and administrating features with your old
firewall scripts.

%prep
rm -rf %{buildroot}

%setup

%build
# the only safe optimization on i386 with ORBit
CFLAGS="${RPM_OPT_FLAGS}" 
CXXFLAGS="${RPM_OPT_FLAGS}" 
%configure

if [ "$SMP" != "" ]; then
	(make "MAKE=make -k -j $SMP"; exit 0)
make
else
	make
fi

%pre

%install
mkdir -p $RPM_BUILD_ROOT/%{_bindir}
mkdir -p $RPM_BUILD_ROOT/%{_sbindir}

%makeinstall

mv $RPM_BUILD_ROOT/%{_bindir}/firestarter $RPM_BUILD_ROOT/%{_sbindir}
ln -s %{_bindir}/consolehelper $RPM_BUILD_ROOT/%{_bindir}/firestarter

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/pam.d
cat > $RPM_BUILD_ROOT%{_sysconfdir}/pam.d/firestarter <<EOF
auth       sufficient   /lib/security/pam_rootok.so
auth       required     /lib/security/pam_stack.so service=system-auth
session    required     /lib/security/pam_permit.so
session    required     /lib/security/pam_xauth.so
account    required     /lib/security/pam_permit.so
EOF

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/security/console.apps
cat > $RPM_BUILD_ROOT%{_sysconfdir}/security/console.apps/firestarter <<EOF
USER=root
FALLBACK=true
PROGRAM=%{_sbindir}/firestarter
SESSION=true
EOF

mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d

# Determine Kernel Revision
KV=`uname -r | cut -c 1-3`

if [ "$KV" = "2.2" ]; then
	/sbin/chkconfig ipchains off 
	install -m 755 ipchains.init $RPM_BUILD_ROOT/etc/rc.d/init.d/firestarter
fi

if [ "$KV" = "2.4" ]; then
	/sbin/chkconfig iptables off
	install -m 755 netfilter.init $RPM_BUILD_ROOT/etc/rc.d/init.d/firestarter
fi

%post
/sbin/chkconfig --level 0123456 ipchains off 2>/dev/null || :
/sbin/chkconfig --level 0123456 iptables off 2>/dev/null || :
/sbin/chkconfig --add firestarter
/sbin/chkconfig firestarter on

%preun
if [ $1 = 0 ]; then
	/sbin/chkconfig ipchains reset 2>/dev/null || :
	/sbin/chkconfig iptables reset 2>/dev/null || :
	/sbin/service firestarter stop >/dev/null 2>&1
	/sbin/chkconfig --del firestarter
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc README ChangeLog AUTHORS TODO COPYING CREDITS
%attr(755,root,root) %{_sbindir}/firestarter
%{_datadir}/gnome/apps/Internet/firestarter.desktop
%{_datadir}/pixmaps/*
%{_datadir}/gnome/help/firestarter/*
%{_datadir}/locale/*/*/*
%{_bindir}/firestarter
%{_sysconfdir}/pam.d/firestarter
%{_sysconfdir}/security/console.apps/firestarter
%config /etc/rc.d/init.d/firestarter

%changelog
* Tue Jun 25 2002 Paul Drain <pd@cipherfunk.org>
- Merged some compatible cleanups from the FreshRPMS (http://freshrpms.net)
  specfile.
  
* Wed Apr 24 2002 Paul Drain <pd@cipherfunk.org>
- build dependancy cleanups

* Mon Apr 22 2002 Paul Drain <pd@cipherfunk.org>
- gnome-doc-tools is no longer required to build the RPM

* Tue Jan 08 2002 Roy-Magne Mo <rmo@sunnmore.net>
- Clean up specfile, and use rpm4 macros
- Remove docuementation tools as requirements
- Add gnome-doc-tools and then some as buildprereq
- Add initscripts to prereq
- used %makeinstall macro instead of old make install
- no use specifying runlevels at the commandline, this
  should be specified in the initscripts itself
- Added gnome-core as requirements

* Mon Jan 07 2002 Tomas Junnonen <majix@sci.fi>
- preun now doesn't explicitly delete the init script,
  caused problem with package upgrades.
- Moved the init scripts to external files
  
* Tue Oct 23 2001 Paul Drain <pd@cipherfunk.org>
- Added sgmltools and openjade to build requirements

* Tue Oct 16 2001 Paul Drain <pd@cipherfunk.org>
- Updated build dependancies

* Mon Jul 09 2001 Paul Drain <pd@cipherfunk.org>
- Fixed documentation directory
- Added sysconfdir variable instead of hardcoding /etc

* Thu Jun 01 2000 Tomas Junnonen <majix@sci.fi>
- Significant changes to allow use of consolehelper

* Wed May 31 2000 Tomas Junnonen <majix@sci.fi>
- Fixed problem with CFLAGS and LDADD usage of " and `

* Mon May 29 2000 Tomas Junnonen <majix@sci.fi>
- First spec file
