/* tpf-persona.c generated by valac, the Vala compiler
 * generated from tpf-persona.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <telepathy-glib/telepathy-glib.h>


#define TPF_TYPE_PERSONA (tpf_persona_get_type ())
#define TPF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA, TpfPersona))
#define TPF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA, TpfPersonaClass))
#define TPF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA))
#define TPF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA))
#define TPF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA, TpfPersonaClass))

typedef struct _TpfPersona TpfPersona;
typedef struct _TpfPersonaClass TpfPersonaClass;
typedef struct _TpfPersonaPrivate TpfPersonaPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TPF_TYPE_PERSONA_STORE (tpf_persona_store_get_type ())
#define TPF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStore))
#define TPF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))
#define TPF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA_STORE))
#define TPF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA_STORE))
#define TPF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))

typedef struct _TpfPersonaStore TpfPersonaStore;
typedef struct _TpfPersonaStoreClass TpfPersonaStoreClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;

typedef enum  {
	TPF_PERSONA_ERROR_INVALID_ARGUMENT
} TpfPersonaError;
#define TPF_PERSONA_ERROR tpf_persona_error_quark ()
struct _TpfPersona {
	FolksPersona parent_instance;
	TpfPersonaPrivate * priv;
};

struct _TpfPersonaClass {
	FolksPersonaClass parent_class;
};

struct _TpfPersonaPrivate {
	GHashTable* _groups;
	gboolean _is_favourite;
	char* _alias;
	gboolean is_constructed;
	GFile* _avatar;
	FolksPresenceType _presence_type;
	char* _presence_message;
	TpContact* _contact;
};

struct _Block1Data {
	int _ref_count_;
	TpAccount* account_found;
	TpConnection* conn;
};

struct _Block2Data {
	int _ref_count_;
	TpfPersona * self;
	GHashTable* value;
};


static gpointer tpf_persona_parent_class = NULL;
static FolksAliasIface* tpf_persona_folks_alias_parent_iface = NULL;
static FolksAvatarIface* tpf_persona_folks_avatar_parent_iface = NULL;
static FolksFavouriteIface* tpf_persona_folks_favourite_parent_iface = NULL;
static FolksGroupsIface* tpf_persona_folks_groups_parent_iface = NULL;
static FolksPresenceIface* tpf_persona_folks_presence_parent_iface = NULL;

GQuark tpf_persona_error_quark (void);
GType tpf_persona_get_type (void) G_GNUC_CONST;
#define TPF_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TPF_TYPE_PERSONA, TpfPersonaPrivate))
enum  {
	TPF_PERSONA_DUMMY_PROPERTY,
	TPF_PERSONA_AVATAR,
	TPF_PERSONA_PRESENCE_TYPE,
	TPF_PERSONA_PRESENCE_MESSAGE,
	TPF_PERSONA_ALIAS,
	TPF_PERSONA_IS_FAVOURITE,
	TPF_PERSONA_GROUPS,
	TPF_PERSONA_CONTACT
};
static gboolean _tpf_persona_change_group (TpfPersona* self, const char* group, gboolean is_member);
GType tpf_persona_store_get_type (void) G_GNUC_CONST;
void tpf_persona_store_change_group_membership (TpfPersonaStore* self, FolksPersona* persona, const char* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_group_membership_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void tpf_persona_real_change_group (FolksGroups* base, const char* group, gboolean is_member);
static TpAccount* tpf_persona_account_for_connection (TpConnection* conn);
static void tpf_persona_contact_notify_avatar (TpfPersona* self);
static void _lambda13_ (GObject* s, GParamSpec* p, TpfPersona* self);
static void __lambda13__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void tpf_persona_contact_notify_presence_message (TpfPersona* self);
static void _lambda14_ (GObject* s, GParamSpec* p, TpfPersona* self);
static void __lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void tpf_persona_contact_notify_presence_type (TpfPersona* self);
static void _lambda15_ (GObject* s, GParamSpec* p, TpfPersona* self);
static void __lambda15__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda16_ (TpfPersonaStore* s, const char* group, GList* added, GList* removed, TpfPersona* self);
static void __lambda16__tpf_persona_store_group_members_changed (TpfPersonaStore* _sender, const char* group, GList* added, GList* removed, gpointer self);
static void _lambda17_ (TpfPersonaStore* s, const char* group, GError* _error_, TpfPersona* self);
static void __lambda17__tpf_persona_store_group_removed (TpfPersonaStore* _sender, const char* group, GError* _error_, gpointer self);
TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store, GError** error);
TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store, GError** error);
static void _lambda12_ (void* l, Block1Data* _data1_);
static void __lambda12__gfunc (void* data, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
TpContact* tpf_persona_get_contact (TpfPersona* self);
static FolksPresenceType tpf_persona_folks_presence_type_from_tp (TpConnectionPresenceType type);
void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const char* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_);
void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void _lambda18_ (void* k, void* v, TpfPersona* self);
static void __lambda18__gh_func (void* key, void* value, gpointer self);
static void _lambda19_ (void* k, void* v, Block2Data* _data2_);
static void __lambda19__gh_func (void* key, void* value, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void tpf_persona_set_contact (TpfPersona* self, TpContact* value);
static void tpf_persona_finalize (GObject* obj);
static void tpf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tpf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark tpf_persona_error_quark (void) {
	return g_quark_from_static_string ("tpf_persona_error-quark");
}


static void tpf_persona_real_change_group (FolksGroups* base, const char* group, gboolean is_member) {
	TpfPersona * self;
	self = (TpfPersona*) base;
	g_return_if_fail (group != NULL);
	if (_tpf_persona_change_group (self, group, is_member)) {
		tpf_persona_store_change_group_membership (TPF_PERSONA_STORE (folks_persona_get_store ((FolksPersona*) self)), (FolksPersona*) self, group, is_member, NULL, NULL);
		g_signal_emit_by_name ((FolksGroups*) self, "group-changed", group, is_member);
	}
}


static gboolean _tpf_persona_change_group (TpfPersona* self, const char* group, gboolean is_member) {
	gboolean result = FALSE;
	gboolean changed;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	changed = FALSE;
	if (is_member) {
		if (GPOINTER_TO_INT (g_hash_table_lookup (self->priv->_groups, group)) != TRUE) {
			g_hash_table_insert (self->priv->_groups, g_strdup (group), GINT_TO_POINTER (TRUE));
			changed = TRUE;
		}
	} else {
		changed = g_hash_table_remove (self->priv->_groups, group);
	}
	result = changed;
	return result;
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void _lambda13_ (GObject* s, GParamSpec* p, TpfPersona* self) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	tpf_persona_contact_notify_avatar (self);
}


static void __lambda13__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda13_ (_sender, pspec, self);
}


static void _lambda14_ (GObject* s, GParamSpec* p, TpfPersona* self) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	tpf_persona_contact_notify_presence_message (self);
}


static void __lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda14_ (_sender, pspec, self);
}


static void _lambda15_ (GObject* s, GParamSpec* p, TpfPersona* self) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	tpf_persona_contact_notify_presence_type (self);
}


static void __lambda15__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda15_ (_sender, pspec, self);
}


static void _lambda16_ (TpfPersonaStore* s, const char* group, GList* added, GList* removed, TpfPersona* self) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (group != NULL);
	if (g_list_find (added, self) != NULL) {
		_tpf_persona_change_group (self, group, TRUE);
	}
	if (g_list_find (removed, self) != NULL) {
		_tpf_persona_change_group (self, group, FALSE);
	}
}


static void __lambda16__tpf_persona_store_group_members_changed (TpfPersonaStore* _sender, const char* group, GList* added, GList* removed, gpointer self) {
	_lambda16_ (_sender, group, added, removed, self);
}


static void _lambda17_ (TpfPersonaStore* s, const char* group, GError* _error_, TpfPersona* self) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (group != NULL);
	if (_error_ != NULL) {
		g_warning ("tpf-persona.vala:232: group invalidated: %s", _error_->message);
	}
	_tpf_persona_change_group (self, group, FALSE);
}


static void __lambda17__tpf_persona_store_group_removed (TpfPersonaStore* _sender, const char* group, GError* _error_, gpointer self) {
	_lambda17_ (_sender, group, _error_, self);
}


TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store, GError** error) {
	GError * _inner_error_;
	TpfPersona * self;
	char* uid;
	gboolean _tmp0_ = FALSE;
	TpAccount* account;
	char* account_id;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp3_;
	char* iid;
	char* alias;
	gboolean _tmp4_ = FALSE;
	GHashTable* _tmp7_;
	g_return_val_if_fail (contact != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_inner_error_ = NULL;
	uid = g_strdup (tp_contact_get_identifier (contact));
	if (uid == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (uid, "") == 0;
	}
	if (_tmp0_) {
		_inner_error_ = g_error_new_literal (TPF_PERSONA_ERROR, TPF_PERSONA_ERROR_INVALID_ARGUMENT, "contact has an " "invalid UID");
		{
			if (_inner_error_->domain == TPF_PERSONA_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (uid);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (uid);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	account = tpf_persona_account_for_connection (tp_contact_get_connection (contact));
	account_id = g_strdup (tp_proxy_get_object_path (TP_PROXY (account)));
	iid = (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat (_tmp1_ = g_strconcat ("telepathy:", account_id, NULL), ":", NULL), uid, NULL), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _tmp3_);
	alias = g_strdup (tp_contact_get_alias (contact));
	if (alias == NULL) {
		_tmp4_ = TRUE;
	} else {
		char* _tmp5_;
		_tmp4_ = _vala_strcmp0 (_tmp5_ = string_strip (alias), "") == 0;
		_g_free0 (_tmp5_);
	}
	if (_tmp4_) {
		char* _tmp6_;
		alias = (_tmp6_ = g_strdup (uid), _g_free0 (alias), _tmp6_);
	}
	self = (TpfPersona*) g_object_new (object_type, "alias", alias, "contact", contact, "iid", iid, "uid", uid, "store", store, NULL);
	self->priv->is_constructed = TRUE;
	self->priv->_groups = (_tmp7_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL), _g_hash_table_unref0 (self->priv->_groups), _tmp7_);
	g_signal_connect_object ((GObject*) contact, "notify::avatar-file", (GCallback) __lambda13__g_object_notify, self, 0);
	tpf_persona_contact_notify_avatar (self);
	g_signal_connect_object ((GObject*) contact, "notify::presence-message", (GCallback) __lambda14__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) contact, "notify::presence-type", (GCallback) __lambda15__g_object_notify, self, 0);
	tpf_persona_contact_notify_presence_message (self);
	tpf_persona_contact_notify_presence_type (self);
	g_signal_connect_object (TPF_PERSONA_STORE (folks_persona_get_store ((FolksPersona*) self)), "group-members-changed", (GCallback) __lambda16__tpf_persona_store_group_members_changed, self, 0);
	g_signal_connect_object (TPF_PERSONA_STORE (folks_persona_get_store ((FolksPersona*) self)), "group-removed", (GCallback) __lambda17__tpf_persona_store_group_removed, self, 0);
	_g_free0 (alias);
	_g_free0 (iid);
	_g_free0 (account_id);
	_g_object_unref0 (account);
	_g_free0 (uid);
	return self;
}


TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store, GError** error) {
	return tpf_persona_construct (TPF_TYPE_PERSONA, contact, store, error);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda12_ (void* l, Block1Data* _data1_) {
	TpAccount* account;
	account = _g_object_ref0 (TP_ACCOUNT (l));
	if (tp_account_get_connection (account) == _data1_->conn) {
		TpAccount* _tmp0_;
		_data1_->account_found = (_tmp0_ = _g_object_ref0 (account), _g_object_unref0 (_data1_->account_found), _tmp0_);
		_g_object_unref0 (account);
		return;
	}
	_g_object_unref0 (account);
}


static void __lambda12__gfunc (void* data, gpointer self) {
	_lambda12_ (data, self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->account_found);
		_g_object_unref0 (_data1_->conn);
		g_slice_free (Block1Data, _data1_);
	}
}


static TpAccount* tpf_persona_account_for_connection (TpConnection* conn) {
	TpAccount* result = NULL;
	Block1Data* _data1_;
	TpAccountManager* manager;
	GList* accounts;
	g_return_val_if_fail (conn != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->conn = _g_object_ref0 (conn);
	manager = tp_account_manager_dup ();
	accounts = tp_account_manager_get_valid_accounts (manager);
	_data1_->account_found = NULL;
	g_list_foreach (accounts, __lambda12__gfunc, _data1_);
	result = _g_object_ref0 (_data1_->account_found);
	_g_list_free0 (accounts);
	_g_object_unref0 (manager);
	block1_data_unref (_data1_);
	return result;
}


static void tpf_persona_contact_notify_presence_message (TpfPersona* self) {
	g_return_if_fail (self != NULL);
	folks_presence_set_presence_message ((FolksPresence*) self, tp_contact_get_presence_message (self->priv->_contact));
}


static void tpf_persona_contact_notify_presence_type (TpfPersona* self) {
	g_return_if_fail (self != NULL);
	folks_presence_set_presence_type ((FolksPresence*) self, tpf_persona_folks_presence_type_from_tp (tp_contact_get_presence_type (self->priv->_contact)));
}


static FolksPresenceType tpf_persona_folks_presence_type_from_tp (TpConnectionPresenceType type) {
	FolksPresenceType result = 0;
	switch (type) {
		case TP_CONNECTION_PRESENCE_TYPE_AVAILABLE:
		{
			result = FOLKS_PRESENCE_TYPE_AVAILABLE;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_AWAY:
		{
			result = FOLKS_PRESENCE_TYPE_AWAY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_BUSY:
		{
			result = FOLKS_PRESENCE_TYPE_BUSY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_ERROR:
		{
			result = FOLKS_PRESENCE_TYPE_ERROR;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_EXTENDED_AWAY:
		{
			result = FOLKS_PRESENCE_TYPE_EXTENDED_AWAY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_HIDDEN:
		{
			result = FOLKS_PRESENCE_TYPE_HIDDEN;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_OFFLINE:
		{
			result = FOLKS_PRESENCE_TYPE_OFFLINE;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_UNKNOWN:
		{
			result = FOLKS_PRESENCE_TYPE_UNKNOWN;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_UNSET:
		{
			result = FOLKS_PRESENCE_TYPE_UNSET;
			return result;
		}
		default:
		{
			result = FOLKS_PRESENCE_TYPE_UNKNOWN;
			return result;
		}
	}
}


static void tpf_persona_contact_notify_avatar (TpfPersona* self) {
	GFile* file;
	g_return_if_fail (self != NULL);
	file = _g_object_ref0 (tp_contact_get_avatar_file (self->priv->_contact));
	if (folks_avatar_get_avatar ((FolksAvatar*) self) != file) {
		folks_avatar_set_avatar ((FolksAvatar*) self, file);
	}
	_g_object_unref0 (file);
}


static GFile* tpf_persona_real_get_avatar (FolksAvatar* base) {
	GFile* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = self->priv->_avatar;
	return result;
}


static void tpf_persona_real_set_avatar (FolksAvatar* base, GFile* value) {
	TpfPersona* self;
	GFile* _tmp0_;
	self = (TpfPersona*) base;
	self->priv->_avatar = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_avatar), _tmp0_);
	g_object_notify ((GObject *) self, "avatar");
}


static FolksPresenceType tpf_persona_real_get_presence_type (FolksPresence* base) {
	FolksPresenceType result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = self->priv->_presence_type;
	return result;
}


static void tpf_persona_real_set_presence_type (FolksPresence* base, FolksPresenceType value) {
	TpfPersona* self;
	self = (TpfPersona*) base;
	self->priv->_presence_type = value;
	g_object_notify ((GObject *) self, "presence-type");
}


static const char* tpf_persona_real_get_presence_message (FolksPresence* base) {
	const char* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = self->priv->_presence_message;
	return result;
}


static void tpf_persona_real_set_presence_message (FolksPresence* base, const char* value) {
	TpfPersona* self;
	char* _tmp0_;
	self = (TpfPersona*) base;
	self->priv->_presence_message = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_presence_message), _tmp0_);
	g_object_notify ((GObject *) self, "presence-message");
}


static const char* tpf_persona_real_get_alias (FolksAlias* base) {
	const char* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = self->priv->_alias;
	return result;
}


static void tpf_persona_real_set_alias (FolksAlias* base, const char* value) {
	TpfPersona* self;
	char* _tmp0_;
	self = (TpfPersona*) base;
	if (_vala_strcmp0 (self->priv->_alias, value) == 0) {
		return;
	}
	if (self->priv->is_constructed) {
		tpf_persona_store_change_alias (TPF_PERSONA_STORE (folks_persona_get_store ((FolksPersona*) self)), self, value, NULL, NULL);
	}
	self->priv->_alias = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_alias), _tmp0_);
	g_object_notify ((GObject *) self, "alias");
}


static gboolean tpf_persona_real_get_is_favourite (FolksFavourite* base) {
	gboolean result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = self->priv->_is_favourite;
	return result;
}


static void tpf_persona_real_set_is_favourite (FolksFavourite* base, gboolean value) {
	TpfPersona* self;
	self = (TpfPersona*) base;
	if (self->priv->_is_favourite == value) {
		return;
	}
	if (self->priv->is_constructed) {
		tpf_persona_store_change_is_favourite (TPF_PERSONA_STORE (folks_persona_get_store ((FolksPersona*) self)), (FolksPersona*) self, value, NULL, NULL);
	}
	self->priv->_is_favourite = value;
	g_object_notify ((GObject *) self, "is-favourite");
}


static GHashTable* tpf_persona_real_get_groups (FolksGroups* base) {
	GHashTable* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = self->priv->_groups;
	return result;
}


static void _lambda18_ (void* k, void* v, TpfPersona* self) {
	char* group;
	group = g_strdup ((const char*) k);
	if (GPOINTER_TO_INT (g_hash_table_lookup (self->priv->_groups, group)) == FALSE) {
		_tpf_persona_change_group (self, group, TRUE);
	}
	_g_free0 (group);
}


static void __lambda18__gh_func (void* key, void* value, gpointer self) {
	_lambda18_ (key, value, self);
}


static void _lambda19_ (void* k, void* v, Block2Data* _data2_) {
	TpfPersona * self;
	char* group;
	self = _data2_->self;
	group = g_strdup ((const char*) k);
	if (GPOINTER_TO_INT (g_hash_table_lookup (_data2_->value, group)) == FALSE) {
		_tpf_persona_change_group (self, group, TRUE);
	}
	_g_free0 (group);
}


static void __lambda19__gh_func (void* key, void* value, gpointer self) {
	_lambda19_ (key, value, self);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_hash_table_unref0 (_data2_->value);
		g_slice_free (Block2Data, _data2_);
	}
}


static void tpf_persona_real_set_groups (FolksGroups* base, GHashTable* value) {
	TpfPersona* self;
	Block2Data* _data2_;
	self = (TpfPersona*) base;
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->value = _g_hash_table_ref0 (value);
	g_hash_table_foreach (_data2_->value, __lambda18__gh_func, self);
	g_hash_table_foreach (self->priv->_groups, __lambda19__gh_func, _data2_);
	block2_data_unref (_data2_);
	g_object_notify ((GObject *) self, "groups");
}


TpContact* tpf_persona_get_contact (TpfPersona* self) {
	TpContact* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_contact;
	return result;
}


static void tpf_persona_set_contact (TpfPersona* self, TpContact* value) {
	TpContact* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_contact = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_contact), _tmp0_);
	g_object_notify ((GObject *) self, "contact");
}


static void tpf_persona_class_init (TpfPersonaClass * klass) {
	tpf_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TpfPersonaPrivate));
	G_OBJECT_CLASS (klass)->get_property = tpf_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = tpf_persona_set_property;
	G_OBJECT_CLASS (klass)->finalize = tpf_persona_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_AVATAR, "avatar");
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PRESENCE_TYPE, "presence-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PRESENCE_MESSAGE, "presence-message");
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_ALIAS, "alias");
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_IS_FAVOURITE, "is-favourite");
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_GROUPS, "groups");
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_CONTACT, g_param_spec_object ("contact", "contact", "contact", TP_TYPE_CONTACT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void tpf_persona_folks_alias_interface_init (FolksAliasIface * iface) {
	tpf_persona_folks_alias_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_alias = tpf_persona_real_get_alias;
	iface->set_alias = tpf_persona_real_set_alias;
}


static void tpf_persona_folks_avatar_interface_init (FolksAvatarIface * iface) {
	tpf_persona_folks_avatar_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_avatar = tpf_persona_real_get_avatar;
	iface->set_avatar = tpf_persona_real_set_avatar;
}


static void tpf_persona_folks_favourite_interface_init (FolksFavouriteIface * iface) {
	tpf_persona_folks_favourite_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_is_favourite = tpf_persona_real_get_is_favourite;
	iface->set_is_favourite = tpf_persona_real_set_is_favourite;
}


static void tpf_persona_folks_groups_interface_init (FolksGroupsIface * iface) {
	tpf_persona_folks_groups_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_group = tpf_persona_real_change_group;
	iface->get_groups = tpf_persona_real_get_groups;
	iface->set_groups = tpf_persona_real_set_groups;
}


static void tpf_persona_folks_presence_interface_init (FolksPresenceIface * iface) {
	tpf_persona_folks_presence_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_presence_type = tpf_persona_real_get_presence_type;
	iface->set_presence_type = tpf_persona_real_set_presence_type;
	iface->get_presence_message = tpf_persona_real_get_presence_message;
	iface->set_presence_message = tpf_persona_real_set_presence_message;
}


static void tpf_persona_instance_init (TpfPersona * self) {
	self->priv = TPF_PERSONA_GET_PRIVATE (self);
	self->priv->is_constructed = FALSE;
}


static void tpf_persona_finalize (GObject* obj) {
	TpfPersona * self;
	self = TPF_PERSONA (obj);
	_g_hash_table_unref0 (self->priv->_groups);
	_g_free0 (self->priv->_alias);
	_g_object_unref0 (self->priv->_avatar);
	_g_free0 (self->priv->_presence_message);
	_g_object_unref0 (self->priv->_contact);
	G_OBJECT_CLASS (tpf_persona_parent_class)->finalize (obj);
}


GType tpf_persona_get_type (void) {
	static volatile gsize tpf_persona_type_id__volatile = 0;
	if (g_once_init_enter (&tpf_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TpfPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tpf_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TpfPersona), 0, (GInstanceInitFunc) tpf_persona_instance_init, NULL };
		static const GInterfaceInfo folks_alias_info = { (GInterfaceInitFunc) tpf_persona_folks_alias_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_avatar_info = { (GInterfaceInitFunc) tpf_persona_folks_avatar_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_favourite_info = { (GInterfaceInitFunc) tpf_persona_folks_favourite_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_groups_info = { (GInterfaceInitFunc) tpf_persona_folks_groups_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_presence_info = { (GInterfaceInitFunc) tpf_persona_folks_presence_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tpf_persona_type_id;
		tpf_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "TpfPersona", &g_define_type_info, 0);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_ALIAS, &folks_alias_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_AVATAR, &folks_avatar_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_FAVOURITE, &folks_favourite_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_GROUPS, &folks_groups_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_PRESENCE, &folks_presence_info);
		g_once_init_leave (&tpf_persona_type_id__volatile, tpf_persona_type_id);
	}
	return tpf_persona_type_id__volatile;
}


static void tpf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TpfPersona * self;
	self = TPF_PERSONA (object);
	switch (property_id) {
		case TPF_PERSONA_AVATAR:
		g_value_set_object (value, folks_avatar_get_avatar ((FolksAvatar*) self));
		break;
		case TPF_PERSONA_PRESENCE_TYPE:
		g_value_set_enum (value, folks_presence_get_presence_type ((FolksPresence*) self));
		break;
		case TPF_PERSONA_PRESENCE_MESSAGE:
		g_value_set_string (value, folks_presence_get_presence_message ((FolksPresence*) self));
		break;
		case TPF_PERSONA_ALIAS:
		g_value_set_string (value, folks_alias_get_alias ((FolksAlias*) self));
		break;
		case TPF_PERSONA_IS_FAVOURITE:
		g_value_set_boolean (value, folks_favourite_get_is_favourite ((FolksFavourite*) self));
		break;
		case TPF_PERSONA_GROUPS:
		g_value_set_boxed (value, folks_groups_get_groups ((FolksGroups*) self));
		break;
		case TPF_PERSONA_CONTACT:
		g_value_set_object (value, tpf_persona_get_contact (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void tpf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TpfPersona * self;
	self = TPF_PERSONA (object);
	switch (property_id) {
		case TPF_PERSONA_AVATAR:
		folks_avatar_set_avatar ((FolksAvatar*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_PRESENCE_TYPE:
		folks_presence_set_presence_type ((FolksPresence*) self, g_value_get_enum (value));
		break;
		case TPF_PERSONA_PRESENCE_MESSAGE:
		folks_presence_set_presence_message ((FolksPresence*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_ALIAS:
		folks_alias_set_alias ((FolksAlias*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_IS_FAVOURITE:
		folks_favourite_set_is_favourite ((FolksFavourite*) self, g_value_get_boolean (value));
		break;
		case TPF_PERSONA_GROUPS:
		folks_groups_set_groups ((FolksGroups*) self, g_value_get_boxed (value));
		break;
		case TPF_PERSONA_CONTACT:
		tpf_persona_set_contact (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




