/* individual-aggregator.c generated by valac, the Vala compiler
 * generated from individual-aggregator.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define FOLKS_TYPE_INDIVIDUAL_AGGREGATOR (folks_individual_aggregator_get_type ())
#define FOLKS_INDIVIDUAL_AGGREGATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator))
#define FOLKS_INDIVIDUAL_AGGREGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorClass))
#define FOLKS_IS_INDIVIDUAL_AGGREGATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR))
#define FOLKS_IS_INDIVIDUAL_AGGREGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR))
#define FOLKS_INDIVIDUAL_AGGREGATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorClass))

typedef struct _FolksIndividualAggregator FolksIndividualAggregator;
typedef struct _FolksIndividualAggregatorClass FolksIndividualAggregatorClass;
typedef struct _FolksIndividualAggregatorPrivate FolksIndividualAggregatorPrivate;

#define FOLKS_TYPE_BACKEND_STORE (folks_backend_store_get_type ())
#define FOLKS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStore))
#define FOLKS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))
#define FOLKS_IS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_IS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_BACKEND_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))

typedef struct _FolksBackendStore FolksBackendStore;
typedef struct _FolksBackendStoreClass FolksBackendStoreClass;

#define FOLKS_TYPE_PERSONA_STORE (folks_persona_store_get_type ())
#define FOLKS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore))
#define FOLKS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))
#define FOLKS_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))

typedef struct _FolksPersonaStore FolksPersonaStore;
typedef struct _FolksPersonaStoreClass FolksPersonaStoreClass;

#define FOLKS_TYPE_BACKEND (folks_backend_get_type ())
#define FOLKS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND, FolksBackend))
#define FOLKS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND, FolksBackendClass))
#define FOLKS_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND))
#define FOLKS_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND))
#define FOLKS_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND, FolksBackendClass))

typedef struct _FolksBackend FolksBackend;
typedef struct _FolksBackendClass FolksBackendClass;

#define FOLKS_TYPE_INDIVIDUAL (folks_individual_get_type ())
#define FOLKS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividual))
#define FOLKS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))
#define FOLKS_IS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_IS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_INDIVIDUAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))

typedef struct _FolksIndividual FolksIndividual;
typedef struct _FolksIndividualClass FolksIndividualClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _FolksIndividualAggregatorPrepareData FolksIndividualAggregatorPrepareData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block10Data Block10Data;

#define FOLKS_TYPE_PERSONA_STORE_TRUST (folks_persona_store_trust_get_type ())

#define FOLKS_TYPE_PERSONA (folks_persona_get_type ())
#define FOLKS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA, FolksPersona))
#define FOLKS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA, FolksPersonaClass))
#define FOLKS_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA))
#define FOLKS_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA))
#define FOLKS_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA, FolksPersonaClass))

typedef struct _FolksPersona FolksPersona;
typedef struct _FolksPersonaClass FolksPersonaClass;

#define FOLKS_GROUPS_TYPE_CHANGE_REASON (folks_groups_change_reason_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block11Data Block11Data;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
typedef struct _Block13Data Block13Data;
typedef struct _Block12Data Block12Data;
typedef struct _Block14Data Block14Data;

#define FOLKS_TYPE_ALIAS (folks_alias_get_type ())
#define FOLKS_ALIAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ALIAS, FolksAlias))
#define FOLKS_IS_ALIAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ALIAS))
#define FOLKS_ALIAS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_ALIAS, FolksAliasIface))

typedef struct _FolksAlias FolksAlias;
typedef struct _FolksAliasIface FolksAliasIface;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _FolksIndividualAggregatorAddPersonaFromDetailsData FolksIndividualAggregatorAddPersonaFromDetailsData;
typedef struct _Block15Data Block15Data;
typedef struct _FolksIndividualAggregatorRemoveIndividualData FolksIndividualAggregatorRemoveIndividualData;
typedef struct _FolksIndividualAggregatorRemovePersonaData FolksIndividualAggregatorRemovePersonaData;

#define FOLKS_TYPE_IMABLE (folks_imable_get_type ())
#define FOLKS_IMABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IMABLE, FolksIMable))
#define FOLKS_IS_IMABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IMABLE))
#define FOLKS_IMABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_IMABLE, FolksIMableIface))

typedef struct _FolksIMable FolksIMable;
typedef struct _FolksIMableIface FolksIMableIface;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block17Data Block17Data;
typedef struct _Block16Data Block16Data;
typedef struct _FolksIndividualAggregatorLinkPersonasData FolksIndividualAggregatorLinkPersonasData;
typedef struct _FolksIndividualAggregatorUnlinkIndividualData FolksIndividualAggregatorUnlinkIndividualData;

typedef enum  {
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_NOT_FOUND,
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED,
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_WRITEABLE_STORE
} FolksIndividualAggregatorError;
#define FOLKS_INDIVIDUAL_AGGREGATOR_ERROR folks_individual_aggregator_error_quark ()
struct _FolksIndividualAggregator {
	GObject parent_instance;
	FolksIndividualAggregatorPrivate * priv;
};

struct _FolksIndividualAggregatorClass {
	GObjectClass parent_class;
};

struct _FolksIndividualAggregatorPrivate {
	FolksBackendStore* backend_store;
	GeeHashMap* stores;
	FolksPersonaStore* writeable_store;
	GeeHashSet* backends;
	GHashTable* link_map;
	GHashTable* _individuals;
};

struct _FolksIndividualAggregatorPrepareData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
};

struct _Block10Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	FolksBackend* backend;
};

typedef enum  {
	FOLKS_PERSONA_STORE_TRUST_NONE,
	FOLKS_PERSONA_STORE_TRUST_PARTIAL,
	FOLKS_PERSONA_STORE_TRUST_FULL
} FolksPersonaStoreTrust;

typedef enum  {
	FOLKS_GROUPS_CHANGE_REASON_NONE = 0,
	FOLKS_GROUPS_CHANGE_REASON_OFFLINE = 1,
	FOLKS_GROUPS_CHANGE_REASON_KICKED = 2,
	FOLKS_GROUPS_CHANGE_REASON_BUSY = 3,
	FOLKS_GROUPS_CHANGE_REASON_INVITED = 4,
	FOLKS_GROUPS_CHANGE_REASON_BANNED = 5,
	FOLKS_GROUPS_CHANGE_REASON_ERROR = 6,
	FOLKS_GROUPS_CHANGE_REASON_INVALID_MEMBER = 7,
	FOLKS_GROUPS_CHANGE_REASON_NO_ANSWER = 8,
	FOLKS_GROUPS_CHANGE_REASON_RENAMED = 9,
	FOLKS_GROUPS_CHANGE_REASON_PERMISSION_DENIED = 10,
	FOLKS_GROUPS_CHANGE_REASON_SEPARATED = 11
} FolksGroupsChangeReason;

struct _Block11Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	char* store_id;
	FolksPersonaStore* store;
};

typedef void (*FolksPersonaLinkablePropertyCallback) (const char* link, void* user_data);
struct _Block13Data {
	int _ref_count_;
	Block12Data * _data12_;
	FolksPersonaStoreTrust trust_level;
	GList* candidate_inds;
	GList* final_personas;
	FolksIndividual* final_individual;
};

struct _Block12Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	GList* added_individuals;
};

struct _Block14Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	GList* removed_individuals;
	GeeHashSet* removed_personas;
};

struct _FolksAliasIface {
	GTypeInterface parent_iface;
	const char* (*get_alias) (FolksAlias* self);
	void (*set_alias) (FolksAlias* self, const char* value);
};

typedef enum  {
	FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT,
	FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED
} FolksPersonaStoreError;
#define FOLKS_PERSONA_STORE_ERROR folks_persona_store_error_quark ()
struct _FolksIndividualAggregatorAddPersonaFromDetailsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* parent;
	char* persona_store_type;
	char* persona_store_id;
	GHashTable* details;
	FolksPersona* result;
	char* full_id;
	FolksPersonaStore* store;
	FolksPersona* persona;
	GHashTable* details_copy;
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	GError * e;
	gboolean _tmp2_;
	GList* personas;
	GError * _inner_error_;
};

struct _Block15Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	GHashTable* retval;
};

struct _FolksIndividualAggregatorRemoveIndividualData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
	GList* i;
	gboolean _tmp0_;
	FolksPersona* persona;
	GError * _inner_error_;
};

struct _FolksIndividualAggregatorRemovePersonaData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksPersona* persona;
	GError * _inner_error_;
};

struct _FolksIMableIface {
	GTypeInterface parent_iface;
	GHashTable* (*get_im_addresses) (FolksIMable* self);
	void (*set_im_addresses) (FolksIMable* self, GHashTable* value);
};

struct _Block17Data {
	int _ref_count_;
	Block16Data * _data16_;
	GPtrArray* existing_addresses;
};

struct _Block16Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	GHashTable* protocols;
	gpointer _async_data_;
};

struct _FolksIndividualAggregatorLinkPersonasData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	void* _personas;
	GList* personas;
	GValue addresses_value;
	GHashTable* details;
	FolksPersona* _tmp0_;
	Block16Data* _data16_;
	GError * _inner_error_;
};

struct _FolksIndividualAggregatorUnlinkIndividualData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
	GList* personas;
	GList* p_collection;
	GList* p_it;
	FolksPersona* p;
	GList* persona_collection;
	GList* persona_it;
	FolksPersona* persona;
	GError * _inner_error_;
};


static gpointer folks_individual_aggregator_parent_class = NULL;

GQuark folks_individual_aggregator_error_quark (void);
GType folks_individual_aggregator_get_type (void) G_GNUC_CONST;
GType folks_backend_store_get_type (void) G_GNUC_CONST;
GType folks_persona_store_get_type (void) G_GNUC_CONST;
GType folks_backend_get_type (void) G_GNUC_CONST;
GType folks_individual_get_type (void) G_GNUC_CONST;
#define FOLKS_INDIVIDUAL_AGGREGATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorPrivate))
enum  {
	FOLKS_INDIVIDUAL_AGGREGATOR_DUMMY_PROPERTY,
	FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS
};
static void folks_individual_aggregator_set_individuals (FolksIndividualAggregator* self, GHashTable* value);
void folks_debug_set_flags (const char* debug_flags);
FolksBackendStore* folks_backend_store_new (void);
FolksBackendStore* folks_backend_store_construct (GType object_type);
static void folks_individual_aggregator_backend_available_cb (FolksIndividualAggregator* self, FolksBackendStore* backend_store, FolksBackend* backend);
static void _folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self);
FolksIndividualAggregator* folks_individual_aggregator_new (void);
FolksIndividualAggregator* folks_individual_aggregator_construct (GType object_type);
static void folks_individual_aggregator_prepare_data_free (gpointer _data);
static void folks_individual_aggregator_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_backend_store_load_backends (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_store_load_backends_finish (FolksBackendStore* self, GAsyncResult* _res_, GError** error);
void folks_individual_aggregator_prepare (FolksIndividualAggregator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_prepare_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_prepare_co (FolksIndividualAggregatorPrepareData* data);
static void folks_individual_aggregator_backend_persona_store_added_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store);
static void _folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
static void folks_individual_aggregator_backend_persona_store_removed_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store);
static void _folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
void folks_backend_prepare (FolksBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_prepare_finish (FolksBackend* self, GAsyncResult* _res_, GError** error);
const char* folks_backend_get_name (FolksBackend* self);
static void _lambda29_ (GObject* obj, GAsyncResult* _result_, Block10Data* _data10_);
static void __lambda29__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
static char* folks_individual_aggregator_get_store_full_id (FolksIndividualAggregator* self, const char* type_id, const char* id);
const char* folks_persona_store_get_type_id (FolksPersonaStore* self);
const char* folks_persona_store_get_id (FolksPersonaStore* self);
void folks_persona_store_set_is_writeable (FolksPersonaStore* self, gboolean value);
GType folks_persona_store_trust_get_type (void) G_GNUC_CONST;
void folks_persona_store_set_trust_level (FolksPersonaStore* self, FolksPersonaStoreTrust value);
GType folks_persona_get_type (void) G_GNUC_CONST;
GType folks_groups_change_reason_get_type (void) G_GNUC_CONST;
static void folks_individual_aggregator_personas_changed_cb (FolksIndividualAggregator* self, FolksPersonaStore* store, GList* added, GList* removed, const char* message, FolksPersona* actor, FolksGroupsChangeReason reason);
static void _folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GList* added, GList* removed, const char* message, FolksPersona* actor, FolksGroupsChangeReason reason, gpointer self);
static void folks_individual_aggregator_is_writeable_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec);
static void _folks_individual_aggregator_is_writeable_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void folks_individual_aggregator_trust_level_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec);
static void _folks_individual_aggregator_trust_level_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void folks_persona_store_prepare (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_prepare_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static void _lambda28_ (GObject* obj, GAsyncResult* _result_, Block11Data* _data11_);
static void __lambda28__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
FolksPersonaStore* folks_persona_get_store (FolksPersona* self);
FolksPersonaStoreTrust folks_persona_store_get_trust_level (FolksPersonaStore* self);
const char* folks_persona_get_uid (FolksPersona* self);
const char* folks_persona_get_iid (FolksPersona* self);
const char* folks_individual_get_id (FolksIndividual* self);
char** folks_persona_get_linkable_properties (FolksPersona* self, int* result_length1);
void folks_persona_linkable_property_to_links (FolksPersona* self, const char* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
static void _lambda20_ (const char* l, Block13Data* _data13_);
static void __lambda20__folks_persona_linkable_property_callback (const char* link, gpointer self);
GList* folks_individual_get_personas (FolksIndividual* self);
static void _lambda22_ (void* p, FolksIndividualAggregator* self);
static void __lambda22__gfunc (void* data, gpointer self);
static void _lambda21_ (void* i, Block13Data* _data13_);
static void __lambda21__gfunc (void* data, gpointer self);
FolksIndividual* folks_individual_new (GList* personas);
FolksIndividual* folks_individual_construct (GType object_type, GList* personas);
static void _lambda24_ (const char* l, Block13Data* _data13_);
static void __lambda24__folks_persona_linkable_property_callback (const char* link, gpointer self);
static void _lambda23_ (void* i, Block13Data* _data13_);
static void __lambda23__gfunc (void* data, gpointer self);
void folks_individual_replace (FolksIndividual* self, FolksIndividual* replacement_individual);
static void _lambda25_ (void* i, Block13Data* _data13_);
static void __lambda25__gfunc (void* data, gpointer self);
static void folks_individual_aggregator_individual_removed_cb (FolksIndividualAggregator* self, FolksIndividual* i, FolksIndividual* replacement);
static void _folks_individual_aggregator_individual_removed_cb_folks_individual_removed (FolksIndividual* _sender, FolksIndividual* replacement_individual, gpointer self);
GHashTable* folks_individual_aggregator_get_individuals (FolksIndividualAggregator* self);
static void _g_list_free_g_object_unref (GList* self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (Block13Data* _data13_);
static void _lambda19_ (void* p, Block12Data* _data12_);
static void __lambda19__gfunc (void* data, gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (Block12Data* _data12_);
static GList* folks_individual_aggregator_add_personas (FolksIndividualAggregator* self, GList* added);
static void _lambda27_ (const char* l, FolksIndividualAggregator* self);
static void __lambda27__folks_persona_linkable_property_callback (const char* link, gpointer self);
static void _lambda26_ (void* p, Block14Data* _data14_);
static void __lambda26__gfunc (void* data, gpointer self);
void folks_individual_set_personas (FolksIndividual* self, GList* value);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (Block14Data* _data14_);
gboolean folks_persona_store_get_is_writeable (FolksPersonaStore* self);
GType folks_alias_get_type (void) G_GNUC_CONST;
const char* folks_alias_get_alias (FolksAlias* self);
static void folks_individual_aggregator_add_persona_from_details_data_free (gpointer _data);
static void folks_individual_aggregator_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GHashTable* folks_individual_aggregator_asv_copy (FolksIndividualAggregator* self, GHashTable* asv);
void folks_persona_store_add_persona_from_details (FolksPersonaStore* self, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
GQuark folks_persona_store_error_quark (void);
FolksPersona* folks_persona_store_add_persona_from_details_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
void folks_individual_aggregator_add_persona_from_details (FolksIndividualAggregator* self, FolksIndividual* parent, const char* persona_store_type, const char* persona_store_id, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* folks_individual_aggregator_add_persona_from_details_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_add_persona_from_details_co (FolksIndividualAggregatorAddPersonaFromDetailsData* data);
static GValue* _g_value_dup (GValue* self);
static void _lambda30_ (void* k, void* v, Block15Data* _data15_);
static void __lambda30__gh_func (void* key, void* value, gpointer self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (Block15Data* _data15_);
static void folks_individual_aggregator_remove_individual_data_free (gpointer _data);
static void folks_individual_aggregator_remove_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_persona_store_remove_persona (FolksPersonaStore* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_remove_persona_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
void folks_individual_aggregator_remove_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_remove_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_remove_individual_co (FolksIndividualAggregatorRemoveIndividualData* data);
static void folks_individual_aggregator_remove_persona_data_free (gpointer _data);
static void folks_individual_aggregator_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_individual_aggregator_remove_persona (FolksIndividualAggregator* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_remove_persona_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_remove_persona_co (FolksIndividualAggregatorRemovePersonaData* data);
static void folks_individual_aggregator_link_personas_data_free (gpointer _data);
static void folks_individual_aggregator_link_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType folks_imable_get_type (void) G_GNUC_CONST;
GHashTable* folks_imable_get_im_addresses (FolksIMable* self);
static void _lambda33_ (void* a, Block17Data* _data17_);
static void __lambda33__gfunc (void* data, gpointer self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (Block17Data* _data17_);
static void _lambda32_ (void* k, void* v, Block16Data* _data16_);
static void __lambda32__gh_func (void* key, void* value, gpointer self);
static void _lambda31_ (void* p, Block16Data* _data16_);
static void __lambda31__gfunc (void* data, gpointer self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (Block16Data* _data16_);
void folks_individual_aggregator_link_personas (FolksIndividualAggregator* self, void* _personas, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_link_personas_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_link_personas_co (FolksIndividualAggregatorLinkPersonasData* data);
static void folks_individual_aggregator_unlink_individual_data_free (gpointer _data);
static void folks_individual_aggregator_unlink_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_individual_aggregator_unlink_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_unlink_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_unlink_individual_co (FolksIndividualAggregatorUnlinkIndividualData* data);
static void folks_individual_aggregator_finalize (GObject* obj);
static void folks_individual_aggregator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void folks_individual_aggregator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__POINTER_POINTER_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

GQuark folks_individual_aggregator_error_quark (void) {
	return g_quark_from_static_string ("folks_individual_aggregator_error-quark");
}


static void _folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self) {
	folks_individual_aggregator_backend_available_cb (self, _sender, backend);
}


/**
   * Create a new IndividualAggregator.
   *
   * Clients should connect to the
   * {@link IndividualAggregator.individuals_changed} signal, then call
   * {@link IndividualAggregator.prepare} to load the backends and start
   * aggregating individuals.
   *
   * An example of how to set up an IndividualAggregator:
   * {{{
   *   IndividualAggregator agg = new IndividualAggregator ();
   *   agg.individuals_changed.connect (individuals_changed_cb);
   *   agg.prepare ();
   * }}}
   */
FolksIndividualAggregator* folks_individual_aggregator_construct (GType object_type) {
	FolksIndividualAggregator * self;
	GeeHashMap* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GeeHashSet* _tmp3_;
	FolksBackendStore* _tmp4_;
	self = (FolksIndividualAggregator*) g_object_new (object_type, NULL);
	self->priv->stores = (_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->stores), _tmp0_);
	folks_individual_aggregator_set_individuals (self, _tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref));
	_g_hash_table_unref0 (_tmp1_);
	self->priv->link_map = (_tmp2_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref), _g_hash_table_unref0 (self->priv->link_map), _tmp2_);
	self->priv->backends = (_tmp3_ = gee_hash_set_new (FOLKS_TYPE_BACKEND, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL), _g_object_unref0 (self->priv->backends), _tmp3_);
	folks_debug_set_flags (g_getenv ("FOLKS_DEBUG"));
	self->priv->backend_store = (_tmp4_ = folks_backend_store_new (), _g_object_unref0 (self->priv->backend_store), _tmp4_);
	g_signal_connect_object (self->priv->backend_store, "backend-available", (GCallback) _folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available, self, 0);
	return self;
}


FolksIndividualAggregator* folks_individual_aggregator_new (void) {
	return folks_individual_aggregator_construct (FOLKS_TYPE_INDIVIDUAL_AGGREGATOR);
}


static void folks_individual_aggregator_prepare_data_free (gpointer _data) {
	FolksIndividualAggregatorPrepareData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (FolksIndividualAggregatorPrepareData, data);
}


void folks_individual_aggregator_prepare (FolksIndividualAggregator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorPrepareData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_prepare_data_free);
	_data_->self = g_object_ref (self);
	folks_individual_aggregator_prepare_co (_data_);
}


void folks_individual_aggregator_prepare_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_individual_aggregator_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorPrepareData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_individual_aggregator_prepare_co (data);
}


/**
   * Prepare the IndividualAggregator for use.
   *
   * This loads all the available backends and prepares them for use by the
   * IndividualAggregator. This should be called //after// connecting to the
   * {@link IndividualAggregator.individuals_changed} signal, or a race
   * condition could occur, with the signal being emitted before your code has
   * connected to them, and {@link Individual}s getting "lost" as a result.
   */
static gboolean folks_individual_aggregator_prepare_co (FolksIndividualAggregatorPrepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		folks_backend_store_load_backends (data->self->priv->backend_store, NULL, NULL);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void _folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
	folks_individual_aggregator_backend_persona_store_added_cb (self, _sender, store);
}


static void _folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
	folks_individual_aggregator_backend_persona_store_removed_cb (self, _sender, store);
}


static void _lambda29_ (GObject* obj, GAsyncResult* _result_, Block10Data* _data10_) {
	FolksIndividualAggregator * self;
	GError * _inner_error_;
	self = _data10_->self;
	g_return_if_fail (_result_ != NULL);
	_inner_error_ = NULL;
	{
		folks_backend_prepare_finish (_data10_->backend, _result_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("individual-aggregator.vala:151: Error preparing Backend '%s': %s", folks_backend_get_name (_data10_->backend), e->message);
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda29__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda29_ (source_object, res, self);
	block10_data_unref (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		_g_object_unref0 (_data10_->self);
		_g_object_unref0 (_data10_->backend);
		g_slice_free (Block10Data, _data10_);
	}
}


static void folks_individual_aggregator_backend_available_cb (FolksIndividualAggregator* self, FolksBackendStore* backend_store, FolksBackend* backend) {
	Block10Data* _data10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend_store != NULL);
	g_return_if_fail (backend != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_data10_->backend = _g_object_ref0 (backend);
	g_signal_connect_object (_data10_->backend, "persona-store-added", (GCallback) _folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added, self, 0);
	g_signal_connect_object (_data10_->backend, "persona-store-removed", (GCallback) _folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed, self, 0);
	folks_backend_prepare (_data10_->backend, __lambda29__gasync_ready_callback, block10_data_ref (_data10_));
	block10_data_unref (_data10_);
}


static void _folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GList* added, GList* removed, const char* message, FolksPersona* actor, FolksGroupsChangeReason reason, gpointer self) {
	folks_individual_aggregator_personas_changed_cb (self, _sender, added, removed, message, actor, reason);
}


static void _folks_individual_aggregator_is_writeable_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_aggregator_is_writeable_changed_cb (self, _sender, pspec);
}


static void _folks_individual_aggregator_trust_level_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_aggregator_trust_level_changed_cb (self, _sender, pspec);
}


static void _lambda28_ (GObject* obj, GAsyncResult* _result_, Block11Data* _data11_) {
	FolksIndividualAggregator * self;
	GError * _inner_error_;
	self = _data11_->self;
	g_return_if_fail (_result_ != NULL);
	_inner_error_ = NULL;
	{
		folks_persona_store_prepare_finish (_data11_->store, _result_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("individual-aggregator.vala:184: Error preparing PersonaStore '%s': %s", _data11_->store_id, e->message);
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda28__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda28_ (source_object, res, self);
	block11_data_unref (self);
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_object_unref0 (_data11_->self);
		_g_free0 (_data11_->store_id);
		_g_object_unref0 (_data11_->store);
		g_slice_free (Block11Data, _data11_);
	}
}


static void folks_individual_aggregator_backend_persona_store_added_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store) {
	Block11Data* _data11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (store != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_data11_->store = _g_object_ref0 (store);
	_data11_->store_id = folks_individual_aggregator_get_store_full_id (self, folks_persona_store_get_type_id (_data11_->store), folks_persona_store_get_id (_data11_->store));
	if (_vala_strcmp0 (folks_persona_store_get_type_id (_data11_->store), "key-file") == 0) {
		folks_persona_store_set_is_writeable (_data11_->store, TRUE);
		folks_persona_store_set_trust_level (_data11_->store, FOLKS_PERSONA_STORE_TRUST_FULL);
		self->priv->writeable_store = _data11_->store;
	}
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->stores, _data11_->store_id, _data11_->store);
	g_signal_connect_object (_data11_->store, "personas-changed", (GCallback) _folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed, self, 0);
	g_signal_connect_object ((GObject*) _data11_->store, "notify::is-writeable", (GCallback) _folks_individual_aggregator_is_writeable_changed_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) _data11_->store, "notify::trust-level", (GCallback) _folks_individual_aggregator_trust_level_changed_cb_g_object_notify, self, 0);
	folks_persona_store_prepare (_data11_->store, __lambda28__gasync_ready_callback, block11_data_ref (_data11_));
	block11_data_unref (_data11_);
}


static void folks_individual_aggregator_backend_persona_store_removed_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store) {
	guint _tmp0_;
	GQuark _tmp2_;
	guint _tmp1_;
	GQuark _tmp4_;
	guint _tmp3_;
	char* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (store != NULL);
	g_signal_parse_name ("personas-changed", FOLKS_TYPE_PERSONA_STORE, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed, self);
	g_signal_parse_name ("notify::trust-level", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _folks_individual_aggregator_trust_level_changed_cb_g_object_notify, self);
	g_signal_parse_name ("notify::is-writeable", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) _folks_individual_aggregator_is_writeable_changed_cb_g_object_notify, self);
	if (self->priv->writeable_store == store) {
		self->priv->writeable_store = NULL;
	}
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->stores, _tmp5_ = folks_individual_aggregator_get_store_full_id (self, folks_persona_store_get_type_id (store), folks_persona_store_get_id (store)), NULL);
	_g_free0 (_tmp5_);
}


static char* folks_individual_aggregator_get_store_full_id (FolksIndividualAggregator* self, const char* type_id, const char* id) {
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_id != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	result = (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (type_id, ":", NULL), id, NULL), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static void _lambda20_ (const char* l, Block13Data* _data13_) {
	Block12Data* _data12_;
	FolksIndividualAggregator * self;
	FolksIndividual* candidate_ind;
	_data12_ = _data13_->_data12_;
	self = _data12_->self;
	g_return_if_fail (l != NULL);
	candidate_ind = _g_object_ref0 ((FolksIndividual*) g_hash_table_lookup (self->priv->link_map, (const char*) l));
	if (candidate_ind != NULL) {
		_data13_->candidate_inds = g_list_prepend (_data13_->candidate_inds, _g_object_ref0 (candidate_ind));
	}
	_g_object_unref0 (candidate_ind);
}


static void __lambda20__folks_persona_linkable_property_callback (const char* link, gpointer self) {
	_lambda20_ (link, self);
}


static void _lambda22_ (void* p, FolksIndividualAggregator* self) {
	g_object_ref ((GObject*) FOLKS_PERSONA (p));
}


static void __lambda22__gfunc (void* data, gpointer self) {
	_lambda22_ (data, self);
}


static void _lambda21_ (void* i, Block13Data* _data13_) {
	Block12Data* _data12_;
	FolksIndividualAggregator * self;
	FolksIndividual* individual;
	_data12_ = _data13_->_data12_;
	self = _data12_->self;
	individual = FOLKS_INDIVIDUAL (i);
	g_debug ("individual-aggregator.vala:278:         %s", folks_individual_get_id (individual));
	g_list_foreach (folks_individual_get_personas (individual), __lambda22__gfunc, self);
	_data13_->final_personas = g_list_concat (_data13_->final_personas, g_list_copy (folks_individual_get_personas (individual)));
}


static void __lambda21__gfunc (void* data, gpointer self) {
	_lambda21_ (data, self);
}


static void _lambda24_ (const char* l, Block13Data* _data13_) {
	Block12Data* _data12_;
	FolksIndividualAggregator * self;
	_data12_ = _data13_->_data12_;
	self = _data12_->self;
	g_return_if_fail (l != NULL);
	g_hash_table_replace (self->priv->link_map, g_strdup ((const char*) l), _g_object_ref0 (_data13_->final_individual));
}


static void __lambda24__folks_persona_linkable_property_callback (const char* link, gpointer self) {
	_lambda24_ (link, self);
}


static void _lambda23_ (void* i, Block13Data* _data13_) {
	Block12Data* _data12_;
	FolksIndividualAggregator * self;
	FolksPersona* final_persona;
	_data12_ = _data13_->_data12_;
	self = _data12_->self;
	final_persona = FOLKS_PERSONA (i);
	g_debug ("individual-aggregator.vala:307:         %s", folks_persona_get_uid (final_persona));
	if (_data13_->trust_level != FOLKS_PERSONA_STORE_TRUST_NONE) {
		g_hash_table_replace (self->priv->link_map, g_strdup (folks_persona_get_iid (final_persona)), _g_object_ref0 (_data13_->final_individual));
	}
	if (folks_persona_store_get_trust_level (folks_persona_get_store (final_persona)) == FOLKS_PERSONA_STORE_TRUST_FULL) {
		{
			gint _tmp0_;
			char** prop_name_collection;
			int prop_name_collection_length1;
			int prop_name_it;
			prop_name_collection = folks_persona_get_linkable_properties (final_persona, &_tmp0_);
			prop_name_collection_length1 = _tmp0_;
			for (prop_name_it = 0; prop_name_it < _tmp0_; prop_name_it = prop_name_it + 1) {
				char* prop_name;
				prop_name = g_strdup (prop_name_collection[prop_name_it]);
				{
					GObjectClass* pclass;
					pclass = G_OBJECT_GET_CLASS ((GObject*) final_persona);
					if (g_object_class_find_property (pclass, prop_name) == NULL) {
						g_warning ("Unknown property '%s' in linkable " "property list.", prop_name);
						_g_free0 (prop_name);
						continue;
					}
					folks_persona_linkable_property_to_links (final_persona, prop_name, __lambda24__folks_persona_linkable_property_callback, _data13_);
					_g_free0 (prop_name);
				}
			}
		}
	}
}


static void __lambda23__gfunc (void* data, gpointer self) {
	_lambda23_ (data, self);
}


static void _lambda25_ (void* i, Block13Data* _data13_) {
	Block12Data* _data12_;
	FolksIndividualAggregator * self;
	_data12_ = _data13_->_data12_;
	self = _data12_->self;
	folks_individual_replace (FOLKS_INDIVIDUAL (i), _data13_->final_individual);
}


static void __lambda25__gfunc (void* data, gpointer self) {
	_lambda25_ (data, self);
}


static void _folks_individual_aggregator_individual_removed_cb_folks_individual_removed (FolksIndividual* _sender, FolksIndividual* replacement_individual, gpointer self) {
	folks_individual_aggregator_individual_removed_cb (self, _sender, replacement_individual);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (Block13Data* _data13_) {
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		block12_data_unref (_data13_->_data12_);
		_g_object_unref0 (_data13_->final_individual);
		__g_list_free_g_object_unref0 (_data13_->final_personas);
		__g_list_free_g_object_unref0 (_data13_->candidate_inds);
		g_slice_free (Block13Data, _data13_);
	}
}


static void _lambda19_ (void* p, Block12Data* _data12_) {
	FolksIndividualAggregator * self;
	Block13Data* _data13_;
	FolksPersona* persona;
	FolksIndividual* _tmp1_;
	self = _data12_->self;
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->_data12_ = block12_data_ref (_data12_);
	persona = FOLKS_PERSONA (p);
	_data13_->trust_level = folks_persona_store_get_trust_level (folks_persona_get_store (persona));
	_data13_->candidate_inds = NULL;
	_data13_->final_personas = NULL;
	_data13_->final_individual = NULL;
	g_debug ("individual-aggregator.vala:223: Aggregating persona '%s' on '%s'.", folks_persona_get_uid (persona), folks_persona_get_iid (persona));
	if (_data13_->trust_level != FOLKS_PERSONA_STORE_TRUST_NONE) {
		FolksIndividual* candidate_ind;
		candidate_ind = _g_object_ref0 ((FolksIndividual*) g_hash_table_lookup (self->priv->link_map, folks_persona_get_iid (persona)));
		if (candidate_ind != NULL) {
			g_debug ("individual-aggregator.vala:232:     Found candidate individual '%s' by" \
" IID.", folks_individual_get_id (candidate_ind));
			_data13_->candidate_inds = g_list_prepend (_data13_->candidate_inds, _g_object_ref0 (candidate_ind));
		}
		_g_object_unref0 (candidate_ind);
	}
	if (folks_persona_store_get_trust_level (folks_persona_get_store (persona)) == FOLKS_PERSONA_STORE_TRUST_FULL) {
		{
			gint _tmp0_;
			char** prop_name_collection;
			int prop_name_collection_length1;
			int prop_name_it;
			prop_name_collection = folks_persona_get_linkable_properties (persona, &_tmp0_);
			prop_name_collection_length1 = _tmp0_;
			for (prop_name_it = 0; prop_name_it < _tmp0_; prop_name_it = prop_name_it + 1) {
				char* prop_name;
				prop_name = g_strdup (prop_name_collection[prop_name_it]);
				{
					GObjectClass* pclass;
					pclass = G_OBJECT_GET_CLASS ((GObject*) persona);
					if (g_object_class_find_property (pclass, prop_name) == NULL) {
						g_warning ("Unknown property '%s' in linkable property " "list.", prop_name);
						_g_free0 (prop_name);
						continue;
					}
					folks_persona_linkable_property_to_links (persona, prop_name, __lambda20__folks_persona_linkable_property_callback, _data13_);
					_g_free0 (prop_name);
				}
			}
		}
	}
	_data13_->final_personas = g_list_prepend (_data13_->final_personas, _g_object_ref0 (persona));
	if (_data13_->candidate_inds != NULL) {
		g_debug ("individual-aggregator.vala:267:     Found candidate individuals:");
		g_list_foreach (_data13_->candidate_inds, __lambda21__gfunc, _data13_);
	} else {
		g_debug ("individual-aggregator.vala:295:     Did not find any candidate individ" \
"uals.");
	}
	_data13_->final_individual = (_tmp1_ = folks_individual_new (_data13_->final_personas), _g_object_unref0 (_data13_->final_individual), _tmp1_);
	g_debug ("individual-aggregator.vala:301:     Created new individual '%s' with p" \
"ersonas:", folks_individual_get_id (_data13_->final_individual));
	g_list_foreach (_data13_->final_personas, __lambda23__gfunc, _data13_);
	g_list_foreach (_data13_->candidate_inds, __lambda25__gfunc, _data13_);
	g_signal_connect_object (_data13_->final_individual, "removed", (GCallback) _folks_individual_aggregator_individual_removed_cb_folks_individual_removed, self, 0);
	_data12_->added_individuals = g_list_prepend (_data12_->added_individuals, _g_object_ref0 (_data13_->final_individual));
	g_hash_table_insert (self->priv->_individuals, g_strdup (folks_individual_get_id (_data13_->final_individual)), _g_object_ref0 (_data13_->final_individual));
	block13_data_unref (_data13_);
}


static void __lambda19__gfunc (void* data, gpointer self) {
	_lambda19_ (data, self);
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (Block12Data* _data12_) {
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		_g_object_unref0 (_data12_->self);
		__g_list_free_g_object_unref0 (_data12_->added_individuals);
		g_slice_free (Block12Data, _data12_);
	}
}


static GList* folks_individual_aggregator_add_personas (FolksIndividualAggregator* self, GList* added) {
	GList* result = NULL;
	Block12Data* _data12_;
	g_return_val_if_fail (self != NULL, NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_data12_->added_individuals = NULL;
	g_list_foreach (added, __lambda19__gfunc, _data12_);
	{
		GList* i_collection;
		GList* i_it;
		i_collection = _data12_->added_individuals;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* i;
			i = _g_object_ref0 ((FolksIndividual*) i_it->data);
			{
				g_object_ref ((GObject*) i);
				_g_object_unref0 (i);
			}
		}
	}
	result = g_list_copy (_data12_->added_individuals);
	block12_data_unref (_data12_);
	return result;
}


static void _lambda27_ (const char* l, FolksIndividualAggregator* self) {
	g_return_if_fail (l != NULL);
	g_hash_table_remove (self->priv->link_map, (const char*) l);
}


static void __lambda27__folks_persona_linkable_property_callback (const char* link, gpointer self) {
	_lambda27_ (link, self);
}


static void _lambda26_ (void* p, Block14Data* _data14_) {
	FolksIndividualAggregator * self;
	FolksPersona* persona;
	FolksPersonaStoreTrust trust_level;
	self = _data14_->self;
	persona = FOLKS_PERSONA (p);
	trust_level = folks_persona_store_get_trust_level (folks_persona_get_store (persona));
	gee_abstract_collection_add ((GeeAbstractCollection*) _data14_->removed_personas, persona);
	if (trust_level != FOLKS_PERSONA_STORE_TRUST_NONE) {
		FolksIndividual* ind;
		ind = _g_object_ref0 ((FolksIndividual*) g_hash_table_lookup (self->priv->link_map, folks_persona_get_iid (persona)));
		_data14_->removed_individuals = g_list_prepend (_data14_->removed_individuals, _g_object_ref0 (ind));
		g_hash_table_remove (self->priv->link_map, folks_persona_get_iid (persona));
		_g_object_unref0 (ind);
	}
	if (trust_level == FOLKS_PERSONA_STORE_TRUST_FULL) {
		{
			gint _tmp0_;
			char** prop_name_collection;
			int prop_name_collection_length1;
			int prop_name_it;
			prop_name_collection = folks_persona_get_linkable_properties (persona, &_tmp0_);
			prop_name_collection_length1 = _tmp0_;
			for (prop_name_it = 0; prop_name_it < _tmp0_; prop_name_it = prop_name_it + 1) {
				char* prop_name;
				prop_name = g_strdup (prop_name_collection[prop_name_it]);
				{
					GObjectClass* pclass;
					pclass = G_OBJECT_GET_CLASS ((GObject*) persona);
					if (g_object_class_find_property (pclass, prop_name) == NULL) {
						g_warning ("Unknown property '%s' in linkable property " "list.", prop_name);
						_g_free0 (prop_name);
						continue;
					}
					folks_persona_linkable_property_to_links (persona, prop_name, __lambda27__folks_persona_linkable_property_callback, self);
					_g_free0 (prop_name);
				}
			}
		}
	}
}


static void __lambda26__gfunc (void* data, gpointer self) {
	_lambda26_ (data, self);
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (Block14Data* _data14_) {
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		_g_object_unref0 (_data14_->self);
		_g_object_unref0 (_data14_->removed_personas);
		__g_list_free_g_object_unref0 (_data14_->removed_individuals);
		g_slice_free (Block14Data, _data14_);
	}
}


static void folks_individual_aggregator_personas_changed_cb (FolksIndividualAggregator* self, FolksPersonaStore* store, GList* added, GList* removed, const char* message, FolksPersona* actor, FolksGroupsChangeReason reason) {
	Block14Data* _data14_;
	GList* added_individuals;
	GList* relinked_personas;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	added_individuals = NULL;
	_data14_->removed_individuals = NULL;
	relinked_personas = NULL;
	_data14_->removed_personas = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal);
	if (added != NULL) {
		GList* _tmp0_;
		added_individuals = (_tmp0_ = folks_individual_aggregator_add_personas (self, added), __g_list_free_g_object_unref0 (added_individuals), _tmp0_);
	}
	g_list_foreach (removed, __lambda26__gfunc, _data14_);
	g_debug ("individual-aggregator.vala:420: Removing Individuals due to removed li" \
"nks:");
	{
		GList* individual_collection;
		GList* individual_it;
		individual_collection = _data14_->removed_individuals;
		for (individual_it = individual_collection; individual_it != NULL; individual_it = individual_it->next) {
			FolksIndividual* individual;
			individual = _g_object_ref0 ((FolksIndividual*) individual_it->data);
			{
				if (((FolksIndividual*) g_hash_table_lookup (self->priv->_individuals, folks_individual_get_id (individual))) == NULL) {
					_g_object_unref0 (individual);
					continue;
				}
				g_debug ("individual-aggregator.vala:427:     %s", folks_individual_get_id (individual));
				{
					GList* p_collection;
					GList* p_it;
					p_collection = folks_individual_get_personas (individual);
					for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
						FolksPersona* p;
						p = (FolksPersona*) p_it->data;
						{
							if (gee_abstract_collection_contains ((GeeAbstractCollection*) _data14_->removed_personas, p) == FALSE) {
								relinked_personas = g_list_prepend (relinked_personas, _g_object_ref0 (p));
							}
						}
					}
				}
				g_hash_table_remove (self->priv->_individuals, folks_individual_get_id (individual));
				folks_individual_set_personas (individual, NULL);
				_g_object_unref0 (individual);
			}
		}
	}
	g_debug ("individual-aggregator.vala:441: Relinking Personas:");
	{
		GList* persona_collection;
		GList* persona_it;
		persona_collection = relinked_personas;
		for (persona_it = persona_collection; persona_it != NULL; persona_it = persona_it->next) {
			FolksPersona* persona;
			persona = (FolksPersona*) persona_it->data;
			{
				g_debug ("individual-aggregator.vala:443:     %s", folks_persona_get_uid (persona));
			}
		}
	}
	added_individuals = g_list_concat (added_individuals, folks_individual_aggregator_add_personas (self, relinked_personas));
	if (added_individuals != NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = _data14_->removed_individuals != NULL;
	}
	if (_tmp1_) {
		g_signal_emit_by_name (self, "individuals-changed", added_individuals, _data14_->removed_individuals, NULL, NULL, 0);
	}
	__g_list_free_g_object_unref0 (relinked_personas);
	__g_list_free_g_object_unref0 (added_individuals);
	block14_data_unref (_data14_);
}


static void folks_individual_aggregator_is_writeable_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec) {
	FolksPersonaStore* store;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	store = FOLKS_PERSONA_STORE (object);
	g_assert (((folks_persona_store_get_is_writeable (store) == TRUE) && (store == self->priv->writeable_store)) || ((folks_persona_store_get_is_writeable (store) == FALSE) && (store != self->priv->writeable_store)));
}


static void folks_individual_aggregator_trust_level_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec) {
	FolksPersonaStore* store;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	store = FOLKS_PERSONA_STORE (object);
	if (_vala_strcmp0 (folks_persona_store_get_type_id (store), "key-file") == 0) {
		g_assert (folks_persona_store_get_trust_level (store) == FOLKS_PERSONA_STORE_TRUST_FULL);
	} else {
		g_assert (folks_persona_store_get_trust_level (store) != FOLKS_PERSONA_STORE_TRUST_FULL);
	}
}


static void folks_individual_aggregator_individual_removed_cb (FolksIndividualAggregator* self, FolksIndividual* i, FolksIndividual* replacement) {
	GList* i_list;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	if (((FolksIndividual*) g_hash_table_lookup (self->priv->_individuals, folks_individual_get_id (i))) == NULL) {
		return;
	}
	i_list = NULL;
	i_list = g_list_append (i_list, _g_object_ref0 (i));
	if (replacement != NULL) {
		g_debug ("individual-aggregator.vala:488: Individual '%s' removed (replaced by '" \
"%s')", folks_alias_get_alias ((FolksAlias*) i), folks_alias_get_alias ((FolksAlias*) replacement));
	} else {
		g_debug ("individual-aggregator.vala:493: Individual '%s' removed (not replaced)", folks_alias_get_alias ((FolksAlias*) i));
	}
	g_signal_emit_by_name (self, "individuals-changed", NULL, i_list, NULL, NULL, 0);
	g_hash_table_remove (self->priv->_individuals, folks_individual_get_id (i));
	__g_list_free_g_object_unref0 (i_list);
}


static void folks_individual_aggregator_add_persona_from_details_data_free (gpointer _data) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* data;
	data = _data;
	_g_object_unref0 (data->parent);
	_g_free0 (data->persona_store_type);
	_g_free0 (data->persona_store_id);
	_g_hash_table_unref0 (data->details);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (FolksIndividualAggregatorAddPersonaFromDetailsData, data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void folks_individual_aggregator_add_persona_from_details (FolksIndividualAggregator* self, FolksIndividual* parent, const char* persona_store_type, const char* persona_store_id, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_add_persona_from_details_data_free);
	_data_->self = g_object_ref (self);
	_data_->parent = _g_object_ref0 (parent);
	_data_->persona_store_type = g_strdup (persona_store_type);
	_data_->persona_store_id = g_strdup (persona_store_id);
	_data_->details = _g_hash_table_ref0 (details);
	folks_individual_aggregator_add_persona_from_details_co (_data_);
}


FolksPersona* folks_individual_aggregator_add_persona_from_details_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void folks_individual_aggregator_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_individual_aggregator_add_persona_from_details_co (data);
}


/**
   * Add a new persona in the given {@link PersonaStore} based on the `details`
   * provided.
   *
   * The details hash is a backend-specific mapping of key, value strings.
   * Common keys include:
   *
   *  * contact - service-specific contact ID
   *
   * If `parent` is provided, the new persona will be appended to its ordered
   * list of personas.
   *
   * @param parent an optional {@link Individual} to add the new {@link Persona}
   * to
   * @param persona_store_type the {@link PersonaStore.type_id} of the
   * {@link PersonaStore} to use
   * @param persona_store_id the {@link PersonaStore.id} of the
   * {@link PersonaStore} to use
   * @param details a key-value map of details to use in creating the new
   * {@link Persona}
   */
static gboolean folks_individual_aggregator_add_persona_from_details_co (FolksIndividualAggregatorAddPersonaFromDetailsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->full_id = folks_individual_aggregator_get_store_full_id (data->self, data->persona_store_type, data->persona_store_id);
		data->store = (FolksPersonaStore*) gee_abstract_map_get ((GeeAbstractMap*) data->self->priv->stores, data->full_id);
		if (data->store == NULL) {
			data->_inner_error_ = g_error_new (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_NOT_FOUND, "no store known for type ID '%s' and ID '%s'", folks_persona_store_get_type_id (data->store), folks_persona_store_get_id (data->store));
			{
				if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->store);
					_g_free0 (data->full_id);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				} else {
					_g_object_unref0 (data->store);
					_g_free0 (data->full_id);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
		}
		data->persona = NULL;
		{
			data->details_copy = folks_individual_aggregator_asv_copy (data->self, data->details);
			data->_state_ = 6;
			folks_persona_store_add_persona_from_details (data->store, data->details_copy, folks_individual_aggregator_add_persona_from_details_ready, data);
			return FALSE;
			_state_6:
			data->_tmp0_ = folks_persona_store_add_persona_from_details_finish (data->store, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				_g_hash_table_unref0 (data->details_copy);
				if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
					goto __catch4_folks_persona_store_error;
				}
				_g_hash_table_unref0 (data->details_copy);
				_g_object_unref0 (data->persona);
				_g_object_unref0 (data->store);
				_g_free0 (data->full_id);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			data->persona = (data->_tmp1_ = data->_tmp0_, _g_object_unref0 (data->persona), data->_tmp1_);
			_g_hash_table_unref0 (data->details_copy);
		}
		goto __finally4;
		__catch4_folks_persona_store_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				data->_inner_error_ = g_error_new (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED, "failed to add contact for store type '%s', ID '%s': %s", data->persona_store_type, data->persona_store_id, data->e->message);
				{
					_g_error_free0 (data->e);
					_g_object_unref0 (data->persona);
					_g_object_unref0 (data->store);
					_g_free0 (data->full_id);
					goto __finally4;
				}
				_g_error_free0 (data->e);
			}
		}
		__finally4:
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->persona);
				_g_object_unref0 (data->store);
				_g_free0 (data->full_id);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				_g_object_unref0 (data->persona);
				_g_object_unref0 (data->store);
				_g_free0 (data->full_id);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		if (data->parent != NULL) {
			data->_tmp2_ = data->persona != NULL;
		} else {
			data->_tmp2_ = FALSE;
		}
		if (data->_tmp2_) {
			data->personas = g_list_copy (folks_individual_get_personas (data->parent));
			data->personas = g_list_append (data->personas, data->persona);
			folks_individual_set_personas (data->parent, data->personas);
			_g_list_free0 (data->personas);
		}
		data->result = data->persona;
		_g_object_unref0 (data->store);
		_g_free0 (data->full_id);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->persona);
		_g_object_unref0 (data->store);
		_g_free0 (data->full_id);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void _lambda30_ (void* k, void* v, Block15Data* _data15_) {
	FolksIndividualAggregator * self;
	self = _data15_->self;
	g_hash_table_insert (_data15_->retval, g_strdup ((const char*) k), __g_value_dup0 ((GValue*) v));
}


static void __lambda30__gh_func (void* key, void* value, gpointer self) {
	_lambda30_ (key, value, self);
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}


static void block15_data_unref (Block15Data* _data15_) {
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		_g_object_unref0 (_data15_->self);
		_g_hash_table_unref0 (_data15_->retval);
		g_slice_free (Block15Data, _data15_);
	}
}


static GHashTable* folks_individual_aggregator_asv_copy (FolksIndividualAggregator* self, GHashTable* asv) {
	GHashTable* result = NULL;
	Block15Data* _data15_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (asv != NULL, NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_data15_->retval = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	g_hash_table_foreach (asv, __lambda30__gh_func, _data15_);
	result = _g_hash_table_ref0 (_data15_->retval);
	block15_data_unref (_data15_);
	return result;
}


static void folks_individual_aggregator_remove_individual_data_free (gpointer _data) {
	FolksIndividualAggregatorRemoveIndividualData* data;
	data = _data;
	_g_object_unref0 (data->individual);
	g_object_unref (data->self);
	g_slice_free (FolksIndividualAggregatorRemoveIndividualData, data);
}


void folks_individual_aggregator_remove_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorRemoveIndividualData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_remove_individual);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_remove_individual_data_free);
	_data_->self = g_object_ref (self);
	_data_->individual = _g_object_ref0 (individual);
	folks_individual_aggregator_remove_individual_co (_data_);
}


void folks_individual_aggregator_remove_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_individual_aggregator_remove_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorRemoveIndividualData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_individual_aggregator_remove_individual_co (data);
}


/**
   * Completely remove the individual and all of its personas from their
   * backing stores.
   *
   * @param individual the {@link Individual} to remove
   */
static gboolean folks_individual_aggregator_remove_individual_co (FolksIndividualAggregatorRemoveIndividualData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 7:
		goto _state_7;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			data->i = folks_individual_get_personas (data->individual);
			data->_tmp0_ = TRUE;
			while (TRUE) {
				if (!data->_tmp0_) {
					data->i = data->i->next;
				}
				data->_tmp0_ = FALSE;
				if (!(data->i != NULL)) {
					break;
				}
				data->persona = FOLKS_PERSONA ((FolksPersona*) data->i->data);
				data->_state_ = 7;
				folks_persona_store_remove_persona (folks_persona_get_store (data->persona), data->persona, folks_individual_aggregator_remove_individual_ready, data);
				return FALSE;
				_state_7:
				folks_persona_store_remove_persona_finish (folks_persona_get_store (data->persona), data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
			}
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void folks_individual_aggregator_remove_persona_data_free (gpointer _data) {
	FolksIndividualAggregatorRemovePersonaData* data;
	data = _data;
	_g_object_unref0 (data->persona);
	g_object_unref (data->self);
	g_slice_free (FolksIndividualAggregatorRemovePersonaData, data);
}


void folks_individual_aggregator_remove_persona (FolksIndividualAggregator* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorRemovePersonaData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_remove_persona_data_free);
	_data_->self = g_object_ref (self);
	_data_->persona = _g_object_ref0 (persona);
	folks_individual_aggregator_remove_persona_co (_data_);
}


void folks_individual_aggregator_remove_persona_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorRemovePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_individual_aggregator_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorRemovePersonaData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_individual_aggregator_remove_persona_co (data);
}


/**
   * Completely remove the persona from its backing store.
   *
   * This will leave other personas in the same individual alone.
   *
   * @param persona the {@link Persona} to remove
   */
static gboolean folks_individual_aggregator_remove_persona_co (FolksIndividualAggregatorRemovePersonaData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 8:
		goto _state_8;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_state_ = 8;
		folks_persona_store_remove_persona (folks_persona_get_store (data->persona), data->persona, folks_individual_aggregator_remove_persona_ready, data);
		return FALSE;
		_state_8:
		folks_persona_store_remove_persona_finish (folks_persona_get_store (data->persona), data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void folks_individual_aggregator_link_personas_data_free (gpointer _data) {
	FolksIndividualAggregatorLinkPersonasData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (FolksIndividualAggregatorLinkPersonasData, data);
}


void folks_individual_aggregator_link_personas (FolksIndividualAggregator* self, void* _personas, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorLinkPersonasData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorLinkPersonasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_link_personas);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_link_personas_data_free);
	_data_->self = g_object_ref (self);
	_data_->_personas = _personas;
	folks_individual_aggregator_link_personas_co (_data_);
}


void folks_individual_aggregator_link_personas_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorLinkPersonasData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_individual_aggregator_link_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorLinkPersonasData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_individual_aggregator_link_personas_co (data);
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static void _lambda33_ (void* a, Block17Data* _data17_) {
	Block16Data* _data16_;
	FolksIndividualAggregator * self;
	const char* address;
	_data16_ = _data17_->_data16_;
	self = _data16_->self;
	address = (const char*) a;
	g_ptr_array_add (_data17_->existing_addresses, g_strdup (address));
}


static void __lambda33__gfunc (void* data, gpointer self) {
	_lambda33_ (data, self);
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}


static void block17_data_unref (Block17Data* _data17_) {
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		block16_data_unref (_data17_->_data16_);
		_g_ptr_array_unref0 (_data17_->existing_addresses);
		g_slice_free (Block17Data, _data17_);
	}
}


static void _lambda32_ (void* k, void* v, Block16Data* _data16_) {
	FolksIndividualAggregator * self;
	Block17Data* _data17_;
	const char* protocol;
	GPtrArray* addresses;
	self = _data16_->self;
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->_data16_ = block16_data_ref (_data16_);
	protocol = (const char*) k;
	addresses = (GPtrArray*) v;
	_data17_->existing_addresses = _g_ptr_array_ref0 ((GPtrArray*) g_hash_table_lookup (_data16_->protocols, protocol));
	if (_data17_->existing_addresses == NULL) {
		GPtrArray* _tmp0_;
		_data17_->existing_addresses = (_tmp0_ = g_ptr_array_new_with_free_func (g_free), _g_ptr_array_unref0 (_data17_->existing_addresses), _tmp0_);
		g_hash_table_insert (_data16_->protocols, g_strdup (protocol), _g_ptr_array_ref0 (_data17_->existing_addresses));
	}
	g_ptr_array_foreach (addresses, __lambda33__gfunc, _data17_);
	block17_data_unref (_data17_);
}


static void __lambda32__gh_func (void* key, void* value, gpointer self) {
	_lambda32_ (key, value, self);
}


static void _lambda31_ (void* p, Block16Data* _data16_) {
	FolksIndividualAggregator * self;
	FolksPersona* persona;
	self = _data16_->self;
	persona = FOLKS_PERSONA (p);
	g_hash_table_foreach (folks_imable_get_im_addresses (FOLKS_IMABLE (persona)), __lambda32__gh_func, _data16_);
}


static void __lambda31__gfunc (void* data, gpointer self) {
	_lambda31_ (data, self);
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}


static void block16_data_unref (Block16Data* _data16_) {
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		_g_object_unref0 (_data16_->self);
		_g_hash_table_unref0 (_data16_->protocols);
		g_slice_free (Block16Data, _data16_);
	}
}


static gboolean folks_individual_aggregator_link_personas_co (FolksIndividualAggregatorLinkPersonasData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 9:
		goto _state_9;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_data16_ = g_slice_new0 (Block16Data);
		data->_data16_->_ref_count_ = 1;
		data->_data16_->self = g_object_ref (data->self);
		data->_data16_->_async_data_ = data;
		data->personas = (GList*) data->_personas;
		if (data->self->priv->writeable_store == NULL) {
			data->_inner_error_ = g_error_new_literal (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_WRITEABLE_STORE, "Can't link personas with no writeable store.");
			{
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				block16_data_unref (data->_data16_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
		}
		if (data->personas->next == NULL) {
			block16_data_unref (data->_data16_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		g_assert (_vala_strcmp0 (folks_persona_store_get_type_id (data->self->priv->writeable_store), "key-file") == 0);
		data->_data16_->protocols = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_ptr_array_unref);
		g_list_foreach (data->personas, __lambda31__gfunc, data->_data16_);
		g_value_init (&data->addresses_value, G_TYPE_HASH_TABLE);
		g_value_set_boxed (&data->addresses_value, data->_data16_->protocols);
		data->details = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
		g_hash_table_insert (data->details, g_strdup ("im-addresses"), __g_value_dup0 (&data->addresses_value));
		data->_state_ = 9;
		folks_individual_aggregator_add_persona_from_details (data->self, NULL, folks_persona_store_get_type_id (data->self->priv->writeable_store), folks_persona_store_get_id (data->self->priv->writeable_store), data->details, folks_individual_aggregator_link_personas_ready, data);
		return FALSE;
		_state_9:
		data->_tmp0_ = folks_individual_aggregator_add_persona_from_details_finish (data->self, data->_res_, &data->_inner_error_);
		_g_object_unref0 (data->_tmp0_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_hash_table_unref0 (data->details);
			G_IS_VALUE (&data->addresses_value) ? (g_value_unset (&data->addresses_value), NULL) : NULL;
			block16_data_unref (data->_data16_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		_g_hash_table_unref0 (data->details);
		G_IS_VALUE (&data->addresses_value) ? (g_value_unset (&data->addresses_value), NULL) : NULL;
		block16_data_unref (data->_data16_);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void folks_individual_aggregator_unlink_individual_data_free (gpointer _data) {
	FolksIndividualAggregatorUnlinkIndividualData* data;
	data = _data;
	_g_object_unref0 (data->individual);
	g_object_unref (data->self);
	g_slice_free (FolksIndividualAggregatorUnlinkIndividualData, data);
}


void folks_individual_aggregator_unlink_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorUnlinkIndividualData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_unlink_individual);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_unlink_individual_data_free);
	_data_->self = g_object_ref (self);
	_data_->individual = _g_object_ref0 (individual);
	folks_individual_aggregator_unlink_individual_co (_data_);
}


void folks_individual_aggregator_unlink_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_individual_aggregator_unlink_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorUnlinkIndividualData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_individual_aggregator_unlink_individual_co (data);
}


static gboolean folks_individual_aggregator_unlink_individual_co (FolksIndividualAggregatorUnlinkIndividualData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 10:
		goto _state_10;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_debug ("individual-aggregator.vala:670: Unlinking Individual '%s', deleting Pe" \
"rsonas:", folks_alias_get_alias ((FolksAlias*) data->individual));
		data->personas = g_list_copy (folks_individual_get_personas (data->individual));
		{
			data->p_collection = data->personas;
			for (data->p_it = data->p_collection; data->p_it != NULL; data->p_it = data->p_it->next) {
				data->p = _g_object_ref0 ((FolksPersona*) data->p_it->data);
				{
					g_object_ref ((GObject*) data->p);
					_g_object_unref0 (data->p);
				}
			}
		}
		{
			data->persona_collection = data->personas;
			for (data->persona_it = data->persona_collection; data->persona_it != NULL; data->persona_it = data->persona_it->next) {
				data->persona = (FolksPersona*) data->persona_it->data;
				{
					if (folks_persona_get_store (data->persona) == data->self->priv->writeable_store) {
						g_debug ("individual-aggregator.vala:684:     %s", folks_persona_get_uid (data->persona));
						data->_state_ = 10;
						folks_persona_store_remove_persona (data->self->priv->writeable_store, data->persona, folks_individual_aggregator_unlink_individual_ready, data);
						return FALSE;
						_state_10:
						folks_persona_store_remove_persona_finish (data->self->priv->writeable_store, data->_res_, &data->_inner_error_);
						if (data->_inner_error_ != NULL) {
							g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
							g_error_free (data->_inner_error_);
							__g_list_free_g_object_unref0 (data->personas);
							{
								if (data->_state_ == 0) {
									g_simple_async_result_complete_in_idle (data->_async_result);
								} else {
									g_simple_async_result_complete (data->_async_result);
								}
								g_object_unref (data->_async_result);
								return FALSE;
							}
						}
					}
				}
			}
		}
		__g_list_free_g_object_unref0 (data->personas);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


GHashTable* folks_individual_aggregator_get_individuals (FolksIndividualAggregator* self) {
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_individuals;
	return result;
}


static void folks_individual_aggregator_set_individuals (FolksIndividualAggregator* self, GHashTable* value) {
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_individuals = (_tmp0_ = _g_hash_table_ref0 (value), _g_hash_table_unref0 (self->priv->_individuals), _tmp0_);
	g_object_notify ((GObject *) self, "individuals");
}


static void folks_individual_aggregator_class_init (FolksIndividualAggregatorClass * klass) {
	folks_individual_aggregator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksIndividualAggregatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = folks_individual_aggregator_get_property;
	G_OBJECT_CLASS (klass)->set_property = folks_individual_aggregator_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_individual_aggregator_finalize;
	/**
	   * A table mapping {@link Individual.id}s to their {@link Individual}s.
	   *
	   * This is the canonical set of {@link Individual}s provided by this
	   * IndividualAggregator.
	   *
	   * {@link Individual}s may be added or removed using
	   * {@link IndividualAggregator.add_persona_from_details} and
	   * {@link IndividualAggregator.remove_individual}, respectively.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS, g_param_spec_boxed ("individuals", "individuals", "individuals", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Emitted when one or more {@link Individual}s are added to or removed from
	   * the aggregator.
	   *
	   * This will not be emitted until after {@link IndividualAggregator.prepare}
	   * has been called.
	   *
	   * @param added a list of {@link Individual}s which have been removed
	   * @param removed a list of {@link Individual}s which have been removed
	   * @param message a string message from the backend, if any
	   * @param actor the {@link Persona} who made the change, if known
	   * @param reason the reason for the change
	   */
	g_signal_new ("individuals_changed", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_POINTER_STRING_OBJECT_ENUM, G_TYPE_NONE, 5, G_TYPE_POINTER, G_TYPE_POINTER, G_TYPE_STRING, FOLKS_TYPE_PERSONA, FOLKS_GROUPS_TYPE_CHANGE_REASON);
}


static void folks_individual_aggregator_instance_init (FolksIndividualAggregator * self) {
	self->priv = FOLKS_INDIVIDUAL_AGGREGATOR_GET_PRIVATE (self);
}


static void folks_individual_aggregator_finalize (GObject* obj) {
	FolksIndividualAggregator * self;
	self = FOLKS_INDIVIDUAL_AGGREGATOR (obj);
	_g_object_unref0 (self->priv->backend_store);
	_g_object_unref0 (self->priv->stores);
	_g_object_unref0 (self->priv->backends);
	_g_hash_table_unref0 (self->priv->link_map);
	_g_hash_table_unref0 (self->priv->_individuals);
	G_OBJECT_CLASS (folks_individual_aggregator_parent_class)->finalize (obj);
}


/**
 * Allows access to the {@link Individual}s which have been created through
 * aggregation of all the {@link Persona}s provided by the various
 * {@link Backend}s. This is the main interface for client applications.
 */
GType folks_individual_aggregator_get_type (void) {
	static volatile gsize folks_individual_aggregator_type_id__volatile = 0;
	if (g_once_init_enter (&folks_individual_aggregator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksIndividualAggregatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_individual_aggregator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksIndividualAggregator), 0, (GInstanceInitFunc) folks_individual_aggregator_instance_init, NULL };
		GType folks_individual_aggregator_type_id;
		folks_individual_aggregator_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksIndividualAggregator", &g_define_type_info, 0);
		g_once_init_leave (&folks_individual_aggregator_type_id__volatile, folks_individual_aggregator_type_id);
	}
	return folks_individual_aggregator_type_id__volatile;
}


static void folks_individual_aggregator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksIndividualAggregator * self;
	self = FOLKS_INDIVIDUAL_AGGREGATOR (object);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS:
		g_value_set_boxed (value, folks_individual_aggregator_get_individuals (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void folks_individual_aggregator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksIndividualAggregator * self;
	self = FOLKS_INDIVIDUAL_AGGREGATOR (object);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS:
		folks_individual_aggregator_set_individuals (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__POINTER_POINTER_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_POINTER_STRING_OBJECT_ENUM) (gpointer data1, gpointer arg_1, gpointer arg_2, const char* arg_3, gpointer arg_4, gint arg_5, gpointer data2);
	register GMarshalFunc_VOID__POINTER_POINTER_STRING_OBJECT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_POINTER_STRING_OBJECT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_string (param_values + 3), g_value_get_object (param_values + 4), g_value_get_enum (param_values + 5), data2);
}



