/* persona.c generated by valac 0.9.7-dirty, the Vala compiler
 * generated from persona.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_TYPE_PERSONA (folks_persona_get_type ())
#define FOLKS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA, FolksPersona))
#define FOLKS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA, FolksPersonaClass))
#define FOLKS_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA))
#define FOLKS_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA))
#define FOLKS_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA, FolksPersonaClass))

typedef struct _FolksPersona FolksPersona;
typedef struct _FolksPersonaClass FolksPersonaClass;
typedef struct _FolksPersonaPrivate FolksPersonaPrivate;

#define FOLKS_TYPE_PERSONA_STORE (folks_persona_store_get_type ())
#define FOLKS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore))
#define FOLKS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))
#define FOLKS_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))

typedef struct _FolksPersonaStore FolksPersonaStore;
typedef struct _FolksPersonaStoreClass FolksPersonaStoreClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef void (*FolksPersonaLinkablePropertyCallback) (const char* link, void* user_data);
struct _FolksPersona {
	GObject parent_instance;
	FolksPersonaPrivate * priv;
};

struct _FolksPersonaClass {
	GObjectClass parent_class;
	void (*linkable_property_to_links) (FolksPersona* self, const char* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
};

struct _FolksPersonaPrivate {
	char* _iid;
	char* _uid;
	char* _display_id;
	FolksPersonaStore* _store;
	char** _linkable_properties;
	gint _linkable_properties_length1;
	gint __linkable_properties_size_;
};


static gpointer folks_persona_parent_class = NULL;

GType folks_persona_get_type (void) G_GNUC_CONST;
GType folks_persona_store_get_type (void) G_GNUC_CONST;
#define FOLKS_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_PERSONA, FolksPersonaPrivate))
enum  {
	FOLKS_PERSONA_DUMMY_PROPERTY,
	FOLKS_PERSONA_IID,
	FOLKS_PERSONA_UID,
	FOLKS_PERSONA_DISPLAY_ID,
	FOLKS_PERSONA_STORE,
	FOLKS_PERSONA_LINKABLE_PROPERTIES
};
void folks_persona_linkable_property_to_links (FolksPersona* self, const char* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
static void folks_persona_real_linkable_property_to_links (FolksPersona* self, const char* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
static char* folks_persona_escape_uid_component (const char* component);
static char* folks_persona_unescape_uid_component (const char* component);
char* folks_persona_build_uid (const char* backend_name, const char* persona_store_id, const char* persona_id);
void folks_persona_split_uid (const char* uid, char** backend_name, char** persona_store_id, char** persona_id);
FolksPersona* folks_persona_construct (GType object_type);
const char* folks_persona_get_iid (FolksPersona* self);
static void folks_persona_set_iid (FolksPersona* self, const char* value);
const char* folks_persona_get_uid (FolksPersona* self);
static void folks_persona_set_uid (FolksPersona* self, const char* value);
const char* folks_persona_get_display_id (FolksPersona* self);
static void folks_persona_set_display_id (FolksPersona* self, const char* value);
FolksPersonaStore* folks_persona_get_store (FolksPersona* self);
static void folks_persona_set_store (FolksPersona* self, FolksPersonaStore* value);
char** folks_persona_get_linkable_properties (FolksPersona* self, int* result_length1);
void folks_persona_set_linkable_properties (FolksPersona* self, char** value, int value_length1);
static char** _vala_array_dup1 (char** self, int length);
static void folks_persona_finalize (GObject* obj);
static void folks_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void folks_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



/**
   * Produce one or more mapping strings for the given property's value.
   *
   * This is a virtual method, to be overridden by subclasses of {@link Persona}
   * who have linkable properties. Each of their linkable properties should be
   * handled by their implementation of this function, examining the current
   * value of the property and calling `callback` with one or more mapping
   * strings for the property's value. Each of these mapping strings will be
   * added to the {@link IndividualAggregator}'s link map, related to the
   * {@link Individual} instance which contains this {@link Persona}.
   *
   * @see Persona.linkable_properties
   */
static void folks_persona_real_linkable_property_to_links (FolksPersona* self, const char* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop_name != NULL);
	g_assert_not_reached ();
}


void folks_persona_linkable_property_to_links (FolksPersona* self, const char* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target) {
	FOLKS_PERSONA_GET_CLASS (self)->linkable_property_to_links (self, prop_name, callback, callback_target);
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static char* folks_persona_escape_uid_component (const char* component) {
	char* result = NULL;
	char* escaped;
	g_return_val_if_fail (component != NULL, NULL);
	escaped = string_replace (component, "\\", "\\\\");
	result = string_replace (escaped, ":", "\\:");
	_g_free0 (escaped);
	return result;
}


static char* folks_persona_unescape_uid_component (const char* component) {
	char* result = NULL;
	char* unescaped;
	g_return_val_if_fail (component != NULL, NULL);
	unescaped = string_replace (component, "\\:", ":");
	result = string_replace (unescaped, "\\", "\\\\");
	_g_free0 (unescaped);
	return result;
}


/**
   * Build a UID from the given components.
   *
   * Each component is escaped before the UID is built.
   *
   * @param backend_name the {@link Backend.name}
   * @param persona_store_id the {@link PersonaStore.id}
   * @param persona_id the Persona identifier (backend-specific)
   * @return a valid UID
   * @see Persona.split_uid
   */
char* folks_persona_build_uid (const char* backend_name, const char* persona_store_id, const char* persona_id) {
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	g_return_val_if_fail (backend_name != NULL, NULL);
	g_return_val_if_fail (persona_store_id != NULL, NULL);
	g_return_val_if_fail (persona_id != NULL, NULL);
	result = (_tmp3_ = g_strdup_printf ("%s:%s:%s", _tmp0_ = folks_persona_escape_uid_component (backend_name), _tmp1_ = folks_persona_escape_uid_component (persona_store_id), _tmp2_ = folks_persona_escape_uid_component (persona_id)), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp3_);
	return result;
}


/**
   * Split a UID into its component parts.
   *
   * Each component is unescaped before being returned. The UID //must// be
   * correctly formed.
   *
   * @param uid a valid UID
   * @param backend_name the {@link Backend.name}
   * @param persona_store_id the {@link PersonaStore.id}
   * @param persona_id the Persona identifier (backend-specific)
   * @see Persona.build_uid
   */
void folks_persona_split_uid (const char* uid, char** backend_name, char** persona_store_id, char** persona_id) {
	gsize backend_name_length;
	gsize persona_store_id_length;
	gboolean escaped;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	g_return_if_fail (uid != NULL);
	if (backend_name != NULL) {
		*backend_name = NULL;
	}
	if (persona_store_id != NULL) {
		*persona_store_id = NULL;
	}
	if (persona_id != NULL) {
		*persona_id = NULL;
	}
	g_assert (g_utf8_validate (uid, -1, NULL));
	backend_name_length = (gsize) 0;
	persona_store_id_length = (gsize) 0;
	escaped = FALSE;
	{
		const char* i;
		i = uid;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i = g_utf8_next_char (i);
				}
				_tmp0_ = FALSE;
				if (!(g_utf8_get_char (i) != '\0')) {
					break;
				}
				if (g_utf8_get_char (i) == '\\') {
					escaped = !escaped;
				} else {
					gboolean _tmp1_ = FALSE;
					if (escaped == FALSE) {
						_tmp1_ = g_utf8_get_char (i) == ':';
					} else {
						_tmp1_ = FALSE;
					}
					if (_tmp1_) {
						if (backend_name_length == 0) {
							backend_name_length = ((gchar*) i) - ((gchar*) uid);
						} else {
							persona_store_id_length = ((((gchar*) i) - ((gchar*) uid)) - backend_name_length) - 1;
						}
					}
				}
			}
		}
	}
	g_assert ((backend_name_length != 0) && (persona_store_id_length != 0));
	*backend_name = (_tmp3_ = folks_persona_unescape_uid_component (_tmp2_ = g_strndup (uid, backend_name_length)), _g_free0 (*backend_name), _tmp3_);
	_g_free0 (_tmp2_);
	*persona_store_id = (_tmp5_ = folks_persona_unescape_uid_component (_tmp4_ = g_strndup ((const char*) ((((gchar*) uid) + backend_name_length) + 1), persona_store_id_length)), _g_free0 (*persona_store_id), _tmp5_);
	_g_free0 (_tmp4_);
	*persona_id = (_tmp6_ = folks_persona_unescape_uid_component ((const char*) (((((gchar*) uid) + backend_name_length) + persona_store_id_length) + 2)), _g_free0 (*persona_id), _tmp6_);
}


FolksPersona* folks_persona_construct (GType object_type) {
	FolksPersona * self;
	self = (FolksPersona*) g_object_new (object_type, NULL);
	return self;
}


const char* folks_persona_get_iid (FolksPersona* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_iid;
	return result;
}


static void folks_persona_set_iid (FolksPersona* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_iid = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_iid), _tmp0_);
	g_object_notify ((GObject *) self, "iid");
}


const char* folks_persona_get_uid (FolksPersona* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_uid;
	return result;
}


static void folks_persona_set_uid (FolksPersona* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_uid = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_uid), _tmp0_);
	g_object_notify ((GObject *) self, "uid");
}


const char* folks_persona_get_display_id (FolksPersona* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_display_id;
	return result;
}


static void folks_persona_set_display_id (FolksPersona* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_display_id = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_display_id), _tmp0_);
	g_object_notify ((GObject *) self, "display-id");
}


FolksPersonaStore* folks_persona_get_store (FolksPersona* self) {
	FolksPersonaStore* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_store;
	return result;
}


static void folks_persona_set_store (FolksPersona* self, FolksPersonaStore* value) {
	g_return_if_fail (self != NULL);
	self->priv->_store = value;
	g_object_notify ((GObject *) self, "store");
}


char** folks_persona_get_linkable_properties (FolksPersona* self, int* result_length1) {
	char** result;
	char** _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp0_ = self->priv->_linkable_properties, *result_length1 = self->priv->_linkable_properties_length1, _tmp0_);
	return result;
}


static char** _vala_array_dup1 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void folks_persona_set_linkable_properties (FolksPersona* self, char** value, int value_length1) {
	char** _tmp0_;
	char** _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_linkable_properties = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup1 (_tmp0_, value_length1)), self->priv->_linkable_properties = (_vala_array_free (self->priv->_linkable_properties, self->priv->_linkable_properties_length1, (GDestroyNotify) g_free), NULL), self->priv->_linkable_properties_length1 = value_length1, self->priv->__linkable_properties_size_ = self->priv->_linkable_properties_length1, _tmp1_);
	g_object_notify ((GObject *) self, "linkable-properties");
}


static void folks_persona_class_init (FolksPersonaClass * klass) {
	folks_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksPersonaPrivate));
	FOLKS_PERSONA_CLASS (klass)->linkable_property_to_links = folks_persona_real_linkable_property_to_links;
	G_OBJECT_CLASS (klass)->get_property = folks_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = folks_persona_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_persona_finalize;
	/**
	   * The internal ID used to represent the Persona for linking.
	   *
	   * This is opaque, and shouldn't be parsed or considered meaningful by
	   * clients.
	   *
	   * The internal ID should be unique within a backend, but may not be unique
	   * across backends, so that links can be made between Personas with similar
	   * internal IDs.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_IID, g_param_spec_string ("iid", "iid", "iid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The universal ID used to represent the Persona outside its {@link Backend}.
	   *
	   * This is opaque, and should only be parsed by clients using
	   * {@link Persona.split_uid}.
	   *
	   * This is the canonical way to refer to any Persona. It is guaranteed to be
	   * unique within the Persona's {@link PersonaStore}.
	   *
	   * @see Persona.build_uid
	   * @see Persona.split_uid
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_UID, g_param_spec_string ("uid", "uid", "uid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The human-readable, service-specific universal ID used to represent the
	   * Persona.
	   *
	   * For example: `foo@@xmpp.example.org`.
	   *
	   * This should be used whenever the user needs to be presented with a
	   * familiar, service-specific ID. For instance, in a prompt for the user to
	   * select a specific IM contact within an {@link Individual} to begin a chat
	   * with.
	   *
	   * This is not guaranteed to be unique outside of the Persona's
	   * {@link PersonaStore}.
	   *
	   * @since 0.1.13
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_DISPLAY_ID, g_param_spec_string ("display-id", "display-id", "display-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The {@link PersonaStore} which contains this Persona.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE, g_param_spec_object ("store", "store", "store", FOLKS_TYPE_PERSONA_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The names of the properties of this Persona which are linkable.
	   *
	   * If a property name is in this list, and the Persona is from a
	   * {@link PersonaStore} whose trust level is {@link PersonaStoreTrust.FULL},
	   * the {@link IndividualAggregator} should be able to reliably use the value
	   * of the property from a given Persona instance to link the Persona with
	   * other Personas and form {@link Individual}s.
	   *
	   * Note that {@link Persona.uid} is always implicitly a member of this list,
	   * and doesn't need to be added explicitly.
	   *
	   * This list will have no effect if the Persona's {@link PersonaStore} trust
	   * level is not {@link PersonaStoreTrust.FULL}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_LINKABLE_PROPERTIES, g_param_spec_boxed ("linkable-properties", "linkable-properties", "linkable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void folks_persona_instance_init (FolksPersona * self) {
	self->priv = FOLKS_PERSONA_GET_PRIVATE (self);
}


static void folks_persona_finalize (GObject* obj) {
	FolksPersona * self;
	self = FOLKS_PERSONA (obj);
	_g_free0 (self->priv->_iid);
	_g_free0 (self->priv->_uid);
	_g_free0 (self->priv->_display_id);
	self->priv->_linkable_properties = (_vala_array_free (self->priv->_linkable_properties, self->priv->_linkable_properties_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (folks_persona_parent_class)->finalize (obj);
}


/**
 * Represents a "shard" of a person from a single source (a single
 * {@link Backend}), such as an XMPP contact from Telepathy or a vCard contact
 * from evolution-data-server. All the personas belonging to one physical person
 * are aggregated to form a single {@link Individual} representing that person.
 */
GType folks_persona_get_type (void) {
	static volatile gsize folks_persona_type_id__volatile = 0;
	if (g_once_init_enter (&folks_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPersona), 0, (GInstanceInitFunc) folks_persona_instance_init, NULL };
		GType folks_persona_type_id;
		folks_persona_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksPersona", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&folks_persona_type_id__volatile, folks_persona_type_id);
	}
	return folks_persona_type_id__volatile;
}


static void folks_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksPersona * self;
	int length;
	self = FOLKS_PERSONA (object);
	switch (property_id) {
		case FOLKS_PERSONA_IID:
		g_value_set_string (value, folks_persona_get_iid (self));
		break;
		case FOLKS_PERSONA_UID:
		g_value_set_string (value, folks_persona_get_uid (self));
		break;
		case FOLKS_PERSONA_DISPLAY_ID:
		g_value_set_string (value, folks_persona_get_display_id (self));
		break;
		case FOLKS_PERSONA_STORE:
		g_value_set_object (value, folks_persona_get_store (self));
		break;
		case FOLKS_PERSONA_LINKABLE_PROPERTIES:
		g_value_set_boxed (value, folks_persona_get_linkable_properties (self, &length));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void folks_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksPersona * self;
	gpointer boxed;
	self = FOLKS_PERSONA (object);
	switch (property_id) {
		case FOLKS_PERSONA_IID:
		folks_persona_set_iid (self, g_value_get_string (value));
		break;
		case FOLKS_PERSONA_UID:
		folks_persona_set_uid (self, g_value_get_string (value));
		break;
		case FOLKS_PERSONA_DISPLAY_ID:
		folks_persona_set_display_id (self, g_value_get_string (value));
		break;
		case FOLKS_PERSONA_STORE:
		folks_persona_set_store (self, g_value_get_object (value));
		break;
		case FOLKS_PERSONA_LINKABLE_PROPERTIES:
		boxed = g_value_get_boxed (value);
		folks_persona_set_linkable_properties (self, boxed, g_strv_length (boxed));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




