/* kf-backend.c generated by valac 0.11.5.3-fe751, the Vala compiler
 * generated from kf-backend.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define FOLKS_BACKENDS_KF_TYPE_BACKEND (folks_backends_kf_backend_get_type ())
#define FOLKS_BACKENDS_KF_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_KF_TYPE_BACKEND, FolksBackendsKfBackend))
#define FOLKS_BACKENDS_KF_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_KF_TYPE_BACKEND, FolksBackendsKfBackendClass))
#define FOLKS_BACKENDS_KF_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_KF_TYPE_BACKEND))
#define FOLKS_BACKENDS_KF_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_KF_TYPE_BACKEND))
#define FOLKS_BACKENDS_KF_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_KF_TYPE_BACKEND, FolksBackendsKfBackendClass))

typedef struct _FolksBackendsKfBackend FolksBackendsKfBackend;
typedef struct _FolksBackendsKfBackendClass FolksBackendsKfBackendClass;
typedef struct _FolksBackendsKfBackendPrivate FolksBackendsKfBackendPrivate;

#define FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE (folks_backends_kf_persona_store_get_type ())
#define FOLKS_BACKENDS_KF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStore))
#define FOLKS_BACKENDS_KF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStoreClass))
#define FOLKS_BACKENDS_KF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_KF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_KF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStoreClass))

typedef struct _FolksBackendsKfPersonaStore FolksBackendsKfPersonaStore;
typedef struct _FolksBackendsKfPersonaStoreClass FolksBackendsKfPersonaStoreClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FolksBackendsKfBackendPrepareData FolksBackendsKfBackendPrepareData;
typedef struct _FolksBackendsKfBackendUnprepareData FolksBackendsKfBackendUnprepareData;

struct _FolksBackendsKfBackend {
	FolksBackend parent_instance;
	FolksBackendsKfBackendPrivate * priv;
};

struct _FolksBackendsKfBackendClass {
	FolksBackendClass parent_class;
};

struct _FolksBackendsKfBackendPrivate {
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	GHashTable* _persona_stores;
};

struct _FolksBackendsKfBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfBackend* self;
	GFile* file;
	const gchar* _tmp0_;
	const gchar* path;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	FolksBackendsKfPersonaStore* _tmp12_;
	FolksBackendsKfPersonaStore* store;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	FolksBackendsKfPersonaStore* _tmp15_;
	GError * _inner_error_;
};

struct _FolksBackendsKfBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfBackend* self;
};


static gpointer folks_backends_kf_backend_parent_class = NULL;

GType folks_backends_kf_backend_get_type (void) G_GNUC_CONST;
GType folks_backends_kf_persona_store_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_KF_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_KF_TYPE_BACKEND, FolksBackendsKfBackendPrivate))
enum  {
	FOLKS_BACKENDS_KF_BACKEND_DUMMY_PROPERTY,
	FOLKS_BACKENDS_KF_BACKEND_IS_PREPARED,
	FOLKS_BACKENDS_KF_BACKEND_NAME,
	FOLKS_BACKENDS_KF_BACKEND_PERSONA_STORES
};
FolksBackendsKfBackend* folks_backends_kf_backend_new (void);
FolksBackendsKfBackend* folks_backends_kf_backend_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void folks_backends_kf_backend_real_prepare_data_free (gpointer _data);
static void folks_backends_kf_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_kf_backend_real_prepare_co (FolksBackendsKfBackendPrepareData* data);
FolksBackendsKfPersonaStore* folks_backends_kf_persona_store_new (GFile* key_file);
FolksBackendsKfPersonaStore* folks_backends_kf_persona_store_construct (GType object_type, GFile* key_file);
static void _folks_backends_kf_backend_store_removed_cb (FolksBackendsKfBackend* self, FolksPersonaStore* store);
static void __folks_backends_kf_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
static void folks_backends_kf_backend_real_unprepare_data_free (gpointer _data);
static void folks_backends_kf_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_kf_backend_real_unprepare_co (FolksBackendsKfBackendUnprepareData* data);
static void _lambda3_ (const gchar* k, FolksBackendsKfPersonaStore* v, FolksBackendsKfBackend* self);
static void __lambda3__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void folks_backends_kf_backend_finalize (GObject* obj);
static void _vala_folks_backends_kf_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


/**
   * {@inheritDoc}
   */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


FolksBackendsKfBackend* folks_backends_kf_backend_construct (GType object_type) {
	FolksBackendsKfBackend * self = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_;
	self = (FolksBackendsKfBackend*) folks_backend_construct (object_type);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	_tmp1_ = _tmp0_;
	_g_hash_table_unref0 (self->priv->_persona_stores);
	self->priv->_persona_stores = _tmp1_;
	return self;
}


FolksBackendsKfBackend* folks_backends_kf_backend_new (void) {
	return folks_backends_kf_backend_construct (FOLKS_BACKENDS_KF_TYPE_BACKEND);
}


static void folks_backends_kf_backend_real_prepare_data_free (gpointer _data) {
	FolksBackendsKfBackendPrepareData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendsKfBackendPrepareData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_backends_kf_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfBackend * self;
	FolksBackendsKfBackendPrepareData* _data_;
	self = (FolksBackendsKfBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsKfBackendPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_backend_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_backend_real_prepare_data_free);
	_data_->self = _g_object_ref0 (self);
	folks_backends_kf_backend_real_prepare_co (_data_);
}


static void folks_backends_kf_backend_real_prepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsKfBackendPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void __folks_backends_kf_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	_folks_backends_kf_backend_store_removed_cb (self, _sender);
}


static gboolean folks_backends_kf_backend_real_prepare_co (FolksBackendsKfBackendPrepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_static_rec_mutex_lock (&data->self->priv->__lock__is_prepared);
		if (!data->self->priv->_is_prepared) {
			data->_tmp0_ = NULL;
			data->_tmp0_ = g_getenv ("FOLKS_BACKEND_KEY_FILE_PATH");
			data->path = data->_tmp0_;
			if (data->path == NULL) {
				data->_tmp1_ = NULL;
				data->_tmp1_ = g_get_user_data_dir ();
				data->_tmp2_ = NULL;
				data->_tmp2_ = g_file_new_for_path (data->_tmp1_);
				data->_tmp3_ = data->_tmp2_;
				_g_object_unref0 (data->file);
				data->file = data->_tmp3_;
				data->_tmp4_ = NULL;
				data->_tmp4_ = g_file_get_child (data->file, "folks");
				data->_tmp5_ = data->_tmp4_;
				_g_object_unref0 (data->file);
				data->file = data->_tmp5_;
				data->_tmp6_ = NULL;
				data->_tmp6_ = g_file_get_child (data->file, "relationships.ini");
				data->_tmp7_ = data->_tmp6_;
				_g_object_unref0 (data->file);
				data->file = data->_tmp7_;
				data->_tmp8_ = NULL;
				data->_tmp8_ = g_file_get_path (data->file);
				data->_tmp9_ = data->_tmp8_;
				g_debug ("Using built-in key file '%s' (override with " "environment variable FOLKS_BACKEND_KEY_FILE_PATH)", data->_tmp9_);
				_g_free0 (data->_tmp9_);
			} else {
				data->_tmp10_ = NULL;
				data->_tmp10_ = g_file_new_for_path (data->path);
				data->_tmp11_ = data->_tmp10_;
				_g_object_unref0 (data->file);
				data->file = data->_tmp11_;
				g_debug ("Using environment variable " "FOLKS_BACKEND_KEY_FILE_PATH = '%s' to load the key " "file.", data->path);
			}
			data->_tmp12_ = NULL;
			data->_tmp12_ = folks_backends_kf_persona_store_new (data->file);
			data->store = data->_tmp12_;
			data->_tmp13_ = NULL;
			data->_tmp13_ = folks_persona_store_get_id ((FolksPersonaStore*) data->store);
			data->_tmp14_ = g_strdup (data->_tmp13_);
			data->_tmp15_ = _g_object_ref0 (data->store);
			g_hash_table_insert (data->self->priv->_persona_stores, data->_tmp14_, data->_tmp15_);
			g_signal_connect_object ((FolksPersonaStore*) data->store, "removed", (GCallback) __folks_backends_kf_backend_store_removed_cb_folks_persona_store_removed, data->self, 0);
			g_object_notify ((GObject*) data->self, "persona-stores");
			g_signal_emit_by_name ((FolksBackend*) data->self, "persona-store-added", (FolksPersonaStore*) data->store);
			data->self->priv->_is_prepared = TRUE;
			g_object_notify ((GObject*) data->self, "is-prepared");
			_g_object_unref0 (data->store);
			_g_object_unref0 (data->file);
		}
		__finally0:
		g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_backends_kf_backend_real_unprepare_data_free (gpointer _data) {
	FolksBackendsKfBackendUnprepareData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendsKfBackendUnprepareData, data);
}


static void folks_backends_kf_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfBackend * self;
	FolksBackendsKfBackendUnprepareData* _data_;
	self = (FolksBackendsKfBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsKfBackendUnprepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_backend_real_unprepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_backend_real_unprepare_data_free);
	_data_->self = _g_object_ref0 (self);
	folks_backends_kf_backend_real_unprepare_co (_data_);
}


static void folks_backends_kf_backend_real_unprepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsKfBackendUnprepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void _lambda3_ (const gchar* k, FolksBackendsKfPersonaStore* v, FolksBackendsKfBackend* self) {
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", (FolksPersonaStore*) FOLKS_BACKENDS_KF_PERSONA_STORE (v));
}


static void __lambda3__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda3_ (key, value, self);
}


static gboolean folks_backends_kf_backend_real_unprepare_co (FolksBackendsKfBackendUnprepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_hash_table_foreach (data->self->priv->_persona_stores, __lambda3__gh_func, data->self);
	g_hash_table_remove_all (data->self->priv->_persona_stores);
	g_object_notify ((GObject*) data->self, "persona-stores");
	data->self->priv->_is_prepared = FALSE;
	g_object_notify ((GObject*) data->self, "is-prepared");
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _folks_backends_kf_backend_store_removed_cb (FolksBackendsKfBackend* self, FolksPersonaStore* store) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", store);
	_tmp0_ = folks_persona_store_get_id (store);
	g_hash_table_remove (self->priv->_persona_stores, _tmp0_);
	g_object_notify ((GObject*) self, "persona-stores");
}


static gboolean folks_backends_kf_backend_real_get_is_prepared (FolksBackend* base) {
	gboolean result;
	FolksBackendsKfBackend* self;
	self = (FolksBackendsKfBackend*) base;
	result = self->priv->_is_prepared;
	return result;
}


static const gchar* folks_backends_kf_backend_real_get_name (FolksBackend* base) {
	const gchar* result;
	FolksBackendsKfBackend* self;
	self = (FolksBackendsKfBackend*) base;
	result = BACKEND_NAME;
	return result;
}


static GHashTable* folks_backends_kf_backend_real_get_persona_stores (FolksBackend* base) {
	GHashTable* result;
	FolksBackendsKfBackend* self;
	self = (FolksBackendsKfBackend*) base;
	result = self->priv->_persona_stores;
	return result;
}


static void folks_backends_kf_backend_class_init (FolksBackendsKfBackendClass * klass) {
	folks_backends_kf_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsKfBackendPrivate));
	FOLKS_BACKEND_CLASS (klass)->prepare = folks_backends_kf_backend_real_prepare;
	FOLKS_BACKEND_CLASS (klass)->prepare_finish = folks_backends_kf_backend_real_prepare_finish;
	FOLKS_BACKEND_CLASS (klass)->unprepare = folks_backends_kf_backend_real_unprepare;
	FOLKS_BACKEND_CLASS (klass)->unprepare_finish = folks_backends_kf_backend_real_unprepare_finish;
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = folks_backends_kf_backend_real_get_is_prepared;
	FOLKS_BACKEND_CLASS (klass)->get_name = folks_backends_kf_backend_real_get_name;
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = folks_backends_kf_backend_real_get_persona_stores;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_kf_backend_get_property;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_kf_backend_finalize;
	/**
	   * Whether this Backend has been prepared.
	   *
	   * See {@link Folks.Backend.is_prepared}.
	   *
	   * @since 0.3.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_BACKEND_IS_PREPARED, "is-prepared");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_BACKEND_NAME, "name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_BACKEND_PERSONA_STORES, "persona-stores");
}


static void folks_backends_kf_backend_instance_init (FolksBackendsKfBackend * self) {
	self->priv = FOLKS_BACKENDS_KF_BACKEND_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
}


static void folks_backends_kf_backend_finalize (GObject* obj) {
	FolksBackendsKfBackend * self;
	self = FOLKS_BACKENDS_KF_BACKEND (obj);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	_g_hash_table_unref0 (self->priv->_persona_stores);
	G_OBJECT_CLASS (folks_backends_kf_backend_parent_class)->finalize (obj);
}


/**
 * A backend which loads {@link Persona}s from a simple key file in
 * (XDG_DATA_HOME/folks/) and presents them through a single
 * {@link PersonaStore}.
 *
 * @since 0.1.13
 */
GType folks_backends_kf_backend_get_type (void) {
	static volatile gsize folks_backends_kf_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_kf_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsKfBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_kf_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsKfBackend), 0, (GInstanceInitFunc) folks_backends_kf_backend_instance_init, NULL };
		GType folks_backends_kf_backend_type_id;
		folks_backends_kf_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksBackendsKfBackend", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_kf_backend_type_id__volatile, folks_backends_kf_backend_type_id);
	}
	return folks_backends_kf_backend_type_id__volatile;
}


static void _vala_folks_backends_kf_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsKfBackend * self;
	self = FOLKS_BACKENDS_KF_BACKEND (object);
	switch (property_id) {
		case FOLKS_BACKENDS_KF_BACKEND_IS_PREPARED:
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_KF_BACKEND_NAME:
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_KF_BACKEND_PERSONA_STORES:
		g_value_set_boxed (value, folks_backend_get_persona_stores ((FolksBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



