/* individual-aggregator.c generated by valac 0.12.0, the Vala compiler
 * generated from individual-aggregator.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gconf/gconf-client.h>
#include <gconf/gconf.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define FOLKS_TYPE_INDIVIDUAL_AGGREGATOR (folks_individual_aggregator_get_type ())
#define FOLKS_INDIVIDUAL_AGGREGATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator))
#define FOLKS_INDIVIDUAL_AGGREGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorClass))
#define FOLKS_IS_INDIVIDUAL_AGGREGATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR))
#define FOLKS_IS_INDIVIDUAL_AGGREGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR))
#define FOLKS_INDIVIDUAL_AGGREGATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorClass))

typedef struct _FolksIndividualAggregator FolksIndividualAggregator;
typedef struct _FolksIndividualAggregatorClass FolksIndividualAggregatorClass;
typedef struct _FolksIndividualAggregatorPrivate FolksIndividualAggregatorPrivate;

#define FOLKS_TYPE_BACKEND_STORE (folks_backend_store_get_type ())
#define FOLKS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStore))
#define FOLKS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))
#define FOLKS_IS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_IS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_BACKEND_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))

typedef struct _FolksBackendStore FolksBackendStore;
typedef struct _FolksBackendStoreClass FolksBackendStoreClass;

#define FOLKS_TYPE_PERSONA_STORE (folks_persona_store_get_type ())
#define FOLKS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore))
#define FOLKS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))
#define FOLKS_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))

typedef struct _FolksPersonaStore FolksPersonaStore;
typedef struct _FolksPersonaStoreClass FolksPersonaStoreClass;

#define FOLKS_TYPE_BACKEND (folks_backend_get_type ())
#define FOLKS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND, FolksBackend))
#define FOLKS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND, FolksBackendClass))
#define FOLKS_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND))
#define FOLKS_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND))
#define FOLKS_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND, FolksBackendClass))

typedef struct _FolksBackend FolksBackend;
typedef struct _FolksBackendClass FolksBackendClass;

#define FOLKS_TYPE_INDIVIDUAL (folks_individual_get_type ())
#define FOLKS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividual))
#define FOLKS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))
#define FOLKS_IS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_IS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_INDIVIDUAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))

typedef struct _FolksIndividual FolksIndividual;
typedef struct _FolksIndividualClass FolksIndividualClass;

#define FOLKS_TYPE_DEBUG (folks_debug_get_type ())
#define FOLKS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_DEBUG, FolksDebug))
#define FOLKS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_DEBUG, FolksDebugClass))
#define FOLKS_IS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_DEBUG))
#define FOLKS_IS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_DEBUG))
#define FOLKS_DEBUG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_DEBUG, FolksDebugClass))

typedef struct _FolksDebug FolksDebug;
typedef struct _FolksDebugClass FolksDebugClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gconf_value_free0(var) ((var == NULL) ? NULL : (var = (gconf_value_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define FOLKS_TYPE_TRUST_LEVEL (folks_trust_level_get_type ())

#define FOLKS_TYPE_PERSONA (folks_persona_get_type ())
#define FOLKS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA, FolksPersona))
#define FOLKS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA, FolksPersonaClass))
#define FOLKS_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA))
#define FOLKS_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA))
#define FOLKS_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA, FolksPersonaClass))

typedef struct _FolksPersona FolksPersona;
typedef struct _FolksPersonaClass FolksPersonaClass;
typedef struct _FolksIndividualAggregatorPrepareData FolksIndividualAggregatorPrepareData;

#define FOLKS_TYPE_MATCH_RESULT (folks_match_result_get_type ())

#define FOLKS_TYPE_POTENTIAL_MATCH (folks_potential_match_get_type ())
#define FOLKS_POTENTIAL_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatch))
#define FOLKS_POTENTIAL_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatchClass))
#define FOLKS_IS_POTENTIAL_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_POTENTIAL_MATCH))
#define FOLKS_IS_POTENTIAL_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_POTENTIAL_MATCH))
#define FOLKS_POTENTIAL_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatchClass))

typedef struct _FolksPotentialMatch FolksPotentialMatch;
typedef struct _FolksPotentialMatchClass FolksPotentialMatchClass;
typedef struct _FolksIndividualAggregatorAddBackendData FolksIndividualAggregatorAddBackendData;
typedef struct _Block1Data Block1Data;

#define FOLKS_TYPE_PERSONA_STORE_TRUST (folks_persona_store_trust_get_type ())

#define FOLKS_GROUP_DETAILS_TYPE_CHANGE_REASON (folks_group_details_change_reason_get_type ())
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _FolksIndividualAggregatorAddPersonaFromDetailsData FolksIndividualAggregatorAddPersonaFromDetailsData;
typedef struct _Block4Data Block4Data;
typedef struct _FolksIndividualAggregatorRemoveIndividualData FolksIndividualAggregatorRemoveIndividualData;
typedef struct _FolksIndividualAggregatorRemovePersonaData FolksIndividualAggregatorRemovePersonaData;

#define FOLKS_TYPE_IM_DETAILS (folks_im_details_get_type ())
#define FOLKS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetails))
#define FOLKS_IS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IM_DETAILS))
#define FOLKS_IM_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetailsIface))

typedef struct _FolksImDetails FolksImDetails;
typedef struct _FolksImDetailsIface FolksImDetailsIface;

#define FOLKS_TYPE_WEB_SERVICE_DETAILS (folks_web_service_details_get_type ())
#define FOLKS_WEB_SERVICE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_WEB_SERVICE_DETAILS, FolksWebServiceDetails))
#define FOLKS_IS_WEB_SERVICE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_WEB_SERVICE_DETAILS))
#define FOLKS_WEB_SERVICE_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_WEB_SERVICE_DETAILS, FolksWebServiceDetailsIface))

typedef struct _FolksWebServiceDetails FolksWebServiceDetails;
typedef struct _FolksWebServiceDetailsIface FolksWebServiceDetailsIface;

#define FOLKS_TYPE_LOCAL_ID_DETAILS (folks_local_id_details_get_type ())
#define FOLKS_LOCAL_ID_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_LOCAL_ID_DETAILS, FolksLocalIdDetails))
#define FOLKS_IS_LOCAL_ID_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_LOCAL_ID_DETAILS))
#define FOLKS_LOCAL_ID_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_LOCAL_ID_DETAILS, FolksLocalIdDetailsIface))

typedef struct _FolksLocalIdDetails FolksLocalIdDetails;
typedef struct _FolksLocalIdDetailsIface FolksLocalIdDetailsIface;

#define FOLKS_TYPE_PERSONA_DETAIL (folks_persona_detail_get_type ())
typedef struct _FolksIndividualAggregatorLinkPersonasData FolksIndividualAggregatorLinkPersonasData;
typedef struct _FolksIndividualAggregatorUnlinkIndividualData FolksIndividualAggregatorUnlinkIndividualData;

/**
 * Errors from {@link IndividualAggregator}s.
 */
typedef enum  {
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED,
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_WRITEABLE_STORE,
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE
} FolksIndividualAggregatorError;
#define FOLKS_INDIVIDUAL_AGGREGATOR_ERROR folks_individual_aggregator_error_quark ()
struct _FolksIndividualAggregator {
	GObject parent_instance;
	FolksIndividualAggregatorPrivate * priv;
};

struct _FolksIndividualAggregatorClass {
	GObjectClass parent_class;
};

struct _FolksIndividualAggregatorPrivate {
	FolksBackendStore* _backend_store;
	GeeHashMap* _stores;
	FolksPersonaStore* _writeable_store;
	GeeHashSet* _backends;
	GHashTable* _link_map;
	gboolean _linking_enabled;
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	FolksDebug* _debug;
	gchar* _configured_writeable_store_type_id;
	GeeMap* _individuals;
	GeeMap* _individuals_ro;
	FolksIndividual* _user;
};

typedef enum  {
	FOLKS_TRUST_LEVEL_NONE,
	FOLKS_TRUST_LEVEL_PERSONAS
} FolksTrustLevel;

struct _FolksIndividualAggregatorPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	GError * _inner_error_;
};

typedef enum  {
	FOLKS_MATCH_RESULT_VERY_LOW,
	FOLKS_MATCH_RESULT_LOW,
	FOLKS_MATCH_RESULT_MEDIUM,
	FOLKS_MATCH_RESULT_HIGH,
	FOLKS_MATCH_RESULT_VERY_HIGH,
	FOLKS_MATCH_RESULT_MIN = FOLKS_MATCH_RESULT_VERY_LOW,
	FOLKS_MATCH_RESULT_MAX = FOLKS_MATCH_RESULT_VERY_HIGH
} FolksMatchResult;

struct _FolksIndividualAggregatorAddBackendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksBackend* backend;
	gboolean _tmp0_;
	GeeMap* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _persona_store_it;
	gboolean _tmp6_;
	gpointer _tmp7_;
	FolksPersonaStore* persona_store;
};

struct _Block1Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	gchar* store_id;
	FolksPersonaStore* store;
};

typedef enum  {
	FOLKS_PERSONA_STORE_TRUST_NONE,
	FOLKS_PERSONA_STORE_TRUST_PARTIAL,
	FOLKS_PERSONA_STORE_TRUST_FULL
} FolksPersonaStoreTrust;

typedef enum  {
	FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE = 0,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_OFFLINE = 1,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_KICKED = 2,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_BUSY = 3,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_INVITED = 4,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_BANNED = 5,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_ERROR = 6,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_INVALID_MEMBER = 7,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_NO_ANSWER = 8,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_RENAMED = 9,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_PERMISSION_DENIED = 10,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_SEPARATED = 11
} FolksGroupDetailsChangeReason;

struct _Block2Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	GeeHashSet* candidate_inds;
	FolksIndividual* final_individual;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	const gchar* prop_name;
};

typedef void (*FolksPersonaLinkablePropertyCallback) (const gchar* link, void* user_data);
typedef enum  {
	FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT,
	FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED,
	FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_USER,
	FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE,
	FOLKS_PERSONA_STORE_ERROR_READ_ONLY
} FolksPersonaStoreError;
#define FOLKS_PERSONA_STORE_ERROR folks_persona_store_error_quark ()
struct _FolksIndividualAggregatorAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* parent;
	FolksPersonaStore* persona_store;
	GHashTable* details;
	FolksPersona* result;
	FolksPersona* persona;
	GHashTable* _tmp0_;
	GHashTable* details_copy;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	GError * e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* full_id;
	const gchar* _tmp7_;
	GError* _tmp8_;
	gboolean _tmp9_;
	GeeSet* _tmp10_;
	GError * _inner_error_;
};

struct _Block4Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	GHashTable* retval;
};

struct _FolksIndividualAggregatorRemoveIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
	GeeHashSet* _tmp0_;
	GeeHashSet* personas;
	GeeSet* _tmp1_;
	GeeIterator* _tmp2_;
	GeeIterator* _p_it;
	gboolean _tmp3_;
	gpointer _tmp4_;
	FolksPersona* p;
	GeeIterator* _tmp5_;
	GeeIterator* _persona_it;
	gboolean _tmp6_;
	gpointer _tmp7_;
	FolksPersona* persona;
	FolksPersonaStore* _tmp8_;
	GError * _inner_error_;
};

struct _FolksIndividualAggregatorRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksPersona* persona;
	FolksPersonaStore* _tmp0_;
	GError * _inner_error_;
};

struct _FolksImDetailsIface {
	GTypeInterface parent_iface;
	GeeMultiMap* (*get_im_addresses) (FolksImDetails* self);
	void (*set_im_addresses) (FolksImDetails* self, GeeMultiMap* value);
};

struct _FolksWebServiceDetailsIface {
	GTypeInterface parent_iface;
	GeeMultiMap* (*get_web_service_addresses) (FolksWebServiceDetails* self);
	void (*set_web_service_addresses) (FolksWebServiceDetails* self, GeeMultiMap* value);
};

struct _FolksLocalIdDetailsIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_local_ids) (FolksLocalIdDetails* self);
	void (*set_local_ids) (FolksLocalIdDetails* self, GeeSet* value);
};

typedef enum  {
	FOLKS_PERSONA_DETAIL_ALIAS,
	FOLKS_PERSONA_DETAIL_AVATAR,
	FOLKS_PERSONA_DETAIL_BIRTHDAY,
	FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES,
	FOLKS_PERSONA_DETAIL_FULL_NAME,
	FOLKS_PERSONA_DETAIL_GENDER,
	FOLKS_PERSONA_DETAIL_IM_ADDRESSES,
	FOLKS_PERSONA_DETAIL_IS_FAVOURITE,
	FOLKS_PERSONA_DETAIL_LOCAL_IDS,
	FOLKS_PERSONA_DETAIL_NOTES,
	FOLKS_PERSONA_DETAIL_PHONE_NUMBERS,
	FOLKS_PERSONA_DETAIL_POSTAL_ADDRESSES,
	FOLKS_PERSONA_DETAIL_ROLES,
	FOLKS_PERSONA_DETAIL_STRUCTURED_NAME,
	FOLKS_PERSONA_DETAIL_URLS,
	FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES
} FolksPersonaDetail;

struct _FolksIndividualAggregatorLinkPersonasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	GeeSet* personas;
	const gchar* _tmp0_;
	GError* _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	GeeHashMultiMap* _tmp4_;
	GeeHashMultiMap* protocols_addrs_set;
	GeeHashMultiMap* _tmp5_;
	GeeHashMultiMap* web_service_addrs_set;
	GeeHashSet* _tmp6_;
	GeeHashSet* local_ids;
	GeeIterator* _tmp7_;
	GeeIterator* _persona_it;
	gboolean _tmp8_;
	gpointer _tmp9_;
	FolksPersona* persona;
	FolksImDetails* _tmp10_;
	FolksImDetails* im_details;
	GeeMultiMap* _tmp11_;
	GeeSet* _tmp12_;
	GeeSet* _tmp13_;
	GeeIterator* _tmp14_;
	GeeIterator* _tmp15_;
	GeeIterator* _protocol_it;
	gboolean _tmp16_;
	gpointer _tmp17_;
	gchar* protocol;
	GeeMultiMap* _tmp18_;
	GeeCollection* _tmp19_;
	GeeCollection* im_addresses;
	GeeIterator* _tmp20_;
	GeeIterator* _im_address_it;
	gboolean _tmp21_;
	gpointer _tmp22_;
	gchar* im_address;
	FolksWebServiceDetails* _tmp23_;
	FolksWebServiceDetails* ws_details;
	GeeMultiMap* _tmp24_;
	GeeSet* _tmp25_;
	GeeSet* _tmp26_;
	GeeIterator* _tmp27_;
	GeeIterator* _tmp28_;
	GeeIterator* _web_service_it;
	gboolean _tmp29_;
	gpointer _tmp30_;
	gchar* web_service;
	GeeMultiMap* _tmp31_;
	GeeCollection* _tmp32_;
	GeeCollection* ws_addresses;
	GeeIterator* _tmp33_;
	GeeIterator* _ws_address_it;
	gboolean _tmp34_;
	gpointer _tmp35_;
	gchar* ws_address;
	GeeSet* _tmp36_;
	GeeIterator* _tmp37_;
	GeeIterator* _id_it;
	gboolean _tmp38_;
	gpointer _tmp39_;
	gchar* id;
	GHashTable* _tmp40_;
	GHashTable* details;
	gint _tmp41_;
	GValue im_addresses_value;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	GValue* _tmp44_;
	gint _tmp45_;
	GValue web_service_addresses_value;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	GValue* _tmp48_;
	gint _tmp49_;
	GValue local_ids_value;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	GValue* _tmp52_;
	FolksPersona* _tmp53_;
	FolksPersona* _tmp54_;
	GError * _inner_error_;
};

struct _FolksIndividualAggregatorUnlinkIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeHashSet* _tmp2_;
	GeeHashSet* personas;
	GeeSet* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _p_it;
	gboolean _tmp5_;
	gpointer _tmp6_;
	FolksPersona* p;
	GeeIterator* _tmp7_;
	GeeIterator* _persona_it;
	gboolean _tmp8_;
	gpointer _tmp9_;
	FolksPersona* persona;
	FolksPersonaStore* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GError * _inner_error_;
};


static gpointer folks_individual_aggregator_parent_class = NULL;

GQuark folks_individual_aggregator_error_quark (void);
GType folks_individual_aggregator_get_type (void) G_GNUC_CONST;
GType folks_backend_store_get_type (void) G_GNUC_CONST;
GType folks_persona_store_get_type (void) G_GNUC_CONST;
GType folks_backend_get_type (void) G_GNUC_CONST;
GType folks_individual_get_type (void) G_GNUC_CONST;
GType folks_debug_get_type (void) G_GNUC_CONST;
#define FOLKS_INDIVIDUAL_AGGREGATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorPrivate))
enum  {
	FOLKS_INDIVIDUAL_AGGREGATOR_DUMMY_PROPERTY,
	FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED,
	FOLKS_INDIVIDUAL_AGGREGATOR_PRIMARY_STORE,
	FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS,
	FOLKS_INDIVIDUAL_AGGREGATOR_USER
};
static void _folks_individual_aggregator_backend_available_cb (FolksIndividualAggregator* self, FolksBackendStore* backend_store, FolksBackend* backend);
static void __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self);
static void _folks_individual_aggregator_debug_print_status (FolksIndividualAggregator* self, FolksDebug* debug);
static void __folks_individual_aggregator_debug_print_status_folks_debug_print_status (FolksDebug* _sender, gpointer self);
#define FOLKS_INDIVIDUAL_AGGREGATOR__FOLKS_CONFIG_KEY "/system/folks/backends/primary_store"
FolksIndividualAggregator* folks_individual_aggregator_new (void);
FolksIndividualAggregator* folks_individual_aggregator_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
FolksDebug* folks_debug_dup (void);
FolksBackendStore* folks_backend_store_dup (void);
#define FOLKS_DEBUG_STATUS_LOG_DOMAIN "folks-status"
void folks_debug_print_heading (FolksDebug* self, const gchar* domain, GLogLevelFlags level, const gchar* format, ...);
void folks_debug_print_key_value_pairs (FolksDebug* self, const gchar* domain, GLogLevelFlags level, ...);
void folks_debug_print_line (FolksDebug* self, const gchar* domain, GLogLevelFlags level, const gchar* format, ...);
GeeMap* folks_individual_aggregator_get_individuals (FolksIndividualAggregator* self);
void folks_debug_indent (FolksDebug* self);
GType folks_trust_level_get_type (void) G_GNUC_CONST;
FolksTrustLevel folks_individual_get_trust_level (FolksIndividual* self);
gboolean folks_individual_get_is_user (FolksIndividual* self);
const gchar* folks_individual_get_id (FolksIndividual* self);
GType folks_persona_get_type (void) G_GNUC_CONST;
GeeSet* folks_individual_get_personas (FolksIndividual* self);
gboolean folks_persona_get_is_user (FolksPersona* self);
const gchar* folks_persona_get_uid (FolksPersona* self);
const gchar* folks_persona_get_iid (FolksPersona* self);
const gchar* folks_persona_get_display_id (FolksPersona* self);
void folks_debug_unindent (FolksDebug* self);
static void folks_individual_aggregator_prepare_data_free (gpointer _data);
void folks_individual_aggregator_prepare (FolksIndividualAggregator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_prepare_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_prepare_co (FolksIndividualAggregatorPrepareData* data);
void folks_backend_store_load_backends (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_store_load_backends_finish (FolksBackendStore* self, GAsyncResult* _res_, GError** error);
static void folks_individual_aggregator_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType folks_match_result_get_type (void) G_GNUC_CONST;
GeeMap* folks_individual_aggregator_get_potential_matches (FolksIndividualAggregator* self, FolksIndividual* matchee, FolksMatchResult min_threshold);
FolksPotentialMatch* folks_potential_match_new (void);
FolksPotentialMatch* folks_potential_match_construct (GType object_type);
GType folks_potential_match_get_type (void) G_GNUC_CONST;
FolksMatchResult folks_potential_match_potential_match (FolksPotentialMatch* self, FolksIndividual* a, FolksIndividual* b);
GeeMap* folks_individual_aggregator_get_all_potential_matches (FolksIndividualAggregator* self, FolksMatchResult min_threshold);
static void _folks_individual_aggregator_add_backend_data_free (gpointer _data);
static void _folks_individual_aggregator_add_backend (FolksIndividualAggregator* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_individual_aggregator_add_backend_finish (FolksIndividualAggregator* self, GAsyncResult* _res_);
static gboolean _folks_individual_aggregator_add_backend_co (FolksIndividualAggregatorAddBackendData* data);
static void _folks_individual_aggregator_backend_persona_store_added_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store);
static void __folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
static void _folks_individual_aggregator_backend_persona_store_removed_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store);
static void __folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
GeeMap* folks_backend_get_persona_stores (FolksBackend* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gchar* _folks_individual_aggregator_get_store_full_id (FolksIndividualAggregator* self, const gchar* type_id, const gchar* id);
const gchar* folks_persona_store_get_type_id (FolksPersonaStore* self);
const gchar* folks_persona_store_get_id (FolksPersonaStore* self);
void folks_persona_store_set_is_writeable (FolksPersonaStore* self, gboolean value);
GType folks_persona_store_trust_get_type (void) G_GNUC_CONST;
void folks_persona_store_set_trust_level (FolksPersonaStore* self, FolksPersonaStoreTrust value);
GType folks_group_details_change_reason_get_type (void) G_GNUC_CONST;
static void _folks_individual_aggregator_personas_changed_cb (FolksIndividualAggregator* self, FolksPersonaStore* store, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _folks_individual_aggregator_is_writeable_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec);
static void __folks_individual_aggregator_is_writeable_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_aggregator_trust_level_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec);
static void __folks_individual_aggregator_trust_level_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void folks_persona_store_prepare (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_prepare_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static void _lambda5_ (GObject* obj, GAsyncResult* _result_, Block1Data* _data1_);
static void __lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _folks_individual_aggregator_emit_individuals_changed (FolksIndividualAggregator* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void _folks_individual_aggregator_connect_to_individual (FolksIndividualAggregator* self, FolksIndividual* individual);
static void _folks_individual_aggregator_individual_removed_cb (FolksIndividualAggregator* self, FolksIndividual* i, FolksIndividual* replacement);
static void __folks_individual_aggregator_individual_removed_cb_folks_individual_removed (FolksIndividual* _sender, FolksIndividual* replacement_individual, gpointer self);
static void _folks_individual_aggregator_disconnect_from_individual (FolksIndividualAggregator* self, FolksIndividual* individual);
static void _folks_individual_aggregator_add_personas (FolksIndividualAggregator* self, GeeSet* added, GeeHashSet** added_individuals, GeeHashMap** replaced_individuals, FolksIndividual** user);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
FolksPersonaStore* folks_persona_get_store (FolksPersona* self);
FolksPersonaStoreTrust folks_persona_store_get_trust_level (FolksPersonaStore* self);
gchar** folks_persona_get_linkable_properties (FolksPersona* self, int* result_length1);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
void folks_persona_linkable_property_to_links (FolksPersona* self, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
static void _lambda2_ (const gchar* l, Block3Data* _data3_);
static void __lambda2__folks_persona_linkable_property_callback (const gchar* link, gpointer self);
FolksIndividual* folks_individual_new (GeeSet* personas);
FolksIndividual* folks_individual_construct (GType object_type, GeeSet* personas);
static void _lambda3_ (const gchar* l, Block2Data* _data2_);
static void __lambda3__folks_persona_linkable_property_callback (const gchar* link, gpointer self);
static void _folks_individual_aggregator_remove_persona_from_link_map (FolksIndividualAggregator* self, FolksPersona* persona);
static void _lambda4_ (const gchar* linking_value, FolksIndividualAggregator* self);
static void __lambda4__folks_persona_linkable_property_callback (const gchar* link, gpointer self);
FolksIndividual* folks_individual_aggregator_get_user (FolksIndividualAggregator* self);
void folks_individual_set_personas (FolksIndividual* self, GeeSet* value);
static void folks_individual_aggregator_set_user (FolksIndividualAggregator* self, FolksIndividual* value);
void folks_individual_replace (FolksIndividual* self, FolksIndividual* replacement_individual);
gboolean folks_persona_store_get_is_writeable (FolksPersonaStore* self);
static void folks_individual_aggregator_add_persona_from_details_data_free (gpointer _data);
void folks_individual_aggregator_add_persona_from_details (FolksIndividualAggregator* self, FolksIndividual* parent, FolksPersonaStore* persona_store, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* folks_individual_aggregator_add_persona_from_details_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_add_persona_from_details_co (FolksIndividualAggregatorAddPersonaFromDetailsData* data);
static GHashTable* _folks_individual_aggregator_asv_copy (FolksIndividualAggregator* self, GHashTable* asv);
void folks_persona_store_add_persona_from_details (FolksPersonaStore* self, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
GQuark folks_persona_store_error_quark (void);
FolksPersona* folks_persona_store_add_persona_from_details_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static void folks_individual_aggregator_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static void _lambda6_ (const gchar* k, GValue* v, Block4Data* _data4_);
static GValue* _g_value_dup (GValue* self);
static void __lambda6__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void folks_individual_aggregator_remove_individual_data_free (gpointer _data);
void folks_individual_aggregator_remove_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_remove_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_remove_individual_co (FolksIndividualAggregatorRemoveIndividualData* data);
void folks_persona_store_remove_persona (FolksPersonaStore* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_remove_persona_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static void folks_individual_aggregator_remove_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_individual_aggregator_remove_persona_data_free (gpointer _data);
void folks_individual_aggregator_remove_persona (FolksIndividualAggregator* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_remove_persona_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_remove_persona_co (FolksIndividualAggregatorRemovePersonaData* data);
static void folks_individual_aggregator_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_individual_aggregator_link_personas_data_free (gpointer _data);
void folks_individual_aggregator_link_personas (FolksIndividualAggregator* self, GeeSet* personas, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_link_personas_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_link_personas_co (FolksIndividualAggregatorLinkPersonasData* data);
GType folks_im_details_get_type (void) G_GNUC_CONST;
GeeMultiMap* folks_im_details_get_im_addresses (FolksImDetails* self);
GType folks_web_service_details_get_type (void) G_GNUC_CONST;
GeeMultiMap* folks_web_service_details_get_web_service_addresses (FolksWebServiceDetails* self);
GType folks_local_id_details_get_type (void) G_GNUC_CONST;
GeeSet* folks_local_id_details_get_local_ids (FolksLocalIdDetails* self);
GType folks_persona_detail_get_type (void) G_GNUC_CONST;
const gchar* folks_persona_store_detail_key (FolksPersonaDetail detail);
static void folks_individual_aggregator_link_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_individual_aggregator_unlink_individual_data_free (gpointer _data);
void folks_individual_aggregator_unlink_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_unlink_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_unlink_individual_co (FolksIndividualAggregatorUnlinkIndividualData* data);
static void folks_individual_aggregator_unlink_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean folks_individual_aggregator_get_is_prepared (FolksIndividualAggregator* self);
FolksPersonaStore* folks_individual_aggregator_get_primary_store (FolksIndividualAggregator* self);
static void folks_individual_aggregator_set_individuals (FolksIndividualAggregator* self, GeeMap* value);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void folks_individual_aggregator_finalize (GObject* obj);
static void _vala_folks_individual_aggregator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_individual_aggregator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark folks_individual_aggregator_error_quark (void) {
	return g_quark_from_static_string ("folks_individual_aggregator_error-quark");
}


static void __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self) {
	_folks_individual_aggregator_backend_available_cb (self, _sender, backend);
}


static void __folks_individual_aggregator_debug_print_status_folks_debug_print_status (FolksDebug* _sender, gpointer self) {
	_folks_individual_aggregator_debug_print_status (self, _sender);
}


/**
   * Create a new IndividualAggregator.
   *
   * Clients should connect to the
   * {@link IndividualAggregator.individuals_changed} signal, then call
   * {@link IndividualAggregator.prepare} to load the backends and start
   * aggregating individuals.
   *
   * An example of how to set up an IndividualAggregator:
   * {{{
   *   IndividualAggregator agg = new IndividualAggregator ();
   *   agg.individuals_changed.connect (individuals_changed_cb);
   *   agg.prepare ();
   * }}}
   */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


FolksIndividualAggregator* folks_individual_aggregator_construct (GType object_type) {
	FolksIndividualAggregator * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeMap* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	GeeHashSet* _tmp4_ = NULL;
	FolksDebug* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* store_type_id;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* disable_linking;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	FolksBackendStore* _tmp21_ = NULL;
	GError * _inner_error_ = NULL;
	self = (FolksIndividualAggregator*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_stores);
	self->priv->_stores = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_individuals);
	self->priv->_individuals = (GeeMap*) _tmp1_;
	_tmp2_ = gee_map_get_read_only_view (self->priv->_individuals);
	_g_object_unref0 (self->priv->_individuals_ro);
	self->priv->_individuals_ro = _tmp2_;
	_tmp3_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->_link_map);
	self->priv->_link_map = _tmp3_;
	_tmp4_ = gee_hash_set_new (FOLKS_TYPE_BACKEND, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (self->priv->_backends);
	self->priv->_backends = _tmp4_;
	_tmp5_ = folks_debug_dup ();
	_g_object_unref0 (self->priv->_debug);
	self->priv->_debug = _tmp5_;
	g_signal_connect_object (self->priv->_debug, "print-status", (GCallback) __folks_individual_aggregator_debug_print_status_folks_debug_print_status, self, 0);
	_tmp6_ = g_getenv ("FOLKS_WRITEABLE_STORE");
	_tmp7_ = g_strdup (_tmp6_);
	store_type_id = _tmp7_;
	if (store_type_id != NULL) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup (store_type_id);
		_g_free0 (self->priv->_configured_writeable_store_type_id);
		self->priv->_configured_writeable_store_type_id = _tmp8_;
	} else {
		gchar* _tmp9_;
		GConfClient* _tmp10_ = NULL;
		GConfClient* client;
		GConfValue* _tmp11_ = NULL;
		GConfValue* val;
		_tmp9_ = g_strdup ("key-file");
		_g_free0 (self->priv->_configured_writeable_store_type_id);
		self->priv->_configured_writeable_store_type_id = _tmp9_;
		_tmp10_ = gconf_client_get_default ();
		client = _tmp10_;
		_tmp11_ = gconf_client_get (client, FOLKS_INDIVIDUAL_AGGREGATOR__FOLKS_CONFIG_KEY, &_inner_error_);
		val = _tmp11_;
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		if (val != NULL) {
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			_tmp12_ = gconf_value_get_string (val);
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (self->priv->_configured_writeable_store_type_id);
			self->priv->_configured_writeable_store_type_id = _tmp13_;
		}
		_gconf_value_free0 (val);
		goto __finally9;
		__catch9_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally9:
		if (_inner_error_ != NULL) {
			_g_free0 (store_type_id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = g_getenv ("FOLKS_DISABLE_LINKING");
	_tmp15_ = g_strdup (_tmp14_);
	disable_linking = _tmp15_;
	if (disable_linking != NULL) {
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		_tmp16_ = string_strip (disable_linking);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_utf8_strdown (_tmp17_, (gssize) (-1));
		_g_free0 (disable_linking);
		disable_linking = _tmp18_;
		_g_free0 (_tmp17_);
	}
	if (disable_linking == NULL) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = g_strcmp0 (disable_linking, "no") == 0;
	}
	if (_tmp20_) {
		_tmp19_ = TRUE;
	} else {
		_tmp19_ = g_strcmp0 (disable_linking, "0") == 0;
	}
	self->priv->_linking_enabled = _tmp19_;
	_tmp21_ = folks_backend_store_dup ();
	_g_object_unref0 (self->priv->_backend_store);
	self->priv->_backend_store = _tmp21_;
	g_signal_connect_object (self->priv->_backend_store, "backend-available", (GCallback) __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available, self, 0);
	_g_free0 (disable_linking);
	_g_free0 (store_type_id);
	return self;
}


FolksIndividualAggregator* folks_individual_aggregator_new (void) {
	return folks_individual_aggregator_construct (FOLKS_TYPE_INDIVIDUAL_AGGREGATOR);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _folks_individual_aggregator_debug_print_status (FolksIndividualAggregator* self, FolksDebug* debug) {
	static const char domain[] = FOLKS_DEBUG_STATUS_LOG_DOMAIN;
	static const GLogLevelFlags level = G_LOG_LEVEL_INFO;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GeeMap* _tmp6_ = NULL;
	gint _tmp7_;
	guint _tmp36_;
	GHashTableIter iter = {0};
	gchar* link_key = NULL;
	FolksIndividual* individual = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (debug != NULL);
	folks_debug_print_heading (debug, domain, level, "IndividualAggregator (%p)", self);
	if (self->priv->_linking_enabled) {
		_tmp0_ = "yes";
	} else {
		_tmp0_ = "no";
	}
	if (self->priv->_is_prepared) {
		_tmp1_ = "yes";
	} else {
		_tmp1_ = "no";
	}
	_tmp2_ = g_strdup_printf ("%u", ((GObject*) self)->ref_count);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%p", self->priv->_writeable_store);
	_tmp5_ = _tmp4_;
	folks_debug_print_key_value_pairs (debug, domain, level, "Ref. count", _tmp3_, "Writeable store", _tmp5_, "Linking enabled?", _tmp0_, "Prepared?", _tmp1_, NULL);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp6_ = folks_individual_aggregator_get_individuals (self);
	_tmp7_ = gee_map_get_size (_tmp6_);
	folks_debug_print_line (debug, domain, level, "%u Individuals:", (guint) _tmp7_);
	folks_debug_indent (debug);
	{
		GeeMap* _tmp8_ = NULL;
		GeeCollection* _tmp9_ = NULL;
		GeeCollection* _tmp10_;
		GeeIterator* _tmp11_ = NULL;
		GeeIterator* _tmp12_;
		GeeIterator* _individual_it;
		_tmp8_ = folks_individual_aggregator_get_individuals (self);
		_tmp9_ = gee_map_get_values (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_individual_it = _tmp12_;
		while (TRUE) {
			gboolean _tmp13_;
			gpointer _tmp14_ = NULL;
			FolksIndividual* individual;
			gchar* trust_level;
			FolksTrustLevel _tmp15_;
			const gchar* _tmp18_ = NULL;
			gboolean _tmp19_;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			const gchar* _tmp22_ = NULL;
			GeeSet* _tmp23_ = NULL;
			gint _tmp24_;
			_tmp13_ = gee_iterator_next (_individual_it);
			if (!_tmp13_) {
				break;
			}
			_tmp14_ = gee_iterator_get (_individual_it);
			individual = (FolksIndividual*) _tmp14_;
			trust_level = NULL;
			_tmp15_ = folks_individual_get_trust_level (individual);
			switch (_tmp15_) {
				case FOLKS_TRUST_LEVEL_NONE:
				{
					gchar* _tmp16_;
					_tmp16_ = g_strdup ("none");
					_g_free0 (trust_level);
					trust_level = _tmp16_;
					break;
				}
				case FOLKS_TRUST_LEVEL_PERSONAS:
				{
					gchar* _tmp17_;
					_tmp17_ = g_strdup ("personas");
					_g_free0 (trust_level);
					trust_level = _tmp17_;
					break;
				}
				default:
				{
					g_assert_not_reached ();
				}
			}
			folks_debug_print_heading (debug, domain, level, "Individual (%p)", individual);
			_tmp19_ = folks_individual_get_is_user (individual);
			if (_tmp19_) {
				_tmp18_ = "yes";
			} else {
				_tmp18_ = "no";
			}
			_tmp20_ = g_strdup_printf ("%u", ((GObject*) individual)->ref_count);
			_tmp21_ = _tmp20_;
			_tmp22_ = folks_individual_get_id (individual);
			folks_debug_print_key_value_pairs (debug, domain, level, "Ref. count", _tmp21_, "ID", _tmp22_, "User?", _tmp18_, "Trust level", trust_level, NULL);
			_g_free0 (_tmp21_);
			_tmp23_ = folks_individual_get_personas (individual);
			_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
			folks_debug_print_line (debug, domain, level, "%u Personas:", (guint) _tmp24_);
			folks_debug_indent (debug);
			{
				GeeSet* _tmp25_ = NULL;
				GeeIterator* _tmp26_ = NULL;
				GeeIterator* _persona_it;
				_tmp25_ = folks_individual_get_personas (individual);
				_tmp26_ = gee_iterable_iterator ((GeeIterable*) _tmp25_);
				_persona_it = _tmp26_;
				while (TRUE) {
					gboolean _tmp27_;
					gpointer _tmp28_ = NULL;
					FolksPersona* persona;
					const gchar* _tmp29_ = NULL;
					gboolean _tmp30_;
					gchar* _tmp31_ = NULL;
					gchar* _tmp32_;
					const gchar* _tmp33_ = NULL;
					const gchar* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					_tmp27_ = gee_iterator_next (_persona_it);
					if (!_tmp27_) {
						break;
					}
					_tmp28_ = gee_iterator_get (_persona_it);
					persona = (FolksPersona*) _tmp28_;
					folks_debug_print_heading (debug, domain, level, "Persona (%p)", persona);
					_tmp30_ = folks_persona_get_is_user (persona);
					if (_tmp30_) {
						_tmp29_ = "yes";
					} else {
						_tmp29_ = "no";
					}
					_tmp31_ = g_strdup_printf ("%u", ((GObject*) persona)->ref_count);
					_tmp32_ = _tmp31_;
					_tmp33_ = folks_persona_get_uid (persona);
					_tmp34_ = folks_persona_get_iid (persona);
					_tmp35_ = folks_persona_get_display_id (persona);
					folks_debug_print_key_value_pairs (debug, domain, level, "Ref. count", _tmp32_, "UID", _tmp33_, "IID", _tmp34_, "Display ID", _tmp35_, "User?", _tmp29_, NULL);
					_g_free0 (_tmp32_);
					_g_object_unref0 (persona);
				}
				_g_object_unref0 (_persona_it);
			}
			folks_debug_unindent (debug);
			_g_free0 (trust_level);
			_g_object_unref0 (individual);
		}
		_g_object_unref0 (_individual_it);
	}
	folks_debug_unindent (debug);
	_tmp36_ = g_hash_table_size (self->priv->_link_map);
	folks_debug_print_line (debug, domain, level, "%u entries in the link map:", _tmp36_);
	folks_debug_indent (debug);
	g_hash_table_iter_init (&iter, self->priv->_link_map);
	while (TRUE) {
		gconstpointer _tmp37_ = NULL;
		gconstpointer _tmp38_ = NULL;
		gboolean _tmp39_;
		gchar* _tmp40_;
		FolksIndividual* _tmp41_;
		_tmp39_ = g_hash_table_iter_next (&iter, &_tmp37_, &_tmp38_);
		_g_free0 (link_key);
		_tmp40_ = g_strdup (_tmp37_);
		link_key = _tmp40_;
		_g_object_unref0 (individual);
		_tmp41_ = _g_object_ref0 (_tmp38_);
		individual = _tmp41_;
		if (!(_tmp39_ == TRUE)) {
			break;
		}
		folks_debug_print_line (debug, domain, level, "%s → %p", link_key, individual);
	}
	folks_debug_unindent (debug);
	folks_debug_print_line (debug, domain, level, "");
	_g_object_unref0 (individual);
	_g_free0 (link_key);
}


static void folks_individual_aggregator_prepare_data_free (gpointer _data) {
	FolksIndividualAggregatorPrepareData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorPrepareData, data);
}


void folks_individual_aggregator_prepare (FolksIndividualAggregator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorPrepareData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_prepare_data_free);
	_data_->self = _g_object_ref0 (self);
	folks_individual_aggregator_prepare_co (_data_);
}


void folks_individual_aggregator_prepare_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Prepare the IndividualAggregator for use.
   *
   * This loads all the available backends and prepares them for use by the
   * IndividualAggregator. This should be called //after// connecting to the
   * {@link IndividualAggregator.individuals_changed} signal, or a race
   * condition could occur, with the signal being emitted before your code has
   * connected to them, and {@link Individual}s getting "lost" as a result.
   *
   * This function is guaranteed to be idempotent (since version 0.3.0).
   *
   * @since 0.1.11
   */
static void folks_individual_aggregator_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorPrepareData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_prepare_co (data);
}


static gboolean folks_individual_aggregator_prepare_co (FolksIndividualAggregatorPrepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_static_rec_mutex_lock (&data->self->priv->__lock__is_prepared);
		if (!data->self->priv->_is_prepared) {
			data->_state_ = 1;
			folks_backend_store_load_backends (data->self->priv->_backend_store, folks_individual_aggregator_prepare_ready, data);
			return FALSE;
			_state_1:
			folks_backend_store_load_backends_finish (data->self->priv->_backend_store, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __finally10;
			}
			data->self->priv->_is_prepared = TRUE;
			g_object_notify ((GObject*) data->self, "is-prepared");
		}
		__finally10:
		g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


/**
   * Get all matches for a given {@link Individual}.
   *
   * @since 0.5.1
   */
GeeMap* folks_individual_aggregator_get_potential_matches (FolksIndividualAggregator* self, FolksIndividual* matchee, FolksMatchResult min_threshold) {
	GeeMap* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* matches;
	FolksPotentialMatch* _tmp1_ = NULL;
	FolksPotentialMatch* matchObj;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (matchee != NULL, NULL);
	_tmp0_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_MATCH_RESULT, NULL, NULL, NULL, NULL, NULL);
	matches = _tmp0_;
	_tmp1_ = folks_potential_match_new ();
	matchObj = _tmp1_;
	{
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _i_it;
		_tmp2_ = gee_map_get_values (self->priv->_individuals);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_i_it = _tmp5_;
		while (TRUE) {
			gboolean _tmp6_;
			gpointer _tmp7_ = NULL;
			FolksIndividual* i;
			const gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			FolksMatchResult _tmp10_;
			FolksMatchResult _result_;
			_tmp6_ = gee_iterator_next (_i_it);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = gee_iterator_get (_i_it);
			i = (FolksIndividual*) _tmp7_;
			_tmp8_ = folks_individual_get_id (i);
			_tmp9_ = folks_individual_get_id (matchee);
			if (g_strcmp0 (_tmp8_, _tmp9_) == 0) {
				_g_object_unref0 (i);
				continue;
			}
			_tmp10_ = folks_potential_match_potential_match (matchObj, i, matchee);
			_result_ = _tmp10_;
			if (_result_ >= min_threshold) {
				gee_abstract_map_set ((GeeAbstractMap*) matches, i, GINT_TO_POINTER (_result_));
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	result = (GeeMap*) matches;
	_g_object_unref0 (matchObj);
	return result;
}


/**
   * Get all combinations between all {@link Individual}s.
   *
   * @since 0.5.1
   */
GeeMap* folks_individual_aggregator_get_all_potential_matches (FolksIndividualAggregator* self, FolksMatchResult min_threshold) {
	GeeMap* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* matches;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_;
	gint _tmp3_;
	gpointer* _tmp4_ = NULL;
	FolksIndividual** _tmp5_;
	FolksIndividual** individuals;
	gint individuals_length1;
	gint _individuals_size_;
	FolksPotentialMatch* _tmp6_ = NULL;
	FolksPotentialMatch* matchObj;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	matches = _tmp0_;
	_tmp1_ = gee_map_get_values (self->priv->_individuals);
	_tmp2_ = _tmp1_;
	_tmp4_ = gee_collection_to_array (_tmp2_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	individuals = _tmp5_;
	individuals_length1 = _tmp3_;
	_individuals_size_ = _tmp3_;
	_tmp6_ = folks_potential_match_new ();
	matchObj = _tmp6_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				FolksIndividual* _tmp8_;
				FolksIndividual* a;
				gpointer _tmp9_ = NULL;
				GeeHashMap* matches_a;
				if (!_tmp7_) {
					i++;
				}
				_tmp7_ = FALSE;
				if (!(i < individuals_length1)) {
					break;
				}
				_tmp8_ = _g_object_ref0 (individuals[i]);
				a = _tmp8_;
				_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) matches, a);
				matches_a = (GeeHashMap*) _tmp9_;
				if (matches_a == NULL) {
					GeeHashMap* _tmp10_ = NULL;
					_tmp10_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_MATCH_RESULT, NULL, NULL, NULL, NULL, NULL);
					_g_object_unref0 (matches_a);
					matches_a = _tmp10_;
					gee_abstract_map_set ((GeeAbstractMap*) matches, a, matches_a);
				}
				{
					gint f;
					f = i + 1;
					{
						gboolean _tmp11_;
						_tmp11_ = TRUE;
						while (TRUE) {
							FolksIndividual* _tmp12_;
							FolksIndividual* b;
							gpointer _tmp13_ = NULL;
							GeeHashMap* matches_b;
							FolksMatchResult _tmp15_;
							FolksMatchResult _result_;
							if (!_tmp11_) {
								f++;
							}
							_tmp11_ = FALSE;
							if (!(f < individuals_length1)) {
								break;
							}
							_tmp12_ = _g_object_ref0 (individuals[f]);
							b = _tmp12_;
							_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) matches, b);
							matches_b = (GeeHashMap*) _tmp13_;
							if (matches_b == NULL) {
								GeeHashMap* _tmp14_ = NULL;
								_tmp14_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_MATCH_RESULT, NULL, NULL, NULL, NULL, NULL);
								_g_object_unref0 (matches_b);
								matches_b = _tmp14_;
								gee_abstract_map_set ((GeeAbstractMap*) matches, b, matches_b);
							}
							_tmp15_ = folks_potential_match_potential_match (matchObj, a, b);
							_result_ = _tmp15_;
							if (_result_ >= min_threshold) {
								gee_abstract_map_set ((GeeAbstractMap*) matches_a, b, GINT_TO_POINTER (_result_));
								gee_abstract_map_set ((GeeAbstractMap*) matches_b, a, GINT_TO_POINTER (_result_));
							}
							_g_object_unref0 (matches_b);
							_g_object_unref0 (b);
						}
					}
				}
				_g_object_unref0 (matches_a);
				_g_object_unref0 (a);
			}
		}
	}
	result = (GeeMap*) matches;
	_g_object_unref0 (matchObj);
	individuals = (_vala_array_free (individuals, individuals_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}


static void _folks_individual_aggregator_add_backend_data_free (gpointer _data) {
	FolksIndividualAggregatorAddBackendData* data;
	data = _data;
	_g_object_unref0 (data->backend);
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorAddBackendData, data);
}


static void _folks_individual_aggregator_add_backend (FolksIndividualAggregator* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorAddBackendData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorAddBackendData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_individual_aggregator_add_backend);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_individual_aggregator_add_backend_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->backend = _g_object_ref0 (backend);
	_folks_individual_aggregator_add_backend_co (_data_);
}


static void _folks_individual_aggregator_add_backend_finish (FolksIndividualAggregator* self, GAsyncResult* _res_) {
	FolksIndividualAggregatorAddBackendData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void __folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
	_folks_individual_aggregator_backend_persona_store_added_cb (self, _sender, store);
}


static void __folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
	_folks_individual_aggregator_backend_persona_store_removed_cb (self, _sender, store);
}


static gboolean _folks_individual_aggregator_add_backend_co (FolksIndividualAggregatorAddBackendData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = gee_abstract_collection_contains ((GeeAbstractCollection*) data->self->priv->_backends, data->backend);
	if (!data->_tmp0_) {
		gee_abstract_collection_add ((GeeAbstractCollection*) data->self->priv->_backends, data->backend);
		g_signal_connect_object (data->backend, "persona-store-added", (GCallback) __folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added, data->self, 0);
		g_signal_connect_object (data->backend, "persona-store-removed", (GCallback) __folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed, data->self, 0);
		{
			data->_tmp1_ = NULL;
			data->_tmp1_ = folks_backend_get_persona_stores (data->backend);
			data->_tmp2_ = NULL;
			data->_tmp2_ = gee_map_get_values (data->_tmp1_);
			data->_tmp3_ = data->_tmp2_;
			data->_tmp4_ = NULL;
			data->_tmp4_ = gee_iterable_iterator ((GeeIterable*) data->_tmp3_);
			data->_tmp5_ = data->_tmp4_;
			_g_object_unref0 (data->_tmp3_);
			data->_persona_store_it = data->_tmp5_;
			while (TRUE) {
				data->_tmp6_ = gee_iterator_next (data->_persona_store_it);
				if (!data->_tmp6_) {
					break;
				}
				data->_tmp7_ = NULL;
				data->_tmp7_ = gee_iterator_get (data->_persona_store_it);
				data->persona_store = (FolksPersonaStore*) data->_tmp7_;
				_folks_individual_aggregator_backend_persona_store_added_cb (data->self, data->backend, data->persona_store);
				_g_object_unref0 (data->persona_store);
			}
			_g_object_unref0 (data->_persona_store_it);
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _folks_individual_aggregator_backend_available_cb (FolksIndividualAggregator* self, FolksBackendStore* backend_store, FolksBackend* backend) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend_store != NULL);
	g_return_if_fail (backend != NULL);
	_folks_individual_aggregator_add_backend (self, backend, NULL, NULL);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_free0 (_data1_->store_id);
		_g_object_unref0 (_data1_->store);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_folks_individual_aggregator_personas_changed_cb (self, _sender, added, removed, message, actor, reason);
}


static void __folks_individual_aggregator_is_writeable_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_folks_individual_aggregator_is_writeable_changed_cb (self, _sender, pspec);
}


static void __folks_individual_aggregator_trust_level_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_folks_individual_aggregator_trust_level_changed_cb (self, _sender, pspec);
}


static void _lambda5_ (GObject* obj, GAsyncResult* _result_, Block1Data* _data1_) {
	FolksIndividualAggregator * self;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	g_return_if_fail (_result_ != NULL);
	folks_persona_store_prepare_finish (_data1_->store, _result_, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch11_g_error;
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		const gchar* _tmp0_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = _ ("Error preparing persona store '%s': %s");
		g_warning (_tmp0_, _data1_->store_id, e->message);
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda5_ (source_object, res, self);
	block1_data_unref (self);
}


static void _folks_individual_aggregator_backend_persona_store_added_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store) {
	Block1Data* _data1_;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (store != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->store = _g_object_ref0 (store);
	_tmp0_ = folks_persona_store_get_type_id (_data1_->store);
	_tmp1_ = folks_persona_store_get_id (_data1_->store);
	_tmp2_ = _folks_individual_aggregator_get_store_full_id (self, _tmp0_, _tmp1_);
	_data1_->store_id = _tmp2_;
	_tmp3_ = folks_persona_store_get_type_id (_data1_->store);
	if (g_strcmp0 (_tmp3_, self->priv->_configured_writeable_store_type_id) == 0) {
		folks_persona_store_set_is_writeable (_data1_->store, TRUE);
		folks_persona_store_set_trust_level (_data1_->store, FOLKS_PERSONA_STORE_TRUST_FULL);
		self->priv->_writeable_store = _data1_->store;
	}
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->_stores, _data1_->store_id, _data1_->store);
	g_signal_connect_object (_data1_->store, "personas-changed", (GCallback) __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed, self, 0);
	g_signal_connect_object ((GObject*) _data1_->store, "notify::is-writeable", (GCallback) __folks_individual_aggregator_is_writeable_changed_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) _data1_->store, "notify::trust-level", (GCallback) __folks_individual_aggregator_trust_level_changed_cb_g_object_notify, self, 0);
	folks_persona_store_prepare (_data1_->store, __lambda5__gasync_ready_callback, block1_data_ref (_data1_));
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void _folks_individual_aggregator_backend_persona_store_removed_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store) {
	guint _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	guint _tmp3_;
	GQuark _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (store != NULL);
	g_signal_parse_name ("personas-changed", FOLKS_TYPE_PERSONA_STORE, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed, self);
	g_signal_parse_name ("notify::trust-level", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) __folks_individual_aggregator_trust_level_changed_cb_g_object_notify, self);
	g_signal_parse_name ("notify::is-writeable", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) __folks_individual_aggregator_is_writeable_changed_cb_g_object_notify, self);
	if (self->priv->_writeable_store == store) {
		self->priv->_writeable_store = NULL;
	}
	_tmp5_ = folks_persona_store_get_type_id (store);
	_tmp6_ = folks_persona_store_get_id (store);
	_tmp7_ = _folks_individual_aggregator_get_store_full_id (self, _tmp5_, _tmp6_);
	_tmp8_ = _tmp7_;
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->_stores, _tmp8_, NULL);
	_g_free0 (_tmp8_);
}


static gchar* _folks_individual_aggregator_get_store_full_id (FolksIndividualAggregator* self, const gchar* type_id, const gchar* id) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_id != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = g_strconcat (type_id, ":", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, id, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static void _folks_individual_aggregator_emit_individuals_changed (FolksIndividualAggregator* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	GeeSet* _tmp0_;
	GeeSet* _added;
	GeeSet* _tmp1_;
	GeeSet* _removed;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GeeSet* _tmp9_ = NULL;
	GeeSet* _tmp10_;
	GeeSet* _tmp11_ = NULL;
	GeeSet* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (added);
	_added = _tmp0_;
	_tmp1_ = _g_object_ref0 (removed);
	_removed = _tmp1_;
	if (added == NULL) {
		_tmp3_ = TRUE;
	} else {
		gint _tmp4_;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) added);
		_tmp3_ = _tmp4_ == 0;
	}
	if (_tmp3_) {
		gboolean _tmp5_ = FALSE;
		if (removed == NULL) {
			_tmp5_ = TRUE;
		} else {
			gint _tmp6_;
			_tmp6_ = gee_collection_get_size ((GeeCollection*) removed);
			_tmp5_ = _tmp6_ == 0;
		}
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_g_object_unref0 (_removed);
		_g_object_unref0 (_added);
		return;
	} else {
		if (added == NULL) {
			GeeHashSet* _tmp7_ = NULL;
			_tmp7_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
			_g_object_unref0 (_added);
			_added = (GeeSet*) _tmp7_;
		} else {
			if (removed == NULL) {
				GeeHashSet* _tmp8_ = NULL;
				_tmp8_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
				_g_object_unref0 (_removed);
				_removed = (GeeSet*) _tmp8_;
			}
		}
	}
	_tmp9_ = gee_set_get_read_only_view (_added);
	_tmp10_ = _tmp9_;
	_tmp11_ = gee_set_get_read_only_view (_removed);
	_tmp12_ = _tmp11_;
	g_signal_emit_by_name (self, "individuals-changed", _tmp10_, _tmp12_, message, actor, reason);
	_g_object_unref0 (_tmp12_);
	_g_object_unref0 (_tmp10_);
	_g_object_unref0 (_removed);
	_g_object_unref0 (_added);
}


static void __folks_individual_aggregator_individual_removed_cb_folks_individual_removed (FolksIndividual* _sender, FolksIndividual* replacement_individual, gpointer self) {
	_folks_individual_aggregator_individual_removed_cb (self, _sender, replacement_individual);
}


static void _folks_individual_aggregator_connect_to_individual (FolksIndividualAggregator* self, FolksIndividual* individual) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	g_signal_connect_object (individual, "removed", (GCallback) __folks_individual_aggregator_individual_removed_cb_folks_individual_removed, self, 0);
	_tmp0_ = folks_individual_get_id (individual);
	gee_map_set (self->priv->_individuals, _tmp0_, individual);
}


static void _folks_individual_aggregator_disconnect_from_individual (FolksIndividualAggregator* self, FolksIndividual* individual) {
	const gchar* _tmp0_ = NULL;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	_tmp0_ = folks_individual_get_id (individual);
	gee_map_unset (self->priv->_individuals, _tmp0_, NULL);
	g_signal_parse_name ("removed", FOLKS_TYPE_INDIVIDUAL, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (individual, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __folks_individual_aggregator_individual_removed_cb_folks_individual_removed, self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->final_individual);
		_g_object_unref0 (_data2_->candidate_inds);
		g_slice_free (Block2Data, _data2_);
	}
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}


static void _lambda2_ (const gchar* l, Block3Data* _data3_) {
	Block2Data* _data2_;
	FolksIndividualAggregator * self;
	const gchar* prop_linking_value;
	gconstpointer _tmp0_ = NULL;
	FolksIndividual* _tmp1_;
	FolksIndividual* candidate_ind;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	g_return_if_fail (l != NULL);
	prop_linking_value = l;
	_tmp0_ = g_hash_table_lookup (self->priv->_link_map, prop_linking_value);
	_tmp1_ = _g_object_ref0 ((FolksIndividual*) _tmp0_);
	candidate_ind = _tmp1_;
	if (candidate_ind != NULL) {
		FolksTrustLevel _tmp4_;
		_tmp4_ = folks_individual_get_trust_level (candidate_ind);
		_tmp3_ = _tmp4_ != FOLKS_TRUST_LEVEL_NONE;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean _tmp5_;
		_tmp5_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data2_->candidate_inds, candidate_ind);
		_tmp2_ = !_tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = folks_individual_get_id (candidate_ind);
		g_debug ("    Found candidate individual '%s' by " "linkable property '%s' = '%s'.", _tmp6_, _data3_->prop_name, prop_linking_value);
		gee_abstract_collection_add ((GeeAbstractCollection*) _data2_->candidate_inds, candidate_ind);
	}
	_g_object_unref0 (candidate_ind);
}


static void __lambda2__folks_persona_linkable_property_callback (const gchar* link, gpointer self) {
	_lambda2_ (link, self);
}


static void _lambda3_ (const gchar* l, Block2Data* _data2_) {
	FolksIndividualAggregator * self;
	const gchar* prop_linking_value;
	gchar* _tmp0_;
	FolksIndividual* _tmp1_;
	self = _data2_->self;
	g_return_if_fail (l != NULL);
	prop_linking_value = l;
	g_debug ("individual-aggregator.vala:703:             %s", prop_linking_value);
	_tmp0_ = g_strdup (prop_linking_value);
	_tmp1_ = _g_object_ref0 (_data2_->final_individual);
	g_hash_table_replace (self->priv->_link_map, _tmp0_, _tmp1_);
}


static void __lambda3__folks_persona_linkable_property_callback (const gchar* link, gpointer self) {
	_lambda3_ (link, self);
}


static void _folks_individual_aggregator_add_personas (FolksIndividualAggregator* self, GeeSet* added, GeeHashSet** added_individuals, GeeHashMap** replaced_individuals, FolksIndividual** user) {
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* almost_added_individuals;
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (added_individuals != NULL);
	g_return_if_fail (replaced_individuals != NULL);
	g_return_if_fail (user != NULL);
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	almost_added_individuals = _tmp0_;
	{
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _persona_it;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) added);
		_persona_it = _tmp1_;
		while (TRUE) {
			Block2Data* _data2_;
			gboolean _tmp2_;
			gpointer _tmp3_ = NULL;
			FolksPersona* persona;
			FolksPersonaStore* _tmp4_ = NULL;
			FolksPersonaStoreTrust _tmp5_;
			FolksPersonaStoreTrust trust_level;
			GeeHashSet* _tmp6_ = NULL;
			GeeHashSet* _tmp7_ = NULL;
			GeeHashSet* final_personas;
			const gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_;
			FolksPersonaStore* _tmp22_ = NULL;
			FolksPersonaStoreTrust _tmp23_;
			gboolean _tmp29_ = FALSE;
			gint _tmp30_;
			FolksIndividual* _tmp36_ = NULL;
			const gchar* _tmp37_ = NULL;
			gboolean _tmp60_;
			_data2_ = g_slice_new0 (Block2Data);
			_data2_->_ref_count_ = 1;
			_data2_->self = g_object_ref (self);
			_tmp2_ = gee_iterator_next (_persona_it);
			if (!_tmp2_) {
				block2_data_unref (_data2_);
				_data2_ = NULL;
				break;
			}
			_tmp3_ = gee_iterator_get (_persona_it);
			persona = (FolksPersona*) _tmp3_;
			_tmp4_ = folks_persona_get_store (persona);
			_tmp5_ = folks_persona_store_get_trust_level (_tmp4_);
			trust_level = _tmp5_;
			_tmp6_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
			_data2_->candidate_inds = _tmp6_;
			_tmp7_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
			final_personas = _tmp7_;
			_data2_->final_individual = NULL;
			_tmp8_ = folks_persona_get_uid (persona);
			_tmp9_ = folks_persona_get_iid (persona);
			g_debug ("individual-aggregator.vala:568: Aggregating persona '%s' on '%s'.", _tmp8_, _tmp9_);
			_tmp11_ = folks_persona_get_is_user (persona);
			if (_tmp11_ == TRUE) {
				_tmp10_ = (*user) != NULL;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				const gchar* _tmp12_ = NULL;
				_tmp12_ = folks_individual_get_id (*user);
				g_debug ("individual-aggregator.vala:574:     Found candidate individual '%s' as" \
" user.", _tmp12_);
				gee_abstract_collection_add ((GeeAbstractCollection*) _data2_->candidate_inds, *user);
			}
			if (trust_level != FOLKS_PERSONA_STORE_TRUST_NONE) {
				const gchar* _tmp13_ = NULL;
				gconstpointer _tmp14_ = NULL;
				FolksIndividual* _tmp15_;
				FolksIndividual* candidate_ind;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				_tmp13_ = folks_persona_get_iid (persona);
				_tmp14_ = g_hash_table_lookup (self->priv->_link_map, _tmp13_);
				_tmp15_ = _g_object_ref0 ((FolksIndividual*) _tmp14_);
				candidate_ind = _tmp15_;
				if (candidate_ind != NULL) {
					FolksTrustLevel _tmp18_;
					_tmp18_ = folks_individual_get_trust_level (candidate_ind);
					_tmp17_ = _tmp18_ != FOLKS_TRUST_LEVEL_NONE;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					gboolean _tmp19_;
					_tmp19_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data2_->candidate_inds, candidate_ind);
					_tmp16_ = !_tmp19_;
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					const gchar* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					_tmp20_ = folks_individual_get_id (candidate_ind);
					_tmp21_ = folks_persona_get_iid (persona);
					g_debug ("individual-aggregator.vala:587:     Found candidate individual '%s' by" \
" IID '%s'.", _tmp20_, _tmp21_);
					gee_abstract_collection_add ((GeeAbstractCollection*) _data2_->candidate_inds, candidate_ind);
				}
				_g_object_unref0 (candidate_ind);
			}
			_tmp22_ = folks_persona_get_store (persona);
			_tmp23_ = folks_persona_store_get_trust_level (_tmp22_);
			if (_tmp23_ == FOLKS_PERSONA_STORE_TRUST_FULL) {
				gchar** _tmp24_ = NULL;
				gint _tmp25_;
				_tmp24_ = folks_persona_get_linkable_properties (persona, &_tmp25_);
				{
					gchar** foo_collection;
					int foo_collection_length1;
					int foo_it;
					foo_collection = _tmp24_;
					foo_collection_length1 = _tmp25_;
					for (foo_it = 0; foo_it < _tmp25_; foo_it = foo_it + 1) {
						const gchar* foo;
						foo = foo_collection[foo_it];
						{
							Block3Data* _data3_;
							GObjectClass* _tmp26_ = NULL;
							GObjectClass* pclass;
							GParamSpec* _tmp27_ = NULL;
							_data3_ = g_slice_new0 (Block3Data);
							_data3_->_ref_count_ = 1;
							_data3_->_data2_ = block2_data_ref (_data2_);
							_data3_->prop_name = foo;
							_tmp26_ = G_OBJECT_GET_CLASS ((GObject*) persona);
							pclass = _tmp26_;
							_tmp27_ = g_object_class_find_property (pclass, _data3_->prop_name);
							if (_tmp27_ == NULL) {
								const gchar* _tmp28_ = NULL;
								_tmp28_ = _ ("Unknown property '%s' in linkable property list.");
								g_warning (_tmp28_, _data3_->prop_name);
								block3_data_unref (_data3_);
								_data3_ = NULL;
								continue;
							}
							folks_persona_linkable_property_to_links (persona, _data3_->prop_name, __lambda2__folks_persona_linkable_property_callback, _data3_);
							block3_data_unref (_data3_);
							_data3_ = NULL;
						}
					}
				}
			}
			gee_abstract_collection_add ((GeeAbstractCollection*) final_personas, persona);
			_tmp30_ = gee_collection_get_size ((GeeCollection*) _data2_->candidate_inds);
			if (_tmp30_ > 0) {
				_tmp29_ = self->priv->_linking_enabled == TRUE;
			} else {
				_tmp29_ = FALSE;
			}
			if (_tmp29_) {
				{
					GeeIterator* _tmp31_ = NULL;
					GeeIterator* _individual_it;
					_tmp31_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data2_->candidate_inds);
					_individual_it = _tmp31_;
					while (TRUE) {
						gboolean _tmp32_;
						gpointer _tmp33_ = NULL;
						FolksIndividual* individual;
						GeeSet* _tmp34_ = NULL;
						_tmp32_ = gee_iterator_next (_individual_it);
						if (!_tmp32_) {
							break;
						}
						_tmp33_ = gee_iterator_get (_individual_it);
						individual = (FolksIndividual*) _tmp33_;
						_tmp34_ = folks_individual_get_personas (individual);
						gee_abstract_collection_add_all ((GeeAbstractCollection*) final_personas, (GeeCollection*) _tmp34_);
						_g_object_unref0 (individual);
					}
					_g_object_unref0 (_individual_it);
				}
			} else {
				gint _tmp35_;
				_tmp35_ = gee_collection_get_size ((GeeCollection*) _data2_->candidate_inds);
				if (_tmp35_ > 0) {
					g_debug ("individual-aggregator.vala:651:     Linking disabled.");
				} else {
					g_debug ("individual-aggregator.vala:655:     Did not find any candidate individ" \
"uals.");
				}
			}
			_tmp36_ = folks_individual_new ((GeeSet*) final_personas);
			_g_object_unref0 (_data2_->final_individual);
			_data2_->final_individual = _tmp36_;
			_tmp37_ = folks_individual_get_id (_data2_->final_individual);
			g_debug ("individual-aggregator.vala:660:     Created new individual '%s' with p" \
"ersonas:", _tmp37_);
			{
				GeeIterator* _tmp38_ = NULL;
				GeeIterator* _p_it;
				_tmp38_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) final_personas);
				_p_it = _tmp38_;
				while (TRUE) {
					gboolean _tmp39_;
					gpointer _tmp40_ = NULL;
					FolksPersona* p;
					FolksPersona* _tmp41_;
					FolksPersona* final_persona;
					const gchar* _tmp42_ = NULL;
					gboolean _tmp43_;
					const gchar* _tmp44_ = NULL;
					const gchar* _tmp45_ = NULL;
					const gchar* _tmp46_ = NULL;
					gchar* _tmp47_;
					FolksIndividual* _tmp48_;
					FolksPersonaStore* _tmp49_ = NULL;
					FolksPersonaStoreTrust _tmp50_;
					_tmp39_ = gee_iterator_next (_p_it);
					if (!_tmp39_) {
						break;
					}
					_tmp40_ = gee_iterator_get (_p_it);
					p = (FolksPersona*) _tmp40_;
					_tmp41_ = _g_object_ref0 (FOLKS_PERSONA (p));
					final_persona = _tmp41_;
					_tmp43_ = folks_persona_get_is_user (final_persona);
					if (_tmp43_) {
						_tmp42_ = "yes";
					} else {
						_tmp42_ = "no";
					}
					_tmp44_ = folks_persona_get_uid (final_persona);
					_tmp45_ = folks_persona_get_iid (final_persona);
					g_debug ("individual-aggregator.vala:666:         %s (is user: %s, IID: %s)", _tmp44_, _tmp42_, _tmp45_);
					_tmp46_ = folks_persona_get_iid (final_persona);
					_tmp47_ = g_strdup (_tmp46_);
					_tmp48_ = _g_object_ref0 (_data2_->final_individual);
					g_hash_table_replace (self->priv->_link_map, _tmp47_, _tmp48_);
					_tmp49_ = folks_persona_get_store (final_persona);
					_tmp50_ = folks_persona_store_get_trust_level (_tmp49_);
					if (_tmp50_ == FOLKS_PERSONA_STORE_TRUST_FULL) {
						gchar** _tmp51_ = NULL;
						gint _tmp52_;
						g_debug ("individual-aggregator.vala:679:         Inserting links:");
						_tmp51_ = folks_persona_get_linkable_properties (final_persona, &_tmp52_);
						{
							gchar** prop_name_collection;
							int prop_name_collection_length1;
							int prop_name_it;
							prop_name_collection = _tmp51_;
							prop_name_collection_length1 = _tmp52_;
							for (prop_name_it = 0; prop_name_it < _tmp52_; prop_name_it = prop_name_it + 1) {
								const gchar* prop_name;
								prop_name = prop_name_collection[prop_name_it];
								{
									GObjectClass* _tmp53_ = NULL;
									GObjectClass* pclass;
									GParamSpec* _tmp54_ = NULL;
									_tmp53_ = G_OBJECT_GET_CLASS ((GObject*) final_persona);
									pclass = _tmp53_;
									_tmp54_ = g_object_class_find_property (pclass, prop_name);
									if (_tmp54_ == NULL) {
										const gchar* _tmp55_ = NULL;
										_tmp55_ = _ ("Unknown property '%s' in linkable property list.");
										g_warning (_tmp55_, prop_name);
										continue;
									}
									folks_persona_linkable_property_to_links (final_persona, prop_name, __lambda3__folks_persona_linkable_property_callback, _data2_);
								}
							}
						}
					}
					_g_object_unref0 (final_persona);
					_g_object_unref0 (p);
				}
				_g_object_unref0 (_p_it);
			}
			{
				GeeIterator* _tmp56_ = NULL;
				GeeIterator* _i_it;
				_tmp56_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data2_->candidate_inds);
				_i_it = _tmp56_;
				while (TRUE) {
					gboolean _tmp57_;
					gpointer _tmp58_ = NULL;
					FolksIndividual* i;
					gboolean _tmp59_;
					_tmp57_ = gee_iterator_next (_i_it);
					if (!_tmp57_) {
						break;
					}
					_tmp58_ = gee_iterator_get (_i_it);
					i = (FolksIndividual*) _tmp58_;
					_tmp59_ = gee_abstract_collection_contains ((GeeAbstractCollection*) almost_added_individuals, i);
					if (_tmp59_ == TRUE) {
						gee_abstract_collection_remove ((GeeAbstractCollection*) almost_added_individuals, i);
					} else {
						gee_abstract_map_set ((GeeAbstractMap*) (*replaced_individuals), i, _data2_->final_individual);
					}
					_g_object_unref0 (i);
				}
				_g_object_unref0 (_i_it);
			}
			_tmp60_ = folks_individual_get_is_user (_data2_->final_individual);
			if (_tmp60_ == TRUE) {
				FolksIndividual* _tmp61_;
				_tmp61_ = _g_object_ref0 (_data2_->final_individual);
				_g_object_unref0 (*user);
				*user = _tmp61_;
			}
			gee_abstract_collection_add ((GeeAbstractCollection*) almost_added_individuals, _data2_->final_individual);
			_g_object_unref0 (final_personas);
			_g_object_unref0 (persona);
			block2_data_unref (_data2_);
			_data2_ = NULL;
		}
		_g_object_unref0 (_persona_it);
	}
	{
		GeeIterator* _tmp62_ = NULL;
		GeeIterator* _i_it;
		_tmp62_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) almost_added_individuals);
		_i_it = _tmp62_;
		while (TRUE) {
			gboolean _tmp63_;
			gpointer _tmp64_ = NULL;
			FolksIndividual* i;
			_tmp63_ = gee_iterator_next (_i_it);
			if (!_tmp63_) {
				break;
			}
			_tmp64_ = gee_iterator_get (_i_it);
			i = (FolksIndividual*) _tmp64_;
			gee_abstract_collection_add ((GeeAbstractCollection*) (*added_individuals), i);
			_folks_individual_aggregator_connect_to_individual (self, i);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	_g_object_unref0 (almost_added_individuals);
}


static void _lambda4_ (const gchar* linking_value, FolksIndividualAggregator* self) {
	g_return_if_fail (linking_value != NULL);
	g_debug ("individual-aggregator.vala:767:         %s", linking_value);
	g_hash_table_remove (self->priv->_link_map, linking_value);
}


static void __lambda4__folks_persona_linkable_property_callback (const gchar* link, gpointer self) {
	_lambda4_ (link, self);
}


static void _folks_individual_aggregator_remove_persona_from_link_map (FolksIndividualAggregator* self, FolksPersona* persona) {
	const gchar* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_ = NULL;
	FolksPersonaStoreTrust _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	_tmp0_ = folks_persona_get_iid (persona);
	g_hash_table_remove (self->priv->_link_map, _tmp0_);
	_tmp1_ = folks_persona_get_store (persona);
	_tmp2_ = folks_persona_store_get_trust_level (_tmp1_);
	if (_tmp2_ == FOLKS_PERSONA_STORE_TRUST_FULL) {
		const gchar* _tmp3_ = NULL;
		gchar** _tmp4_ = NULL;
		gint _tmp5_;
		_tmp3_ = folks_persona_get_uid (persona);
		g_debug ("individual-aggregator.vala:747:     Removing links to %s:", _tmp3_);
		_tmp4_ = folks_persona_get_linkable_properties (persona, &_tmp5_);
		{
			gchar** prop_name_collection;
			int prop_name_collection_length1;
			int prop_name_it;
			prop_name_collection = _tmp4_;
			prop_name_collection_length1 = _tmp5_;
			for (prop_name_it = 0; prop_name_it < _tmp5_; prop_name_it = prop_name_it + 1) {
				const gchar* prop_name;
				prop_name = prop_name_collection[prop_name_it];
				{
					GObjectClass* _tmp6_ = NULL;
					GObjectClass* pclass;
					GParamSpec* _tmp7_ = NULL;
					_tmp6_ = G_OBJECT_GET_CLASS ((GObject*) persona);
					pclass = _tmp6_;
					_tmp7_ = g_object_class_find_property (pclass, prop_name);
					if (_tmp7_ == NULL) {
						const gchar* _tmp8_ = NULL;
						_tmp8_ = _ ("Unknown property '%s' in linkable property list.");
						g_warning (_tmp8_, prop_name);
						continue;
					}
					folks_persona_linkable_property_to_links (persona, prop_name, __lambda4__folks_persona_linkable_property_callback, self);
				}
			}
		}
	}
}


static void _folks_individual_aggregator_personas_changed_cb (FolksIndividualAggregator* self, FolksPersonaStore* store, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* added_individuals;
	GeeHashSet* _tmp1_ = NULL;
	GeeHashSet* removed_individuals;
	GeeHashMap* _tmp2_ = NULL;
	GeeHashMap* replaced_individuals;
	GeeHashSet* _tmp3_ = NULL;
	GeeHashSet* relinked_personas;
	GeeHashSet* _tmp4_ = NULL;
	GeeHashSet* removed_personas;
	FolksIndividual* _tmp5_;
	FolksIndividual* user;
	gint _tmp6_;
	gboolean _tmp41_ = FALSE;
	gint _tmp42_;
	GeeMapIterator* _tmp44_ = NULL;
	GeeMapIterator* iter;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	added_individuals = _tmp0_;
	_tmp1_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	removed_individuals = _tmp1_;
	_tmp2_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	replaced_individuals = _tmp2_;
	_tmp3_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	relinked_personas = _tmp3_;
	_tmp4_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal);
	removed_personas = _tmp4_;
	_tmp5_ = _g_object_ref0 (self->priv->_user);
	user = _tmp5_;
	_tmp6_ = gee_collection_get_size ((GeeCollection*) added);
	if (_tmp6_ > 0) {
		_folks_individual_aggregator_add_personas (self, added, &added_individuals, &replaced_individuals, &user);
	}
	g_debug ("individual-aggregator.vala:798: Removing Personas:");
	{
		GeeIterator* _tmp7_ = NULL;
		GeeIterator* _persona_it;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) removed);
		_persona_it = _tmp7_;
		while (TRUE) {
			gboolean _tmp8_;
			gpointer _tmp9_ = NULL;
			FolksPersona* persona;
			const gchar* _tmp10_ = NULL;
			gboolean _tmp11_;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gconstpointer _tmp15_ = NULL;
			FolksIndividual* _tmp16_;
			FolksIndividual* ind;
			_tmp8_ = gee_iterator_next (_persona_it);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = gee_iterator_get (_persona_it);
			persona = (FolksPersona*) _tmp9_;
			_tmp11_ = folks_persona_get_is_user (persona);
			if (_tmp11_) {
				_tmp10_ = "yes";
			} else {
				_tmp10_ = "no";
			}
			_tmp12_ = folks_persona_get_uid (persona);
			_tmp13_ = folks_persona_get_iid (persona);
			g_debug ("individual-aggregator.vala:802:     %s (is user: %s, IID: %s)", _tmp12_, _tmp10_, _tmp13_);
			gee_abstract_collection_add ((GeeAbstractCollection*) removed_personas, persona);
			_tmp14_ = folks_persona_get_iid (persona);
			_tmp15_ = g_hash_table_lookup (self->priv->_link_map, _tmp14_);
			_tmp16_ = _g_object_ref0 ((FolksIndividual*) _tmp15_);
			ind = _tmp16_;
			if (ind != NULL) {
				gee_abstract_collection_add ((GeeAbstractCollection*) removed_individuals, ind);
			}
			_folks_individual_aggregator_remove_persona_from_link_map (self, persona);
			_g_object_unref0 (ind);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	g_debug ("individual-aggregator.vala:827: Removing Individuals due to removed li" \
"nks:");
	{
		GeeIterator* _tmp17_ = NULL;
		GeeIterator* _individual_it;
		_tmp17_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) removed_individuals);
		_individual_it = _tmp17_;
		while (TRUE) {
			gboolean _tmp18_;
			gpointer _tmp19_ = NULL;
			FolksIndividual* individual;
			const gchar* _tmp20_ = NULL;
			gboolean _tmp21_;
			const gchar* _tmp22_ = NULL;
			_tmp18_ = gee_iterator_next (_individual_it);
			if (!_tmp18_) {
				break;
			}
			_tmp19_ = gee_iterator_get (_individual_it);
			individual = (FolksIndividual*) _tmp19_;
			_tmp20_ = folks_individual_get_id (individual);
			_tmp21_ = gee_map_has_key (self->priv->_individuals, _tmp20_);
			if (_tmp21_ == FALSE) {
				_g_object_unref0 (individual);
				continue;
			}
			_tmp22_ = folks_individual_get_id (individual);
			g_debug ("individual-aggregator.vala:834:     %s", _tmp22_);
			{
				GeeSet* _tmp23_ = NULL;
				GeeIterator* _tmp24_ = NULL;
				GeeIterator* _persona_it;
				_tmp23_ = folks_individual_get_personas (individual);
				_tmp24_ = gee_iterable_iterator ((GeeIterable*) _tmp23_);
				_persona_it = _tmp24_;
				while (TRUE) {
					gboolean _tmp25_;
					gpointer _tmp26_ = NULL;
					FolksPersona* persona;
					gboolean _tmp27_ = FALSE;
					gboolean _tmp28_;
					_tmp25_ = gee_iterator_next (_persona_it);
					if (!_tmp25_) {
						break;
					}
					_tmp26_ = gee_iterator_get (_persona_it);
					persona = (FolksPersona*) _tmp26_;
					_tmp28_ = gee_abstract_collection_contains ((GeeAbstractCollection*) removed_personas, persona);
					if (_tmp28_ == TRUE) {
						_tmp27_ = TRUE;
					} else {
						gboolean _tmp29_;
						_tmp29_ = gee_abstract_collection_contains ((GeeAbstractCollection*) relinked_personas, persona);
						_tmp27_ = _tmp29_ == TRUE;
					}
					if (_tmp27_) {
						_g_object_unref0 (persona);
						continue;
					}
					gee_abstract_collection_add ((GeeAbstractCollection*) relinked_personas, persona);
					_folks_individual_aggregator_remove_persona_from_link_map (self, persona);
					_g_object_unref0 (persona);
				}
				_g_object_unref0 (_persona_it);
			}
			if (user == individual) {
				_g_object_unref0 (user);
				user = NULL;
			}
			_folks_individual_aggregator_disconnect_from_individual (self, individual);
			folks_individual_set_personas (individual, NULL);
			_g_object_unref0 (individual);
		}
		_g_object_unref0 (_individual_it);
	}
	g_debug ("individual-aggregator.vala:857: Relinking Personas:");
	{
		GeeIterator* _tmp30_ = NULL;
		GeeIterator* _persona_it;
		_tmp30_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) relinked_personas);
		_persona_it = _tmp30_;
		while (TRUE) {
			gboolean _tmp31_;
			gpointer _tmp32_ = NULL;
			FolksPersona* persona;
			const gchar* _tmp33_ = NULL;
			gboolean _tmp34_;
			const gchar* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			_tmp31_ = gee_iterator_next (_persona_it);
			if (!_tmp31_) {
				break;
			}
			_tmp32_ = gee_iterator_get (_persona_it);
			persona = (FolksPersona*) _tmp32_;
			_tmp34_ = folks_persona_get_is_user (persona);
			if (_tmp34_) {
				_tmp33_ = "yes";
			} else {
				_tmp33_ = "no";
			}
			_tmp35_ = folks_persona_get_uid (persona);
			_tmp36_ = folks_persona_get_iid (persona);
			g_debug ("individual-aggregator.vala:860:     %s (is user: %s, IID: %s)", _tmp35_, _tmp33_, _tmp36_);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_folks_individual_aggregator_add_personas (self, (GeeSet*) relinked_personas, &added_individuals, &replaced_individuals, &user);
	if (replaced_individuals != NULL) {
		GeeMapIterator* _tmp37_ = NULL;
		GeeMapIterator* iter;
		_tmp37_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) replaced_individuals);
		iter = _tmp37_;
		while (TRUE) {
			gboolean _tmp38_;
			gpointer _tmp39_ = NULL;
			FolksIndividual* _tmp40_;
			_tmp38_ = gee_map_iterator_next (iter);
			if (!(_tmp38_ == TRUE)) {
				break;
			}
			_tmp39_ = gee_map_iterator_get_key (iter);
			_tmp40_ = (FolksIndividual*) _tmp39_;
			gee_abstract_collection_add ((GeeAbstractCollection*) removed_individuals, _tmp40_);
			_g_object_unref0 (_tmp40_);
		}
		_g_object_unref0 (iter);
	}
	folks_individual_aggregator_set_user (self, user);
	_tmp42_ = gee_collection_get_size ((GeeCollection*) added_individuals);
	if (_tmp42_ > 0) {
		_tmp41_ = TRUE;
	} else {
		gint _tmp43_;
		_tmp43_ = gee_collection_get_size ((GeeCollection*) removed_individuals);
		_tmp41_ = _tmp43_ > 0;
	}
	if (_tmp41_) {
		_folks_individual_aggregator_emit_individuals_changed (self, (GeeSet*) added_individuals, (GeeSet*) removed_individuals, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	}
	g_debug ("individual-aggregator.vala:892: Replacing Individuals due to linking:");
	_tmp44_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) replaced_individuals);
	iter = _tmp44_;
	while (TRUE) {
		gboolean _tmp45_;
		gpointer _tmp46_ = NULL;
		FolksIndividual* _tmp47_;
		gpointer _tmp48_ = NULL;
		FolksIndividual* _tmp49_;
		_tmp45_ = gee_map_iterator_next (iter);
		if (!(_tmp45_ == TRUE)) {
			break;
		}
		_tmp46_ = gee_map_iterator_get_key (iter);
		_tmp47_ = (FolksIndividual*) _tmp46_;
		_tmp48_ = gee_map_iterator_get_value (iter);
		_tmp49_ = (FolksIndividual*) _tmp48_;
		folks_individual_replace (_tmp47_, _tmp49_);
		_g_object_unref0 (_tmp49_);
		_g_object_unref0 (_tmp47_);
	}
	_g_object_unref0 (iter);
	_g_object_unref0 (user);
	_g_object_unref0 (removed_personas);
	_g_object_unref0 (relinked_personas);
	_g_object_unref0 (replaced_individuals);
	_g_object_unref0 (removed_individuals);
	_g_object_unref0 (added_individuals);
}


static void _folks_individual_aggregator_is_writeable_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec) {
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* store;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = _g_object_ref0 (FOLKS_PERSONA_STORE (object));
	store = _tmp0_;
	_tmp3_ = folks_persona_store_get_is_writeable (store);
	if (_tmp3_ == TRUE) {
		_tmp2_ = store == self->priv->_writeable_store;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		_tmp5_ = folks_persona_store_get_is_writeable (store);
		if (_tmp5_ == FALSE) {
			_tmp4_ = store != self->priv->_writeable_store;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp1_ = _tmp4_;
	}
	g_assert (_tmp1_);
	_g_object_unref0 (store);
}


static void _folks_individual_aggregator_trust_level_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec) {
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* store;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = _g_object_ref0 (FOLKS_PERSONA_STORE (object));
	store = _tmp0_;
	if (self->priv->_writeable_store != NULL) {
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = folks_persona_store_get_type_id (store);
		_tmp3_ = folks_persona_store_get_type_id (self->priv->_writeable_store);
		_tmp1_ = g_strcmp0 (_tmp2_, _tmp3_) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		FolksPersonaStoreTrust _tmp4_;
		_tmp4_ = folks_persona_store_get_trust_level (store);
		g_assert (_tmp4_ == FOLKS_PERSONA_STORE_TRUST_FULL);
	} else {
		FolksPersonaStoreTrust _tmp5_;
		_tmp5_ = folks_persona_store_get_trust_level (store);
		g_assert (_tmp5_ != FOLKS_PERSONA_STORE_TRUST_FULL);
	}
	_g_object_unref0 (store);
}


static void _folks_individual_aggregator_individual_removed_cb (FolksIndividualAggregator* self, FolksIndividual* i, FolksIndividual* replacement) {
	const gchar* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	FolksIndividual* _tmp2_;
	gboolean _tmp3_;
	GeeHashSet* _tmp4_ = NULL;
	GeeHashSet* individuals;
	GeeSet* _tmp8_ = NULL;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	if (self->priv->_user == i) {
		folks_individual_aggregator_set_user (self, NULL);
	}
	_tmp0_ = folks_individual_get_id (i);
	_tmp1_ = gee_map_get (self->priv->_individuals, _tmp0_);
	_tmp2_ = (FolksIndividual*) _tmp1_;
	_tmp3_ = _tmp2_ != i;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		return;
	}
	_tmp4_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	individuals = _tmp4_;
	gee_abstract_collection_add ((GeeAbstractCollection*) individuals, i);
	if (replacement != NULL) {
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = folks_individual_get_id (i);
		_tmp6_ = folks_individual_get_id (replacement);
		g_debug ("individual-aggregator.vala:934: Individual '%s' removed (replaced by '" \
"%s')", _tmp5_, _tmp6_);
	} else {
		const gchar* _tmp7_ = NULL;
		_tmp7_ = folks_individual_get_id (i);
		g_debug ("individual-aggregator.vala:939: Individual '%s' removed (not replaced)", _tmp7_);
	}
	_tmp8_ = folks_individual_get_personas (i);
	_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
	if (_tmp9_ > 0) {
		_folks_individual_aggregator_emit_individuals_changed (self, NULL, (GeeSet*) individuals, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	}
	_folks_individual_aggregator_disconnect_from_individual (self, i);
	_g_object_unref0 (individuals);
}


static void folks_individual_aggregator_add_persona_from_details_data_free (gpointer _data) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* data;
	data = _data;
	_g_object_unref0 (data->parent);
	_g_object_unref0 (data->persona_store);
	_g_hash_table_unref0 (data->details);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorAddPersonaFromDetailsData, data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void folks_individual_aggregator_add_persona_from_details (FolksIndividualAggregator* self, FolksIndividual* parent, FolksPersonaStore* persona_store, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_add_persona_from_details_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->parent = _g_object_ref0 (parent);
	_data_->persona_store = _g_object_ref0 (persona_store);
	_data_->details = _g_hash_table_ref0 (details);
	folks_individual_aggregator_add_persona_from_details_co (_data_);
}


FolksPersona* folks_individual_aggregator_add_persona_from_details_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Add a new persona in the given {@link PersonaStore} based on the `details`
   * provided.
   *
   * If the target store is offline, this function will throw
   * {@link IndividualAggregatorError.STORE_OFFLINE}. It's the responsibility of
   * the caller to cache details and re-try this function if it wishes to make
   * offline adds work.
   *
   * The details hash is a backend-specific mapping of key, value strings.
   * Common keys include:
   *
   *  * contact - service-specific contact ID
   *  * message - a user-readable message to pass to the persona being added
   *
   * If a {@link Persona} with the given details already exists in the store, no
   * error will be thrown and this function will return `null`.
   *
   * @param parent an optional {@link Individual} to add the new {@link Persona}
   * to. This persona will be appended to its ordered list of personas.
   * @param persona_store the {@link PersonaStore} to add the persona to
   * @param details a key-value map of details to use in creating the new
   * {@link Persona}
   * @return the new {@link Persona} or `null` if the corresponding
   * {@link Persona} already existed. If non-`null`, the new {@link Persona}
   * will also be added to a new or existing {@link Individual} as necessary.
   *
   * @since 0.3.5
   */
static void folks_individual_aggregator_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_add_persona_from_details_co (data);
}


static gboolean folks_individual_aggregator_add_persona_from_details_co (FolksIndividualAggregatorAddPersonaFromDetailsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->persona = NULL;
	data->_tmp0_ = NULL;
	data->_tmp0_ = _folks_individual_aggregator_asv_copy (data->self, data->details);
	data->details_copy = data->_tmp0_;
	data->_state_ = 1;
	folks_persona_store_add_persona_from_details (data->persona_store, data->details_copy, folks_individual_aggregator_add_persona_from_details_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_persona_store_add_persona_from_details_finish (data->persona_store, data->_res_, &data->_inner_error_);
	data->_tmp2_ = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		_g_hash_table_unref0 (data->details_copy);
		if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			goto __catch12_folks_persona_store_error;
		}
		_g_hash_table_unref0 (data->details_copy);
		_g_object_unref0 (data->persona);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->persona);
	data->persona = data->_tmp2_;
	_g_hash_table_unref0 (data->details_copy);
	goto __finally12;
	__catch12_folks_persona_store_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		if (g_error_matches (data->e, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE)) {
			data->_tmp3_ = NULL;
			data->_tmp3_ = g_error_new_literal (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE, data->e->message);
			data->_inner_error_ = data->_tmp3_;
			_g_error_free0 (data->e);
			goto __finally12;
		} else {
			data->_tmp4_ = NULL;
			data->_tmp4_ = folks_persona_store_get_type_id (data->persona_store);
			data->_tmp5_ = NULL;
			data->_tmp5_ = folks_persona_store_get_id (data->persona_store);
			data->_tmp6_ = NULL;
			data->_tmp6_ = _folks_individual_aggregator_get_store_full_id (data->self, data->_tmp4_, data->_tmp5_);
			data->full_id = data->_tmp6_;
			data->_tmp7_ = NULL;
			data->_tmp7_ = _ ("Failed to add contact for persona store ID '%s': %s");
			data->_tmp8_ = NULL;
			data->_tmp8_ = g_error_new (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED, data->_tmp7_, data->full_id, data->e->message);
			data->_inner_error_ = data->_tmp8_;
			_g_free0 (data->full_id);
			_g_error_free0 (data->e);
			goto __finally12;
		}
		_g_error_free0 (data->e);
	}
	__finally12:
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->persona);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->parent != NULL) {
		data->_tmp9_ = data->persona != NULL;
	} else {
		data->_tmp9_ = FALSE;
	}
	if (data->_tmp9_) {
		data->_tmp10_ = NULL;
		data->_tmp10_ = folks_individual_get_personas (data->parent);
		gee_collection_add ((GeeCollection*) data->_tmp10_, data->persona);
	}
	data->result = data->persona;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->persona);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_g_hash_table_unref0 (_data4_->retval);
		g_slice_free (Block4Data, _data4_);
	}
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void _lambda6_ (const gchar* k, GValue* v, Block4Data* _data4_) {
	FolksIndividualAggregator * self;
	gchar* _tmp0_;
	GValue* _tmp1_;
	self = _data4_->self;
	g_return_if_fail (k != NULL);
	_tmp0_ = g_strdup ((const gchar*) k);
	_tmp1_ = __g_value_dup0 (v);
	g_hash_table_insert (_data4_->retval, _tmp0_, _tmp1_);
}


static void __lambda6__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda6_ (key, value, self);
}


static GHashTable* _folks_individual_aggregator_asv_copy (FolksIndividualAggregator* self, GHashTable* asv) {
	GHashTable* result = NULL;
	Block4Data* _data4_;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (asv != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	_data4_->retval = _tmp0_;
	g_hash_table_foreach (asv, __lambda6__gh_func, _data4_);
	_tmp1_ = _g_hash_table_ref0 (_data4_->retval);
	result = _tmp1_;
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return result;
}


static void folks_individual_aggregator_remove_individual_data_free (gpointer _data) {
	FolksIndividualAggregatorRemoveIndividualData* data;
	data = _data;
	_g_object_unref0 (data->individual);
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorRemoveIndividualData, data);
}


void folks_individual_aggregator_remove_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorRemoveIndividualData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_remove_individual);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_remove_individual_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->individual = _g_object_ref0 (individual);
	folks_individual_aggregator_remove_individual_co (_data_);
}


void folks_individual_aggregator_remove_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Completely remove the individual and all of its personas from their
   * backing stores.
   *
   * @param individual the {@link Individual} to remove
   * @since 0.1.11
   */
static void folks_individual_aggregator_remove_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorRemoveIndividualData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_remove_individual_co (data);
}


static gboolean folks_individual_aggregator_remove_individual_co (FolksIndividualAggregatorRemoveIndividualData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	data->personas = data->_tmp0_;
	{
		data->_tmp1_ = NULL;
		data->_tmp1_ = folks_individual_get_personas (data->individual);
		data->_tmp2_ = NULL;
		data->_tmp2_ = gee_iterable_iterator ((GeeIterable*) data->_tmp1_);
		data->_p_it = data->_tmp2_;
		while (TRUE) {
			data->_tmp3_ = gee_iterator_next (data->_p_it);
			if (!data->_tmp3_) {
				break;
			}
			data->_tmp4_ = NULL;
			data->_tmp4_ = gee_iterator_get (data->_p_it);
			data->p = (FolksPersona*) data->_tmp4_;
			gee_abstract_collection_add ((GeeAbstractCollection*) data->personas, data->p);
			_g_object_unref0 (data->p);
		}
		_g_object_unref0 (data->_p_it);
	}
	{
		data->_tmp5_ = NULL;
		data->_tmp5_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) data->personas);
		data->_persona_it = data->_tmp5_;
		while (TRUE) {
			data->_tmp6_ = gee_iterator_next (data->_persona_it);
			if (!data->_tmp6_) {
				break;
			}
			data->_tmp7_ = NULL;
			data->_tmp7_ = gee_iterator_get (data->_persona_it);
			data->persona = (FolksPersona*) data->_tmp7_;
			data->_tmp8_ = NULL;
			data->_tmp8_ = folks_persona_get_store (data->persona);
			data->_state_ = 1;
			folks_persona_store_remove_persona (data->_tmp8_, data->persona, folks_individual_aggregator_remove_individual_ready, data);
			return FALSE;
			_state_1:
			folks_persona_store_remove_persona_finish (data->_tmp8_, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->persona);
				_g_object_unref0 (data->_persona_it);
				_g_object_unref0 (data->personas);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->persona);
		}
		_g_object_unref0 (data->_persona_it);
	}
	_g_object_unref0 (data->personas);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_remove_persona_data_free (gpointer _data) {
	FolksIndividualAggregatorRemovePersonaData* data;
	data = _data;
	_g_object_unref0 (data->persona);
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorRemovePersonaData, data);
}


void folks_individual_aggregator_remove_persona (FolksIndividualAggregator* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorRemovePersonaData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_remove_persona_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->persona = _g_object_ref0 (persona);
	folks_individual_aggregator_remove_persona_co (_data_);
}


void folks_individual_aggregator_remove_persona_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorRemovePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Completely remove the persona from its backing store.
   *
   * This will leave other personas in the same individual alone.
   *
   * @param persona the {@link Persona} to remove
   * @since 0.1.11
   */
static void folks_individual_aggregator_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorRemovePersonaData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_remove_persona_co (data);
}


static gboolean folks_individual_aggregator_remove_persona_co (FolksIndividualAggregatorRemovePersonaData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_persona_get_store (data->persona);
	data->_state_ = 1;
	folks_persona_store_remove_persona (data->_tmp0_, data->persona, folks_individual_aggregator_remove_persona_ready, data);
	return FALSE;
	_state_1:
	folks_persona_store_remove_persona_finish (data->_tmp0_, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_link_personas_data_free (gpointer _data) {
	FolksIndividualAggregatorLinkPersonasData* data;
	data = _data;
	_g_object_unref0 (data->personas);
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorLinkPersonasData, data);
}


void folks_individual_aggregator_link_personas (FolksIndividualAggregator* self, GeeSet* personas, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorLinkPersonasData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorLinkPersonasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_link_personas);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_link_personas_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->personas = _g_object_ref0 (personas);
	folks_individual_aggregator_link_personas_co (_data_);
}


void folks_individual_aggregator_link_personas_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorLinkPersonasData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Link the given {@link Persona}s together.
   *
   * Create links between the given {@link Persona}s so that they form a single
   * {@link Individual}. The new {@link Individual} will be returned via the
   * {@link IndividualAggregator.individuals_changed} signal.
   *
   * Removal of the {@link Individual}s which the {@link Persona}s were in
   * before is signalled by {@link IndividualAggregator.individuals_changed} and
   * {@link Individual.removed}.
   *
   * @param personas the {@link Persona}s to be linked
   * @since 0.5.1
   */
static void folks_individual_aggregator_link_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorLinkPersonasData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_link_personas_co (data);
}


static gboolean folks_individual_aggregator_link_personas_co (FolksIndividualAggregatorLinkPersonasData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->self->priv->_writeable_store == NULL) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = _ ("Can't link personas with no writeable store.");
		data->_tmp1_ = NULL;
		data->_tmp1_ = g_error_new_literal (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_WRITEABLE_STORE, data->_tmp0_);
		data->_inner_error_ = data->_tmp1_;
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp2_ = gee_collection_get_size ((GeeCollection*) data->personas);
	if (data->_tmp2_ <= 1) {
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->self->priv->_linking_enabled == FALSE) {
		g_debug ("individual-aggregator.vala:1095: Can't link Personas: linking disabled" \
".");
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp3_ = NULL;
	data->_tmp3_ = folks_persona_store_get_type_id (data->self->priv->_writeable_store);
	g_assert (g_strcmp0 (data->_tmp3_, data->self->priv->_configured_writeable_store_type_id) == 0);
	data->_tmp4_ = NULL;
	data->_tmp4_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL);
	data->protocols_addrs_set = data->_tmp4_;
	data->_tmp5_ = NULL;
	data->_tmp5_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL);
	data->web_service_addrs_set = data->_tmp5_;
	data->_tmp6_ = NULL;
	data->_tmp6_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	data->local_ids = data->_tmp6_;
	{
		data->_tmp7_ = NULL;
		data->_tmp7_ = gee_iterable_iterator ((GeeIterable*) data->personas);
		data->_persona_it = data->_tmp7_;
		while (TRUE) {
			data->_tmp8_ = gee_iterator_next (data->_persona_it);
			if (!data->_tmp8_) {
				break;
			}
			data->_tmp9_ = NULL;
			data->_tmp9_ = gee_iterator_get (data->_persona_it);
			data->persona = (FolksPersona*) data->_tmp9_;
			if (FOLKS_IS_IM_DETAILS (data->persona)) {
				data->_tmp10_ = _g_object_ref0 (FOLKS_IM_DETAILS (data->persona));
				data->im_details = data->_tmp10_;
				{
					data->_tmp11_ = NULL;
					data->_tmp11_ = folks_im_details_get_im_addresses (data->im_details);
					data->_tmp12_ = NULL;
					data->_tmp12_ = gee_multi_map_get_keys (data->_tmp11_);
					data->_tmp13_ = data->_tmp12_;
					data->_tmp14_ = NULL;
					data->_tmp14_ = gee_iterable_iterator ((GeeIterable*) data->_tmp13_);
					data->_tmp15_ = data->_tmp14_;
					_g_object_unref0 (data->_tmp13_);
					data->_protocol_it = data->_tmp15_;
					while (TRUE) {
						data->_tmp16_ = gee_iterator_next (data->_protocol_it);
						if (!data->_tmp16_) {
							break;
						}
						data->_tmp17_ = NULL;
						data->_tmp17_ = gee_iterator_get (data->_protocol_it);
						data->protocol = (gchar*) data->_tmp17_;
						data->_tmp18_ = NULL;
						data->_tmp18_ = folks_im_details_get_im_addresses (data->im_details);
						data->_tmp19_ = NULL;
						data->_tmp19_ = gee_multi_map_get (data->_tmp18_, data->protocol);
						data->im_addresses = data->_tmp19_;
						{
							data->_tmp20_ = NULL;
							data->_tmp20_ = gee_iterable_iterator ((GeeIterable*) data->im_addresses);
							data->_im_address_it = data->_tmp20_;
							while (TRUE) {
								data->_tmp21_ = gee_iterator_next (data->_im_address_it);
								if (!data->_tmp21_) {
									break;
								}
								data->_tmp22_ = NULL;
								data->_tmp22_ = gee_iterator_get (data->_im_address_it);
								data->im_address = (gchar*) data->_tmp22_;
								gee_multi_map_set ((GeeMultiMap*) data->protocols_addrs_set, data->protocol, data->im_address);
								_g_free0 (data->im_address);
							}
							_g_object_unref0 (data->_im_address_it);
						}
						_g_object_unref0 (data->im_addresses);
						_g_free0 (data->protocol);
					}
					_g_object_unref0 (data->_protocol_it);
				}
				_g_object_unref0 (data->im_details);
			}
			if (FOLKS_IS_WEB_SERVICE_DETAILS (data->persona)) {
				data->_tmp23_ = _g_object_ref0 (FOLKS_WEB_SERVICE_DETAILS (data->persona));
				data->ws_details = data->_tmp23_;
				{
					data->_tmp24_ = NULL;
					data->_tmp24_ = folks_web_service_details_get_web_service_addresses (data->ws_details);
					data->_tmp25_ = NULL;
					data->_tmp25_ = gee_multi_map_get_keys (data->_tmp24_);
					data->_tmp26_ = data->_tmp25_;
					data->_tmp27_ = NULL;
					data->_tmp27_ = gee_iterable_iterator ((GeeIterable*) data->_tmp26_);
					data->_tmp28_ = data->_tmp27_;
					_g_object_unref0 (data->_tmp26_);
					data->_web_service_it = data->_tmp28_;
					while (TRUE) {
						data->_tmp29_ = gee_iterator_next (data->_web_service_it);
						if (!data->_tmp29_) {
							break;
						}
						data->_tmp30_ = NULL;
						data->_tmp30_ = gee_iterator_get (data->_web_service_it);
						data->web_service = (gchar*) data->_tmp30_;
						data->_tmp31_ = NULL;
						data->_tmp31_ = folks_web_service_details_get_web_service_addresses (data->ws_details);
						data->_tmp32_ = NULL;
						data->_tmp32_ = gee_multi_map_get (data->_tmp31_, data->web_service);
						data->ws_addresses = data->_tmp32_;
						{
							data->_tmp33_ = NULL;
							data->_tmp33_ = gee_iterable_iterator ((GeeIterable*) data->ws_addresses);
							data->_ws_address_it = data->_tmp33_;
							while (TRUE) {
								data->_tmp34_ = gee_iterator_next (data->_ws_address_it);
								if (!data->_tmp34_) {
									break;
								}
								data->_tmp35_ = NULL;
								data->_tmp35_ = gee_iterator_get (data->_ws_address_it);
								data->ws_address = (gchar*) data->_tmp35_;
								gee_multi_map_set ((GeeMultiMap*) data->web_service_addrs_set, data->web_service, data->ws_address);
								_g_free0 (data->ws_address);
							}
							_g_object_unref0 (data->_ws_address_it);
						}
						_g_object_unref0 (data->ws_addresses);
						_g_free0 (data->web_service);
					}
					_g_object_unref0 (data->_web_service_it);
				}
				_g_object_unref0 (data->ws_details);
			}
			if (FOLKS_IS_LOCAL_ID_DETAILS (data->persona)) {
				{
					data->_tmp36_ = NULL;
					data->_tmp36_ = folks_local_id_details_get_local_ids (FOLKS_LOCAL_ID_DETAILS (data->persona));
					data->_tmp37_ = NULL;
					data->_tmp37_ = gee_iterable_iterator ((GeeIterable*) data->_tmp36_);
					data->_id_it = data->_tmp37_;
					while (TRUE) {
						data->_tmp38_ = gee_iterator_next (data->_id_it);
						if (!data->_tmp38_) {
							break;
						}
						data->_tmp39_ = NULL;
						data->_tmp39_ = gee_iterator_get (data->_id_it);
						data->id = (gchar*) data->_tmp39_;
						gee_abstract_collection_add ((GeeAbstractCollection*) data->local_ids, data->id);
						_g_free0 (data->id);
					}
					_g_object_unref0 (data->_id_it);
				}
			}
			_g_object_unref0 (data->persona);
		}
		_g_object_unref0 (data->_persona_it);
	}
	data->_tmp40_ = NULL;
	data->_tmp40_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	data->details = data->_tmp40_;
	data->_tmp41_ = gee_multi_map_get_size ((GeeMultiMap*) data->protocols_addrs_set);
	if (data->_tmp41_ > 0) {
		g_value_init (&data->im_addresses_value, GEE_TYPE_MULTI_MAP);
		g_value_set_object (&data->im_addresses_value, (GObject*) data->protocols_addrs_set);
		data->_tmp42_ = NULL;
		data->_tmp42_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_IM_ADDRESSES);
		data->_tmp43_ = g_strdup (data->_tmp42_);
		data->_tmp44_ = __g_value_dup0 (&data->im_addresses_value);
		g_hash_table_insert (data->details, data->_tmp43_, data->_tmp44_);
		G_IS_VALUE (&data->im_addresses_value) ? (g_value_unset (&data->im_addresses_value), NULL) : NULL;
	}
	data->_tmp45_ = gee_multi_map_get_size ((GeeMultiMap*) data->web_service_addrs_set);
	if (data->_tmp45_ > 0) {
		g_value_init (&data->web_service_addresses_value, GEE_TYPE_MULTI_MAP);
		g_value_set_object (&data->web_service_addresses_value, (GObject*) data->web_service_addrs_set);
		data->_tmp46_ = NULL;
		data->_tmp46_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES);
		data->_tmp47_ = g_strdup (data->_tmp46_);
		data->_tmp48_ = __g_value_dup0 (&data->web_service_addresses_value);
		g_hash_table_insert (data->details, data->_tmp47_, data->_tmp48_);
		G_IS_VALUE (&data->web_service_addresses_value) ? (g_value_unset (&data->web_service_addresses_value), NULL) : NULL;
	}
	data->_tmp49_ = gee_collection_get_size ((GeeCollection*) data->local_ids);
	if (data->_tmp49_ > 0) {
		g_value_init (&data->local_ids_value, GEE_TYPE_SET);
		g_value_set_object (&data->local_ids_value, (GObject*) data->local_ids);
		data->_tmp50_ = NULL;
		data->_tmp50_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_LOCAL_IDS);
		data->_tmp51_ = g_strdup (data->_tmp50_);
		data->_tmp52_ = __g_value_dup0 (&data->local_ids_value);
		g_hash_table_insert (data->details, data->_tmp51_, data->_tmp52_);
		G_IS_VALUE (&data->local_ids_value) ? (g_value_unset (&data->local_ids_value), NULL) : NULL;
	}
	data->_state_ = 1;
	folks_individual_aggregator_add_persona_from_details (data->self, NULL, data->self->priv->_writeable_store, data->details, folks_individual_aggregator_link_personas_ready, data);
	return FALSE;
	_state_1:
	data->_tmp53_ = NULL;
	data->_tmp53_ = folks_individual_aggregator_add_persona_from_details_finish (data->self, data->_res_, &data->_inner_error_);
	data->_tmp54_ = data->_tmp53_;
	_g_object_unref0 (data->_tmp54_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_hash_table_unref0 (data->details);
			_g_object_unref0 (data->local_ids);
			_g_object_unref0 (data->web_service_addrs_set);
			_g_object_unref0 (data->protocols_addrs_set);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_hash_table_unref0 (data->details);
			_g_object_unref0 (data->local_ids);
			_g_object_unref0 (data->web_service_addrs_set);
			_g_object_unref0 (data->protocols_addrs_set);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	_g_hash_table_unref0 (data->details);
	_g_object_unref0 (data->local_ids);
	_g_object_unref0 (data->web_service_addrs_set);
	_g_object_unref0 (data->protocols_addrs_set);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_unlink_individual_data_free (gpointer _data) {
	FolksIndividualAggregatorUnlinkIndividualData* data;
	data = _data;
	_g_object_unref0 (data->individual);
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorUnlinkIndividualData, data);
}


void folks_individual_aggregator_unlink_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorUnlinkIndividualData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_unlink_individual);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_unlink_individual_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->individual = _g_object_ref0 (individual);
	folks_individual_aggregator_unlink_individual_co (_data_);
}


void folks_individual_aggregator_unlink_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Unlinks the given {@link Individual} into its constituent {@link Persona}s.
   *
   * This completely unlinks the given {@link Individual}, destroying all of
   * its writeable {@link Persona}s.
   *
   * The {@link Individual}'s removal is signalled by
   * {@link IndividualAggregator.individuals_changed} and
   * {@link Individual.removed}.
   *
   * The {@link Persona}s comprising the {@link Individual} will be re-linked
   * into one or more new {@link Individual}s, depending on how much linking
   * data remains (typically only implicit links remain). The addition of these
   * new {@link Individual}s will be signalled by
   * {@link IndividualAggregator.individuals_changed}.
   *
   * @param individual the {@link Individual} to unlink
   * @since 0.1.13
   */
static void folks_individual_aggregator_unlink_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorUnlinkIndividualData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_unlink_individual_co (data);
}


static gboolean folks_individual_aggregator_unlink_individual_co (FolksIndividualAggregatorUnlinkIndividualData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->self->priv->_linking_enabled == FALSE) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = folks_individual_get_id (data->individual);
		g_debug ("individual-aggregator.vala:1211: Can't unlink Individual '%s': linking" \
" disabled.", data->_tmp0_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_individual_get_id (data->individual);
	g_debug ("individual-aggregator.vala:1216: Unlinking Individual '%s', deleting P" \
"ersonas:", data->_tmp1_);
	data->_tmp2_ = NULL;
	data->_tmp2_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	data->personas = data->_tmp2_;
	{
		data->_tmp3_ = NULL;
		data->_tmp3_ = folks_individual_get_personas (data->individual);
		data->_tmp4_ = NULL;
		data->_tmp4_ = gee_iterable_iterator ((GeeIterable*) data->_tmp3_);
		data->_p_it = data->_tmp4_;
		while (TRUE) {
			data->_tmp5_ = gee_iterator_next (data->_p_it);
			if (!data->_tmp5_) {
				break;
			}
			data->_tmp6_ = NULL;
			data->_tmp6_ = gee_iterator_get (data->_p_it);
			data->p = (FolksPersona*) data->_tmp6_;
			gee_abstract_collection_add ((GeeAbstractCollection*) data->personas, data->p);
			_g_object_unref0 (data->p);
		}
		_g_object_unref0 (data->_p_it);
	}
	{
		data->_tmp7_ = NULL;
		data->_tmp7_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) data->personas);
		data->_persona_it = data->_tmp7_;
		while (TRUE) {
			data->_tmp8_ = gee_iterator_next (data->_persona_it);
			if (!data->_tmp8_) {
				break;
			}
			data->_tmp9_ = NULL;
			data->_tmp9_ = gee_iterator_get (data->_persona_it);
			data->persona = (FolksPersona*) data->_tmp9_;
			data->_tmp10_ = NULL;
			data->_tmp10_ = folks_persona_get_store (data->persona);
			if (data->_tmp10_ == data->self->priv->_writeable_store) {
				data->_tmp12_ = folks_persona_get_is_user (data->persona);
				if (data->_tmp12_) {
					data->_tmp11_ = "yes";
				} else {
					data->_tmp11_ = "no";
				}
				data->_tmp13_ = NULL;
				data->_tmp13_ = folks_persona_get_uid (data->persona);
				data->_tmp14_ = NULL;
				data->_tmp14_ = folks_persona_get_iid (data->persona);
				g_debug ("individual-aggregator.vala:1234:     %s (is user: %s, IID: %s)", data->_tmp13_, data->_tmp11_, data->_tmp14_);
				data->_state_ = 1;
				folks_persona_store_remove_persona (data->self->priv->_writeable_store, data->persona, folks_individual_aggregator_unlink_individual_ready, data);
				return FALSE;
				_state_1:
				folks_persona_store_remove_persona_finish (data->self->priv->_writeable_store, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->persona);
					_g_object_unref0 (data->_persona_it);
					_g_object_unref0 (data->personas);
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			_g_object_unref0 (data->persona);
		}
		_g_object_unref0 (data->_persona_it);
	}
	_g_object_unref0 (data->personas);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


gboolean folks_individual_aggregator_get_is_prepared (FolksIndividualAggregator* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_prepared;
	return result;
}


FolksPersonaStore* folks_individual_aggregator_get_primary_store (FolksIndividualAggregator* self) {
	FolksPersonaStore* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_writeable_store;
	return result;
}


GeeMap* folks_individual_aggregator_get_individuals (FolksIndividualAggregator* self) {
	GeeMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_individuals_ro;
	return result;
}


static void folks_individual_aggregator_set_individuals (FolksIndividualAggregator* self, GeeMap* value) {
	GeeMap* _tmp0_;
	GeeMap* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_individuals);
	self->priv->_individuals = _tmp0_;
	_tmp1_ = gee_map_get_read_only_view (self->priv->_individuals);
	_g_object_unref0 (self->priv->_individuals_ro);
	self->priv->_individuals_ro = _tmp1_;
	g_object_notify ((GObject *) self, "individuals");
}


FolksIndividual* folks_individual_aggregator_get_user (FolksIndividualAggregator* self) {
	FolksIndividual* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_user;
	return result;
}


static void folks_individual_aggregator_set_user (FolksIndividualAggregator* self, FolksIndividual* value) {
	FolksIndividual* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_user);
	self->priv->_user = _tmp0_;
	g_object_notify ((GObject *) self, "user");
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM) (gpointer data1, gpointer arg_1, gpointer arg_2, const char* arg_3, gpointer arg_4, gint arg_5, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_string (param_values + 3), g_value_get_object (param_values + 4), g_value_get_enum (param_values + 5), data2);
}


static void folks_individual_aggregator_class_init (FolksIndividualAggregatorClass * klass) {
	folks_individual_aggregator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksIndividualAggregatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_individual_aggregator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_individual_aggregator_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_individual_aggregator_finalize;
	/**
	   * Whether {@link IndividualAggregator.prepare} has successfully completed for
	   * this aggregator.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Our configured primary (writeable) store.
	   *
	   * Which one to use is decided (in order or precedence)
	   * by:
	   *
	   * - the FOLKS_WRITEABLE_STORE env var (mostly for debugging)
	   * - the GConf key set in _FOLKS_CONFIG_KEY (system set store)
	   * - going with the `key-file` store as the fall-back option
	   *
	   * @since 0.5.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_PRIMARY_STORE, g_param_spec_object ("primary-store", "primary-store", "primary-store", FOLKS_TYPE_PERSONA_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * A map from {@link Individual.id}s to their {@link Individual}s.
	   *
	   * This is the canonical set of {@link Individual}s provided by this
	   * IndividualAggregator.
	   *
	   * {@link Individual}s may be added or removed using
	   * {@link IndividualAggregator.add_persona_from_details} and
	   * {@link IndividualAggregator.remove_individual}, respectively.
	   *
	   * @since 0.5.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS, g_param_spec_object ("individuals", "individuals", "individuals", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The {@link Individual} representing the user.
	   *
	   * If it exists, this holds the {@link Individual} who is the user: the
	   * {@link Individual} containing the {@link Persona}s who are the owners of
	   * the accounts for their respective backends.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_USER, g_param_spec_object ("user", "user", "user", FOLKS_TYPE_INDIVIDUAL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Emitted when one or more {@link Individual}s are added to or removed from
	   * the aggregator.
	   *
	   * This will not be emitted until after {@link IndividualAggregator.prepare}
	   * has been called.
	   *
	   * @param added a list of {@link Individual}s which have been removed
	   * @param removed a list of {@link Individual}s which have been removed
	   * @param message a string message from the backend, if any
	   * @param actor the {@link Persona} who made the change, if known
	   * @param reason the reason for the change
	   *
	   * @since 0.5.1
	   */
	g_signal_new ("individuals_changed", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM, G_TYPE_NONE, 5, GEE_TYPE_SET, GEE_TYPE_SET, G_TYPE_STRING, FOLKS_TYPE_PERSONA, FOLKS_GROUP_DETAILS_TYPE_CHANGE_REASON);
}


static void folks_individual_aggregator_instance_init (FolksIndividualAggregator * self) {
	self->priv = FOLKS_INDIVIDUAL_AGGREGATOR_GET_PRIVATE (self);
	self->priv->_linking_enabled = TRUE;
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
}


static void folks_individual_aggregator_finalize (GObject* obj) {
	FolksIndividualAggregator * self;
	guint _tmp0_;
	guint _tmp1_;
	self = FOLKS_INDIVIDUAL_AGGREGATOR (obj);
	g_signal_parse_name ("backend-available", FOLKS_TYPE_BACKEND_STORE, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (self->priv->_backend_store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available, self);
	_g_object_unref0 (self->priv->_backend_store);
	self->priv->_backend_store = NULL;
	g_signal_parse_name ("print-status", FOLKS_TYPE_DEBUG, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (self->priv->_debug, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __folks_individual_aggregator_debug_print_status_folks_debug_print_status, self);
	_g_object_unref0 (self->priv->_backend_store);
	_g_object_unref0 (self->priv->_stores);
	_g_object_unref0 (self->priv->_backends);
	_g_hash_table_unref0 (self->priv->_link_map);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	_g_object_unref0 (self->priv->_debug);
	_g_free0 (self->priv->_configured_writeable_store_type_id);
	_g_object_unref0 (self->priv->_individuals);
	_g_object_unref0 (self->priv->_individuals_ro);
	_g_object_unref0 (self->priv->_user);
	G_OBJECT_CLASS (folks_individual_aggregator_parent_class)->finalize (obj);
}


/**
 * Stores {@link Individual}s which have been created through
 * aggregation of all the {@link Persona}s provided by the various
 * {@link Backend}s.
 *
 * This is the main interface for client applications.
 */
GType folks_individual_aggregator_get_type (void) {
	static volatile gsize folks_individual_aggregator_type_id__volatile = 0;
	if (g_once_init_enter (&folks_individual_aggregator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksIndividualAggregatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_individual_aggregator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksIndividualAggregator), 0, (GInstanceInitFunc) folks_individual_aggregator_instance_init, NULL };
		GType folks_individual_aggregator_type_id;
		folks_individual_aggregator_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksIndividualAggregator", &g_define_type_info, 0);
		g_once_init_leave (&folks_individual_aggregator_type_id__volatile, folks_individual_aggregator_type_id);
	}
	return folks_individual_aggregator_type_id__volatile;
}


static void _vala_folks_individual_aggregator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksIndividualAggregator * self;
	self = FOLKS_INDIVIDUAL_AGGREGATOR (object);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED:
		g_value_set_boolean (value, folks_individual_aggregator_get_is_prepared (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_PRIMARY_STORE:
		g_value_set_object (value, folks_individual_aggregator_get_primary_store (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS:
		g_value_set_object (value, folks_individual_aggregator_get_individuals (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_USER:
		g_value_set_object (value, folks_individual_aggregator_get_user (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_individual_aggregator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksIndividualAggregator * self;
	self = FOLKS_INDIVIDUAL_AGGREGATOR (object);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS:
		folks_individual_aggregator_set_individuals (self, g_value_get_object (value));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_USER:
		folks_individual_aggregator_set_user (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



