/* avatar-updates.c generated by valac 0.12.0, the Vala compiler
 * generated from avatar-updates.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <tracker-test.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <folks/folks-tracker.h>
#include <gio/gio.h>


#define TYPE_AVATAR_UPDATES_TESTS (avatar_updates_tests_get_type ())
#define AVATAR_UPDATES_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_UPDATES_TESTS, AvatarUpdatesTests))
#define AVATAR_UPDATES_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_UPDATES_TESTS, AvatarUpdatesTestsClass))
#define IS_AVATAR_UPDATES_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_UPDATES_TESTS))
#define IS_AVATAR_UPDATES_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_UPDATES_TESTS))
#define AVATAR_UPDATES_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_UPDATES_TESTS, AvatarUpdatesTestsClass))

typedef struct _AvatarUpdatesTests AvatarUpdatesTests;
typedef struct _AvatarUpdatesTestsClass AvatarUpdatesTestsClass;
typedef struct _AvatarUpdatesTestsPrivate AvatarUpdatesTestsPrivate;
#define _tracker_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (tracker_test_backend_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AvatarUpdatesTestsTestAvatarUpdatesAsyncData AvatarUpdatesTestsTestAvatarUpdatesAsyncData;

struct _AvatarUpdatesTests {
	FolksTestCase parent_instance;
	AvatarUpdatesTestsPrivate * priv;
};

struct _AvatarUpdatesTestsClass {
	FolksTestCaseClass parent_class;
};

struct _AvatarUpdatesTestsPrivate {
	TrackerTestBackend* _tracker_backend;
	FolksIndividualAggregator* _aggregator;
	gboolean _updated_avatar_found;
	gchar* _updated_avatar;
	gchar* _individual_id;
	GMainLoop* _main_loop;
	gboolean _initial_avatar_found;
	gchar* _initial_fullname;
	gchar* _initial_avatar;
	gchar* _contact_urn;
	gchar* _photo_urn;
};

struct _AvatarUpdatesTestsTestAvatarUpdatesAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AvatarUpdatesTests* self;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* store;
	FolksIndividualAggregator* _tmp1_;
	GError * e;
	GError * _inner_error_;
};


static gpointer avatar_updates_tests_parent_class = NULL;

GType avatar_updates_tests_get_type (void) G_GNUC_CONST;
#define AVATAR_UPDATES_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AVATAR_UPDATES_TESTS, AvatarUpdatesTestsPrivate))
enum  {
	AVATAR_UPDATES_TESTS_DUMMY_PROPERTY
};
AvatarUpdatesTests* avatar_updates_tests_new (void);
AvatarUpdatesTests* avatar_updates_tests_construct (GType object_type);
void avatar_updates_tests_test_avatar_updates (AvatarUpdatesTests* self);
static void _avatar_updates_tests_test_avatar_updates_folks_test_case_test_method (gpointer self);
static void avatar_updates_tests_real_set_up (FolksTestCase* base);
static void avatar_updates_tests_real_tear_down (FolksTestCase* base);
static void avatar_updates_tests_test_avatar_updates_async (AvatarUpdatesTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void avatar_updates_tests_test_avatar_updates_finish (AvatarUpdatesTests* self, GAsyncResult* _res_);
static gboolean _lambda0_ (AvatarUpdatesTests* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void avatar_updates_tests_test_avatar_updates_async_data_free (gpointer _data);
static gboolean avatar_updates_tests_test_avatar_updates_async_co (AvatarUpdatesTestsTestAvatarUpdatesAsyncData* data);
static void avatar_updates_tests_test_avatar_updates_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _avatar_updates_tests_individuals_changed_cb (AvatarUpdatesTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __avatar_updates_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _avatar_updates_tests_notify_avatar_cb (AvatarUpdatesTests* self);
static void __avatar_updates_tests_notify_avatar_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void avatar_updates_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _avatar_updates_tests_test_avatar_updates_folks_test_case_test_method (gpointer self) {
	avatar_updates_tests_test_avatar_updates (self);
}


AvatarUpdatesTests* avatar_updates_tests_construct (GType object_type) {
	AvatarUpdatesTests * self = NULL;
	TrackerTestBackend* _tmp0_ = NULL;
	self = (AvatarUpdatesTests*) folks_test_case_construct (object_type, "AvatarUpdates");
	_tmp0_ = tracker_test_backend_new ();
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	self->priv->_tracker_backend = _tmp0_;
	tracker_test_backend_set_debug (self->priv->_tracker_backend, FALSE);
	folks_test_case_add_test ((FolksTestCase*) self, "avatar updates", _avatar_updates_tests_test_avatar_updates_folks_test_case_test_method, self);
	return self;
}


AvatarUpdatesTests* avatar_updates_tests_new (void) {
	return avatar_updates_tests_construct (TYPE_AVATAR_UPDATES_TESTS);
}


static void avatar_updates_tests_real_set_up (FolksTestCase* base) {
	AvatarUpdatesTests * self;
	self = (AvatarUpdatesTests*) base;
}


static void avatar_updates_tests_real_tear_down (FolksTestCase* base) {
	AvatarUpdatesTests * self;
	self = (AvatarUpdatesTests*) base;
}


static gboolean _lambda0_ (AvatarUpdatesTests* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->_main_loop);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


void avatar_updates_tests_test_avatar_updates (AvatarUpdatesTests* self) {
	GMainLoop* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* c1;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	c1 = _tmp1_;
	_tmp2_ = g_strdup ("persona #1");
	_g_free0 (self->priv->_initial_fullname);
	self->priv->_initial_fullname = _tmp2_;
	_tmp3_ = g_strdup ("file:///tmp/avatar-01");
	_g_free0 (self->priv->_initial_avatar);
	self->priv->_initial_avatar = _tmp3_;
	_tmp4_ = g_strdup ("<urn:contact001>");
	_g_free0 (self->priv->_contact_urn);
	self->priv->_contact_urn = _tmp4_;
	_tmp5_ = g_strconcat ("<", self->priv->_initial_avatar, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, ">", NULL);
	_g_free0 (self->priv->_photo_urn);
	self->priv->_photo_urn = _tmp7_;
	_g_free0 (_tmp6_);
	_tmp8_ = g_strdup ("file:///tmp/avatar-02");
	_g_free0 (self->priv->_updated_avatar);
	self->priv->_updated_avatar = _tmp8_;
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRACKER_TEST_BACKEND_URN, self->priv->_contact_urn);
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRF_ONTOLOGY_DEFS_NCO_FULLNAME, self->priv->_initial_fullname);
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRF_ONTOLOGY_DEFS_NCO_PHOTO, self->priv->_initial_avatar);
	tracker_test_backend_add_contact (self->priv->_tracker_backend, c1);
	tracker_test_backend_set_up (self->priv->_tracker_backend);
	self->priv->_initial_avatar_found = FALSE;
	self->priv->_updated_avatar_found = FALSE;
	_tmp9_ = g_strdup ("");
	_g_free0 (self->priv->_individual_id);
	self->priv->_individual_id = _tmp9_;
	avatar_updates_tests_test_avatar_updates_async (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->_main_loop);
	g_assert (self->priv->_initial_avatar_found == TRUE);
	g_assert (self->priv->_updated_avatar_found == TRUE);
	tracker_test_backend_tear_down (self->priv->_tracker_backend);
	_g_object_unref0 (c1);
}


static void avatar_updates_tests_test_avatar_updates_async_data_free (gpointer _data) {
	AvatarUpdatesTestsTestAvatarUpdatesAsyncData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (AvatarUpdatesTestsTestAvatarUpdatesAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void avatar_updates_tests_test_avatar_updates_async (AvatarUpdatesTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AvatarUpdatesTestsTestAvatarUpdatesAsyncData* _data_;
	_data_ = g_slice_new0 (AvatarUpdatesTestsTestAvatarUpdatesAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, avatar_updates_tests_test_avatar_updates_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, avatar_updates_tests_test_avatar_updates_async_data_free);
	_data_->self = _g_object_ref0 (self);
	avatar_updates_tests_test_avatar_updates_async_co (_data_);
}


static void avatar_updates_tests_test_avatar_updates_finish (AvatarUpdatesTests* self, GAsyncResult* _res_) {
	AvatarUpdatesTestsTestAvatarUpdatesAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void avatar_updates_tests_test_avatar_updates_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AvatarUpdatesTestsTestAvatarUpdatesAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	avatar_updates_tests_test_avatar_updates_async_co (data);
}


static void __avatar_updates_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_avatar_updates_tests_individuals_changed_cb (self, added, removed, message, actor, reason);
}


static gboolean avatar_updates_tests_test_avatar_updates_async_co (AvatarUpdatesTestsTestAvatarUpdatesAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_store_dup ();
	data->store = data->_tmp0_;
	data->_state_ = 1;
	folks_backend_store_prepare (data->store, avatar_updates_tests_test_avatar_updates_async_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (data->store, data->_res_);
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_individual_aggregator_new ();
	_g_object_unref0 (data->self->priv->_aggregator);
	data->self->priv->_aggregator = data->_tmp1_;
	g_signal_connect_object (data->self->priv->_aggregator, "individuals-changed", (GCallback) __avatar_updates_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed, data->self, 0);
	data->_state_ = 2;
	folks_individual_aggregator_prepare (data->self->priv->_aggregator, avatar_updates_tests_test_avatar_updates_async_ready, data);
	return FALSE;
	_state_2:
	folks_individual_aggregator_prepare_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("avatar-updates.vala:108: Error when calling prepare: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally0:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->store);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void __avatar_updates_tests_notify_avatar_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_avatar_updates_tests_notify_avatar_cb (self);
}


static void _avatar_updates_tests_individuals_changed_cb (AvatarUpdatesTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) added);
		_i_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksIndividual* i;
			const gchar* _tmp3_ = NULL;
			gint _tmp13_;
			_tmp1_ = gee_iterator_next (_i_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_i_it);
			i = (FolksIndividual*) _tmp2_;
			_tmp3_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
			if (g_strcmp0 (_tmp3_, self->priv->_initial_fullname) == 0) {
				const gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				gboolean _tmp6_ = FALSE;
				GFile* _tmp7_ = NULL;
				g_signal_connect_object ((GObject*) i, "notify::avatar", (GCallback) __avatar_updates_tests_notify_avatar_cb_g_object_notify, self, 0);
				_tmp4_ = folks_individual_get_id (i);
				_tmp5_ = g_strdup (_tmp4_);
				_g_free0 (self->priv->_individual_id);
				self->priv->_individual_id = _tmp5_;
				_tmp7_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) i);
				if (_tmp7_ != NULL) {
					GFile* _tmp8_ = NULL;
					gchar* _tmp9_ = NULL;
					gchar* _tmp10_;
					_tmp8_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) i);
					_tmp9_ = g_file_get_uri (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp6_ = g_strcmp0 (_tmp10_, self->priv->_initial_avatar) == 0;
					_g_free0 (_tmp10_);
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					gchar* _tmp11_;
					gchar* photo_urn_2;
					gchar* _tmp12_;
					self->priv->_initial_avatar_found = TRUE;
					tracker_test_backend_remove_triplet (self->priv->_tracker_backend, self->priv->_contact_urn, TRF_ONTOLOGY_DEFS_NCO_PHOTO, self->priv->_photo_urn);
					_tmp11_ = g_strconcat ("<", self->priv->_updated_avatar, NULL);
					photo_urn_2 = _tmp11_;
					_tmp12_ = g_strconcat (photo_urn_2, ">", NULL);
					_g_free0 (photo_urn_2);
					photo_urn_2 = _tmp12_;
					tracker_test_backend_insert_triplet (self->priv->_tracker_backend, photo_urn_2, "a", "nfo:Image, nie:DataObject", TRF_ONTOLOGY_DEFS_NIE_URL, self->priv->_updated_avatar, NULL, NULL);
					tracker_test_backend_insert_triplet (self->priv->_tracker_backend, self->priv->_contact_urn, TRF_ONTOLOGY_DEFS_NCO_PHOTO, photo_urn_2, NULL, NULL, NULL, NULL);
					_g_free0 (photo_urn_2);
				}
			}
			_tmp13_ = gee_collection_get_size ((GeeCollection*) removed);
			g_assert (_tmp13_ == 0);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
}


static void _avatar_updates_tests_notify_avatar_cb (AvatarUpdatesTests* self) {
	GeeMap* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	FolksIndividual* i;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_individual_aggregator_get_individuals (self->priv->_aggregator);
	_tmp1_ = gee_map_get (_tmp0_, self->priv->_individual_id);
	i = (FolksIndividual*) _tmp1_;
	if (i == NULL) {
		_g_object_unref0 (i);
		return;
	}
	_tmp3_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) i);
	if (_tmp3_ != NULL) {
		GFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp4_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) i);
		_tmp5_ = g_file_get_uri (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = g_strcmp0 (_tmp6_, self->priv->_updated_avatar) == 0;
		_g_free0 (_tmp6_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		g_main_loop_quit (self->priv->_main_loop);
		self->priv->_updated_avatar_found = TRUE;
	}
	_g_object_unref0 (i);
}


static void avatar_updates_tests_class_init (AvatarUpdatesTestsClass * klass) {
	avatar_updates_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AvatarUpdatesTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = avatar_updates_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = avatar_updates_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = avatar_updates_tests_finalize;
}


static void avatar_updates_tests_instance_init (AvatarUpdatesTests * self) {
	self->priv = AVATAR_UPDATES_TESTS_GET_PRIVATE (self);
}


static void avatar_updates_tests_finalize (GObject* obj) {
	AvatarUpdatesTests * self;
	self = AVATAR_UPDATES_TESTS (obj);
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	_g_object_unref0 (self->priv->_aggregator);
	_g_free0 (self->priv->_updated_avatar);
	_g_free0 (self->priv->_individual_id);
	_g_main_loop_unref0 (self->priv->_main_loop);
	_g_free0 (self->priv->_initial_fullname);
	_g_free0 (self->priv->_initial_avatar);
	_g_free0 (self->priv->_contact_urn);
	_g_free0 (self->priv->_photo_urn);
	G_OBJECT_CLASS (avatar_updates_tests_parent_class)->finalize (obj);
}


GType avatar_updates_tests_get_type (void) {
	static volatile gsize avatar_updates_tests_type_id__volatile = 0;
	if (g_once_init_enter (&avatar_updates_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AvatarUpdatesTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avatar_updates_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AvatarUpdatesTests), 0, (GInstanceInitFunc) avatar_updates_tests_instance_init, NULL };
		GType avatar_updates_tests_type_id;
		avatar_updates_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "AvatarUpdatesTests", &g_define_type_info, 0);
		g_once_init_leave (&avatar_updates_tests_type_id__volatile, avatar_updates_tests_type_id);
	}
	return avatar_updates_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	AvatarUpdatesTests* _tmp1_ = NULL;
	AvatarUpdatesTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = avatar_updates_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



